# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataCatalog
      module V1
        module PolicyTagManager
          # Path helper methods for the PolicyTagManager API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified PolicyTag resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/taxonomies/{taxonomy}/policyTags/{policy_tag}`
            #
            # @param project [String]
            # @param location [String]
            # @param taxonomy [String]
            # @param policy_tag [String]
            #
            # @return [::String]
            def policy_tag_path project:, location:, taxonomy:, policy_tag:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "taxonomy cannot contain /" if taxonomy.to_s.include? "/"

              "projects/#{project}/locations/#{location}/taxonomies/#{taxonomy}/policyTags/#{policy_tag}"
            end

            ##
            # Create a fully-qualified Taxonomy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/taxonomies/{taxonomy}`
            #
            # @param project [String]
            # @param location [String]
            # @param taxonomy [String]
            #
            # @return [::String]
            def taxonomy_path project:, location:, taxonomy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/taxonomies/#{taxonomy}"
            end

            extend self
          end
        end
      end
    end
  end
end
