# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/datacatalog/v1/datacatalog_pb"
require "google/cloud/data_catalog/v1/data_catalog/rest/service_stub"
require "google/iam/v1/rest"

module Google
  module Cloud
    module DataCatalog
      module V1
        module DataCatalog
          module Rest
            ##
            # REST client for the DataCatalog service.
            #
            # Deprecated: Please use Dataplex Catalog instead.
            #
            # Data Catalog API service allows you to discover, understand, and manage
            # your data.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "datacatalog.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :data_catalog_stub

              ##
              # Configure the DataCatalog Client class.
              #
              # See {::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client::Configuration}
              # for a description of the configuration fields.
              # @deprecated This service is deprecated and may be removed in the next major version update.
              #
              # @example
              #
              #   # Modify the configuration for all DataCatalog clients
              #   ::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "DataCatalog", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 8, 13]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DataCatalog Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @data_catalog_stub.universe_domain
              end

              ##
              # Create a new DataCatalog REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DataCatalog client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @data_catalog_stub = ::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @data_catalog_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @data_catalog_stub.endpoint
                  config.universe_domain = @data_catalog_stub.universe_domain
                  config.logger = @data_catalog_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @data_catalog_stub.logger
              end

              # Service calls

              ##
              # Searches Data Catalog for multiple resources like entries and tags that
              # match a query.
              #
              # This is a [Custom Method]
              # (https://cloud.google.com/apis/design/custom_methods) that doesn't return
              # all information on a resource, only its ID and high level fields. To get
              # more information, you can subsequently call specific get methods.
              #
              # Note: Data Catalog search queries don't guarantee full recall. Results
              # that match your query might not be returned, even in subsequent
              # result pages. Additionally, returned (and not returned) results can vary
              # if you repeat search queries.
              #
              # For more information, see [Data Catalog search syntax]
              # (https://cloud.google.com/data-catalog/docs/how-to/search-reference).
              #
              # @overload search_catalog(request, options = nil)
              #   Pass arguments to `search_catalog` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::SearchCatalogRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::SearchCatalogRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_catalog(scope: nil, query: nil, page_size: nil, page_token: nil, order_by: nil, admin_search: nil)
              #   Pass arguments to `search_catalog` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param scope [::Google::Cloud::DataCatalog::V1::SearchCatalogRequest::Scope, ::Hash]
              #     Required. The scope of this search request.
              #
              #     The `scope` is invalid if `include_org_ids`, `include_project_ids` are
              #     empty AND `include_gcp_public_datasets` is set to `false`. In this case,
              #     the request returns an error.
              #   @param query [::String]
              #     Optional. The query string with a minimum of 3 characters and specific
              #     syntax. For more information, see [Data Catalog search
              #     syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference).
              #
              #     An empty query string returns all data assets (in the specified scope)
              #     that you have access to.
              #
              #     A query string can be a simple `xyz` or qualified by predicates:
              #
              #     * `name:x`
              #     * `column:y`
              #     * `description:z`
              #   @param page_size [::Integer]
              #     Upper bound on the number of results you can get in a single response.
              #
              #     Can't be negative or 0, defaults to 10 in this case.
              #     The maximum number is 1000. If exceeded, throws an "invalid argument"
              #     exception.
              #   @param page_token [::String]
              #     Optional. Pagination token that, if specified, returns the next page of
              #     search results. If empty, returns the first page.
              #
              #     This token is returned in the
              #     {::Google::Cloud::DataCatalog::V1::SearchCatalogResponse#next_page_token SearchCatalogResponse.next_page_token}
              #     field of the response to a previous
              #     {::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client#search_catalog SearchCatalogRequest}
              #     call.
              #   @param order_by [::String]
              #     Specifies the order of results.
              #
              #     Currently supported case-sensitive values are:
              #
              #     * `relevance` that can only be descending
              #     * `last_modified_timestamp [asc|desc]` with descending (`desc`) as default
              #     * `default` that can only be descending
              #
              #     Search queries don't guarantee full recall. Results that match your query
              #     might not be returned, even in subsequent result pages. Additionally,
              #     returned (and not returned) results can vary if you repeat search queries.
              #     If you are experiencing recall issues and you don't have to fetch the
              #     results in any specific order, consider setting this parameter to
              #     `default`.
              #
              #     If this parameter is omitted, it defaults to the descending `relevance`.
              #   @param admin_search [::Boolean]
              #     Optional. If set, use searchAll permission granted on organizations from
              #     `include_org_ids` and projects from `include_project_ids` instead of the
              #     fine grained per resource permissions when filtering the search results.
              #     The only allowed `order_by` criteria for admin_search mode is `default`.
              #     Using this flags guarantees a full recall of the search results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DataCatalog::V1::SearchCatalogResult>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DataCatalog::V1::SearchCatalogResult>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::SearchCatalogRequest.new
              #
              #   # Call the search_catalog method.
              #   result = client.search_catalog request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::V1::SearchCatalogResult.
              #     p item
              #   end
              #
              def search_catalog request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::SearchCatalogRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_catalog.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_catalog.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_catalog.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.search_catalog request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_catalog_stub, :search_catalog, "results", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an entry group.
              #
              # An entry group contains logically related entries together with [Cloud
              # Identity and Access Management](/data-catalog/docs/concepts/iam) policies.
              # These policies specify users who can create, edit, and view entries
              # within entry groups.
              #
              # Data Catalog automatically creates entry groups with names that start with
              # the `@` symbol for the following resources:
              #
              # * BigQuery entries (`@bigquery`)
              # * Pub/Sub topics (`@pubsub`)
              # * Dataproc Metastore services (`@dataproc_metastore_{SERVICE_NAME_HASH}`)
              #
              # You can create your own entry groups for Cloud Storage fileset entries
              # and custom entries together with the corresponding IAM policies.
              # User-created entry groups can't contain the `@` symbol, it is reserved
              # for automatically created groups.
              #
              # Entry groups, like entries, can be searched.
              #
              # A maximum of 10,000 entry groups may be created per organization across all
              # locations.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `parent` parameter. For more information, see [Data Catalog resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload create_entry_group(request, options = nil)
              #   Pass arguments to `create_entry_group` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::CreateEntryGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::CreateEntryGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_entry_group(parent: nil, entry_group_id: nil, entry_group: nil)
              #   Pass arguments to `create_entry_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The names of the project and location that the new entry group
              #     belongs to.
              #
              #     Note: The entry group itself and its child resources might not be
              #     stored in the location specified in its name.
              #   @param entry_group_id [::String]
              #     Required. The ID of the entry group to create.
              #
              #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
              #     underscores (_), and must start with a letter or underscore.
              #     The maximum size is 64 bytes when encoded in UTF-8.
              #   @param entry_group [::Google::Cloud::DataCatalog::V1::EntryGroup, ::Hash]
              #     The entry group to create. Defaults to empty.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::EntryGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::EntryGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::CreateEntryGroupRequest.new
              #
              #   # Call the create_entry_group method.
              #   result = client.create_entry_group request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::EntryGroup.
              #   p result
              #
              def create_entry_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::CreateEntryGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_entry_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_entry_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_entry_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.create_entry_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an entry group.
              #
              # @overload get_entry_group(request, options = nil)
              #   Pass arguments to `get_entry_group` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::GetEntryGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::GetEntryGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_entry_group(name: nil, read_mask: nil)
              #   Pass arguments to `get_entry_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entry group to get.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The fields to return. If empty or omitted, all fields are returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::EntryGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::EntryGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::GetEntryGroupRequest.new
              #
              #   # Call the get_entry_group method.
              #   result = client.get_entry_group request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::EntryGroup.
              #   p result
              #
              def get_entry_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::GetEntryGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_entry_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_entry_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_entry_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.get_entry_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an entry group.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `entry_group.name` parameter. For more information, see [Data Catalog
              # resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload update_entry_group(request, options = nil)
              #   Pass arguments to `update_entry_group` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::UpdateEntryGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::UpdateEntryGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_entry_group(entry_group: nil, update_mask: nil)
              #   Pass arguments to `update_entry_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param entry_group [::Google::Cloud::DataCatalog::V1::EntryGroup, ::Hash]
              #     Required. Updates for the entry group. The `name` field must be set.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Names of fields whose values to overwrite on an entry group.
              #
              #     If this parameter is absent or empty, all modifiable fields
              #     are overwritten. If such fields are non-required and omitted in the
              #     request body, their values are emptied.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::EntryGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::EntryGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::UpdateEntryGroupRequest.new
              #
              #   # Call the update_entry_group method.
              #   result = client.update_entry_group request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::EntryGroup.
              #   p result
              #
              def update_entry_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::UpdateEntryGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_entry_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_entry_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_entry_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.update_entry_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an entry group.
              #
              # You must enable the Data Catalog API in the project
              # identified by the `name` parameter. For more information, see [Data Catalog
              # resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload delete_entry_group(request, options = nil)
              #   Pass arguments to `delete_entry_group` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::DeleteEntryGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::DeleteEntryGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_entry_group(name: nil, force: nil)
              #   Pass arguments to `delete_entry_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entry group to delete.
              #   @param force [::Boolean]
              #     Optional. If true, deletes all entries in the entry group.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::DeleteEntryGroupRequest.new
              #
              #   # Call the delete_entry_group method.
              #   result = client.delete_entry_group request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_entry_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::DeleteEntryGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_entry_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_entry_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_entry_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.delete_entry_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists entry groups.
              #
              # @overload list_entry_groups(request, options = nil)
              #   Pass arguments to `list_entry_groups` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::ListEntryGroupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::ListEntryGroupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_entry_groups(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_entry_groups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the location that contains the entry groups to list.
              #
              #     Can be provided as a URL.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #
              #     Default is 10. Maximum limit is 1000.
              #     Throws an invalid argument if `page_size` is greater than 1000.
              #   @param page_token [::String]
              #     Optional. Pagination token that specifies the next page to return.
              #     If empty, returns the first page.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DataCatalog::V1::EntryGroup>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DataCatalog::V1::EntryGroup>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::ListEntryGroupsRequest.new
              #
              #   # Call the list_entry_groups method.
              #   result = client.list_entry_groups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::V1::EntryGroup.
              #     p item
              #   end
              #
              def list_entry_groups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::ListEntryGroupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_entry_groups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_entry_groups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_entry_groups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.list_entry_groups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_catalog_stub, :list_entry_groups, "entry_groups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an entry.
              #
              # You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM',
              # or custom types. Data Catalog automatically creates entries with other
              # types during metadata ingestion from integrated systems.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `parent` parameter. For more information, see [Data Catalog resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # An entry group can have a maximum of 100,000 entries.
              #
              # @overload create_entry(request, options = nil)
              #   Pass arguments to `create_entry` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::CreateEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::CreateEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_entry(parent: nil, entry_id: nil, entry: nil)
              #   Pass arguments to `create_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the entry group this entry belongs to.
              #
              #     Note: The entry itself and its child resources might not be stored in
              #     the location specified in its name.
              #   @param entry_id [::String]
              #     Required. The ID of the entry to create.
              #
              #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
              #     and underscores (_).
              #     The maximum size is 64 bytes when encoded in UTF-8.
              #   @param entry [::Google::Cloud::DataCatalog::V1::Entry, ::Hash]
              #     Required. The entry to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::Entry]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::Entry]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::CreateEntryRequest.new
              #
              #   # Call the create_entry method.
              #   result = client.create_entry request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::Entry.
              #   p result
              #
              def create_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::CreateEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.create_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing entry.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `entry.name` parameter. For more information, see [Data Catalog
              # resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload update_entry(request, options = nil)
              #   Pass arguments to `update_entry` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::UpdateEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::UpdateEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_entry(entry: nil, update_mask: nil)
              #   Pass arguments to `update_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param entry [::Google::Cloud::DataCatalog::V1::Entry, ::Hash]
              #     Required. Updates for the entry. The `name` field must be set.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Names of fields whose values to overwrite on an entry.
              #
              #     If this parameter is absent or empty, all modifiable fields
              #     are overwritten. If such fields are non-required and omitted in the
              #     request body, their values are emptied.
              #
              #     You can modify only the fields listed below.
              #
              #     For entries with type `DATA_STREAM`:
              #
              #     * `schema`
              #
              #     For entries with type `FILESET`:
              #
              #     * `schema`
              #     * `display_name`
              #     * `description`
              #     * `gcs_fileset_spec`
              #     * `gcs_fileset_spec.file_patterns`
              #
              #     For entries with `user_specified_type`:
              #
              #     * `schema`
              #     * `display_name`
              #     * `description`
              #     * `user_specified_type`
              #     * `user_specified_system`
              #     * `linked_resource`
              #     * `source_system_timestamps`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::Entry]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::Entry]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::UpdateEntryRequest.new
              #
              #   # Call the update_entry method.
              #   result = client.update_entry request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::Entry.
              #   p result
              #
              def update_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::UpdateEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.update_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an existing entry.
              #
              # You can delete only the entries created by the
              # {::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client#create_entry CreateEntry}
              # method.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `name` parameter. For more information, see [Data Catalog
              # resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload delete_entry(request, options = nil)
              #   Pass arguments to `delete_entry` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::DeleteEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::DeleteEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_entry(name: nil)
              #   Pass arguments to `delete_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entry to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::DeleteEntryRequest.new
              #
              #   # Call the delete_entry method.
              #   result = client.delete_entry request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::DeleteEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.delete_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an entry.
              #
              # @overload get_entry(request, options = nil)
              #   Pass arguments to `get_entry` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::GetEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::GetEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_entry(name: nil)
              #   Pass arguments to `get_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entry to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::Entry]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::Entry]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::GetEntryRequest.new
              #
              #   # Call the get_entry method.
              #   result = client.get_entry request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::Entry.
              #   p result
              #
              def get_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::GetEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.get_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an entry by its target resource name.
              #
              # The resource name comes from the source Google Cloud Platform service.
              #
              # @overload lookup_entry(request, options = nil)
              #   Pass arguments to `lookup_entry` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::LookupEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::LookupEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload lookup_entry(linked_resource: nil, sql_resource: nil, fully_qualified_name: nil, project: nil, location: nil)
              #   Pass arguments to `lookup_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param linked_resource [::String]
              #     The full name of the Google Cloud Platform resource the Data Catalog
              #     entry represents. For more information, see [Full Resource Name]
              #     (https://cloud.google.com/apis/design/resource_names#full_resource_name).
              #
              #     Full names are case-sensitive. For example:
              #
              #      * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
              #      * `//pubsub.googleapis.com/projects/{PROJECT_ID}/topics/{TOPIC_ID}`
              #
              #     Note: The following parameters are mutually exclusive: `linked_resource`, `sql_resource`, `fully_qualified_name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param sql_resource [::String]
              #     The SQL name of the entry. SQL names are case-sensitive.
              #
              #     Examples:
              #
              #     * `pubsub.topic.{PROJECT_ID}.{TOPIC_ID}`
              #     * `pubsub.topic.{PROJECT_ID}.`\``{TOPIC.ID.SEPARATED.WITH.DOTS}`\`
              #     * `bigquery.table.{PROJECT_ID}.{DATASET_ID}.{TABLE_ID}`
              #     * `bigquery.dataset.{PROJECT_ID}.{DATASET_ID}`
              #     * `datacatalog.entry.{PROJECT_ID}.{LOCATION_ID}.{ENTRY_GROUP_ID}.{ENTRY_ID}`
              #
              #     Identifiers (`*_ID`) should comply with the
              #     [Lexical structure in GoogleSQL]
              #     (https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical).
              #
              #     Note: The following parameters are mutually exclusive: `sql_resource`, `linked_resource`, `fully_qualified_name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param fully_qualified_name [::String]
              #     [Fully Qualified Name
              #     (FQN)](https://cloud.google.com//data-catalog/docs/fully-qualified-names)
              #     of the resource.
              #
              #     FQNs take two forms:
              #
              #     * For non-regionalized resources:
              #
              #       `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
              #
              #     * For regionalized resources:
              #
              #       `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
              #
              #     Example for a DPMS table:
              #
              #     `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
              #
              #     Note: The following parameters are mutually exclusive: `fully_qualified_name`, `linked_resource`, `sql_resource`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param project [::String]
              #     Project where the lookup should be performed. Required to lookup
              #     entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
              #     using its `fully_qualified_name`. Ignored in other cases.
              #   @param location [::String]
              #     Location where the lookup should be performed. Required to lookup
              #     entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
              #     using its `fully_qualified_name`. Ignored in other cases.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::Entry]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::Entry]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::LookupEntryRequest.new
              #
              #   # Call the lookup_entry method.
              #   result = client.lookup_entry request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::Entry.
              #   p result
              #
              def lookup_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::LookupEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.lookup_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.lookup_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.lookup_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.lookup_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists entries.
              #
              # Note: Currently, this method can list only custom entries.
              # To get a list of both custom and automatically created entries, use
              # {::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client#search_catalog SearchCatalog}.
              #
              # @overload list_entries(request, options = nil)
              #   Pass arguments to `list_entries` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::ListEntriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::ListEntriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_entries(parent: nil, page_size: nil, page_token: nil, read_mask: nil)
              #   Pass arguments to `list_entries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the entry group that contains the entries to list.
              #
              #     Can be provided in URL format.
              #   @param page_size [::Integer]
              #     The maximum number of items to return. Default is 10. Maximum limit is
              #     1000. Throws an invalid argument if `page_size` is more than 1000.
              #   @param page_token [::String]
              #     Pagination token that specifies the next page to return. If empty, the
              #     first page is returned.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The fields to return for each entry. If empty or omitted, all
              #     fields are returned.
              #
              #     For example, to return a list of entries with only the `name` field,
              #     set `read_mask` to only one path with the `name` value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DataCatalog::V1::Entry>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DataCatalog::V1::Entry>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::ListEntriesRequest.new
              #
              #   # Call the list_entries method.
              #   result = client.list_entries request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::V1::Entry.
              #     p item
              #   end
              #
              def list_entries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::ListEntriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_entries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_entries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_entries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.list_entries request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_catalog_stub, :list_entries, "entries", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Modifies entry overview, part of the business context of an
              # {::Google::Cloud::DataCatalog::V1::Entry Entry}.
              #
              # To call this method, you must have the `datacatalog.entries.updateOverview`
              # IAM permission on the corresponding project.
              #
              # @overload modify_entry_overview(request, options = nil)
              #   Pass arguments to `modify_entry_overview` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::ModifyEntryOverviewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::ModifyEntryOverviewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload modify_entry_overview(name: nil, entry_overview: nil)
              #   Pass arguments to `modify_entry_overview` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full resource name of the entry.
              #   @param entry_overview [::Google::Cloud::DataCatalog::V1::EntryOverview, ::Hash]
              #     Required. The new value for the Entry Overview.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::EntryOverview]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::EntryOverview]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::ModifyEntryOverviewRequest.new
              #
              #   # Call the modify_entry_overview method.
              #   result = client.modify_entry_overview request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::EntryOverview.
              #   p result
              #
              def modify_entry_overview request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::ModifyEntryOverviewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.modify_entry_overview.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.modify_entry_overview.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.modify_entry_overview.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.modify_entry_overview request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Modifies contacts, part of the business context of an
              # {::Google::Cloud::DataCatalog::V1::Entry Entry}.
              #
              # To call this method, you must have the `datacatalog.entries.updateContacts`
              # IAM permission on the corresponding project.
              #
              # @overload modify_entry_contacts(request, options = nil)
              #   Pass arguments to `modify_entry_contacts` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::ModifyEntryContactsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::ModifyEntryContactsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload modify_entry_contacts(name: nil, contacts: nil)
              #   Pass arguments to `modify_entry_contacts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full resource name of the entry.
              #   @param contacts [::Google::Cloud::DataCatalog::V1::Contacts, ::Hash]
              #     Required. The new value for the Contacts.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::Contacts]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::Contacts]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::ModifyEntryContactsRequest.new
              #
              #   # Call the modify_entry_contacts method.
              #   result = client.modify_entry_contacts request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::Contacts.
              #   p result
              #
              def modify_entry_contacts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::ModifyEntryContactsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.modify_entry_contacts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.modify_entry_contacts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.modify_entry_contacts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.modify_entry_contacts request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a tag template.
              #
              # You must enable the Data Catalog API in the project identified by the
              # `parent` parameter.
              # For more information, see [Data Catalog resource project]
              # (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload create_tag_template(request, options = nil)
              #   Pass arguments to `create_tag_template` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::CreateTagTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::CreateTagTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tag_template(parent: nil, tag_template_id: nil, tag_template: nil)
              #   Pass arguments to `create_tag_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the project and the template location
              #     [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
              #   @param tag_template_id [::String]
              #     Required. The ID of the tag template to create.
              #
              #     The ID must contain only lowercase letters (a-z), numbers (0-9),
              #     or underscores (_), and must start with a letter or underscore.
              #     The maximum size is 64 bytes when encoded in UTF-8.
              #   @param tag_template [::Google::Cloud::DataCatalog::V1::TagTemplate, ::Hash]
              #     Required. The tag template to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::TagTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::TagTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::CreateTagTemplateRequest.new
              #
              #   # Call the create_tag_template method.
              #   result = client.create_tag_template request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::TagTemplate.
              #   p result
              #
              def create_tag_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::CreateTagTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tag_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tag_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tag_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.create_tag_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a tag template.
              #
              # @overload get_tag_template(request, options = nil)
              #   Pass arguments to `get_tag_template` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::GetTagTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::GetTagTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_tag_template(name: nil)
              #   Pass arguments to `get_tag_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the tag template to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::TagTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::TagTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::GetTagTemplateRequest.new
              #
              #   # Call the get_tag_template method.
              #   result = client.get_tag_template request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::TagTemplate.
              #   p result
              #
              def get_tag_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::GetTagTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_tag_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_tag_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_tag_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.get_tag_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a tag template.
              #
              # You can't update template fields with this method. These fields are
              # separate resources with their own create, update, and delete methods.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `tag_template.name` parameter. For more information, see [Data Catalog
              # resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload update_tag_template(request, options = nil)
              #   Pass arguments to `update_tag_template` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::UpdateTagTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::UpdateTagTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tag_template(tag_template: nil, update_mask: nil)
              #   Pass arguments to `update_tag_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tag_template [::Google::Cloud::DataCatalog::V1::TagTemplate, ::Hash]
              #     Required. The template to update. The `name` field must be set.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Names of fields whose values to overwrite on a tag template. Currently,
              #     only `display_name` and `is_publicly_readable` can be overwritten.
              #
              #     If this parameter is absent or empty, all modifiable fields
              #     are overwritten. If such fields are non-required and omitted in the
              #     request body, their values are emptied.
              #
              #     Note: Updating the `is_publicly_readable` field may require up to 12
              #     hours to take effect in search results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::TagTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::TagTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::UpdateTagTemplateRequest.new
              #
              #   # Call the update_tag_template method.
              #   result = client.update_tag_template request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::TagTemplate.
              #   p result
              #
              def update_tag_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::UpdateTagTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tag_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tag_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tag_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.update_tag_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a tag template and all tags that use it.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `name` parameter. For more information, see [Data Catalog resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload delete_tag_template(request, options = nil)
              #   Pass arguments to `delete_tag_template` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::DeleteTagTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::DeleteTagTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tag_template(name: nil, force: nil)
              #   Pass arguments to `delete_tag_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the tag template to delete.
              #   @param force [::Boolean]
              #     Required. If true, deletes all tags that use this template.
              #
              #     Currently, `true` is the only supported value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::DeleteTagTemplateRequest.new
              #
              #   # Call the delete_tag_template method.
              #   result = client.delete_tag_template request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_tag_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::DeleteTagTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tag_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tag_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tag_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.delete_tag_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a field in a tag template.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `parent` parameter. For more information, see [Data Catalog resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload create_tag_template_field(request, options = nil)
              #   Pass arguments to `create_tag_template_field` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::CreateTagTemplateFieldRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::CreateTagTemplateFieldRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tag_template_field(parent: nil, tag_template_field_id: nil, tag_template_field: nil)
              #   Pass arguments to `create_tag_template_field` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the project and the template location
              #     [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
              #   @param tag_template_field_id [::String]
              #     Required. The ID of the tag template field to create.
              #
              #     Note: Adding a required field to an existing template is *not* allowed.
              #
              #     Field IDs can contain letters (both uppercase and lowercase), numbers
              #     (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
              #     character long and at most 128 characters long. Field IDs must also be
              #     unique within their template.
              #   @param tag_template_field [::Google::Cloud::DataCatalog::V1::TagTemplateField, ::Hash]
              #     Required. The tag template field to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::TagTemplateField]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::TagTemplateField]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::CreateTagTemplateFieldRequest.new
              #
              #   # Call the create_tag_template_field method.
              #   result = client.create_tag_template_field request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::TagTemplateField.
              #   p result
              #
              def create_tag_template_field request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::CreateTagTemplateFieldRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tag_template_field.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tag_template_field.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tag_template_field.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.create_tag_template_field request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a field in a tag template.
              #
              # You can't update the field type with this method.
              #
              # You must enable the Data Catalog API in the project
              # identified by the `name` parameter. For more information, see [Data Catalog
              # resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload update_tag_template_field(request, options = nil)
              #   Pass arguments to `update_tag_template_field` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::UpdateTagTemplateFieldRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::UpdateTagTemplateFieldRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tag_template_field(name: nil, tag_template_field: nil, update_mask: nil)
              #   Pass arguments to `update_tag_template_field` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the tag template field.
              #   @param tag_template_field [::Google::Cloud::DataCatalog::V1::TagTemplateField, ::Hash]
              #     Required. The template to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Names of fields whose values to overwrite on an individual field
              #     of a tag template. The following fields are modifiable:
              #
              #     * `display_name`
              #     * `type.enum_type`
              #     * `is_required`
              #
              #     If this parameter is absent or empty, all modifiable fields
              #     are overwritten. If such fields are non-required and omitted in the request
              #     body, their values are emptied with one exception: when updating an enum
              #     type, the provided values are merged with the existing values. Therefore,
              #     enum values can only be added, existing enum values cannot be deleted or
              #     renamed.
              #
              #     Additionally, updating a template field from optional to required is
              #     *not* allowed.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::TagTemplateField]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::TagTemplateField]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::UpdateTagTemplateFieldRequest.new
              #
              #   # Call the update_tag_template_field method.
              #   result = client.update_tag_template_field request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::TagTemplateField.
              #   p result
              #
              def update_tag_template_field request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::UpdateTagTemplateFieldRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tag_template_field.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tag_template_field.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tag_template_field.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.update_tag_template_field request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Renames a field in a tag template.
              #
              # You must enable the Data Catalog API in the project identified by the
              # `name` parameter. For more information, see [Data Catalog resource project]
              # (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload rename_tag_template_field(request, options = nil)
              #   Pass arguments to `rename_tag_template_field` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::RenameTagTemplateFieldRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::RenameTagTemplateFieldRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rename_tag_template_field(name: nil, new_tag_template_field_id: nil)
              #   Pass arguments to `rename_tag_template_field` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the tag template field.
              #   @param new_tag_template_field_id [::String]
              #     Required. The new ID of this tag template field. For example,
              #     `my_new_field`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::TagTemplateField]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::TagTemplateField]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::RenameTagTemplateFieldRequest.new
              #
              #   # Call the rename_tag_template_field method.
              #   result = client.rename_tag_template_field request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::TagTemplateField.
              #   p result
              #
              def rename_tag_template_field request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::RenameTagTemplateFieldRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rename_tag_template_field.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rename_tag_template_field.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rename_tag_template_field.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.rename_tag_template_field request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Renames an enum value in a tag template.
              #
              # Within a single enum field, enum values must be unique.
              #
              # @overload rename_tag_template_field_enum_value(request, options = nil)
              #   Pass arguments to `rename_tag_template_field_enum_value` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::RenameTagTemplateFieldEnumValueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::RenameTagTemplateFieldEnumValueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rename_tag_template_field_enum_value(name: nil, new_enum_value_display_name: nil)
              #   Pass arguments to `rename_tag_template_field_enum_value` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the enum field value.
              #   @param new_enum_value_display_name [::String]
              #     Required. The new display name of the enum value. For example,
              #     `my_new_enum_value`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::TagTemplateField]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::TagTemplateField]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::RenameTagTemplateFieldEnumValueRequest.new
              #
              #   # Call the rename_tag_template_field_enum_value method.
              #   result = client.rename_tag_template_field_enum_value request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::TagTemplateField.
              #   p result
              #
              def rename_tag_template_field_enum_value request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::RenameTagTemplateFieldEnumValueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rename_tag_template_field_enum_value.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rename_tag_template_field_enum_value.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rename_tag_template_field_enum_value.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.rename_tag_template_field_enum_value request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a field in a tag template and all uses of this field from the tags
              # based on this template.
              #
              # You must enable the Data Catalog API in the project identified by
              # the `name` parameter. For more information, see [Data Catalog resource
              # project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
              #
              # @overload delete_tag_template_field(request, options = nil)
              #   Pass arguments to `delete_tag_template_field` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::DeleteTagTemplateFieldRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::DeleteTagTemplateFieldRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tag_template_field(name: nil, force: nil)
              #   Pass arguments to `delete_tag_template_field` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the tag template field to delete.
              #   @param force [::Boolean]
              #     Required. If true, deletes this field from any tags that use it.
              #
              #     Currently, `true` is the only supported value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::DeleteTagTemplateFieldRequest.new
              #
              #   # Call the delete_tag_template_field method.
              #   result = client.delete_tag_template_field request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_tag_template_field request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::DeleteTagTemplateFieldRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tag_template_field.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tag_template_field.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tag_template_field.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.delete_tag_template_field request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a tag and assigns it to:
              #
              # * An {::Google::Cloud::DataCatalog::V1::Entry Entry} if the method name is
              #   `projects.locations.entryGroups.entries.tags.create`.
              # * Or {::Google::Cloud::DataCatalog::V1::EntryGroup EntryGroup}if the method
              #   name is `projects.locations.entryGroups.tags.create`.
              #
              # Note: The project identified by the `parent` parameter for the [tag]
              # (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
              # and the [tag template]
              # (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
              # used to create the tag must be in the same organization.
              #
              # @overload create_tag(request, options = nil)
              #   Pass arguments to `create_tag` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::CreateTagRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::CreateTagRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tag(parent: nil, tag: nil)
              #   Pass arguments to `create_tag` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the resource to attach this tag to.
              #
              #     Tags can be attached to entries or entry groups. An entry can have up to
              #     1000 attached tags.
              #
              #     Note: The tag and its child resources might not be stored in
              #     the location specified in its name.
              #   @param tag [::Google::Cloud::DataCatalog::V1::Tag, ::Hash]
              #     Required. The tag to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::Tag]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::Tag]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::CreateTagRequest.new
              #
              #   # Call the create_tag method.
              #   result = client.create_tag request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::Tag.
              #   p result
              #
              def create_tag request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::CreateTagRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tag.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tag.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tag.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.create_tag request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing tag.
              #
              # @overload update_tag(request, options = nil)
              #   Pass arguments to `update_tag` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::UpdateTagRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::UpdateTagRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tag(tag: nil, update_mask: nil)
              #   Pass arguments to `update_tag` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tag [::Google::Cloud::DataCatalog::V1::Tag, ::Hash]
              #     Required. The updated tag. The "name" field must be set.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Names of fields whose values to overwrite on a tag. Currently, a tag has
              #     the only modifiable field with the name `fields`.
              #
              #     In general, if this parameter is absent or empty, all modifiable fields
              #     are overwritten. If such fields are non-required and omitted in the
              #     request body, their values are emptied.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::Tag]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::Tag]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::UpdateTagRequest.new
              #
              #   # Call the update_tag method.
              #   result = client.update_tag request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::Tag.
              #   p result
              #
              def update_tag request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::UpdateTagRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tag.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tag.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tag.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.update_tag request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a tag.
              #
              # @overload delete_tag(request, options = nil)
              #   Pass arguments to `delete_tag` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::DeleteTagRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::DeleteTagRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tag(name: nil)
              #   Pass arguments to `delete_tag` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the tag to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::DeleteTagRequest.new
              #
              #   # Call the delete_tag method.
              #   result = client.delete_tag request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_tag request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::DeleteTagRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tag.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tag.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tag.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.delete_tag request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists tags assigned to an {::Google::Cloud::DataCatalog::V1::Entry Entry}.
              # The {::Google::Cloud::DataCatalog::V1::Tag#column columns} in the response are
              # lowercased.
              #
              # @overload list_tags(request, options = nil)
              #   Pass arguments to `list_tags` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::ListTagsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::ListTagsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tags(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_tags` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the Data Catalog resource to list the tags of.
              #
              #     The resource can be an {::Google::Cloud::DataCatalog::V1::Entry Entry}
              #     or an {::Google::Cloud::DataCatalog::V1::EntryGroup EntryGroup}
              #     (without `/entries/{entries}` at the end).
              #   @param page_size [::Integer]
              #     The maximum number of tags to return. Default is 10. Maximum limit is 1000.
              #   @param page_token [::String]
              #     Pagination token that specifies the next page to return. If empty, the
              #     first page is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DataCatalog::V1::Tag>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DataCatalog::V1::Tag>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::ListTagsRequest.new
              #
              #   # Call the list_tags method.
              #   result = client.list_tags request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::V1::Tag.
              #     p item
              #   end
              #
              def list_tags request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::ListTagsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tags.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tags.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tags.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.list_tags request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_catalog_stub, :list_tags, "tags", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # `ReconcileTags` creates or updates a list of tags on the entry.
              # If the
              # {::Google::Cloud::DataCatalog::V1::ReconcileTagsRequest#force_delete_missing ReconcileTagsRequest.force_delete_missing}
              # parameter is set, the operation deletes tags not included in the input tag
              # list.
              #
              # `ReconcileTags` returns a [long-running operation]
              # [google.longrunning.Operation] resource that can be queried with
              # Operations.GetOperation
              # to return [ReconcileTagsMetadata]
              # [google.cloud.datacatalog.v1.ReconcileTagsMetadata] and
              # a [ReconcileTagsResponse]
              # [google.cloud.datacatalog.v1.ReconcileTagsResponse] message.
              #
              # @overload reconcile_tags(request, options = nil)
              #   Pass arguments to `reconcile_tags` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::ReconcileTagsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::ReconcileTagsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reconcile_tags(parent: nil, tag_template: nil, force_delete_missing: nil, tags: nil)
              #   Pass arguments to `reconcile_tags` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of {::Google::Cloud::DataCatalog::V1::Entry Entry} to be tagged.
              #   @param tag_template [::String]
              #     Required. The name of the tag template, which is used for reconciliation.
              #   @param force_delete_missing [::Boolean]
              #     If set to `true`, deletes entry tags related to a tag template
              #     not listed in the tags source from an entry. If set to `false`,
              #     unlisted tags are retained.
              #   @param tags [::Array<::Google::Cloud::DataCatalog::V1::Tag, ::Hash>]
              #     A list of tags to apply to an entry. A tag can specify a
              #     tag template, which must be the template specified in the
              #     `ReconcileTagsRequest`.
              #     The sole entry and each of its columns must be mentioned at most once.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::ReconcileTagsRequest.new
              #
              #   # Call the reconcile_tags method.
              #   result = client.reconcile_tags request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def reconcile_tags request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::ReconcileTagsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reconcile_tags.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reconcile_tags.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reconcile_tags.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.reconcile_tags request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks an {::Google::Cloud::DataCatalog::V1::Entry Entry} as starred by
              # the current user. Starring information is private to each user.
              #
              # @overload star_entry(request, options = nil)
              #   Pass arguments to `star_entry` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::StarEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::StarEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload star_entry(name: nil)
              #   Pass arguments to `star_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entry to mark as starred.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::StarEntryResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::StarEntryResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::StarEntryRequest.new
              #
              #   # Call the star_entry method.
              #   result = client.star_entry request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::StarEntryResponse.
              #   p result
              #
              def star_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::StarEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.star_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.star_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.star_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.star_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks an {::Google::Cloud::DataCatalog::V1::Entry Entry} as NOT starred by
              # the current user. Starring information is private to each user.
              #
              # @overload unstar_entry(request, options = nil)
              #   Pass arguments to `unstar_entry` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::UnstarEntryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::UnstarEntryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload unstar_entry(name: nil)
              #   Pass arguments to `unstar_entry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entry to mark as **not** starred.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::UnstarEntryResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::UnstarEntryResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::UnstarEntryRequest.new
              #
              #   # Call the unstar_entry method.
              #   result = client.unstar_entry request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::UnstarEntryResponse.
              #   p result
              #
              def unstar_entry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::UnstarEntryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.unstar_entry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.unstar_entry.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.unstar_entry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.unstar_entry request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets an access control policy for a resource. Replaces any existing
              # policy.
              #
              # Supported resources are:
              #
              # - Tag templates
              # - Entry groups
              #
              # Note: This method sets policies only within Data Catalog and can't be
              # used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any
              # external Google Cloud Platform resources synced with the Data Catalog.
              #
              # To call this method, you must have the following Google IAM permissions:
              #
              # - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
              #   templates.
              # - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a resource.
              #
              # May return:
              #
              # * A`NOT_FOUND` error if the resource doesn't exist or you don't have the
              #   permission to view it.
              # * An empty policy if the resource exists but doesn't have a set policy.
              #
              # Supported resources are:
              #
              # - Tag templates
              # - Entry groups
              #
              # Note: This method doesn't get policies from Google Cloud Platform
              # resources ingested into Data Catalog.
              #
              # To call this method, you must have the following Google IAM permissions:
              #
              # - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
              #   templates.
              # - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets your permissions on a resource.
              #
              # Returns an empty set of permissions if the resource doesn't exist.
              #
              # Supported resources are:
              #
              # - Tag templates
              # - Entry groups
              #
              # Note: This method gets policies only within Data Catalog and can't be
              # used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any
              # external Google Cloud Platform resources ingested into Data Catalog.
              #
              # No Google IAM permissions are required to call this method.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports entries from a source, such as data previously dumped into a
              # Cloud Storage bucket, into Data Catalog. Import of entries
              # is a sync operation that reconciles the state of the third-party system
              # with the Data Catalog.
              #
              # `ImportEntries` accepts source data snapshots of a third-party system.
              # Snapshot should be delivered as a .wire or base65-encoded .txt file
              # containing a sequence of Protocol Buffer messages of
              # {::Google::Cloud::DataCatalog::V1::DumpItem DumpItem} type.
              #
              # `ImportEntries` returns a [long-running operation]
              # [google.longrunning.Operation] resource that can be queried with
              # Operations.GetOperation
              # to return
              # {::Google::Cloud::DataCatalog::V1::ImportEntriesMetadata ImportEntriesMetadata}
              # and an
              # {::Google::Cloud::DataCatalog::V1::ImportEntriesResponse ImportEntriesResponse}
              # message.
              #
              # @overload import_entries(request, options = nil)
              #   Pass arguments to `import_entries` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::ImportEntriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::ImportEntriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_entries(parent: nil, gcs_bucket_path: nil, job_id: nil)
              #   Pass arguments to `import_entries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Target entry group for ingested entries.
              #   @param gcs_bucket_path [::String]
              #     Path to a Cloud Storage bucket that contains a dump ready for ingestion.
              #   @param job_id [::String]
              #     Optional. (Optional) Dataplex task job id, if specified will be used as
              #     part of ImportEntries LRO ID
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::ImportEntriesRequest.new
              #
              #   # Call the import_entries method.
              #   result = client.import_entries request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_entries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::ImportEntriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_entries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_entries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_entries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.import_entries request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the configuration related to the migration to Dataplex for an
              # organization or project.
              #
              # @overload set_config(request, options = nil)
              #   Pass arguments to `set_config` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::SetConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::SetConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_config(name: nil, tag_template_migration: nil, catalog_ui_experience: nil)
              #   Pass arguments to `set_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The organization or project whose config is being specified.
              #   @param tag_template_migration [::Google::Cloud::DataCatalog::V1::TagTemplateMigration]
              #     Opt-in status for the migration of Tag Templates to Dataplex.
              #
              #     Note: The following parameters are mutually exclusive: `tag_template_migration`, `catalog_ui_experience`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param catalog_ui_experience [::Google::Cloud::DataCatalog::V1::CatalogUIExperience]
              #     Opt-in status for the UI switch to Dataplex.
              #
              #     Note: The following parameters are mutually exclusive: `catalog_ui_experience`, `tag_template_migration`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::MigrationConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::MigrationConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::SetConfigRequest.new
              #
              #   # Call the set_config method.
              #   result = client.set_config request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::MigrationConfig.
              #   p result
              #
              def set_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::SetConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.set_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the configuration related to the migration from Data Catalog to
              # Dataplex for a specific organization, including all the projects under it
              # which have a separate configuration set.
              #
              # @overload retrieve_config(request, options = nil)
              #   Pass arguments to `retrieve_config` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::RetrieveConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::RetrieveConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload retrieve_config(name: nil)
              #   Pass arguments to `retrieve_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The organization whose config is being retrieved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::OrganizationConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::OrganizationConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::RetrieveConfigRequest.new
              #
              #   # Call the retrieve_config method.
              #   result = client.retrieve_config request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::OrganizationConfig.
              #   p result
              #
              def retrieve_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::RetrieveConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.retrieve_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.retrieve_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.retrieve_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.retrieve_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the effective configuration related to the migration from Data
              # Catalog to Dataplex for a specific organization or project. If there is no
              # specific configuration set for the resource, the setting is checked
              # hierarchicahlly through the ancestors of the resource, starting from the
              # resource itself.
              #
              # @overload retrieve_effective_config(request, options = nil)
              #   Pass arguments to `retrieve_effective_config` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::V1::RetrieveEffectiveConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::V1::RetrieveEffectiveConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload retrieve_effective_config(name: nil)
              #   Pass arguments to `retrieve_effective_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource whose effective config is being retrieved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DataCatalog::V1::MigrationConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DataCatalog::V1::MigrationConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::V1::RetrieveEffectiveConfigRequest.new
              #
              #   # Call the retrieve_effective_config method.
              #   result = client.retrieve_effective_config request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::V1::MigrationConfig.
              #   p result
              #
              def retrieve_effective_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1::RetrieveEffectiveConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.retrieve_effective_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.retrieve_effective_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.retrieve_effective_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_catalog_stub.retrieve_effective_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DataCatalog REST API.
              #
              # This class represents the configuration for DataCatalog REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # search_catalog to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.search_catalog.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::DataCatalog::V1::DataCatalog::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.search_catalog.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "datacatalog.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DataCatalog API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `search_catalog`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_catalog
                  ##
                  # RPC-specific configuration for `create_entry_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_entry_group
                  ##
                  # RPC-specific configuration for `get_entry_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_entry_group
                  ##
                  # RPC-specific configuration for `update_entry_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_entry_group
                  ##
                  # RPC-specific configuration for `delete_entry_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_entry_group
                  ##
                  # RPC-specific configuration for `list_entry_groups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_entry_groups
                  ##
                  # RPC-specific configuration for `create_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_entry
                  ##
                  # RPC-specific configuration for `update_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_entry
                  ##
                  # RPC-specific configuration for `delete_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_entry
                  ##
                  # RPC-specific configuration for `get_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_entry
                  ##
                  # RPC-specific configuration for `lookup_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :lookup_entry
                  ##
                  # RPC-specific configuration for `list_entries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_entries
                  ##
                  # RPC-specific configuration for `modify_entry_overview`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :modify_entry_overview
                  ##
                  # RPC-specific configuration for `modify_entry_contacts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :modify_entry_contacts
                  ##
                  # RPC-specific configuration for `create_tag_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tag_template
                  ##
                  # RPC-specific configuration for `get_tag_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_tag_template
                  ##
                  # RPC-specific configuration for `update_tag_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tag_template
                  ##
                  # RPC-specific configuration for `delete_tag_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tag_template
                  ##
                  # RPC-specific configuration for `create_tag_template_field`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tag_template_field
                  ##
                  # RPC-specific configuration for `update_tag_template_field`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tag_template_field
                  ##
                  # RPC-specific configuration for `rename_tag_template_field`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rename_tag_template_field
                  ##
                  # RPC-specific configuration for `rename_tag_template_field_enum_value`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rename_tag_template_field_enum_value
                  ##
                  # RPC-specific configuration for `delete_tag_template_field`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tag_template_field
                  ##
                  # RPC-specific configuration for `create_tag`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tag
                  ##
                  # RPC-specific configuration for `update_tag`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tag
                  ##
                  # RPC-specific configuration for `delete_tag`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tag
                  ##
                  # RPC-specific configuration for `list_tags`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tags
                  ##
                  # RPC-specific configuration for `reconcile_tags`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reconcile_tags
                  ##
                  # RPC-specific configuration for `star_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :star_entry
                  ##
                  # RPC-specific configuration for `unstar_entry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :unstar_entry
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `import_entries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_entries
                  ##
                  # RPC-specific configuration for `set_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_config
                  ##
                  # RPC-specific configuration for `retrieve_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :retrieve_config
                  ##
                  # RPC-specific configuration for `retrieve_effective_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :retrieve_effective_config

                  # @private
                  def initialize parent_rpcs = nil
                    search_catalog_config = parent_rpcs.search_catalog if parent_rpcs.respond_to? :search_catalog
                    @search_catalog = ::Gapic::Config::Method.new search_catalog_config
                    create_entry_group_config = parent_rpcs.create_entry_group if parent_rpcs.respond_to? :create_entry_group
                    @create_entry_group = ::Gapic::Config::Method.new create_entry_group_config
                    get_entry_group_config = parent_rpcs.get_entry_group if parent_rpcs.respond_to? :get_entry_group
                    @get_entry_group = ::Gapic::Config::Method.new get_entry_group_config
                    update_entry_group_config = parent_rpcs.update_entry_group if parent_rpcs.respond_to? :update_entry_group
                    @update_entry_group = ::Gapic::Config::Method.new update_entry_group_config
                    delete_entry_group_config = parent_rpcs.delete_entry_group if parent_rpcs.respond_to? :delete_entry_group
                    @delete_entry_group = ::Gapic::Config::Method.new delete_entry_group_config
                    list_entry_groups_config = parent_rpcs.list_entry_groups if parent_rpcs.respond_to? :list_entry_groups
                    @list_entry_groups = ::Gapic::Config::Method.new list_entry_groups_config
                    create_entry_config = parent_rpcs.create_entry if parent_rpcs.respond_to? :create_entry
                    @create_entry = ::Gapic::Config::Method.new create_entry_config
                    update_entry_config = parent_rpcs.update_entry if parent_rpcs.respond_to? :update_entry
                    @update_entry = ::Gapic::Config::Method.new update_entry_config
                    delete_entry_config = parent_rpcs.delete_entry if parent_rpcs.respond_to? :delete_entry
                    @delete_entry = ::Gapic::Config::Method.new delete_entry_config
                    get_entry_config = parent_rpcs.get_entry if parent_rpcs.respond_to? :get_entry
                    @get_entry = ::Gapic::Config::Method.new get_entry_config
                    lookup_entry_config = parent_rpcs.lookup_entry if parent_rpcs.respond_to? :lookup_entry
                    @lookup_entry = ::Gapic::Config::Method.new lookup_entry_config
                    list_entries_config = parent_rpcs.list_entries if parent_rpcs.respond_to? :list_entries
                    @list_entries = ::Gapic::Config::Method.new list_entries_config
                    modify_entry_overview_config = parent_rpcs.modify_entry_overview if parent_rpcs.respond_to? :modify_entry_overview
                    @modify_entry_overview = ::Gapic::Config::Method.new modify_entry_overview_config
                    modify_entry_contacts_config = parent_rpcs.modify_entry_contacts if parent_rpcs.respond_to? :modify_entry_contacts
                    @modify_entry_contacts = ::Gapic::Config::Method.new modify_entry_contacts_config
                    create_tag_template_config = parent_rpcs.create_tag_template if parent_rpcs.respond_to? :create_tag_template
                    @create_tag_template = ::Gapic::Config::Method.new create_tag_template_config
                    get_tag_template_config = parent_rpcs.get_tag_template if parent_rpcs.respond_to? :get_tag_template
                    @get_tag_template = ::Gapic::Config::Method.new get_tag_template_config
                    update_tag_template_config = parent_rpcs.update_tag_template if parent_rpcs.respond_to? :update_tag_template
                    @update_tag_template = ::Gapic::Config::Method.new update_tag_template_config
                    delete_tag_template_config = parent_rpcs.delete_tag_template if parent_rpcs.respond_to? :delete_tag_template
                    @delete_tag_template = ::Gapic::Config::Method.new delete_tag_template_config
                    create_tag_template_field_config = parent_rpcs.create_tag_template_field if parent_rpcs.respond_to? :create_tag_template_field
                    @create_tag_template_field = ::Gapic::Config::Method.new create_tag_template_field_config
                    update_tag_template_field_config = parent_rpcs.update_tag_template_field if parent_rpcs.respond_to? :update_tag_template_field
                    @update_tag_template_field = ::Gapic::Config::Method.new update_tag_template_field_config
                    rename_tag_template_field_config = parent_rpcs.rename_tag_template_field if parent_rpcs.respond_to? :rename_tag_template_field
                    @rename_tag_template_field = ::Gapic::Config::Method.new rename_tag_template_field_config
                    rename_tag_template_field_enum_value_config = parent_rpcs.rename_tag_template_field_enum_value if parent_rpcs.respond_to? :rename_tag_template_field_enum_value
                    @rename_tag_template_field_enum_value = ::Gapic::Config::Method.new rename_tag_template_field_enum_value_config
                    delete_tag_template_field_config = parent_rpcs.delete_tag_template_field if parent_rpcs.respond_to? :delete_tag_template_field
                    @delete_tag_template_field = ::Gapic::Config::Method.new delete_tag_template_field_config
                    create_tag_config = parent_rpcs.create_tag if parent_rpcs.respond_to? :create_tag
                    @create_tag = ::Gapic::Config::Method.new create_tag_config
                    update_tag_config = parent_rpcs.update_tag if parent_rpcs.respond_to? :update_tag
                    @update_tag = ::Gapic::Config::Method.new update_tag_config
                    delete_tag_config = parent_rpcs.delete_tag if parent_rpcs.respond_to? :delete_tag
                    @delete_tag = ::Gapic::Config::Method.new delete_tag_config
                    list_tags_config = parent_rpcs.list_tags if parent_rpcs.respond_to? :list_tags
                    @list_tags = ::Gapic::Config::Method.new list_tags_config
                    reconcile_tags_config = parent_rpcs.reconcile_tags if parent_rpcs.respond_to? :reconcile_tags
                    @reconcile_tags = ::Gapic::Config::Method.new reconcile_tags_config
                    star_entry_config = parent_rpcs.star_entry if parent_rpcs.respond_to? :star_entry
                    @star_entry = ::Gapic::Config::Method.new star_entry_config
                    unstar_entry_config = parent_rpcs.unstar_entry if parent_rpcs.respond_to? :unstar_entry
                    @unstar_entry = ::Gapic::Config::Method.new unstar_entry_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    import_entries_config = parent_rpcs.import_entries if parent_rpcs.respond_to? :import_entries
                    @import_entries = ::Gapic::Config::Method.new import_entries_config
                    set_config_config = parent_rpcs.set_config if parent_rpcs.respond_to? :set_config
                    @set_config = ::Gapic::Config::Method.new set_config_config
                    retrieve_config_config = parent_rpcs.retrieve_config if parent_rpcs.respond_to? :retrieve_config
                    @retrieve_config = ::Gapic::Config::Method.new retrieve_config_config
                    retrieve_effective_config_config = parent_rpcs.retrieve_effective_config if parent_rpcs.respond_to? :retrieve_effective_config
                    @retrieve_effective_config = ::Gapic::Config::Method.new retrieve_effective_config_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
