# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/datacatalog/lineage/v1/lineage_pb"
require "google/cloud/data_catalog/lineage/v1/lineage"

class ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_process_open_lineage_run_event
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    open_lineage = {}
    request_id = "hello world"

    process_open_lineage_run_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :process_open_lineage_run_event, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Struct), request["open_lineage"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, process_open_lineage_run_event_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.process_open_lineage_run_event({ parent: parent, open_lineage: open_lineage, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.process_open_lineage_run_event parent: parent, open_lineage: open_lineage, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.process_open_lineage_run_event ::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest.new(parent: parent, open_lineage: open_lineage, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.process_open_lineage_run_event({ parent: parent, open_lineage: open_lineage, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.process_open_lineage_run_event(::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest.new(parent: parent, open_lineage: open_lineage, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, process_open_lineage_run_event_client_stub.call_rpc_count
    end
  end

  def test_create_process
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::Process.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    process = {}
    request_id = "hello world"

    create_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_process, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataCatalog::Lineage::V1::Process), request["process"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_process_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_process({ parent: parent, process: process, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_process parent: parent, process: process, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_process ::Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest.new(parent: parent, process: process, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_process({ parent: parent, process: process, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_process(::Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest.new(parent: parent, process: process, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_process_client_stub.call_rpc_count
    end
  end

  def test_update_process
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::Process.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    process = {}
    update_mask = {}
    allow_missing = true

    update_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_process, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataCatalog::Lineage::V1::Process), request["process"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_process_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_process({ process: process, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_process process: process, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_process ::Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest.new(process: process, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_process({ process: process, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_process(::Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest.new(process: process, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_process_client_stub.call_rpc_count
    end
  end

  def test_get_process
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::Process.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_process, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_process_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_process({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_process name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_process ::Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_process({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_process(::Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_process_client_stub.call_rpc_count
    end
  end

  def test_list_processes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_processes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_processes, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_processes_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_processes({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_processes parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_processes ::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_processes({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_processes(::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_processes_client_stub.call_rpc_count
    end
  end

  def test_delete_process
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_process, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_process_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_process({ name: name, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_process name: name, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_process ::Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest.new(name: name, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_process({ name: name, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_process(::Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest.new(name: name, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_process_client_stub.call_rpc_count
    end
  end

  def test_create_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::Run.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    run = {}
    request_id = "hello world"

    create_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_run, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataCatalog::Lineage::V1::Run), request["run"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_run_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_run({ parent: parent, run: run, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_run parent: parent, run: run, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_run ::Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest.new(parent: parent, run: run, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_run({ parent: parent, run: run, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_run(::Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest.new(parent: parent, run: run, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_run_client_stub.call_rpc_count
    end
  end

  def test_update_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::Run.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    run = {}
    update_mask = {}
    allow_missing = true

    update_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_run, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataCatalog::Lineage::V1::Run), request["run"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_run_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_run({ run: run, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_run run: run, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_run ::Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest.new(run: run, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_run({ run: run, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_run(::Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest.new(run: run, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_run_client_stub.call_rpc_count
    end
  end

  def test_get_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::Run.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_run, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_run_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_run({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_run name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_run ::Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_run({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_run(::Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_run_client_stub.call_rpc_count
    end
  end

  def test_list_runs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::ListRunsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_runs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_runs, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_runs_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_runs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_runs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_runs ::Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_runs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_runs(::Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_runs_client_stub.call_rpc_count
    end
  end

  def test_delete_run
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_run, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_run_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_run({ name: name, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_run name: name, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_run ::Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest.new(name: name, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_run({ name: name, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_run(::Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest.new(name: name, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_run_client_stub.call_rpc_count
    end
  end

  def test_create_lineage_event
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    lineage_event = {}
    request_id = "hello world"

    create_lineage_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_lineage_event, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent), request["lineage_event"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_lineage_event_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_lineage_event({ parent: parent, lineage_event: lineage_event, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_lineage_event parent: parent, lineage_event: lineage_event, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_lineage_event ::Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest.new(parent: parent, lineage_event: lineage_event, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_lineage_event({ parent: parent, lineage_event: lineage_event, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_lineage_event(::Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest.new(parent: parent, lineage_event: lineage_event, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_lineage_event_client_stub.call_rpc_count
    end
  end

  def test_get_lineage_event
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_lineage_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_lineage_event, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_lineage_event_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_lineage_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_lineage_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_lineage_event ::Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_lineage_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_lineage_event(::Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_lineage_event_client_stub.call_rpc_count
    end
  end

  def test_list_lineage_events
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_lineage_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_lineage_events, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_lineage_events_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_lineage_events({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_lineage_events parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_lineage_events ::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_lineage_events({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_lineage_events(::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_lineage_events_client_stub.call_rpc_count
    end
  end

  def test_delete_lineage_event
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_lineage_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_lineage_event, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_lineage_event_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_lineage_event({ name: name, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_lineage_event name: name, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_lineage_event ::Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest.new(name: name, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_lineage_event({ name: name, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_lineage_event(::Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest.new(name: name, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_lineage_event_client_stub.call_rpc_count
    end
  end

  def test_search_links
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source = {}
    page_size = 42
    page_token = "hello world"

    search_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_links, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataCatalog::Lineage::V1::EntityReference), request["source"]
      assert_equal :source, request.criteria
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_links_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_links({ parent: parent, source: source, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_links parent: parent, source: source, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_links ::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest.new(parent: parent, source: source, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_links({ parent: parent, source: source, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_links(::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest.new(parent: parent, source: source, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_links_client_stub.call_rpc_count
    end
  end

  def test_batch_search_link_processes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    links = ["hello world"]
    page_size = 42
    page_token = "hello world"

    batch_search_link_processes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_search_link_processes, name
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["links"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_search_link_processes_client_stub do
      # Create client
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_search_link_processes({ parent: parent, links: links, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_search_link_processes parent: parent, links: links, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_search_link_processes ::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest.new(parent: parent, links: links, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_search_link_processes({ parent: parent, links: links, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_search_link_processes(::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest.new(parent: parent, links: links, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_search_link_processes_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Operations, client.operations_client
  end
end
