# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/datacatalog/lineage/v1/lineage_pb"
require "google/cloud/data_catalog/lineage/v1/lineage/rest"


class ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_process_open_lineage_run_event
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    open_lineage = {}
    request_id = "hello world"

    process_open_lineage_run_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_process_open_lineage_run_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, process_open_lineage_run_event_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.process_open_lineage_run_event({ parent: parent, open_lineage: open_lineage, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.process_open_lineage_run_event parent: parent, open_lineage: open_lineage, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.process_open_lineage_run_event ::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest.new(parent: parent, open_lineage: open_lineage, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.process_open_lineage_run_event({ parent: parent, open_lineage: open_lineage, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.process_open_lineage_run_event(::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest.new(parent: parent, open_lineage: open_lineage, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, process_open_lineage_run_event_client_stub.call_count
      end
    end
  end

  def test_create_process
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::Process.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    process = {}
    request_id = "hello world"

    create_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_create_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_process_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_process({ parent: parent, process: process, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_process parent: parent, process: process, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_process ::Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest.new(parent: parent, process: process, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_process({ parent: parent, process: process, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_process(::Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest.new(parent: parent, process: process, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_process_client_stub.call_count
      end
    end
  end

  def test_update_process
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::Process.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    process = {}
    update_mask = {}
    allow_missing = true

    update_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_update_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_process_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_process({ process: process, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_process process: process, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_process ::Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest.new(process: process, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_process({ process: process, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_process(::Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest.new(process: process, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_process_client_stub.call_count
      end
    end
  end

  def test_get_process
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::Process.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_get_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_process_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_process({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_process name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_process ::Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_process({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_process(::Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_process_client_stub.call_count
      end
    end
  end

  def test_list_processes
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_processes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_list_processes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_processes_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_processes({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_processes parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_processes ::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_processes({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_processes(::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_processes_client_stub.call_count
      end
    end
  end

  def test_delete_process
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_delete_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_process_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_process({ name: name, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_process name: name, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_process ::Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest.new(name: name, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_process({ name: name, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_process(::Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest.new(name: name, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_process_client_stub.call_count
      end
    end
  end

  def test_create_run
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::Run.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    run = {}
    request_id = "hello world"

    create_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_create_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_run_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_run({ parent: parent, run: run, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_run parent: parent, run: run, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_run ::Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest.new(parent: parent, run: run, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_run({ parent: parent, run: run, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_run(::Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest.new(parent: parent, run: run, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_run_client_stub.call_count
      end
    end
  end

  def test_update_run
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::Run.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    run = {}
    update_mask = {}
    allow_missing = true

    update_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_update_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_run_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_run({ run: run, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_run run: run, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_run ::Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest.new(run: run, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_run({ run: run, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_run(::Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest.new(run: run, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_run_client_stub.call_count
      end
    end
  end

  def test_get_run
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::Run.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_get_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_run_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_run ::Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_run(::Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_run_client_stub.call_count
      end
    end
  end

  def test_list_runs
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::ListRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_list_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_runs_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_runs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_runs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_runs ::Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_runs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_runs(::Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_runs_client_stub.call_count
      end
    end
  end

  def test_delete_run
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_delete_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_run_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_run({ name: name, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_run name: name, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_run ::Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest.new(name: name, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_run({ name: name, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_run(::Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest.new(name: name, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_run_client_stub.call_count
      end
    end
  end

  def test_create_lineage_event
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    lineage_event = {}
    request_id = "hello world"

    create_lineage_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_create_lineage_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_lineage_event_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_lineage_event({ parent: parent, lineage_event: lineage_event, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_lineage_event parent: parent, lineage_event: lineage_event, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_lineage_event ::Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest.new(parent: parent, lineage_event: lineage_event, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_lineage_event({ parent: parent, lineage_event: lineage_event, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_lineage_event(::Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest.new(parent: parent, lineage_event: lineage_event, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_lineage_event_client_stub.call_count
      end
    end
  end

  def test_get_lineage_event
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_lineage_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_get_lineage_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_lineage_event_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_lineage_event({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_lineage_event name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_lineage_event ::Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_lineage_event({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_lineage_event(::Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_lineage_event_client_stub.call_count
      end
    end
  end

  def test_list_lineage_events
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_lineage_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_list_lineage_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_lineage_events_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_lineage_events({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_lineage_events parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_lineage_events ::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_lineage_events({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_lineage_events(::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_lineage_events_client_stub.call_count
      end
    end
  end

  def test_delete_lineage_event
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true

    delete_lineage_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_delete_lineage_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_lineage_event_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_lineage_event({ name: name, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_lineage_event name: name, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_lineage_event ::Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest.new(name: name, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_lineage_event({ name: name, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_lineage_event(::Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest.new(name: name, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_lineage_event_client_stub.call_count
      end
    end
  end

  def test_search_links
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source = {}
    page_size = 42
    page_token = "hello world"

    search_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_search_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_links_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_links({ parent: parent, source: source, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_links parent: parent, source: source, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_links ::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest.new(parent: parent, source: source, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_links({ parent: parent, source: source, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_links(::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest.new(parent: parent, source: source, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_links_client_stub.call_count
      end
    end
  end

  def test_batch_search_link_processes
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    links = ["hello world"]
    page_size = 42
    page_token = "hello world"

    batch_search_link_processes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::ServiceStub.stub :transcode_batch_search_link_processes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_search_link_processes_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_search_link_processes({ parent: parent, links: links, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_search_link_processes parent: parent, links: links, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_search_link_processes ::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest.new(parent: parent, links: links, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_search_link_processes({ parent: parent, links: links, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_search_link_processes(::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest.new(parent: parent, links: links, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_search_link_processes_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client::Configuration, config
  end
end
