# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataCatalog
      module Lineage
        module V1
          module Lineage
            # Path helper methods for the Lineage API.
            module Paths
              ##
              # Create a fully-qualified LineageEvent resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`
              #
              # @param project [String]
              # @param location [String]
              # @param process [String]
              # @param run [String]
              # @param lineage_event [String]
              #
              # @return [::String]
              def lineage_event_path project:, location:, process:, run:, lineage_event:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "process cannot contain /" if process.to_s.include? "/"
                raise ::ArgumentError, "run cannot contain /" if run.to_s.include? "/"

                "projects/#{project}/locations/#{location}/processes/#{process}/runs/#{run}/lineageEvents/#{lineage_event}"
              end

              ##
              # Create a fully-qualified Location resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}`
              #
              # @param project [String]
              # @param location [String]
              #
              # @return [::String]
              def location_path project:, location:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/locations/#{location}"
              end

              ##
              # Create a fully-qualified Process resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/processes/{process}`
              #
              # @param project [String]
              # @param location [String]
              # @param process [String]
              #
              # @return [::String]
              def process_path project:, location:, process:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/processes/#{process}"
              end

              ##
              # Create a fully-qualified Run resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/processes/{process}/runs/{run}`
              #
              # @param project [String]
              # @param location [String]
              # @param process [String]
              # @param run [String]
              #
              # @return [::String]
              def run_path project:, location:, process:, run:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "process cannot contain /" if process.to_s.include? "/"

                "projects/#{project}/locations/#{location}/processes/#{process}/runs/#{run}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
