# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/datacatalog/lineage/v1/lineage_pb"

module Google
  module Cloud
    module DataCatalog
      module Lineage
        module V1
          module Lineage
            ##
            # Client for the Lineage service.
            #
            # Lineage is used to track data flows between assets over time. You can
            # create {::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent LineageEvents}
            # to record lineage between multiple sources and a single target, for
            # example, when table data is based on data from multiple tables.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "datalineage.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :lineage_stub

              ##
              # Configure the Lineage Client class.
              #
              # See {::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Lineage clients
              #   ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "DataCatalog", "Lineage", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Lineage Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @lineage_stub.universe_domain
              end

              ##
              # Create a new Lineage client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Lineage client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/datacatalog/lineage/v1/lineage_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @lineage_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @lineage_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @lineage_stub.logger
              end

              # Service calls

              ##
              # Creates new lineage events together with their parents: process and run.
              # Updates the process and run if they already exist.
              # Mapped from Open Lineage specification:
              # https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json.
              #
              # @overload process_open_lineage_run_event(request, options = nil)
              #   Pass arguments to `process_open_lineage_run_event` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload process_open_lineage_run_event(parent: nil, open_lineage: nil, request_id: nil)
              #   Pass arguments to `process_open_lineage_run_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the project and its location that should own the
              #     process, run, and lineage event.
              #   @param open_lineage [::Google::Protobuf::Struct, ::Hash]
              #     Required. OpenLineage message following OpenLineage format:
              #     https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json
              #   @param request_id [::String]
              #     A unique identifier for this request. Restricted to 36 ASCII characters.
              #     A random UUID is recommended. This request is idempotent only if a
              #     `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest.new
              #
              #   # Call the process_open_lineage_run_event method.
              #   result = client.process_open_lineage_run_event request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventResponse.
              #   p result
              #
              def process_open_lineage_run_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::ProcessOpenLineageRunEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.process_open_lineage_run_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.process_open_lineage_run_event.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.process_open_lineage_run_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :process_open_lineage_run_event, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new process.
              #
              # @overload create_process(request, options = nil)
              #   Pass arguments to `create_process` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_process(parent: nil, process: nil, request_id: nil)
              #   Pass arguments to `create_process` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the project and its location that should own the
              #     process.
              #   @param process [::Google::Cloud::DataCatalog::Lineage::V1::Process, ::Hash]
              #     Required. The process to create.
              #   @param request_id [::String]
              #     A unique identifier for this request. Restricted to 36 ASCII characters.
              #     A random UUID is recommended. This request is idempotent only if a
              #     `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::Process]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::Process]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest.new
              #
              #   # Call the create_process method.
              #   result = client.create_process request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::Process.
              #   p result
              #
              def create_process request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::CreateProcessRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_process.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_process.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_process.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :create_process, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a process.
              #
              # @overload update_process(request, options = nil)
              #   Pass arguments to `update_process` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_process(process: nil, update_mask: nil, allow_missing: nil)
              #   Pass arguments to `update_process` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param process [::Google::Cloud::DataCatalog::Lineage::V1::Process, ::Hash]
              #     Required. The lineage process to update.
              #
              #     The process's `name` field is used to identify the process to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to update. Currently not used. The whole message is
              #     updated.
              #   @param allow_missing [::Boolean]
              #     If set to true and the process is not found, the request inserts it.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::Process]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::Process]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest.new
              #
              #   # Call the update_process method.
              #   result = client.update_process request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::Process.
              #   p result
              #
              def update_process request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::UpdateProcessRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_process.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.process&.name
                  header_params["process.name"] = request.process.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_process.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_process.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :update_process, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of the specified process.
              #
              # @overload get_process(request, options = nil)
              #   Pass arguments to `get_process` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_process(name: nil)
              #   Pass arguments to `get_process` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the process to get.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::Process]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::Process]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest.new
              #
              #   # Call the get_process method.
              #   result = client.get_process request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::Process.
              #   p result
              #
              def get_process request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::GetProcessRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_process.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_process.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_process.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :get_process, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List processes in the given project and location. List order is descending
              # by insertion time.
              #
              # @overload list_processes(request, options = nil)
              #   Pass arguments to `list_processes` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_processes(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_processes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the project and its location that owns this
              #     collection of processes.
              #   @param page_size [::Integer]
              #     The maximum number of processes to return. The service may return
              #     fewer than this value. If unspecified, at most 50 processes are
              #     returned. The maximum value is 100; values greater than 100 are cut to
              #     100.
              #   @param page_token [::String]
              #     The page token received from a previous `ListProcesses` call. Specify
              #     it to get the next page.
              #
              #     When paginating, all other parameters specified in this call must
              #     match the parameters of the call that provided the page token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::Process>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::Process>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest.new
              #
              #   # Call the list_processes method.
              #   result = client.list_processes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::Lineage::V1::Process.
              #     p item
              #   end
              #
              def list_processes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::ListProcessesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_processes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_processes.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_processes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :list_processes, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @lineage_stub, :list_processes, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the process with the specified name.
              #
              # @overload delete_process(request, options = nil)
              #   Pass arguments to `delete_process` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_process(name: nil, allow_missing: nil)
              #   Pass arguments to `delete_process` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the process to delete.
              #   @param allow_missing [::Boolean]
              #     If set to true and the process is not found, the request
              #     succeeds but the server doesn't perform any actions.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest.new
              #
              #   # Call the delete_process method.
              #   result = client.delete_process request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_process request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::DeleteProcessRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_process.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_process.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_process.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :delete_process, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new run.
              #
              # @overload create_run(request, options = nil)
              #   Pass arguments to `create_run` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_run(parent: nil, run: nil, request_id: nil)
              #   Pass arguments to `create_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the process that should own the run.
              #   @param run [::Google::Cloud::DataCatalog::Lineage::V1::Run, ::Hash]
              #     Required. The run to create.
              #   @param request_id [::String]
              #     A unique identifier for this request. Restricted to 36 ASCII characters.
              #     A random UUID is recommended. This request is idempotent only if a
              #     `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::Run]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::Run]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest.new
              #
              #   # Call the create_run method.
              #   result = client.create_run request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::Run.
              #   p result
              #
              def create_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::CreateRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_run.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :create_run, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a run.
              #
              # @overload update_run(request, options = nil)
              #   Pass arguments to `update_run` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_run(run: nil, update_mask: nil, allow_missing: nil)
              #   Pass arguments to `update_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param run [::Google::Cloud::DataCatalog::Lineage::V1::Run, ::Hash]
              #     Required. The lineage run to update.
              #
              #     The run's `name` field is used to identify the run to update.
              #
              #     Format:
              #     `projects/{project}/locations/{location}/processes/{process}/runs/{run}`.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to update. Currently not used. The whole message is
              #     updated.
              #   @param allow_missing [::Boolean]
              #     If set to true and the run is not found, the request creates it.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::Run]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::Run]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest.new
              #
              #   # Call the update_run method.
              #   result = client.update_run request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::Run.
              #   p result
              #
              def update_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::UpdateRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.run&.name
                  header_params["run.name"] = request.run.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_run.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :update_run, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of the specified run.
              #
              # @overload get_run(request, options = nil)
              #   Pass arguments to `get_run` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_run(name: nil)
              #   Pass arguments to `get_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the run to get.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::Run]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::Run]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest.new
              #
              #   # Call the get_run method.
              #   result = client.get_run request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::Run.
              #   p result
              #
              def get_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::GetRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_run.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :get_run, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists runs in the given project and location. List order is descending by
              # `start_time`.
              #
              # @overload list_runs(request, options = nil)
              #   Pass arguments to `list_runs` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_runs(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_runs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of process that owns this collection of runs.
              #   @param page_size [::Integer]
              #     The maximum number of runs to return. The service may return
              #     fewer than this value. If unspecified, at most 50 runs are
              #     returned. The maximum value is 100; values greater than 100 are cut to
              #     100.
              #   @param page_token [::String]
              #     The page token received from a previous `ListRuns` call. Specify
              #     it to get the next page.
              #
              #     When paginating, all other parameters specified in this call must
              #     match the parameters of the call that provided the page token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::Run>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::Run>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest.new
              #
              #   # Call the list_runs method.
              #   result = client.list_runs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::Lineage::V1::Run.
              #     p item
              #   end
              #
              def list_runs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::ListRunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_runs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_runs.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_runs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :list_runs, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @lineage_stub, :list_runs, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the run with the specified name.
              #
              # @overload delete_run(request, options = nil)
              #   Pass arguments to `delete_run` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_run(name: nil, allow_missing: nil)
              #   Pass arguments to `delete_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the run to delete.
              #   @param allow_missing [::Boolean]
              #     If set to true and the run is not found, the request
              #     succeeds but the server doesn't perform any actions.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest.new
              #
              #   # Call the delete_run method.
              #   result = client.delete_run request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::DeleteRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_run.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :delete_run, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new lineage event.
              #
              # @overload create_lineage_event(request, options = nil)
              #   Pass arguments to `create_lineage_event` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_lineage_event(parent: nil, lineage_event: nil, request_id: nil)
              #   Pass arguments to `create_lineage_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the run that should own the lineage event.
              #   @param lineage_event [::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent, ::Hash]
              #     Required. The lineage event to create.
              #   @param request_id [::String]
              #     A unique identifier for this request. Restricted to 36 ASCII characters.
              #     A random UUID is recommended. This request is idempotent only if a
              #     `request_id` is provided.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest.new
              #
              #   # Call the create_lineage_event method.
              #   result = client.create_lineage_event request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::LineageEvent.
              #   p result
              #
              def create_lineage_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::CreateLineageEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_lineage_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_lineage_event.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_lineage_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :create_lineage_event, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a specified lineage event.
              #
              # @overload get_lineage_event(request, options = nil)
              #   Pass arguments to `get_lineage_event` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_lineage_event(name: nil)
              #   Pass arguments to `get_lineage_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the lineage event to get.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest.new
              #
              #   # Call the get_lineage_event method.
              #   result = client.get_lineage_event request
              #
              #   # The returned object is of type Google::Cloud::DataCatalog::Lineage::V1::LineageEvent.
              #   p result
              #
              def get_lineage_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::GetLineageEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_lineage_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_lineage_event.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_lineage_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :get_lineage_event, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists lineage events in the given project and location. The list order is
              # not defined.
              #
              # @overload list_lineage_events(request, options = nil)
              #   Pass arguments to `list_lineage_events` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_lineage_events(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_lineage_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the run that owns the collection of lineage events to
              #     get.
              #   @param page_size [::Integer]
              #     The maximum number of lineage events to return.
              #
              #     The service may return fewer events than this value.
              #     If unspecified, at most 50 events are returned. The maximum value is 100;
              #     values greater than 100 are cut to 100.
              #   @param page_token [::String]
              #     The page token received from a previous `ListLineageEvents` call. Specify
              #     it to get the next page.
              #
              #     When paginating, all other parameters specified in this call must
              #     match the parameters of the call that provided the page token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest.new
              #
              #   # Call the list_lineage_events method.
              #   result = client.list_lineage_events request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent.
              #     p item
              #   end
              #
              def list_lineage_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::ListLineageEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_lineage_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_lineage_events.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_lineage_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :list_lineage_events, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @lineage_stub, :list_lineage_events, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the lineage event with the specified name.
              #
              # @overload delete_lineage_event(request, options = nil)
              #   Pass arguments to `delete_lineage_event` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_lineage_event(name: nil, allow_missing: nil)
              #   Pass arguments to `delete_lineage_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the lineage event to delete.
              #   @param allow_missing [::Boolean]
              #     If set to true and the lineage event is not found, the request
              #     succeeds but the server doesn't perform any actions.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest.new
              #
              #   # Call the delete_lineage_event method.
              #   result = client.delete_lineage_event request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_lineage_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::DeleteLineageEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_lineage_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_lineage_event.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_lineage_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :delete_lineage_event, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieve a list of links connected to a specific asset.
              # Links represent the data flow between **source** (upstream)
              # and **target** (downstream) assets in transformation pipelines.
              # Links are stored in the same project as the Lineage Events that create
              # them.
              #
              # You can retrieve links in every project where you have the
              # `datalineage.events.get` permission. The project provided in the URL
              # is used for Billing and Quota.
              #
              # @overload search_links(request, options = nil)
              #   Pass arguments to `search_links` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload search_links(parent: nil, source: nil, target: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `search_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location you want search in.
              #   @param source [::Google::Cloud::DataCatalog::Lineage::V1::EntityReference, ::Hash]
              #     Optional. Send asset information in the **source** field to retrieve all
              #     links that lead from the specified asset to downstream assets.
              #
              #     Note: The following parameters are mutually exclusive: `source`, `target`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param target [::Google::Cloud::DataCatalog::Lineage::V1::EntityReference, ::Hash]
              #     Optional. Send asset information in the **target** field to retrieve all
              #     links that lead from upstream assets to the specified asset.
              #
              #     Note: The following parameters are mutually exclusive: `target`, `source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of links to return in a single page of the
              #     response. A page may contain fewer links than this value. If unspecified,
              #     at most 10 links are returned.
              #
              #     Maximum value is 100; values greater than 100 are reduced to 100.
              #   @param page_token [::String]
              #     Optional. The page token received from a previous `SearchLinksRequest`
              #     call. Use it to get the next page.
              #
              #     When requesting subsequent pages of a response, remember that
              #     all parameters must match the values you provided
              #     in the original request.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::Link>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::Link>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest.new
              #
              #   # Call the search_links method.
              #   result = client.search_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::Lineage::V1::Link.
              #     p item
              #   end
              #
              def search_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::SearchLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.search_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.search_links.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.search_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :search_links, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @lineage_stub, :search_links, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieve information about LineageProcesses associated with specific
              # links. LineageProcesses are transformation pipelines that result in data
              # flowing from **source** to **target** assets. Links between assets
              # represent this operation.
              #
              # If you have specific link names, you can use this method to
              # verify which LineageProcesses contribute to creating those links.
              # See the
              # {::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client#search_links SearchLinks}
              # method for more information on how to retrieve link name.
              #
              # You can retrieve the LineageProcess information in every project where you
              # have the `datalineage.events.get` permission. The project provided in the
              # URL is used for Billing and Quota.
              #
              # @overload batch_search_link_processes(request, options = nil)
              #   Pass arguments to `batch_search_link_processes` via a request object, either of type
              #   {::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload batch_search_link_processes(parent: nil, links: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `batch_search_link_processes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location where you want to search.
              #   @param links [::Array<::String>]
              #     Required. An array of links to check for their associated LineageProcesses.
              #
              #     The maximum number of items in this array is 100.
              #     If the request contains more than 100 links, it returns the
              #     `INVALID_ARGUMENT` error.
              #
              #     Format: `projects/{project}/locations/{location}/links/{link}`.
              #   @param page_size [::Integer]
              #     The maximum number of processes to return in a single page of the response.
              #     A page may contain fewer results than this value.
              #   @param page_token [::String]
              #     The page token received from a previous `BatchSearchLinkProcesses` call.
              #     Use it to get the next page.
              #
              #     When requesting subsequent pages of a response, remember that
              #     all parameters must match the values you provided
              #     in the original request.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::ProcessLinks>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::Lineage::V1::ProcessLinks>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/data_catalog/lineage/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest.new
              #
              #   # Call the batch_search_link_processes method.
              #   result = client.batch_search_link_processes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DataCatalog::Lineage::V1::ProcessLinks.
              #     p item
              #   end
              #
              def batch_search_link_processes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::Lineage::V1::BatchSearchLinkProcessesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.batch_search_link_processes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DataCatalog::Lineage::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.batch_search_link_processes.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.batch_search_link_processes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @lineage_stub.call_rpc :batch_search_link_processes, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @lineage_stub, :batch_search_link_processes, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Lineage API.
              #
              # This class represents the configuration for Lineage,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # process_open_lineage_run_event to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.process_open_lineage_run_event.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.process_open_lineage_run_event.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "datalineage.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the Lineage API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `process_open_lineage_run_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :process_open_lineage_run_event
                  ##
                  # RPC-specific configuration for `create_process`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_process
                  ##
                  # RPC-specific configuration for `update_process`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_process
                  ##
                  # RPC-specific configuration for `get_process`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_process
                  ##
                  # RPC-specific configuration for `list_processes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_processes
                  ##
                  # RPC-specific configuration for `delete_process`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_process
                  ##
                  # RPC-specific configuration for `create_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_run
                  ##
                  # RPC-specific configuration for `update_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_run
                  ##
                  # RPC-specific configuration for `get_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_run
                  ##
                  # RPC-specific configuration for `list_runs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_runs
                  ##
                  # RPC-specific configuration for `delete_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_run
                  ##
                  # RPC-specific configuration for `create_lineage_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_lineage_event
                  ##
                  # RPC-specific configuration for `get_lineage_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_lineage_event
                  ##
                  # RPC-specific configuration for `list_lineage_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_lineage_events
                  ##
                  # RPC-specific configuration for `delete_lineage_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_lineage_event
                  ##
                  # RPC-specific configuration for `search_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_links
                  ##
                  # RPC-specific configuration for `batch_search_link_processes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_search_link_processes

                  # @private
                  def initialize parent_rpcs = nil
                    process_open_lineage_run_event_config = parent_rpcs.process_open_lineage_run_event if parent_rpcs.respond_to? :process_open_lineage_run_event
                    @process_open_lineage_run_event = ::Gapic::Config::Method.new process_open_lineage_run_event_config
                    create_process_config = parent_rpcs.create_process if parent_rpcs.respond_to? :create_process
                    @create_process = ::Gapic::Config::Method.new create_process_config
                    update_process_config = parent_rpcs.update_process if parent_rpcs.respond_to? :update_process
                    @update_process = ::Gapic::Config::Method.new update_process_config
                    get_process_config = parent_rpcs.get_process if parent_rpcs.respond_to? :get_process
                    @get_process = ::Gapic::Config::Method.new get_process_config
                    list_processes_config = parent_rpcs.list_processes if parent_rpcs.respond_to? :list_processes
                    @list_processes = ::Gapic::Config::Method.new list_processes_config
                    delete_process_config = parent_rpcs.delete_process if parent_rpcs.respond_to? :delete_process
                    @delete_process = ::Gapic::Config::Method.new delete_process_config
                    create_run_config = parent_rpcs.create_run if parent_rpcs.respond_to? :create_run
                    @create_run = ::Gapic::Config::Method.new create_run_config
                    update_run_config = parent_rpcs.update_run if parent_rpcs.respond_to? :update_run
                    @update_run = ::Gapic::Config::Method.new update_run_config
                    get_run_config = parent_rpcs.get_run if parent_rpcs.respond_to? :get_run
                    @get_run = ::Gapic::Config::Method.new get_run_config
                    list_runs_config = parent_rpcs.list_runs if parent_rpcs.respond_to? :list_runs
                    @list_runs = ::Gapic::Config::Method.new list_runs_config
                    delete_run_config = parent_rpcs.delete_run if parent_rpcs.respond_to? :delete_run
                    @delete_run = ::Gapic::Config::Method.new delete_run_config
                    create_lineage_event_config = parent_rpcs.create_lineage_event if parent_rpcs.respond_to? :create_lineage_event
                    @create_lineage_event = ::Gapic::Config::Method.new create_lineage_event_config
                    get_lineage_event_config = parent_rpcs.get_lineage_event if parent_rpcs.respond_to? :get_lineage_event
                    @get_lineage_event = ::Gapic::Config::Method.new get_lineage_event_config
                    list_lineage_events_config = parent_rpcs.list_lineage_events if parent_rpcs.respond_to? :list_lineage_events
                    @list_lineage_events = ::Gapic::Config::Method.new list_lineage_events_config
                    delete_lineage_event_config = parent_rpcs.delete_lineage_event if parent_rpcs.respond_to? :delete_lineage_event
                    @delete_lineage_event = ::Gapic::Config::Method.new delete_lineage_event_config
                    search_links_config = parent_rpcs.search_links if parent_rpcs.respond_to? :search_links
                    @search_links = ::Gapic::Config::Method.new search_links_config
                    batch_search_link_processes_config = parent_rpcs.batch_search_link_processes if parent_rpcs.respond_to? :batch_search_link_processes
                    @batch_search_link_processes = ::Gapic::Config::Method.new batch_search_link_processes_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
