# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/data_catalog/lineage/v1/version"

require "google/cloud/data_catalog/lineage/v1/lineage/credentials"
require "google/cloud/data_catalog/lineage/v1/lineage/paths"
require "google/cloud/data_catalog/lineage/v1/lineage/operations"
require "google/cloud/data_catalog/lineage/v1/lineage/client"
require "google/cloud/data_catalog/lineage/v1/lineage/rest"

module Google
  module Cloud
    module DataCatalog
      module Lineage
        module V1
          ##
          # Lineage is used to track data flows between assets over time. You can
          # create {::Google::Cloud::DataCatalog::Lineage::V1::LineageEvent LineageEvents}
          # to record lineage between multiple sources and a single target, for
          # example, when table data is based on data from multiple tables.
          #
          # @example Load this service and instantiate a gRPC client
          #
          #     require "google/cloud/data_catalog/lineage/v1/lineage"
          #     client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Client.new
          #
          # @example Load this service and instantiate a REST client
          #
          #     require "google/cloud/data_catalog/lineage/v1/lineage/rest"
          #     client = ::Google::Cloud::DataCatalog::Lineage::V1::Lineage::Rest::Client.new
          #
          module Lineage
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "lineage", "helpers.rb"
require "google/cloud/data_catalog/lineage/v1/lineage/helpers" if ::File.file? helper_path
