# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/devtools/containeranalysis/v1/containeranalysis.proto for package 'Google.Cloud.ContainerAnalysis.V1'
# Original file comments:
# Copyright 2019 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/devtools/containeranalysis/v1/containeranalysis_pb'

module Google
  module Cloud
    module ContainerAnalysis
      module V1
        module ContainerAnalysis
          # Retrieves analysis results of Cloud components such as Docker container
          # images. The Container Analysis API is an implementation of the
          # [Grafeas](https://grafeas.io) API.
          #
          # Analysis results are stored as a series of occurrences. An `Occurrence`
          # contains information about a specific analysis instance on a resource. An
          # occurrence refers to a `Note`. A note contains details describing the
          # analysis and is generally stored in a separate project, called a `Provider`.
          # Multiple occurrences can refer to the same note.
          #
          # For example, an SSL vulnerability could affect multiple images. In this case,
          # there would be one note for the vulnerability and an occurrence for each
          # image with the vulnerability referring to that note.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.devtools.containeranalysis.v1.ContainerAnalysis'

            # Sets the access control policy on the specified note or occurrence.
            # Requires `containeranalysis.notes.setIamPolicy` or
            # `containeranalysis.occurrences.setIamPolicy` permission if the resource is
            # a note or an occurrence, respectively.
            #
            # The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
            # notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
            # occurrences.
            rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Gets the access control policy for a note or an occurrence resource.
            # Requires `containeranalysis.notes.setIamPolicy` or
            # `containeranalysis.occurrences.setIamPolicy` permission if the resource is
            # a note or occurrence, respectively.
            #
            # The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
            # notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
            # occurrences.
            rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Returns the permissions that a caller has on the specified note or
            # occurrence. Requires list permission on the project (for example,
            # `containeranalysis.notes.list`).
            #
            # The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
            # notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
            # occurrences.
            rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
            # Gets a summary of the number and severity of occurrences.
            rpc :GetVulnerabilityOccurrencesSummary, ::Google::Cloud::ContainerAnalysis::V1::GetVulnerabilityOccurrencesSummaryRequest, ::Google::Cloud::ContainerAnalysis::V1::VulnerabilityOccurrencesSummary
            # Generates an SBOM for the given resource.
            rpc :ExportSBOM, ::Google::Cloud::ContainerAnalysis::V1::ExportSBOMRequest, ::Google::Cloud::ContainerAnalysis::V1::ExportSBOMResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
