# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/container/v1/cluster_service_pb"
require "google/cloud/container/v1/cluster_manager/rest"


class ::Google::Cloud::Container::V1::ClusterManager::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_clusters
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::ListClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    parent = "hello world"

    list_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_list_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_clusters({ project_id: project_id, zone: zone, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_clusters project_id: project_id, zone: zone, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_clusters ::Google::Cloud::Container::V1::ListClustersRequest.new(project_id: project_id, zone: zone, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_clusters({ project_id: project_id, zone: zone, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_clusters(::Google::Cloud::Container::V1::ListClustersRequest.new(project_id: project_id, zone: zone, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_clusters_client_stub.call_count
      end
    end
  end

  def test_get_cluster
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Cluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    name = "hello world"

    get_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_get_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_cluster({ project_id: project_id, zone: zone, cluster_id: cluster_id, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_cluster project_id: project_id, zone: zone, cluster_id: cluster_id, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_cluster ::Google::Cloud::Container::V1::GetClusterRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_cluster({ project_id: project_id, zone: zone, cluster_id: cluster_id, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_cluster(::Google::Cloud::Container::V1::GetClusterRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_cluster_client_stub.call_count
      end
    end
  end

  def test_create_cluster
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster = {}
    parent = "hello world"

    create_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_create_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_cluster({ project_id: project_id, zone: zone, cluster: cluster, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_cluster project_id: project_id, zone: zone, cluster: cluster, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_cluster ::Google::Cloud::Container::V1::CreateClusterRequest.new(project_id: project_id, zone: zone, cluster: cluster, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_cluster({ project_id: project_id, zone: zone, cluster: cluster, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_cluster(::Google::Cloud::Container::V1::CreateClusterRequest.new(project_id: project_id, zone: zone, cluster: cluster, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_cluster_client_stub.call_count
      end
    end
  end

  def test_update_cluster
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    update = {}
    name = "hello world"

    update_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_update_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_cluster({ project_id: project_id, zone: zone, cluster_id: cluster_id, update: update, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_cluster project_id: project_id, zone: zone, cluster_id: cluster_id, update: update, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_cluster ::Google::Cloud::Container::V1::UpdateClusterRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, update: update, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_cluster({ project_id: project_id, zone: zone, cluster_id: cluster_id, update: update, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_cluster(::Google::Cloud::Container::V1::UpdateClusterRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, update: update, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_cluster_client_stub.call_count
      end
    end
  end

  def test_update_node_pool
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    node_pool_id = "hello world"
    node_version = "hello world"
    image_type = "hello world"
    name = "hello world"
    locations = ["hello world"]
    workload_metadata_config = {}
    upgrade_settings = {}
    tags = {}
    taints = {}
    labels = {}
    linux_node_config = {}
    kubelet_config = {}
    node_network_config = {}
    gcfs_config = {}
    confidential_nodes = {}
    gvnic = {}
    etag = "hello world"
    fast_socket = {}
    logging_config = {}
    resource_labels = {}
    windows_node_config = {}
    accelerators = [{}]
    machine_type = "hello world"
    disk_type = "hello world"
    disk_size_gb = 42
    resource_manager_tags = {}
    containerd_config = {}
    queued_provisioning = {}
    storage_pools = ["hello world"]
    max_run_duration = {}
    flex_start = true
    boot_disk = {}

    update_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_update_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_node_pool({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_version: node_version, image_type: image_type, name: name, locations: locations, workload_metadata_config: workload_metadata_config, upgrade_settings: upgrade_settings, tags: tags, taints: taints, labels: labels, linux_node_config: linux_node_config, kubelet_config: kubelet_config, node_network_config: node_network_config, gcfs_config: gcfs_config, confidential_nodes: confidential_nodes, gvnic: gvnic, etag: etag, fast_socket: fast_socket, logging_config: logging_config, resource_labels: resource_labels, windows_node_config: windows_node_config, accelerators: accelerators, machine_type: machine_type, disk_type: disk_type, disk_size_gb: disk_size_gb, resource_manager_tags: resource_manager_tags, containerd_config: containerd_config, queued_provisioning: queued_provisioning, storage_pools: storage_pools, max_run_duration: max_run_duration, flex_start: flex_start, boot_disk: boot_disk }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_node_pool project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_version: node_version, image_type: image_type, name: name, locations: locations, workload_metadata_config: workload_metadata_config, upgrade_settings: upgrade_settings, tags: tags, taints: taints, labels: labels, linux_node_config: linux_node_config, kubelet_config: kubelet_config, node_network_config: node_network_config, gcfs_config: gcfs_config, confidential_nodes: confidential_nodes, gvnic: gvnic, etag: etag, fast_socket: fast_socket, logging_config: logging_config, resource_labels: resource_labels, windows_node_config: windows_node_config, accelerators: accelerators, machine_type: machine_type, disk_type: disk_type, disk_size_gb: disk_size_gb, resource_manager_tags: resource_manager_tags, containerd_config: containerd_config, queued_provisioning: queued_provisioning, storage_pools: storage_pools, max_run_duration: max_run_duration, flex_start: flex_start, boot_disk: boot_disk do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_node_pool ::Google::Cloud::Container::V1::UpdateNodePoolRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_version: node_version, image_type: image_type, name: name, locations: locations, workload_metadata_config: workload_metadata_config, upgrade_settings: upgrade_settings, tags: tags, taints: taints, labels: labels, linux_node_config: linux_node_config, kubelet_config: kubelet_config, node_network_config: node_network_config, gcfs_config: gcfs_config, confidential_nodes: confidential_nodes, gvnic: gvnic, etag: etag, fast_socket: fast_socket, logging_config: logging_config, resource_labels: resource_labels, windows_node_config: windows_node_config, accelerators: accelerators, machine_type: machine_type, disk_type: disk_type, disk_size_gb: disk_size_gb, resource_manager_tags: resource_manager_tags, containerd_config: containerd_config, queued_provisioning: queued_provisioning, storage_pools: storage_pools, max_run_duration: max_run_duration, flex_start: flex_start, boot_disk: boot_disk) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_node_pool({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_version: node_version, image_type: image_type, name: name, locations: locations, workload_metadata_config: workload_metadata_config, upgrade_settings: upgrade_settings, tags: tags, taints: taints, labels: labels, linux_node_config: linux_node_config, kubelet_config: kubelet_config, node_network_config: node_network_config, gcfs_config: gcfs_config, confidential_nodes: confidential_nodes, gvnic: gvnic, etag: etag, fast_socket: fast_socket, logging_config: logging_config, resource_labels: resource_labels, windows_node_config: windows_node_config, accelerators: accelerators, machine_type: machine_type, disk_type: disk_type, disk_size_gb: disk_size_gb, resource_manager_tags: resource_manager_tags, containerd_config: containerd_config, queued_provisioning: queued_provisioning, storage_pools: storage_pools, max_run_duration: max_run_duration, flex_start: flex_start, boot_disk: boot_disk }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_node_pool(::Google::Cloud::Container::V1::UpdateNodePoolRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_version: node_version, image_type: image_type, name: name, locations: locations, workload_metadata_config: workload_metadata_config, upgrade_settings: upgrade_settings, tags: tags, taints: taints, labels: labels, linux_node_config: linux_node_config, kubelet_config: kubelet_config, node_network_config: node_network_config, gcfs_config: gcfs_config, confidential_nodes: confidential_nodes, gvnic: gvnic, etag: etag, fast_socket: fast_socket, logging_config: logging_config, resource_labels: resource_labels, windows_node_config: windows_node_config, accelerators: accelerators, machine_type: machine_type, disk_type: disk_type, disk_size_gb: disk_size_gb, resource_manager_tags: resource_manager_tags, containerd_config: containerd_config, queued_provisioning: queued_provisioning, storage_pools: storage_pools, max_run_duration: max_run_duration, flex_start: flex_start, boot_disk: boot_disk), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_node_pool_client_stub.call_count
      end
    end
  end

  def test_set_node_pool_autoscaling
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    node_pool_id = "hello world"
    autoscaling = {}
    name = "hello world"

    set_node_pool_autoscaling_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_node_pool_autoscaling_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_node_pool_autoscaling_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_node_pool_autoscaling({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, autoscaling: autoscaling, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_node_pool_autoscaling project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, autoscaling: autoscaling, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_node_pool_autoscaling ::Google::Cloud::Container::V1::SetNodePoolAutoscalingRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, autoscaling: autoscaling, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_node_pool_autoscaling({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, autoscaling: autoscaling, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_node_pool_autoscaling(::Google::Cloud::Container::V1::SetNodePoolAutoscalingRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, autoscaling: autoscaling, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_node_pool_autoscaling_client_stub.call_count
      end
    end
  end

  def test_set_logging_service
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    logging_service = "hello world"
    name = "hello world"

    set_logging_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_logging_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_logging_service_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_logging_service({ project_id: project_id, zone: zone, cluster_id: cluster_id, logging_service: logging_service, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_logging_service project_id: project_id, zone: zone, cluster_id: cluster_id, logging_service: logging_service, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_logging_service ::Google::Cloud::Container::V1::SetLoggingServiceRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, logging_service: logging_service, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_logging_service({ project_id: project_id, zone: zone, cluster_id: cluster_id, logging_service: logging_service, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_logging_service(::Google::Cloud::Container::V1::SetLoggingServiceRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, logging_service: logging_service, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_logging_service_client_stub.call_count
      end
    end
  end

  def test_set_monitoring_service
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    monitoring_service = "hello world"
    name = "hello world"

    set_monitoring_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_monitoring_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_monitoring_service_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_monitoring_service({ project_id: project_id, zone: zone, cluster_id: cluster_id, monitoring_service: monitoring_service, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_monitoring_service project_id: project_id, zone: zone, cluster_id: cluster_id, monitoring_service: monitoring_service, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_monitoring_service ::Google::Cloud::Container::V1::SetMonitoringServiceRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, monitoring_service: monitoring_service, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_monitoring_service({ project_id: project_id, zone: zone, cluster_id: cluster_id, monitoring_service: monitoring_service, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_monitoring_service(::Google::Cloud::Container::V1::SetMonitoringServiceRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, monitoring_service: monitoring_service, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_monitoring_service_client_stub.call_count
      end
    end
  end

  def test_set_addons_config
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    addons_config = {}
    name = "hello world"

    set_addons_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_addons_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_addons_config_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_addons_config({ project_id: project_id, zone: zone, cluster_id: cluster_id, addons_config: addons_config, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_addons_config project_id: project_id, zone: zone, cluster_id: cluster_id, addons_config: addons_config, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_addons_config ::Google::Cloud::Container::V1::SetAddonsConfigRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, addons_config: addons_config, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_addons_config({ project_id: project_id, zone: zone, cluster_id: cluster_id, addons_config: addons_config, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_addons_config(::Google::Cloud::Container::V1::SetAddonsConfigRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, addons_config: addons_config, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_addons_config_client_stub.call_count
      end
    end
  end

  def test_set_locations
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    locations = ["hello world"]
    name = "hello world"

    set_locations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_locations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_locations_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_locations({ project_id: project_id, zone: zone, cluster_id: cluster_id, locations: locations, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_locations project_id: project_id, zone: zone, cluster_id: cluster_id, locations: locations, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_locations ::Google::Cloud::Container::V1::SetLocationsRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, locations: locations, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_locations({ project_id: project_id, zone: zone, cluster_id: cluster_id, locations: locations, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_locations(::Google::Cloud::Container::V1::SetLocationsRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, locations: locations, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_locations_client_stub.call_count
      end
    end
  end

  def test_update_master
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    master_version = "hello world"
    name = "hello world"

    update_master_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_update_master_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_master_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_master({ project_id: project_id, zone: zone, cluster_id: cluster_id, master_version: master_version, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_master project_id: project_id, zone: zone, cluster_id: cluster_id, master_version: master_version, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_master ::Google::Cloud::Container::V1::UpdateMasterRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, master_version: master_version, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_master({ project_id: project_id, zone: zone, cluster_id: cluster_id, master_version: master_version, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_master(::Google::Cloud::Container::V1::UpdateMasterRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, master_version: master_version, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_master_client_stub.call_count
      end
    end
  end

  def test_set_master_auth
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    action = :UNKNOWN
    update = {}
    name = "hello world"

    set_master_auth_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_master_auth_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_master_auth_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_master_auth({ project_id: project_id, zone: zone, cluster_id: cluster_id, action: action, update: update, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_master_auth project_id: project_id, zone: zone, cluster_id: cluster_id, action: action, update: update, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_master_auth ::Google::Cloud::Container::V1::SetMasterAuthRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, action: action, update: update, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_master_auth({ project_id: project_id, zone: zone, cluster_id: cluster_id, action: action, update: update, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_master_auth(::Google::Cloud::Container::V1::SetMasterAuthRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, action: action, update: update, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_master_auth_client_stub.call_count
      end
    end
  end

  def test_delete_cluster
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    name = "hello world"

    delete_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_delete_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_cluster({ project_id: project_id, zone: zone, cluster_id: cluster_id, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_cluster project_id: project_id, zone: zone, cluster_id: cluster_id, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_cluster ::Google::Cloud::Container::V1::DeleteClusterRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_cluster({ project_id: project_id, zone: zone, cluster_id: cluster_id, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_cluster(::Google::Cloud::Container::V1::DeleteClusterRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_cluster_client_stub.call_count
      end
    end
  end

  def test_list_operations
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::ListOperationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    parent = "hello world"

    list_operations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_list_operations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_operations_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_operations({ project_id: project_id, zone: zone, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_operations project_id: project_id, zone: zone, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_operations ::Google::Cloud::Container::V1::ListOperationsRequest.new(project_id: project_id, zone: zone, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_operations({ project_id: project_id, zone: zone, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_operations(::Google::Cloud::Container::V1::ListOperationsRequest.new(project_id: project_id, zone: zone, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_operations_client_stub.call_count
      end
    end
  end

  def test_get_operation
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    operation_id = "hello world"
    name = "hello world"

    get_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_get_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_operation_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_operation({ project_id: project_id, zone: zone, operation_id: operation_id, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_operation project_id: project_id, zone: zone, operation_id: operation_id, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_operation ::Google::Cloud::Container::V1::GetOperationRequest.new(project_id: project_id, zone: zone, operation_id: operation_id, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_operation({ project_id: project_id, zone: zone, operation_id: operation_id, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_operation(::Google::Cloud::Container::V1::GetOperationRequest.new(project_id: project_id, zone: zone, operation_id: operation_id, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_operation_client_stub.call_count
      end
    end
  end

  def test_cancel_operation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    operation_id = "hello world"
    name = "hello world"

    cancel_operation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_cancel_operation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_operation_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_operation({ project_id: project_id, zone: zone, operation_id: operation_id, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_operation project_id: project_id, zone: zone, operation_id: operation_id, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_operation ::Google::Cloud::Container::V1::CancelOperationRequest.new(project_id: project_id, zone: zone, operation_id: operation_id, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_operation({ project_id: project_id, zone: zone, operation_id: operation_id, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_operation(::Google::Cloud::Container::V1::CancelOperationRequest.new(project_id: project_id, zone: zone, operation_id: operation_id, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_operation_client_stub.call_count
      end
    end
  end

  def test_get_server_config
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::ServerConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    name = "hello world"

    get_server_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_get_server_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_server_config_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_server_config({ project_id: project_id, zone: zone, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_server_config project_id: project_id, zone: zone, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_server_config ::Google::Cloud::Container::V1::GetServerConfigRequest.new(project_id: project_id, zone: zone, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_server_config({ project_id: project_id, zone: zone, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_server_config(::Google::Cloud::Container::V1::GetServerConfigRequest.new(project_id: project_id, zone: zone, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_server_config_client_stub.call_count
      end
    end
  end

  def test_get_json_web_keys
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::GetJSONWebKeysResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    get_json_web_keys_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_get_json_web_keys_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_json_web_keys_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_json_web_keys({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_json_web_keys parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_json_web_keys ::Google::Cloud::Container::V1::GetJSONWebKeysRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_json_web_keys({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_json_web_keys(::Google::Cloud::Container::V1::GetJSONWebKeysRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_json_web_keys_client_stub.call_count
      end
    end
  end

  def test_list_node_pools
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::ListNodePoolsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    parent = "hello world"

    list_node_pools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_list_node_pools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_node_pools_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_node_pools({ project_id: project_id, zone: zone, cluster_id: cluster_id, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_node_pools project_id: project_id, zone: zone, cluster_id: cluster_id, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_node_pools ::Google::Cloud::Container::V1::ListNodePoolsRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_node_pools({ project_id: project_id, zone: zone, cluster_id: cluster_id, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_node_pools(::Google::Cloud::Container::V1::ListNodePoolsRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_node_pools_client_stub.call_count
      end
    end
  end

  def test_get_node_pool
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::NodePool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    node_pool_id = "hello world"
    name = "hello world"

    get_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_get_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_node_pool({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_node_pool project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_node_pool ::Google::Cloud::Container::V1::GetNodePoolRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_node_pool({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_node_pool(::Google::Cloud::Container::V1::GetNodePoolRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_node_pool_client_stub.call_count
      end
    end
  end

  def test_create_node_pool
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    node_pool = {}
    parent = "hello world"

    create_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_create_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_node_pool({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool: node_pool, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_node_pool project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool: node_pool, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_node_pool ::Google::Cloud::Container::V1::CreateNodePoolRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool: node_pool, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_node_pool({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool: node_pool, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_node_pool(::Google::Cloud::Container::V1::CreateNodePoolRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool: node_pool, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_node_pool_client_stub.call_count
      end
    end
  end

  def test_delete_node_pool
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    node_pool_id = "hello world"
    name = "hello world"

    delete_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_delete_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_node_pool({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_node_pool project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_node_pool ::Google::Cloud::Container::V1::DeleteNodePoolRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_node_pool({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_node_pool(::Google::Cloud::Container::V1::DeleteNodePoolRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_node_pool_client_stub.call_count
      end
    end
  end

  def test_complete_node_pool_upgrade
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    complete_node_pool_upgrade_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_complete_node_pool_upgrade_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, complete_node_pool_upgrade_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.complete_node_pool_upgrade({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.complete_node_pool_upgrade name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.complete_node_pool_upgrade ::Google::Cloud::Container::V1::CompleteNodePoolUpgradeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.complete_node_pool_upgrade({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.complete_node_pool_upgrade(::Google::Cloud::Container::V1::CompleteNodePoolUpgradeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, complete_node_pool_upgrade_client_stub.call_count
      end
    end
  end

  def test_rollback_node_pool_upgrade
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    node_pool_id = "hello world"
    name = "hello world"
    respect_pdb = true

    rollback_node_pool_upgrade_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_rollback_node_pool_upgrade_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rollback_node_pool_upgrade_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rollback_node_pool_upgrade({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name, respect_pdb: respect_pdb }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rollback_node_pool_upgrade project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name, respect_pdb: respect_pdb do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rollback_node_pool_upgrade ::Google::Cloud::Container::V1::RollbackNodePoolUpgradeRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name, respect_pdb: respect_pdb) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rollback_node_pool_upgrade({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name, respect_pdb: respect_pdb }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rollback_node_pool_upgrade(::Google::Cloud::Container::V1::RollbackNodePoolUpgradeRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, name: name, respect_pdb: respect_pdb), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rollback_node_pool_upgrade_client_stub.call_count
      end
    end
  end

  def test_set_node_pool_management
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    node_pool_id = "hello world"
    management = {}
    name = "hello world"

    set_node_pool_management_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_node_pool_management_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_node_pool_management_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_node_pool_management({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, management: management, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_node_pool_management project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, management: management, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_node_pool_management ::Google::Cloud::Container::V1::SetNodePoolManagementRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, management: management, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_node_pool_management({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, management: management, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_node_pool_management(::Google::Cloud::Container::V1::SetNodePoolManagementRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, management: management, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_node_pool_management_client_stub.call_count
      end
    end
  end

  def test_set_labels
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    resource_labels = {}
    label_fingerprint = "hello world"
    name = "hello world"

    set_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_labels_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_labels({ project_id: project_id, zone: zone, cluster_id: cluster_id, resource_labels: resource_labels, label_fingerprint: label_fingerprint, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_labels project_id: project_id, zone: zone, cluster_id: cluster_id, resource_labels: resource_labels, label_fingerprint: label_fingerprint, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_labels ::Google::Cloud::Container::V1::SetLabelsRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, resource_labels: resource_labels, label_fingerprint: label_fingerprint, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_labels({ project_id: project_id, zone: zone, cluster_id: cluster_id, resource_labels: resource_labels, label_fingerprint: label_fingerprint, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_labels(::Google::Cloud::Container::V1::SetLabelsRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, resource_labels: resource_labels, label_fingerprint: label_fingerprint, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_labels_client_stub.call_count
      end
    end
  end

  def test_set_legacy_abac
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    enabled = true
    name = "hello world"

    set_legacy_abac_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_legacy_abac_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_legacy_abac_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_legacy_abac({ project_id: project_id, zone: zone, cluster_id: cluster_id, enabled: enabled, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_legacy_abac project_id: project_id, zone: zone, cluster_id: cluster_id, enabled: enabled, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_legacy_abac ::Google::Cloud::Container::V1::SetLegacyAbacRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, enabled: enabled, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_legacy_abac({ project_id: project_id, zone: zone, cluster_id: cluster_id, enabled: enabled, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_legacy_abac(::Google::Cloud::Container::V1::SetLegacyAbacRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, enabled: enabled, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_legacy_abac_client_stub.call_count
      end
    end
  end

  def test_start_ip_rotation
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    name = "hello world"
    rotate_credentials = true

    start_ip_rotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_start_ip_rotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_ip_rotation_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_ip_rotation({ project_id: project_id, zone: zone, cluster_id: cluster_id, name: name, rotate_credentials: rotate_credentials }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_ip_rotation project_id: project_id, zone: zone, cluster_id: cluster_id, name: name, rotate_credentials: rotate_credentials do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_ip_rotation ::Google::Cloud::Container::V1::StartIPRotationRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, name: name, rotate_credentials: rotate_credentials) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_ip_rotation({ project_id: project_id, zone: zone, cluster_id: cluster_id, name: name, rotate_credentials: rotate_credentials }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_ip_rotation(::Google::Cloud::Container::V1::StartIPRotationRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, name: name, rotate_credentials: rotate_credentials), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_ip_rotation_client_stub.call_count
      end
    end
  end

  def test_complete_ip_rotation
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    name = "hello world"

    complete_ip_rotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_complete_ip_rotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, complete_ip_rotation_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.complete_ip_rotation({ project_id: project_id, zone: zone, cluster_id: cluster_id, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.complete_ip_rotation project_id: project_id, zone: zone, cluster_id: cluster_id, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.complete_ip_rotation ::Google::Cloud::Container::V1::CompleteIPRotationRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.complete_ip_rotation({ project_id: project_id, zone: zone, cluster_id: cluster_id, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.complete_ip_rotation(::Google::Cloud::Container::V1::CompleteIPRotationRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, complete_ip_rotation_client_stub.call_count
      end
    end
  end

  def test_set_node_pool_size
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    node_pool_id = "hello world"
    node_count = 42
    name = "hello world"

    set_node_pool_size_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_node_pool_size_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_node_pool_size_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_node_pool_size({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_count: node_count, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_node_pool_size project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_count: node_count, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_node_pool_size ::Google::Cloud::Container::V1::SetNodePoolSizeRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_count: node_count, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_node_pool_size({ project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_count: node_count, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_node_pool_size(::Google::Cloud::Container::V1::SetNodePoolSizeRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, node_pool_id: node_pool_id, node_count: node_count, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_node_pool_size_client_stub.call_count
      end
    end
  end

  def test_set_network_policy
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    network_policy = {}
    name = "hello world"

    set_network_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_network_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_network_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_network_policy({ project_id: project_id, zone: zone, cluster_id: cluster_id, network_policy: network_policy, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_network_policy project_id: project_id, zone: zone, cluster_id: cluster_id, network_policy: network_policy, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_network_policy ::Google::Cloud::Container::V1::SetNetworkPolicyRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, network_policy: network_policy, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_network_policy({ project_id: project_id, zone: zone, cluster_id: cluster_id, network_policy: network_policy, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_network_policy(::Google::Cloud::Container::V1::SetNetworkPolicyRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, network_policy: network_policy, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_network_policy_client_stub.call_count
      end
    end
  end

  def test_set_maintenance_policy
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    zone = "hello world"
    cluster_id = "hello world"
    maintenance_policy = {}
    name = "hello world"

    set_maintenance_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_set_maintenance_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_maintenance_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_maintenance_policy({ project_id: project_id, zone: zone, cluster_id: cluster_id, maintenance_policy: maintenance_policy, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_maintenance_policy project_id: project_id, zone: zone, cluster_id: cluster_id, maintenance_policy: maintenance_policy, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_maintenance_policy ::Google::Cloud::Container::V1::SetMaintenancePolicyRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, maintenance_policy: maintenance_policy, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_maintenance_policy({ project_id: project_id, zone: zone, cluster_id: cluster_id, maintenance_policy: maintenance_policy, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_maintenance_policy(::Google::Cloud::Container::V1::SetMaintenancePolicyRequest.new(project_id: project_id, zone: zone, cluster_id: cluster_id, maintenance_policy: maintenance_policy, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_maintenance_policy_client_stub.call_count
      end
    end
  end

  def test_list_usable_subnetworks
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::ListUsableSubnetworksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_usable_subnetworks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_list_usable_subnetworks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_usable_subnetworks_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_usable_subnetworks({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_usable_subnetworks parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_usable_subnetworks ::Google::Cloud::Container::V1::ListUsableSubnetworksRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_usable_subnetworks({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_usable_subnetworks(::Google::Cloud::Container::V1::ListUsableSubnetworksRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_usable_subnetworks_client_stub.call_count
      end
    end
  end

  def test_check_autopilot_compatibility
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::CheckAutopilotCompatibilityResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    check_autopilot_compatibility_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_check_autopilot_compatibility_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, check_autopilot_compatibility_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.check_autopilot_compatibility({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.check_autopilot_compatibility name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.check_autopilot_compatibility ::Google::Cloud::Container::V1::CheckAutopilotCompatibilityRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.check_autopilot_compatibility({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.check_autopilot_compatibility(::Google::Cloud::Container::V1::CheckAutopilotCompatibilityRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, check_autopilot_compatibility_client_stub.call_count
      end
    end
  end

  def test_fetch_cluster_upgrade_info
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::ClusterUpgradeInfo.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    version = "hello world"

    fetch_cluster_upgrade_info_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_fetch_cluster_upgrade_info_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_cluster_upgrade_info_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_cluster_upgrade_info({ name: name, version: version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_cluster_upgrade_info name: name, version: version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_cluster_upgrade_info ::Google::Cloud::Container::V1::FetchClusterUpgradeInfoRequest.new(name: name, version: version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_cluster_upgrade_info({ name: name, version: version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_cluster_upgrade_info(::Google::Cloud::Container::V1::FetchClusterUpgradeInfoRequest.new(name: name, version: version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_cluster_upgrade_info_client_stub.call_count
      end
    end
  end

  def test_fetch_node_pool_upgrade_info
    # Create test objects.
    client_result = ::Google::Cloud::Container::V1::NodePoolUpgradeInfo.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    version = "hello world"

    fetch_node_pool_upgrade_info_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Container::V1::ClusterManager::Rest::ServiceStub.stub :transcode_fetch_node_pool_upgrade_info_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_node_pool_upgrade_info_client_stub do
        # Create client
        client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_node_pool_upgrade_info({ name: name, version: version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_node_pool_upgrade_info name: name, version: version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_node_pool_upgrade_info ::Google::Cloud::Container::V1::FetchNodePoolUpgradeInfoRequest.new(name: name, version: version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_node_pool_upgrade_info({ name: name, version: version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_node_pool_upgrade_info(::Google::Cloud::Container::V1::FetchNodePoolUpgradeInfoRequest.new(name: name, version: version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_node_pool_upgrade_info_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Container::V1::ClusterManager::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Container::V1::ClusterManager::Rest::Client::Configuration, config
  end
end
