# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Container
      module V1
        # Parameters that can be configured on Linux nodes.
        # @!attribute [rw] sysctls
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The Linux kernel parameters to be applied to the nodes and all pods running
        #     on the nodes.
        #
        #     The following parameters are supported.
        #
        #     net.core.busy_poll
        #     net.core.busy_read
        #     net.core.netdev_max_backlog
        #     net.core.rmem_max
        #     net.core.rmem_default
        #     net.core.wmem_default
        #     net.core.wmem_max
        #     net.core.optmem_max
        #     net.core.somaxconn
        #     net.ipv4.tcp_rmem
        #     net.ipv4.tcp_wmem
        #     net.ipv4.tcp_tw_reuse
        #     net.ipv4.tcp_max_orphans
        #     net.netfilter.nf_conntrack_max
        #     net.netfilter.nf_conntrack_buckets
        #     net.netfilter.nf_conntrack_tcp_timeout_close_wait
        #     net.netfilter.nf_conntrack_tcp_timeout_time_wait
        #     net.netfilter.nf_conntrack_tcp_timeout_established
        #     net.netfilter.nf_conntrack_acct
        #     kernel.shmmni
        #     kernel.shmmax
        #     kernel.shmall
        #     fs.aio-max-nr
        #     fs.file-max
        #     fs.inotify.max_user_instances
        #     fs.inotify.max_user_watches
        #     fs.nr_open
        #     vm.dirty_background_ratio
        #     vm.dirty_expire_centisecs
        #     vm.dirty_ratio
        #     vm.dirty_writeback_centisecs
        #     vm.max_map_count
        #     vm.overcommit_memory
        #     vm.overcommit_ratio
        #     vm.vfs_cache_pressure
        #     vm.swappiness
        #     vm.watermark_scale_factor
        #     vm.min_free_kbytes
        # @!attribute [rw] cgroup_mode
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig::CgroupMode]
        #     cgroup_mode specifies the cgroup mode to be used on the node.
        # @!attribute [rw] hugepages
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig::HugepagesConfig]
        #     Optional. Amounts for 2M and 1G hugepages
        # @!attribute [rw] transparent_hugepage_enabled
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig::TransparentHugepageEnabled]
        #     Optional. Transparent hugepage support for anonymous memory can be entirely
        #     disabled (mostly for debugging purposes) or only enabled inside
        #     MADV_HUGEPAGE regions (to avoid the risk of consuming more memory
        #     resources) or enabled system wide.
        #
        #     See https://docs.kernel.org/admin-guide/mm/transhuge.html
        #     for more details.
        # @!attribute [rw] transparent_hugepage_defrag
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig::TransparentHugepageDefrag]
        #     Optional. Defines the transparent hugepage defrag configuration on the
        #     node. VM hugepage allocation can be managed by either limiting
        #     defragmentation for delayed allocation or skipping it entirely for
        #     immediate allocation only.
        #
        #     See https://docs.kernel.org/admin-guide/mm/transhuge.html
        #     for more details.
        # @!attribute [rw] node_kernel_module_loading
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig::NodeKernelModuleLoading]
        #     Optional. Configuration for kernel module loading on nodes.
        #     When enabled, the node pool will be provisioned with a Container-Optimized
        #     OS image that enforces kernel module signature verification.
        class LinuxNodeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Hugepages amount in both 2m and 1g size
          # @!attribute [rw] hugepage_size2m
          #   @return [::Integer]
          #     Optional. Amount of 2M hugepages
          # @!attribute [rw] hugepage_size1g
          #   @return [::Integer]
          #     Optional. Amount of 1G hugepages
          class HugepagesConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for kernel module loading on nodes.
          # @!attribute [rw] policy
          #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig::NodeKernelModuleLoading::Policy]
          #     Set the node module loading policy for nodes in the node pool.
          class NodeKernelModuleLoading
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the kernel module loading policy for nodes in the nodepool.
            module Policy
              # Default behavior. GKE selects the image based on node type.
              # For CPU and TPU nodes, the image will not allow loading external
              # kernel modules.
              # For GPU nodes, the image will allow loading any module, whether it
              # is signed or not.
              POLICY_UNSPECIFIED = 0

              # Enforced signature verification: Node pools will use a
              # Container-Optimized OS image configured to allow loading of
              # *Google-signed* external kernel modules.
              # Loadpin is enabled but configured to exclude modules, and kernel
              # module signature checking is enforced.
              ENFORCE_SIGNED_MODULES = 1

              # Mirrors existing DEFAULT behavior:
              # For CPU and TPU nodes, the image will not allow loading external
              # kernel modules.
              # For GPU nodes, the image will allow loading any module, whether it
              # is signed or not.
              DO_NOT_ENFORCE_SIGNED_MODULES = 2
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class SysctlsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible cgroup modes that can be used.
          module CgroupMode
            # CGROUP_MODE_UNSPECIFIED is when unspecified cgroup configuration is used.
            # The default for the GKE node OS image will be used.
            CGROUP_MODE_UNSPECIFIED = 0

            # CGROUP_MODE_V1 specifies to use cgroupv1 for the cgroup configuration on
            # the node image.
            CGROUP_MODE_V1 = 1

            # CGROUP_MODE_V2 specifies to use cgroupv2 for the cgroup configuration on
            # the node image.
            CGROUP_MODE_V2 = 2
          end

          # Possible values for transparent hugepage enabled support.
          module TransparentHugepageEnabled
            # Default value. GKE will not modify the kernel configuration.
            TRANSPARENT_HUGEPAGE_ENABLED_UNSPECIFIED = 0

            # Transparent hugepage support for anonymous memory is enabled system wide.
            TRANSPARENT_HUGEPAGE_ENABLED_ALWAYS = 1

            # Transparent hugepage support for anonymous memory is enabled inside
            # MADV_HUGEPAGE regions. This is the default kernel configuration.
            TRANSPARENT_HUGEPAGE_ENABLED_MADVISE = 2

            # Transparent hugepage support for anonymous memory is disabled.
            TRANSPARENT_HUGEPAGE_ENABLED_NEVER = 3
          end

          # Possible values for transparent hugepage defrag support.
          module TransparentHugepageDefrag
            # Default value. GKE will not modify the kernel configuration.
            TRANSPARENT_HUGEPAGE_DEFRAG_UNSPECIFIED = 0

            # It means that an application requesting THP will stall on allocation
            # failure and directly reclaim pages and compact memory in an effort to
            # allocate a THP immediately.
            TRANSPARENT_HUGEPAGE_DEFRAG_ALWAYS = 1

            # It means that an application will wake kswapd in the background to
            # reclaim pages and wake kcompactd to compact memory so that THP is
            # available in the near future. It's the responsibility of khugepaged to
            # then install the THP pages later.
            TRANSPARENT_HUGEPAGE_DEFRAG_DEFER = 2

            # It means that an application will enter direct reclaim and compaction
            # like always, but only for regions that have used madvise(MADV_HUGEPAGE);
            # all other regions will wake kswapd in the background to reclaim pages and
            # wake kcompactd to compact memory so that THP is available in the near
            # future.
            TRANSPARENT_HUGEPAGE_DEFRAG_DEFER_WITH_MADVISE = 3

            # It means that an application will enter direct reclaim like always but
            # only for regions that are have used madvise(MADV_HUGEPAGE). This is the
            # default kernel configuration.
            TRANSPARENT_HUGEPAGE_DEFRAG_MADVISE = 4

            # It means that an application will never enter direct reclaim or
            # compaction.
            TRANSPARENT_HUGEPAGE_DEFRAG_NEVER = 5
          end
        end

        # Parameters that can be configured on Windows nodes.
        # Windows Node Config that define the parameters that will be used to
        # configure the Windows node pool settings.
        # @!attribute [rw] os_version
        #   @return [::Google::Cloud::Container::V1::WindowsNodeConfig::OSVersion]
        #     OSVersion specifies the Windows node config to be used on the node.
        class WindowsNodeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible OS version that can be used.
          module OSVersion
            # When OSVersion is not specified.
            OS_VERSION_UNSPECIFIED = 0

            # LTSC2019 specifies to use LTSC2019 as the Windows Servercore Base Image.
            OS_VERSION_LTSC2019 = 1

            # LTSC2022 specifies to use LTSC2022 as the Windows Servercore Base Image.
            OS_VERSION_LTSC2022 = 2
          end
        end

        # Node kubelet configs.
        # @!attribute [rw] cpu_manager_policy
        #   @return [::String]
        #     Control the CPU management policy on the node.
        #     See
        #     https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
        #
        #     The following values are allowed.
        #     * "none": the default, which represents the existing scheduling behavior.
        #     * "static": allows pods with certain resource characteristics to be granted
        #     increased CPU affinity and exclusivity on the node.
        #     The default value is 'none' if unspecified.
        # @!attribute [rw] topology_manager
        #   @return [::Google::Cloud::Container::V1::TopologyManager]
        #     Optional. Controls Topology Manager configuration on the node.
        #     For more information, see:
        #     https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/
        # @!attribute [rw] memory_manager
        #   @return [::Google::Cloud::Container::V1::MemoryManager]
        #     Optional. Controls NUMA-aware Memory Manager configuration on the
        #     node. For more information, see:
        #     https://kubernetes.io/docs/tasks/administer-cluster/memory-manager/
        # @!attribute [rw] cpu_cfs_quota
        #   @return [::Google::Protobuf::BoolValue]
        #     Enable CPU CFS quota enforcement for containers that specify CPU limits.
        #
        #     This option is enabled by default which makes kubelet use CFS quota
        #     (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
        #     enforce container CPU limits. Otherwise, CPU limits will not be enforced at
        #     all.
        #
        #     Disable this option to mitigate CPU throttling problems while still having
        #     your pods to be in Guaranteed QoS class by specifying the CPU limits.
        #
        #     The default value is 'true' if unspecified.
        # @!attribute [rw] cpu_cfs_quota_period
        #   @return [::String]
        #     Set the CPU CFS quota period value 'cpu.cfs_period_us'.
        #
        #     The string must be a sequence of decimal numbers, each with optional
        #     fraction and a unit suffix, such as "300ms".
        #     Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
        #     The value must be a positive duration between 1ms and 1 second, inclusive.
        # @!attribute [rw] pod_pids_limit
        #   @return [::Integer]
        #     Set the Pod PID limits. See
        #     https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
        #
        #     Controls the maximum number of processes allowed to run in a pod. The value
        #     must be greater than or equal to 1024 and less than 4194304.
        # @!attribute [rw] insecure_kubelet_readonly_port_enabled
        #   @return [::Boolean]
        #     Enable or disable Kubelet read only port.
        # @!attribute [rw] image_gc_low_threshold_percent
        #   @return [::Integer]
        #     Optional. Defines the percent of disk usage before which image garbage
        #     collection is never run. Lowest disk usage to garbage collect to. The
        #     percent is calculated as this field value out of 100.
        #
        #     The value must be between 10 and 85, inclusive and smaller than
        #     image_gc_high_threshold_percent.
        #
        #     The default value is 80 if unspecified.
        # @!attribute [rw] image_gc_high_threshold_percent
        #   @return [::Integer]
        #     Optional. Defines the percent of disk usage after which image garbage
        #     collection is always run. The percent is calculated as this field value out
        #     of 100.
        #
        #     The value must be between 10 and 85, inclusive and greater than
        #     image_gc_low_threshold_percent.
        #
        #     The default value is 85 if unspecified.
        # @!attribute [rw] image_minimum_gc_age
        #   @return [::String]
        #     Optional. Defines the minimum age for an unused image before it is garbage
        #     collected.
        #
        #     The string must be a sequence of decimal numbers, each with optional
        #     fraction and a unit suffix, such as "300s", "1.5h", and "2h45m". Valid time
        #     units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
        #
        #     The value must be a positive duration less than or equal to 2 minutes.
        #
        #     The default value is "2m0s" if unspecified.
        # @!attribute [rw] image_maximum_gc_age
        #   @return [::String]
        #     Optional. Defines the maximum age an image can be unused before it is
        #     garbage collected. The string must be a sequence of decimal numbers, each
        #     with optional fraction and a unit suffix, such as "300s", "1.5h", and
        #     "2h45m". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
        #
        #     The value must be a positive duration greater than image_minimum_gc_age
        #     or "0s".
        #
        #     The default value is "0s" if unspecified, which disables this field,
        #     meaning images won't be garbage collected based on being unused for too
        #     long.
        # @!attribute [rw] container_log_max_size
        #   @return [::String]
        #     Optional. Defines the maximum size of the container log file before it is
        #     rotated. See
        #     https://kubernetes.io/docs/concepts/cluster-administration/logging/#log-rotation
        #
        #     Valid format is positive number + unit, e.g. 100Ki, 10Mi. Valid units are
        #     Ki, Mi, Gi.
        #     The value must be between 10Mi and 500Mi, inclusive.
        #
        #     Note that the total container log size (container_log_max_size *
        #     container_log_max_files) cannot exceed 1% of the total
        #     storage of the node, to avoid disk pressure caused by log files.
        #
        #     The default value is 10Mi if unspecified.
        # @!attribute [rw] container_log_max_files
        #   @return [::Integer]
        #     Optional. Defines the maximum number of container log files that can be
        #     present for a container. See
        #     https://kubernetes.io/docs/concepts/cluster-administration/logging/#log-rotation
        #
        #     The value must be an integer between 2 and 10, inclusive.
        #     The default value is 5 if unspecified.
        # @!attribute [rw] allowed_unsafe_sysctls
        #   @return [::Array<::String>]
        #     Optional. Defines a comma-separated allowlist of unsafe sysctls or sysctl
        #     patterns (ending in `*`).
        #
        #     The unsafe namespaced sysctl groups are `kernel.shm*`, `kernel.msg*`,
        #     `kernel.sem`, `fs.mqueue.*`, and `net.*`. Leaving this allowlist empty
        #     means they cannot be set on Pods.
        #
        #     To allow certain sysctls or sysctl patterns to be set on Pods, list them
        #     separated by commas.
        #     For example: `kernel.msg*,net.ipv4.route.min_pmtu`.
        #
        #     See https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster/
        #     for more details.
        # @!attribute [rw] eviction_soft
        #   @return [::Google::Cloud::Container::V1::EvictionSignals]
        #     Optional. eviction_soft is a map of signal names to quantities that defines
        #     soft eviction thresholds. Each signal is compared to its corresponding
        #     threshold to determine if a pod eviction should occur.
        # @!attribute [rw] eviction_soft_grace_period
        #   @return [::Google::Cloud::Container::V1::EvictionGracePeriod]
        #     Optional. eviction_soft_grace_period is a map of signal names to quantities
        #     that defines grace periods for each soft eviction signal. The grace period
        #     is the amount of time that a pod must be under pressure before an eviction
        #     occurs.
        # @!attribute [rw] eviction_minimum_reclaim
        #   @return [::Google::Cloud::Container::V1::EvictionMinimumReclaim]
        #     Optional. eviction_minimum_reclaim is a map of signal names to quantities
        #     that defines minimum reclaims, which describe the minimum amount of a given
        #     resource the kubelet will reclaim when performing a pod eviction while that
        #     resource is under pressure.
        # @!attribute [rw] eviction_max_pod_grace_period_seconds
        #   @return [::Integer]
        #     Optional. eviction_max_pod_grace_period_seconds is the maximum allowed
        #     grace period (in seconds) to use when terminating pods in response to a
        #     soft eviction threshold being met. This value effectively caps the Pod's
        #     terminationGracePeriodSeconds value during soft evictions. Default: 0.
        #     Range: [0, 300].
        # @!attribute [rw] max_parallel_image_pulls
        #   @return [::Integer]
        #     Optional. Defines the maximum number of image pulls in parallel.
        #     The range is 2 to 5, inclusive.
        #     The default value is 2 or 3 depending on the disk type.
        #
        #     See
        #     https://kubernetes.io/docs/concepts/containers/images/#maximum-parallel-image-pulls
        #     for more details.
        # @!attribute [rw] single_process_oom_kill
        #   @return [::Boolean]
        #     Optional. Defines whether to enable single process OOM killer.
        #     If true, will prevent the memory.oom.group flag from being set for
        #     container cgroups in cgroups v2. This causes processes in the container to
        #     be OOM killed individually instead of as a group.
        class NodeKubeletConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TopologyManager defines the configuration options for Topology Manager
        # feature. See
        # https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/
        # @!attribute [rw] policy
        #   @return [::String]
        #     Configures the strategy for resource alignment.
        #     Allowed values are:
        #
        #     * none: the default policy, and does not perform any topology alignment.
        #     * restricted: the topology manager stores the preferred NUMA node affinity
        #     for the container, and will reject the pod if the affinity if not
        #     preferred.
        #     * best-effort: the topology manager stores the preferred NUMA node affinity
        #     for the container. If the affinity is not preferred, the topology manager
        #     will admit the pod to the node anyway.
        #     * single-numa-node: the topology manager determines if the single NUMA node
        #     affinity is possible. If it is, Topology Manager will store this and the
        #     Hint Providers can then use this information when making the resource
        #     allocation decision. If, however, this is not possible then the
        #     Topology Manager will reject the pod from the node. This will result in a
        #     pod in a Terminated state with a pod admission failure.
        #
        #     The default policy value is 'none' if unspecified.
        #     Details about each strategy can be found
        #     [here](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-policies).
        # @!attribute [rw] scope
        #   @return [::String]
        #     The Topology Manager aligns resources in following scopes:
        #
        #     * container
        #     * pod
        #
        #     The default scope is 'container' if unspecified.
        #     See
        #     https://kubernetes.io/docs/tasks/administer-cluster/topology-manager/#topology-manager-scopes
        class TopologyManager
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The option enables the Kubernetes NUMA-aware Memory Manager feature.
        # Detailed description about the feature can be found
        # [here](https://kubernetes.io/docs/tasks/administer-cluster/memory-manager/).
        # @!attribute [rw] policy
        #   @return [::String]
        #     Controls the memory management policy on the Node.
        #     See
        #     https://kubernetes.io/docs/tasks/administer-cluster/memory-manager/#policies
        #
        #     The following values are allowed.
        #     * "none"
        #     * "static"
        #     The default value is 'none' if unspecified.
        class MemoryManager
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Eviction signals are the current state of a particular resource at a specific
        # point in time. The kubelet uses eviction signals to make eviction decisions
        # by comparing the signals to eviction thresholds, which are the minimum amount
        # of the resource that should be available on the node.
        # @!attribute [rw] memory_available
        #   @return [::String]
        #     Optional. Memory available (i.e. capacity - workingSet), in bytes. Defines
        #     the amount of "memory.available" signal in kubelet. Default is unset, if
        #     not specified in the kubelet config. Format: positive number + unit, e.g.
        #     100Ki, 10Mi, 5Gi. Valid units are Ki, Mi, Gi. Must be >= 100Mi and <= 50%
        #     of the node's memory. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] nodefs_available
        #   @return [::String]
        #     Optional. Amount of storage available on filesystem that kubelet uses for
        #     volumes, daemon logs, etc. Defines the amount of "nodefs.available" signal
        #     in kubelet. Default is unset, if not specified in the kubelet config. It
        #     takses percentage value for now. Sample format: "30%". Must be >= 10% and
        #     <= 50%. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] nodefs_inodes_free
        #   @return [::String]
        #     Optional. Amount of inodes available on filesystem that kubelet uses for
        #     volumes, daemon logs, etc. Defines the amount of "nodefs.inodesFree" signal
        #     in kubelet. Default is unset, if not specified in the kubelet config. Linux
        #     only. It takses percentage value for now. Sample format: "30%". Must be >=
        #     5% and <= 50%. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] imagefs_available
        #   @return [::String]
        #     Optional. Amount of storage available on filesystem that container runtime
        #     uses for storing images layers. If the container filesystem and image
        #     filesystem are not separate, then imagefs can store both image layers and
        #     writeable layers. Defines the amount of "imagefs.available" signal in
        #     kubelet. Default is unset, if not specified in the kubelet config. It
        #     takses percentage value for now. Sample format: "30%". Must be >= 15% and
        #     <= 50%. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] imagefs_inodes_free
        #   @return [::String]
        #     Optional. Amount of inodes available on filesystem that container runtime
        #     uses for storing images layers. Defines the amount of "imagefs.inodesFree"
        #     signal in kubelet. Default is unset, if not specified in the kubelet
        #     config. Linux only. It takses percentage value for now. Sample format:
        #     "30%". Must be >= 5% and <= 50%. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] pid_available
        #   @return [::String]
        #     Optional. Amount of PID available for pod allocation. Defines the amount of
        #     "pid.available" signal in kubelet. Default is unset, if not specified in
        #     the kubelet config. It takses percentage value for now. Sample format:
        #     "30%". Must be >= 10% and <= 50%. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        class EvictionSignals
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Eviction grace periods are grace periods for each eviction signal.
        # @!attribute [rw] memory_available
        #   @return [::String]
        #     Optional. Grace period for eviction due to memory available signal. Sample
        #     format: "10s". Must be >= 0. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] nodefs_available
        #   @return [::String]
        #     Optional. Grace period for eviction due to nodefs available signal. Sample
        #     format: "10s". Must be >= 0. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] nodefs_inodes_free
        #   @return [::String]
        #     Optional. Grace period for eviction due to nodefs inodes free signal.
        #     Sample format: "10s". Must be >= 0. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] imagefs_available
        #   @return [::String]
        #     Optional. Grace period for eviction due to imagefs available signal. Sample
        #     format: "10s". Must be >= 0. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] imagefs_inodes_free
        #   @return [::String]
        #     Optional. Grace period for eviction due to imagefs inodes free signal.
        #     Sample format: "10s". Must be >= 0. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] pid_available
        #   @return [::String]
        #     Optional. Grace period for eviction due to pid available signal. Sample
        #     format: "10s". Must be >= 0. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        class EvictionGracePeriod
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Eviction minimum reclaims are the resource amounts of minimum reclaims for
        # each eviction signal.
        # @!attribute [rw] memory_available
        #   @return [::String]
        #     Optional. Minimum reclaim for eviction due to memory available signal. Only
        #     take percentage value for now. Sample format: "10%". Must be <=10%. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] nodefs_available
        #   @return [::String]
        #     Optional. Minimum reclaim for eviction due to nodefs available signal. Only
        #     take percentage value for now. Sample format: "10%". Must be <=10%. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] nodefs_inodes_free
        #   @return [::String]
        #     Optional. Minimum reclaim for eviction due to nodefs inodes free signal.
        #     Only take percentage value for now. Sample format: "10%". Must be <=10%.
        #     See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] imagefs_available
        #   @return [::String]
        #     Optional. Minimum reclaim for eviction due to imagefs available signal.
        #     Only take percentage value for now. Sample format: "10%". Must be <=10%.
        #     See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] imagefs_inodes_free
        #   @return [::String]
        #     Optional. Minimum reclaim for eviction due to imagefs inodes free signal.
        #     Only take percentage value for now. Sample format: "10%". Must be <=10%.
        #     See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        # @!attribute [rw] pid_available
        #   @return [::String]
        #     Optional. Minimum reclaim for eviction due to pid available signal. Only
        #     take percentage value for now. Sample format: "10%". Must be <=10%. See
        #     https://kubernetes.io/docs/concepts/scheduling-eviction/node-pressure-eviction/#eviction-signals
        class EvictionMinimumReclaim
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Parameters that describe the nodes in a cluster.
        #
        # GKE Autopilot clusters do not
        # recognize parameters in `NodeConfig`. Use
        # {::Google::Cloud::Container::V1::AutoprovisioningNodePoolDefaults AutoprovisioningNodePoolDefaults}
        # instead.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     The name of a Google Compute Engine [machine
        #     type](https://cloud.google.com/compute/docs/machine-types)
        #
        #     If unspecified, the default machine type is `e2-medium`.
        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     Size of the disk attached to each node, specified in GB.
        #     The smallest allowed disk size is 10GB.
        #
        #     If unspecified, the default disk size is 100GB.
        # @!attribute [rw] oauth_scopes
        #   @return [::Array<::String>]
        #     The set of Google API scopes to be made available on all of the
        #     node VMs under the "default" service account.
        #
        #     The following scopes are recommended, but not required, and by default are
        #     not included:
        #
        #     * `https://www.googleapis.com/auth/compute` is required for mounting
        #     persistent storage on your nodes.
        #     * `https://www.googleapis.com/auth/devstorage.read_only` is required for
        #     communicating with **gcr.io**
        #     (the [Artifact Registry](https://cloud.google.com/artifact-registry/)).
        #
        #     If unspecified, no scopes are added, unless Cloud Logging or Cloud
        #     Monitoring are enabled, in which case their required scopes will be added.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The Google Cloud Platform Service Account to be used by the node VMs.
        #     Specify the email address of the Service Account; otherwise, if no Service
        #     Account is specified, the "default" service account is used.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The metadata key/value pairs assigned to instances in the cluster.
        #
        #     Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
        #     in length. These are reflected as part of a URL in the metadata server.
        #     Additionally, to avoid ambiguity, keys must not conflict with any other
        #     metadata keys for the project or be one of the reserved keys:
        #
        #      - "cluster-location"
        #      - "cluster-name"
        #      - "cluster-uid"
        #      - "configure-sh"
        #      - "containerd-configure-sh"
        #      - "enable-os-login"
        #      - "gci-ensure-gke-docker"
        #      - "gci-metrics-enabled"
        #      - "gci-update-strategy"
        #      - "instance-template"
        #      - "kube-env"
        #      - "startup-script"
        #      - "user-data"
        #      - "disable-address-manager"
        #      - "windows-startup-script-ps1"
        #      - "common-psm1"
        #      - "k8s-node-setup-psm1"
        #      - "install-ssh-psm1"
        #      - "user-profile-psm1"
        #
        #     Values are free-form strings, and only have meaning as interpreted by
        #     the image running in the instance. The only restriction placed on them is
        #     that each value's size must be less than or equal to 32 KB.
        #
        #     The total size of all keys and values must be less than 512 KB.
        # @!attribute [rw] image_type
        #   @return [::String]
        #     The image type to use for this node. Note that for a given image type,
        #     the latest version of it will be used. Please see
        #     https://cloud.google.com/kubernetes-engine/docs/concepts/node-images
        #     for available image types.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The map of Kubernetes labels (key/value pairs) to be applied to each node.
        #     These will added in addition to any default label(s) that
        #     Kubernetes may apply to the node.
        #     In case of conflict in label keys, the applied set may differ depending on
        #     the Kubernetes version -- it's best to assume the behavior is undefined
        #     and conflicts should be avoided.
        #     For more information, including usage and the valid values, see:
        #     https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
        # @!attribute [rw] local_ssd_count
        #   @return [::Integer]
        #     The number of local SSD disks to be attached to the node.
        #
        #     The limit for this value is dependent upon the maximum number of
        #     disks available on a machine per zone. See:
        #     https://cloud.google.com/compute/docs/disks/local-ssd
        #     for more information.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     The list of instance tags applied to all nodes. Tags are used to identify
        #     valid sources or targets for network firewalls and are specified by
        #     the client during cluster or node pool creation. Each tag within the list
        #     must comply with RFC1035.
        # @!attribute [rw] preemptible
        #   @return [::Boolean]
        #     Whether the nodes are created as preemptible VM instances. See:
        #     https://cloud.google.com/compute/docs/instances/preemptible
        #     for more information about preemptible VM instances.
        # @!attribute [rw] accelerators
        #   @return [::Array<::Google::Cloud::Container::V1::AcceleratorConfig>]
        #     A list of hardware accelerators to be attached to each node.
        #     See
        #     https://cloud.google.com/compute/docs/gpus
        #     for more information about support for GPUs.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
        #     'pd-balanced')
        #
        #     If unspecified, the default disk type is 'pd-standard'
        # @!attribute [rw] min_cpu_platform
        #   @return [::String]
        #     Minimum CPU platform to be used by this instance. The instance may be
        #     scheduled on the specified or newer CPU platform. Applicable values are the
        #     friendly names of CPU platforms, such as
        #     `minCpuPlatform: "Intel Haswell"` or
        #     `minCpuPlatform: "Intel Sandy Bridge"`. For more
        #     information, read [how to specify min CPU
        #     platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        # @!attribute [rw] workload_metadata_config
        #   @return [::Google::Cloud::Container::V1::WorkloadMetadataConfig]
        #     The workload metadata configuration for this node.
        # @!attribute [rw] taints
        #   @return [::Array<::Google::Cloud::Container::V1::NodeTaint>]
        #     List of kubernetes taints to be applied to each node.
        #
        #     For more information, including usage and the valid values, see:
        #     https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
        # @!attribute [rw] sandbox_config
        #   @return [::Google::Cloud::Container::V1::SandboxConfig]
        #     Sandbox configuration for this node.
        # @!attribute [rw] node_group
        #   @return [::String]
        #     Setting this field will assign instances of this
        #     pool to run on the specified node group. This is useful for running
        #     workloads on [sole tenant
        #     nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
        # @!attribute [rw] reservation_affinity
        #   @return [::Google::Cloud::Container::V1::ReservationAffinity]
        #     The optional reservation affinity. Setting this field will apply
        #     the specified [Zonal Compute
        #     Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
        #     to this node pool.
        # @!attribute [rw] shielded_instance_config
        #   @return [::Google::Cloud::Container::V1::ShieldedInstanceConfig]
        #     Shielded Instance options.
        # @!attribute [rw] linux_node_config
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig]
        #     Parameters that can be configured on Linux nodes.
        # @!attribute [rw] kubelet_config
        #   @return [::Google::Cloud::Container::V1::NodeKubeletConfig]
        #     Node kubelet configs.
        # @!attribute [rw] boot_disk_kms_key
        #   @return [::String]
        #     The Customer Managed Encryption Key used to encrypt the boot disk attached
        #     to each node in the node pool. This should be of the form
        #     projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
        #     For more information about protecting resources with Cloud KMS Keys please
        #     see:
        #     https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        # @!attribute [rw] gcfs_config
        #   @return [::Google::Cloud::Container::V1::GcfsConfig]
        #     Google Container File System (image streaming) configs.
        # @!attribute [rw] advanced_machine_features
        #   @return [::Google::Cloud::Container::V1::AdvancedMachineFeatures]
        #     Advanced features for the Compute Engine VM.
        # @!attribute [rw] gvnic
        #   @return [::Google::Cloud::Container::V1::VirtualNIC]
        #     Enable or disable gvnic in the node pool.
        # @!attribute [rw] spot
        #   @return [::Boolean]
        #     Spot flag for enabling Spot VM, which is a rebrand of
        #     the existing preemptible flag.
        # @!attribute [rw] confidential_nodes
        #   @return [::Google::Cloud::Container::V1::ConfidentialNodes]
        #     Confidential nodes config.
        #     All the nodes in the node pool will be Confidential VM once enabled.
        # @!attribute [rw] fast_socket
        #   @return [::Google::Cloud::Container::V1::FastSocket]
        #     Enable or disable NCCL fast socket for the node pool.
        # @!attribute [rw] resource_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The resource labels for the node pool to use to annotate any related
        #     Google Compute Engine resources.
        # @!attribute [rw] logging_config
        #   @return [::Google::Cloud::Container::V1::NodePoolLoggingConfig]
        #     Logging configuration.
        # @!attribute [rw] windows_node_config
        #   @return [::Google::Cloud::Container::V1::WindowsNodeConfig]
        #     Parameters that can be configured on Windows nodes.
        # @!attribute [rw] local_nvme_ssd_block_config
        #   @return [::Google::Cloud::Container::V1::LocalNvmeSsdBlockConfig]
        #     Parameters for using raw-block Local NVMe SSDs.
        # @!attribute [rw] ephemeral_storage_local_ssd_config
        #   @return [::Google::Cloud::Container::V1::EphemeralStorageLocalSsdConfig]
        #     Parameters for the node ephemeral storage using Local SSDs.
        #     If unspecified, ephemeral storage is backed by the boot disk.
        # @!attribute [rw] sole_tenant_config
        #   @return [::Google::Cloud::Container::V1::SoleTenantConfig]
        #     Parameters for node pools to be backed by shared sole tenant node groups.
        # @!attribute [rw] containerd_config
        #   @return [::Google::Cloud::Container::V1::ContainerdConfig]
        #     Parameters for containerd customization.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Cloud::Container::V1::ResourceManagerTags]
        #     A map of resource manager tag keys and values to be attached to the nodes.
        # @!attribute [rw] enable_confidential_storage
        #   @return [::Boolean]
        #     Optional. Reserved for future use.
        # @!attribute [rw] secondary_boot_disks
        #   @return [::Array<::Google::Cloud::Container::V1::SecondaryBootDisk>]
        #     List of secondary boot disks attached to the nodes.
        # @!attribute [rw] storage_pools
        #   @return [::Array<::String>]
        #     List of Storage Pools where boot disks are provisioned.
        # @!attribute [rw] secondary_boot_disk_update_strategy
        #   @return [::Google::Cloud::Container::V1::SecondaryBootDiskUpdateStrategy]
        #     Secondary boot disk update strategy.
        # @!attribute [rw] max_run_duration
        #   @return [::Google::Protobuf::Duration]
        #     The maximum duration for the nodes to exist.
        #     If unspecified, the nodes can exist indefinitely.
        # @!attribute [rw] local_ssd_encryption_mode
        #   @return [::Google::Cloud::Container::V1::NodeConfig::LocalSsdEncryptionMode]
        #     Specifies which method should be used for encrypting the
        #     Local SSDs attached to the node.
        # @!attribute [r] effective_cgroup_mode
        #   @return [::Google::Cloud::Container::V1::NodeConfig::EffectiveCgroupMode]
        #     Output only. effective_cgroup_mode is the cgroup mode actually used by the
        #     node pool. It is determined by the cgroup mode specified in the
        #     LinuxNodeConfig or the default cgroup mode based on the cluster creation
        #     version.
        # @!attribute [rw] flex_start
        #   @return [::Boolean]
        #     Flex Start flag for enabling Flex Start VM.
        # @!attribute [rw] boot_disk
        #   @return [::Google::Cloud::Container::V1::BootDisk]
        #     The boot disk configuration for the node pool.
        class NodeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # LocalSsdEncryptionMode specifies the method used for encrypting the Local
          # SSDs attached to the node.
          module LocalSsdEncryptionMode
            # The given node will be encrypted using keys managed by Google
            # infrastructure and the keys will be deleted when the node is
            # deleted.
            LOCAL_SSD_ENCRYPTION_MODE_UNSPECIFIED = 0

            # The given node will be encrypted using keys managed by Google
            # infrastructure and the keys will be deleted when the node is
            # deleted.
            STANDARD_ENCRYPTION = 1

            # The given node will opt-in for using ephemeral key for
            # encryption of Local SSDs.
            # The Local SSDs will not be able to recover data in case of node
            # crash.
            EPHEMERAL_KEY_ENCRYPTION = 2
          end

          # Possible effective cgroup modes for the node.
          module EffectiveCgroupMode
            # EFFECTIVE_CGROUP_MODE_UNSPECIFIED means the cgroup configuration for the
            # node pool is unspecified, i.e. the node pool is a Windows node pool.
            EFFECTIVE_CGROUP_MODE_UNSPECIFIED = 0

            # CGROUP_MODE_V1 means the node pool is configured to use cgroupv1 for the
            # cgroup configuration.
            EFFECTIVE_CGROUP_MODE_V1 = 1

            # CGROUP_MODE_V2 means the node pool is configured to use cgroupv2 for the
            # cgroup configuration.
            EFFECTIVE_CGROUP_MODE_V2 = 2
          end
        end

        # Specifies options for controlling advanced machine features.
        # @!attribute [rw] threads_per_core
        #   @return [::Integer]
        #     The number of threads per physical core. To disable simultaneous
        #     multithreading (SMT) set this to 1. If unset, the maximum number of threads
        #     supported per core by the underlying processor is assumed.
        # @!attribute [rw] enable_nested_virtualization
        #   @return [::Boolean]
        #     Whether or not to enable nested virtualization (defaults to false).
        # @!attribute [rw] performance_monitoring_unit
        #   @return [::Google::Cloud::Container::V1::AdvancedMachineFeatures::PerformanceMonitoringUnit]
        #     Type of Performance Monitoring Unit (PMU) requested on node pool instances.
        #     If unset, PMU will not be available to the node.
        class AdvancedMachineFeatures
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Level of PMU access.
          module PerformanceMonitoringUnit
            # PMU not enabled.
            PERFORMANCE_MONITORING_UNIT_UNSPECIFIED = 0

            # Architecturally defined non-LLC events.
            ARCHITECTURAL = 1

            # Most documented core/L2 events.
            STANDARD = 2

            # Most documented core/L2 and LLC events.
            ENHANCED = 3
          end
        end

        # Parameters for node pool-level network config.
        # @!attribute [rw] create_pod_range
        #   @return [::Boolean]
        #     Input only. Whether to create a new range for pod IPs in this node pool.
        #     Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
        #     are not specified.
        #
        #     If neither `create_pod_range` or `pod_range` are specified, the
        #     cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
        #     used.
        #
        #     Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
        #
        #     This field cannot be changed after the node pool has been created.
        # @!attribute [rw] pod_range
        #   @return [::String]
        #     The ID of the secondary range for pod IPs.
        #     If `create_pod_range` is true, this ID is used for the new range.
        #     If `create_pod_range` is false, uses an existing secondary range with this
        #     ID.
        #
        #     Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
        #
        #     This field cannot be changed after the node pool has been created.
        # @!attribute [rw] pod_ipv4_cidr_block
        #   @return [::String]
        #     The IP address range for pod IPs in this node pool.
        #
        #     Only applicable if `create_pod_range` is true.
        #
        #     Set to blank to have a range chosen with the default size.
        #
        #     Set to /netmask (e.g. `/14`) to have a range chosen with a specific
        #     netmask.
        #
        #     Set to a
        #     [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
        #     notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
        #
        #     Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
        #
        #     This field cannot be changed after the node pool has been created.
        # @!attribute [rw] enable_private_nodes
        #   @return [::Boolean]
        #     Whether nodes have internal IP addresses only.
        #     If enable_private_nodes is not specified, then the value is derived from
        #     [Cluster.NetworkConfig.default_enable_private_nodes][]
        # @!attribute [rw] network_performance_config
        #   @return [::Google::Cloud::Container::V1::NodeNetworkConfig::NetworkPerformanceConfig]
        #     Network bandwidth tier configuration.
        # @!attribute [rw] pod_cidr_overprovision_config
        #   @return [::Google::Cloud::Container::V1::PodCIDROverprovisionConfig]
        #     [PRIVATE FIELD]
        #     Pod CIDR size overprovisioning config for the nodepool.
        #
        #     Pod CIDR size per node depends on max_pods_per_node. By default, the value
        #     of max_pods_per_node is rounded off to next power of 2 and we then double
        #     that to get the size of pod CIDR block per node.
        #     Example: max_pods_per_node of 30 would result in 64 IPs (/26).
        #
        #     This config can disable the doubling of IPs (we still round off to next
        #     power of 2)
        #     Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
        #     overprovisioning is disabled.
        # @!attribute [rw] additional_node_network_configs
        #   @return [::Array<::Google::Cloud::Container::V1::AdditionalNodeNetworkConfig>]
        #     We specify the additional node networks for this node pool using this list.
        #     Each node network corresponds to an additional interface
        # @!attribute [rw] additional_pod_network_configs
        #   @return [::Array<::Google::Cloud::Container::V1::AdditionalPodNetworkConfig>]
        #     We specify the additional pod networks for this node pool using this list.
        #     Each pod network corresponds to an additional alias IP range for the node
        # @!attribute [r] pod_ipv4_range_utilization
        #   @return [::Float]
        #     Output only. The utilization of the IPv4 range for the pod.
        #     The ratio is Usage/[Total number of IPs in the secondary range],
        #     Usage=numNodes*numZones*podIPsPerNode.
        # @!attribute [r] subnetwork
        #   @return [::String]
        #     Output only. The subnetwork path for the node pool.
        #     Format: projects/\\{project}/regions/\\{region}/subnetworks/\\{subnetwork}
        #     If the cluster is associated with multiple subnetworks, the subnetwork for
        #     the node pool is picked based on the IP utilization during node pool
        #     creation and is immutable.
        # @!attribute [r] network_tier_config
        #   @return [::Google::Cloud::Container::V1::NetworkTierConfig]
        #     Output only. The network tier configuration for the node pool inherits from
        #     the cluster-level configuration and remains immutable throughout the node
        #     pool's lifecycle, including during upgrades.
        class NodeNetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration of all network bandwidth tiers
          # @!attribute [rw] total_egress_bandwidth_tier
          #   @return [::Google::Cloud::Container::V1::NodeNetworkConfig::NetworkPerformanceConfig::Tier]
          #     Specifies the total network bandwidth tier for the NodePool.
          class NetworkPerformanceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Node network tier
            module Tier
              # Default value
              TIER_UNSPECIFIED = 0

              # Higher bandwidth, actual values based on VM size.
              TIER_1 = 1
            end
          end
        end

        # AdditionalNodeNetworkConfig is the configuration for additional node networks
        # within the NodeNetworkConfig message
        # @!attribute [rw] network
        #   @return [::String]
        #     Name of the VPC where the additional interface belongs
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Name of the subnetwork where the additional interface belongs
        class AdditionalNodeNetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AdditionalPodNetworkConfig is the configuration for additional pod networks
        # within the NodeNetworkConfig message
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Name of the subnetwork where the additional pod network belongs.
        # @!attribute [rw] secondary_pod_range
        #   @return [::String]
        #     The name of the secondary range on the subnet which provides IP address for
        #     this pod range.
        # @!attribute [rw] max_pods_per_node
        #   @return [::Google::Cloud::Container::V1::MaxPodsConstraint]
        #     The maximum number of pods per node which use this pod network.
        class AdditionalPodNetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of Shielded Instance options.
        # @!attribute [rw] enable_secure_boot
        #   @return [::Boolean]
        #     Defines whether the instance has Secure Boot enabled.
        #
        #     Secure Boot helps ensure that the system only runs authentic software by
        #     verifying the digital signature of all boot components, and halting the
        #     boot process if signature verification fails.
        # @!attribute [rw] enable_integrity_monitoring
        #   @return [::Boolean]
        #     Defines whether the instance has integrity monitoring enabled.
        #
        #     Enables monitoring and attestation of the boot integrity of the instance.
        #     The attestation is performed against the integrity policy baseline. This
        #     baseline is initially derived from the implicitly trusted boot image when
        #     the instance is created.
        class ShieldedInstanceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SandboxConfig contains configurations of the sandbox to use for the node.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Container::V1::SandboxConfig::Type]
        #     Type of the sandbox to use for the node.
        class SandboxConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible types of sandboxes.
          module Type
            # Default value. This should not be used.
            UNSPECIFIED = 0

            # Run sandbox using gvisor.
            GVISOR = 1
          end
        end

        # GcfsConfig contains configurations of Google Container File System
        # (image streaming).
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether to use GCFS.
        class GcfsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # [ReservationAffinity](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
        # is the configuration of desired reservation which instances could take
        # capacity from.
        # @!attribute [rw] consume_reservation_type
        #   @return [::Google::Cloud::Container::V1::ReservationAffinity::Type]
        #     Corresponds to the type of reservation consumption.
        # @!attribute [rw] key
        #   @return [::String]
        #     Corresponds to the label key of a reservation resource. To target a
        #     SPECIFIC_RESERVATION by name, specify
        #     "compute.googleapis.com/reservation-name" as the key and specify the name
        #     of your reservation as its value.
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        #     Corresponds to the label value(s) of reservation resource(s).
        class ReservationAffinity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicates whether to consume capacity from a reservation or not.
          module Type
            # Default value. This should not be used.
            UNSPECIFIED = 0

            # Do not consume from any reserved capacity.
            NO_RESERVATION = 1

            # Consume any reservation available.
            ANY_RESERVATION = 2

            # Must consume from a specific reservation. Must specify key value fields
            # for specifying the reservations.
            SPECIFIC_RESERVATION = 3
          end
        end

        # SoleTenantConfig contains the NodeAffinities to specify what shared sole
        # tenant node groups should back the node pool.
        # @!attribute [rw] node_affinities
        #   @return [::Array<::Google::Cloud::Container::V1::SoleTenantConfig::NodeAffinity>]
        #     NodeAffinities used to match to a shared sole tenant node group.
        # @!attribute [rw] min_node_cpus
        #   @return [::Integer]
        #     Optional. The minimum number of virtual CPUs this instance will consume
        #     when running on a sole-tenant node. This field can only be set if the node
        #     pool is created in a shared sole-tenant node group.
        class SoleTenantConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the NodeAffinity key, values, and affinity operator according to
          # [shared sole tenant node group
          # affinities](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes#node_affinity_and_anti-affinity).
          # @!attribute [rw] key
          #   @return [::String]
          #     Key for NodeAffinity.
          # @!attribute [rw] operator
          #   @return [::Google::Cloud::Container::V1::SoleTenantConfig::NodeAffinity::Operator]
          #     Operator for NodeAffinity.
          # @!attribute [rw] values
          #   @return [::Array<::String>]
          #     Values for NodeAffinity.
          class NodeAffinity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Operator allows user to specify affinity or anti-affinity for the
            # given key values.
            module Operator
              # Invalid or unspecified affinity operator.
              OPERATOR_UNSPECIFIED = 0

              # Affinity operator.
              IN = 1

              # Anti-affinity operator.
              NOT_IN = 2
            end
          end
        end

        # ContainerdConfig contains configuration to customize containerd.
        # @!attribute [rw] private_registry_access_config
        #   @return [::Google::Cloud::Container::V1::ContainerdConfig::PrivateRegistryAccessConfig]
        #     PrivateRegistryAccessConfig is used to configure access configuration
        #     for private container registries.
        # @!attribute [rw] writable_cgroups
        #   @return [::Google::Cloud::Container::V1::ContainerdConfig::WritableCgroups]
        #     Optional. WritableCgroups defines writable cgroups configuration for the
        #     node pool.
        class ContainerdConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # PrivateRegistryAccessConfig contains access configuration for
          # private container registries.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Private registry access is enabled.
          # @!attribute [rw] certificate_authority_domain_config
          #   @return [::Array<::Google::Cloud::Container::V1::ContainerdConfig::PrivateRegistryAccessConfig::CertificateAuthorityDomainConfig>]
          #     Private registry access configuration.
          class PrivateRegistryAccessConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # CertificateAuthorityDomainConfig configures one or more fully qualified
            # domain names (FQDN) to a specific certificate.
            # @!attribute [rw] fqdns
            #   @return [::Array<::String>]
            #     List of fully qualified domain names (FQDN).
            #     Specifying port is supported.
            #     Wildcards are NOT supported.
            #     Examples:
            #     - my.customdomain.com
            #     - 10.0.1.2:5000
            # @!attribute [rw] gcp_secret_manager_certificate_config
            #   @return [::Google::Cloud::Container::V1::ContainerdConfig::PrivateRegistryAccessConfig::CertificateAuthorityDomainConfig::GCPSecretManagerCertificateConfig]
            #     Google Secret Manager (GCP) certificate configuration.
            class CertificateAuthorityDomainConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # GCPSecretManagerCertificateConfig configures a secret from
              # [Secret Manager](https://cloud.google.com/secret-manager).
              # @!attribute [rw] secret_uri
              #   @return [::String]
              #     Secret URI, in the form
              #     "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
              #     Version can be fixed (e.g. "2") or "latest"
              class GCPSecretManagerCertificateConfig
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # Defines writable cgroups configuration.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Optional. Whether writable cgroups is enabled.
          class WritableCgroups
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Kubernetes taint is composed of three fields: key, value, and effect. Effect
        # can only be one of three types:  NoSchedule, PreferNoSchedule or NoExecute.
        #
        # See
        # [here](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration)
        # for more information, including usage and the valid values.
        # @!attribute [rw] key
        #   @return [::String]
        #     Key for taint.
        # @!attribute [rw] value
        #   @return [::String]
        #     Value for taint.
        # @!attribute [rw] effect
        #   @return [::Google::Cloud::Container::V1::NodeTaint::Effect]
        #     Effect for taint.
        class NodeTaint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible values for Effect in taint.
          module Effect
            # Not set
            EFFECT_UNSPECIFIED = 0

            # NoSchedule
            NO_SCHEDULE = 1

            # PreferNoSchedule
            PREFER_NO_SCHEDULE = 2

            # NoExecute
            NO_EXECUTE = 3
          end
        end

        # Collection of Kubernetes [node
        # taints](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration).
        # @!attribute [rw] taints
        #   @return [::Array<::Google::Cloud::Container::V1::NodeTaint>]
        #     List of node taints.
        class NodeTaints
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Collection of node-level [Kubernetes
        # labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels).
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Map of node label keys and node label values.
        class NodeLabels
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Collection of [Resource Manager
        # labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels).
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Map of node label keys and node label values.
        class ResourceLabels
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Collection of Compute Engine network tags that can be applied to a node's
        # underlying VM instance.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     List of network tags.
        class NetworkTags
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The authentication information for accessing the master endpoint.
        # Authentication can be done using HTTP basic auth or using client
        # certificates.
        # @!attribute [rw] username
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     The username to use for HTTP basic authentication to the master endpoint.
        #     For clusters v1.6.0 and later, basic authentication can be disabled by
        #     leaving username unspecified (or setting it to the empty string).
        #
        #     Warning: basic authentication is deprecated, and will be removed in GKE
        #     control plane versions 1.19 and newer. For a list of recommended
        #     authentication methods, see:
        #     https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        # @!attribute [rw] password
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     The password to use for HTTP basic authentication to the master endpoint.
        #     Because the master endpoint is open to the Internet, you should create a
        #     strong password.  If a password is provided for cluster creation, username
        #     must be non-empty.
        #
        #     Warning: basic authentication is deprecated, and will be removed in GKE
        #     control plane versions 1.19 and newer. For a list of recommended
        #     authentication methods, see:
        #     https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        # @!attribute [rw] client_certificate_config
        #   @return [::Google::Cloud::Container::V1::ClientCertificateConfig]
        #     Configuration for client certificate authentication on the cluster. For
        #     clusters before v1.12, if no configuration is specified, a client
        #     certificate is issued.
        # @!attribute [r] cluster_ca_certificate
        #   @return [::String]
        #     Output only. Base64-encoded public certificate that is the root of
        #     trust for the cluster.
        # @!attribute [r] client_certificate
        #   @return [::String]
        #     Output only. Base64-encoded public certificate used by clients to
        #     authenticate to the cluster endpoint. Issued only if
        #     client_certificate_config is set.
        # @!attribute [r] client_key
        #   @return [::String]
        #     Output only. Base64-encoded private key used by clients to authenticate
        #     to the cluster endpoint.
        class MasterAuth
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for client certificates on the cluster.
        # @!attribute [rw] issue_client_certificate
        #   @return [::Boolean]
        #     Issue a client certificate.
        class ClientCertificateConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the addons that can be automatically spun up in the
        # cluster, enabling additional functionality.
        # @!attribute [rw] http_load_balancing
        #   @return [::Google::Cloud::Container::V1::HttpLoadBalancing]
        #     Configuration for the HTTP (L7) load balancing controller addon, which
        #     makes it easy to set up HTTP load balancers for services in a cluster.
        # @!attribute [rw] horizontal_pod_autoscaling
        #   @return [::Google::Cloud::Container::V1::HorizontalPodAutoscaling]
        #     Configuration for the horizontal pod autoscaling feature, which
        #     increases or decreases the number of replica pods a replication controller
        #     has based on the resource usage of the existing pods.
        # @!attribute [rw] kubernetes_dashboard
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::KubernetesDashboard]
        #     Configuration for the Kubernetes Dashboard.
        #     This addon is deprecated, and will be disabled in 1.15. It is recommended
        #     to use the Cloud Console to manage and monitor your Kubernetes clusters,
        #     workloads and applications. For more information, see:
        #     https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
        # @!attribute [rw] network_policy_config
        #   @return [::Google::Cloud::Container::V1::NetworkPolicyConfig]
        #     Configuration for NetworkPolicy. This only tracks whether the addon
        #     is enabled or not on the Master, it does not track whether network policy
        #     is enabled for the nodes.
        # @!attribute [rw] cloud_run_config
        #   @return [::Google::Cloud::Container::V1::CloudRunConfig]
        #     Configuration for the Cloud Run addon, which allows the user to use a
        #     managed Knative service.
        # @!attribute [rw] dns_cache_config
        #   @return [::Google::Cloud::Container::V1::DnsCacheConfig]
        #     Configuration for NodeLocalDNS, a dns cache running on cluster nodes
        # @!attribute [rw] config_connector_config
        #   @return [::Google::Cloud::Container::V1::ConfigConnectorConfig]
        #     Configuration for the ConfigConnector add-on, a Kubernetes
        #     extension to manage hosted Google Cloud services through the Kubernetes
        #     API.
        # @!attribute [rw] gce_persistent_disk_csi_driver_config
        #   @return [::Google::Cloud::Container::V1::GcePersistentDiskCsiDriverConfig]
        #     Configuration for the Compute Engine Persistent Disk CSI driver.
        # @!attribute [rw] gcp_filestore_csi_driver_config
        #   @return [::Google::Cloud::Container::V1::GcpFilestoreCsiDriverConfig]
        #     Configuration for the Filestore CSI driver.
        # @!attribute [rw] gke_backup_agent_config
        #   @return [::Google::Cloud::Container::V1::GkeBackupAgentConfig]
        #     Configuration for the Backup for GKE agent addon.
        # @!attribute [rw] gcs_fuse_csi_driver_config
        #   @return [::Google::Cloud::Container::V1::GcsFuseCsiDriverConfig]
        #     Configuration for the Cloud Storage Fuse CSI driver.
        # @!attribute [rw] stateful_ha_config
        #   @return [::Google::Cloud::Container::V1::StatefulHAConfig]
        #     Optional. Configuration for the StatefulHA add-on.
        # @!attribute [rw] parallelstore_csi_driver_config
        #   @return [::Google::Cloud::Container::V1::ParallelstoreCsiDriverConfig]
        #     Configuration for the Cloud Storage Parallelstore CSI driver.
        # @!attribute [rw] ray_operator_config
        #   @return [::Google::Cloud::Container::V1::RayOperatorConfig]
        #     Optional. Configuration for Ray Operator addon.
        # @!attribute [rw] high_scale_checkpointing_config
        #   @return [::Google::Cloud::Container::V1::HighScaleCheckpointingConfig]
        #     Configuration for the High Scale Checkpointing add-on.
        # @!attribute [rw] lustre_csi_driver_config
        #   @return [::Google::Cloud::Container::V1::LustreCsiDriverConfig]
        #     Configuration for the Lustre CSI driver.
        class AddonsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration options for the HTTP (L7) load balancing controller addon,
        # which makes it easy to set up HTTP load balancers for services in a cluster.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Whether the HTTP Load Balancing controller is enabled in the cluster.
        #     When enabled, it runs a small pod in the cluster that manages the load
        #     balancers.
        class HttpLoadBalancing
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration options for the horizontal pod autoscaling feature, which
        # increases or decreases the number of replica pods a replication controller
        # has based on the resource usage of the existing pods.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Whether the Horizontal Pod Autoscaling feature is enabled in the cluster.
        #     When enabled, it ensures that metrics are collected into Stackdriver
        #     Monitoring.
        class HorizontalPodAutoscaling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the Kubernetes Dashboard.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Whether the Kubernetes Dashboard is enabled for this cluster.
        class KubernetesDashboard
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for NetworkPolicy. This only tracks whether the addon
        # is enabled or not on the Master, it does not track whether network policy
        # is enabled for the nodes.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Whether NetworkPolicy is enabled for this cluster.
        class NetworkPolicyConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for NodeLocal DNSCache
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether NodeLocal DNSCache is enabled for this cluster.
        class DnsCacheConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for controlling master global access settings.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whenever master is accessible globally or not.
        class PrivateClusterMasterGlobalAccessConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration options for private clusters.
        # @!attribute [rw] enable_private_nodes
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Whether nodes have internal IP addresses only. If enabled, all nodes are
        #     given only RFC 1918 private addresses and communicate with the master via
        #     private networking.
        #
        #     Deprecated: Use
        #     {::Google::Cloud::Container::V1::NetworkConfig#default_enable_private_nodes NetworkConfig.default_enable_private_nodes}
        #     instead.
        # @!attribute [rw] enable_private_endpoint
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Whether the master's internal IP address is used as the cluster endpoint.
        #
        #     Deprecated: Use
        #     {::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig::IPEndpointsConfig#enable_public_endpoint ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_public_endpoint}
        #     instead. Note that the value of enable_public_endpoint is reversed: if
        #     enable_private_endpoint is false, then enable_public_endpoint will be true.
        # @!attribute [rw] master_ipv4_cidr_block
        #   @return [::String]
        #     The IP range in CIDR notation to use for the hosted master network. This
        #     range will be used for assigning internal IP addresses to the master or
        #     set of masters, as well as the ILB VIP. This range must not overlap with
        #     any other ranges in use within the cluster's network.
        # @!attribute [r] private_endpoint
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. The internal IP address of this cluster's master endpoint.
        #
        #     Deprecated: Use
        #     {::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig::IPEndpointsConfig#private_endpoint ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint}
        #     instead.
        # @!attribute [r] public_endpoint
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. The external IP address of this cluster's master endpoint.
        #
        #     Deprecated:Use
        #     {::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig::IPEndpointsConfig#public_endpoint ControlPlaneEndpointsConfig.IPEndpointsConfig.public_endpoint}
        #     instead.
        # @!attribute [r] peering_name
        #   @return [::String]
        #     Output only. The peering name in the customer VPC used by this cluster.
        # @!attribute [rw] master_global_access_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::PrivateClusterMasterGlobalAccessConfig]
        #     Controls master global access settings.
        #
        #     Deprecated: Use
        #     [ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_global_access][]
        #     instead.
        # @!attribute [rw] private_endpoint_subnetwork
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Subnet to provision the master's private endpoint during cluster creation.
        #     Specified in projects/*/regions/*/subnetworks/* format.
        #
        #     Deprecated: Use
        #     {::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig::IPEndpointsConfig#private_endpoint_subnetwork ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint_subnetwork}
        #     instead.
        class PrivateClusterConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for returning group information from authenticators.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether this cluster should return group membership lookups
        #     during authentication using a group of security groups.
        # @!attribute [rw] security_group
        #   @return [::String]
        #     The name of the security group-of-groups to be used. Only relevant
        #     if enabled = true.
        class AuthenticatorGroupsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration options for the Cloud Run feature.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Whether Cloud Run addon is enabled for this cluster.
        # @!attribute [rw] load_balancer_type
        #   @return [::Google::Cloud::Container::V1::CloudRunConfig::LoadBalancerType]
        #     Which load balancer type is installed for Cloud Run.
        class CloudRunConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Load balancer type of ingress service of Cloud Run.
          module LoadBalancerType
            # Load balancer type for Cloud Run is unspecified.
            LOAD_BALANCER_TYPE_UNSPECIFIED = 0

            # Install external load balancer for Cloud Run.
            LOAD_BALANCER_TYPE_EXTERNAL = 1

            # Install internal load balancer for Cloud Run.
            LOAD_BALANCER_TYPE_INTERNAL = 2
          end
        end

        # Configuration options for the Config Connector add-on.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether Cloud Connector is enabled for this cluster.
        class ConfigConnectorConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the Compute Engine PD CSI driver.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the Compute Engine PD CSI driver is enabled for this cluster.
        class GcePersistentDiskCsiDriverConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the Filestore CSI driver.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the Filestore CSI driver is enabled for this cluster.
        class GcpFilestoreCsiDriverConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the Cloud Storage Fuse CSI driver.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the Cloud Storage Fuse CSI driver is enabled for this cluster.
        class GcsFuseCsiDriverConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the Cloud Storage Parallelstore CSI driver.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the Cloud Storage Parallelstore CSI driver is enabled for this
        #     cluster.
        class ParallelstoreCsiDriverConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the High Scale Checkpointing.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the High Scale Checkpointing is enabled for this
        #     cluster.
        class HighScaleCheckpointingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the Lustre CSI driver.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the Lustre CSI driver is enabled for this cluster.
        # @!attribute [rw] enable_legacy_lustre_port
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     If set to true, the Lustre CSI driver will install Lustre kernel modules
        #     using port 6988.
        #     This serves as a workaround for a port conflict with the
        #     gke-metadata-server. This field is required ONLY under the following
        #     conditions:
        #     1. The GKE node version is older than 1.33.2-gke.4655000.
        #     2. You're connecting to a Lustre instance that has the
        #     'gke-support-enabled' flag.
        #     Deprecated: This flag is no longer required as of GKE node version
        #     1.33.2-gke.4655000, unless you are connecting to a Lustre instance
        #     that has the `gke-support-enabled` flag.
        class LustreCsiDriverConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration options for the Ray Operator add-on.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the Ray Operator addon is enabled for this cluster.
        # @!attribute [rw] ray_cluster_logging_config
        #   @return [::Google::Cloud::Container::V1::RayClusterLoggingConfig]
        #     Optional. Logging configuration for Ray clusters.
        # @!attribute [rw] ray_cluster_monitoring_config
        #   @return [::Google::Cloud::Container::V1::RayClusterMonitoringConfig]
        #     Optional. Monitoring configuration for Ray clusters.
        class RayOperatorConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the Backup for GKE Agent.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the Backup for GKE agent is enabled for this cluster.
        class GkeBackupAgentConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the Stateful HA add-on.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the Stateful HA add-on is enabled for this cluster.
        class StatefulHAConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration options for the master authorized networks feature. Enabled
        # master authorized networks will disallow all external traffic to access
        # Kubernetes master through HTTPS except traffic from the given CIDR blocks,
        # Google Compute Engine Public IPs and Google Prod IPs.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether or not master authorized networks is enabled.
        # @!attribute [rw] cidr_blocks
        #   @return [::Array<::Google::Cloud::Container::V1::MasterAuthorizedNetworksConfig::CidrBlock>]
        #     cidr_blocks define up to 50 external networks that could access
        #     Kubernetes master through HTTPS.
        # @!attribute [rw] gcp_public_cidrs_access_enabled
        #   @return [::Boolean]
        #     Whether master is accessible via Google Compute Engine Public IP addresses.
        # @!attribute [rw] private_endpoint_enforcement_enabled
        #   @return [::Boolean]
        #     Whether master authorized networks is enforced on private endpoint or not.
        class MasterAuthorizedNetworksConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # CidrBlock contains an optional name and one CIDR block.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     display_name is an optional field for users to identify CIDR blocks.
          # @!attribute [rw] cidr_block
          #   @return [::String]
          #     cidr_block must be specified in CIDR notation.
          class CidrBlock
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration for the legacy Attribute Based Access Control authorization
        # mode.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the ABAC authorizer is enabled for this cluster. When enabled,
        #     identities in the system, including service accounts, nodes, and
        #     controllers, will have statically granted permissions beyond those
        #     provided by the RBAC configuration or IAM.
        class LegacyAbac
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration options for the NetworkPolicy feature.
        # https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
        # @!attribute [rw] provider
        #   @return [::Google::Cloud::Container::V1::NetworkPolicy::Provider]
        #     The selected network policy provider.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether network policy is enabled on the cluster.
        class NetworkPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Allowed Network Policy providers.
          module Provider
            # Not set
            PROVIDER_UNSPECIFIED = 0

            # Tigera (Calico Felix).
            CALICO = 1
          end
        end

        # Configuration for Binary Authorization.
        # @!attribute [rw] enabled
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     This field is deprecated. Leave this unset and instead configure
        #     BinaryAuthorization using evaluation_mode. If evaluation_mode is set to
        #     anything other than EVALUATION_MODE_UNSPECIFIED, this field is ignored.
        # @!attribute [rw] evaluation_mode
        #   @return [::Google::Cloud::Container::V1::BinaryAuthorization::EvaluationMode]
        #     Mode of operation for binauthz policy evaluation. If unspecified, defaults
        #     to DISABLED.
        class BinaryAuthorization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Binary Authorization mode of operation.
          module EvaluationMode
            # Default value
            EVALUATION_MODE_UNSPECIFIED = 0

            # Disable BinaryAuthorization
            DISABLED = 1

            # Enforce Kubernetes admission requests with BinaryAuthorization using the
            # project's singleton policy. This is equivalent to setting the
            # enabled boolean to true.
            PROJECT_SINGLETON_POLICY_ENFORCE = 2
          end
        end

        # [PRIVATE FIELD]
        # Config for pod CIDR size overprovisioning.
        # @!attribute [rw] disable
        #   @return [::Boolean]
        #     Whether Pod CIDR overprovisioning is disabled.
        #     Note: Pod CIDR overprovisioning is enabled by default.
        class PodCIDROverprovisionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for controlling how IPs are allocated in the cluster.
        # @!attribute [rw] use_ip_aliases
        #   @return [::Boolean]
        #     Whether alias IPs will be used for pod IPs in the cluster.
        #     This is used in conjunction with use_routes. It cannot
        #     be true if use_routes is true. If both use_ip_aliases and use_routes are
        #     false, then the server picks the default IP allocation mode
        # @!attribute [rw] create_subnetwork
        #   @return [::Boolean]
        #     Whether a new subnetwork will be created automatically for the cluster.
        #
        #     This field is only applicable when `use_ip_aliases` is true.
        # @!attribute [rw] subnetwork_name
        #   @return [::String]
        #     A custom subnetwork name to be used if `create_subnetwork` is true.  If
        #     this field is empty, then an automatic name will be chosen for the new
        #     subnetwork.
        # @!attribute [rw] cluster_ipv4_cidr
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     This field is deprecated, use cluster_ipv4_cidr_block.
        # @!attribute [rw] node_ipv4_cidr
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     This field is deprecated, use node_ipv4_cidr_block.
        # @!attribute [rw] services_ipv4_cidr
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     This field is deprecated, use services_ipv4_cidr_block.
        # @!attribute [rw] cluster_secondary_range_name
        #   @return [::String]
        #     The name of the secondary range to be used for the cluster CIDR
        #     block.  The secondary range will be used for pod IP
        #     addresses. This must be an existing secondary range associated
        #     with the cluster subnetwork.
        #
        #     This field is only applicable with use_ip_aliases is true and
        #     create_subnetwork is false.
        # @!attribute [rw] services_secondary_range_name
        #   @return [::String]
        #     The name of the secondary range to be used as for the services
        #     CIDR block.  The secondary range will be used for service
        #     ClusterIPs. This must be an existing secondary range associated
        #     with the cluster subnetwork.
        #
        #     This field is only applicable with use_ip_aliases is true and
        #     create_subnetwork is false.
        # @!attribute [rw] cluster_ipv4_cidr_block
        #   @return [::String]
        #     The IP address range for the cluster pod IPs. If this field is set, then
        #     `cluster.cluster_ipv4_cidr` must be left blank.
        #
        #     This field is only applicable when `use_ip_aliases` is true.
        #
        #     Set to blank to have a range chosen with the default size.
        #
        #     Set to /netmask (e.g. `/14`) to have a range chosen with a specific
        #     netmask.
        #
        #     Set to a
        #     [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
        #     notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
        #     `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
        #     to use.
        # @!attribute [rw] node_ipv4_cidr_block
        #   @return [::String]
        #     The IP address range of the instance IPs in this cluster.
        #
        #     This is applicable only if `create_subnetwork` is true.
        #
        #     Set to blank to have a range chosen with the default size.
        #
        #     Set to /netmask (e.g. `/14`) to have a range chosen with a specific
        #     netmask.
        #
        #     Set to a
        #     [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
        #     notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
        #     `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
        #     to use.
        # @!attribute [rw] services_ipv4_cidr_block
        #   @return [::String]
        #     The IP address range of the services IPs in this cluster. If blank, a range
        #     will be automatically chosen with the default size.
        #
        #     This field is only applicable when `use_ip_aliases` is true.
        #
        #     Set to blank to have a range chosen with the default size.
        #
        #     Set to /netmask (e.g. `/14`) to have a range chosen with a specific
        #     netmask.
        #
        #     Set to a
        #     [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
        #     notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
        #     `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
        #     to use.
        # @!attribute [rw] tpu_ipv4_cidr_block
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     The IP address range of the Cloud TPUs in this cluster. If unspecified, a
        #     range will be automatically chosen with the default size.
        #
        #     This field is only applicable when `use_ip_aliases` is true.
        #
        #     If unspecified, the range will use the default size.
        #
        #     Set to /netmask (e.g. `/14`) to have a range chosen with a specific
        #     netmask.
        #
        #     Set to a
        #     [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
        #     notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
        #     `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
        #     to use.
        #
        #     This field is deprecated due to the deprecation of 2VM TPU. The end of life
        #     date for 2VM TPU is 2025-04-25.
        # @!attribute [rw] use_routes
        #   @return [::Boolean]
        #     Whether routes will be used for pod IPs in the cluster.
        #     This is used in conjunction with use_ip_aliases. It cannot be true if
        #     use_ip_aliases is true. If both use_ip_aliases and use_routes are false,
        #     then the server picks the default IP allocation mode
        # @!attribute [rw] stack_type
        #   @return [::Google::Cloud::Container::V1::StackType]
        #     The IP stack type of the cluster
        # @!attribute [rw] ipv6_access_type
        #   @return [::Google::Cloud::Container::V1::IPv6AccessType]
        #     The ipv6 access type (internal or external) when create_subnetwork is true
        # @!attribute [rw] pod_cidr_overprovision_config
        #   @return [::Google::Cloud::Container::V1::PodCIDROverprovisionConfig]
        #     [PRIVATE FIELD]
        #     Pod CIDR size overprovisioning config for the cluster.
        #
        #     Pod CIDR size per node depends on max_pods_per_node. By default, the value
        #     of max_pods_per_node is doubled and then rounded off to next power of 2 to
        #     get the size of pod CIDR block per node.
        #     Example: max_pods_per_node of 30 would result in 64 IPs (/26).
        #
        #     This config can disable the doubling of IPs (we still round off to next
        #     power of 2)
        #     Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
        #     overprovisioning is disabled.
        # @!attribute [r] subnet_ipv6_cidr_block
        #   @return [::String]
        #     Output only. The subnet's IPv6 CIDR block used by nodes and pods.
        # @!attribute [r] services_ipv6_cidr_block
        #   @return [::String]
        #     Output only. The services IPv6 CIDR block for the cluster.
        # @!attribute [r] additional_pod_ranges_config
        #   @return [::Google::Cloud::Container::V1::AdditionalPodRangesConfig]
        #     Output only. The additional pod ranges that are added to the cluster.
        #     These pod ranges can be used by new node pools to allocate pod IPs
        #     automatically. Once the range is removed it will not show up in
        #     IPAllocationPolicy.
        # @!attribute [r] default_pod_ipv4_range_utilization
        #   @return [::Float]
        #     Output only. The utilization of the cluster default IPv4 range for the
        #     pod. The ratio is Usage/[Total number of IPs in the secondary range],
        #     Usage=numNodes*numZones*podIPsPerNode.
        # @!attribute [r] additional_ip_ranges_configs
        #   @return [::Array<::Google::Cloud::Container::V1::AdditionalIPRangesConfig>]
        #     Output only. The additional IP ranges that are added to the cluster.
        #     These IP ranges can be used by new node pools to allocate node and pod IPs
        #     automatically.
        #     Each AdditionalIPRangesConfig corresponds to a single subnetwork.
        #     Once a range is removed it will not show up in IPAllocationPolicy.
        # @!attribute [rw] auto_ipam_config
        #   @return [::Google::Cloud::Container::V1::AutoIpamConfig]
        #     Optional. AutoIpamConfig contains all information related to Auto IPAM
        # @!attribute [rw] network_tier_config
        #   @return [::Google::Cloud::Container::V1::NetworkTierConfig]
        #     Cluster-level network tier configuration is used to determine the default
        #     network tier for external IP addresses on cluster resources, such as node
        #     pools and load balancers.
        class IPAllocationPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Google Kubernetes Engine cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of this cluster. The name must be unique within this project
        #     and location (e.g. zone or region), and can be up to 40 characters with
        #     the following restrictions:
        #
        #     * Lowercase letters, numbers, and hyphens only.
        #     * Must start with a letter.
        #     * Must end with a number or a letter.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this cluster.
        # @!attribute [rw] initial_node_count
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     The number of nodes to create in this cluster. You must ensure that your
        #     Compute Engine [resource
        #     quota](https://cloud.google.com/compute/quotas)
        #     is sufficient for this number of instances. You must also have available
        #     firewall and routes quota.
        #     For requests, this field should only be used in lieu of a
        #     "node_pool" object, since this configuration (along with the
        #     "node_config") will be used to create a "NodePool" object with an
        #     auto-generated name. Do not use this and a node_pool at the same time.
        #
        #     This field is deprecated, use node_pool.initial_node_count instead.
        # @!attribute [rw] node_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::NodeConfig]
        #     Parameters used in creating the cluster's nodes.
        #     For requests, this field should only be used in lieu of a
        #     "node_pool" object, since this configuration (along with the
        #     "initial_node_count") will be used to create a "NodePool" object with an
        #     auto-generated name. Do not use this and a node_pool at the same time.
        #     For responses, this field will be populated with the node configuration of
        #     the first node pool. (For configuration of each node pool, see
        #     `node_pool.config`)
        #
        #     If unspecified, the defaults are used.
        #     This field is deprecated, use node_pool.config instead.
        # @!attribute [rw] master_auth
        #   @return [::Google::Cloud::Container::V1::MasterAuth]
        #     The authentication information for accessing the master endpoint.
        #     If unspecified, the defaults are used:
        #     For clusters before v1.12, if master_auth is unspecified, `username` will
        #     be set to "admin", a random password will be generated, and a client
        #     certificate will be issued.
        # @!attribute [rw] logging_service
        #   @return [::String]
        #     The logging service the cluster should use to write logs.
        #     Currently available options:
        #
        #     * `logging.googleapis.com/kubernetes` - The Cloud Logging
        #     service with a Kubernetes-native resource model
        #     * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
        #       available as of GKE 1.15).
        #     * `none` - no logs will be exported from the cluster.
        #
        #     If left as an empty string,`logging.googleapis.com/kubernetes` will be
        #     used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
        # @!attribute [rw] monitoring_service
        #   @return [::String]
        #     The monitoring service the cluster should use to write metrics.
        #     Currently available options:
        #
        #     * `monitoring.googleapis.com/kubernetes` - The Cloud Monitoring
        #     service with a Kubernetes-native resource model
        #     * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
        #       longer available as of GKE 1.15).
        #     * `none` - No metrics will be exported from the cluster.
        #
        #     If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
        #     used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
        # @!attribute [rw] network
        #   @return [::String]
        #     The name of the Google Compute Engine
        #     [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
        #     to which the cluster is connected. If left unspecified, the `default`
        #     network will be used.
        # @!attribute [rw] cluster_ipv4_cidr
        #   @return [::String]
        #     The IP address range of the container pods in this cluster, in
        #     [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
        #     notation (e.g. `10.96.0.0/14`). Leave blank to have
        #     one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
        # @!attribute [rw] addons_config
        #   @return [::Google::Cloud::Container::V1::AddonsConfig]
        #     Configurations for the various addons available to run in the cluster.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     The name of the Google Compute Engine
        #     [subnetwork](https://cloud.google.com/compute/docs/subnetworks)
        #     to which the cluster is connected.
        # @!attribute [rw] node_pools
        #   @return [::Array<::Google::Cloud::Container::V1::NodePool>]
        #     The node pools associated with this cluster.
        #     This field should not be set if "node_config" or "initial_node_count" are
        #     specified.
        # @!attribute [rw] locations
        #   @return [::Array<::String>]
        #     The list of Google Compute Engine
        #     [zones](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster's nodes should be located.
        #
        #     This field provides a default value if
        #     [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
        #     are not specified during node pool creation.
        #
        #     Warning: changing cluster locations will update the
        #     [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
        #     of all node pools and will result in nodes being added and/or removed.
        # @!attribute [rw] enable_kubernetes_alpha
        #   @return [::Boolean]
        #     Kubernetes alpha features are enabled on this cluster. This includes alpha
        #     API groups (e.g. v1alpha1) and features that may not be production ready in
        #     the kubernetes version of the master and nodes.
        #     The cluster has no SLA for uptime and master/node upgrades are disabled.
        #     Alpha enabled clusters are automatically deleted thirty days after
        #     creation.
        # @!attribute [rw] alpha_cluster_feature_gates
        #   @return [::Array<::String>]
        #     The list of user specified Kubernetes feature gates.
        #     Each string represents the activation status of a feature gate (e.g.
        #     "featureX=true" or "featureX=false")
        # @!attribute [rw] resource_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The resource labels for the cluster to use to annotate any related
        #     Google Compute Engine resources.
        # @!attribute [rw] label_fingerprint
        #   @return [::String]
        #     The fingerprint of the set of labels for this cluster.
        # @!attribute [rw] legacy_abac
        #   @return [::Google::Cloud::Container::V1::LegacyAbac]
        #     Configuration for the legacy ABAC authorization mode.
        # @!attribute [rw] network_policy
        #   @return [::Google::Cloud::Container::V1::NetworkPolicy]
        #     Configuration options for the NetworkPolicy feature.
        # @!attribute [rw] ip_allocation_policy
        #   @return [::Google::Cloud::Container::V1::IPAllocationPolicy]
        #     Configuration for cluster IP allocation.
        # @!attribute [rw] master_authorized_networks_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::MasterAuthorizedNetworksConfig]
        #     The configuration options for master authorized networks feature.
        #
        #     Deprecated: Use
        #     {::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig::IPEndpointsConfig#authorized_networks_config ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config}
        #     instead.
        # @!attribute [rw] maintenance_policy
        #   @return [::Google::Cloud::Container::V1::MaintenancePolicy]
        #     Configure the maintenance policy for this cluster.
        # @!attribute [rw] binary_authorization
        #   @return [::Google::Cloud::Container::V1::BinaryAuthorization]
        #     Configuration for Binary Authorization.
        # @!attribute [rw] autoscaling
        #   @return [::Google::Cloud::Container::V1::ClusterAutoscaling]
        #     Cluster-level autoscaling configuration.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::Container::V1::NetworkConfig]
        #     Configuration for cluster networking.
        # @!attribute [rw] default_max_pods_constraint
        #   @return [::Google::Cloud::Container::V1::MaxPodsConstraint]
        #     The default constraint on the maximum number of pods that can be run
        #     simultaneously on a node in the node pool of this cluster. Only honored
        #     if cluster created with IP Alias support.
        # @!attribute [rw] resource_usage_export_config
        #   @return [::Google::Cloud::Container::V1::ResourceUsageExportConfig]
        #     Configuration for exporting resource usages. Resource usage export is
        #     disabled when this config is unspecified.
        # @!attribute [rw] authenticator_groups_config
        #   @return [::Google::Cloud::Container::V1::AuthenticatorGroupsConfig]
        #     Configuration controlling RBAC group membership information.
        # @!attribute [rw] private_cluster_config
        #   @return [::Google::Cloud::Container::V1::PrivateClusterConfig]
        #     Configuration for private cluster.
        # @!attribute [rw] database_encryption
        #   @return [::Google::Cloud::Container::V1::DatabaseEncryption]
        #     Configuration of etcd encryption.
        # @!attribute [rw] vertical_pod_autoscaling
        #   @return [::Google::Cloud::Container::V1::VerticalPodAutoscaling]
        #     Cluster-level Vertical Pod Autoscaling configuration.
        # @!attribute [rw] shielded_nodes
        #   @return [::Google::Cloud::Container::V1::ShieldedNodes]
        #     Shielded Nodes configuration.
        # @!attribute [rw] release_channel
        #   @return [::Google::Cloud::Container::V1::ReleaseChannel]
        #     Release channel configuration. If left unspecified on cluster creation and
        #     a version is specified, the cluster is enrolled in the most mature release
        #     channel where the version is available (first checking STABLE, then
        #     REGULAR, and finally RAPID). Otherwise, if no release channel
        #     configuration and no version is specified, the cluster is enrolled in the
        #     REGULAR channel with its default version.
        # @!attribute [rw] workload_identity_config
        #   @return [::Google::Cloud::Container::V1::WorkloadIdentityConfig]
        #     Configuration for the use of Kubernetes Service Accounts in IAM policies.
        # @!attribute [rw] mesh_certificates
        #   @return [::Google::Cloud::Container::V1::MeshCertificates]
        #     Configuration for issuance of mTLS keys and certificates to Kubernetes
        #     pods.
        # @!attribute [rw] cost_management_config
        #   @return [::Google::Cloud::Container::V1::CostManagementConfig]
        #     Configuration for the fine-grained cost management feature.
        # @!attribute [rw] notification_config
        #   @return [::Google::Cloud::Container::V1::NotificationConfig]
        #     Notification configuration of the cluster.
        # @!attribute [rw] confidential_nodes
        #   @return [::Google::Cloud::Container::V1::ConfidentialNodes]
        #     Configuration of Confidential Nodes.
        #     All the nodes in the cluster will be Confidential VM once enabled.
        # @!attribute [rw] identity_service_config
        #   @return [::Google::Cloud::Container::V1::IdentityServiceConfig]
        #     Configuration for Identity Service component.
        # @!attribute [r] self_link
        #   @return [::String]
        #     Output only. Server-defined URL for the resource.
        # @!attribute [r] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field is deprecated, use location
        #     instead.
        # @!attribute [r] endpoint
        #   @return [::String]
        #     Output only. The IP address of this cluster's master endpoint.
        #     The endpoint can be accessed from the internet at
        #     `https://username:password@endpoint/`.
        #
        #     See the `masterAuth` property of this resource for username and
        #     password information.
        # @!attribute [rw] initial_cluster_version
        #   @return [::String]
        #     The initial Kubernetes version for this cluster.  Valid versions are those
        #     found in validMasterVersions returned by getServerConfig.  The version can
        #     be upgraded over time; such upgrades are reflected in
        #     currentMasterVersion and currentNodeVersion.
        #
        #     Users may specify either explicit versions offered by
        #     Kubernetes Engine or version aliases, which have the following behavior:
        #
        #     - "latest": picks the highest valid Kubernetes version
        #     - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
        #     - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
        #     - "1.X.Y-gke.N": picks an explicit Kubernetes version
        #     - "","-": picks the default Kubernetes version
        # @!attribute [r] current_master_version
        #   @return [::String]
        #     Output only. The current software version of the master endpoint.
        # @!attribute [r] current_node_version
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. Deprecated, use
        #     [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
        #     instead. The current version of the node software components. If they are
        #     currently at multiple versions because they're in the process of being
        #     upgraded, this reflects the minimum version of all nodes.
        # @!attribute [r] create_time
        #   @return [::String]
        #     Output only. The time the cluster was created, in
        #     [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Container::V1::Cluster::Status]
        #     Output only. The current status of this cluster.
        # @!attribute [r] status_message
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. Deprecated. Use conditions instead.
        #     Additional information about the current status of this
        #     cluster, if available.
        # @!attribute [r] node_ipv4_cidr_size
        #   @return [::Integer]
        #     Output only. The size of the address space on each node for hosting
        #     containers. This is provisioned from within the `container_ipv4_cidr`
        #     range. This field will only be set when cluster is in route-based network
        #     mode.
        # @!attribute [r] services_ipv4_cidr
        #   @return [::String]
        #     Output only. The IP address range of the Kubernetes services in
        #     this cluster, in
        #     [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
        #     notation (e.g. `1.2.3.4/29`). Service addresses are
        #     typically put in the last `/16` from the container CIDR.
        # @!attribute [r] instance_group_urls
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::String>]
        #     Output only. Deprecated. Use node_pools.instance_group_urls.
        # @!attribute [r] current_node_count
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     Output only. The number of nodes currently in the cluster. Deprecated.
        #     Call Kubernetes API directly to retrieve node information.
        # @!attribute [r] expire_time
        #   @return [::String]
        #     Output only. The time the cluster will be automatically
        #     deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        # @!attribute [r] location
        #   @return [::String]
        #     Output only. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
        #     or
        #     [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
        #     in which the cluster resides.
        # @!attribute [rw] enable_tpu
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Enable the ability to use Cloud TPUs in this cluster.
        #     This field is deprecated due to the deprecation of 2VM TPU. The end of life
        #     date for 2VM TPU is 2025-04-25.
        # @!attribute [r] tpu_ipv4_cidr_block
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. The IP address range of the Cloud TPUs in this cluster, in
        #     [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
        #     notation (e.g. `1.2.3.4/29`).
        #     This field is deprecated due to the deprecation of 2VM TPU. The end of life
        #     date for 2VM TPU is 2025-04-25.
        # @!attribute [rw] conditions
        #   @return [::Array<::Google::Cloud::Container::V1::StatusCondition>]
        #     Which conditions caused the current cluster state.
        # @!attribute [rw] autopilot
        #   @return [::Google::Cloud::Container::V1::Autopilot]
        #     Autopilot configuration for the cluster.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. Unique id for the cluster.
        # @!attribute [rw] node_pool_defaults
        #   @return [::Google::Cloud::Container::V1::NodePoolDefaults]
        #     Default NodePool settings for the entire cluster. These settings are
        #     overridden if specified on the specific NodePool object.
        # @!attribute [rw] logging_config
        #   @return [::Google::Cloud::Container::V1::LoggingConfig]
        #     Logging configuration for the cluster.
        # @!attribute [rw] monitoring_config
        #   @return [::Google::Cloud::Container::V1::MonitoringConfig]
        #     Monitoring configuration for the cluster.
        # @!attribute [rw] node_pool_auto_config
        #   @return [::Google::Cloud::Container::V1::NodePoolAutoConfig]
        #     Node pool configs that apply to all auto-provisioned node pools
        #     in autopilot clusters and node auto-provisioning enabled clusters.
        # @!attribute [rw] pod_autoscaling
        #   @return [::Google::Cloud::Container::V1::PodAutoscaling]
        #     The config for pod autoscaling.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of cluster
        #     fields, and may be sent on update requests to ensure the client has an
        #     up-to-date value before proceeding.
        # @!attribute [rw] fleet
        #   @return [::Google::Cloud::Container::V1::Fleet]
        #     Fleet information for the cluster.
        # @!attribute [rw] security_posture_config
        #   @return [::Google::Cloud::Container::V1::SecurityPostureConfig]
        #     Enable/Disable Security Posture API features for the cluster.
        # @!attribute [rw] control_plane_endpoints_config
        #   @return [::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig]
        #     Configuration for all cluster's control plane endpoints.
        # @!attribute [rw] enable_k8s_beta_apis
        #   @return [::Google::Cloud::Container::V1::K8sBetaAPIConfig]
        #     Beta APIs Config
        # @!attribute [rw] enterprise_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::EnterpriseConfig]
        #     GKE Enterprise Configuration.
        #
        #     Deprecated: GKE Enterprise features are now available without an Enterprise
        #     tier.
        # @!attribute [rw] secret_manager_config
        #   @return [::Google::Cloud::Container::V1::SecretManagerConfig]
        #     Secret CSI driver configuration.
        # @!attribute [rw] compliance_posture_config
        #   @return [::Google::Cloud::Container::V1::CompliancePostureConfig]
        #     Enable/Disable Compliance Posture features for the cluster.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] user_managed_keys_config
        #   @return [::Google::Cloud::Container::V1::UserManagedKeysConfig]
        #     The Custom keys configuration for the cluster.
        # @!attribute [rw] rbac_binding_config
        #   @return [::Google::Cloud::Container::V1::RBACBindingConfig]
        #     RBACBindingConfig allows user to restrict ClusterRoleBindings an
        #     RoleBindings that can be created.
        # @!attribute [rw] gke_auto_upgrade_config
        #   @return [::Google::Cloud::Container::V1::GkeAutoUpgradeConfig]
        #     Configuration for GKE auto upgrades.
        # @!attribute [rw] anonymous_authentication_config
        #   @return [::Google::Cloud::Container::V1::AnonymousAuthenticationConfig]
        #     Configuration for limiting anonymous access to all endpoints except the
        #     health checks.
        class Cluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The current status of the cluster.
          module Status
            # Not set.
            STATUS_UNSPECIFIED = 0

            # The PROVISIONING state indicates the cluster is being created.
            PROVISIONING = 1

            # The RUNNING state indicates the cluster has been created and is fully
            # usable.
            RUNNING = 2

            # The RECONCILING state indicates that some work is actively being done on
            # the cluster, such as upgrading the master or node software. Details can
            # be found in the `statusMessage` field.
            RECONCILING = 3

            # The STOPPING state indicates the cluster is being deleted.
            STOPPING = 4

            # The ERROR state indicates the cluster is unusable. It will be
            # automatically deleted. Details can be found in the `statusMessage` field.
            ERROR = 5

            # The DEGRADED state indicates the cluster requires user action to restore
            # full functionality. Details can be found in the `statusMessage` field.
            DEGRADED = 6
          end
        end

        # RBACBindingConfig allows user to restrict ClusterRoleBindings an RoleBindings
        # that can be created.
        # @!attribute [rw] enable_insecure_binding_system_unauthenticated
        #   @return [::Boolean]
        #     Setting this to true will allow any ClusterRoleBinding and RoleBinding
        #     with subjets system:anonymous or system:unauthenticated.
        # @!attribute [rw] enable_insecure_binding_system_authenticated
        #   @return [::Boolean]
        #     Setting this to true will allow any ClusterRoleBinding and RoleBinding
        #     with subjects system:authenticated.
        class RBACBindingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UserManagedKeysConfig holds the resource address to Keys which are used
        # for signing certs and token that are used for communication within cluster.
        # @!attribute [rw] cluster_ca
        #   @return [::String]
        #     The Certificate Authority Service caPool to use for the cluster CA in this
        #     cluster.
        # @!attribute [rw] etcd_api_ca
        #   @return [::String]
        #     Resource path of the Certificate Authority Service caPool to use for the
        #     etcd API CA in this cluster.
        # @!attribute [rw] etcd_peer_ca
        #   @return [::String]
        #     Resource path of the Certificate Authority Service caPool to use for the
        #     etcd peer CA in this cluster.
        # @!attribute [rw] service_account_signing_keys
        #   @return [::Array<::String>]
        #     The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
        #     issued by this cluster.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
        # @!attribute [rw] service_account_verification_keys
        #   @return [::Array<::String>]
        #     The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
        #     issued by this cluster.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
        # @!attribute [rw] aggregation_ca
        #   @return [::String]
        #     The Certificate Authority Service caPool to use for the aggregation CA in
        #     this cluster.
        # @!attribute [rw] control_plane_disk_encryption_key
        #   @return [::String]
        #     The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
        #     plane nodes.
        # @!attribute [rw] gkeops_etcd_backup_encryption_key
        #   @return [::String]
        #     Resource path of the Cloud KMS cryptoKey to use for encryption of internal
        #     etcd backups.
        class UserManagedKeysConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AnonymousAuthenticationConfig defines the settings needed to limit endpoints
        # that allow anonymous authentication.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::Container::V1::AnonymousAuthenticationConfig::Mode]
        #     Defines the mode of limiting anonymous access in the cluster.
        class AnonymousAuthenticationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Mode defines the mode of anonymous authentication
          # allowed in the cluster.
          module Mode
            # Default value not specified.
            MODE_UNSPECIFIED = 0

            # Anonymous authentication is allowed for all endpoints.
            ENABLED = 1

            # Anonymous authentication is allowed for only health check endpoints.
            LIMITED = 2
          end
        end

        # CompliancePostureConfig defines the settings needed to enable/disable
        # features for the Compliance Posture.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::Container::V1::CompliancePostureConfig::Mode]
        #     Defines the enablement mode for Compliance Posture.
        # @!attribute [rw] compliance_standards
        #   @return [::Array<::Google::Cloud::Container::V1::CompliancePostureConfig::ComplianceStandard>]
        #     List of enabled compliance standards.
        class CompliancePostureConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines the details of a compliance standard.
          # @!attribute [rw] standard
          #   @return [::String]
          #     Name of the compliance standard.
          class ComplianceStandard
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Mode defines enablement mode for Compliance Posture.
          module Mode
            # Default value not specified.
            MODE_UNSPECIFIED = 0

            # Disables Compliance Posture features on the cluster.
            DISABLED = 1

            # Enables Compliance Posture features on the cluster.
            ENABLED = 2
          end
        end

        # K8sBetaAPIConfig , configuration for beta APIs
        # @!attribute [rw] enabled_apis
        #   @return [::Array<::String>]
        #     Enabled k8s beta APIs.
        class K8sBetaAPIConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SecurityPostureConfig defines the flags needed to enable/disable features for
        # the Security Posture API.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::Container::V1::SecurityPostureConfig::Mode]
        #     Sets which mode to use for Security Posture features.
        # @!attribute [rw] vulnerability_mode
        #   @return [::Google::Cloud::Container::V1::SecurityPostureConfig::VulnerabilityMode]
        #     Sets which mode to use for vulnerability scanning.
        class SecurityPostureConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Mode defines enablement mode for GKE Security posture features.
          module Mode
            # Default value not specified.
            MODE_UNSPECIFIED = 0

            # Disables Security Posture features on the cluster.
            DISABLED = 1

            # Applies Security Posture features on the cluster.
            BASIC = 2

            # Applies the Security Posture off cluster Enterprise level features.
            ENTERPRISE = 3
          end

          # VulnerabilityMode defines enablement mode for vulnerability scanning.
          module VulnerabilityMode
            # Default value not specified.
            VULNERABILITY_MODE_UNSPECIFIED = 0

            # Disables vulnerability scanning on the cluster.
            VULNERABILITY_DISABLED = 1

            # Applies basic vulnerability scanning on the cluster.
            VULNERABILITY_BASIC = 2

            # Applies the Security Posture's vulnerability on cluster Enterprise level
            # features.
            VULNERABILITY_ENTERPRISE = 3
          end
        end

        # Node pool configs that apply to all auto-provisioned node pools
        # in autopilot clusters and node auto-provisioning enabled clusters.
        # @!attribute [rw] network_tags
        #   @return [::Google::Cloud::Container::V1::NetworkTags]
        #     The list of instance tags applied to all nodes. Tags are used to identify
        #     valid sources or targets for network firewalls and are specified by
        #     the client during cluster creation. Each tag within the list
        #     must comply with RFC1035.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Cloud::Container::V1::ResourceManagerTags]
        #     Resource manager tag keys and values to be attached to the nodes
        #     for managing Compute Engine firewalls using Network Firewall Policies.
        # @!attribute [rw] node_kubelet_config
        #   @return [::Google::Cloud::Container::V1::NodeKubeletConfig]
        #     NodeKubeletConfig controls the defaults for autoprovisioned node-pools.
        #
        #     Currently only `insecure_kubelet_readonly_port_enabled` can be set here.
        # @!attribute [r] linux_node_config
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig]
        #     Output only. Configuration options for Linux nodes.
        class NodePoolAutoConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Subset of Nodepool message that has defaults.
        # @!attribute [rw] node_config_defaults
        #   @return [::Google::Cloud::Container::V1::NodeConfigDefaults]
        #     Subset of NodeConfig message that has defaults.
        class NodePoolDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Subset of NodeConfig message that has defaults.
        # @!attribute [rw] gcfs_config
        #   @return [::Google::Cloud::Container::V1::GcfsConfig]
        #     GCFS (Google Container File System, also known as Riptide) options.
        # @!attribute [rw] logging_config
        #   @return [::Google::Cloud::Container::V1::NodePoolLoggingConfig]
        #     Logging configuration for node pools.
        # @!attribute [rw] containerd_config
        #   @return [::Google::Cloud::Container::V1::ContainerdConfig]
        #     Parameters for containerd customization.
        # @!attribute [rw] node_kubelet_config
        #   @return [::Google::Cloud::Container::V1::NodeKubeletConfig]
        #     NodeKubeletConfig controls the defaults for new node-pools.
        #
        #     Currently only `insecure_kubelet_readonly_port_enabled` can be set here.
        class NodeConfigDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ClusterUpdate describes an update to the cluster. Exactly one update can
        # be applied to a cluster with each request, so at most one field can be
        # provided.
        # @!attribute [rw] desired_node_version
        #   @return [::String]
        #     The Kubernetes version to change the nodes to (typically an
        #     upgrade).
        #
        #     Users may specify either explicit versions offered by
        #     Kubernetes Engine or version aliases, which have the following behavior:
        #
        #     - "latest": picks the highest valid Kubernetes version
        #     - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
        #     - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
        #     - "1.X.Y-gke.N": picks an explicit Kubernetes version
        #     - "-": picks the Kubernetes master version
        # @!attribute [rw] desired_monitoring_service
        #   @return [::String]
        #     The monitoring service the cluster should use to write metrics.
        #     Currently available options:
        #
        #     * `monitoring.googleapis.com/kubernetes` - The Cloud Monitoring
        #     service with a Kubernetes-native resource model
        #     * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
        #       longer available as of GKE 1.15).
        #     * `none` - No metrics will be exported from the cluster.
        #
        #     If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
        #     used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
        # @!attribute [rw] desired_addons_config
        #   @return [::Google::Cloud::Container::V1::AddonsConfig]
        #     Configurations for the various addons available to run in the cluster.
        # @!attribute [rw] desired_node_pool_id
        #   @return [::String]
        #     The node pool to be upgraded. This field is mandatory if
        #     "desired_node_version", "desired_image_family" or
        #     "desired_node_pool_autoscaling" is specified and there is more than one
        #     node pool on the cluster.
        # @!attribute [rw] desired_image_type
        #   @return [::String]
        #     The desired image type for the node pool.
        #     NOTE: Set the "desired_node_pool" field as well.
        # @!attribute [rw] desired_database_encryption
        #   @return [::Google::Cloud::Container::V1::DatabaseEncryption]
        #     Configuration of etcd encryption.
        # @!attribute [rw] desired_workload_identity_config
        #   @return [::Google::Cloud::Container::V1::WorkloadIdentityConfig]
        #     Configuration for Workload Identity.
        # @!attribute [rw] desired_mesh_certificates
        #   @return [::Google::Cloud::Container::V1::MeshCertificates]
        #     Configuration for issuance of mTLS keys and certificates to Kubernetes
        #     pods.
        # @!attribute [rw] desired_shielded_nodes
        #   @return [::Google::Cloud::Container::V1::ShieldedNodes]
        #     Configuration for Shielded Nodes.
        # @!attribute [rw] desired_cost_management_config
        #   @return [::Google::Cloud::Container::V1::CostManagementConfig]
        #     The desired configuration for the fine-grained cost management feature.
        # @!attribute [rw] desired_dns_config
        #   @return [::Google::Cloud::Container::V1::DNSConfig]
        #     DNSConfig contains clusterDNS config for this cluster.
        # @!attribute [rw] desired_node_pool_autoscaling
        #   @return [::Google::Cloud::Container::V1::NodePoolAutoscaling]
        #     Autoscaler configuration for the node pool specified in
        #     desired_node_pool_id. If there is only one pool in the
        #     cluster and desired_node_pool_id is not provided then
        #     the change applies to that single node pool.
        # @!attribute [rw] desired_locations
        #   @return [::Array<::String>]
        #     The desired list of Google Compute Engine
        #     [zones](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster's nodes should be located.
        #
        #     This list must always include the cluster's primary zone.
        #
        #     Warning: changing cluster locations will update the locations of all node
        #     pools and will result in nodes being added and/or removed.
        # @!attribute [rw] desired_master_authorized_networks_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::MasterAuthorizedNetworksConfig]
        #     The desired configuration options for master authorized networks feature.
        #
        #     Deprecated: Use
        #     desired_control_plane_endpoints_config.ip_endpoints_config.authorized_networks_config
        #     instead.
        # @!attribute [rw] desired_cluster_autoscaling
        #   @return [::Google::Cloud::Container::V1::ClusterAutoscaling]
        #     Cluster-level autoscaling configuration.
        # @!attribute [rw] desired_binary_authorization
        #   @return [::Google::Cloud::Container::V1::BinaryAuthorization]
        #     The desired configuration options for the Binary Authorization feature.
        # @!attribute [rw] desired_logging_service
        #   @return [::String]
        #     The logging service the cluster should use to write logs.
        #     Currently available options:
        #
        #     * `logging.googleapis.com/kubernetes` - The Cloud Logging
        #     service with a Kubernetes-native resource model
        #     * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
        #       available as of GKE 1.15).
        #     * `none` - no logs will be exported from the cluster.
        #
        #     If left as an empty string,`logging.googleapis.com/kubernetes` will be
        #     used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
        # @!attribute [rw] desired_resource_usage_export_config
        #   @return [::Google::Cloud::Container::V1::ResourceUsageExportConfig]
        #     The desired configuration for exporting resource usage.
        # @!attribute [rw] desired_vertical_pod_autoscaling
        #   @return [::Google::Cloud::Container::V1::VerticalPodAutoscaling]
        #     Cluster-level Vertical Pod Autoscaling configuration.
        # @!attribute [rw] desired_private_cluster_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::PrivateClusterConfig]
        #     The desired private cluster configuration. master_global_access_config is
        #     the only field that can be changed via this field.
        #     See also
        #     {::Google::Cloud::Container::V1::ClusterUpdate#desired_enable_private_endpoint ClusterUpdate.desired_enable_private_endpoint}
        #     for modifying other fields within
        #     {::Google::Cloud::Container::V1::PrivateClusterConfig PrivateClusterConfig}.
        #
        #     Deprecated: Use
        #     desired_control_plane_endpoints_config.ip_endpoints_config.global_access
        #     instead.
        # @!attribute [rw] desired_intra_node_visibility_config
        #   @return [::Google::Cloud::Container::V1::IntraNodeVisibilityConfig]
        #     The desired config of Intra-node visibility.
        # @!attribute [rw] desired_default_snat_status
        #   @return [::Google::Cloud::Container::V1::DefaultSnatStatus]
        #     The desired status of whether to disable default sNAT for this cluster.
        # @!attribute [rw] desired_release_channel
        #   @return [::Google::Cloud::Container::V1::ReleaseChannel]
        #     The desired release channel configuration.
        # @!attribute [rw] desired_l4ilb_subsetting_config
        #   @return [::Google::Cloud::Container::V1::ILBSubsettingConfig]
        #     The desired L4 Internal Load Balancer Subsetting configuration.
        # @!attribute [rw] desired_datapath_provider
        #   @return [::Google::Cloud::Container::V1::DatapathProvider]
        #     The desired datapath provider for the cluster.
        # @!attribute [rw] desired_private_ipv6_google_access
        #   @return [::Google::Cloud::Container::V1::PrivateIPv6GoogleAccess]
        #     The desired state of IPv6 connectivity to Google Services.
        # @!attribute [rw] desired_notification_config
        #   @return [::Google::Cloud::Container::V1::NotificationConfig]
        #     The desired notification configuration.
        # @!attribute [rw] desired_authenticator_groups_config
        #   @return [::Google::Cloud::Container::V1::AuthenticatorGroupsConfig]
        #     The desired authenticator groups config for the cluster.
        # @!attribute [rw] desired_logging_config
        #   @return [::Google::Cloud::Container::V1::LoggingConfig]
        #     The desired logging configuration.
        # @!attribute [rw] desired_monitoring_config
        #   @return [::Google::Cloud::Container::V1::MonitoringConfig]
        #     The desired monitoring configuration.
        # @!attribute [rw] desired_identity_service_config
        #   @return [::Google::Cloud::Container::V1::IdentityServiceConfig]
        #     The desired Identity Service component configuration.
        # @!attribute [rw] desired_service_external_ips_config
        #   @return [::Google::Cloud::Container::V1::ServiceExternalIPsConfig]
        #     ServiceExternalIPsConfig specifies the config for the use of Services with
        #     ExternalIPs field.
        # @!attribute [rw] desired_enable_private_endpoint
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Enable/Disable private endpoint for the cluster's master.
        #
        #     Deprecated: Use
        #     desired_control_plane_endpoints_config.ip_endpoints_config.enable_public_endpoint
        #     instead. Note that the value of enable_public_endpoint is reversed: if
        #     enable_private_endpoint is false, then enable_public_endpoint will be true.
        # @!attribute [rw] desired_default_enable_private_nodes
        #   @return [::Boolean]
        #     Override the default setting of whether future created
        #     nodes have private IP addresses only, namely
        #     {::Google::Cloud::Container::V1::NetworkConfig#default_enable_private_nodes NetworkConfig.default_enable_private_nodes}
        # @!attribute [rw] desired_control_plane_endpoints_config
        #   @return [::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig]
        #     [Control plane
        #     endpoints][google.container.v1.Cluster.control_plane_endpoints_config]
        #     configuration.
        # @!attribute [rw] desired_master_version
        #   @return [::String]
        #     The Kubernetes version to change the master to.
        #
        #     Users may specify either explicit versions offered by
        #     Kubernetes Engine or version aliases, which have the following behavior:
        #
        #     - "latest": picks the highest valid Kubernetes version
        #     - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
        #     - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
        #     - "1.X.Y-gke.N": picks an explicit Kubernetes version
        #     - "-": picks the default Kubernetes version
        # @!attribute [rw] desired_gcfs_config
        #   @return [::Google::Cloud::Container::V1::GcfsConfig]
        #     The desired GCFS config for the cluster
        # @!attribute [rw] desired_node_pool_auto_config_network_tags
        #   @return [::Google::Cloud::Container::V1::NetworkTags]
        #     The desired network tags that apply to all auto-provisioned node pools
        #     in autopilot clusters and node auto-provisioning enabled clusters.
        # @!attribute [rw] desired_pod_autoscaling
        #   @return [::Google::Cloud::Container::V1::PodAutoscaling]
        #     The desired config for pod autoscaling.
        # @!attribute [rw] desired_gateway_api_config
        #   @return [::Google::Cloud::Container::V1::GatewayAPIConfig]
        #     The desired config of Gateway API on this cluster.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The current etag of the cluster.
        #     If an etag is provided and does not match the current etag of the cluster,
        #     update will be blocked and an ABORTED error will be returned.
        # @!attribute [rw] desired_node_pool_logging_config
        #   @return [::Google::Cloud::Container::V1::NodePoolLoggingConfig]
        #     The desired node pool logging configuration defaults for the cluster.
        # @!attribute [rw] desired_fleet
        #   @return [::Google::Cloud::Container::V1::Fleet]
        #     The desired fleet configuration for the cluster.
        # @!attribute [rw] desired_stack_type
        #   @return [::Google::Cloud::Container::V1::StackType]
        #     The desired stack type of the cluster.
        #     If a stack type is provided and does not match the current stack type of
        #     the cluster, update will attempt to change the stack type to the new type.
        # @!attribute [rw] additional_pod_ranges_config
        #   @return [::Google::Cloud::Container::V1::AdditionalPodRangesConfig]
        #     The additional pod ranges to be added to the cluster. These pod ranges
        #     can be used by node pools to allocate pod IPs.
        # @!attribute [rw] removed_additional_pod_ranges_config
        #   @return [::Google::Cloud::Container::V1::AdditionalPodRangesConfig]
        #     The additional pod ranges that are to be removed from the cluster.
        #     The pod ranges specified here must have been specified earlier in the
        #     'additional_pod_ranges_config' argument.
        # @!attribute [rw] enable_k8s_beta_apis
        #   @return [::Google::Cloud::Container::V1::K8sBetaAPIConfig]
        #     Kubernetes open source beta apis enabled on the cluster. Only beta apis
        # @!attribute [rw] desired_security_posture_config
        #   @return [::Google::Cloud::Container::V1::SecurityPostureConfig]
        #     Enable/Disable Security Posture API features for the cluster.
        # @!attribute [rw] desired_network_performance_config
        #   @return [::Google::Cloud::Container::V1::NetworkConfig::ClusterNetworkPerformanceConfig]
        #     The desired network performance config.
        # @!attribute [rw] desired_enable_fqdn_network_policy
        #   @return [::Boolean]
        #     Enable/Disable FQDN Network Policy for the cluster.
        # @!attribute [rw] desired_autopilot_workload_policy_config
        #   @return [::Google::Cloud::Container::V1::WorkloadPolicyConfig]
        #     WorkloadPolicyConfig is the configuration related to GCW workload policy
        # @!attribute [rw] desired_k8s_beta_apis
        #   @return [::Google::Cloud::Container::V1::K8sBetaAPIConfig]
        #     Desired Beta APIs to be enabled for cluster.
        # @!attribute [rw] desired_containerd_config
        #   @return [::Google::Cloud::Container::V1::ContainerdConfig]
        #     The desired containerd config for the cluster.
        # @!attribute [rw] desired_enable_multi_networking
        #   @return [::Boolean]
        #     Enable/Disable Multi-Networking for the cluster
        # @!attribute [rw] desired_node_pool_auto_config_resource_manager_tags
        #   @return [::Google::Cloud::Container::V1::ResourceManagerTags]
        #     The desired resource manager tags that apply to all auto-provisioned node
        #     pools in autopilot clusters and node auto-provisioning enabled clusters.
        # @!attribute [rw] desired_in_transit_encryption_config
        #   @return [::Google::Cloud::Container::V1::InTransitEncryptionConfig]
        #     Specify the details of in-transit encryption.
        # @!attribute [rw] desired_enable_cilium_clusterwide_network_policy
        #   @return [::Boolean]
        #     Enable/Disable Cilium Clusterwide Network Policy for the cluster.
        # @!attribute [rw] desired_secret_manager_config
        #   @return [::Google::Cloud::Container::V1::SecretManagerConfig]
        #     Enable/Disable Secret Manager Config.
        # @!attribute [rw] desired_compliance_posture_config
        #   @return [::Google::Cloud::Container::V1::CompliancePostureConfig]
        #     Enable/Disable Compliance Posture features for the cluster.
        # @!attribute [rw] desired_node_kubelet_config
        #   @return [::Google::Cloud::Container::V1::NodeKubeletConfig]
        #     The desired node kubelet config for the cluster.
        # @!attribute [rw] desired_node_pool_auto_config_kubelet_config
        #   @return [::Google::Cloud::Container::V1::NodeKubeletConfig]
        #     The desired node kubelet config for all auto-provisioned node pools
        #     in autopilot clusters and node auto-provisioning enabled clusters.
        # @!attribute [rw] user_managed_keys_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::UserManagedKeysConfig]
        #     The Custom keys configuration for the cluster.
        #
        #     This field is deprecated.
        #     Use
        #     {::Google::Cloud::Container::V1::ClusterUpdate#desired_user_managed_keys_config ClusterUpdate.desired_user_managed_keys_config}
        #     instead.
        # @!attribute [rw] desired_rbac_binding_config
        #   @return [::Google::Cloud::Container::V1::RBACBindingConfig]
        #     RBACBindingConfig allows user to restrict ClusterRoleBindings an
        #     RoleBindings that can be created.
        # @!attribute [rw] desired_additional_ip_ranges_config
        #   @return [::Google::Cloud::Container::V1::DesiredAdditionalIPRangesConfig]
        #     The desired config for additional subnetworks attached to the cluster.
        # @!attribute [rw] desired_enterprise_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::DesiredEnterpriseConfig]
        #     The desired enterprise configuration for the cluster.
        #
        #     Deprecated: GKE Enterprise features are now available without an Enterprise
        #     tier.
        # @!attribute [rw] desired_auto_ipam_config
        #   @return [::Google::Cloud::Container::V1::AutoIpamConfig]
        #     AutoIpamConfig contains all information related to Auto IPAM
        # @!attribute [rw] desired_disable_l4_lb_firewall_reconciliation
        #   @return [::Boolean]
        #     Enable/Disable L4 LB VPC firewall reconciliation for the cluster.
        # @!attribute [rw] desired_node_pool_auto_config_linux_node_config
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig]
        #     The desired Linux node config for all auto-provisioned node pools
        #     in autopilot clusters and node auto-provisioning enabled clusters.
        #
        #     Currently only `cgroup_mode` can be set here.
        # @!attribute [rw] desired_user_managed_keys_config
        #   @return [::Google::Cloud::Container::V1::UserManagedKeysConfig]
        #     The desired user managed keys config for the cluster.
        # @!attribute [rw] desired_anonymous_authentication_config
        #   @return [::Google::Cloud::Container::V1::AnonymousAuthenticationConfig]
        #     Configuration for limiting anonymous access to all endpoints except the
        #     health checks.
        # @!attribute [rw] gke_auto_upgrade_config
        #   @return [::Google::Cloud::Container::V1::GkeAutoUpgradeConfig]
        #     Configuration for GKE auto upgrade.
        # @!attribute [rw] desired_network_tier_config
        #   @return [::Google::Cloud::Container::V1::NetworkTierConfig]
        #     The desired network tier configuration for the cluster.
        class ClusterUpdate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AdditionalPodRangesConfig is the configuration for additional pod secondary
        # ranges supporting the ClusterUpdate message.
        # @!attribute [rw] pod_range_names
        #   @return [::Array<::String>]
        #     Name for pod secondary ipv4 range which has the actual range defined ahead.
        # @!attribute [r] pod_range_info
        #   @return [::Array<::Google::Cloud::Container::V1::RangeInfo>]
        #     Output only. Information for additional pod range.
        class AdditionalPodRangesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AdditionalIPRangesConfig is the configuration for individual additional
        # subnetwork attached to the cluster
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Name of the subnetwork. This can be the full path of the subnetwork or
        #     just the name.
        #     Example1: my-subnet
        #     Example2: projects/gke-project/regions/us-central1/subnetworks/my-subnet
        # @!attribute [rw] pod_ipv4_range_names
        #   @return [::Array<::String>]
        #     List of secondary ranges names within this subnetwork that can be used for
        #     pod IPs.
        #     Example1: gke-pod-range1
        #     Example2: gke-pod-range1,gke-pod-range2
        class AdditionalIPRangesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DesiredAdditionalIPRangesConfig is a wrapper used for cluster update
        # operation and contains multiple AdditionalIPRangesConfigs.
        # @!attribute [rw] additional_ip_ranges_configs
        #   @return [::Array<::Google::Cloud::Container::V1::AdditionalIPRangesConfig>]
        #     List of additional IP ranges configs where each AdditionalIPRangesConfig
        #     corresponds to one subnetwork's IP ranges
        class DesiredAdditionalIPRangesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AutoIpamConfig contains all information related to Auto IPAM
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     The flag that enables Auto IPAM on this cluster
        class AutoIpamConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RangeInfo contains the range name and the range utilization by this cluster.
        # @!attribute [r] range_name
        #   @return [::String]
        #     Output only. Name of a range.
        # @!attribute [r] utilization
        #   @return [::Float]
        #     Output only. The utilization of the range.
        class RangeInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DesiredEnterpriseConfig is a wrapper used for updating enterprise_config.
        #
        # Deprecated: GKE Enterprise features are now available without an Enterprise
        # tier.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] desired_tier
        #   @return [::Google::Cloud::Container::V1::EnterpriseConfig::ClusterTier]
        #     desired_tier specifies the desired tier of the cluster.
        class DesiredEnterpriseConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This operation resource represents operations that may have happened or are
        # happening on the cluster. All fields are output only.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The server-assigned ID for the operation.
        # @!attribute [r] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the operation is taking place. This field is deprecated, use
        #     location instead.
        # @!attribute [r] operation_type
        #   @return [::Google::Cloud::Container::V1::Operation::Type]
        #     Output only. The operation type.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Container::V1::Operation::Status]
        #     Output only. The current status of the operation.
        # @!attribute [r] detail
        #   @return [::String]
        #     Output only. Detailed operation progress, if available.
        # @!attribute [r] status_message
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. If an error has occurred, a textual description of the error.
        #     Deprecated. Use the field error instead.
        # @!attribute [r] self_link
        #   @return [::String]
        #     Output only. Server-defined URI for the operation. Example:
        #     `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
        # @!attribute [r] target_link
        #   @return [::String]
        #     Output only. Server-defined URI for the target of the operation. The format
        #     of this is a URI to the resource being modified (such as a cluster, node
        #     pool, or node). For node pool repairs, there may be multiple nodes being
        #     repaired, but only one will be the target.
        #
        #     Examples:
        #
        #     -
        #     ##
        #     `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
        #
        #     ##
        #     `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
        #
        #     `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
        # @!attribute [r] location
        #   @return [::String]
        #     Output only. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
        #     or
        #     [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
        #     in which the cluster resides.
        # @!attribute [r] start_time
        #   @return [::String]
        #     Output only. The time the operation started, in
        #     [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        # @!attribute [r] end_time
        #   @return [::String]
        #     Output only. The time the operation completed, in
        #     [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        # @!attribute [r] progress
        #   @return [::Google::Cloud::Container::V1::OperationProgress]
        #     Output only. Progress information for an operation.
        # @!attribute [rw] cluster_conditions
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::Container::V1::StatusCondition>]
        #     Which conditions caused the current cluster state.
        #     Deprecated. Use field error instead.
        # @!attribute [rw] nodepool_conditions
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::Container::V1::StatusCondition>]
        #     Which conditions caused the current node pool state.
        #     Deprecated. Use field error instead.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     The error result of the operation in case of failure.
        class Operation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Current status of the operation.
          module Status
            # Not set.
            STATUS_UNSPECIFIED = 0

            # The operation has been created.
            PENDING = 1

            # The operation is currently running.
            RUNNING = 2

            # The operation is done, either cancelled or completed.
            DONE = 3

            # The operation is aborting.
            ABORTING = 4
          end

          # Operation type categorizes the operation.
          module Type
            # Not set.
            TYPE_UNSPECIFIED = 0

            # The cluster is being created. The cluster should be assumed to be
            # unusable until the operation finishes.
            #
            # In the event of the operation failing, the cluster will enter the
            # {::Google::Cloud::Container::V1::Cluster::Status::ERROR ERROR state} and eventually be
            # deleted.
            CREATE_CLUSTER = 1

            # The cluster is being deleted. The cluster should be assumed to be
            # unusable as soon as this operation starts.
            #
            # In the event of the operation failing, the cluster will enter the
            # {::Google::Cloud::Container::V1::Cluster::Status::ERROR ERROR state} and the deletion
            # will be automatically retried until completed.
            DELETE_CLUSTER = 2

            # The [cluster
            # version][google.container.v1.ClusterUpdate.desired_master_version] is
            # being updated. Note that this includes "upgrades" to the same version,
            # which are simply a recreation. This also includes
            # [auto-upgrades](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-upgrades#upgrading_automatically).
            # For more details, see [documentation on cluster
            # upgrades](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-upgrades#cluster_upgrades).
            UPGRADE_MASTER = 3

            # A node pool is being updated. Despite calling this an "upgrade", this
            # includes most forms of updates to node pools. This also includes
            # [auto-upgrades](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-upgrades).
            #
            # This operation sets the
            # {::Google::Cloud::Container::V1::Operation#progress progress} field and may be
            # {::Google::Cloud::Container::V1::ClusterManager::Client#cancel_operation canceled}.
            #
            # The upgrade strategy depends on [node pool
            # configuration](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pool-upgrade-strategies).
            # The nodes are generally still usable during this operation.
            UPGRADE_NODES = 4

            # A problem has been detected with the control plane and is being repaired.
            # This operation type is initiated by GKE. For more details, see
            # [documentation on
            # repairs](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
            REPAIR_CLUSTER = 5

            # The cluster is being updated. This is a broad category of operations and
            # includes operations that only change metadata as well as those that must
            # recreate the entire cluster. If the control plane must be recreated, this
            # will cause temporary downtime for zonal clusters.
            #
            # Some features require recreating the nodes as well. Those will be
            # recreated as separate operations and the update may not be completely
            # functional until the node pools recreations finish. Node recreations will
            # generally follow [maintenance
            # policies](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions).
            #
            # Some GKE-initiated operations use this type. This includes certain types
            # of auto-upgrades and incident mitigations.
            UPDATE_CLUSTER = 6

            # A node pool is being created. The node pool should be assumed to be
            # unusable until this operation finishes. In the event of an error, the
            # node pool may be partially created.
            #
            # If enabled, [node
            # autoprovisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
            # may have automatically initiated such operations.
            CREATE_NODE_POOL = 7

            # The node pool is being deleted. The node pool should be assumed to be
            # unusable as soon as this operation starts.
            DELETE_NODE_POOL = 8

            # The node pool's {::Google::Cloud::Container::V1::NodePool#management manamagent}
            # field is being updated. These operations only update metadata and may be
            # concurrent with most other operations.
            SET_NODE_POOL_MANAGEMENT = 9

            # A problem has been detected with nodes and [they are being
            # repaired](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-repair).
            # This operation type is initiated by GKE, typically automatically. This
            # operation may be concurrent with other operations and there may be
            # multiple repairs occurring on the same node pool.
            AUTO_REPAIR_NODES = 10

            # Unused. Automatic node upgrade uses
            # {::Google::Cloud::Container::V1::Operation::Type::UPGRADE_NODES UPGRADE_NODES}.
            AUTO_UPGRADE_NODES = 11

            # Unused. Updating labels uses
            # {::Google::Cloud::Container::V1::Operation::Type::UPDATE_CLUSTER UPDATE_CLUSTER}.
            SET_LABELS = 12

            # Unused. Updating master auth uses
            # {::Google::Cloud::Container::V1::Operation::Type::UPDATE_CLUSTER UPDATE_CLUSTER}.
            SET_MASTER_AUTH = 13

            # The node pool is being resized. With the exception of resizing to or from
            # size zero, the node pool is generally usable during this operation.
            SET_NODE_POOL_SIZE = 14

            # Unused. Updating network policy uses
            # {::Google::Cloud::Container::V1::Operation::Type::UPDATE_CLUSTER UPDATE_CLUSTER}.
            SET_NETWORK_POLICY = 15

            # Unused. Updating maintenance policy uses
            # {::Google::Cloud::Container::V1::Operation::Type::UPDATE_CLUSTER UPDATE_CLUSTER}.
            SET_MAINTENANCE_POLICY = 16

            # The control plane is being resized. This operation type is initiated by
            # GKE. These operations are often performed preemptively to ensure that the
            # control plane has sufficient resources and is not typically an indication
            # of issues. For more details, see
            # [documentation on
            # resizes](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
            RESIZE_CLUSTER = 18

            # Fleet features of GKE Enterprise are being upgraded. The cluster should
            # be assumed to be blocked for other upgrades until the operation finishes.
            FLEET_FEATURE_UPGRADE = 19
          end
        end

        # Information about operation (or operation stage) progress.
        # @!attribute [rw] name
        #   @return [::String]
        #     A non-parameterized string describing an operation stage.
        #     Unset for single-stage operations.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::Container::V1::Operation::Status]
        #     Status of an operation stage.
        #     Unset for single-stage operations.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Cloud::Container::V1::OperationProgress::Metric>]
        #     Progress metric bundle, for example:
        #       metrics: [\\{name: "nodes done",     int_value: 15},
        #                 \\{name: "nodes total",    int_value: 32}]
        #     or
        #       metrics: [\\{name: "progress",       double_value: 0.56},
        #                 \\{name: "progress scale", double_value: 1.0}]
        # @!attribute [rw] stages
        #   @return [::Array<::Google::Cloud::Container::V1::OperationProgress>]
        #     Substages of an operation or a stage.
        class OperationProgress
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Progress metric is (string, int|float|string) pair.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Metric name, e.g., "nodes total", "percent done".
          # @!attribute [rw] int_value
          #   @return [::Integer]
          #     For metrics with integer value.
          #
          #     Note: The following fields are mutually exclusive: `int_value`, `double_value`, `string_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] double_value
          #   @return [::Float]
          #     For metrics with floating point value.
          #
          #     Note: The following fields are mutually exclusive: `double_value`, `int_value`, `string_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] string_value
          #   @return [::String]
          #     For metrics with custom values (ratios, visual progress, etc.).
          #
          #     Note: The following fields are mutually exclusive: `string_value`, `int_value`, `double_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Metric
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # CreateClusterRequest creates a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the parent field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the parent field.
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::Container::V1::Cluster]
        #     Required. A [cluster
        #     resource](https://cloud.google.com/container-engine/reference/rest/v1/projects.locations.clusters)
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent (project and location) where the cluster will be created.
        #     Specified in the format `projects/*/locations/*`.
        class CreateClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetClusterRequest gets the settings of a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to retrieve.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to retrieve.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class GetClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateClusterRequest updates the settings of a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] update
        #   @return [::Google::Cloud::Container::V1::ClusterUpdate]
        #     Required. A description of the update.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to update.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class UpdateClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateNodePoolRequests update a node pool's image and/or version.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_pool_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the node pool to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_version
        #   @return [::String]
        #     Required. The Kubernetes version to change the nodes to (typically an
        #     upgrade).
        #
        #     Users may specify either explicit versions offered by Kubernetes Engine or
        #     version aliases, which have the following behavior:
        #
        #     - "latest": picks the highest valid Kubernetes version
        #     - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
        #     - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
        #     - "1.X.Y-gke.N": picks an explicit Kubernetes version
        #     - "-": picks the Kubernetes master version
        # @!attribute [rw] image_type
        #   @return [::String]
        #     Required. The desired image type for the node pool. Please see
        #     https://cloud.google.com/kubernetes-engine/docs/concepts/node-images
        #     for available image types.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster, node pool) of the node pool to
        #     update. Specified in the format
        #     `projects/*/locations/*/clusters/*/nodePools/*`.
        # @!attribute [rw] locations
        #   @return [::Array<::String>]
        #     The desired list of Google Compute Engine
        #     [zones](https://cloud.google.com/compute/docs/zones#available)
        #     in which the node pool's nodes should be located. Changing the locations
        #     for a node pool will result in nodes being either created or removed from
        #     the node pool, depending on whether locations are being added or removed.
        #
        #     Warning: It is recommended to update node pool locations in a standalone
        #     API call. Do not combine a location update with changes to other fields
        #     (such as `tags`, `labels`, `taints`, etc.) in the same request.
        #     Otherwise, the API performs a structural modification where changes to
        #     other fields will only apply to newly created nodes and will not be
        #     applied to existing nodes in the node pool. To ensure all nodes are updated
        #     consistently, use a separate API call for location changes.
        # @!attribute [rw] workload_metadata_config
        #   @return [::Google::Cloud::Container::V1::WorkloadMetadataConfig]
        #     The desired workload metadata config for the node pool.
        # @!attribute [rw] upgrade_settings
        #   @return [::Google::Cloud::Container::V1::NodePool::UpgradeSettings]
        #     Upgrade settings control disruption and speed of the upgrade.
        # @!attribute [rw] tags
        #   @return [::Google::Cloud::Container::V1::NetworkTags]
        #     The desired network tags to be applied to all nodes in the node pool.
        #     If this field is not present, the tags will not be changed. Otherwise,
        #     the existing network tags will be *replaced* with the provided tags.
        # @!attribute [rw] taints
        #   @return [::Google::Cloud::Container::V1::NodeTaints]
        #     The desired node taints to be applied to all nodes in the node pool.
        #     If this field is not present, the taints will not be changed. Otherwise,
        #     the existing node taints will be *replaced* with the provided taints.
        # @!attribute [rw] labels
        #   @return [::Google::Cloud::Container::V1::NodeLabels]
        #     The desired node labels to be applied to all nodes in the node pool.
        #     If this field is not present, the labels will not be changed. Otherwise,
        #     the existing node labels will be *replaced* with the provided labels.
        # @!attribute [rw] linux_node_config
        #   @return [::Google::Cloud::Container::V1::LinuxNodeConfig]
        #     Parameters that can be configured on Linux nodes.
        # @!attribute [rw] kubelet_config
        #   @return [::Google::Cloud::Container::V1::NodeKubeletConfig]
        #     Node kubelet configs.
        # @!attribute [rw] node_network_config
        #   @return [::Google::Cloud::Container::V1::NodeNetworkConfig]
        #     Node network config.
        # @!attribute [rw] gcfs_config
        #   @return [::Google::Cloud::Container::V1::GcfsConfig]
        #     GCFS config.
        # @!attribute [rw] confidential_nodes
        #   @return [::Google::Cloud::Container::V1::ConfidentialNodes]
        #     Confidential nodes config.
        #     All the nodes in the node pool will be Confidential VM once enabled.
        # @!attribute [rw] gvnic
        #   @return [::Google::Cloud::Container::V1::VirtualNIC]
        #     Enable or disable gvnic on the node pool.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The current etag of the node pool.
        #     If an etag is provided and does not match the current etag of the node
        #     pool, update will be blocked and an ABORTED error will be returned.
        # @!attribute [rw] fast_socket
        #   @return [::Google::Cloud::Container::V1::FastSocket]
        #     Enable or disable NCCL fast socket for the node pool.
        # @!attribute [rw] logging_config
        #   @return [::Google::Cloud::Container::V1::NodePoolLoggingConfig]
        #     Logging configuration.
        # @!attribute [rw] resource_labels
        #   @return [::Google::Cloud::Container::V1::ResourceLabels]
        #     The resource labels for the node pool to use to annotate any related
        #     Google Compute Engine resources.
        # @!attribute [rw] windows_node_config
        #   @return [::Google::Cloud::Container::V1::WindowsNodeConfig]
        #     Parameters that can be configured on Windows nodes.
        # @!attribute [rw] accelerators
        #   @return [::Array<::Google::Cloud::Container::V1::AcceleratorConfig>]
        #     A list of hardware accelerators to be attached to each node.
        #     See
        #     https://cloud.google.com/compute/docs/gpus
        #     for more information about support for GPUs.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Optional. The desired [Google Compute Engine machine
        #     type](https://cloud.google.com/compute/docs/machine-types)
        #     for nodes in the node pool. Initiates an upgrade operation that migrates
        #     the nodes in the node pool to the specified machine type.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
        #     'pd-balanced') for nodes in the node pool.
        #     Initiates an upgrade operation that migrates the nodes in the
        #     node pool to the specified disk type.
        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     Optional. The desired disk size for nodes in the node pool specified in GB.
        #     The smallest allowed disk size is 10GB.
        #     Initiates an upgrade operation that migrates the nodes in the
        #     node pool to the specified disk size.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Cloud::Container::V1::ResourceManagerTags]
        #     Desired resource manager tag keys and values to be attached to the nodes
        #     for managing Compute Engine firewalls using Network Firewall Policies.
        #     Existing tags will be replaced with new values.
        # @!attribute [rw] containerd_config
        #   @return [::Google::Cloud::Container::V1::ContainerdConfig]
        #     The desired containerd config for nodes in the node pool.
        #     Initiates an upgrade operation that recreates the nodes with the new
        #     config.
        # @!attribute [rw] queued_provisioning
        #   @return [::Google::Cloud::Container::V1::NodePool::QueuedProvisioning]
        #     Specifies the configuration of queued provisioning.
        # @!attribute [rw] storage_pools
        #   @return [::Array<::String>]
        #     List of Storage Pools where boot disks are provisioned.
        #     Existing Storage Pools will be replaced with storage-pools.
        # @!attribute [rw] max_run_duration
        #   @return [::Google::Protobuf::Duration]
        #     The maximum duration for the nodes to exist.
        #     If unspecified, the nodes can exist indefinitely.
        # @!attribute [rw] flex_start
        #   @return [::Boolean]
        #     Flex Start flag for enabling Flex Start VM.
        # @!attribute [rw] boot_disk
        #   @return [::Google::Cloud::Container::V1::BootDisk]
        #     The desired boot disk config for nodes in the node pool.
        #     Initiates an upgrade operation that migrates the nodes in the
        #     node pool to the specified boot disk config.
        class UpdateNodePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetNodePoolAutoscalingRequest sets the autoscaler settings of a node pool.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_pool_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the node pool to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] autoscaling
        #   @return [::Google::Cloud::Container::V1::NodePoolAutoscaling]
        #     Required. Autoscaling configuration for the node pool.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster, node pool) of the node pool to set
        #     autoscaler settings. Specified in the format
        #     `projects/*/locations/*/clusters/*/nodePools/*`.
        class SetNodePoolAutoscalingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetLoggingServiceRequest sets the logging service of a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] logging_service
        #   @return [::String]
        #     Required. The logging service the cluster should use to write logs.
        #     Currently available options:
        #
        #     * `logging.googleapis.com/kubernetes` - The Cloud Logging
        #     service with a Kubernetes-native resource model
        #     * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
        #       available as of GKE 1.15).
        #     * `none` - no logs will be exported from the cluster.
        #
        #     If left as an empty string,`logging.googleapis.com/kubernetes` will be
        #     used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to set logging.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class SetLoggingServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetMonitoringServiceRequest sets the monitoring service of a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] monitoring_service
        #   @return [::String]
        #     Required. The monitoring service the cluster should use to write metrics.
        #     Currently available options:
        #
        #     * `monitoring.googleapis.com/kubernetes` - The Cloud Monitoring
        #     service with a Kubernetes-native resource model
        #     * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
        #       longer available as of GKE 1.15).
        #     * `none` - No metrics will be exported from the cluster.
        #
        #     If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
        #     used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to set monitoring.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class SetMonitoringServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetAddonsConfigRequest sets the addons associated with the cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] addons_config
        #   @return [::Google::Cloud::Container::V1::AddonsConfig]
        #     Required. The desired configurations for the various addons available to
        #     run in the cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to set addons.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class SetAddonsConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetLocationsRequest sets the locations of the cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] locations
        #   @return [::Array<::String>]
        #     Required. The desired list of Google Compute Engine
        #     [zones](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster's nodes should be located. Changing the locations a
        #     cluster is in will result in nodes being either created or removed from the
        #     cluster, depending on whether locations are being added or removed.
        #
        #     This list must always include the cluster's primary zone.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to set locations.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class SetLocationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateMasterRequest updates the master of the cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] master_version
        #   @return [::String]
        #     Required. The Kubernetes version to change the master to.
        #
        #     Users may specify either explicit versions offered by Kubernetes Engine or
        #     version aliases, which have the following behavior:
        #
        #     - "latest": picks the highest valid Kubernetes version
        #     - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
        #     - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
        #     - "1.X.Y-gke.N": picks an explicit Kubernetes version
        #     - "-": picks the default Kubernetes version
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to update.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class UpdateMasterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetMasterAuthRequest updates the admin password of a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to upgrade.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] action
        #   @return [::Google::Cloud::Container::V1::SetMasterAuthRequest::Action]
        #     Required. The exact form of action to be taken on the master auth.
        # @!attribute [rw] update
        #   @return [::Google::Cloud::Container::V1::MasterAuth]
        #     Required. A description of the update.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to set auth.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class SetMasterAuthRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Operation type: what type update to perform.
          module Action
            # Operation is unknown and will error out.
            UNKNOWN = 0

            # Set the password to a user generated value.
            SET_PASSWORD = 1

            # Generate a new password and set it to that.
            GENERATE_PASSWORD = 2

            # Set the username.  If an empty username is provided, basic authentication
            # is disabled for the cluster.  If a non-empty username is provided, basic
            # authentication is enabled, with either a provided password or a generated
            # one.
            SET_USERNAME = 3
          end
        end

        # DeleteClusterRequest deletes a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to delete.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to delete.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class DeleteClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListClustersRequest lists clusters.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the parent field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides, or "-" for all zones. This field has been
        #     deprecated and replaced by the parent field.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent (project and location) where the clusters will be listed.
        #     Specified in the format `projects/*/locations/*`.
        #     Location "-" matches all zones and all regions.
        class ListClustersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListClustersResponse is the result of ListClustersRequest.
        # @!attribute [rw] clusters
        #   @return [::Array<::Google::Cloud::Container::V1::Cluster>]
        #     A list of clusters in the project in the specified zone, or
        #     across all ones.
        # @!attribute [rw] missing_zones
        #   @return [::Array<::String>]
        #     If any zones are listed here, the list of clusters returned
        #     may be missing those zones.
        class ListClustersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetOperationRequest gets a single operation.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] operation_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The server-assigned `name` of the operation.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, operation id) of the operation to get.
        #     Specified in the format `projects/*/locations/*/operations/*`.
        class GetOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListOperationsRequest lists operations.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the parent field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     to return operations for, or `-` for all zones. This field has been
        #     deprecated and replaced by the parent field.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent (project and location) where the operations will be listed.
        #     Specified in the format `projects/*/locations/*`.
        #     Location "-" matches all zones and all regions.
        class ListOperationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CancelOperationRequest cancels a single operation.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the operation resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] operation_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The server-assigned `name` of the operation.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, operation id) of the operation to cancel.
        #     Specified in the format `projects/*/locations/*/operations/*`.
        class CancelOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListOperationsResponse is the result of ListOperationsRequest.
        # @!attribute [rw] operations
        #   @return [::Array<::Google::Cloud::Container::V1::Operation>]
        #     A list of operations in the project in the specified zone.
        # @!attribute [rw] missing_zones
        #   @return [::Array<::String>]
        #     If any zones are listed here, the list of operations returned
        #     may be missing the operations from those zones.
        class ListOperationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Gets the current Kubernetes Engine service configuration.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     to return operations for. This field has been deprecated and replaced by
        #     the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project and location) of the server config to get,
        #     specified in the format `projects/*/locations/*`.
        class GetServerConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Kubernetes Engine service configuration.
        # @!attribute [rw] default_cluster_version
        #   @return [::String]
        #     Version of Kubernetes the service deploys by default.
        # @!attribute [rw] valid_node_versions
        #   @return [::Array<::String>]
        #     List of valid node upgrade target versions, in descending order.
        # @!attribute [rw] default_image_type
        #   @return [::String]
        #     Default image type.
        # @!attribute [rw] valid_image_types
        #   @return [::Array<::String>]
        #     List of valid image types.
        # @!attribute [rw] valid_master_versions
        #   @return [::Array<::String>]
        #     List of valid master versions, in descending order.
        # @!attribute [rw] channels
        #   @return [::Array<::Google::Cloud::Container::V1::ServerConfig::ReleaseChannelConfig>]
        #     List of release channel configurations.
        class ServerConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # ReleaseChannelConfig exposes configuration for a release channel.
          # @!attribute [rw] channel
          #   @return [::Google::Cloud::Container::V1::ReleaseChannel::Channel]
          #     The release channel this configuration applies to.
          # @!attribute [rw] default_version
          #   @return [::String]
          #     The default version for newly created clusters on the channel.
          # @!attribute [rw] valid_versions
          #   @return [::Array<::String>]
          #     List of valid versions for the channel.
          # @!attribute [rw] upgrade_target_version
          #   @return [::String]
          #     The auto upgrade target version for clusters on the channel.
          class ReleaseChannelConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # CreateNodePoolRequest creates a node pool for a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the parent field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the parent field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster.
        #     This field has been deprecated and replaced by the parent field.
        # @!attribute [rw] node_pool
        #   @return [::Google::Cloud::Container::V1::NodePool]
        #     Required. The node pool to create.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent (project, location, cluster name) where the node pool will be
        #     created. Specified in the format
        #     `projects/*/locations/*/clusters/*`.
        class CreateNodePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteNodePoolRequest deletes a node pool for a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_pool_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the node pool to delete.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster, node pool id) of the node pool to
        #     delete. Specified in the format
        #     `projects/*/locations/*/clusters/*/nodePools/*`.
        class DeleteNodePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListNodePoolsRequest lists the node pool(s) for a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the parent field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the parent field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster.
        #     This field has been deprecated and replaced by the parent field.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent (project, location, cluster name) where the node pools will be
        #     listed. Specified in the format `projects/*/locations/*/clusters/*`.
        class ListNodePoolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetNodePoolRequest retrieves a node pool for a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_pool_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the node pool.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster, node pool id) of the node pool to
        #     get. Specified in the format
        #     `projects/*/locations/*/clusters/*/nodePools/*`.
        class GetNodePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for blue-green upgrade.
        # @!attribute [rw] standard_rollout_policy
        #   @return [::Google::Cloud::Container::V1::BlueGreenSettings::StandardRolloutPolicy]
        #     Standard policy for the blue-green upgrade.
        #
        #     Note: The following fields are mutually exclusive: `standard_rollout_policy`, `autoscaled_rollout_policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] autoscaled_rollout_policy
        #   @return [::Google::Cloud::Container::V1::BlueGreenSettings::AutoscaledRolloutPolicy]
        #     Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
        #
        #     Note: The following fields are mutually exclusive: `autoscaled_rollout_policy`, `standard_rollout_policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] node_pool_soak_duration
        #   @return [::Google::Protobuf::Duration]
        #     Time needed after draining entire blue pool. After this period, blue pool
        #     will be cleaned up.
        class BlueGreenSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Standard rollout policy is the default policy for blue-green.
          # @!attribute [rw] batch_percentage
          #   @return [::Float]
          #     Percentage of the blue pool nodes to drain in a batch.
          #     The range of this field should be (0.0, 1.0].
          #
          #     Note: The following fields are mutually exclusive: `batch_percentage`, `batch_node_count`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] batch_node_count
          #   @return [::Integer]
          #     Number of blue nodes to drain in a batch.
          #
          #     Note: The following fields are mutually exclusive: `batch_node_count`, `batch_percentage`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] batch_soak_duration
          #   @return [::Google::Protobuf::Duration]
          #     Soak time after each batch gets drained. Default to zero.
          class StandardRolloutPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Autoscaled rollout policy utilizes the cluster autoscaler during
          # blue-green upgrade to scale both the blue and green pools.
          # @!attribute [rw] wait_for_drain_duration
          #   @return [::Google::Protobuf::Duration]
          #     Optional. Time to wait after cordoning the blue pool before draining the
          #     nodes. Defaults to 3 days. The value can be set between 0 and 7 days,
          #     inclusive.
          class AutoscaledRolloutPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # NodePool contains the name and configuration for a cluster's node pool.
        # Node pools are a set of nodes (i.e. VM's), with a common configuration and
        # specification, under the control of the cluster master. They may have a set
        # of Kubernetes labels applied to them, which may be used to reference them
        # during pod scheduling. They may also be resized up or down, to accommodate
        # the workload.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the node pool.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Container::V1::NodeConfig]
        #     The node configuration of the pool.
        # @!attribute [rw] initial_node_count
        #   @return [::Integer]
        #     The initial node count for the pool. You must ensure that your
        #     Compute Engine [resource
        #     quota](https://cloud.google.com/compute/quotas)
        #     is sufficient for this number of instances. You must also have available
        #     firewall and routes quota.
        # @!attribute [rw] locations
        #   @return [::Array<::String>]
        #     The list of Google Compute Engine
        #     [zones](https://cloud.google.com/compute/docs/zones#available)
        #     in which the NodePool's nodes should be located.
        #
        #     If this value is unspecified during node pool creation, the
        #     [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
        #     value will be used, instead.
        #
        #     Warning: changing node pool locations will result in nodes being added
        #     and/or removed.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::Container::V1::NodeNetworkConfig]
        #     Networking configuration for this NodePool. If specified, it overrides the
        #     cluster-level defaults.
        # @!attribute [r] self_link
        #   @return [::String]
        #     Output only. Server-defined URL for the resource.
        # @!attribute [rw] version
        #   @return [::String]
        #     The version of Kubernetes running on this NodePool's nodes. If unspecified,
        #     it defaults as described
        #     [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
        # @!attribute [r] instance_group_urls
        #   @return [::Array<::String>]
        #     Output only. The resource URLs of the [managed instance
        #     groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
        #     associated with this node pool.
        #     During the node pool blue-green upgrade operation, the URLs contain both
        #     blue and green resources.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Container::V1::NodePool::Status]
        #     Output only. The status of the nodes in this pool instance.
        # @!attribute [r] status_message
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Output only. Deprecated. Use conditions instead.
        #     Additional information about the current status of this
        #     node pool instance, if available.
        # @!attribute [rw] autoscaling
        #   @return [::Google::Cloud::Container::V1::NodePoolAutoscaling]
        #     Autoscaler configuration for this NodePool. Autoscaler is enabled
        #     only if a valid configuration is present.
        # @!attribute [rw] management
        #   @return [::Google::Cloud::Container::V1::NodeManagement]
        #     NodeManagement configuration for this NodePool.
        # @!attribute [rw] max_pods_constraint
        #   @return [::Google::Cloud::Container::V1::MaxPodsConstraint]
        #     The constraint on the maximum number of pods that can be run
        #     simultaneously on a node in the node pool.
        # @!attribute [rw] conditions
        #   @return [::Array<::Google::Cloud::Container::V1::StatusCondition>]
        #     Which conditions caused the current node pool state.
        # @!attribute [r] pod_ipv4_cidr_size
        #   @return [::Integer]
        #     Output only. The pod CIDR block size per node in this node pool.
        # @!attribute [rw] upgrade_settings
        #   @return [::Google::Cloud::Container::V1::NodePool::UpgradeSettings]
        #     Upgrade settings control disruption and speed of the upgrade.
        # @!attribute [rw] placement_policy
        #   @return [::Google::Cloud::Container::V1::NodePool::PlacementPolicy]
        #     Specifies the node placement policy.
        # @!attribute [r] update_info
        #   @return [::Google::Cloud::Container::V1::NodePool::UpdateInfo]
        #     Output only. Update info contains relevant information during a node
        #     pool update.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of node pool
        #     fields, and may be sent on update requests to ensure the client has an
        #     up-to-date value before proceeding.
        # @!attribute [rw] queued_provisioning
        #   @return [::Google::Cloud::Container::V1::NodePool::QueuedProvisioning]
        #     Specifies the configuration of queued provisioning.
        # @!attribute [rw] best_effort_provisioning
        #   @return [::Google::Cloud::Container::V1::BestEffortProvisioning]
        #     Enable best effort provisioning for nodes
        class NodePool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # These upgrade settings control the level of parallelism and the level of
          # disruption caused by an upgrade.
          #
          # maxUnavailable controls the number of nodes that can be simultaneously
          # unavailable.
          #
          # maxSurge controls the number of additional nodes that can be added to the
          # node pool temporarily for the time of the upgrade to increase the number of
          # available nodes.
          #
          # (maxUnavailable + maxSurge) determines the level of parallelism (how many
          # nodes are being upgraded at the same time).
          #
          # Note: upgrades inevitably introduce some disruption since workloads need to
          # be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0,
          # this holds true. (Disruption stays within the limits of
          # PodDisruptionBudget, if it is configured.)
          #
          # Consider a hypothetical node pool with 5 nodes having maxSurge=2,
          # maxUnavailable=1. This means the upgrade process upgrades 3 nodes
          # simultaneously. It creates 2 additional (upgraded) nodes, then it brings
          # down 3 old (not yet upgraded) nodes at the same time. This ensures that
          # there are always at least 4 nodes available.
          #
          # These upgrade settings configure the upgrade strategy for the node pool.
          # Use strategy to switch between the strategies applied to the node pool.
          #
          # If the strategy is ROLLING, use max_surge and max_unavailable to control
          # the level of parallelism and the level of disruption caused by upgrade.
          # 1. maxSurge controls the number of additional nodes that can be added to
          # the node pool temporarily for the time of the upgrade to increase the
          # number of available nodes.
          # 2. maxUnavailable controls the number of nodes that can be simultaneously
          # unavailable.
          # 3. (maxUnavailable + maxSurge) determines the level of parallelism (how
          # many nodes are being upgraded at the same time).
          #
          # If the strategy is BLUE_GREEN, use blue_green_settings to configure the
          # blue-green upgrade related settings.
          # 1. standard_rollout_policy is the default policy. The policy is used to
          # control the way blue pool gets drained. The draining is executed in the
          # batch mode. The batch size could be specified as either percentage of the
          # node pool size or the number of nodes. batch_soak_duration is the soak
          # time after each batch gets drained.
          # 2. node_pool_soak_duration is the soak time after all blue nodes are
          # drained. After this period, the blue pool nodes will be deleted.
          # @!attribute [rw] max_surge
          #   @return [::Integer]
          #     The maximum number of nodes that can be created beyond the current size
          #     of the node pool during the upgrade process.
          # @!attribute [rw] max_unavailable
          #   @return [::Integer]
          #     The maximum number of nodes that can be simultaneously unavailable during
          #     the upgrade process. A node is considered available if its status is
          #     Ready.
          # @!attribute [rw] strategy
          #   @return [::Google::Cloud::Container::V1::NodePoolUpdateStrategy]
          #     Update strategy of the node pool.
          # @!attribute [rw] blue_green_settings
          #   @return [::Google::Cloud::Container::V1::BlueGreenSettings]
          #     Settings for blue-green upgrade strategy.
          class UpgradeSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # UpdateInfo contains resource (instance groups, etc), status and other
          # intermediate information relevant to a node pool upgrade.
          # @!attribute [rw] blue_green_info
          #   @return [::Google::Cloud::Container::V1::NodePool::UpdateInfo::BlueGreenInfo]
          #     Information of a blue-green upgrade.
          class UpdateInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Information relevant to blue-green upgrade.
            # @!attribute [rw] phase
            #   @return [::Google::Cloud::Container::V1::NodePool::UpdateInfo::BlueGreenInfo::Phase]
            #     Current blue-green upgrade phase.
            # @!attribute [rw] blue_instance_group_urls
            #   @return [::Array<::String>]
            #     The resource URLs of the [managed instance groups]
            #     (/compute/docs/instance-groups/creating-groups-of-managed-instances)
            #     associated with blue pool.
            # @!attribute [rw] green_instance_group_urls
            #   @return [::Array<::String>]
            #     The resource URLs of the [managed instance groups]
            #     (/compute/docs/instance-groups/creating-groups-of-managed-instances)
            #     associated with green pool.
            # @!attribute [rw] blue_pool_deletion_start_time
            #   @return [::String]
            #     Time to start deleting blue pool to complete blue-green upgrade,
            #     in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
            # @!attribute [rw] green_pool_version
            #   @return [::String]
            #     Version of green pool.
            class BlueGreenInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Phase represents the different stages blue-green upgrade is running in.
              module Phase
                # Unspecified phase.
                PHASE_UNSPECIFIED = 0

                # blue-green upgrade has been initiated.
                UPDATE_STARTED = 1

                # Start creating green pool nodes.
                CREATING_GREEN_POOL = 2

                # Start cordoning blue pool nodes.
                CORDONING_BLUE_POOL = 3

                # Start draining blue pool nodes.
                DRAINING_BLUE_POOL = 4

                # Start soaking time after draining entire blue pool.
                NODE_POOL_SOAKING = 5

                # Start deleting blue nodes.
                DELETING_BLUE_POOL = 6

                # Rollback has been initiated.
                ROLLBACK_STARTED = 7
              end
            end
          end

          # PlacementPolicy defines the placement policy used by the node pool.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Container::V1::NodePool::PlacementPolicy::Type]
          #     The type of placement.
          # @!attribute [rw] tpu_topology
          #   @return [::String]
          #     Optional. TPU placement topology for pod slice node pool.
          #     https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
          # @!attribute [rw] policy_name
          #   @return [::String]
          #     If set, refers to the name of a custom resource policy supplied by the
          #     user. The resource policy must be in the same project and region as the
          #     node pool. If not found, InvalidArgument error is returned.
          class PlacementPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Type defines the type of placement policy.
            module Type
              # TYPE_UNSPECIFIED specifies no requirements on nodes
              # placement.
              TYPE_UNSPECIFIED = 0

              # COMPACT specifies node placement in the same availability domain to
              # ensure low communication latency.
              COMPACT = 1
            end
          end

          # QueuedProvisioning defines the queued provisioning used by the node pool.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Denotes that this nodepool is QRM specific, meaning nodes can be only
          #     obtained through queuing via the Cluster Autoscaler ProvisioningRequest
          #     API.
          class QueuedProvisioning
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The current status of the node pool instance.
          module Status
            # Not set.
            STATUS_UNSPECIFIED = 0

            # The PROVISIONING state indicates the node pool is being created.
            PROVISIONING = 1

            # The RUNNING state indicates the node pool has been created
            # and is fully usable.
            RUNNING = 2

            # The RUNNING_WITH_ERROR state indicates the node pool has been created
            # and is partially usable. Some error state has occurred and some
            # functionality may be impaired. Customer may need to reissue a request
            # or trigger a new update.
            RUNNING_WITH_ERROR = 3

            # The RECONCILING state indicates that some work is actively being done on
            # the node pool, such as upgrading node software. Details can
            # be found in the `statusMessage` field.
            RECONCILING = 4

            # The STOPPING state indicates the node pool is being deleted.
            STOPPING = 5

            # The ERROR state indicates the node pool may be unusable. Details
            # can be found in the `statusMessage` field.
            ERROR = 6
          end
        end

        # NodeManagement defines the set of node management services turned on for the
        # node pool.
        # @!attribute [rw] auto_upgrade
        #   @return [::Boolean]
        #     A flag that specifies whether node auto-upgrade is enabled for the node
        #     pool. If enabled, node auto-upgrade helps keep the nodes in your node pool
        #     up to date with the latest release version of Kubernetes.
        # @!attribute [rw] auto_repair
        #   @return [::Boolean]
        #     A flag that specifies whether the node auto-repair is enabled for the node
        #     pool. If enabled, the nodes in this node pool will be monitored and, if
        #     they fail health checks too many times, an automatic repair action will be
        #     triggered.
        # @!attribute [rw] upgrade_options
        #   @return [::Google::Cloud::Container::V1::AutoUpgradeOptions]
        #     Specifies the Auto Upgrade knobs for the node pool.
        class NodeManagement
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Best effort provisioning.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     When this is enabled, cluster/node pool creations will ignore non-fatal
        #     errors like stockout to best provision as many nodes as possible right now
        #     and eventually bring up all target number of nodes
        # @!attribute [rw] min_provision_nodes
        #   @return [::Integer]
        #     Minimum number of nodes to be provisioned to be considered as succeeded,
        #     and the rest of nodes will be provisioned gradually and eventually when
        #     stockout issue has been resolved.
        class BestEffortProvisioning
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AutoUpgradeOptions defines the set of options for the user to control how
        # the Auto Upgrades will proceed.
        # @!attribute [r] auto_upgrade_start_time
        #   @return [::String]
        #     Output only. This field is set when upgrades are about to commence
        #     with the approximate start time for the upgrades, in
        #     [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. This field is set when upgrades are about to commence
        #     with the description of the upgrade.
        class AutoUpgradeOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MaintenancePolicy defines the maintenance policy to be used for the cluster.
        # @!attribute [rw] window
        #   @return [::Google::Cloud::Container::V1::MaintenanceWindow]
        #     Specifies the maintenance window in which maintenance may be performed.
        # @!attribute [rw] resource_version
        #   @return [::String]
        #     A hash identifying the version of this policy, so that updates to fields of
        #     the policy won't accidentally undo intermediate changes (and so that users
        #     of the API unaware of some fields won't accidentally remove other fields).
        #     Make a `get()` request to the cluster to get the current
        #     resource version and include it with requests to set the policy.
        class MaintenancePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MaintenanceWindow defines the maintenance window to be used for the cluster.
        # @!attribute [rw] daily_maintenance_window
        #   @return [::Google::Cloud::Container::V1::DailyMaintenanceWindow]
        #     DailyMaintenanceWindow specifies a daily maintenance operation window.
        #
        #     Note: The following fields are mutually exclusive: `daily_maintenance_window`, `recurring_window`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] recurring_window
        #   @return [::Google::Cloud::Container::V1::RecurringTimeWindow]
        #     RecurringWindow specifies some number of recurring time periods for
        #     maintenance to occur. The time windows may be overlapping. If no
        #     maintenance windows are set, maintenance can occur at any time.
        #
        #     Note: The following fields are mutually exclusive: `recurring_window`, `daily_maintenance_window`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] maintenance_exclusions
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Container::V1::TimeWindow}]
        #     Exceptions to maintenance window. Non-emergency maintenance should not
        #     occur in these windows.
        class MaintenanceWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Container::V1::TimeWindow]
          class MaintenanceExclusionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents an arbitrary window of time.
        # @!attribute [rw] maintenance_exclusion_options
        #   @return [::Google::Cloud::Container::V1::MaintenanceExclusionOptions]
        #     MaintenanceExclusionOptions provides maintenance exclusion related
        #     options.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time that the window first starts.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time that the window ends. The end time should take place after the
        #     start time.
        class TimeWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the Maintenance exclusion option.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::Container::V1::MaintenanceExclusionOptions::Scope]
        #     Scope specifies the upgrade scope which upgrades are blocked by the
        #     exclusion.
        # @!attribute [rw] end_time_behavior
        #   @return [::Google::Cloud::Container::V1::MaintenanceExclusionOptions::EndTimeBehavior]
        #     EndTimeBehavior specifies the behavior of the exclusion end time.
        class MaintenanceExclusionOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Scope of exclusion.
          module Scope
            # NO_UPGRADES excludes all upgrades, including patch upgrades and minor
            # upgrades across control planes and nodes. This is the default exclusion
            # behavior.
            NO_UPGRADES = 0

            # NO_MINOR_UPGRADES excludes all minor upgrades for the cluster, only
            # patches are allowed.
            NO_MINOR_UPGRADES = 1

            # NO_MINOR_OR_NODE_UPGRADES excludes all minor upgrades for the cluster,
            # and also exclude all node pool upgrades. Only control
            # plane patches are allowed.
            NO_MINOR_OR_NODE_UPGRADES = 2
          end

          # EndTimeBehavior specifies the behavior of the exclusion end time.
          module EndTimeBehavior
            # END_TIME_BEHAVIOR_UNSPECIFIED is the default behavior, which is fixed
            # end time.
            END_TIME_BEHAVIOR_UNSPECIFIED = 0

            # UNTIL_END_OF_SUPPORT means the exclusion will be in effect until the end
            # of the support of the cluster's current version.
            UNTIL_END_OF_SUPPORT = 1
          end
        end

        # Represents an arbitrary window of time that recurs.
        # @!attribute [rw] window
        #   @return [::Google::Cloud::Container::V1::TimeWindow]
        #     The window of the first recurrence.
        # @!attribute [rw] recurrence
        #   @return [::String]
        #     An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
        #     this window reccurs. They go on for the span of time between the start and
        #     end time.
        #
        #     For example, to have something repeat every weekday, you'd use:
        #     `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR`
        #
        #     To repeat some window daily (equivalent to the DailyMaintenanceWindow):
        #     `FREQ=DAILY`
        #
        #     For the first weekend of every month:
        #     `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU`
        #
        #     This specifies how frequently the window starts. Eg, if you wanted to have
        #     a 9-5 UTC-4 window every weekday, you'd use something like:
        #     ```
        #     start time = 2019-01-01T09:00:00-0400
        #     end time = 2019-01-01T17:00:00-0400
        #     recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR
        #     ```
        #
        #     Windows can span multiple days. Eg, to make the window encompass every
        #     weekend from midnight Saturday till the last minute of Sunday UTC:
        #     ```
        #     start time = 2019-01-05T00:00:00Z
        #     end time = 2019-01-07T23:59:00Z
        #     recurrence = FREQ=WEEKLY;BYDAY=SA
        #     ```
        #
        #     Note the start and end time's specific dates are largely arbitrary except
        #     to specify duration of the window and when it first starts.
        #     The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
        class RecurringTimeWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Time window specified for daily maintenance operations.
        # @!attribute [rw] start_time
        #   @return [::String]
        #     Time within the maintenance window to start the maintenance operations.
        #     Time format should be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
        #     format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
        # @!attribute [r] duration
        #   @return [::String]
        #     Output only. Duration of the time window, automatically chosen to be
        #     smallest possible in the given scenario.
        #     Duration will be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
        #     format "PTnHnMnS".
        class DailyMaintenanceWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetNodePoolManagementRequest sets the node management properties of a node
        # pool.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to update.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_pool_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the node pool to update.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] management
        #   @return [::Google::Cloud::Container::V1::NodeManagement]
        #     Required. NodeManagement configuration for the node pool.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster, node pool id) of the node pool to set
        #     management properties. Specified in the format
        #     `projects/*/locations/*/clusters/*/nodePools/*`.
        class SetNodePoolManagementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetNodePoolSizeRequest sets the size of a node pool.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to update.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_pool_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the node pool to update.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_count
        #   @return [::Integer]
        #     Required. The desired node count for the pool.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster, node pool id) of the node pool to set
        #     size.
        #     Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
        class SetNodePoolSizeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CompleteNodePoolUpgradeRequest sets the name of target node pool to complete
        # upgrade.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster, node pool id) of the node pool to
        #     complete upgrade.
        #     Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
        class CompleteNodePoolUpgradeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or Failed
        #  NodePool upgrade. This will be an no-op if the last upgrade successfully
        #  completed.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to rollback.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] node_pool_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the node pool to rollback.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster, node pool id) of the node poll to
        #     rollback upgrade.
        #     Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
        # @!attribute [rw] respect_pdb
        #   @return [::Boolean]
        #     Option for rollback to ignore the PodDisruptionBudget.
        #     Default value is false.
        class RollbackNodePoolUpgradeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListNodePoolsResponse is the result of ListNodePoolsRequest.
        # @!attribute [rw] node_pools
        #   @return [::Array<::Google::Cloud::Container::V1::NodePool>]
        #     A list of node pools for a cluster.
        class ListNodePoolsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ClusterAutoscaling contains global, per-cluster information
        # required by Cluster Autoscaler to automatically adjust
        # the size of the cluster and create/delete
        # node pools based on the current needs.
        # @!attribute [rw] enable_node_autoprovisioning
        #   @return [::Boolean]
        #     Enables automatic node pool creation and deletion.
        # @!attribute [rw] resource_limits
        #   @return [::Array<::Google::Cloud::Container::V1::ResourceLimit>]
        #     Contains global constraints regarding minimum and maximum
        #     amount of resources in the cluster.
        # @!attribute [rw] autoscaling_profile
        #   @return [::Google::Cloud::Container::V1::ClusterAutoscaling::AutoscalingProfile]
        #     Defines autoscaling behaviour.
        # @!attribute [rw] autoprovisioning_node_pool_defaults
        #   @return [::Google::Cloud::Container::V1::AutoprovisioningNodePoolDefaults]
        #     AutoprovisioningNodePoolDefaults contains defaults for a node pool
        #     created by NAP.
        # @!attribute [rw] autoprovisioning_locations
        #   @return [::Array<::String>]
        #     The list of Google Compute Engine
        #     [zones](https://cloud.google.com/compute/docs/zones#available)
        #     in which the NodePool's nodes can be created by NAP.
        # @!attribute [rw] default_compute_class_config
        #   @return [::Google::Cloud::Container::V1::DefaultComputeClassConfig]
        #     Default compute class is a configuration for default compute class.
        class ClusterAutoscaling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines possible options for autoscaling_profile field.
          module AutoscalingProfile
            # No change to autoscaling configuration.
            PROFILE_UNSPECIFIED = 0

            # Prioritize optimizing utilization of resources.
            OPTIMIZE_UTILIZATION = 1

            # Use default (balanced) autoscaling configuration.
            BALANCED = 2
          end
        end

        # AutoprovisioningNodePoolDefaults contains defaults for a node pool created
        # by NAP.
        # @!attribute [rw] oauth_scopes
        #   @return [::Array<::String>]
        #     Scopes that are used by NAP when creating node pools.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The Google Cloud Platform Service Account to be used by the node VMs.
        # @!attribute [rw] upgrade_settings
        #   @return [::Google::Cloud::Container::V1::NodePool::UpgradeSettings]
        #     Specifies the upgrade settings for NAP created node pools
        # @!attribute [rw] management
        #   @return [::Google::Cloud::Container::V1::NodeManagement]
        #     Specifies the node management options for NAP created node-pools.
        # @!attribute [rw] min_cpu_platform
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. Minimum CPU platform to be used for NAP created node pools.
        #     The instance may be scheduled on the specified or newer CPU platform.
        #     Applicable values are the friendly names of CPU platforms, such as
        #     minCpuPlatform: Intel Haswell or
        #     minCpuPlatform: Intel Sandy Bridge. For more
        #     information, read [how to specify min CPU
        #     platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        #     This field is deprecated, min_cpu_platform should be specified using
        #     `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
        #     To unset the min cpu platform field pass "automatic"
        #     as field value.
        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     Size of the disk attached to each node, specified in GB.
        #     The smallest allowed disk size is 10GB.
        #
        #     If unspecified, the default disk size is 100GB.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
        #     'pd-balanced')
        #
        #     If unspecified, the default disk type is 'pd-standard'
        # @!attribute [rw] shielded_instance_config
        #   @return [::Google::Cloud::Container::V1::ShieldedInstanceConfig]
        #     Shielded Instance options.
        # @!attribute [rw] boot_disk_kms_key
        #   @return [::String]
        #     The Customer Managed Encryption Key used to encrypt the boot disk attached
        #     to each node in the node pool. This should be of the form
        #     projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
        #     For more information about protecting resources with Cloud KMS Keys please
        #     see:
        #     https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        # @!attribute [rw] image_type
        #   @return [::String]
        #     The image type to use for NAP created node. Please see
        #     https://cloud.google.com/kubernetes-engine/docs/concepts/node-images
        #     for available image types.
        # @!attribute [rw] insecure_kubelet_readonly_port_enabled
        #   @return [::Boolean]
        #     DEPRECATED. Use NodePoolAutoConfig.NodeKubeletConfig instead.
        class AutoprovisioningNodePoolDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains information about amount of some resource in the cluster.
        # For memory, value should be in GB.
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     Resource name "cpu", "memory" or gpu-specific string.
        # @!attribute [rw] minimum
        #   @return [::Integer]
        #     Minimum amount of the resource in the cluster.
        # @!attribute [rw] maximum
        #   @return [::Integer]
        #     Maximum amount of the resource in the cluster.
        class ResourceLimit
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DefaultComputeClassConfig defines default compute class
        #  configuration.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enables default compute class.
        class DefaultComputeClassConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # NodePoolAutoscaling contains information required by cluster autoscaler to
        # adjust the size of the node pool to the current cluster usage.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Is autoscaling enabled for this node pool.
        # @!attribute [rw] min_node_count
        #   @return [::Integer]
        #     Minimum number of nodes for one location in the node pool. Must be greater
        #     than or equal to 0 and less than or equal to max_node_count.
        # @!attribute [rw] max_node_count
        #   @return [::Integer]
        #     Maximum number of nodes for one location in the node pool. Must be >=
        #     min_node_count. There has to be enough quota to scale up the cluster.
        # @!attribute [rw] autoprovisioned
        #   @return [::Boolean]
        #     Can this node pool be deleted automatically.
        # @!attribute [rw] location_policy
        #   @return [::Google::Cloud::Container::V1::NodePoolAutoscaling::LocationPolicy]
        #     Location policy used when scaling up a nodepool.
        # @!attribute [rw] total_min_node_count
        #   @return [::Integer]
        #     Minimum number of nodes in the node pool. Must be greater than or equal
        #     to 0 and less than or equal to total_max_node_count.
        #     The total_*_node_count fields are mutually exclusive with the *_node_count
        #     fields.
        # @!attribute [rw] total_max_node_count
        #   @return [::Integer]
        #     Maximum number of nodes in the node pool. Must be greater than or equal to
        #     total_min_node_count. There has to be enough quota to scale up the cluster.
        #     The total_*_node_count fields are mutually exclusive with the *_node_count
        #     fields.
        class NodePoolAutoscaling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Location policy specifies how zones are picked when scaling up the
          # nodepool.
          module LocationPolicy
            # Not set.
            LOCATION_POLICY_UNSPECIFIED = 0

            # BALANCED is a best effort policy that aims to balance the sizes of
            # different zones.
            BALANCED = 1

            # ANY policy picks zones that have the highest capacity available.
            ANY = 2
          end
        end

        # SetLabelsRequest sets the Google Cloud Platform labels on a Google Container
        # Engine cluster, which will in turn set them for Google Compute Engine
        # resources used by that cluster
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] resource_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Required. The labels to set for that cluster.
        # @!attribute [rw] label_fingerprint
        #   @return [::String]
        #     Required. The fingerprint of the previous set of labels for this resource,
        #     used to detect conflicts. The fingerprint is initially generated by
        #     Kubernetes Engine and changes after every request to modify or update
        #     labels. You must always provide an up-to-date fingerprint hash when
        #     updating or changing labels. Make a `get()` request to the
        #     resource to get the latest fingerprint.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster name) of the cluster to set labels.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class SetLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # SetLegacyAbacRequest enables or disables the ABAC authorization mechanism for
        # a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster to update.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Required. Whether ABAC authorization will be enabled in the cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster name) of the cluster to set legacy
        #     abac. Specified in the format `projects/*/locations/*/clusters/*`.
        class SetLegacyAbacRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # StartIPRotationRequest creates a new IP for the cluster and then performs
        # a node upgrade on each node pool to point to the new IP.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster name) of the cluster to start IP
        #     rotation. Specified in the format `projects/*/locations/*/clusters/*`.
        # @!attribute [rw] rotate_credentials
        #   @return [::Boolean]
        #     Whether to rotate credentials during IP rotation.
        class StartIPRotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CompleteIPRotationRequest moves the cluster master back into single-IP mode.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster name) of the cluster to complete IP
        #     rotation. Specified in the format `projects/*/locations/*/clusters/*`.
        class CompleteIPRotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AcceleratorConfig represents a Hardware Accelerator request.
        # @!attribute [rw] accelerator_count
        #   @return [::Integer]
        #     The number of the accelerator cards exposed to an instance.
        # @!attribute [rw] accelerator_type
        #   @return [::String]
        #     The accelerator type resource name. List of supported accelerators
        #     [here](https://cloud.google.com/compute/docs/gpus)
        # @!attribute [rw] gpu_partition_size
        #   @return [::String]
        #     Size of partitions to create on the GPU. Valid values are described in the
        #     NVIDIA [mig user
        #     guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
        # @!attribute [rw] gpu_sharing_config
        #   @return [::Google::Cloud::Container::V1::GPUSharingConfig]
        #     The configuration for GPU sharing options.
        # @!attribute [rw] gpu_driver_installation_config
        #   @return [::Google::Cloud::Container::V1::GPUDriverInstallationConfig]
        #     The configuration for auto installation of GPU driver.
        class AcceleratorConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GPUSharingConfig represents the GPU sharing configuration for Hardware
        # Accelerators.
        # @!attribute [rw] max_shared_clients_per_gpu
        #   @return [::Integer]
        #     The max number of containers that can share a physical GPU.
        # @!attribute [rw] gpu_sharing_strategy
        #   @return [::Google::Cloud::Container::V1::GPUSharingConfig::GPUSharingStrategy]
        #     The type of GPU sharing strategy to enable on the GPU node.
        class GPUSharingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of GPU sharing strategy currently provided.
          module GPUSharingStrategy
            # Default value.
            GPU_SHARING_STRATEGY_UNSPECIFIED = 0

            # GPUs are time-shared between containers.
            TIME_SHARING = 1

            # GPUs are shared between containers with NVIDIA MPS.
            MPS = 2
          end
        end

        # GPUDriverInstallationConfig specifies the version of GPU driver to be auto
        # installed.
        # @!attribute [rw] gpu_driver_version
        #   @return [::Google::Cloud::Container::V1::GPUDriverInstallationConfig::GPUDriverVersion]
        #     Mode for how the GPU driver is installed.
        class GPUDriverInstallationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The GPU driver version to install.
          module GPUDriverVersion
            # Default value is to not install any GPU driver.
            GPU_DRIVER_VERSION_UNSPECIFIED = 0

            # Disable GPU driver auto installation and needs manual installation
            INSTALLATION_DISABLED = 1

            # "Default" GPU driver in COS and Ubuntu.
            DEFAULT = 2

            # "Latest" GPU driver in COS.
            LATEST = 3
          end
        end

        # WorkloadMetadataConfig defines the metadata configuration to expose to
        # workloads on the node pool.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::Container::V1::WorkloadMetadataConfig::Mode]
        #     Mode is the configuration for how to expose metadata to workloads running
        #     on the node pool.
        class WorkloadMetadataConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Mode is the configuration for how to expose metadata to workloads running
          # on the node.
          module Mode
            # Not set.
            MODE_UNSPECIFIED = 0

            # Expose all Compute Engine metadata to pods.
            GCE_METADATA = 1

            # Run the GKE Metadata Server on this node. The GKE Metadata Server exposes
            # a metadata API to workloads that is compatible with the V1 Compute
            # Metadata APIs exposed by the Compute Engine and App Engine Metadata
            # Servers. This feature can only be enabled if Workload Identity is enabled
            # at the cluster level.
            GKE_METADATA = 2
          end
        end

        # SetNetworkPolicyRequest enables/disables network policy for a cluster.
        # @!attribute [rw] project_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] zone
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides. This field has been deprecated and replaced
        #     by the name field.
        # @!attribute [rw] cluster_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated. The name of the cluster.
        #     This field has been deprecated and replaced by the name field.
        # @!attribute [rw] network_policy
        #   @return [::Google::Cloud::Container::V1::NetworkPolicy]
        #     Required. Configuration options for the NetworkPolicy feature.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster name) of the cluster to set networking
        #     policy. Specified in the format `projects/*/locations/*/clusters/*`.
        class SetNetworkPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SetMaintenancePolicyRequest sets the maintenance policy for a cluster.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The Google Developers Console [project ID or project
        #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
        # @!attribute [rw] zone
        #   @return [::String]
        #     Required. The name of the Google Compute Engine
        #     [zone](https://cloud.google.com/compute/docs/zones#available)
        #     in which the cluster resides.
        # @!attribute [rw] cluster_id
        #   @return [::String]
        #     Required. The name of the cluster to update.
        # @!attribute [rw] maintenance_policy
        #   @return [::Google::Cloud::Container::V1::MaintenancePolicy]
        #     Required. The maintenance policy to be set for the cluster. An empty field
        #     clears the existing maintenance policy.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster name) of the cluster to set
        #     maintenance policy.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class SetMaintenancePolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # StatusCondition describes why a cluster or a node pool has a certain status
        # (e.g., ERROR or DEGRADED).
        # @!attribute [rw] code
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Container::V1::StatusCondition::Code]
        #     Machine-friendly representation of the condition
        #     Deprecated. Use canonical_code instead.
        # @!attribute [rw] message
        #   @return [::String]
        #     Human-friendly representation of the condition
        # @!attribute [rw] canonical_code
        #   @return [::Google::Rpc::Code]
        #     Canonical code of the condition.
        class StatusCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Code for each condition
          module Code
            # UNKNOWN indicates a generic condition.
            UNKNOWN = 0

            # GCE_STOCKOUT indicates that Google Compute Engine resources are
            # temporarily unavailable.
            GCE_STOCKOUT = 1

            # GKE_SERVICE_ACCOUNT_DELETED indicates that the user deleted their robot
            # service account.
            GKE_SERVICE_ACCOUNT_DELETED = 2

            # Google Compute Engine quota was exceeded.
            GCE_QUOTA_EXCEEDED = 3

            # Cluster state was manually changed by an SRE due to a system logic error.
            SET_BY_OPERATOR = 4

            # Unable to perform an encrypt operation against the CloudKMS key used for
            # etcd level encryption.
            CLOUD_KMS_KEY_ERROR = 7

            # Cluster CA is expiring soon.
            CA_EXPIRING = 9

            # Node service account is missing permissions.
            NODE_SERVICE_ACCOUNT_MISSING_PERMISSIONS = 10

            # Cloud KMS key version used for etcd level encryption has been destroyed.
            # This is a permanent error.
            CLOUD_KMS_KEY_DESTROYED = 11
          end
        end

        # NetworkConfig reports the relative names of network & subnetwork.
        # @!attribute [r] network
        #   @return [::String]
        #     Output only. The relative name of the Google Compute Engine
        #     [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
        #     to which the cluster is connected. Example:
        #     projects/my-project/global/networks/my-network
        # @!attribute [r] subnetwork
        #   @return [::String]
        #     Output only. The relative name of the Google Compute Engine
        #     [subnetwork](https://cloud.google.com/compute/docs/vpc)
        #     to which the cluster is connected. Example:
        #     projects/my-project/regions/us-central1/subnetworks/my-subnet
        # @!attribute [rw] enable_intra_node_visibility
        #   @return [::Boolean]
        #     Whether Intra-node visibility is enabled for this cluster.
        #     This makes same node pod to pod traffic visible for VPC network.
        # @!attribute [rw] default_snat_status
        #   @return [::Google::Cloud::Container::V1::DefaultSnatStatus]
        #     Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
        #     will be disabled when default_snat_status is disabled. When disabled is set
        #     to false, default IP masquerade rules will be applied to the nodes to
        #     prevent sNAT on cluster internal traffic.
        # @!attribute [rw] enable_l4ilb_subsetting
        #   @return [::Boolean]
        #     Whether L4ILB Subsetting is enabled for this cluster.
        # @!attribute [rw] datapath_provider
        #   @return [::Google::Cloud::Container::V1::DatapathProvider]
        #     The desired datapath provider for this cluster. By default, uses the
        #     IPTables-based kube-proxy implementation.
        # @!attribute [rw] private_ipv6_google_access
        #   @return [::Google::Cloud::Container::V1::PrivateIPv6GoogleAccess]
        #     The desired state of IPv6 connectivity to Google Services.
        #     By default, no private IPv6 access to or from Google Services (all access
        #     will be via IPv4)
        # @!attribute [rw] dns_config
        #   @return [::Google::Cloud::Container::V1::DNSConfig]
        #     DNSConfig contains clusterDNS config for this cluster.
        # @!attribute [rw] service_external_ips_config
        #   @return [::Google::Cloud::Container::V1::ServiceExternalIPsConfig]
        #     ServiceExternalIPsConfig specifies if services with externalIPs field are
        #     blocked or not.
        # @!attribute [rw] gateway_api_config
        #   @return [::Google::Cloud::Container::V1::GatewayAPIConfig]
        #     GatewayAPIConfig contains the desired config of Gateway API on this
        #     cluster.
        # @!attribute [rw] enable_multi_networking
        #   @return [::Boolean]
        #     Whether multi-networking is enabled for this cluster.
        # @!attribute [rw] network_performance_config
        #   @return [::Google::Cloud::Container::V1::NetworkConfig::ClusterNetworkPerformanceConfig]
        #     Network bandwidth tier configuration.
        # @!attribute [rw] enable_fqdn_network_policy
        #   @return [::Boolean]
        #     Whether FQDN Network Policy is enabled on this cluster.
        # @!attribute [rw] in_transit_encryption_config
        #   @return [::Google::Cloud::Container::V1::InTransitEncryptionConfig]
        #     Specify the details of in-transit encryption.
        #     Now named inter-node transparent encryption.
        # @!attribute [rw] enable_cilium_clusterwide_network_policy
        #   @return [::Boolean]
        #     Whether CiliumClusterwideNetworkPolicy is enabled on this cluster.
        # @!attribute [rw] default_enable_private_nodes
        #   @return [::Boolean]
        #     Controls whether by default nodes have private IP addresses only.
        #     It is invalid to specify both [PrivateClusterConfig.enablePrivateNodes][]
        #     and this field at the same time.
        #     To update the default setting, use
        #     {::Google::Cloud::Container::V1::ClusterUpdate#desired_default_enable_private_nodes ClusterUpdate.desired_default_enable_private_nodes}
        # @!attribute [rw] disable_l4_lb_firewall_reconciliation
        #   @return [::Boolean]
        #     Disable L4 load balancer VPC firewalls to enable firewall policies.
        class NetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration of network bandwidth tiers
          # @!attribute [rw] total_egress_bandwidth_tier
          #   @return [::Google::Cloud::Container::V1::NetworkConfig::ClusterNetworkPerformanceConfig::Tier]
          #     Specifies the total network bandwidth tier for NodePools in the cluster.
          class ClusterNetworkPerformanceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Node network tier
            module Tier
              # Default value
              TIER_UNSPECIFIED = 0

              # Higher bandwidth, actual values based on VM size.
              TIER_1 = 1
            end
          end
        end

        # GatewayAPIConfig contains the desired config of Gateway API on this cluster.
        # @!attribute [rw] channel
        #   @return [::Google::Cloud::Container::V1::GatewayAPIConfig::Channel]
        #     The Gateway API release channel to use for Gateway API.
        class GatewayAPIConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Channel describes if/how Gateway API should be installed and implemented in
          # a cluster.
          module Channel
            # Default value.
            CHANNEL_UNSPECIFIED = 0

            # Gateway API support is disabled
            CHANNEL_DISABLED = 1

            # Deprecated: use CHANNEL_STANDARD instead.
            # Gateway API support is enabled, experimental CRDs are installed
            CHANNEL_EXPERIMENTAL = 3

            # Gateway API support is enabled, standard CRDs are installed
            CHANNEL_STANDARD = 4
          end
        end

        # Config to block services with externalIPs field.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether Services with ExternalIPs field are allowed or not.
        class ServiceExternalIPsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetOpenIDConfigRequest gets the OIDC discovery document for the
        # cluster. See the OpenID Connect Discovery 1.0 specification for details.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The cluster (project, location, cluster name) to get the discovery document
        #     for. Specified in the format `projects/*/locations/*/clusters/*`.
        class GetOpenIDConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetOpenIDConfigResponse is an OIDC discovery document for the cluster.
        # See the OpenID Connect Discovery 1.0 specification for details.
        # @!attribute [rw] issuer
        #   @return [::String]
        #     OIDC Issuer.
        # @!attribute [rw] jwks_uri
        #   @return [::String]
        #     JSON Web Key uri.
        # @!attribute [rw] response_types_supported
        #   @return [::Array<::String>]
        #     Supported response types.
        # @!attribute [rw] subject_types_supported
        #   @return [::Array<::String>]
        #     Supported subject types.
        # @!attribute [rw] id_token_signing_alg_values_supported
        #   @return [::Array<::String>]
        #     supported ID Token signing Algorithms.
        # @!attribute [rw] claims_supported
        #   @return [::Array<::String>]
        #     Supported claims.
        # @!attribute [rw] grant_types
        #   @return [::Array<::String>]
        #     Supported grant types.
        class GetOpenIDConfigResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetJSONWebKeysRequest gets the public component of the keys used by the
        # cluster to sign token requests. This will be the jwks_uri for the discover
        # document returned by getOpenIDConfig. See the OpenID Connect
        # Discovery 1.0 specification for details.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The cluster (project, location, cluster name) to get keys for. Specified in
        #     the format `projects/*/locations/*/clusters/*`.
        class GetJSONWebKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Jwk is a JSON Web Key as specified in RFC 7517
        # @!attribute [rw] kty
        #   @return [::String]
        #     Key Type.
        # @!attribute [rw] alg
        #   @return [::String]
        #     Algorithm.
        # @!attribute [rw] use
        #   @return [::String]
        #     Permitted uses for the public keys.
        # @!attribute [rw] kid
        #   @return [::String]
        #     Key ID.
        # @!attribute [rw] n
        #   @return [::String]
        #     Used for RSA keys.
        # @!attribute [rw] e
        #   @return [::String]
        #     Used for RSA keys.
        # @!attribute [rw] x
        #   @return [::String]
        #     Used for ECDSA keys.
        # @!attribute [rw] y
        #   @return [::String]
        #     Used for ECDSA keys.
        # @!attribute [rw] crv
        #   @return [::String]
        #     Used for ECDSA keys.
        class Jwk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetJSONWebKeysResponse is a valid JSON Web Key Set as specified in rfc 7517
        # @!attribute [rw] keys
        #   @return [::Array<::Google::Cloud::Container::V1::Jwk>]
        #     The public component of the keys used by the cluster to sign token
        #     requests.
        class GetJSONWebKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CheckAutopilotCompatibilityRequest requests getting the blockers for the
        # given operation in the cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (project, location, cluster) of the cluster to retrieve.
        #     Specified in the format `projects/*/locations/*/clusters/*`.
        class CheckAutopilotCompatibilityRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AutopilotCompatibilityIssue contains information about a specific
        # compatibility issue with Autopilot mode.
        # @!attribute [rw] last_observation
        #   @return [::Google::Protobuf::Timestamp]
        #     The last time when this issue was observed.
        # @!attribute [rw] constraint_type
        #   @return [::String]
        #     The constraint type of the issue.
        # @!attribute [rw] incompatibility_type
        #   @return [::Google::Cloud::Container::V1::AutopilotCompatibilityIssue::IssueType]
        #     The incompatibility type of this issue.
        # @!attribute [rw] subjects
        #   @return [::Array<::String>]
        #     The name of the resources which are subject to this issue.
        # @!attribute [rw] documentation_url
        #   @return [::String]
        #     A URL to a public documentation, which addresses resolving this issue.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the issue.
        class AutopilotCompatibilityIssue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the reported issue.
          module IssueType
            # Default value, should not be used.
            UNSPECIFIED = 0

            # Indicates that the issue is a known incompatibility between the
            # cluster and Autopilot mode.
            INCOMPATIBILITY = 1

            # Indicates the issue is an incompatibility if customers take no further
            # action to resolve.
            ADDITIONAL_CONFIG_REQUIRED = 2

            # Indicates the issue is not an incompatibility, but depending on the
            # workloads business logic, there is a potential that they won't work on
            # Autopilot.
            PASSED_WITH_OPTIONAL_CONFIG = 3
          end
        end

        # CheckAutopilotCompatibilityResponse has a list of compatibility issues.
        # @!attribute [rw] issues
        #   @return [::Array<::Google::Cloud::Container::V1::AutopilotCompatibilityIssue>]
        #     The list of issues for the given operation.
        # @!attribute [rw] summary
        #   @return [::String]
        #     The summary of the autopilot compatibility response.
        class CheckAutopilotCompatibilityResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ReleaseChannel indicates which release channel a cluster is
        # subscribed to. Release channels are arranged in order of risk.
        #
        # When a cluster is subscribed to a release channel, Google maintains
        # both the master version and the node version. Node auto-upgrade
        # defaults to true and cannot be disabled.
        # @!attribute [rw] channel
        #   @return [::Google::Cloud::Container::V1::ReleaseChannel::Channel]
        #     channel specifies which release channel the cluster is subscribed to.
        class ReleaseChannel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible values for 'channel'.
          module Channel
            # No channel specified.
            UNSPECIFIED = 0

            # RAPID channel is offered on an early access basis for customers who want
            # to test new releases.
            #
            # WARNING: Versions available in the RAPID Channel may be subject to
            # unresolved issues with no known workaround and are not subject to any
            # SLAs.
            RAPID = 1

            # Clusters subscribed to REGULAR receive versions that are considered GA
            # quality. REGULAR is intended for production users who want to take
            # advantage of new features.
            REGULAR = 2

            # Clusters subscribed to STABLE receive versions that are known to be
            # stable and reliable in production.
            STABLE = 3

            # Clusters subscribed to EXTENDED receive extended support and availability
            # for versions which are known to be stable and reliable in production.
            EXTENDED = 4
          end
        end

        # Configuration for fine-grained cost management feature.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the feature is enabled or not.
        class CostManagementConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # IntraNodeVisibilityConfig contains the desired config of the intra-node
        # visibility on this cluster.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enables intra node visibility for this cluster.
        class IntraNodeVisibilityConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ILBSubsettingConfig contains the desired config of L4 Internal LoadBalancer
        # subsetting on this cluster.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enables l4 ILB subsetting for this cluster.
        class ILBSubsettingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DNSConfig contains the desired set of options for configuring clusterDNS.
        # @!attribute [rw] cluster_dns
        #   @return [::Google::Cloud::Container::V1::DNSConfig::Provider]
        #     cluster_dns indicates which in-cluster DNS provider should be used.
        # @!attribute [rw] cluster_dns_scope
        #   @return [::Google::Cloud::Container::V1::DNSConfig::DNSScope]
        #     cluster_dns_scope indicates the scope of access to cluster DNS records.
        # @!attribute [rw] cluster_dns_domain
        #   @return [::String]
        #     cluster_dns_domain is the suffix used for all cluster service records.
        # @!attribute [rw] additive_vpc_scope_dns_domain
        #   @return [::String]
        #     Optional. The domain used in Additive VPC scope.
        class DNSConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Provider lists the various in-cluster DNS providers.
          module Provider
            # Default value
            PROVIDER_UNSPECIFIED = 0

            # Use GKE default DNS provider(kube-dns) for DNS resolution.
            PLATFORM_DEFAULT = 1

            # Use CloudDNS for DNS resolution.
            CLOUD_DNS = 2

            # Use KubeDNS for DNS resolution.
            KUBE_DNS = 3
          end

          # DNSScope lists the various scopes of access to cluster DNS records.
          module DNSScope
            # Default value, will be inferred as cluster scope.
            DNS_SCOPE_UNSPECIFIED = 0

            # DNS records are accessible from within the cluster.
            CLUSTER_SCOPE = 1

            # DNS records are accessible from within the VPC.
            VPC_SCOPE = 2
          end
        end

        # Constraints applied to pods.
        # @!attribute [rw] max_pods_per_node
        #   @return [::Integer]
        #     Constraint enforced on the max num of pods per node.
        class MaxPodsConstraint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for the use of Kubernetes Service Accounts in IAM policies.
        # @!attribute [rw] workload_pool
        #   @return [::String]
        #     The workload pool to attach all Kubernetes service accounts to.
        class WorkloadIdentityConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # IdentityServiceConfig is configuration for Identity Service which allows
        # customers to use external identity providers with the K8S API
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether to enable the Identity Service component
        class IdentityServiceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for issuance of mTLS keys and certificates to Kubernetes pods.
        # @!attribute [rw] enable_certificates
        #   @return [::Google::Protobuf::BoolValue]
        #     enable_certificates controls issuance of workload mTLS certificates.
        #
        #     If set, the GKE Workload Identity Certificates controller and node agent
        #     will be deployed in the cluster, which can then be configured by creating a
        #     WorkloadCertificateConfig Custom Resource.
        #
        #     Requires Workload Identity
        #     ({::Google::Cloud::Container::V1::WorkloadIdentityConfig#workload_pool workload_pool}
        #     must be non-empty).
        class MeshCertificates
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of etcd encryption.
        # @!attribute [rw] key_name
        #   @return [::String]
        #     Name of CloudKMS key to use for the encryption of secrets in etcd.
        #     Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Container::V1::DatabaseEncryption::State]
        #     The desired state of etcd encryption.
        # @!attribute [r] current_state
        #   @return [::Google::Cloud::Container::V1::DatabaseEncryption::CurrentState]
        #     Output only. The current state of etcd encryption.
        # @!attribute [r] decryption_keys
        #   @return [::Array<::String>]
        #     Output only. Keys in use by the cluster for decrypting
        #     existing objects, in addition to the key in `key_name`.
        #
        #     Each item is a CloudKMS key resource.
        # @!attribute [r] last_operation_errors
        #   @return [::Array<::Google::Cloud::Container::V1::DatabaseEncryption::OperationError>]
        #     Output only. Records errors seen during DatabaseEncryption update
        #     operations.
        class DatabaseEncryption
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # OperationError records errors seen from CloudKMS keys
          # encountered during updates to DatabaseEncryption configuration.
          # @!attribute [rw] key_name
          #   @return [::String]
          #     CloudKMS key resource that had the error.
          # @!attribute [rw] error_message
          #   @return [::String]
          #     Description of the error seen during the operation.
          # @!attribute [rw] timestamp
          #   @return [::Google::Protobuf::Timestamp]
          #     Time when the CloudKMS error was seen.
          class OperationError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of etcd encryption.
          module State
            # Should never be set
            UNKNOWN = 0

            # Secrets in etcd are encrypted.
            ENCRYPTED = 1

            # Secrets in etcd are stored in plain text (at etcd level) - this is
            # unrelated to Compute Engine level full disk encryption.
            DECRYPTED = 2
          end

          # Current State of etcd encryption.
          module CurrentState
            # Should never be set
            CURRENT_STATE_UNSPECIFIED = 0

            # Secrets in etcd are encrypted.
            CURRENT_STATE_ENCRYPTED = 7

            # Secrets in etcd are stored in plain text (at etcd level) - this is
            # unrelated to Compute Engine level full disk encryption.
            CURRENT_STATE_DECRYPTED = 2

            # Encryption (or re-encryption with a different CloudKMS key)
            # of Secrets is in progress.
            CURRENT_STATE_ENCRYPTION_PENDING = 3

            # Encryption (or re-encryption with a different CloudKMS key) of Secrets in
            # etcd encountered an error.
            CURRENT_STATE_ENCRYPTION_ERROR = 4

            # De-crypting Secrets to plain text in etcd is in progress.
            CURRENT_STATE_DECRYPTION_PENDING = 5

            # De-crypting Secrets to plain text in etcd encountered an error.
            CURRENT_STATE_DECRYPTION_ERROR = 6
          end
        end

        # ListUsableSubnetworksRequest requests the list of usable subnetworks
        # available to a user for creating clusters.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent project where subnetworks are usable.
        #     Specified in the format `projects/*`.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering currently only supports equality on the networkProjectId and must
        #     be in the form: "networkProjectId=[PROJECTID]", where `networkProjectId`
        #     is the project which owns the listed subnetworks. This defaults to the
        #     parent project ID.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The max number of results per page that should be returned. If the number
        #     of available results is larger than `page_size`, a `next_page_token` is
        #     returned which can be used to get the next page of results in subsequent
        #     requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set this to the nextPageToken returned by
        #     previous list requests to get the next page of results.
        class ListUsableSubnetworksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListUsableSubnetworksResponse is the response of
        # ListUsableSubnetworksRequest.
        # @!attribute [rw] subnetworks
        #   @return [::Array<::Google::Cloud::Container::V1::UsableSubnetwork>]
        #     A list of usable subnetworks in the specified network project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     This token allows you to get the next page of results for list requests.
        #     If the number of results is larger than `page_size`, use the
        #     `next_page_token` as a value for the query parameter `page_token` in the
        #     next request. The value will become empty when there are no more pages.
        class ListUsableSubnetworksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Secondary IP range of a usable subnetwork.
        # @!attribute [rw] range_name
        #   @return [::String]
        #     The name associated with this subnetwork secondary range, used when adding
        #     an alias IP range to a VM instance.
        # @!attribute [rw] ip_cidr_range
        #   @return [::String]
        #     The range of IP addresses belonging to this subnetwork secondary range.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::Container::V1::UsableSubnetworkSecondaryRange::Status]
        #     This field is to determine the status of the secondary range programmably.
        class UsableSubnetworkSecondaryRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Status shows the current usage of a secondary IP range.
          module Status
            # UNKNOWN is the zero value of the Status enum. It's not a valid status.
            UNKNOWN = 0

            # UNUSED denotes that this range is unclaimed by any cluster.
            UNUSED = 1

            # IN_USE_SERVICE denotes that this range is claimed by cluster(s) for
            # services. User-managed services range can be shared between clusters
            # within the same subnetwork.
            IN_USE_SERVICE = 2

            # IN_USE_SHAREABLE_POD denotes this range was created by the network admin
            # and is currently claimed by a cluster for pods. It can only be used by
            # other clusters as a pod range.
            IN_USE_SHAREABLE_POD = 3

            # IN_USE_MANAGED_POD denotes this range was created by GKE and is claimed
            # for pods. It cannot be used for other clusters.
            IN_USE_MANAGED_POD = 4
          end
        end

        # UsableSubnetwork resource returns the subnetwork name, its associated network
        # and the primary CIDR range.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Subnetwork Name.
        #     Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
        # @!attribute [rw] network
        #   @return [::String]
        #     Network Name.
        #     Example: projects/my-project/global/networks/my-network
        # @!attribute [rw] ip_cidr_range
        #   @return [::String]
        #     The range of internal addresses that are owned by this subnetwork.
        # @!attribute [rw] secondary_ip_ranges
        #   @return [::Array<::Google::Cloud::Container::V1::UsableSubnetworkSecondaryRange>]
        #     Secondary IP ranges.
        # @!attribute [rw] status_message
        #   @return [::String]
        #     A human readable status message representing the reasons for cases where
        #     the caller cannot use the secondary ranges under the subnet. For example if
        #     the secondary_ip_ranges is empty due to a permission issue, an insufficient
        #     permission message will be given by status_message.
        class UsableSubnetwork
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for exporting cluster resource usages.
        # @!attribute [rw] bigquery_destination
        #   @return [::Google::Cloud::Container::V1::ResourceUsageExportConfig::BigQueryDestination]
        #     Configuration to use BigQuery as usage export destination.
        # @!attribute [rw] enable_network_egress_metering
        #   @return [::Boolean]
        #     Whether to enable network egress metering for this cluster. If enabled, a
        #     daemonset will be created in the cluster to meter network egress traffic.
        # @!attribute [rw] consumption_metering_config
        #   @return [::Google::Cloud::Container::V1::ResourceUsageExportConfig::ConsumptionMeteringConfig]
        #     Configuration to enable resource consumption metering.
        class ResourceUsageExportConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Parameters for using BigQuery as the destination of resource usage export.
          # @!attribute [rw] dataset_id
          #   @return [::String]
          #     The ID of a BigQuery Dataset.
          class BigQueryDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Parameters for controlling consumption metering.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Whether to enable consumption metering for this cluster. If enabled, a
          #     second BigQuery table will be created to hold resource consumption
          #     records.
          class ConsumptionMeteringConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # VerticalPodAutoscaling contains global, per-cluster information
        # required by Vertical Pod Autoscaler to automatically adjust
        # the resources of pods controlled by it.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enables vertical pod autoscaling.
        class VerticalPodAutoscaling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DefaultSnatStatus contains the desired state of whether default sNAT should
        # be disabled on the cluster.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Disables cluster default sNAT rules.
        class DefaultSnatStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of Shielded Nodes feature.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether Shielded Nodes features are enabled on all nodes in this cluster.
        class ShieldedNodes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of gVNIC feature.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether gVNIC features are enabled in the node pool.
        class VirtualNIC
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of Fast Socket feature.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether Fast Socket features are enabled in the node pool.
        class FastSocket
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # NotificationConfig is the configuration of notifications.
        # @!attribute [rw] pubsub
        #   @return [::Google::Cloud::Container::V1::NotificationConfig::PubSub]
        #     Notification config for Pub/Sub.
        class NotificationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Pub/Sub specific notification config.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Enable notifications for Pub/Sub.
          # @!attribute [rw] topic
          #   @return [::String]
          #     The desired Pub/Sub topic to which notifications will be
          #     sent by GKE. Format is `projects/{project}/topics/{topic}`.
          # @!attribute [rw] filter
          #   @return [::Google::Cloud::Container::V1::NotificationConfig::Filter]
          #     Allows filtering to one or more specific event types. If no filter is
          #     specified, or if a filter is specified with no event types, all event
          #     types will be sent
          class PubSub
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Allows filtering to one or more specific event types. If event types are
          # present, those and only those event types will be transmitted to the
          # cluster. Other types will be skipped. If no filter is specified, or no
          # event types are present, all event types will be sent
          # @!attribute [rw] event_type
          #   @return [::Array<::Google::Cloud::Container::V1::NotificationConfig::EventType>]
          #     Event types to allowlist.
          class Filter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Types of notifications currently supported. Can be used to filter what
          # notifications are sent.
          module EventType
            # Not set, will be ignored.
            EVENT_TYPE_UNSPECIFIED = 0

            # Corresponds with UpgradeAvailableEvent.
            UPGRADE_AVAILABLE_EVENT = 1

            # Corresponds with UpgradeEvent.
            UPGRADE_EVENT = 2

            # Corresponds with SecurityBulletinEvent.
            SECURITY_BULLETIN_EVENT = 3

            # Corresponds with UpgradeInfoEvent.
            UPGRADE_INFO_EVENT = 4
          end
        end

        # ConfidentialNodes is configuration for the confidential nodes feature, which
        # makes nodes run on confidential VMs.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether Confidential Nodes feature is enabled.
        # @!attribute [rw] confidential_instance_type
        #   @return [::Google::Cloud::Container::V1::ConfidentialNodes::ConfidentialInstanceType]
        #     Defines the type of technology used by the confidential node.
        class ConfidentialNodes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of technology used by the confidential node.
          module ConfidentialInstanceType
            # No type specified. Do not use this value.
            CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED = 0

            # AMD Secure Encrypted Virtualization.
            SEV = 1

            # AMD Secure Encrypted Virtualization - Secure Nested Paging.
            SEV_SNP = 2

            # Intel Trust Domain eXtension.
            TDX = 3
          end
        end

        # UpgradeEvent is a notification sent to customers by the cluster server when
        # a resource is upgrading.
        # @!attribute [rw] resource_type
        #   @return [::Google::Cloud::Container::V1::UpgradeResourceType]
        #     The resource type that is upgrading.
        # @!attribute [rw] operation
        #   @return [::String]
        #     The operation associated with this upgrade.
        # @!attribute [rw] operation_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation was started.
        # @!attribute [rw] current_version
        #   @return [::String]
        #     The current version before the upgrade.
        # @!attribute [rw] target_version
        #   @return [::String]
        #     The target version for the upgrade.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Optional relative path to the resource. For example in node pool upgrades,
        #     the relative path of the node pool.
        class UpgradeEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpgradeInfoEvent is a notification sent to customers about the upgrade
        # information of a resource.
        # @!attribute [rw] resource_type
        #   @return [::Google::Cloud::Container::V1::UpgradeResourceType]
        #     The resource type associated with the upgrade.
        # @!attribute [rw] operation
        #   @return [::String]
        #     The operation associated with this upgrade.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation was started.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation ended.
        # @!attribute [rw] current_version
        #   @return [::String]
        #     The current version before the upgrade.
        # @!attribute [rw] target_version
        #   @return [::String]
        #     The target version for the upgrade.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Optional relative path to the resource. For example in node pool upgrades,
        #     the relative path of the node pool.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Container::V1::UpgradeInfoEvent::State]
        #     Output only. The state of the upgrade.
        # @!attribute [rw] standard_support_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end of standard support timestamp.
        # @!attribute [rw] extended_support_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end of extended support timestamp.
        # @!attribute [rw] description
        #   @return [::String]
        #     A brief description of the event.
        # @!attribute [rw] event_type
        #   @return [::Google::Cloud::Container::V1::UpgradeInfoEvent::EventType]
        #     The type of the event.
        class UpgradeInfoEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The state of the upgrade.
          module State
            # STATE_UNSPECIFIED indicates the state is unspecified.
            STATE_UNSPECIFIED = 0

            # STARTED indicates the upgrade has started.
            STARTED = 3

            # SUCCEEDED indicates the upgrade has completed successfully.
            SUCCEEDED = 4

            # FAILED indicates the upgrade has failed.
            FAILED = 5

            # CANCELED indicates the upgrade has canceled.
            CANCELED = 6
          end

          # The type of the event.
          module EventType
            # EVENT_TYPE_UNSPECIFIED indicates the event type is unspecified.
            EVENT_TYPE_UNSPECIFIED = 0

            # END_OF_SUPPORT indicates GKE version reaches end of support, check
            # standard_support_end_time and extended_support_end_time for more details.
            END_OF_SUPPORT = 1

            # COS_MILESTONE_VERSION_UPDATE indicates that the COS node image will
            # update COS milestone version for new patch versions starting with
            # the one in the description.
            COS_MILESTONE_VERSION_UPDATE = 2

            # UPGRADE_LIFECYCLE indicates the event is about the upgrade lifecycle.
            UPGRADE_LIFECYCLE = 3
          end
        end

        # UpgradeAvailableEvent is a notification sent to customers when a new
        # available version is released.
        # @!attribute [rw] version
        #   @return [::String]
        #     The release version available for upgrade.
        # @!attribute [rw] resource_type
        #   @return [::Google::Cloud::Container::V1::UpgradeResourceType]
        #     The resource type of the release version.
        # @!attribute [rw] release_channel
        #   @return [::Google::Cloud::Container::V1::ReleaseChannel]
        #     The release channel of the version. If empty, it means a non-channel
        #     release.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Optional relative path to the resource. For example, the relative path of
        #     the node pool.
        class UpgradeAvailableEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SecurityBulletinEvent is a notification sent to customers when a security
        # bulletin has been posted that they are vulnerable to.
        # @!attribute [rw] resource_type_affected
        #   @return [::String]
        #     The resource type (node/control plane) that has the vulnerability. Multiple
        #     notifications (1 notification per resource type) will be sent for a
        #     vulnerability that affects > 1 resource type.
        # @!attribute [rw] bulletin_id
        #   @return [::String]
        #     The ID of the bulletin corresponding to the vulnerability.
        # @!attribute [rw] cve_ids
        #   @return [::Array<::String>]
        #     The CVEs associated with this bulletin.
        # @!attribute [rw] severity
        #   @return [::String]
        #     The severity of this bulletin as it relates to GKE.
        # @!attribute [rw] bulletin_uri
        #   @return [::String]
        #     The URI link to the bulletin on the website for more information.
        # @!attribute [rw] brief_description
        #   @return [::String]
        #     A brief description of the bulletin. See the bulletin pointed to by the
        #     bulletin_uri field for an expanded description.
        # @!attribute [rw] affected_supported_minors
        #   @return [::Array<::String>]
        #     The GKE minor versions affected by this vulnerability.
        # @!attribute [rw] patched_versions
        #   @return [::Array<::String>]
        #     The GKE versions where this vulnerability is patched.
        # @!attribute [rw] suggested_upgrade_target
        #   @return [::String]
        #     This represents a version selected from the patched_versions field that
        #     the cluster receiving this notification should most likely want to upgrade
        #     to based on its current version. Note that if this notification is being
        #     received by a given cluster, it means that this version is currently
        #     available as an upgrade target in that cluster's location.
        # @!attribute [rw] manual_steps_required
        #   @return [::Boolean]
        #     If this field is specified, it means there are manual steps that the user
        #     must take to make their clusters safe.
        # @!attribute [rw] mitigated_versions
        #   @return [::Array<::String>]
        #     The GKE versions where this vulnerability is mitigated.
        class SecurityBulletinEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Autopilot is the configuration for Autopilot settings on the cluster.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enable Autopilot
        # @!attribute [rw] workload_policy_config
        #   @return [::Google::Cloud::Container::V1::WorkloadPolicyConfig]
        #     WorkloadPolicyConfig is the configuration related to GCW workload policy
        # @!attribute [rw] privileged_admission_config
        #   @return [::Google::Cloud::Container::V1::PrivilegedAdmissionConfig]
        #     PrivilegedAdmissionConfig is the configuration related to privileged
        #     admission control.
        class Autopilot
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PrivilegedAdmissionConfig stores the list of authorized allowlist
        # paths for the cluster.
        # @!attribute [rw] allowlist_paths
        #   @return [::Array<::String>]
        #     The customer allowlist Cloud Storage paths for the cluster. These paths are
        #     used with the `--autopilot-privileged-admission` flag to authorize
        #     privileged workloads in Autopilot clusters.
        #
        #     Paths can be GKE-owned, in the format
        #     `gke://<partner_name>/<app_name>/<allowlist_path>`, or customer-owned, in
        #     the format `gs://<bucket_name>/<allowlist_path>`.
        #
        #     Wildcards (`*`) are supported to authorize all allowlists under specific
        #     paths or directories. Example: `gs://my-bucket/*` will authorize all
        #     allowlists under the `my-bucket` bucket.
        class PrivilegedAdmissionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # WorkloadPolicyConfig is the configuration related to GCW workload policy
        # @!attribute [rw] allow_net_admin
        #   @return [::Boolean]
        #     If true, workloads can use NET_ADMIN capability.
        # @!attribute [rw] autopilot_compatibility_auditing_enabled
        #   @return [::Boolean]
        #     If true, enables the GCW Auditor that audits workloads on
        #     standard clusters.
        class WorkloadPolicyConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # LoggingConfig is cluster logging configuration.
        # @!attribute [rw] component_config
        #   @return [::Google::Cloud::Container::V1::LoggingComponentConfig]
        #     Logging components configuration
        class LoggingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # LoggingComponentConfig is cluster logging component configuration.
        # @!attribute [rw] enable_components
        #   @return [::Array<::Google::Cloud::Container::V1::LoggingComponentConfig::Component>]
        #     Select components to collect logs. An empty set would disable all logging.
        class LoggingComponentConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # GKE components exposing logs
          module Component
            # Default value. This shouldn't be used.
            COMPONENT_UNSPECIFIED = 0

            # system components
            SYSTEM_COMPONENTS = 1

            # workloads
            WORKLOADS = 2

            # kube-apiserver
            APISERVER = 3

            # kube-scheduler
            SCHEDULER = 4

            # kube-controller-manager
            CONTROLLER_MANAGER = 5

            # kcp-sshd
            KCP_SSHD = 7

            # kcp connection logs
            KCP_CONNECTION = 8

            # horizontal pod autoscaler decision logs
            KCP_HPA = 9
          end
        end

        # RayClusterLoggingConfig specifies configuration of Ray logging.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enable log collection for Ray clusters.
        class RayClusterLoggingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MonitoringConfig is cluster monitoring configuration.
        # @!attribute [rw] component_config
        #   @return [::Google::Cloud::Container::V1::MonitoringComponentConfig]
        #     Monitoring components configuration
        # @!attribute [rw] managed_prometheus_config
        #   @return [::Google::Cloud::Container::V1::ManagedPrometheusConfig]
        #     Enable Google Cloud Managed Service for Prometheus
        #     in the cluster.
        # @!attribute [rw] advanced_datapath_observability_config
        #   @return [::Google::Cloud::Container::V1::AdvancedDatapathObservabilityConfig]
        #     Configuration of Advanced Datapath Observability features.
        class MonitoringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AdvancedDatapathObservabilityConfig specifies configuration of observability
        # features of advanced datapath.
        # @!attribute [rw] enable_metrics
        #   @return [::Boolean]
        #     Expose flow metrics on nodes
        # @!attribute [rw] relay_mode
        #   @return [::Google::Cloud::Container::V1::AdvancedDatapathObservabilityConfig::RelayMode]
        #     Method used to make Relay available
        # @!attribute [rw] enable_relay
        #   @return [::Boolean]
        #     Enable Relay component
        class AdvancedDatapathObservabilityConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported Relay modes
          module RelayMode
            # Default value. This shouldn't be used.
            RELAY_MODE_UNSPECIFIED = 0

            # disabled
            DISABLED = 1

            # exposed via internal load balancer
            INTERNAL_VPC_LB = 3

            # exposed via external load balancer
            EXTERNAL_LB = 4
          end
        end

        # RayClusterMonitoringConfig specifies monitoring configuration for Ray
        # clusters.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enable metrics collection for Ray clusters.
        class RayClusterMonitoringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # NodePoolLoggingConfig specifies logging configuration for nodepools.
        # @!attribute [rw] variant_config
        #   @return [::Google::Cloud::Container::V1::LoggingVariantConfig]
        #     Logging variant configuration.
        class NodePoolLoggingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # LoggingVariantConfig specifies the behaviour of the logging component.
        # @!attribute [rw] variant
        #   @return [::Google::Cloud::Container::V1::LoggingVariantConfig::Variant]
        #     Logging variant deployed on nodes.
        class LoggingVariantConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Logging component variants.
          module Variant
            # Default value. This shouldn't be used.
            VARIANT_UNSPECIFIED = 0

            # default logging variant.
            DEFAULT = 1

            # maximum logging throughput variant.
            MAX_THROUGHPUT = 2
          end
        end

        # MonitoringComponentConfig is cluster monitoring component configuration.
        # @!attribute [rw] enable_components
        #   @return [::Array<::Google::Cloud::Container::V1::MonitoringComponentConfig::Component>]
        #     Select components to collect metrics. An empty set would disable all
        #     monitoring.
        class MonitoringComponentConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # GKE components exposing metrics
          module Component
            # Default value. This shouldn't be used.
            COMPONENT_UNSPECIFIED = 0

            # system components
            SYSTEM_COMPONENTS = 1

            # kube-apiserver
            APISERVER = 3

            # kube-scheduler
            SCHEDULER = 4

            # kube-controller-manager
            CONTROLLER_MANAGER = 5

            # Storage
            STORAGE = 7

            # Horizontal Pod Autoscaling
            HPA = 8

            # Pod
            POD = 9

            # DaemonSet
            DAEMONSET = 10

            # Deployment
            DEPLOYMENT = 11

            # Statefulset
            STATEFULSET = 12

            # CADVISOR
            CADVISOR = 13

            # KUBELET
            KUBELET = 14

            # NVIDIA Data Center GPU Manager (DCGM)
            DCGM = 15

            # JobSet
            JOBSET = 16
          end
        end

        # ManagedPrometheusConfig defines the configuration for
        # Google Cloud Managed Service for Prometheus.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enable Managed Collection.
        # @!attribute [rw] auto_monitoring_config
        #   @return [::Google::Cloud::Container::V1::AutoMonitoringConfig]
        #     GKE Workload Auto-Monitoring Configuration.
        class ManagedPrometheusConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AutoMonitoringConfig defines the configuration for GKE Workload
        # Auto-Monitoring.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::Container::V1::AutoMonitoringConfig::Scope]
        #     Scope for GKE Workload Auto-Monitoring.
        class AutoMonitoringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Scope for applications monitored by Auto-Monitoring
          module Scope
            # Not set.
            SCOPE_UNSPECIFIED = 0

            # Auto-Monitoring is enabled for all supported applications.
            ALL = 1

            # Disable Auto-Monitoring.
            NONE = 2
          end
        end

        # PodAutoscaling is used for configuration of parameters
        # for workload autoscaling.
        # @!attribute [rw] hpa_profile
        #   @return [::Google::Cloud::Container::V1::PodAutoscaling::HPAProfile]
        #     Selected Horizontal Pod Autoscaling profile.
        class PodAutoscaling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible types of Horizontal Pod Autoscaling profile.
          module HPAProfile
            # HPA_PROFILE_UNSPECIFIED is used when no custom HPA profile is set.
            HPA_PROFILE_UNSPECIFIED = 0

            # Customers explicitly opt-out of HPA profiles.
            NONE = 1

            # PERFORMANCE is used when customers opt-in to the performance HPA profile.
            # In this profile we support a higher number of HPAs per cluster and faster
            # metrics collection for workload autoscaling.
            PERFORMANCE = 2
          end
        end

        # Fleet is the fleet configuration for the cluster.
        # @!attribute [rw] project
        #   @return [::String]
        #     The Fleet host project(project ID or project number) where this cluster
        #     will be registered to. This field cannot be changed after the cluster has
        #     been registered.
        # @!attribute [r] membership
        #   @return [::String]
        #     Output only. The full resource name of the registered fleet membership of
        #     the cluster, in the format
        #     `//gkehub.googleapis.com/projects/*/locations/*/memberships/*`.
        # @!attribute [r] pre_registered
        #   @return [::Boolean]
        #     Output only. Whether the cluster has been registered through the fleet
        #     API.
        # @!attribute [rw] membership_type
        #   @return [::Google::Cloud::Container::V1::Fleet::MembershipType]
        #     The type of the cluster's fleet membership.
        class Fleet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # MembershipType describes if the membership supports all features or only
          # lightweight compatible ones.
          module MembershipType
            # The MembershipType is not set.
            MEMBERSHIP_TYPE_UNSPECIFIED = 0

            # The membership supports only lightweight compatible features.
            LIGHTWEIGHT = 1
          end
        end

        # Configuration for all of the cluster's control plane endpoints.
        # @!attribute [rw] dns_endpoint_config
        #   @return [::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig::DNSEndpointConfig]
        #     DNS endpoint configuration.
        # @!attribute [rw] ip_endpoints_config
        #   @return [::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig::IPEndpointsConfig]
        #     IP endpoints configuration.
        class ControlPlaneEndpointsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes the configuration of a DNS endpoint.
          # @!attribute [r] endpoint
          #   @return [::String]
          #     Output only. The cluster's DNS endpoint configuration.
          #     A DNS format address. This is accessible from the public internet.
          #     Ex: uid.us-central1.gke.goog.
          #     Always present, but the behavior may change according to the value of
          #     {::Google::Cloud::Container::V1::ControlPlaneEndpointsConfig::DNSEndpointConfig#allow_external_traffic DNSEndpointConfig.allow_external_traffic}.
          # @!attribute [rw] allow_external_traffic
          #   @return [::Boolean]
          #     Controls whether user traffic is allowed over this endpoint. Note that
          #     Google-managed services may still use the endpoint even if this is false.
          # @!attribute [rw] enable_k8s_tokens_via_dns
          #   @return [::Boolean]
          #     Controls whether the k8s token auth is allowed via DNS.
          # @!attribute [rw] enable_k8s_certs_via_dns
          #   @return [::Boolean]
          #     Controls whether the k8s certs auth is allowed via DNS.
          class DNSEndpointConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # IP endpoints configuration.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Controls whether to allow direct IP access.
          # @!attribute [rw] enable_public_endpoint
          #   @return [::Boolean]
          #     Controls whether the control plane allows access through a public IP.
          #     It is invalid to specify both
          #     [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
          #     time.
          # @!attribute [rw] global_access
          #   @return [::Boolean]
          #     Controls whether the control plane's private endpoint is accessible from
          #     sources in other regions.
          #     It is invalid to specify both
          #     {::Google::Cloud::Container::V1::PrivateClusterMasterGlobalAccessConfig#enabled PrivateClusterMasterGlobalAccessConfig.enabled}
          #     and this field at the same time.
          # @!attribute [rw] authorized_networks_config
          #   @return [::Google::Cloud::Container::V1::MasterAuthorizedNetworksConfig]
          #     Configuration of authorized networks. If enabled, restricts access to the
          #     control plane based on source IP.
          #     It is invalid to specify both
          #     [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
          #     time.
          # @!attribute [r] public_endpoint
          #   @return [::String]
          #     Output only. The external IP address of this cluster's control plane.
          #     Only populated if enabled.
          # @!attribute [r] private_endpoint
          #   @return [::String]
          #     Output only. The internal IP address of this cluster's control plane.
          #     Only populated if enabled.
          # @!attribute [rw] private_endpoint_subnetwork
          #   @return [::String]
          #     Subnet to provision the master's private endpoint during cluster
          #     creation. Specified in projects/*/regions/*/subnetworks/* format. It is
          #     invalid to specify both
          #     [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
          #     same time.
          class IPEndpointsConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # LocalNvmeSsdBlockConfig contains configuration for using raw-block local
        # NVMe SSDs
        # @!attribute [rw] local_ssd_count
        #   @return [::Integer]
        #     Number of local NVMe SSDs to use.  The limit for this value is dependent
        #     upon the maximum number of disk available on a machine per zone. See:
        #     https://cloud.google.com/compute/docs/disks/local-ssd
        #     for more information.
        #
        #     A zero (or unset) value has different meanings depending on machine type
        #     being used:
        #     1. For pre-Gen3 machines, which support flexible numbers of local ssds,
        #     zero (or unset) means to disable using local SSDs as ephemeral storage.
        #     2. For Gen3 machines which dictate a specific number of local ssds, zero
        #     (or unset) means to use the default number of local ssds that goes with
        #     that machine type. For example, for a c3-standard-8-lssd machine, 2 local
        #     ssds would be provisioned. For c3-standard-8 (which doesn't support local
        #     ssds), 0 will be provisioned. See
        #     https://cloud.google.com/compute/docs/disks/local-ssd#choose_number_local_ssds
        #     for more info.
        class LocalNvmeSsdBlockConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # EphemeralStorageLocalSsdConfig contains configuration for the node ephemeral
        # storage using Local SSDs.
        # @!attribute [rw] local_ssd_count
        #   @return [::Integer]
        #     Number of local SSDs to use to back ephemeral storage. Uses NVMe
        #     interfaces.
        #
        #     A zero (or unset) value has different meanings depending on machine type
        #     being used:
        #     1. For pre-Gen3 machines, which support flexible numbers of local ssds,
        #     zero (or unset) means to disable using local SSDs as ephemeral storage. The
        #     limit for this value is dependent upon the maximum number of disk
        #     available on a machine per zone. See:
        #     https://cloud.google.com/compute/docs/disks/local-ssd
        #     for more information.
        #     2. For Gen3 machines which dictate a specific number of local ssds, zero
        #     (or unset) means to use the default number of local ssds that goes with
        #     that machine type. For example, for a c3-standard-8-lssd machine, 2 local
        #     ssds would be provisioned. For c3-standard-8 (which doesn't support local
        #     ssds), 0 will be provisioned. See
        #     https://cloud.google.com/compute/docs/disks/local-ssd#choose_number_local_ssds
        #     for more info.
        # @!attribute [rw] data_cache_count
        #   @return [::Integer]
        #     Number of local SSDs to use for GKE Data Cache.
        class EphemeralStorageLocalSsdConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A map of resource manager tag keys and values to be attached to the nodes
        # for managing Compute Engine firewalls using Network Firewall Policies.
        # Tags must be according to specifications in
        # https://cloud.google.com/vpc/docs/tags-firewalls-overview#specifications.
        # A maximum of 5 tag key-value pairs can be specified.
        # Existing tags will be replaced with new values.
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
        #     1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
        #     2. `{org_id}/{tag_key_name}={tag_value_name}`
        #     3. `{project_id}/{tag_key_name}={tag_value_name}`
        class ResourceManagerTags
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # EnterpriseConfig is the cluster enterprise configuration.
        #
        # Deprecated: GKE Enterprise features are now available without an Enterprise
        # tier.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [r] cluster_tier
        #   @return [::Google::Cloud::Container::V1::EnterpriseConfig::ClusterTier]
        #     Output only. cluster_tier indicates the effective tier of the cluster.
        # @!attribute [rw] desired_tier
        #   @return [::Google::Cloud::Container::V1::EnterpriseConfig::ClusterTier]
        #     desired_tier specifies the desired tier of the cluster.
        class EnterpriseConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Premium tiers for GKE Cluster.
          #
          # Deprecated: GKE Enterprise features are now available without an Enterprise
          # tier.
          # @deprecated This enum is deprecated and may be removed in the next major version update.
          module ClusterTier
            # CLUSTER_TIER_UNSPECIFIED is when cluster_tier is not set.
            CLUSTER_TIER_UNSPECIFIED = 0

            # STANDARD indicates a standard GKE cluster.
            STANDARD = 1

            # ENTERPRISE indicates a GKE Enterprise cluster.
            ENTERPRISE = 2
          end
        end

        # SecretManagerConfig is config for secret manager enablement.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enable/Disable Secret Manager Config.
        # @!attribute [rw] rotation_config
        #   @return [::Google::Cloud::Container::V1::SecretManagerConfig::RotationConfig]
        #     Rotation config for secret manager.
        class SecretManagerConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # RotationConfig is config for secret manager auto rotation.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Whether the rotation is enabled.
          # @!attribute [rw] rotation_interval
          #   @return [::Google::Protobuf::Duration]
          #     The interval between two consecutive rotations. Default rotation interval
          #     is 2 minutes.
          class RotationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # BootDisk specifies the boot disk configuration for nodepools.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Disk type of the boot disk.
        #     (i.e. Hyperdisk-Balanced, PD-Balanced, etc.)
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     Disk size in GB. Replaces NodeConfig.disk_size_gb
        # @!attribute [rw] provisioned_iops
        #   @return [::Integer]
        #     For Hyperdisk-Balanced only, the provisioned IOPS config value.
        # @!attribute [rw] provisioned_throughput
        #   @return [::Integer]
        #     For Hyperdisk-Balanced only, the provisioned throughput config value.
        class BootDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SecondaryBootDisk represents a persistent disk attached to a node
        # with special configurations based on its mode.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::Container::V1::SecondaryBootDisk::Mode]
        #     Disk mode (container image cache, etc.)
        # @!attribute [rw] disk_image
        #   @return [::String]
        #     Fully-qualified resource ID for an existing disk image.
        class SecondaryBootDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Mode specifies how the secondary boot disk will be used.
          # This triggers mode-specified logic in the control plane.
          module Mode
            # MODE_UNSPECIFIED is when mode is not set.
            MODE_UNSPECIFIED = 0

            # CONTAINER_IMAGE_CACHE is for using the secondary boot disk as
            # a container image cache.
            CONTAINER_IMAGE_CACHE = 1
          end
        end

        # SecondaryBootDiskUpdateStrategy is a placeholder which will be extended
        # in the future to define different options for updating secondary boot disks.
        class SecondaryBootDiskUpdateStrategy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # FetchClusterUpgradeInfoRequest fetches the upgrade information of a cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name (project, location, cluster) of the cluster to get.
        #     Specified in the format `projects/*/locations/*/clusters/*` or
        #     `projects/*/zones/*/clusters/*`.
        # @!attribute [rw] version
        #   @return [::String]
        #     API request version that initiates this operation.
        class FetchClusterUpgradeInfoRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ClusterUpgradeInfo contains the upgrade information of a cluster.
        # @!attribute [rw] minor_target_version
        #   @return [::String]
        #     minor_target_version indicates the target version for minor upgrade.
        # @!attribute [rw] patch_target_version
        #   @return [::String]
        #     patch_target_version indicates the target version for patch upgrade.
        # @!attribute [rw] auto_upgrade_status
        #   @return [::Array<::Google::Cloud::Container::V1::ClusterUpgradeInfo::AutoUpgradeStatus>]
        #     The auto upgrade status.
        # @!attribute [rw] paused_reason
        #   @return [::Array<::Google::Cloud::Container::V1::ClusterUpgradeInfo::AutoUpgradePausedReason>]
        #     The auto upgrade paused reason.
        # @!attribute [rw] upgrade_details
        #   @return [::Array<::Google::Cloud::Container::V1::UpgradeDetails>]
        #     The list of past auto upgrades.
        # @!attribute [rw] end_of_standard_support_timestamp
        #   @return [::String]
        #     The cluster's current minor version's end of standard support timestamp.
        # @!attribute [rw] end_of_extended_support_timestamp
        #   @return [::String]
        #     The cluster's current minor version's end of extended support timestamp.
        class ClusterUpgradeInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # AutoUpgradeStatus indicates the status of auto upgrade.
          module AutoUpgradeStatus
            # UNKNOWN indicates an unknown status.
            UNKNOWN = 0

            # ACTIVE indicates an active status.
            ACTIVE = 1

            # MINOR_UPGRADE_PAUSED indicates the minor version upgrade is
            # paused.
            MINOR_UPGRADE_PAUSED = 4

            # UPGRADE_PAUSED indicates the upgrade is paused.
            UPGRADE_PAUSED = 5
          end

          # AutoUpgradePausedReason indicates the reason for auto upgrade paused
          # status.
          module AutoUpgradePausedReason
            # AUTO_UPGRADE_PAUSED_REASON_UNSPECIFIED indicates an unspecified reason.
            AUTO_UPGRADE_PAUSED_REASON_UNSPECIFIED = 0

            # MAINTENANCE_WINDOW indicates the cluster is outside customer maintenance
            # window.
            MAINTENANCE_WINDOW = 1

            # MAINTENANCE_EXCLUSION_NO_UPGRADES indicates the cluster is in a
            # maintenance exclusion with scope NO_UPGRADES.
            MAINTENANCE_EXCLUSION_NO_UPGRADES = 5

            # MAINTENANCE_EXCLUSION_NO_MINOR_UPGRADES indicates the cluster is in a
            # maintenance exclusion with scope NO_MINOR_UPGRADES.
            MAINTENANCE_EXCLUSION_NO_MINOR_UPGRADES = 6

            # CLUSTER_DISRUPTION_BUDGET indicates the cluster is outside the cluster
            # disruption budget.
            CLUSTER_DISRUPTION_BUDGET = 4

            # CLUSTER_DISRUPTION_BUDGET_MINOR_UPGRADE indicates the cluster is outside
            # the cluster disruption budget for minor version upgrade.
            CLUSTER_DISRUPTION_BUDGET_MINOR_UPGRADE = 7

            # SYSTEM_CONFIG indicates the cluster upgrade is paused  by system config.
            SYSTEM_CONFIG = 8
          end
        end

        # UpgradeDetails contains detailed information of each individual upgrade
        # operation.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Container::V1::UpgradeDetails::State]
        #     Output only. The state of the upgrade.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The start timestamp of the upgrade.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end timestamp of the upgrade.
        # @!attribute [rw] initial_version
        #   @return [::String]
        #     The version before the upgrade.
        # @!attribute [rw] target_version
        #   @return [::String]
        #     The version after the upgrade.
        # @!attribute [rw] start_type
        #   @return [::Google::Cloud::Container::V1::UpgradeDetails::StartType]
        #     The start type of the upgrade.
        class UpgradeDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State indicates the state of the upgrade.
          module State
            # Upgrade state is unknown.
            UNKNOWN = 0

            # Upgrade has failed with an error.
            FAILED = 1

            # Upgrade has succeeded.
            SUCCEEDED = 2

            # Upgrade has been canceled.
            CANCELED = 3

            # Upgrade is running.
            RUNNING = 4
          end

          # StartType indicates the type of starting the upgrade.
          module StartType
            # Upgrade start type is unspecified.
            START_TYPE_UNSPECIFIED = 0

            # Upgrade started automatically.
            AUTOMATIC = 1

            # Upgrade started manually.
            MANUAL = 2
          end
        end

        # FetchNodePoolUpgradeInfoRequest fetches the upgrade information of a
        # nodepool.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name (project, location, cluster, nodepool) of the nodepool
        #     to get. Specified in the format
        #     `projects/*/locations/*/clusters/*/nodePools/*` or
        #     `projects/*/zones/*/clusters/*/nodePools/*`.
        # @!attribute [rw] version
        #   @return [::String]
        #     API request version that initiates this operation.
        class FetchNodePoolUpgradeInfoRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # NodePoolUpgradeInfo contains the upgrade information of a nodepool.
        # @!attribute [rw] minor_target_version
        #   @return [::String]
        #     minor_target_version indicates the target version for minor upgrade.
        # @!attribute [rw] patch_target_version
        #   @return [::String]
        #     patch_target_version indicates the target version for patch upgrade.
        # @!attribute [rw] auto_upgrade_status
        #   @return [::Array<::Google::Cloud::Container::V1::NodePoolUpgradeInfo::AutoUpgradeStatus>]
        #     The auto upgrade status.
        # @!attribute [rw] paused_reason
        #   @return [::Array<::Google::Cloud::Container::V1::NodePoolUpgradeInfo::AutoUpgradePausedReason>]
        #     The auto upgrade paused reason.
        # @!attribute [rw] upgrade_details
        #   @return [::Array<::Google::Cloud::Container::V1::UpgradeDetails>]
        #     The list of past auto upgrades.
        # @!attribute [rw] end_of_standard_support_timestamp
        #   @return [::String]
        #     The nodepool's current minor version's end of standard support timestamp.
        # @!attribute [rw] end_of_extended_support_timestamp
        #   @return [::String]
        #     The nodepool's current minor version's end of extended support timestamp.
        class NodePoolUpgradeInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # AutoUpgradeStatus indicates the status of auto upgrade.
          module AutoUpgradeStatus
            # UNKNOWN indicates an unknown status.
            UNKNOWN = 0

            # ACTIVE indicates an active status.
            ACTIVE = 1

            # MINOR_UPGRADE_PAUSED indicates the minor version upgrade is
            # paused.
            MINOR_UPGRADE_PAUSED = 2

            # UPGRADE_PAUSED indicates the upgrade is paused.
            UPGRADE_PAUSED = 3
          end

          # AutoUpgradePausedReason indicates the reason for auto upgrade paused
          # status.
          module AutoUpgradePausedReason
            # AUTO_UPGRADE_PAUSED_REASON_UNSPECIFIED indicates an unspecified reason.
            AUTO_UPGRADE_PAUSED_REASON_UNSPECIFIED = 0

            # MAINTENANCE_WINDOW indicates the cluster is outside customer maintenance
            # window.
            MAINTENANCE_WINDOW = 1

            # MAINTENANCE_EXCLUSION_NO_UPGRADES indicates the cluster is in a
            # maintenance exclusion with scope NO_UPGRADES.
            MAINTENANCE_EXCLUSION_NO_UPGRADES = 2

            # MAINTENANCE_EXCLUSION_NO_MINOR_UPGRADES indicates the cluster is in a
            # maintenance exclusion with scope NO_MINOR_UPGRADES.
            MAINTENANCE_EXCLUSION_NO_MINOR_UPGRADES = 3

            # SYSTEM_CONFIG indicates the cluster upgrade is paused by system config.
            SYSTEM_CONFIG = 4
          end
        end

        # GkeAutoUpgradeConfig is the configuration for GKE auto upgrades.
        # @!attribute [rw] patch_mode
        #   @return [::Google::Cloud::Container::V1::GkeAutoUpgradeConfig::PatchMode]
        #     PatchMode specifies how auto upgrade patch builds should be
        #     selected.
        class GkeAutoUpgradeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # PatchMode specifies how auto upgrade patch builds should be
          # selected.
          module PatchMode
            # PATCH_MODE_UNSPECIFIED defaults to using the upgrade target from the
            # channel's patch upgrade targets as the upgrade target for the
            # version.
            PATCH_MODE_UNSPECIFIED = 0

            # ACCELERATED denotes that the latest patch build in the channel should be
            # used as the upgrade target for the version.
            ACCELERATED = 1
          end
        end

        # NetworkTierConfig contains network tier information.
        # @!attribute [rw] network_tier
        #   @return [::Google::Cloud::Container::V1::NetworkTierConfig::NetworkTier]
        #     Network tier configuration.
        class NetworkTierConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Network tier configuration.
          module NetworkTier
            # By default, use project-level configuration. When unspecified, the
            # behavior defaults to NETWORK_TIER_DEFAULT. For cluster updates, this
            # implies no action (no-op).
            NETWORK_TIER_UNSPECIFIED = 0

            # Default network tier. Use project-level configuration. User can specify
            # this value, meaning they want to keep the same behaviour as before
            # cluster level network tier configuration is introduced. This field
            # ensures backward compatibility for the network tier of cluster resources,
            # such as node pools and load balancers, for their external IP addresses.
            NETWORK_TIER_DEFAULT = 1

            # Premium network tier.
            NETWORK_TIER_PREMIUM = 2

            # Standard network tier.
            NETWORK_TIER_STANDARD = 3
          end
        end

        # PrivateIPv6GoogleAccess controls whether and how the pods can communicate
        # with Google Services through gRPC over IPv6.
        module PrivateIPv6GoogleAccess
          # Default value. Same as DISABLED
          PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED = 0

          # No private access to or from Google Services
          PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED = 1

          # Enables private IPv6 access to Google Services from GKE
          PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE = 2

          # Enables private IPv6 access to and from Google Services
          PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL = 3
        end

        # UpgradeResourceType is the resource type that is upgrading. It is used
        # in upgrade notifications.
        module UpgradeResourceType
          # Default value. This shouldn't be used.
          UPGRADE_RESOURCE_TYPE_UNSPECIFIED = 0

          # Master / control plane
          MASTER = 1

          # Node pool
          NODE_POOL = 2
        end

        # The datapath provider selects the implementation of the Kubernetes networking
        # model for service resolution and network policy enforcement.
        module DatapathProvider
          # Default value.
          DATAPATH_PROVIDER_UNSPECIFIED = 0

          # Use the IPTables implementation based on kube-proxy.
          LEGACY_DATAPATH = 1

          # Use the eBPF based GKE Dataplane V2 with additional features. See the [GKE
          # Dataplane V2
          # documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/dataplane-v2)
          # for more.
          ADVANCED_DATAPATH = 2
        end

        # Strategy used for node pool update.
        module NodePoolUpdateStrategy
          # Default value if unset. GKE internally defaults the update strategy to
          # SURGE for unspecified strategies.
          NODE_POOL_UPDATE_STRATEGY_UNSPECIFIED = 0

          # blue-green upgrade.
          BLUE_GREEN = 2

          # SURGE is the traditional way of upgrade a node pool.
          # max_surge and max_unavailable determines the level of upgrade parallelism.
          SURGE = 3
        end

        # Possible values for IP stack type
        module StackType
          # Default value, will be defaulted as IPV4 only
          STACK_TYPE_UNSPECIFIED = 0

          # Cluster is IPV4 only
          IPV4 = 1

          # Cluster can use both IPv4 and IPv6
          IPV4_IPV6 = 2
        end

        # Possible values for IPv6 access type
        module IPv6AccessType
          # Default value, will be defaulted as type external.
          IPV6_ACCESS_TYPE_UNSPECIFIED = 0

          # Access type internal (all v6 addresses are internal IPs)
          INTERNAL = 1

          # Access type external (all v6 addresses are external IPs)
          EXTERNAL = 2
        end

        # Options for in-transit encryption.
        module InTransitEncryptionConfig
          # Unspecified, will be inferred as default -
          # IN_TRANSIT_ENCRYPTION_UNSPECIFIED.
          IN_TRANSIT_ENCRYPTION_CONFIG_UNSPECIFIED = 0

          # In-transit encryption is disabled.
          IN_TRANSIT_ENCRYPTION_DISABLED = 1

          # Data in-transit is encrypted using inter-node transparent encryption.
          IN_TRANSIT_ENCRYPTION_INTER_NODE_TRANSPARENT = 2
        end
      end
    end
  end
end
