# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/container/v1/cluster_service.proto for package 'Google.Cloud.Container.V1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/container/v1/cluster_service_pb'

module Google
  module Cloud
    module Container
      module V1
        module ClusterManager
          # Google Kubernetes Engine Cluster Manager v1
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.container.v1.ClusterManager'

            # Lists all clusters owned by a project in either the specified zone or all
            # zones.
            rpc :ListClusters, ::Google::Cloud::Container::V1::ListClustersRequest, ::Google::Cloud::Container::V1::ListClustersResponse
            # Gets the details of a specific cluster.
            rpc :GetCluster, ::Google::Cloud::Container::V1::GetClusterRequest, ::Google::Cloud::Container::V1::Cluster
            # Creates a cluster, consisting of the specified number and type of Google
            # Compute Engine instances.
            #
            # By default, the cluster is created in the project's
            # [default
            # network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks).
            #
            # One firewall is added for the cluster. After cluster creation,
            # the kubelet creates routes for each node to allow the containers
            # on that node to communicate with all other instances in the
            # cluster.
            #
            # Finally, an entry is added to the project's global metadata indicating
            # which CIDR range the cluster is using.
            rpc :CreateCluster, ::Google::Cloud::Container::V1::CreateClusterRequest, ::Google::Cloud::Container::V1::Operation
            # Updates the settings of a specific cluster.
            rpc :UpdateCluster, ::Google::Cloud::Container::V1::UpdateClusterRequest, ::Google::Cloud::Container::V1::Operation
            # Updates the version and/or image type for the specified node pool.
            rpc :UpdateNodePool, ::Google::Cloud::Container::V1::UpdateNodePoolRequest, ::Google::Cloud::Container::V1::Operation
            # Sets the autoscaling settings for the specified node pool.
            rpc :SetNodePoolAutoscaling, ::Google::Cloud::Container::V1::SetNodePoolAutoscalingRequest, ::Google::Cloud::Container::V1::Operation
            # Sets the logging service for a specific cluster.
            rpc :SetLoggingService, ::Google::Cloud::Container::V1::SetLoggingServiceRequest, ::Google::Cloud::Container::V1::Operation
            # Sets the monitoring service for a specific cluster.
            rpc :SetMonitoringService, ::Google::Cloud::Container::V1::SetMonitoringServiceRequest, ::Google::Cloud::Container::V1::Operation
            # Sets the addons for a specific cluster.
            rpc :SetAddonsConfig, ::Google::Cloud::Container::V1::SetAddonsConfigRequest, ::Google::Cloud::Container::V1::Operation
            # Sets the locations for a specific cluster.
            # Deprecated. Use
            # [projects.locations.clusters.update](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/update)
            # instead.
            rpc :SetLocations, ::Google::Cloud::Container::V1::SetLocationsRequest, ::Google::Cloud::Container::V1::Operation
            # Updates the master for a specific cluster.
            rpc :UpdateMaster, ::Google::Cloud::Container::V1::UpdateMasterRequest, ::Google::Cloud::Container::V1::Operation
            # Sets master auth materials. Currently supports changing the admin password
            # or a specific cluster, either via password generation or explicitly setting
            # the password.
            rpc :SetMasterAuth, ::Google::Cloud::Container::V1::SetMasterAuthRequest, ::Google::Cloud::Container::V1::Operation
            # Deletes the cluster, including the Kubernetes endpoint and all worker
            # nodes.
            #
            # Firewalls and routes that were configured during cluster creation
            # are also deleted.
            #
            # Other Google Compute Engine resources that might be in use by the cluster,
            # such as load balancer resources, are not deleted if they weren't present
            # when the cluster was initially created.
            rpc :DeleteCluster, ::Google::Cloud::Container::V1::DeleteClusterRequest, ::Google::Cloud::Container::V1::Operation
            # Lists all operations in a project in a specific zone or all zones.
            rpc :ListOperations, ::Google::Cloud::Container::V1::ListOperationsRequest, ::Google::Cloud::Container::V1::ListOperationsResponse
            # Gets the specified operation.
            rpc :GetOperation, ::Google::Cloud::Container::V1::GetOperationRequest, ::Google::Cloud::Container::V1::Operation
            # Cancels the specified operation.
            rpc :CancelOperation, ::Google::Cloud::Container::V1::CancelOperationRequest, ::Google::Protobuf::Empty
            # Returns configuration info about the Google Kubernetes Engine service.
            rpc :GetServerConfig, ::Google::Cloud::Container::V1::GetServerConfigRequest, ::Google::Cloud::Container::V1::ServerConfig
            # Gets the public component of the cluster signing keys in
            # JSON Web Key format.
            rpc :GetJSONWebKeys, ::Google::Cloud::Container::V1::GetJSONWebKeysRequest, ::Google::Cloud::Container::V1::GetJSONWebKeysResponse
            # Lists the node pools for a cluster.
            rpc :ListNodePools, ::Google::Cloud::Container::V1::ListNodePoolsRequest, ::Google::Cloud::Container::V1::ListNodePoolsResponse
            # Retrieves the requested node pool.
            rpc :GetNodePool, ::Google::Cloud::Container::V1::GetNodePoolRequest, ::Google::Cloud::Container::V1::NodePool
            # Creates a node pool for a cluster.
            rpc :CreateNodePool, ::Google::Cloud::Container::V1::CreateNodePoolRequest, ::Google::Cloud::Container::V1::Operation
            # Deletes a node pool from a cluster.
            rpc :DeleteNodePool, ::Google::Cloud::Container::V1::DeleteNodePoolRequest, ::Google::Cloud::Container::V1::Operation
            # CompleteNodePoolUpgrade will signal an on-going node pool upgrade to
            # complete.
            rpc :CompleteNodePoolUpgrade, ::Google::Cloud::Container::V1::CompleteNodePoolUpgradeRequest, ::Google::Protobuf::Empty
            # Rolls back a previously Aborted or Failed NodePool upgrade.
            # This makes no changes if the last upgrade successfully completed.
            rpc :RollbackNodePoolUpgrade, ::Google::Cloud::Container::V1::RollbackNodePoolUpgradeRequest, ::Google::Cloud::Container::V1::Operation
            # Sets the NodeManagement options for a node pool.
            rpc :SetNodePoolManagement, ::Google::Cloud::Container::V1::SetNodePoolManagementRequest, ::Google::Cloud::Container::V1::Operation
            # Sets labels on a cluster.
            rpc :SetLabels, ::Google::Cloud::Container::V1::SetLabelsRequest, ::Google::Cloud::Container::V1::Operation
            # Enables or disables the ABAC authorization mechanism on a cluster.
            rpc :SetLegacyAbac, ::Google::Cloud::Container::V1::SetLegacyAbacRequest, ::Google::Cloud::Container::V1::Operation
            # Starts master IP rotation.
            rpc :StartIPRotation, ::Google::Cloud::Container::V1::StartIPRotationRequest, ::Google::Cloud::Container::V1::Operation
            # Completes master IP rotation.
            rpc :CompleteIPRotation, ::Google::Cloud::Container::V1::CompleteIPRotationRequest, ::Google::Cloud::Container::V1::Operation
            # Sets the size for a specific node pool. The new size will be used for all
            # replicas, including future replicas created by modifying
            # [NodePool.locations][google.container.v1.NodePool.locations].
            rpc :SetNodePoolSize, ::Google::Cloud::Container::V1::SetNodePoolSizeRequest, ::Google::Cloud::Container::V1::Operation
            # Enables or disables Network Policy for a cluster.
            rpc :SetNetworkPolicy, ::Google::Cloud::Container::V1::SetNetworkPolicyRequest, ::Google::Cloud::Container::V1::Operation
            # Sets the maintenance policy for a cluster.
            rpc :SetMaintenancePolicy, ::Google::Cloud::Container::V1::SetMaintenancePolicyRequest, ::Google::Cloud::Container::V1::Operation
            # Lists subnetworks that are usable for creating clusters in a project.
            rpc :ListUsableSubnetworks, ::Google::Cloud::Container::V1::ListUsableSubnetworksRequest, ::Google::Cloud::Container::V1::ListUsableSubnetworksResponse
            # Checks the cluster compatibility with Autopilot mode, and returns a list of
            # compatibility issues.
            rpc :CheckAutopilotCompatibility, ::Google::Cloud::Container::V1::CheckAutopilotCompatibilityRequest, ::Google::Cloud::Container::V1::CheckAutopilotCompatibilityResponse
            # Fetch upgrade information of a specific cluster.
            rpc :FetchClusterUpgradeInfo, ::Google::Cloud::Container::V1::FetchClusterUpgradeInfoRequest, ::Google::Cloud::Container::V1::ClusterUpgradeInfo
            # Fetch upgrade information of a specific nodepool.
            rpc :FetchNodePoolUpgradeInfo, ::Google::Cloud::Container::V1::FetchNodePoolUpgradeInfoRequest, ::Google::Cloud::Container::V1::NodePoolUpgradeInfo
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
