# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/container/v1/cluster_service_pb"

module Google
  module Cloud
    module Container
      module V1
        module ClusterManager
          ##
          # Client for the ClusterManager service.
          #
          # Google Kubernetes Engine Cluster Manager v1
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "container.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :cluster_manager_stub

            ##
            # Configure the ClusterManager Client class.
            #
            # See {::Google::Cloud::Container::V1::ClusterManager::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ClusterManager clients
            #   ::Google::Cloud::Container::V1::ClusterManager::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Container", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_clusters.timeout = 20.0
                default_config.rpcs.list_clusters.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_cluster.timeout = 20.0
                default_config.rpcs.get_cluster.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.create_cluster.timeout = 45.0

                default_config.rpcs.update_cluster.timeout = 45.0

                default_config.rpcs.update_node_pool.timeout = 45.0

                default_config.rpcs.set_node_pool_autoscaling.timeout = 45.0

                default_config.rpcs.set_logging_service.timeout = 45.0

                default_config.rpcs.set_monitoring_service.timeout = 45.0

                default_config.rpcs.set_addons_config.timeout = 45.0

                default_config.rpcs.set_locations.timeout = 45.0

                default_config.rpcs.update_master.timeout = 45.0

                default_config.rpcs.set_master_auth.timeout = 45.0

                default_config.rpcs.delete_cluster.timeout = 20.0
                default_config.rpcs.delete_cluster.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_operations.timeout = 20.0
                default_config.rpcs.list_operations.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_operation.timeout = 20.0
                default_config.rpcs.get_operation.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.cancel_operation.timeout = 45.0

                default_config.rpcs.get_server_config.timeout = 20.0
                default_config.rpcs.get_server_config.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_node_pools.timeout = 20.0
                default_config.rpcs.list_node_pools.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_node_pool.timeout = 20.0
                default_config.rpcs.get_node_pool.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.create_node_pool.timeout = 45.0

                default_config.rpcs.delete_node_pool.timeout = 20.0
                default_config.rpcs.delete_node_pool.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.rollback_node_pool_upgrade.timeout = 45.0

                default_config.rpcs.set_node_pool_management.timeout = 45.0

                default_config.rpcs.set_labels.timeout = 45.0

                default_config.rpcs.set_legacy_abac.timeout = 45.0

                default_config.rpcs.start_ip_rotation.timeout = 45.0

                default_config.rpcs.complete_ip_rotation.timeout = 45.0

                default_config.rpcs.set_node_pool_size.timeout = 45.0

                default_config.rpcs.set_network_policy.timeout = 45.0

                default_config.rpcs.set_maintenance_policy.timeout = 45.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ClusterManager Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Container::V1::ClusterManager::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @cluster_manager_stub.universe_domain
            end

            ##
            # Create a new ClusterManager client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Container::V1::ClusterManager::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ClusterManager client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/container/v1/cluster_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @cluster_manager_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Container::V1::ClusterManager::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @cluster_manager_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @cluster_manager_stub.logger
            end

            # Service calls

            ##
            # Lists all clusters owned by a project in either the specified zone or all
            # zones.
            #
            # @overload list_clusters(request, options = nil)
            #   Pass arguments to `list_clusters` via a request object, either of type
            #   {::Google::Cloud::Container::V1::ListClustersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::ListClustersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_clusters(project_id: nil, zone: nil, parent: nil)
            #   Pass arguments to `list_clusters` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the parent field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides, or "-" for all zones. This field has been
            #     deprecated and replaced by the parent field.
            #   @param parent [::String]
            #     The parent (project and location) where the clusters will be listed.
            #     Specified in the format `projects/*/locations/*`.
            #     Location "-" matches all zones and all regions.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::ListClustersResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::ListClustersResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::ListClustersRequest.new
            #
            #   # Call the list_clusters method.
            #   result = client.list_clusters request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::ListClustersResponse.
            #   p result
            #
            def list_clusters request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::ListClustersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_clusters.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_clusters.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_clusters.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :list_clusters, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a specific cluster.
            #
            # @overload get_cluster(request, options = nil)
            #   Pass arguments to `get_cluster` via a request object, either of type
            #   {::Google::Cloud::Container::V1::GetClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::GetClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_cluster(project_id: nil, zone: nil, cluster_id: nil, name: nil)
            #   Pass arguments to `get_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to retrieve.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to retrieve.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Cluster]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Cluster]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::GetClusterRequest.new
            #
            #   # Call the get_cluster method.
            #   result = client.get_cluster request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Cluster.
            #   p result
            #
            def get_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::GetClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :get_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a cluster, consisting of the specified number and type of Google
            # Compute Engine instances.
            #
            # By default, the cluster is created in the project's
            # [default
            # network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks).
            #
            # One firewall is added for the cluster. After cluster creation,
            # the kubelet creates routes for each node to allow the containers
            # on that node to communicate with all other instances in the
            # cluster.
            #
            # Finally, an entry is added to the project's global metadata indicating
            # which CIDR range the cluster is using.
            #
            # @overload create_cluster(request, options = nil)
            #   Pass arguments to `create_cluster` via a request object, either of type
            #   {::Google::Cloud::Container::V1::CreateClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::CreateClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_cluster(project_id: nil, zone: nil, cluster: nil, parent: nil)
            #   Pass arguments to `create_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the parent field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the parent field.
            #   @param cluster [::Google::Cloud::Container::V1::Cluster, ::Hash]
            #     Required. A [cluster
            #     resource](https://cloud.google.com/container-engine/reference/rest/v1/projects.locations.clusters)
            #   @param parent [::String]
            #     The parent (project and location) where the cluster will be created.
            #     Specified in the format `projects/*/locations/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::CreateClusterRequest.new
            #
            #   # Call the create_cluster method.
            #   result = client.create_cluster request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def create_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::CreateClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :create_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the settings of a specific cluster.
            #
            # @overload update_cluster(request, options = nil)
            #   Pass arguments to `update_cluster` via a request object, either of type
            #   {::Google::Cloud::Container::V1::UpdateClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::UpdateClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_cluster(project_id: nil, zone: nil, cluster_id: nil, update: nil, name: nil)
            #   Pass arguments to `update_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param update [::Google::Cloud::Container::V1::ClusterUpdate, ::Hash]
            #     Required. A description of the update.
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to update.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::UpdateClusterRequest.new
            #
            #   # Call the update_cluster method.
            #   result = client.update_cluster request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def update_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::UpdateClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :update_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the version and/or image type for the specified node pool.
            #
            # @overload update_node_pool(request, options = nil)
            #   Pass arguments to `update_node_pool` via a request object, either of type
            #   {::Google::Cloud::Container::V1::UpdateNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::UpdateNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_node_pool(project_id: nil, zone: nil, cluster_id: nil, node_pool_id: nil, node_version: nil, image_type: nil, name: nil, locations: nil, workload_metadata_config: nil, upgrade_settings: nil, tags: nil, taints: nil, labels: nil, linux_node_config: nil, kubelet_config: nil, node_network_config: nil, gcfs_config: nil, confidential_nodes: nil, gvnic: nil, etag: nil, fast_socket: nil, logging_config: nil, resource_labels: nil, windows_node_config: nil, accelerators: nil, machine_type: nil, disk_type: nil, disk_size_gb: nil, resource_manager_tags: nil, containerd_config: nil, queued_provisioning: nil, storage_pools: nil, max_run_duration: nil, flex_start: nil, boot_disk: nil)
            #   Pass arguments to `update_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_pool_id [::String]
            #     Deprecated. The name of the node pool to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_version [::String]
            #     Required. The Kubernetes version to change the nodes to (typically an
            #     upgrade).
            #
            #     Users may specify either explicit versions offered by Kubernetes Engine or
            #     version aliases, which have the following behavior:
            #
            #     - "latest": picks the highest valid Kubernetes version
            #     - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
            #     - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
            #     - "1.X.Y-gke.N": picks an explicit Kubernetes version
            #     - "-": picks the Kubernetes master version
            #   @param image_type [::String]
            #     Required. The desired image type for the node pool. Please see
            #     https://cloud.google.com/kubernetes-engine/docs/concepts/node-images
            #     for available image types.
            #   @param name [::String]
            #     The name (project, location, cluster, node pool) of the node pool to
            #     update. Specified in the format
            #     `projects/*/locations/*/clusters/*/nodePools/*`.
            #   @param locations [::Array<::String>]
            #     The desired list of Google Compute Engine
            #     [zones](https://cloud.google.com/compute/docs/zones#available)
            #     in which the node pool's nodes should be located. Changing the locations
            #     for a node pool will result in nodes being either created or removed from
            #     the node pool, depending on whether locations are being added or removed.
            #
            #     Warning: It is recommended to update node pool locations in a standalone
            #     API call. Do not combine a location update with changes to other fields
            #     (such as `tags`, `labels`, `taints`, etc.) in the same request.
            #     Otherwise, the API performs a structural modification where changes to
            #     other fields will only apply to newly created nodes and will not be
            #     applied to existing nodes in the node pool. To ensure all nodes are updated
            #     consistently, use a separate API call for location changes.
            #   @param workload_metadata_config [::Google::Cloud::Container::V1::WorkloadMetadataConfig, ::Hash]
            #     The desired workload metadata config for the node pool.
            #   @param upgrade_settings [::Google::Cloud::Container::V1::NodePool::UpgradeSettings, ::Hash]
            #     Upgrade settings control disruption and speed of the upgrade.
            #   @param tags [::Google::Cloud::Container::V1::NetworkTags, ::Hash]
            #     The desired network tags to be applied to all nodes in the node pool.
            #     If this field is not present, the tags will not be changed. Otherwise,
            #     the existing network tags will be *replaced* with the provided tags.
            #   @param taints [::Google::Cloud::Container::V1::NodeTaints, ::Hash]
            #     The desired node taints to be applied to all nodes in the node pool.
            #     If this field is not present, the taints will not be changed. Otherwise,
            #     the existing node taints will be *replaced* with the provided taints.
            #   @param labels [::Google::Cloud::Container::V1::NodeLabels, ::Hash]
            #     The desired node labels to be applied to all nodes in the node pool.
            #     If this field is not present, the labels will not be changed. Otherwise,
            #     the existing node labels will be *replaced* with the provided labels.
            #   @param linux_node_config [::Google::Cloud::Container::V1::LinuxNodeConfig, ::Hash]
            #     Parameters that can be configured on Linux nodes.
            #   @param kubelet_config [::Google::Cloud::Container::V1::NodeKubeletConfig, ::Hash]
            #     Node kubelet configs.
            #   @param node_network_config [::Google::Cloud::Container::V1::NodeNetworkConfig, ::Hash]
            #     Node network config.
            #   @param gcfs_config [::Google::Cloud::Container::V1::GcfsConfig, ::Hash]
            #     GCFS config.
            #   @param confidential_nodes [::Google::Cloud::Container::V1::ConfidentialNodes, ::Hash]
            #     Confidential nodes config.
            #     All the nodes in the node pool will be Confidential VM once enabled.
            #   @param gvnic [::Google::Cloud::Container::V1::VirtualNIC, ::Hash]
            #     Enable or disable gvnic on the node pool.
            #   @param etag [::String]
            #     The current etag of the node pool.
            #     If an etag is provided and does not match the current etag of the node
            #     pool, update will be blocked and an ABORTED error will be returned.
            #   @param fast_socket [::Google::Cloud::Container::V1::FastSocket, ::Hash]
            #     Enable or disable NCCL fast socket for the node pool.
            #   @param logging_config [::Google::Cloud::Container::V1::NodePoolLoggingConfig, ::Hash]
            #     Logging configuration.
            #   @param resource_labels [::Google::Cloud::Container::V1::ResourceLabels, ::Hash]
            #     The resource labels for the node pool to use to annotate any related
            #     Google Compute Engine resources.
            #   @param windows_node_config [::Google::Cloud::Container::V1::WindowsNodeConfig, ::Hash]
            #     Parameters that can be configured on Windows nodes.
            #   @param accelerators [::Array<::Google::Cloud::Container::V1::AcceleratorConfig, ::Hash>]
            #     A list of hardware accelerators to be attached to each node.
            #     See
            #     https://cloud.google.com/compute/docs/gpus
            #     for more information about support for GPUs.
            #   @param machine_type [::String]
            #     Optional. The desired [Google Compute Engine machine
            #     type](https://cloud.google.com/compute/docs/machine-types)
            #     for nodes in the node pool. Initiates an upgrade operation that migrates
            #     the nodes in the node pool to the specified machine type.
            #   @param disk_type [::String]
            #     Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
            #     'pd-balanced') for nodes in the node pool.
            #     Initiates an upgrade operation that migrates the nodes in the
            #     node pool to the specified disk type.
            #   @param disk_size_gb [::Integer]
            #     Optional. The desired disk size for nodes in the node pool specified in GB.
            #     The smallest allowed disk size is 10GB.
            #     Initiates an upgrade operation that migrates the nodes in the
            #     node pool to the specified disk size.
            #   @param resource_manager_tags [::Google::Cloud::Container::V1::ResourceManagerTags, ::Hash]
            #     Desired resource manager tag keys and values to be attached to the nodes
            #     for managing Compute Engine firewalls using Network Firewall Policies.
            #     Existing tags will be replaced with new values.
            #   @param containerd_config [::Google::Cloud::Container::V1::ContainerdConfig, ::Hash]
            #     The desired containerd config for nodes in the node pool.
            #     Initiates an upgrade operation that recreates the nodes with the new
            #     config.
            #   @param queued_provisioning [::Google::Cloud::Container::V1::NodePool::QueuedProvisioning, ::Hash]
            #     Specifies the configuration of queued provisioning.
            #   @param storage_pools [::Array<::String>]
            #     List of Storage Pools where boot disks are provisioned.
            #     Existing Storage Pools will be replaced with storage-pools.
            #   @param max_run_duration [::Google::Protobuf::Duration, ::Hash]
            #     The maximum duration for the nodes to exist.
            #     If unspecified, the nodes can exist indefinitely.
            #   @param flex_start [::Boolean]
            #     Flex Start flag for enabling Flex Start VM.
            #   @param boot_disk [::Google::Cloud::Container::V1::BootDisk, ::Hash]
            #     The desired boot disk config for nodes in the node pool.
            #     Initiates an upgrade operation that migrates the nodes in the
            #     node pool to the specified boot disk config.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::UpdateNodePoolRequest.new
            #
            #   # Call the update_node_pool method.
            #   result = client.update_node_pool request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def update_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::UpdateNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :update_node_pool, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the autoscaling settings for the specified node pool.
            #
            # @overload set_node_pool_autoscaling(request, options = nil)
            #   Pass arguments to `set_node_pool_autoscaling` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetNodePoolAutoscalingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetNodePoolAutoscalingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_node_pool_autoscaling(project_id: nil, zone: nil, cluster_id: nil, node_pool_id: nil, autoscaling: nil, name: nil)
            #   Pass arguments to `set_node_pool_autoscaling` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_pool_id [::String]
            #     Deprecated. The name of the node pool to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param autoscaling [::Google::Cloud::Container::V1::NodePoolAutoscaling, ::Hash]
            #     Required. Autoscaling configuration for the node pool.
            #   @param name [::String]
            #     The name (project, location, cluster, node pool) of the node pool to set
            #     autoscaler settings. Specified in the format
            #     `projects/*/locations/*/clusters/*/nodePools/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetNodePoolAutoscalingRequest.new
            #
            #   # Call the set_node_pool_autoscaling method.
            #   result = client.set_node_pool_autoscaling request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_node_pool_autoscaling request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetNodePoolAutoscalingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_node_pool_autoscaling.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_node_pool_autoscaling.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_node_pool_autoscaling.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_node_pool_autoscaling, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the logging service for a specific cluster.
            #
            # @overload set_logging_service(request, options = nil)
            #   Pass arguments to `set_logging_service` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetLoggingServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetLoggingServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_logging_service(project_id: nil, zone: nil, cluster_id: nil, logging_service: nil, name: nil)
            #   Pass arguments to `set_logging_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param logging_service [::String]
            #     Required. The logging service the cluster should use to write logs.
            #     Currently available options:
            #
            #     * `logging.googleapis.com/kubernetes` - The Cloud Logging
            #     service with a Kubernetes-native resource model
            #     * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
            #       available as of GKE 1.15).
            #     * `none` - no logs will be exported from the cluster.
            #
            #     If left as an empty string,`logging.googleapis.com/kubernetes` will be
            #     used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to set logging.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetLoggingServiceRequest.new
            #
            #   # Call the set_logging_service method.
            #   result = client.set_logging_service request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_logging_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetLoggingServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_logging_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_logging_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_logging_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_logging_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the monitoring service for a specific cluster.
            #
            # @overload set_monitoring_service(request, options = nil)
            #   Pass arguments to `set_monitoring_service` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetMonitoringServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetMonitoringServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_monitoring_service(project_id: nil, zone: nil, cluster_id: nil, monitoring_service: nil, name: nil)
            #   Pass arguments to `set_monitoring_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param monitoring_service [::String]
            #     Required. The monitoring service the cluster should use to write metrics.
            #     Currently available options:
            #
            #     * `monitoring.googleapis.com/kubernetes` - The Cloud Monitoring
            #     service with a Kubernetes-native resource model
            #     * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
            #       longer available as of GKE 1.15).
            #     * `none` - No metrics will be exported from the cluster.
            #
            #     If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
            #     used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to set monitoring.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetMonitoringServiceRequest.new
            #
            #   # Call the set_monitoring_service method.
            #   result = client.set_monitoring_service request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_monitoring_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetMonitoringServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_monitoring_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_monitoring_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_monitoring_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_monitoring_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the addons for a specific cluster.
            #
            # @overload set_addons_config(request, options = nil)
            #   Pass arguments to `set_addons_config` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetAddonsConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetAddonsConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_addons_config(project_id: nil, zone: nil, cluster_id: nil, addons_config: nil, name: nil)
            #   Pass arguments to `set_addons_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param addons_config [::Google::Cloud::Container::V1::AddonsConfig, ::Hash]
            #     Required. The desired configurations for the various addons available to
            #     run in the cluster.
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to set addons.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetAddonsConfigRequest.new
            #
            #   # Call the set_addons_config method.
            #   result = client.set_addons_config request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_addons_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetAddonsConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_addons_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_addons_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_addons_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_addons_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the locations for a specific cluster.
            # Deprecated. Use
            # [projects.locations.clusters.update](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/update)
            # instead.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload set_locations(request, options = nil)
            #   Pass arguments to `set_locations` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetLocationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetLocationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_locations(project_id: nil, zone: nil, cluster_id: nil, locations: nil, name: nil)
            #   Pass arguments to `set_locations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param locations [::Array<::String>]
            #     Required. The desired list of Google Compute Engine
            #     [zones](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster's nodes should be located. Changing the locations a
            #     cluster is in will result in nodes being either created or removed from the
            #     cluster, depending on whether locations are being added or removed.
            #
            #     This list must always include the cluster's primary zone.
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to set locations.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetLocationsRequest.new
            #
            #   # Call the set_locations method.
            #   result = client.set_locations request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_locations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetLocationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_locations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_locations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_locations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_locations, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the master for a specific cluster.
            #
            # @overload update_master(request, options = nil)
            #   Pass arguments to `update_master` via a request object, either of type
            #   {::Google::Cloud::Container::V1::UpdateMasterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::UpdateMasterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_master(project_id: nil, zone: nil, cluster_id: nil, master_version: nil, name: nil)
            #   Pass arguments to `update_master` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param master_version [::String]
            #     Required. The Kubernetes version to change the master to.
            #
            #     Users may specify either explicit versions offered by Kubernetes Engine or
            #     version aliases, which have the following behavior:
            #
            #     - "latest": picks the highest valid Kubernetes version
            #     - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
            #     - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
            #     - "1.X.Y-gke.N": picks an explicit Kubernetes version
            #     - "-": picks the default Kubernetes version
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to update.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::UpdateMasterRequest.new
            #
            #   # Call the update_master method.
            #   result = client.update_master request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def update_master request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::UpdateMasterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_master.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_master.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_master.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :update_master, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets master auth materials. Currently supports changing the admin password
            # or a specific cluster, either via password generation or explicitly setting
            # the password.
            #
            # @overload set_master_auth(request, options = nil)
            #   Pass arguments to `set_master_auth` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetMasterAuthRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetMasterAuthRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_master_auth(project_id: nil, zone: nil, cluster_id: nil, action: nil, update: nil, name: nil)
            #   Pass arguments to `set_master_auth` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to upgrade.
            #     This field has been deprecated and replaced by the name field.
            #   @param action [::Google::Cloud::Container::V1::SetMasterAuthRequest::Action]
            #     Required. The exact form of action to be taken on the master auth.
            #   @param update [::Google::Cloud::Container::V1::MasterAuth, ::Hash]
            #     Required. A description of the update.
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to set auth.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetMasterAuthRequest.new
            #
            #   # Call the set_master_auth method.
            #   result = client.set_master_auth request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_master_auth request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetMasterAuthRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_master_auth.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_master_auth.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_master_auth.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_master_auth, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the cluster, including the Kubernetes endpoint and all worker
            # nodes.
            #
            # Firewalls and routes that were configured during cluster creation
            # are also deleted.
            #
            # Other Google Compute Engine resources that might be in use by the cluster,
            # such as load balancer resources, are not deleted if they weren't present
            # when the cluster was initially created.
            #
            # @overload delete_cluster(request, options = nil)
            #   Pass arguments to `delete_cluster` via a request object, either of type
            #   {::Google::Cloud::Container::V1::DeleteClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::DeleteClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_cluster(project_id: nil, zone: nil, cluster_id: nil, name: nil)
            #   Pass arguments to `delete_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to delete.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to delete.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::DeleteClusterRequest.new
            #
            #   # Call the delete_cluster method.
            #   result = client.delete_cluster request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def delete_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::DeleteClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :delete_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all operations in a project in a specific zone or all zones.
            #
            # @overload list_operations(request, options = nil)
            #   Pass arguments to `list_operations` via a request object, either of type
            #   {::Google::Cloud::Container::V1::ListOperationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::ListOperationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_operations(project_id: nil, zone: nil, parent: nil)
            #   Pass arguments to `list_operations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the parent field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     to return operations for, or `-` for all zones. This field has been
            #     deprecated and replaced by the parent field.
            #   @param parent [::String]
            #     The parent (project and location) where the operations will be listed.
            #     Specified in the format `projects/*/locations/*`.
            #     Location "-" matches all zones and all regions.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::ListOperationsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::ListOperationsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::ListOperationsRequest.new
            #
            #   # Call the list_operations method.
            #   result = client.list_operations request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::ListOperationsResponse.
            #   p result
            #
            def list_operations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::ListOperationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_operations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_operations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_operations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :list_operations, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the specified operation.
            #
            # @overload get_operation(request, options = nil)
            #   Pass arguments to `get_operation` via a request object, either of type
            #   {::Google::Cloud::Container::V1::GetOperationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::GetOperationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_operation(project_id: nil, zone: nil, operation_id: nil, name: nil)
            #   Pass arguments to `get_operation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param operation_id [::String]
            #     Deprecated. The server-assigned `name` of the operation.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, operation id) of the operation to get.
            #     Specified in the format `projects/*/locations/*/operations/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::GetOperationRequest.new
            #
            #   # Call the get_operation method.
            #   result = client.get_operation request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def get_operation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::GetOperationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_operation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_operation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_operation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :get_operation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels the specified operation.
            #
            # @overload cancel_operation(request, options = nil)
            #   Pass arguments to `cancel_operation` via a request object, either of type
            #   {::Google::Cloud::Container::V1::CancelOperationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::CancelOperationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_operation(project_id: nil, zone: nil, operation_id: nil, name: nil)
            #   Pass arguments to `cancel_operation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the operation resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param operation_id [::String]
            #     Deprecated. The server-assigned `name` of the operation.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, operation id) of the operation to cancel.
            #     Specified in the format `projects/*/locations/*/operations/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::CancelOperationRequest.new
            #
            #   # Call the cancel_operation method.
            #   result = client.cancel_operation request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_operation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::CancelOperationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_operation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_operation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_operation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :cancel_operation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns configuration info about the Google Kubernetes Engine service.
            #
            # @overload get_server_config(request, options = nil)
            #   Pass arguments to `get_server_config` via a request object, either of type
            #   {::Google::Cloud::Container::V1::GetServerConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::GetServerConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_server_config(project_id: nil, zone: nil, name: nil)
            #   Pass arguments to `get_server_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     to return operations for. This field has been deprecated and replaced by
            #     the name field.
            #   @param name [::String]
            #     The name (project and location) of the server config to get,
            #     specified in the format `projects/*/locations/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::ServerConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::ServerConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::GetServerConfigRequest.new
            #
            #   # Call the get_server_config method.
            #   result = client.get_server_config request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::ServerConfig.
            #   p result
            #
            def get_server_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::GetServerConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_server_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_server_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_server_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :get_server_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the public component of the cluster signing keys in
            # JSON Web Key format.
            #
            # @overload get_json_web_keys(request, options = nil)
            #   Pass arguments to `get_json_web_keys` via a request object, either of type
            #   {::Google::Cloud::Container::V1::GetJSONWebKeysRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::GetJSONWebKeysRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_json_web_keys(parent: nil)
            #   Pass arguments to `get_json_web_keys` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     The cluster (project, location, cluster name) to get keys for. Specified in
            #     the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::GetJSONWebKeysResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::GetJSONWebKeysResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::GetJSONWebKeysRequest.new
            #
            #   # Call the get_json_web_keys method.
            #   result = client.get_json_web_keys request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::GetJSONWebKeysResponse.
            #   p result
            #
            def get_json_web_keys request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::GetJSONWebKeysRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_json_web_keys.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_json_web_keys.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_json_web_keys.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :get_json_web_keys, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the node pools for a cluster.
            #
            # @overload list_node_pools(request, options = nil)
            #   Pass arguments to `list_node_pools` via a request object, either of type
            #   {::Google::Cloud::Container::V1::ListNodePoolsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::ListNodePoolsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_node_pools(project_id: nil, zone: nil, cluster_id: nil, parent: nil)
            #   Pass arguments to `list_node_pools` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the parent field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the parent field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster.
            #     This field has been deprecated and replaced by the parent field.
            #   @param parent [::String]
            #     The parent (project, location, cluster name) where the node pools will be
            #     listed. Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::ListNodePoolsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::ListNodePoolsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::ListNodePoolsRequest.new
            #
            #   # Call the list_node_pools method.
            #   result = client.list_node_pools request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::ListNodePoolsResponse.
            #   p result
            #
            def list_node_pools request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::ListNodePoolsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_node_pools.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_node_pools.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_node_pools.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :list_node_pools, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves the requested node pool.
            #
            # @overload get_node_pool(request, options = nil)
            #   Pass arguments to `get_node_pool` via a request object, either of type
            #   {::Google::Cloud::Container::V1::GetNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::GetNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_node_pool(project_id: nil, zone: nil, cluster_id: nil, node_pool_id: nil, name: nil)
            #   Pass arguments to `get_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_pool_id [::String]
            #     Deprecated. The name of the node pool.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, cluster, node pool id) of the node pool to
            #     get. Specified in the format
            #     `projects/*/locations/*/clusters/*/nodePools/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::NodePool]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::NodePool]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::GetNodePoolRequest.new
            #
            #   # Call the get_node_pool method.
            #   result = client.get_node_pool request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::NodePool.
            #   p result
            #
            def get_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::GetNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :get_node_pool, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a node pool for a cluster.
            #
            # @overload create_node_pool(request, options = nil)
            #   Pass arguments to `create_node_pool` via a request object, either of type
            #   {::Google::Cloud::Container::V1::CreateNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::CreateNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_node_pool(project_id: nil, zone: nil, cluster_id: nil, node_pool: nil, parent: nil)
            #   Pass arguments to `create_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the parent field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the parent field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster.
            #     This field has been deprecated and replaced by the parent field.
            #   @param node_pool [::Google::Cloud::Container::V1::NodePool, ::Hash]
            #     Required. The node pool to create.
            #   @param parent [::String]
            #     The parent (project, location, cluster name) where the node pool will be
            #     created. Specified in the format
            #     `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::CreateNodePoolRequest.new
            #
            #   # Call the create_node_pool method.
            #   result = client.create_node_pool request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def create_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::CreateNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :create_node_pool, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a node pool from a cluster.
            #
            # @overload delete_node_pool(request, options = nil)
            #   Pass arguments to `delete_node_pool` via a request object, either of type
            #   {::Google::Cloud::Container::V1::DeleteNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::DeleteNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_node_pool(project_id: nil, zone: nil, cluster_id: nil, node_pool_id: nil, name: nil)
            #   Pass arguments to `delete_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_pool_id [::String]
            #     Deprecated. The name of the node pool to delete.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, cluster, node pool id) of the node pool to
            #     delete. Specified in the format
            #     `projects/*/locations/*/clusters/*/nodePools/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::DeleteNodePoolRequest.new
            #
            #   # Call the delete_node_pool method.
            #   result = client.delete_node_pool request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def delete_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::DeleteNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :delete_node_pool, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # CompleteNodePoolUpgrade will signal an on-going node pool upgrade to
            # complete.
            #
            # @overload complete_node_pool_upgrade(request, options = nil)
            #   Pass arguments to `complete_node_pool_upgrade` via a request object, either of type
            #   {::Google::Cloud::Container::V1::CompleteNodePoolUpgradeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::CompleteNodePoolUpgradeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload complete_node_pool_upgrade(name: nil)
            #   Pass arguments to `complete_node_pool_upgrade` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     The name (project, location, cluster, node pool id) of the node pool to
            #     complete upgrade.
            #     Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::CompleteNodePoolUpgradeRequest.new
            #
            #   # Call the complete_node_pool_upgrade method.
            #   result = client.complete_node_pool_upgrade request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def complete_node_pool_upgrade request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::CompleteNodePoolUpgradeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.complete_node_pool_upgrade.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.complete_node_pool_upgrade.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.complete_node_pool_upgrade.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :complete_node_pool_upgrade, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Rolls back a previously Aborted or Failed NodePool upgrade.
            # This makes no changes if the last upgrade successfully completed.
            #
            # @overload rollback_node_pool_upgrade(request, options = nil)
            #   Pass arguments to `rollback_node_pool_upgrade` via a request object, either of type
            #   {::Google::Cloud::Container::V1::RollbackNodePoolUpgradeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::RollbackNodePoolUpgradeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rollback_node_pool_upgrade(project_id: nil, zone: nil, cluster_id: nil, node_pool_id: nil, name: nil, respect_pdb: nil)
            #   Pass arguments to `rollback_node_pool_upgrade` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to rollback.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_pool_id [::String]
            #     Deprecated. The name of the node pool to rollback.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, cluster, node pool id) of the node poll to
            #     rollback upgrade.
            #     Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
            #   @param respect_pdb [::Boolean]
            #     Option for rollback to ignore the PodDisruptionBudget.
            #     Default value is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::RollbackNodePoolUpgradeRequest.new
            #
            #   # Call the rollback_node_pool_upgrade method.
            #   result = client.rollback_node_pool_upgrade request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def rollback_node_pool_upgrade request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::RollbackNodePoolUpgradeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rollback_node_pool_upgrade.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rollback_node_pool_upgrade.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rollback_node_pool_upgrade.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :rollback_node_pool_upgrade, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the NodeManagement options for a node pool.
            #
            # @overload set_node_pool_management(request, options = nil)
            #   Pass arguments to `set_node_pool_management` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetNodePoolManagementRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetNodePoolManagementRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_node_pool_management(project_id: nil, zone: nil, cluster_id: nil, node_pool_id: nil, management: nil, name: nil)
            #   Pass arguments to `set_node_pool_management` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to update.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_pool_id [::String]
            #     Deprecated. The name of the node pool to update.
            #     This field has been deprecated and replaced by the name field.
            #   @param management [::Google::Cloud::Container::V1::NodeManagement, ::Hash]
            #     Required. NodeManagement configuration for the node pool.
            #   @param name [::String]
            #     The name (project, location, cluster, node pool id) of the node pool to set
            #     management properties. Specified in the format
            #     `projects/*/locations/*/clusters/*/nodePools/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetNodePoolManagementRequest.new
            #
            #   # Call the set_node_pool_management method.
            #   result = client.set_node_pool_management request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_node_pool_management request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetNodePoolManagementRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_node_pool_management.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_node_pool_management.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_node_pool_management.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_node_pool_management, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets labels on a cluster.
            #
            # @overload set_labels(request, options = nil)
            #   Pass arguments to `set_labels` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetLabelsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetLabelsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_labels(project_id: nil, zone: nil, cluster_id: nil, resource_labels: nil, label_fingerprint: nil, name: nil)
            #   Pass arguments to `set_labels` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster.
            #     This field has been deprecated and replaced by the name field.
            #   @param resource_labels [::Hash{::String => ::String}]
            #     Required. The labels to set for that cluster.
            #   @param label_fingerprint [::String]
            #     Required. The fingerprint of the previous set of labels for this resource,
            #     used to detect conflicts. The fingerprint is initially generated by
            #     Kubernetes Engine and changes after every request to modify or update
            #     labels. You must always provide an up-to-date fingerprint hash when
            #     updating or changing labels. Make a `get()` request to the
            #     resource to get the latest fingerprint.
            #   @param name [::String]
            #     The name (project, location, cluster name) of the cluster to set labels.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetLabelsRequest.new
            #
            #   # Call the set_labels method.
            #   result = client.set_labels request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_labels request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetLabelsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_labels.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_labels.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_labels.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_labels, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Enables or disables the ABAC authorization mechanism on a cluster.
            #
            # @overload set_legacy_abac(request, options = nil)
            #   Pass arguments to `set_legacy_abac` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetLegacyAbacRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetLegacyAbacRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_legacy_abac(project_id: nil, zone: nil, cluster_id: nil, enabled: nil, name: nil)
            #   Pass arguments to `set_legacy_abac` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to update.
            #     This field has been deprecated and replaced by the name field.
            #   @param enabled [::Boolean]
            #     Required. Whether ABAC authorization will be enabled in the cluster.
            #   @param name [::String]
            #     The name (project, location, cluster name) of the cluster to set legacy
            #     abac. Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetLegacyAbacRequest.new
            #
            #   # Call the set_legacy_abac method.
            #   result = client.set_legacy_abac request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_legacy_abac request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetLegacyAbacRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_legacy_abac.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_legacy_abac.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_legacy_abac.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_legacy_abac, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Starts master IP rotation.
            #
            # @overload start_ip_rotation(request, options = nil)
            #   Pass arguments to `start_ip_rotation` via a request object, either of type
            #   {::Google::Cloud::Container::V1::StartIPRotationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::StartIPRotationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload start_ip_rotation(project_id: nil, zone: nil, cluster_id: nil, name: nil, rotate_credentials: nil)
            #   Pass arguments to `start_ip_rotation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, cluster name) of the cluster to start IP
            #     rotation. Specified in the format `projects/*/locations/*/clusters/*`.
            #   @param rotate_credentials [::Boolean]
            #     Whether to rotate credentials during IP rotation.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::StartIPRotationRequest.new
            #
            #   # Call the start_ip_rotation method.
            #   result = client.start_ip_rotation request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def start_ip_rotation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::StartIPRotationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.start_ip_rotation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.start_ip_rotation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.start_ip_rotation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :start_ip_rotation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Completes master IP rotation.
            #
            # @overload complete_ip_rotation(request, options = nil)
            #   Pass arguments to `complete_ip_rotation` via a request object, either of type
            #   {::Google::Cloud::Container::V1::CompleteIPRotationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::CompleteIPRotationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload complete_ip_rotation(project_id: nil, zone: nil, cluster_id: nil, name: nil)
            #   Pass arguments to `complete_ip_rotation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster.
            #     This field has been deprecated and replaced by the name field.
            #   @param name [::String]
            #     The name (project, location, cluster name) of the cluster to complete IP
            #     rotation. Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::CompleteIPRotationRequest.new
            #
            #   # Call the complete_ip_rotation method.
            #   result = client.complete_ip_rotation request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def complete_ip_rotation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::CompleteIPRotationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.complete_ip_rotation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.complete_ip_rotation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.complete_ip_rotation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :complete_ip_rotation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the size for a specific node pool. The new size will be used for all
            # replicas, including future replicas created by modifying
            # {::Google::Cloud::Container::V1::NodePool#locations NodePool.locations}.
            #
            # @overload set_node_pool_size(request, options = nil)
            #   Pass arguments to `set_node_pool_size` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetNodePoolSizeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetNodePoolSizeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_node_pool_size(project_id: nil, zone: nil, cluster_id: nil, node_pool_id: nil, node_count: nil, name: nil)
            #   Pass arguments to `set_node_pool_size` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster to update.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_pool_id [::String]
            #     Deprecated. The name of the node pool to update.
            #     This field has been deprecated and replaced by the name field.
            #   @param node_count [::Integer]
            #     Required. The desired node count for the pool.
            #   @param name [::String]
            #     The name (project, location, cluster, node pool id) of the node pool to set
            #     size.
            #     Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetNodePoolSizeRequest.new
            #
            #   # Call the set_node_pool_size method.
            #   result = client.set_node_pool_size request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_node_pool_size request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetNodePoolSizeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_node_pool_size.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_node_pool_size.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_node_pool_size.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_node_pool_size, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Enables or disables Network Policy for a cluster.
            #
            # @overload set_network_policy(request, options = nil)
            #   Pass arguments to `set_network_policy` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetNetworkPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetNetworkPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_network_policy(project_id: nil, zone: nil, cluster_id: nil, network_policy: nil, name: nil)
            #   Pass arguments to `set_network_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Deprecated. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #     This field has been deprecated and replaced by the name field.
            #   @param zone [::String]
            #     Deprecated. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides. This field has been deprecated and replaced
            #     by the name field.
            #   @param cluster_id [::String]
            #     Deprecated. The name of the cluster.
            #     This field has been deprecated and replaced by the name field.
            #   @param network_policy [::Google::Cloud::Container::V1::NetworkPolicy, ::Hash]
            #     Required. Configuration options for the NetworkPolicy feature.
            #   @param name [::String]
            #     The name (project, location, cluster name) of the cluster to set networking
            #     policy. Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetNetworkPolicyRequest.new
            #
            #   # Call the set_network_policy method.
            #   result = client.set_network_policy request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_network_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetNetworkPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_network_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_network_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_network_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_network_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the maintenance policy for a cluster.
            #
            # @overload set_maintenance_policy(request, options = nil)
            #   Pass arguments to `set_maintenance_policy` via a request object, either of type
            #   {::Google::Cloud::Container::V1::SetMaintenancePolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::SetMaintenancePolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_maintenance_policy(project_id: nil, zone: nil, cluster_id: nil, maintenance_policy: nil, name: nil)
            #   Pass arguments to `set_maintenance_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The Google Developers Console [project ID or project
            #     number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
            #   @param zone [::String]
            #     Required. The name of the Google Compute Engine
            #     [zone](https://cloud.google.com/compute/docs/zones#available)
            #     in which the cluster resides.
            #   @param cluster_id [::String]
            #     Required. The name of the cluster to update.
            #   @param maintenance_policy [::Google::Cloud::Container::V1::MaintenancePolicy, ::Hash]
            #     Required. The maintenance policy to be set for the cluster. An empty field
            #     clears the existing maintenance policy.
            #   @param name [::String]
            #     The name (project, location, cluster name) of the cluster to set
            #     maintenance policy.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::SetMaintenancePolicyRequest.new
            #
            #   # Call the set_maintenance_policy method.
            #   result = client.set_maintenance_policy request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::Operation.
            #   p result
            #
            def set_maintenance_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::SetMaintenancePolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_maintenance_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_maintenance_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_maintenance_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :set_maintenance_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists subnetworks that are usable for creating clusters in a project.
            #
            # @overload list_usable_subnetworks(request, options = nil)
            #   Pass arguments to `list_usable_subnetworks` via a request object, either of type
            #   {::Google::Cloud::Container::V1::ListUsableSubnetworksRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::ListUsableSubnetworksRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_usable_subnetworks(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_usable_subnetworks` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     The parent project where subnetworks are usable.
            #     Specified in the format `projects/*`.
            #   @param filter [::String]
            #     Filtering currently only supports equality on the networkProjectId and must
            #     be in the form: "networkProjectId=[PROJECTID]", where `networkProjectId`
            #     is the project which owns the listed subnetworks. This defaults to the
            #     parent project ID.
            #   @param page_size [::Integer]
            #     The max number of results per page that should be returned. If the number
            #     of available results is larger than `page_size`, a `next_page_token` is
            #     returned which can be used to get the next page of results in subsequent
            #     requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
            #   @param page_token [::String]
            #     Specifies a page token to use. Set this to the nextPageToken returned by
            #     previous list requests to get the next page of results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Container::V1::UsableSubnetwork>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Container::V1::UsableSubnetwork>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::ListUsableSubnetworksRequest.new
            #
            #   # Call the list_usable_subnetworks method.
            #   result = client.list_usable_subnetworks request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Container::V1::UsableSubnetwork.
            #     p item
            #   end
            #
            def list_usable_subnetworks request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::ListUsableSubnetworksRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_usable_subnetworks.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_usable_subnetworks.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_usable_subnetworks.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :list_usable_subnetworks, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cluster_manager_stub, :list_usable_subnetworks, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Checks the cluster compatibility with Autopilot mode, and returns a list of
            # compatibility issues.
            #
            # @overload check_autopilot_compatibility(request, options = nil)
            #   Pass arguments to `check_autopilot_compatibility` via a request object, either of type
            #   {::Google::Cloud::Container::V1::CheckAutopilotCompatibilityRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::CheckAutopilotCompatibilityRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload check_autopilot_compatibility(name: nil)
            #   Pass arguments to `check_autopilot_compatibility` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     The name (project, location, cluster) of the cluster to retrieve.
            #     Specified in the format `projects/*/locations/*/clusters/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::CheckAutopilotCompatibilityResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::CheckAutopilotCompatibilityResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::CheckAutopilotCompatibilityRequest.new
            #
            #   # Call the check_autopilot_compatibility method.
            #   result = client.check_autopilot_compatibility request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::CheckAutopilotCompatibilityResponse.
            #   p result
            #
            def check_autopilot_compatibility request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::CheckAutopilotCompatibilityRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.check_autopilot_compatibility.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.check_autopilot_compatibility.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.check_autopilot_compatibility.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :check_autopilot_compatibility, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetch upgrade information of a specific cluster.
            #
            # @overload fetch_cluster_upgrade_info(request, options = nil)
            #   Pass arguments to `fetch_cluster_upgrade_info` via a request object, either of type
            #   {::Google::Cloud::Container::V1::FetchClusterUpgradeInfoRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::FetchClusterUpgradeInfoRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_cluster_upgrade_info(name: nil, version: nil)
            #   Pass arguments to `fetch_cluster_upgrade_info` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name (project, location, cluster) of the cluster to get.
            #     Specified in the format `projects/*/locations/*/clusters/*` or
            #     `projects/*/zones/*/clusters/*`.
            #   @param version [::String]
            #     API request version that initiates this operation.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::ClusterUpgradeInfo]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::ClusterUpgradeInfo]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::FetchClusterUpgradeInfoRequest.new
            #
            #   # Call the fetch_cluster_upgrade_info method.
            #   result = client.fetch_cluster_upgrade_info request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::ClusterUpgradeInfo.
            #   p result
            #
            def fetch_cluster_upgrade_info request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::FetchClusterUpgradeInfoRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_cluster_upgrade_info.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_cluster_upgrade_info.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_cluster_upgrade_info.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :fetch_cluster_upgrade_info, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetch upgrade information of a specific nodepool.
            #
            # @overload fetch_node_pool_upgrade_info(request, options = nil)
            #   Pass arguments to `fetch_node_pool_upgrade_info` via a request object, either of type
            #   {::Google::Cloud::Container::V1::FetchNodePoolUpgradeInfoRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Container::V1::FetchNodePoolUpgradeInfoRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_node_pool_upgrade_info(name: nil, version: nil)
            #   Pass arguments to `fetch_node_pool_upgrade_info` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name (project, location, cluster, nodepool) of the nodepool
            #     to get. Specified in the format
            #     `projects/*/locations/*/clusters/*/nodePools/*` or
            #     `projects/*/zones/*/clusters/*/nodePools/*`.
            #   @param version [::String]
            #     API request version that initiates this operation.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Container::V1::NodePoolUpgradeInfo]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Container::V1::NodePoolUpgradeInfo]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Container::V1::ClusterManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Container::V1::FetchNodePoolUpgradeInfoRequest.new
            #
            #   # Call the fetch_node_pool_upgrade_info method.
            #   result = client.fetch_node_pool_upgrade_info request
            #
            #   # The returned object is of type Google::Cloud::Container::V1::NodePoolUpgradeInfo.
            #   p result
            #
            def fetch_node_pool_upgrade_info request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Container::V1::FetchNodePoolUpgradeInfoRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_node_pool_upgrade_info.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Container::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_node_pool_upgrade_info.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_node_pool_upgrade_info.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cluster_manager_stub.call_rpc :fetch_node_pool_upgrade_info, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ClusterManager API.
            #
            # This class represents the configuration for ClusterManager,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Container::V1::ClusterManager::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_clusters to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Container::V1::ClusterManager::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_clusters.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Container::V1::ClusterManager::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_clusters.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Container::V1::ClusterManager::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "container.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ClusterManager API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_clusters`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_clusters
                ##
                # RPC-specific configuration for `get_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_cluster
                ##
                # RPC-specific configuration for `create_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_cluster
                ##
                # RPC-specific configuration for `update_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_cluster
                ##
                # RPC-specific configuration for `update_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_node_pool
                ##
                # RPC-specific configuration for `set_node_pool_autoscaling`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_node_pool_autoscaling
                ##
                # RPC-specific configuration for `set_logging_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_logging_service
                ##
                # RPC-specific configuration for `set_monitoring_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_monitoring_service
                ##
                # RPC-specific configuration for `set_addons_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_addons_config
                ##
                # RPC-specific configuration for `set_locations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_locations
                ##
                # RPC-specific configuration for `update_master`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_master
                ##
                # RPC-specific configuration for `set_master_auth`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_master_auth
                ##
                # RPC-specific configuration for `delete_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_cluster
                ##
                # RPC-specific configuration for `list_operations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_operations
                ##
                # RPC-specific configuration for `get_operation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_operation
                ##
                # RPC-specific configuration for `cancel_operation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_operation
                ##
                # RPC-specific configuration for `get_server_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_server_config
                ##
                # RPC-specific configuration for `get_json_web_keys`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_json_web_keys
                ##
                # RPC-specific configuration for `list_node_pools`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_node_pools
                ##
                # RPC-specific configuration for `get_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_node_pool
                ##
                # RPC-specific configuration for `create_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_node_pool
                ##
                # RPC-specific configuration for `delete_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_node_pool
                ##
                # RPC-specific configuration for `complete_node_pool_upgrade`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :complete_node_pool_upgrade
                ##
                # RPC-specific configuration for `rollback_node_pool_upgrade`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rollback_node_pool_upgrade
                ##
                # RPC-specific configuration for `set_node_pool_management`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_node_pool_management
                ##
                # RPC-specific configuration for `set_labels`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_labels
                ##
                # RPC-specific configuration for `set_legacy_abac`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_legacy_abac
                ##
                # RPC-specific configuration for `start_ip_rotation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :start_ip_rotation
                ##
                # RPC-specific configuration for `complete_ip_rotation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :complete_ip_rotation
                ##
                # RPC-specific configuration for `set_node_pool_size`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_node_pool_size
                ##
                # RPC-specific configuration for `set_network_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_network_policy
                ##
                # RPC-specific configuration for `set_maintenance_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_maintenance_policy
                ##
                # RPC-specific configuration for `list_usable_subnetworks`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_usable_subnetworks
                ##
                # RPC-specific configuration for `check_autopilot_compatibility`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :check_autopilot_compatibility
                ##
                # RPC-specific configuration for `fetch_cluster_upgrade_info`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_cluster_upgrade_info
                ##
                # RPC-specific configuration for `fetch_node_pool_upgrade_info`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_node_pool_upgrade_info

                # @private
                def initialize parent_rpcs = nil
                  list_clusters_config = parent_rpcs.list_clusters if parent_rpcs.respond_to? :list_clusters
                  @list_clusters = ::Gapic::Config::Method.new list_clusters_config
                  get_cluster_config = parent_rpcs.get_cluster if parent_rpcs.respond_to? :get_cluster
                  @get_cluster = ::Gapic::Config::Method.new get_cluster_config
                  create_cluster_config = parent_rpcs.create_cluster if parent_rpcs.respond_to? :create_cluster
                  @create_cluster = ::Gapic::Config::Method.new create_cluster_config
                  update_cluster_config = parent_rpcs.update_cluster if parent_rpcs.respond_to? :update_cluster
                  @update_cluster = ::Gapic::Config::Method.new update_cluster_config
                  update_node_pool_config = parent_rpcs.update_node_pool if parent_rpcs.respond_to? :update_node_pool
                  @update_node_pool = ::Gapic::Config::Method.new update_node_pool_config
                  set_node_pool_autoscaling_config = parent_rpcs.set_node_pool_autoscaling if parent_rpcs.respond_to? :set_node_pool_autoscaling
                  @set_node_pool_autoscaling = ::Gapic::Config::Method.new set_node_pool_autoscaling_config
                  set_logging_service_config = parent_rpcs.set_logging_service if parent_rpcs.respond_to? :set_logging_service
                  @set_logging_service = ::Gapic::Config::Method.new set_logging_service_config
                  set_monitoring_service_config = parent_rpcs.set_monitoring_service if parent_rpcs.respond_to? :set_monitoring_service
                  @set_monitoring_service = ::Gapic::Config::Method.new set_monitoring_service_config
                  set_addons_config_config = parent_rpcs.set_addons_config if parent_rpcs.respond_to? :set_addons_config
                  @set_addons_config = ::Gapic::Config::Method.new set_addons_config_config
                  set_locations_config = parent_rpcs.set_locations if parent_rpcs.respond_to? :set_locations
                  @set_locations = ::Gapic::Config::Method.new set_locations_config
                  update_master_config = parent_rpcs.update_master if parent_rpcs.respond_to? :update_master
                  @update_master = ::Gapic::Config::Method.new update_master_config
                  set_master_auth_config = parent_rpcs.set_master_auth if parent_rpcs.respond_to? :set_master_auth
                  @set_master_auth = ::Gapic::Config::Method.new set_master_auth_config
                  delete_cluster_config = parent_rpcs.delete_cluster if parent_rpcs.respond_to? :delete_cluster
                  @delete_cluster = ::Gapic::Config::Method.new delete_cluster_config
                  list_operations_config = parent_rpcs.list_operations if parent_rpcs.respond_to? :list_operations
                  @list_operations = ::Gapic::Config::Method.new list_operations_config
                  get_operation_config = parent_rpcs.get_operation if parent_rpcs.respond_to? :get_operation
                  @get_operation = ::Gapic::Config::Method.new get_operation_config
                  cancel_operation_config = parent_rpcs.cancel_operation if parent_rpcs.respond_to? :cancel_operation
                  @cancel_operation = ::Gapic::Config::Method.new cancel_operation_config
                  get_server_config_config = parent_rpcs.get_server_config if parent_rpcs.respond_to? :get_server_config
                  @get_server_config = ::Gapic::Config::Method.new get_server_config_config
                  get_json_web_keys_config = parent_rpcs.get_json_web_keys if parent_rpcs.respond_to? :get_json_web_keys
                  @get_json_web_keys = ::Gapic::Config::Method.new get_json_web_keys_config
                  list_node_pools_config = parent_rpcs.list_node_pools if parent_rpcs.respond_to? :list_node_pools
                  @list_node_pools = ::Gapic::Config::Method.new list_node_pools_config
                  get_node_pool_config = parent_rpcs.get_node_pool if parent_rpcs.respond_to? :get_node_pool
                  @get_node_pool = ::Gapic::Config::Method.new get_node_pool_config
                  create_node_pool_config = parent_rpcs.create_node_pool if parent_rpcs.respond_to? :create_node_pool
                  @create_node_pool = ::Gapic::Config::Method.new create_node_pool_config
                  delete_node_pool_config = parent_rpcs.delete_node_pool if parent_rpcs.respond_to? :delete_node_pool
                  @delete_node_pool = ::Gapic::Config::Method.new delete_node_pool_config
                  complete_node_pool_upgrade_config = parent_rpcs.complete_node_pool_upgrade if parent_rpcs.respond_to? :complete_node_pool_upgrade
                  @complete_node_pool_upgrade = ::Gapic::Config::Method.new complete_node_pool_upgrade_config
                  rollback_node_pool_upgrade_config = parent_rpcs.rollback_node_pool_upgrade if parent_rpcs.respond_to? :rollback_node_pool_upgrade
                  @rollback_node_pool_upgrade = ::Gapic::Config::Method.new rollback_node_pool_upgrade_config
                  set_node_pool_management_config = parent_rpcs.set_node_pool_management if parent_rpcs.respond_to? :set_node_pool_management
                  @set_node_pool_management = ::Gapic::Config::Method.new set_node_pool_management_config
                  set_labels_config = parent_rpcs.set_labels if parent_rpcs.respond_to? :set_labels
                  @set_labels = ::Gapic::Config::Method.new set_labels_config
                  set_legacy_abac_config = parent_rpcs.set_legacy_abac if parent_rpcs.respond_to? :set_legacy_abac
                  @set_legacy_abac = ::Gapic::Config::Method.new set_legacy_abac_config
                  start_ip_rotation_config = parent_rpcs.start_ip_rotation if parent_rpcs.respond_to? :start_ip_rotation
                  @start_ip_rotation = ::Gapic::Config::Method.new start_ip_rotation_config
                  complete_ip_rotation_config = parent_rpcs.complete_ip_rotation if parent_rpcs.respond_to? :complete_ip_rotation
                  @complete_ip_rotation = ::Gapic::Config::Method.new complete_ip_rotation_config
                  set_node_pool_size_config = parent_rpcs.set_node_pool_size if parent_rpcs.respond_to? :set_node_pool_size
                  @set_node_pool_size = ::Gapic::Config::Method.new set_node_pool_size_config
                  set_network_policy_config = parent_rpcs.set_network_policy if parent_rpcs.respond_to? :set_network_policy
                  @set_network_policy = ::Gapic::Config::Method.new set_network_policy_config
                  set_maintenance_policy_config = parent_rpcs.set_maintenance_policy if parent_rpcs.respond_to? :set_maintenance_policy
                  @set_maintenance_policy = ::Gapic::Config::Method.new set_maintenance_policy_config
                  list_usable_subnetworks_config = parent_rpcs.list_usable_subnetworks if parent_rpcs.respond_to? :list_usable_subnetworks
                  @list_usable_subnetworks = ::Gapic::Config::Method.new list_usable_subnetworks_config
                  check_autopilot_compatibility_config = parent_rpcs.check_autopilot_compatibility if parent_rpcs.respond_to? :check_autopilot_compatibility
                  @check_autopilot_compatibility = ::Gapic::Config::Method.new check_autopilot_compatibility_config
                  fetch_cluster_upgrade_info_config = parent_rpcs.fetch_cluster_upgrade_info if parent_rpcs.respond_to? :fetch_cluster_upgrade_info
                  @fetch_cluster_upgrade_info = ::Gapic::Config::Method.new fetch_cluster_upgrade_info_config
                  fetch_node_pool_upgrade_info_config = parent_rpcs.fetch_node_pool_upgrade_info if parent_rpcs.respond_to? :fetch_node_pool_upgrade_info
                  @fetch_node_pool_upgrade_info = ::Gapic::Config::Method.new fetch_node_pool_upgrade_info_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
