# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/contactcenterinsights/v1/contact_center_insights_pb"
require "google/cloud/contact_center_insights/v1/contact_center_insights"

class ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_conversation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::Conversation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversation = {}
    conversation_id = "hello world"

    create_conversation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_conversation, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::Conversation), request["conversation"]
      assert_equal "hello world", request["conversation_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_conversation_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_conversation({ parent: parent, conversation: conversation, conversation_id: conversation_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_conversation parent: parent, conversation: conversation, conversation_id: conversation_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_conversation ::Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest.new(parent: parent, conversation: conversation, conversation_id: conversation_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_conversation({ parent: parent, conversation: conversation, conversation_id: conversation_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_conversation(::Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest.new(parent: parent, conversation: conversation, conversation_id: conversation_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_conversation_client_stub.call_rpc_count
    end
  end

  def test_upload_conversation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversation = {}
    conversation_id = "hello world"
    redaction_config = {}
    speech_config = {}

    upload_conversation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :upload_conversation, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::Conversation), request["conversation"]
      assert_equal "hello world", request["conversation_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::RedactionConfig), request["redaction_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::SpeechConfig), request["speech_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, upload_conversation_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.upload_conversation({ parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.upload_conversation parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.upload_conversation ::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest.new(parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.upload_conversation({ parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.upload_conversation(::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest.new(parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, upload_conversation_client_stub.call_rpc_count
    end
  end

  def test_update_conversation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::Conversation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversation = {}
    update_mask = {}

    update_conversation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_conversation, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::Conversation), request["conversation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_conversation_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_conversation({ conversation: conversation, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_conversation conversation: conversation, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_conversation ::Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest.new(conversation: conversation, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_conversation({ conversation: conversation, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_conversation(::Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest.new(conversation: conversation, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_conversation_client_stub.call_rpc_count
    end
  end

  def test_get_conversation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::Conversation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :CONVERSATION_VIEW_UNSPECIFIED

    get_conversation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_conversation, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetConversationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :CONVERSATION_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_conversation_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_conversation({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_conversation name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_conversation ::Google::Cloud::ContactCenterInsights::V1::GetConversationRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_conversation({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_conversation(::Google::Cloud::ContactCenterInsights::V1::GetConversationRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_conversation_client_stub.call_rpc_count
    end
  end

  def test_list_conversations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListConversationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :CONVERSATION_VIEW_UNSPECIFIED

    list_conversations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_conversations, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal :CONVERSATION_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_conversations_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_conversations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_conversations ::Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_conversations(::Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_conversations_client_stub.call_rpc_count
    end
  end

  def test_delete_conversation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_conversation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_conversation, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_conversation_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_conversation({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_conversation name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_conversation ::Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_conversation({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_conversation(::Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_conversation_client_stub.call_rpc_count
    end
  end

  def test_create_analysis
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    analysis = {}

    create_analysis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_analysis, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::Analysis), request["analysis"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_analysis_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_analysis({ parent: parent, analysis: analysis }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_analysis parent: parent, analysis: analysis do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_analysis ::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest.new(parent: parent, analysis: analysis) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_analysis({ parent: parent, analysis: analysis }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_analysis(::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest.new(parent: parent, analysis: analysis), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_analysis_client_stub.call_rpc_count
    end
  end

  def test_get_analysis
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::Analysis.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_analysis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_analysis, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_analysis_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_analysis({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_analysis name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_analysis ::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_analysis({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_analysis(::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_analysis_client_stub.call_rpc_count
    end
  end

  def test_list_analyses
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListAnalysesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_analyses_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_analyses, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_analyses_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_analyses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_analyses parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_analyses ::Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_analyses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_analyses(::Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_analyses_client_stub.call_rpc_count
    end
  end

  def test_delete_analysis
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_analysis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_analysis, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_analysis_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_analysis({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_analysis name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_analysis ::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_analysis({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_analysis(::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_analysis_client_stub.call_rpc_count
    end
  end

  def test_bulk_analyze_conversations
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    analysis_percentage = 3.5
    annotator_selector = {}

    bulk_analyze_conversations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :bulk_analyze_conversations, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 3.5, request["analysis_percentage"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::AnnotatorSelector), request["annotator_selector"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, bulk_analyze_conversations_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.bulk_analyze_conversations({ parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.bulk_analyze_conversations parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.bulk_analyze_conversations ::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest.new(parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.bulk_analyze_conversations({ parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.bulk_analyze_conversations(::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest.new(parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, bulk_analyze_conversations_client_stub.call_rpc_count
    end
  end

  def test_bulk_delete_conversations
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    max_delete_count = 42
    force = true

    bulk_delete_conversations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :bulk_delete_conversations, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["max_delete_count"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, bulk_delete_conversations_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.bulk_delete_conversations({ parent: parent, filter: filter, max_delete_count: max_delete_count, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.bulk_delete_conversations parent: parent, filter: filter, max_delete_count: max_delete_count, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.bulk_delete_conversations ::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest.new(parent: parent, filter: filter, max_delete_count: max_delete_count, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.bulk_delete_conversations({ parent: parent, filter: filter, max_delete_count: max_delete_count, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.bulk_delete_conversations(::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest.new(parent: parent, filter: filter, max_delete_count: max_delete_count, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, bulk_delete_conversations_client_stub.call_rpc_count
    end
  end

  def test_ingest_conversations
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    transcript_object_config = {}
    parent = "hello world"
    conversation_config = {}
    redaction_config = {}
    speech_config = {}
    sample_size = 42

    ingest_conversations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :ingest_conversations, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::GcsSource), request["gcs_source"]
      assert_equal :gcs_source, request.source
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::TranscriptObjectConfig), request["transcript_object_config"]
      assert_equal :transcript_object_config, request.object_config
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::ConversationConfig), request["conversation_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::RedactionConfig), request["redaction_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::SpeechConfig), request["speech_config"]
      assert_equal 42, request["sample_size"]
      assert request.has_sample_size?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, ingest_conversations_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.ingest_conversations({ gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.ingest_conversations gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.ingest_conversations ::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest.new(gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.ingest_conversations({ gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.ingest_conversations(::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest.new(gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, ingest_conversations_client_stub.call_rpc_count
    end
  end

  def test_export_insights_data
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    big_query_destination = {}
    parent = "hello world"
    filter = "hello world"
    kms_key = "hello world"
    write_disposition = :WRITE_DISPOSITION_UNSPECIFIED

    export_insights_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_insights_data, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest::BigQueryDestination), request["big_query_destination"]
      assert_equal :big_query_destination, request.destination
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["kms_key"]
      assert_equal :WRITE_DISPOSITION_UNSPECIFIED, request["write_disposition"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_insights_data_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_insights_data({ big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_insights_data big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_insights_data ::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest.new(big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_insights_data({ big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_insights_data(::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest.new(big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_insights_data_client_stub.call_rpc_count
    end
  end

  def test_create_issue_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    issue_model = {}

    create_issue_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_issue_model, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::IssueModel), request["issue_model"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_issue_model_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_issue_model({ parent: parent, issue_model: issue_model }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_issue_model parent: parent, issue_model: issue_model do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_issue_model ::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest.new(parent: parent, issue_model: issue_model) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_issue_model({ parent: parent, issue_model: issue_model }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_issue_model(::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest.new(parent: parent, issue_model: issue_model), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_issue_model_client_stub.call_rpc_count
    end
  end

  def test_update_issue_model
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::IssueModel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    issue_model = {}
    update_mask = {}

    update_issue_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_issue_model, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::IssueModel), request["issue_model"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_issue_model_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_issue_model({ issue_model: issue_model, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_issue_model issue_model: issue_model, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_issue_model ::Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest.new(issue_model: issue_model, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_issue_model({ issue_model: issue_model, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_issue_model(::Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest.new(issue_model: issue_model, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_issue_model_client_stub.call_rpc_count
    end
  end

  def test_get_issue_model
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::IssueModel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_issue_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_issue_model, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_issue_model_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_issue_model({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_issue_model name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_issue_model ::Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_issue_model({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_issue_model(::Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_issue_model_client_stub.call_rpc_count
    end
  end

  def test_list_issue_models
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_issue_models_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_issue_models, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_issue_models_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_issue_models({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_issue_models parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_issue_models ::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_issue_models({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_issue_models(::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_issue_models_client_stub.call_rpc_count
    end
  end

  def test_delete_issue_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_issue_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_issue_model, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_issue_model_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_issue_model({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_issue_model name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_issue_model ::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_issue_model({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_issue_model(::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_issue_model_client_stub.call_rpc_count
    end
  end

  def test_deploy_issue_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    deploy_issue_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :deploy_issue_model, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, deploy_issue_model_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.deploy_issue_model({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.deploy_issue_model name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.deploy_issue_model ::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.deploy_issue_model({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.deploy_issue_model(::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, deploy_issue_model_client_stub.call_rpc_count
    end
  end

  def test_undeploy_issue_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undeploy_issue_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undeploy_issue_model, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undeploy_issue_model_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undeploy_issue_model({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undeploy_issue_model name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undeploy_issue_model ::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undeploy_issue_model({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undeploy_issue_model(::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undeploy_issue_model_client_stub.call_rpc_count
    end
  end

  def test_export_issue_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcs_destination = {}
    name = "hello world"

    export_issue_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_issue_model, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest::GcsDestination), request["gcs_destination"]
      assert_equal :gcs_destination, request.Destination
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_issue_model_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_issue_model({ gcs_destination: gcs_destination, name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_issue_model gcs_destination: gcs_destination, name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_issue_model ::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest.new(gcs_destination: gcs_destination, name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_issue_model({ gcs_destination: gcs_destination, name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_issue_model(::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest.new(gcs_destination: gcs_destination, name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_issue_model_client_stub.call_rpc_count
    end
  end

  def test_import_issue_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    parent = "hello world"
    create_new_model = true

    import_issue_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_issue_model, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest::GcsSource), request["gcs_source"]
      assert_equal :gcs_source, request.Source
      assert_equal "hello world", request["parent"]
      assert_equal true, request["create_new_model"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_issue_model_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_issue_model({ gcs_source: gcs_source, parent: parent, create_new_model: create_new_model }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_issue_model gcs_source: gcs_source, parent: parent, create_new_model: create_new_model do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_issue_model ::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest.new(gcs_source: gcs_source, parent: parent, create_new_model: create_new_model) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_issue_model({ gcs_source: gcs_source, parent: parent, create_new_model: create_new_model }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_issue_model(::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest.new(gcs_source: gcs_source, parent: parent, create_new_model: create_new_model), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_issue_model_client_stub.call_rpc_count
    end
  end

  def test_get_issue
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::Issue.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_issue, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetIssueRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_issue_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_issue({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_issue name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_issue ::Google::Cloud::ContactCenterInsights::V1::GetIssueRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_issue({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_issue(::Google::Cloud::ContactCenterInsights::V1::GetIssueRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_issue_client_stub.call_rpc_count
    end
  end

  def test_list_issues
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListIssuesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_issues_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_issues, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_issues_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_issues({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_issues parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_issues ::Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_issues({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_issues(::Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_issues_client_stub.call_rpc_count
    end
  end

  def test_update_issue
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::Issue.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    issue = {}
    update_mask = {}

    update_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_issue, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::Issue), request["issue"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_issue_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_issue({ issue: issue, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_issue issue: issue, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_issue ::Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest.new(issue: issue, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_issue({ issue: issue, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_issue(::Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest.new(issue: issue, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_issue_client_stub.call_rpc_count
    end
  end

  def test_delete_issue
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_issue_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_issue, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_issue_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_issue({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_issue name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_issue ::Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_issue({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_issue(::Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_issue_client_stub.call_rpc_count
    end
  end

  def test_calculate_issue_model_stats
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    issue_model = "hello world"

    calculate_issue_model_stats_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :calculate_issue_model_stats, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest, request
      assert_equal "hello world", request["issue_model"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, calculate_issue_model_stats_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.calculate_issue_model_stats({ issue_model: issue_model }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.calculate_issue_model_stats issue_model: issue_model do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.calculate_issue_model_stats ::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest.new(issue_model: issue_model) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.calculate_issue_model_stats({ issue_model: issue_model }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.calculate_issue_model_stats(::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest.new(issue_model: issue_model), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, calculate_issue_model_stats_client_stub.call_rpc_count
    end
  end

  def test_create_phrase_matcher
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    phrase_matcher = {}

    create_phrase_matcher_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_phrase_matcher, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher), request["phrase_matcher"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_phrase_matcher_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_phrase_matcher({ parent: parent, phrase_matcher: phrase_matcher }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_phrase_matcher parent: parent, phrase_matcher: phrase_matcher do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_phrase_matcher ::Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest.new(parent: parent, phrase_matcher: phrase_matcher) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_phrase_matcher({ parent: parent, phrase_matcher: phrase_matcher }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_phrase_matcher(::Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest.new(parent: parent, phrase_matcher: phrase_matcher), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_phrase_matcher_client_stub.call_rpc_count
    end
  end

  def test_get_phrase_matcher
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_phrase_matcher_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_phrase_matcher, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_phrase_matcher_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_phrase_matcher({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_phrase_matcher name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_phrase_matcher ::Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_phrase_matcher({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_phrase_matcher(::Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_phrase_matcher_client_stub.call_rpc_count
    end
  end

  def test_list_phrase_matchers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_phrase_matchers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_phrase_matchers, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_phrase_matchers_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_phrase_matchers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_phrase_matchers parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_phrase_matchers ::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_phrase_matchers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_phrase_matchers(::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_phrase_matchers_client_stub.call_rpc_count
    end
  end

  def test_delete_phrase_matcher
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_phrase_matcher_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_phrase_matcher, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_phrase_matcher_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_phrase_matcher({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_phrase_matcher name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_phrase_matcher ::Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_phrase_matcher({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_phrase_matcher(::Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_phrase_matcher_client_stub.call_rpc_count
    end
  end

  def test_update_phrase_matcher
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    phrase_matcher = {}
    update_mask = {}

    update_phrase_matcher_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_phrase_matcher, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher), request["phrase_matcher"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_phrase_matcher_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_phrase_matcher({ phrase_matcher: phrase_matcher, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_phrase_matcher phrase_matcher: phrase_matcher, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_phrase_matcher ::Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest.new(phrase_matcher: phrase_matcher, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_phrase_matcher({ phrase_matcher: phrase_matcher, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_phrase_matcher(::Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest.new(phrase_matcher: phrase_matcher, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_phrase_matcher_client_stub.call_rpc_count
    end
  end

  def test_calculate_stats
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::CalculateStatsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    filter = "hello world"

    calculate_stats_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :calculate_stats, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest, request
      assert_equal "hello world", request["location"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, calculate_stats_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.calculate_stats({ location: location, filter: filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.calculate_stats location: location, filter: filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.calculate_stats ::Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest.new(location: location, filter: filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.calculate_stats({ location: location, filter: filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.calculate_stats(::Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest.new(location: location, filter: filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, calculate_stats_client_stub.call_rpc_count
    end
  end

  def test_get_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::Settings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_settings, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_settings_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_settings ::Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_settings(::Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_settings_client_stub.call_rpc_count
    end
  end

  def test_update_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::Settings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    settings = {}
    update_mask = {}

    update_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_settings, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::Settings), request["settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_settings_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_settings({ settings: settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_settings settings: settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_settings ::Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest.new(settings: settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_settings({ settings: settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_settings(::Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest.new(settings: settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_settings_client_stub.call_rpc_count
    end
  end

  def test_create_analysis_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    analysis_rule = {}

    create_analysis_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_analysis_rule, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule), request["analysis_rule"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_analysis_rule_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_analysis_rule({ parent: parent, analysis_rule: analysis_rule }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_analysis_rule parent: parent, analysis_rule: analysis_rule do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_analysis_rule ::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest.new(parent: parent, analysis_rule: analysis_rule) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_analysis_rule({ parent: parent, analysis_rule: analysis_rule }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_analysis_rule(::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest.new(parent: parent, analysis_rule: analysis_rule), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_analysis_rule_client_stub.call_rpc_count
    end
  end

  def test_get_analysis_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_analysis_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_analysis_rule, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_analysis_rule_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_analysis_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_analysis_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_analysis_rule ::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_analysis_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_analysis_rule(::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_analysis_rule_client_stub.call_rpc_count
    end
  end

  def test_list_analysis_rules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_analysis_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_analysis_rules, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_analysis_rules_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_analysis_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_analysis_rules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_analysis_rules ::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_analysis_rules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_analysis_rules(::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_analysis_rules_client_stub.call_rpc_count
    end
  end

  def test_update_analysis_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    analysis_rule = {}
    update_mask = {}

    update_analysis_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_analysis_rule, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule), request["analysis_rule"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_analysis_rule_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_analysis_rule({ analysis_rule: analysis_rule, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_analysis_rule analysis_rule: analysis_rule, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_analysis_rule ::Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest.new(analysis_rule: analysis_rule, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_analysis_rule({ analysis_rule: analysis_rule, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_analysis_rule(::Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest.new(analysis_rule: analysis_rule, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_analysis_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_analysis_rule
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_analysis_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_analysis_rule, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_analysis_rule_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_analysis_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_analysis_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_analysis_rule ::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_analysis_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_analysis_rule(::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_analysis_rule_client_stub.call_rpc_count
    end
  end

  def test_get_encryption_spec
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::EncryptionSpec.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_encryption_spec_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_encryption_spec, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_encryption_spec_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_encryption_spec({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_encryption_spec name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_encryption_spec ::Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_encryption_spec({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_encryption_spec(::Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_encryption_spec_client_stub.call_rpc_count
    end
  end

  def test_initialize_encryption_spec
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    encryption_spec = {}

    initialize_encryption_spec_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :initialize_encryption_spec, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::EncryptionSpec), request["encryption_spec"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, initialize_encryption_spec_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.initialize_encryption_spec({ encryption_spec: encryption_spec }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.initialize_encryption_spec encryption_spec: encryption_spec do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.initialize_encryption_spec ::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest.new(encryption_spec: encryption_spec) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.initialize_encryption_spec({ encryption_spec: encryption_spec }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.initialize_encryption_spec(::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest.new(encryption_spec: encryption_spec), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, initialize_encryption_spec_client_stub.call_rpc_count
    end
  end

  def test_create_view
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::View.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    view = {}

    create_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_view, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateViewRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::View), request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_view_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_view({ parent: parent, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_view parent: parent, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_view ::Google::Cloud::ContactCenterInsights::V1::CreateViewRequest.new(parent: parent, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_view({ parent: parent, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_view(::Google::Cloud::ContactCenterInsights::V1::CreateViewRequest.new(parent: parent, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_view_client_stub.call_rpc_count
    end
  end

  def test_get_view
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::View.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_view, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetViewRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_view_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_view({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_view name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_view ::Google::Cloud::ContactCenterInsights::V1::GetViewRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_view({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_view(::Google::Cloud::ContactCenterInsights::V1::GetViewRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_view_client_stub.call_rpc_count
    end
  end

  def test_list_views
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListViewsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_views_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_views, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListViewsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_views_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_views({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_views parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_views ::Google::Cloud::ContactCenterInsights::V1::ListViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_views({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_views(::Google::Cloud::ContactCenterInsights::V1::ListViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_views_client_stub.call_rpc_count
    end
  end

  def test_update_view
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::View.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    view = {}
    update_mask = {}

    update_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_view, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::View), request["view"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_view_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_view({ view: view, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_view view: view, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_view ::Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest.new(view: view, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_view({ view: view, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_view(::Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest.new(view: view, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_view_client_stub.call_rpc_count
    end
  end

  def test_delete_view
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_view, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_view_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_view({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_view name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_view ::Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_view({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_view(::Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_view_client_stub.call_rpc_count
    end
  end

  def test_query_metrics
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    filter = "hello world"
    time_granularity = :TIME_GRANULARITY_UNSPECIFIED
    dimensions = [{}]
    measure_mask = {}

    query_metrics_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_metrics, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest, request
      assert_equal "hello world", request["location"]
      assert_equal "hello world", request["filter"]
      assert_equal :TIME_GRANULARITY_UNSPECIFIED, request["time_granularity"]
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::Dimension, request["dimensions"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["measure_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_metrics_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_metrics({ location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_metrics location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_metrics ::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest.new(location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_metrics({ location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_metrics(::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest.new(location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_metrics_client_stub.call_rpc_count
    end
  end

  def test_create_qa_question
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaQuestion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    qa_question = {}
    qa_question_id = "hello world"

    create_qa_question_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_qa_question, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::QaQuestion), request["qa_question"]
      assert_equal "hello world", request["qa_question_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_qa_question_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_qa_question({ parent: parent, qa_question: qa_question, qa_question_id: qa_question_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_qa_question parent: parent, qa_question: qa_question, qa_question_id: qa_question_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_qa_question ::Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest.new(parent: parent, qa_question: qa_question, qa_question_id: qa_question_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_qa_question({ parent: parent, qa_question: qa_question, qa_question_id: qa_question_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_qa_question(::Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest.new(parent: parent, qa_question: qa_question, qa_question_id: qa_question_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_qa_question_client_stub.call_rpc_count
    end
  end

  def test_get_qa_question
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaQuestion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_qa_question_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_qa_question, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_qa_question_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_qa_question({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_qa_question name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_qa_question ::Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_qa_question({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_qa_question(::Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_qa_question_client_stub.call_rpc_count
    end
  end

  def test_update_qa_question
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaQuestion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    qa_question = {}
    update_mask = {}

    update_qa_question_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_qa_question, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::QaQuestion), request["qa_question"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_qa_question_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_qa_question({ qa_question: qa_question, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_qa_question qa_question: qa_question, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_qa_question ::Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest.new(qa_question: qa_question, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_qa_question({ qa_question: qa_question, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_qa_question(::Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest.new(qa_question: qa_question, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_qa_question_client_stub.call_rpc_count
    end
  end

  def test_delete_qa_question
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_qa_question_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_qa_question, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_qa_question_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_qa_question({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_qa_question name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_qa_question ::Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_qa_question({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_qa_question(::Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_qa_question_client_stub.call_rpc_count
    end
  end

  def test_list_qa_questions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_qa_questions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_qa_questions, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_qa_questions_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_qa_questions({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_qa_questions parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_qa_questions ::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_qa_questions({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_qa_questions(::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_qa_questions_client_stub.call_rpc_count
    end
  end

  def test_create_qa_scorecard
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaScorecard.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    qa_scorecard = {}
    qa_scorecard_id = "hello world"

    create_qa_scorecard_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_qa_scorecard, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::QaScorecard), request["qa_scorecard"]
      assert_equal "hello world", request["qa_scorecard_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_qa_scorecard_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_qa_scorecard({ parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_qa_scorecard parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_qa_scorecard ::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest.new(parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_qa_scorecard({ parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_qa_scorecard(::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest.new(parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_qa_scorecard_client_stub.call_rpc_count
    end
  end

  def test_get_qa_scorecard
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaScorecard.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_qa_scorecard_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_qa_scorecard, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_qa_scorecard_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_qa_scorecard({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_qa_scorecard name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_qa_scorecard ::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_qa_scorecard({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_qa_scorecard(::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_qa_scorecard_client_stub.call_rpc_count
    end
  end

  def test_update_qa_scorecard
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaScorecard.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    qa_scorecard = {}
    update_mask = {}

    update_qa_scorecard_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_qa_scorecard, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::QaScorecard), request["qa_scorecard"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_qa_scorecard_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_qa_scorecard({ qa_scorecard: qa_scorecard, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_qa_scorecard qa_scorecard: qa_scorecard, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_qa_scorecard ::Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest.new(qa_scorecard: qa_scorecard, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_qa_scorecard({ qa_scorecard: qa_scorecard, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_qa_scorecard(::Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest.new(qa_scorecard: qa_scorecard, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_qa_scorecard_client_stub.call_rpc_count
    end
  end

  def test_delete_qa_scorecard
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_qa_scorecard_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_qa_scorecard, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_qa_scorecard_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_qa_scorecard({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_qa_scorecard name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_qa_scorecard ::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_qa_scorecard({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_qa_scorecard(::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_qa_scorecard_client_stub.call_rpc_count
    end
  end

  def test_list_qa_scorecards
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_qa_scorecards_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_qa_scorecards, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_qa_scorecards_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_qa_scorecards({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_qa_scorecards parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_qa_scorecards ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_qa_scorecards({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_qa_scorecards(::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_qa_scorecards_client_stub.call_rpc_count
    end
  end

  def test_create_qa_scorecard_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    qa_scorecard_revision = {}
    qa_scorecard_revision_id = "hello world"

    create_qa_scorecard_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_qa_scorecard_revision, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision), request["qa_scorecard_revision"]
      assert_equal "hello world", request["qa_scorecard_revision_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_qa_scorecard_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_qa_scorecard_revision({ parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_qa_scorecard_revision parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest.new(parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_qa_scorecard_revision({ parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest.new(parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_qa_scorecard_revision_client_stub.call_rpc_count
    end
  end

  def test_get_qa_scorecard_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_qa_scorecard_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_qa_scorecard_revision, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_qa_scorecard_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_qa_scorecard_revision({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_qa_scorecard_revision name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_qa_scorecard_revision({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_qa_scorecard_revision_client_stub.call_rpc_count
    end
  end

  def test_tune_qa_scorecard_revision
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    validate_only = true

    tune_qa_scorecard_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :tune_qa_scorecard_revision, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, tune_qa_scorecard_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.tune_qa_scorecard_revision({ parent: parent, filter: filter, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.tune_qa_scorecard_revision parent: parent, filter: filter, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.tune_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest.new(parent: parent, filter: filter, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.tune_qa_scorecard_revision({ parent: parent, filter: filter, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.tune_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest.new(parent: parent, filter: filter, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, tune_qa_scorecard_revision_client_stub.call_rpc_count
    end
  end

  def test_deploy_qa_scorecard_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    deploy_qa_scorecard_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :deploy_qa_scorecard_revision, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, deploy_qa_scorecard_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.deploy_qa_scorecard_revision({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.deploy_qa_scorecard_revision name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.deploy_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.deploy_qa_scorecard_revision({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.deploy_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, deploy_qa_scorecard_revision_client_stub.call_rpc_count
    end
  end

  def test_undeploy_qa_scorecard_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undeploy_qa_scorecard_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undeploy_qa_scorecard_revision, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undeploy_qa_scorecard_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undeploy_qa_scorecard_revision({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undeploy_qa_scorecard_revision name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undeploy_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undeploy_qa_scorecard_revision({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undeploy_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undeploy_qa_scorecard_revision_client_stub.call_rpc_count
    end
  end

  def test_delete_qa_scorecard_revision
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_qa_scorecard_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_qa_scorecard_revision, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_qa_scorecard_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_qa_scorecard_revision({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_qa_scorecard_revision name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_qa_scorecard_revision({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_qa_scorecard_revision_client_stub.call_rpc_count
    end
  end

  def test_list_qa_scorecard_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_qa_scorecard_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_qa_scorecard_revisions, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_qa_scorecard_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_qa_scorecard_revisions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_qa_scorecard_revisions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_qa_scorecard_revisions ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_qa_scorecard_revisions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_qa_scorecard_revisions(::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_qa_scorecard_revisions_client_stub.call_rpc_count
    end
  end

  def test_create_feedback_label
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    feedback_label_id = "hello world"
    feedback_label = {}

    create_feedback_label_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_feedback_label, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["feedback_label_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel), request["feedback_label"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_feedback_label_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_feedback_label({ parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_feedback_label parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_feedback_label ::Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest.new(parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_feedback_label({ parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_feedback_label(::Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest.new(parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_feedback_label_client_stub.call_rpc_count
    end
  end

  def test_list_feedback_labels
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_feedback_labels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_feedback_labels, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_feedback_labels_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_feedback_labels({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_feedback_labels parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_feedback_labels ::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_feedback_labels({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_feedback_labels(::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_feedback_labels_client_stub.call_rpc_count
    end
  end

  def test_get_feedback_label
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_feedback_label_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_feedback_label, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_feedback_label_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_feedback_label({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_feedback_label name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_feedback_label ::Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_feedback_label({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_feedback_label(::Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_feedback_label_client_stub.call_rpc_count
    end
  end

  def test_update_feedback_label
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    feedback_label = {}
    update_mask = {}

    update_feedback_label_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_feedback_label, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel), request["feedback_label"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_feedback_label_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_feedback_label({ feedback_label: feedback_label, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_feedback_label feedback_label: feedback_label, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_feedback_label ::Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest.new(feedback_label: feedback_label, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_feedback_label({ feedback_label: feedback_label, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_feedback_label(::Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest.new(feedback_label: feedback_label, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_feedback_label_client_stub.call_rpc_count
    end
  end

  def test_delete_feedback_label
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_feedback_label_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_feedback_label, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_feedback_label_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_feedback_label({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_feedback_label name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_feedback_label ::Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_feedback_label({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_feedback_label(::Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_feedback_label_client_stub.call_rpc_count
    end
  end

  def test_list_all_feedback_labels
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_all_feedback_labels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_all_feedback_labels, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_all_feedback_labels_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_all_feedback_labels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_all_feedback_labels parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_all_feedback_labels ::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_all_feedback_labels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_all_feedback_labels(::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_all_feedback_labels_client_stub.call_rpc_count
    end
  end

  def test_bulk_upload_feedback_labels
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    parent = "hello world"
    validate_only = true

    bulk_upload_feedback_labels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :bulk_upload_feedback_labels, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest::GcsSource), request["gcs_source"]
      assert_equal :gcs_source, request.source
      assert_equal "hello world", request["parent"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, bulk_upload_feedback_labels_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.bulk_upload_feedback_labels({ gcs_source: gcs_source, parent: parent, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.bulk_upload_feedback_labels gcs_source: gcs_source, parent: parent, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.bulk_upload_feedback_labels ::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest.new(gcs_source: gcs_source, parent: parent, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.bulk_upload_feedback_labels({ gcs_source: gcs_source, parent: parent, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.bulk_upload_feedback_labels(::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest.new(gcs_source: gcs_source, parent: parent, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, bulk_upload_feedback_labels_client_stub.call_rpc_count
    end
  end

  def test_bulk_download_feedback_labels
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcs_destination = {}
    parent = "hello world"
    filter = "hello world"
    max_download_count = 42
    feedback_label_type = :FEEDBACK_LABEL_TYPE_UNSPECIFIED
    conversation_filter = "hello world"
    template_qa_scorecard_id = ["hello world"]

    bulk_download_feedback_labels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :bulk_download_feedback_labels, name
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest::GcsDestination), request["gcs_destination"]
      assert_equal :gcs_destination, request.destination
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["max_download_count"]
      assert_equal :FEEDBACK_LABEL_TYPE_UNSPECIFIED, request["feedback_label_type"]
      assert_equal "hello world", request["conversation_filter"]
      assert_equal ["hello world"], request["template_qa_scorecard_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, bulk_download_feedback_labels_client_stub do
      # Create client
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.bulk_download_feedback_labels({ gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.bulk_download_feedback_labels gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.bulk_download_feedback_labels ::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest.new(gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.bulk_download_feedback_labels({ gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.bulk_download_feedback_labels(::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest.new(gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, bulk_download_feedback_labels_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Operations, client.operations_client
  end
end
