# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/contactcenterinsights/v1/contact_center_insights_pb"
require "google/cloud/contact_center_insights/v1/contact_center_insights/rest"


class ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_conversation
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::Conversation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversation = {}
    conversation_id = "hello world"

    create_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_conversation({ parent: parent, conversation: conversation, conversation_id: conversation_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_conversation parent: parent, conversation: conversation, conversation_id: conversation_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_conversation ::Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest.new(parent: parent, conversation: conversation, conversation_id: conversation_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_conversation({ parent: parent, conversation: conversation, conversation_id: conversation_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_conversation(::Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest.new(parent: parent, conversation: conversation, conversation_id: conversation_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_conversation_client_stub.call_count
      end
    end
  end

  def test_upload_conversation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversation = {}
    conversation_id = "hello world"
    redaction_config = {}
    speech_config = {}

    upload_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_upload_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upload_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upload_conversation({ parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upload_conversation parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upload_conversation ::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest.new(parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upload_conversation({ parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upload_conversation(::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest.new(parent: parent, conversation: conversation, conversation_id: conversation_id, redaction_config: redaction_config, speech_config: speech_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upload_conversation_client_stub.call_count
      end
    end
  end

  def test_update_conversation
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::Conversation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    conversation = {}
    update_mask = {}

    update_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_conversation({ conversation: conversation, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_conversation conversation: conversation, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_conversation ::Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest.new(conversation: conversation, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_conversation({ conversation: conversation, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_conversation(::Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest.new(conversation: conversation, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_conversation_client_stub.call_count
      end
    end
  end

  def test_get_conversation
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::Conversation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :CONVERSATION_VIEW_UNSPECIFIED

    get_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_conversation({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_conversation name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_conversation ::Google::Cloud::ContactCenterInsights::V1::GetConversationRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_conversation({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_conversation(::Google::Cloud::ContactCenterInsights::V1::GetConversationRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_conversation_client_stub.call_count
      end
    end
  end

  def test_list_conversations
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListConversationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :CONVERSATION_VIEW_UNSPECIFIED

    list_conversations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_conversations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_conversations_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_conversations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_conversations ::Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_conversations(::Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_conversations_client_stub.call_count
      end
    end
  end

  def test_delete_conversation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_conversation({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_conversation name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_conversation ::Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_conversation({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_conversation(::Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_conversation_client_stub.call_count
      end
    end
  end

  def test_create_analysis
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    analysis = {}

    create_analysis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_analysis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_analysis_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_analysis({ parent: parent, analysis: analysis }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_analysis parent: parent, analysis: analysis do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_analysis ::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest.new(parent: parent, analysis: analysis) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_analysis({ parent: parent, analysis: analysis }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_analysis(::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest.new(parent: parent, analysis: analysis), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_analysis_client_stub.call_count
      end
    end
  end

  def test_get_analysis
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::Analysis.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_analysis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_analysis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_analysis_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_analysis({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_analysis name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_analysis ::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_analysis({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_analysis(::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_analysis_client_stub.call_count
      end
    end
  end

  def test_list_analyses
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListAnalysesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_analyses_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_analyses_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_analyses_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_analyses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_analyses parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_analyses ::Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_analyses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_analyses(::Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_analyses_client_stub.call_count
      end
    end
  end

  def test_delete_analysis
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_analysis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_analysis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_analysis_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_analysis({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_analysis name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_analysis ::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_analysis({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_analysis(::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_analysis_client_stub.call_count
      end
    end
  end

  def test_bulk_analyze_conversations
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    analysis_percentage = 3.5
    annotator_selector = {}

    bulk_analyze_conversations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_bulk_analyze_conversations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_analyze_conversations_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_analyze_conversations({ parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_analyze_conversations parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_analyze_conversations ::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest.new(parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_analyze_conversations({ parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_analyze_conversations(::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest.new(parent: parent, filter: filter, analysis_percentage: analysis_percentage, annotator_selector: annotator_selector), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_analyze_conversations_client_stub.call_count
      end
    end
  end

  def test_bulk_delete_conversations
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    max_delete_count = 42
    force = true

    bulk_delete_conversations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_bulk_delete_conversations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_delete_conversations_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_delete_conversations({ parent: parent, filter: filter, max_delete_count: max_delete_count, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_delete_conversations parent: parent, filter: filter, max_delete_count: max_delete_count, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_delete_conversations ::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest.new(parent: parent, filter: filter, max_delete_count: max_delete_count, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_delete_conversations({ parent: parent, filter: filter, max_delete_count: max_delete_count, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_delete_conversations(::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest.new(parent: parent, filter: filter, max_delete_count: max_delete_count, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_delete_conversations_client_stub.call_count
      end
    end
  end

  def test_ingest_conversations
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    transcript_object_config = {}
    parent = "hello world"
    conversation_config = {}
    redaction_config = {}
    speech_config = {}
    sample_size = 42

    ingest_conversations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_ingest_conversations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, ingest_conversations_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.ingest_conversations({ gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.ingest_conversations gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.ingest_conversations ::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest.new(gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.ingest_conversations({ gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.ingest_conversations(::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest.new(gcs_source: gcs_source, transcript_object_config: transcript_object_config, parent: parent, conversation_config: conversation_config, redaction_config: redaction_config, speech_config: speech_config, sample_size: sample_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, ingest_conversations_client_stub.call_count
      end
    end
  end

  def test_export_insights_data
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    big_query_destination = {}
    parent = "hello world"
    filter = "hello world"
    kms_key = "hello world"
    write_disposition = :WRITE_DISPOSITION_UNSPECIFIED

    export_insights_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_export_insights_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_insights_data_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_insights_data({ big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_insights_data big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_insights_data ::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest.new(big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_insights_data({ big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_insights_data(::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest.new(big_query_destination: big_query_destination, parent: parent, filter: filter, kms_key: kms_key, write_disposition: write_disposition), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_insights_data_client_stub.call_count
      end
    end
  end

  def test_create_issue_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    issue_model = {}

    create_issue_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_issue_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_issue_model_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_issue_model({ parent: parent, issue_model: issue_model }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_issue_model parent: parent, issue_model: issue_model do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_issue_model ::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest.new(parent: parent, issue_model: issue_model) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_issue_model({ parent: parent, issue_model: issue_model }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_issue_model(::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest.new(parent: parent, issue_model: issue_model), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_issue_model_client_stub.call_count
      end
    end
  end

  def test_update_issue_model
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::IssueModel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    issue_model = {}
    update_mask = {}

    update_issue_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_issue_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_issue_model_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_issue_model({ issue_model: issue_model, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_issue_model issue_model: issue_model, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_issue_model ::Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest.new(issue_model: issue_model, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_issue_model({ issue_model: issue_model, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_issue_model(::Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest.new(issue_model: issue_model, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_issue_model_client_stub.call_count
      end
    end
  end

  def test_get_issue_model
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::IssueModel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_issue_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_issue_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_issue_model_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_issue_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_issue_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_issue_model ::Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_issue_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_issue_model(::Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_issue_model_client_stub.call_count
      end
    end
  end

  def test_list_issue_models
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_issue_models_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_issue_models_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_issue_models_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_issue_models({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_issue_models parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_issue_models ::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_issue_models({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_issue_models(::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_issue_models_client_stub.call_count
      end
    end
  end

  def test_delete_issue_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_issue_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_issue_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_issue_model_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_issue_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_issue_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_issue_model ::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_issue_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_issue_model(::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_issue_model_client_stub.call_count
      end
    end
  end

  def test_deploy_issue_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    deploy_issue_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_deploy_issue_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, deploy_issue_model_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.deploy_issue_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.deploy_issue_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.deploy_issue_model ::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.deploy_issue_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.deploy_issue_model(::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, deploy_issue_model_client_stub.call_count
      end
    end
  end

  def test_undeploy_issue_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undeploy_issue_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_undeploy_issue_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undeploy_issue_model_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undeploy_issue_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undeploy_issue_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undeploy_issue_model ::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undeploy_issue_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undeploy_issue_model(::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undeploy_issue_model_client_stub.call_count
      end
    end
  end

  def test_export_issue_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_destination = {}
    name = "hello world"

    export_issue_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_export_issue_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_issue_model_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_issue_model({ gcs_destination: gcs_destination, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_issue_model gcs_destination: gcs_destination, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_issue_model ::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest.new(gcs_destination: gcs_destination, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_issue_model({ gcs_destination: gcs_destination, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_issue_model(::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest.new(gcs_destination: gcs_destination, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_issue_model_client_stub.call_count
      end
    end
  end

  def test_import_issue_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    parent = "hello world"
    create_new_model = true

    import_issue_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_import_issue_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_issue_model_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_issue_model({ gcs_source: gcs_source, parent: parent, create_new_model: create_new_model }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_issue_model gcs_source: gcs_source, parent: parent, create_new_model: create_new_model do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_issue_model ::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest.new(gcs_source: gcs_source, parent: parent, create_new_model: create_new_model) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_issue_model({ gcs_source: gcs_source, parent: parent, create_new_model: create_new_model }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_issue_model(::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest.new(gcs_source: gcs_source, parent: parent, create_new_model: create_new_model), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_issue_model_client_stub.call_count
      end
    end
  end

  def test_get_issue
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::Issue.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_issue_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_issue({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_issue name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_issue ::Google::Cloud::ContactCenterInsights::V1::GetIssueRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_issue({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_issue(::Google::Cloud::ContactCenterInsights::V1::GetIssueRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_issue_client_stub.call_count
      end
    end
  end

  def test_list_issues
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListIssuesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_issues_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_issues_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_issues_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_issues({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_issues parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_issues ::Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_issues({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_issues(::Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_issues_client_stub.call_count
      end
    end
  end

  def test_update_issue
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::Issue.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    issue = {}
    update_mask = {}

    update_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_issue_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_issue({ issue: issue, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_issue issue: issue, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_issue ::Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest.new(issue: issue, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_issue({ issue: issue, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_issue(::Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest.new(issue: issue, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_issue_client_stub.call_count
      end
    end
  end

  def test_delete_issue
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_issue_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_issue_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_issue_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_issue({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_issue name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_issue ::Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_issue({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_issue(::Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_issue_client_stub.call_count
      end
    end
  end

  def test_calculate_issue_model_stats
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    issue_model = "hello world"

    calculate_issue_model_stats_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_calculate_issue_model_stats_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, calculate_issue_model_stats_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.calculate_issue_model_stats({ issue_model: issue_model }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.calculate_issue_model_stats issue_model: issue_model do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.calculate_issue_model_stats ::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest.new(issue_model: issue_model) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.calculate_issue_model_stats({ issue_model: issue_model }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.calculate_issue_model_stats(::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest.new(issue_model: issue_model), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, calculate_issue_model_stats_client_stub.call_count
      end
    end
  end

  def test_create_phrase_matcher
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    phrase_matcher = {}

    create_phrase_matcher_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_phrase_matcher_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_phrase_matcher_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_phrase_matcher({ parent: parent, phrase_matcher: phrase_matcher }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_phrase_matcher parent: parent, phrase_matcher: phrase_matcher do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_phrase_matcher ::Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest.new(parent: parent, phrase_matcher: phrase_matcher) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_phrase_matcher({ parent: parent, phrase_matcher: phrase_matcher }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_phrase_matcher(::Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest.new(parent: parent, phrase_matcher: phrase_matcher), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_phrase_matcher_client_stub.call_count
      end
    end
  end

  def test_get_phrase_matcher
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_phrase_matcher_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_phrase_matcher_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_phrase_matcher_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_phrase_matcher({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_phrase_matcher name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_phrase_matcher ::Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_phrase_matcher({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_phrase_matcher(::Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_phrase_matcher_client_stub.call_count
      end
    end
  end

  def test_list_phrase_matchers
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_phrase_matchers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_phrase_matchers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_phrase_matchers_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_phrase_matchers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_phrase_matchers parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_phrase_matchers ::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_phrase_matchers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_phrase_matchers(::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_phrase_matchers_client_stub.call_count
      end
    end
  end

  def test_delete_phrase_matcher
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_phrase_matcher_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_phrase_matcher_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_phrase_matcher_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_phrase_matcher({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_phrase_matcher name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_phrase_matcher ::Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_phrase_matcher({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_phrase_matcher(::Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_phrase_matcher_client_stub.call_count
      end
    end
  end

  def test_update_phrase_matcher
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    phrase_matcher = {}
    update_mask = {}

    update_phrase_matcher_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_phrase_matcher_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_phrase_matcher_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_phrase_matcher({ phrase_matcher: phrase_matcher, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_phrase_matcher phrase_matcher: phrase_matcher, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_phrase_matcher ::Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest.new(phrase_matcher: phrase_matcher, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_phrase_matcher({ phrase_matcher: phrase_matcher, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_phrase_matcher(::Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest.new(phrase_matcher: phrase_matcher, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_phrase_matcher_client_stub.call_count
      end
    end
  end

  def test_calculate_stats
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::CalculateStatsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    filter = "hello world"

    calculate_stats_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_calculate_stats_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, calculate_stats_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.calculate_stats({ location: location, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.calculate_stats location: location, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.calculate_stats ::Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest.new(location: location, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.calculate_stats({ location: location, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.calculate_stats(::Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest.new(location: location, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, calculate_stats_client_stub.call_count
      end
    end
  end

  def test_get_settings
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::Settings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_settings_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_settings ::Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_settings(::Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_settings_client_stub.call_count
      end
    end
  end

  def test_update_settings
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::Settings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    settings = {}
    update_mask = {}

    update_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_settings_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_settings({ settings: settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_settings settings: settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_settings ::Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest.new(settings: settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_settings({ settings: settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_settings(::Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest.new(settings: settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_settings_client_stub.call_count
      end
    end
  end

  def test_create_analysis_rule
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    analysis_rule = {}

    create_analysis_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_analysis_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_analysis_rule_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_analysis_rule({ parent: parent, analysis_rule: analysis_rule }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_analysis_rule parent: parent, analysis_rule: analysis_rule do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_analysis_rule ::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest.new(parent: parent, analysis_rule: analysis_rule) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_analysis_rule({ parent: parent, analysis_rule: analysis_rule }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_analysis_rule(::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest.new(parent: parent, analysis_rule: analysis_rule), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_analysis_rule_client_stub.call_count
      end
    end
  end

  def test_get_analysis_rule
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_analysis_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_analysis_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_analysis_rule_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_analysis_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_analysis_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_analysis_rule ::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_analysis_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_analysis_rule(::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_analysis_rule_client_stub.call_count
      end
    end
  end

  def test_list_analysis_rules
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_analysis_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_analysis_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_analysis_rules_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_analysis_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_analysis_rules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_analysis_rules ::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_analysis_rules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_analysis_rules(::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_analysis_rules_client_stub.call_count
      end
    end
  end

  def test_update_analysis_rule
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    analysis_rule = {}
    update_mask = {}

    update_analysis_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_analysis_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_analysis_rule_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_analysis_rule({ analysis_rule: analysis_rule, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_analysis_rule analysis_rule: analysis_rule, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_analysis_rule ::Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest.new(analysis_rule: analysis_rule, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_analysis_rule({ analysis_rule: analysis_rule, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_analysis_rule(::Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest.new(analysis_rule: analysis_rule, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_analysis_rule_client_stub.call_count
      end
    end
  end

  def test_delete_analysis_rule
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_analysis_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_analysis_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_analysis_rule_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_analysis_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_analysis_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_analysis_rule ::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_analysis_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_analysis_rule(::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_analysis_rule_client_stub.call_count
      end
    end
  end

  def test_get_encryption_spec
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::EncryptionSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_encryption_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_encryption_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_encryption_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_encryption_spec({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_encryption_spec name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_encryption_spec ::Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_encryption_spec({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_encryption_spec(::Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_encryption_spec_client_stub.call_count
      end
    end
  end

  def test_initialize_encryption_spec
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    encryption_spec = {}

    initialize_encryption_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_initialize_encryption_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, initialize_encryption_spec_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.initialize_encryption_spec({ encryption_spec: encryption_spec }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.initialize_encryption_spec encryption_spec: encryption_spec do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.initialize_encryption_spec ::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest.new(encryption_spec: encryption_spec) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.initialize_encryption_spec({ encryption_spec: encryption_spec }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.initialize_encryption_spec(::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest.new(encryption_spec: encryption_spec), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, initialize_encryption_spec_client_stub.call_count
      end
    end
  end

  def test_create_view
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::View.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    view = {}

    create_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_view_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_view({ parent: parent, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_view parent: parent, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_view ::Google::Cloud::ContactCenterInsights::V1::CreateViewRequest.new(parent: parent, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_view({ parent: parent, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_view(::Google::Cloud::ContactCenterInsights::V1::CreateViewRequest.new(parent: parent, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_view_client_stub.call_count
      end
    end
  end

  def test_get_view
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::View.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_view_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_view({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_view name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_view ::Google::Cloud::ContactCenterInsights::V1::GetViewRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_view({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_view(::Google::Cloud::ContactCenterInsights::V1::GetViewRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_view_client_stub.call_count
      end
    end
  end

  def test_list_views
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListViewsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_views_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_views_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_views_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_views({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_views parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_views ::Google::Cloud::ContactCenterInsights::V1::ListViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_views({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_views(::Google::Cloud::ContactCenterInsights::V1::ListViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_views_client_stub.call_count
      end
    end
  end

  def test_update_view
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::View.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    view = {}
    update_mask = {}

    update_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_view_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_view({ view: view, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_view view: view, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_view ::Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest.new(view: view, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_view({ view: view, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_view(::Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest.new(view: view, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_view_client_stub.call_count
      end
    end
  end

  def test_delete_view
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_view_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_view({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_view name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_view ::Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_view({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_view(::Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_view_client_stub.call_count
      end
    end
  end

  def test_query_metrics
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    filter = "hello world"
    time_granularity = :TIME_GRANULARITY_UNSPECIFIED
    dimensions = [{}]
    measure_mask = {}

    query_metrics_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_query_metrics_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_metrics_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_metrics({ location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_metrics location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_metrics ::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest.new(location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_metrics({ location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_metrics(::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest.new(location: location, filter: filter, time_granularity: time_granularity, dimensions: dimensions, measure_mask: measure_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_metrics_client_stub.call_count
      end
    end
  end

  def test_create_qa_question
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaQuestion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    qa_question = {}
    qa_question_id = "hello world"

    create_qa_question_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_qa_question_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_qa_question_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_qa_question({ parent: parent, qa_question: qa_question, qa_question_id: qa_question_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_qa_question parent: parent, qa_question: qa_question, qa_question_id: qa_question_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_qa_question ::Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest.new(parent: parent, qa_question: qa_question, qa_question_id: qa_question_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_qa_question({ parent: parent, qa_question: qa_question, qa_question_id: qa_question_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_qa_question(::Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest.new(parent: parent, qa_question: qa_question, qa_question_id: qa_question_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_qa_question_client_stub.call_count
      end
    end
  end

  def test_get_qa_question
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaQuestion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_qa_question_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_qa_question_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_qa_question_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_qa_question({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_qa_question name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_qa_question ::Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_qa_question({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_qa_question(::Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_qa_question_client_stub.call_count
      end
    end
  end

  def test_update_qa_question
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaQuestion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    qa_question = {}
    update_mask = {}

    update_qa_question_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_qa_question_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_qa_question_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_qa_question({ qa_question: qa_question, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_qa_question qa_question: qa_question, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_qa_question ::Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest.new(qa_question: qa_question, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_qa_question({ qa_question: qa_question, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_qa_question(::Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest.new(qa_question: qa_question, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_qa_question_client_stub.call_count
      end
    end
  end

  def test_delete_qa_question
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_qa_question_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_qa_question_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_qa_question_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_qa_question({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_qa_question name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_qa_question ::Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_qa_question({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_qa_question(::Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_qa_question_client_stub.call_count
      end
    end
  end

  def test_list_qa_questions
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_qa_questions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_qa_questions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_qa_questions_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_qa_questions({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_qa_questions parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_qa_questions ::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_qa_questions({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_qa_questions(::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_qa_questions_client_stub.call_count
      end
    end
  end

  def test_create_qa_scorecard
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaScorecard.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    qa_scorecard = {}
    qa_scorecard_id = "hello world"

    create_qa_scorecard_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_qa_scorecard_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_qa_scorecard_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_qa_scorecard({ parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_qa_scorecard parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_qa_scorecard ::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest.new(parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_qa_scorecard({ parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_qa_scorecard(::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest.new(parent: parent, qa_scorecard: qa_scorecard, qa_scorecard_id: qa_scorecard_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_qa_scorecard_client_stub.call_count
      end
    end
  end

  def test_get_qa_scorecard
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaScorecard.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_qa_scorecard_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_qa_scorecard_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_qa_scorecard_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_qa_scorecard({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_qa_scorecard name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_qa_scorecard ::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_qa_scorecard({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_qa_scorecard(::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_qa_scorecard_client_stub.call_count
      end
    end
  end

  def test_update_qa_scorecard
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaScorecard.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    qa_scorecard = {}
    update_mask = {}

    update_qa_scorecard_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_qa_scorecard_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_qa_scorecard_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_qa_scorecard({ qa_scorecard: qa_scorecard, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_qa_scorecard qa_scorecard: qa_scorecard, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_qa_scorecard ::Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest.new(qa_scorecard: qa_scorecard, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_qa_scorecard({ qa_scorecard: qa_scorecard, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_qa_scorecard(::Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest.new(qa_scorecard: qa_scorecard, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_qa_scorecard_client_stub.call_count
      end
    end
  end

  def test_delete_qa_scorecard
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_qa_scorecard_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_qa_scorecard_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_qa_scorecard_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_qa_scorecard({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_qa_scorecard name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_qa_scorecard ::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_qa_scorecard({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_qa_scorecard(::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_qa_scorecard_client_stub.call_count
      end
    end
  end

  def test_list_qa_scorecards
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_qa_scorecards_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_qa_scorecards_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_qa_scorecards_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_qa_scorecards({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_qa_scorecards parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_qa_scorecards ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_qa_scorecards({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_qa_scorecards(::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_qa_scorecards_client_stub.call_count
      end
    end
  end

  def test_create_qa_scorecard_revision
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    qa_scorecard_revision = {}
    qa_scorecard_revision_id = "hello world"

    create_qa_scorecard_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_qa_scorecard_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_qa_scorecard_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_qa_scorecard_revision({ parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_qa_scorecard_revision parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest.new(parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_qa_scorecard_revision({ parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest.new(parent: parent, qa_scorecard_revision: qa_scorecard_revision, qa_scorecard_revision_id: qa_scorecard_revision_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_qa_scorecard_revision_client_stub.call_count
      end
    end
  end

  def test_get_qa_scorecard_revision
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_qa_scorecard_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_qa_scorecard_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_qa_scorecard_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_qa_scorecard_revision({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_qa_scorecard_revision name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_qa_scorecard_revision({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_qa_scorecard_revision_client_stub.call_count
      end
    end
  end

  def test_tune_qa_scorecard_revision
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    validate_only = true

    tune_qa_scorecard_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_tune_qa_scorecard_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, tune_qa_scorecard_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.tune_qa_scorecard_revision({ parent: parent, filter: filter, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.tune_qa_scorecard_revision parent: parent, filter: filter, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.tune_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest.new(parent: parent, filter: filter, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.tune_qa_scorecard_revision({ parent: parent, filter: filter, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.tune_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest.new(parent: parent, filter: filter, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, tune_qa_scorecard_revision_client_stub.call_count
      end
    end
  end

  def test_deploy_qa_scorecard_revision
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    deploy_qa_scorecard_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_deploy_qa_scorecard_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, deploy_qa_scorecard_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.deploy_qa_scorecard_revision({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.deploy_qa_scorecard_revision name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.deploy_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.deploy_qa_scorecard_revision({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.deploy_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, deploy_qa_scorecard_revision_client_stub.call_count
      end
    end
  end

  def test_undeploy_qa_scorecard_revision
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undeploy_qa_scorecard_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_undeploy_qa_scorecard_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undeploy_qa_scorecard_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undeploy_qa_scorecard_revision({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undeploy_qa_scorecard_revision name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undeploy_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undeploy_qa_scorecard_revision({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undeploy_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undeploy_qa_scorecard_revision_client_stub.call_count
      end
    end
  end

  def test_delete_qa_scorecard_revision
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_qa_scorecard_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_qa_scorecard_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_qa_scorecard_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_qa_scorecard_revision({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_qa_scorecard_revision name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_qa_scorecard_revision ::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_qa_scorecard_revision({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_qa_scorecard_revision(::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_qa_scorecard_revision_client_stub.call_count
      end
    end
  end

  def test_list_qa_scorecard_revisions
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_qa_scorecard_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_qa_scorecard_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_qa_scorecard_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_qa_scorecard_revisions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_qa_scorecard_revisions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_qa_scorecard_revisions ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_qa_scorecard_revisions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_qa_scorecard_revisions(::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_qa_scorecard_revisions_client_stub.call_count
      end
    end
  end

  def test_create_feedback_label
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    feedback_label_id = "hello world"
    feedback_label = {}

    create_feedback_label_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_create_feedback_label_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_feedback_label_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_feedback_label({ parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_feedback_label parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_feedback_label ::Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest.new(parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_feedback_label({ parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_feedback_label(::Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest.new(parent: parent, feedback_label_id: feedback_label_id, feedback_label: feedback_label), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_feedback_label_client_stub.call_count
      end
    end
  end

  def test_list_feedback_labels
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_feedback_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_feedback_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_feedback_labels_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_feedback_labels({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_feedback_labels parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_feedback_labels ::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_feedback_labels({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_feedback_labels(::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_feedback_labels_client_stub.call_count
      end
    end
  end

  def test_get_feedback_label
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_feedback_label_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_get_feedback_label_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_feedback_label_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_feedback_label({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_feedback_label name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_feedback_label ::Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_feedback_label({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_feedback_label(::Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_feedback_label_client_stub.call_count
      end
    end
  end

  def test_update_feedback_label
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feedback_label = {}
    update_mask = {}

    update_feedback_label_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_update_feedback_label_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_feedback_label_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_feedback_label({ feedback_label: feedback_label, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_feedback_label feedback_label: feedback_label, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_feedback_label ::Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest.new(feedback_label: feedback_label, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_feedback_label({ feedback_label: feedback_label, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_feedback_label(::Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest.new(feedback_label: feedback_label, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_feedback_label_client_stub.call_count
      end
    end
  end

  def test_delete_feedback_label
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_feedback_label_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_delete_feedback_label_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_feedback_label_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_feedback_label({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_feedback_label name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_feedback_label ::Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_feedback_label({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_feedback_label(::Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_feedback_label_client_stub.call_count
      end
    end
  end

  def test_list_all_feedback_labels
    # Create test objects.
    client_result = ::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_all_feedback_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_list_all_feedback_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_all_feedback_labels_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_all_feedback_labels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_all_feedback_labels parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_all_feedback_labels ::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_all_feedback_labels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_all_feedback_labels(::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_all_feedback_labels_client_stub.call_count
      end
    end
  end

  def test_bulk_upload_feedback_labels
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    parent = "hello world"
    validate_only = true

    bulk_upload_feedback_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_bulk_upload_feedback_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_upload_feedback_labels_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_upload_feedback_labels({ gcs_source: gcs_source, parent: parent, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_upload_feedback_labels gcs_source: gcs_source, parent: parent, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_upload_feedback_labels ::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest.new(gcs_source: gcs_source, parent: parent, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_upload_feedback_labels({ gcs_source: gcs_source, parent: parent, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_upload_feedback_labels(::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest.new(gcs_source: gcs_source, parent: parent, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_upload_feedback_labels_client_stub.call_count
      end
    end
  end

  def test_bulk_download_feedback_labels
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_destination = {}
    parent = "hello world"
    filter = "hello world"
    max_download_count = 42
    feedback_label_type = :FEEDBACK_LABEL_TYPE_UNSPECIFIED
    conversation_filter = "hello world"
    template_qa_scorecard_id = ["hello world"]

    bulk_download_feedback_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.stub :transcode_bulk_download_feedback_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_download_feedback_labels_client_stub do
        # Create client
        client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_download_feedback_labels({ gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_download_feedback_labels gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_download_feedback_labels ::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest.new(gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_download_feedback_labels({ gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_download_feedback_labels(::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest.new(gcs_destination: gcs_destination, parent: parent, filter: filter, max_download_count: max_download_count, feedback_label_type: feedback_label_type, conversation_filter: conversation_filter, template_qa_scorecard_id: template_qa_scorecard_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_download_feedback_labels_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client::Configuration, config
  end
end
