# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ContactCenterInsights
      module V1
        # The request for calculating conversation statistics.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The location of the conversations.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter to reduce results to a specific subset. This field is useful for
        #     getting statistics about conversations with specific properties.
        class CalculateStatsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for calculating conversation statistics.
        # @!attribute [rw] average_duration
        #   @return [::Google::Protobuf::Duration]
        #     The average duration of all conversations. The average is calculated using
        #     only conversations that have a time duration.
        # @!attribute [rw] average_turn_count
        #   @return [::Integer]
        #     The average number of turns per conversation.
        # @!attribute [rw] conversation_count
        #   @return [::Integer]
        #     The total number of conversations.
        # @!attribute [rw] smart_highlighter_matches
        #   @return [::Google::Protobuf::Map{::String => ::Integer}]
        #     A map associating each smart highlighter display name with its respective
        #     number of matches in the set of conversations.
        # @!attribute [rw] custom_highlighter_matches
        #   @return [::Google::Protobuf::Map{::String => ::Integer}]
        #     A map associating each custom highlighter resource name with its respective
        #     number of matches in the set of conversations.
        # @!attribute [rw] issue_matches
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Protobuf::Map{::String => ::Integer}]
        #     A map associating each issue resource name with its respective number of
        #     matches in the set of conversations. Key has the format:
        #     `projects/<Project-ID>/locations/<Location-ID>/issueModels/<Issue-Model-ID>/issues/<Issue-ID>`
        #     Deprecated, use `issue_matches_stats` field instead.
        # @!attribute [rw] issue_matches_stats
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ContactCenterInsights::V1::IssueModelLabelStats::IssueStats}]
        #     A map associating each issue resource name with its respective number of
        #     matches in the set of conversations. Key has the format:
        #     `projects/<Project-ID>/locations/<Location-ID>/issueModels/<Issue-Model-ID>/issues/<Issue-ID>`
        # @!attribute [rw] conversation_count_time_series
        #   @return [::Google::Cloud::ContactCenterInsights::V1::CalculateStatsResponse::TimeSeries]
        #     A time series representing the count of conversations created over time
        #     that match that requested filter criteria.
        class CalculateStatsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A time series representing conversations over time.
          # @!attribute [rw] interval_duration
          #   @return [::Google::Protobuf::Duration]
          #     The duration of each interval.
          # @!attribute [rw] points
          #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::CalculateStatsResponse::TimeSeries::Interval>]
          #     An ordered list of intervals from earliest to latest, where each interval
          #     represents the number of conversations that transpired during the time
          #     window.
          class TimeSeries
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A single interval in a time series.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The start time of this interval.
            # @!attribute [rw] conversation_count
            #   @return [::Integer]
            #     The number of conversations created in this interval.
            class Interval
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Integer]
          class SmartHighlighterMatchesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Integer]
          class CustomHighlighterMatchesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Integer]
          class IssueMatchesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ContactCenterInsights::V1::IssueModelLabelStats::IssueStats]
          class IssueMatchesStatsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata for a create analysis operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] conversation
        #   @return [::String]
        #     Output only. The Conversation that this Analysis Operation belongs to.
        # @!attribute [r] annotator_selector
        #   @return [::Google::Cloud::ContactCenterInsights::V1::AnnotatorSelector]
        #     Output only. The annotator selector used for the analysis (if any).
        class CreateAnalysisOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to create a conversation.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the conversation.
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Conversation]
        #     Required. The conversation resource to create.
        # @!attribute [rw] conversation_id
        #   @return [::String]
        #     A unique ID for the new conversation. This ID will become the final
        #     component of the conversation's resource name. If no ID is specified, a
        #     server-generated ID will be used.
        #
        #     This value should be 4-64 characters and must match the regular
        #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
        class CreateConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to upload a conversation.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the conversation.
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Conversation]
        #     Required. The conversation resource to create.
        # @!attribute [rw] conversation_id
        #   @return [::String]
        #     Optional. A unique ID for the new conversation. This ID will become the
        #     final component of the conversation's resource name. If no ID is specified,
        #     a server-generated ID will be used.
        #
        #     This value should be 4-64 characters and must match the regular
        #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
        # @!attribute [rw] redaction_config
        #   @return [::Google::Cloud::ContactCenterInsights::V1::RedactionConfig]
        #     Optional. DLP settings for transcript redaction. Will default to the config
        #     specified in Settings.
        # @!attribute [rw] speech_config
        #   @return [::Google::Cloud::ContactCenterInsights::V1::SpeechConfig]
        #     Optional. Speech-to-Text configuration. Will default to the config
        #     specified in Settings.
        class UploadConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata for an `UploadConversation` operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest]
        #     Output only. The original request.
        # @!attribute [r] analysis_operation
        #   @return [::String]
        #     Output only. The operation name for a successfully created analysis
        #     operation, if any.
        # @!attribute [r] applied_redaction_config
        #   @return [::Google::Cloud::ContactCenterInsights::V1::RedactionConfig]
        #     Output only. The redaction config applied to the uploaded conversation.
        class UploadConversationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list conversations.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the conversation.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of conversations to return in the response. A valid page
        #     size ranges from 0 to 100,000 inclusive. If the page size is zero or
        #     unspecified, a default page size of 100 will be chosen. Note that a call
        #     might return fewer results than the requested page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListConversationsResponse`. This value
        #     indicates that this is a continuation of a prior `ListConversations` call
        #     and that the system should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter to reduce results to a specific subset. Useful for querying
        #     conversations with specific properties.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The attribute by which to order conversations in the response.
        #     If empty, conversations will be ordered by descending creation time.
        #     Supported values are one of the following:
        #
        #     * create_time
        #     * customer_satisfaction_rating
        #     * duration
        #     * latest_analysis
        #     * start_time
        #     * turn_count
        #
        #     The default sort order is ascending. To specify order, append `asc` or
        #     `desc` (`create_time desc`).
        #     For more details, see [Google AIPs
        #     Ordering](https://google.aip.dev/132#ordering).
        # @!attribute [rw] view
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ConversationView]
        #     The level of details of the conversation. Default is `BASIC`.
        class ListConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response of listing conversations.
        # @!attribute [rw] conversations
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::Conversation>]
        #     The conversations that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which can be sent as `page_token` to retrieve the next page. If
        #     this field is set, it means there is another page available. If it is not
        #     set, it means no other pages are available.
        class ListConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get a conversation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the conversation to get.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ConversationView]
        #     The level of details of the conversation. Default is `FULL`.
        class GetConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update a conversation.
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Conversation]
        #     Required. The new values for the conversation.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. All possible fields can be updated by
        #     passing `*`, or a subset of the following updateable fields can be
        #     provided:
        #
        #     * `agent_id`
        #     * `language_code`
        #     * `labels`
        #     * `metadata`
        #     * `quality_metadata`
        #     * `call_metadata`
        #     * `start_time`
        #     * `expire_time` or `ttl`
        #     * `data_source.gcs_source.audio_uri` or
        #     `data_source.dialogflow_source.audio_uri`
        class UpdateConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a conversation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the conversation to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, all of this conversation's analyses will also be deleted.
        #     Otherwise, the request will only succeed if the conversation has no
        #     analyses.
        class DeleteConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to ingest conversations.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::GcsSource]
        #     A cloud storage bucket source. Note that any previously ingested objects
        #     from the source will be skipped to avoid duplication.
        # @!attribute [rw] transcript_object_config
        #   @return [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::TranscriptObjectConfig]
        #     Configuration for when `source` contains conversation transcripts.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for new conversations.
        # @!attribute [rw] conversation_config
        #   @return [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::ConversationConfig]
        #     Configuration that applies to all conversations.
        # @!attribute [rw] redaction_config
        #   @return [::Google::Cloud::ContactCenterInsights::V1::RedactionConfig]
        #     Optional. DLP settings for transcript redaction. Optional, will default to
        #     the config specified in Settings.
        # @!attribute [rw] speech_config
        #   @return [::Google::Cloud::ContactCenterInsights::V1::SpeechConfig]
        #     Optional. Default Speech-to-Text configuration. Optional, will default to
        #     the config specified in Settings.
        # @!attribute [rw] sample_size
        #   @return [::Integer]
        #     Optional. If set, this fields indicates the number of objects to ingest
        #     from the Cloud Storage bucket. If empty, the entire bucket will be
        #     ingested. Unless they are first deleted, conversations produced through
        #     sampling won't be ingested by subsequent ingest requests.
        class IngestConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for Cloud Storage bucket sources.
          # @!attribute [rw] bucket_uri
          #   @return [::String]
          #     Required. The Cloud Storage bucket containing source objects.
          # @!attribute [rw] bucket_object_type
          #   @return [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::GcsSource::BucketObjectType]
          #     Optional. Specifies the type of the objects in `bucket_uri`.
          # @!attribute [rw] metadata_bucket_uri
          #   @return [::String]
          #     Optional. The Cloud Storage path to the conversation metadata. Note that:
          #     [1] Metadata files are expected to be in JSON format.
          #     [2] Metadata and source files (transcripts or audio) must be in
          #         separate buckets.
          #     [3] A source file and its corresponding metadata file must share the same
          #     name to
          #         be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
          #         `gs://bucket/metadata/conversation1.json`.
          # @!attribute [rw] custom_metadata_keys
          #   @return [::Array<::String>]
          #     Optional. Custom keys to extract as conversation labels from metadata
          #     files in `metadata_bucket_uri`. Keys not included in this field will be
          #     ignored. Note that there is a limit of 100 labels per conversation.
          class GcsSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            module BucketObjectType
              # The object type is unspecified and will default to `TRANSCRIPT`.
              BUCKET_OBJECT_TYPE_UNSPECIFIED = 0

              # The object is a transcript.
              TRANSCRIPT = 1

              # The object is an audio file.
              AUDIO = 2
            end
          end

          # Configuration for processing transcript objects.
          # @!attribute [rw] medium
          #   @return [::Google::Cloud::ContactCenterInsights::V1::Conversation::Medium]
          #     Required. The medium transcript objects represent.
          class TranscriptObjectConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration that applies to all conversations.
          # @!attribute [rw] agent_id
          #   @return [::String]
          #     Optional. An opaque, user-specified string representing a human agent who
          #     handled all conversations in the import. Note that this will be
          #     overridden if per-conversation metadata is provided through the
          #     `metadata_bucket_uri`.
          # @!attribute [rw] agent_channel
          #   @return [::Integer]
          #     Optional. Indicates which of the channels, 1 or 2, contains the agent.
          #     Note that this must be set for conversations to be properly displayed and
          #     analyzed.
          # @!attribute [rw] customer_channel
          #   @return [::Integer]
          #     Optional. Indicates which of the channels, 1 or 2, contains the agent.
          #     Note that this must be set for conversations to be properly displayed and
          #     analyzed.
          class ConversationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The metadata for an IngestConversations operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest]
        #     Output only. The original request for ingest.
        # @!attribute [r] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. Partial errors during ingest operation that might cause the
        #     operation output to be incomplete.
        # @!attribute [r] ingest_conversations_stats
        #   @return [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsMetadata::IngestConversationsStats]
        #     Output only. Statistics for IngestConversations operation.
        class IngestConversationsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Statistics for IngestConversations operation.
          # @!attribute [r] processed_object_count
          #   @return [::Integer]
          #     Output only. The number of objects processed during the ingest operation.
          # @!attribute [r] duplicates_skipped_count
          #   @return [::Integer]
          #     Output only. The number of objects skipped because another conversation
          #     with the same transcript uri had already been ingested.
          # @!attribute [r] successful_ingest_count
          #   @return [::Integer]
          #     Output only. The number of new conversations added during this ingest
          #     operation.
          # @!attribute [r] failed_ingest_count
          #   @return [::Integer]
          #     Output only. The number of objects which were unable to be ingested due
          #     to errors. The errors are populated in the partial_errors field.
          class IngestConversationsStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response to an IngestConversations operation.
        class IngestConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create an analysis.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the analysis.
        # @!attribute [rw] analysis
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Analysis]
        #     Required. The analysis to create.
        class CreateAnalysisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list analyses.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the analyses.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of analyses to return in the response. If this
        #     value is zero, the service will select a default size. A call might return
        #     fewer objects than requested. A non-empty `next_page_token` in the response
        #     indicates that more data is available.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListAnalysesResponse`; indicates
        #     that this is a continuation of a prior `ListAnalyses` call and
        #     the system should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter to reduce results to a specific subset. Useful for querying
        #     conversations with specific properties.
        class ListAnalysesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to list analyses.
        # @!attribute [rw] analyses
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::Analysis>]
        #     The analyses that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAnalysesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get an analysis.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the analysis to get.
        class GetAnalysisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete an analysis.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the analysis to delete.
        class DeleteAnalysisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to analyze conversations in bulk.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource to create analyses in.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. Filter used to select the subset of conversations to analyze.
        # @!attribute [rw] analysis_percentage
        #   @return [::Float]
        #     Required. Percentage of selected conversation to analyze, between
        #     [0, 100].
        # @!attribute [rw] annotator_selector
        #   @return [::Google::Cloud::ContactCenterInsights::V1::AnnotatorSelector]
        #     To select the annotators to run and the phrase matchers to use
        #     (if any). If not specified, all annotators will be run.
        class BulkAnalyzeConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata for a bulk analyze conversations operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest]
        #     The original request for bulk analyze.
        # @!attribute [rw] completed_analyses_count
        #   @return [::Integer]
        #     The number of requested analyses that have completed successfully so far.
        # @!attribute [rw] failed_analyses_count
        #   @return [::Integer]
        #     The number of requested analyses that have failed so far.
        # @!attribute [rw] total_requested_analyses_count
        #   @return [::Integer]
        #     Total number of analyses requested. Computed by the number of conversations
        #     returned by `filter` multiplied by `analysis_percentage` in the request.
        # @!attribute [r] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. Partial errors during bulk analyze operation that might cause
        #     the operation output to be incomplete.
        class BulkAnalyzeConversationsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for a bulk analyze conversations operation.
        # @!attribute [rw] successful_analysis_count
        #   @return [::Integer]
        #     Count of successful analyses.
        # @!attribute [rw] failed_analysis_count
        #   @return [::Integer]
        #     Count of failed analyses.
        class BulkAnalyzeConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete conversations in bulk.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource to delete conversations from.
        #     Format:
        #     projects/\\{project}/locations/\\{location}
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter used to select the subset of conversations to delete.
        # @!attribute [rw] max_delete_count
        #   @return [::Integer]
        #     Maximum number of conversations to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, all of this conversation's analyses will also be deleted.
        #     Otherwise, the request will only succeed if the conversation has no
        #     analyses.
        class BulkDeleteConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata for a bulk delete conversations operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest]
        #     The original request for bulk delete.
        # @!attribute [rw] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Partial errors during bulk delete conversations operation that might cause
        #     the operation output to be incomplete.
        class BulkDeleteConversationsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for a bulk delete conversations operation.
        class BulkDeleteConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to export insights.
        # @!attribute [rw] big_query_destination
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest::BigQueryDestination]
        #     Specified if sink is a BigQuery table.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource to export data from.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter to reduce results to a specific subset. Useful for exporting
        #     conversations with specific properties.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     A fully qualified KMS key name for BigQuery tables protected by CMEK.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/keyRings/\\{keyring}/cryptoKeys/\\{key}/cryptoKeyVersions/\\{version}
        # @!attribute [rw] write_disposition
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest::WriteDisposition]
        #     Options for what to do if the destination table already exists.
        class ExportInsightsDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A BigQuery Table Reference.
          # @!attribute [rw] project_id
          #   @return [::String]
          #     A project ID or number. If specified, then export will attempt to
          #     write data to this project instead of the resource project. Otherwise,
          #     the resource project will be used.
          # @!attribute [rw] dataset
          #   @return [::String]
          #     Required. The name of the BigQuery dataset that the snapshot result
          #     should be exported to. If this dataset does not exist, the export call
          #     returns an INVALID_ARGUMENT error.
          # @!attribute [rw] table
          #   @return [::String]
          #     The BigQuery table name to which the insights data should be written.
          #     If this table does not exist, the export call returns an INVALID_ARGUMENT
          #     error.
          class BigQueryDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies the action that occurs if the destination table already exists.
          module WriteDisposition
            # Write disposition is not specified. Defaults to WRITE_TRUNCATE.
            WRITE_DISPOSITION_UNSPECIFIED = 0

            # If the table already exists, BigQuery will overwrite the table data and
            # use the schema from the load.
            WRITE_TRUNCATE = 1

            # If the table already exists, BigQuery will append data to the table.
            WRITE_APPEND = 2
          end
        end

        # Metadata for an export insights operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest]
        #     The original request for export.
        # @!attribute [rw] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Partial errors during export operation that might cause the operation
        #     output to be incomplete.
        class ExportInsightsDataMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for an export insights operation.
        class ExportInsightsDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create an issue model.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the issue model.
        # @!attribute [rw] issue_model
        #   @return [::Google::Cloud::ContactCenterInsights::V1::IssueModel]
        #     Required. The issue model to create.
        class CreateIssueModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for creating an issue model.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest]
        #     The original request for creation.
        class CreateIssueModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update an issue model.
        # @!attribute [rw] issue_model
        #   @return [::Google::Cloud::ContactCenterInsights::V1::IssueModel]
        #     Required. The new values for the issue model.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdateIssueModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list issue models.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the issue model.
        class ListIssueModelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response of listing issue models.
        # @!attribute [rw] issue_models
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::IssueModel>]
        #     The issue models that match the request.
        class ListIssueModelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get an issue model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the issue model to get.
        class GetIssueModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete an issue model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the issue model to delete.
        class DeleteIssueModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for deleting an issue model.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest]
        #     The original request for deletion.
        class DeleteIssueModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to deploy an issue model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The issue model to deploy.
        class DeployIssueModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to deploy an issue model.
        class DeployIssueModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for deploying an issue model.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest]
        #     The original request for deployment.
        class DeployIssueModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to undeploy an issue model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The issue model to undeploy.
        class UndeployIssueModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to undeploy an issue model.
        class UndeployIssueModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for undeploying an issue model.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest]
        #     The original request for undeployment.
        class UndeployIssueModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to export an issue model.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest::GcsDestination]
        #     Google Cloud Storage URI to export the issue model to.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The issue model to export.
        class ExportIssueModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Google Cloud Storage Object URI to save the issue model to.
          # @!attribute [rw] object_uri
          #   @return [::String]
          #     Required. Format: `gs://<bucket-name>/<object-name>`
          class GcsDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response from export issue model
        class ExportIssueModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata used for export issue model.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest]
        #     The original export request.
        class ExportIssueModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to import an issue model.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest::GcsSource]
        #     Google Cloud Storage source message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the issue model.
        # @!attribute [rw] create_new_model
        #   @return [::Boolean]
        #     Optional. If set to true, will create an issue model from the imported file
        #     with randomly generated IDs for the issue model and corresponding issues.
        #     Otherwise, replaces an existing model with the same ID as the file.
        class ImportIssueModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Google Cloud Storage Object URI to get the issue model file from.
          # @!attribute [rw] object_uri
          #   @return [::String]
          #     Required. Format: `gs://<bucket-name>/<object-name>`
          class GcsSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response from import issue model
        class ImportIssueModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata used for import issue model.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation finished running.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest]
        #     The original import request.
        class ImportIssueModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get an issue.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the issue to get.
        class GetIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list issues.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the issue.
        class ListIssuesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response of listing issues.
        # @!attribute [rw] issues
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::Issue>]
        #     The issues that match the request.
        class ListIssuesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update an issue.
        # @!attribute [rw] issue
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Issue]
        #     Required. The new values for the issue.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdateIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete an issue.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the issue to delete.
        class DeleteIssueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get statistics of an issue model.
        # @!attribute [rw] issue_model
        #   @return [::String]
        #     Required. The resource name of the issue model to query against.
        class CalculateIssueModelStatsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of querying an issue model's statistics.
        # @!attribute [rw] current_stats
        #   @return [::Google::Cloud::ContactCenterInsights::V1::IssueModelLabelStats]
        #     The latest label statistics for the queried issue model. Includes results
        #     on both training data and data labeled after deployment.
        class CalculateIssueModelStatsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to create a phrase matcher.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the phrase matcher. Required. The location
        #     to create a phrase matcher for. Format: `projects/<Project
        #     ID>/locations/<Location ID>` or `projects/<Project
        #     Number>/locations/<Location ID>`
        # @!attribute [rw] phrase_matcher
        #   @return [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher]
        #     Required. The phrase matcher resource to create.
        class CreatePhraseMatcherRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list phrase matchers.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the phrase matcher.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of phrase matchers to return in the response. If this
        #     value is zero, the service will select a default size. A call might return
        #     fewer objects than requested. A non-empty `next_page_token` in the response
        #     indicates that more data is available.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListPhraseMatchersResponse`. This value
        #     indicates that this is a continuation of a prior `ListPhraseMatchers` call
        #     and that the system should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter to reduce results to a specific subset. Useful for querying
        #     phrase matchers with specific properties.
        class ListPhraseMatchersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response of listing phrase matchers.
        # @!attribute [rw] phrase_matchers
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher>]
        #     The phrase matchers that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListPhraseMatchersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get a a phrase matcher.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the phrase matcher to get.
        class GetPhraseMatcherRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a phrase matcher.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the phrase matcher to delete.
        class DeletePhraseMatcherRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update a phrase matcher.
        # @!attribute [rw] phrase_matcher
        #   @return [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher]
        #     Required. The new values for the phrase matcher.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdatePhraseMatcherRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get project-level settings.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the settings resource to get.
        class GetSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update project-level settings.
        # @!attribute [rw] settings
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Settings]
        #     Required. The new settings values.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated.
        class UpdateSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create a analysis rule.
        # analysis_rule_id will be generated by the server.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the analysis rule. Required. The location
        #     to create a analysis rule for. Format: `projects/<Project
        #     ID>/locations/<Location ID>` or `projects/<Project
        #     Number>/locations/<Location ID>`
        # @!attribute [rw] analysis_rule
        #   @return [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule]
        #     Required. The analysis rule resource to create.
        class CreateAnalysisRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for getting a analysis rule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the AnalysisRule to get.
        class GetAnalysisRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update a analysis rule.
        # @!attribute [rw] analysis_rule
        #   @return [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule]
        #     Required. The new analysis rule.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to be updated.
        #     If the update_mask is not provided, the update will be applied to all
        #     fields.
        class UpdateAnalysisRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a analysis rule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the analysis rule to delete.
        class DeleteAnalysisRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list analysis rules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the analysis rules.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of analysis rule to return in the response. If
        #     this value is zero, the service will select a default size. A call may
        #     return fewer objects than requested. A non-empty `next_page_token` in the
        #     response indicates that more data is available.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListAnalysisRulesResponse`;
        #     indicates that this is a continuation of a prior `ListAnalysisRules` call
        #     and the system should return the next page of data.
        class ListAnalysisRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response of listing views.
        # @!attribute [rw] analysis_rules
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::AnalysisRule>]
        #     The analysis_rule that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAnalysisRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get location-level encryption specification.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the encryption spec resource to get.
        class GetEncryptionSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to initialize a location-level encryption specification.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::ContactCenterInsights::V1::EncryptionSpec]
        #     Required. The encryption spec used for CMEK encryption. It is required that
        #     the kms key is in the same region as the endpoint. The same key will be
        #     used for all provisioned resources, if encryption is available. If the
        #     `kms_key_name` field is left empty, no encryption will be enforced.
        class InitializeEncryptionSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to initialize a location-level encryption specification.
        class InitializeEncryptionSpecResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for initializing a location-level encryption specification.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest]
        #     Output only. The original request for initialization.
        # @!attribute [rw] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Partial errors during initializing operation that might cause the operation
        #     output to be incomplete.
        class InitializeEncryptionSpecMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create a view.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the view. Required. The location to create
        #     a view for.
        #     Format: `projects/<Project ID>/locations/<Location ID>` or
        #     `projects/<Project Number>/locations/<Location ID>`
        # @!attribute [rw] view
        #   @return [::Google::Cloud::ContactCenterInsights::V1::View]
        #     Required. The view resource to create.
        class CreateViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get a view.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the view to get.
        class GetViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list views.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the views.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of views to return in the response. If this
        #     value is zero, the service will select a default size. A call may return
        #     fewer objects than requested. A non-empty `next_page_token` in the response
        #     indicates that more data is available.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListViewsResponse`; indicates
        #     that this is a continuation of a prior `ListViews` call and
        #     the system should return the next page of data.
        class ListViewsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response of listing views.
        # @!attribute [rw] views
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::View>]
        #     The views that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListViewsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update a view.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::ContactCenterInsights::V1::View]
        #     Required. The new view.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdateViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a view.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the view to delete.
        class DeleteViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A dimension determines the grouping key for the query. In SQL terms, these
        # would be part of both the "SELECT" and "GROUP BY" clauses.
        # @!attribute [r] issue_dimension_metadata
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Dimension::IssueDimensionMetadata]
        #     Output only. Metadata about the issue dimension.
        #
        #     Note: The following fields are mutually exclusive: `issue_dimension_metadata`, `agent_dimension_metadata`, `qa_question_dimension_metadata`, `qa_question_answer_dimension_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] agent_dimension_metadata
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Dimension::AgentDimensionMetadata]
        #     Output only. Metadata about the agent dimension.
        #
        #     Note: The following fields are mutually exclusive: `agent_dimension_metadata`, `issue_dimension_metadata`, `qa_question_dimension_metadata`, `qa_question_answer_dimension_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] qa_question_dimension_metadata
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Dimension::QaQuestionDimensionMetadata]
        #     Output only. Metadata about the QA question dimension.
        #
        #     Note: The following fields are mutually exclusive: `qa_question_dimension_metadata`, `issue_dimension_metadata`, `agent_dimension_metadata`, `qa_question_answer_dimension_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] qa_question_answer_dimension_metadata
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Dimension::QaQuestionAnswerDimensionMetadata]
        #     Output only. Metadata about the QA question-answer dimension.
        #
        #     Note: The following fields are mutually exclusive: `qa_question_answer_dimension_metadata`, `issue_dimension_metadata`, `agent_dimension_metadata`, `qa_question_dimension_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] dimension_key
        #   @return [::Google::Cloud::ContactCenterInsights::V1::Dimension::DimensionKey]
        #     The key of the dimension.
        class Dimension
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metadata about the issue dimension.
          # @!attribute [rw] issue_id
          #   @return [::String]
          #     The issue ID.
          # @!attribute [rw] issue_display_name
          #   @return [::String]
          #     The issue display name.
          # @!attribute [rw] issue_model_id
          #   @return [::String]
          #     The parent issue model ID.
          class IssueDimensionMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata about the agent dimension.
          # @!attribute [rw] agent_id
          #   @return [::String]
          #     Optional. A user-specified string representing the agent.
          # @!attribute [rw] agent_display_name
          #   @return [::String]
          #     Optional. The agent's name
          # @!attribute [rw] agent_team
          #   @return [::String]
          #     Optional. A user-specified string representing the agent's team.
          class AgentDimensionMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata about the QA question dimension.
          # @!attribute [rw] qa_scorecard_id
          #   @return [::String]
          #     Optional. The QA scorecard ID.
          # @!attribute [rw] qa_question_id
          #   @return [::String]
          #     Optional. The QA question ID.
          # @!attribute [rw] question_body
          #   @return [::String]
          #     Optional. The full body of the question.
          class QaQuestionDimensionMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata about the QA question-answer dimension.
          # This is useful for showing the answer distribution for questions for a
          # given scorecard.
          # @!attribute [rw] qa_scorecard_id
          #   @return [::String]
          #     Optional. The QA scorecard ID.
          # @!attribute [rw] qa_question_id
          #   @return [::String]
          #     Optional. The QA question ID.
          # @!attribute [rw] question_body
          #   @return [::String]
          #     Optional. The full body of the question.
          # @!attribute [rw] answer_value
          #   @return [::String]
          #     Optional. The full body of the question.
          class QaQuestionAnswerDimensionMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The key of the dimension.
          module DimensionKey
            # The key of the dimension is unspecified.
            DIMENSION_KEY_UNSPECIFIED = 0

            # The dimension is keyed by issues.
            ISSUE = 1

            # The dimension is keyed by agents.
            AGENT = 2

            # The dimension is keyed by agent teams.
            AGENT_TEAM = 3

            # The dimension is keyed by QaQuestionIds.
            # Note that: We only group by the QuestionId and not the revision-id of the
            # scorecard this question is a part of. This allows for showing stats for
            # the same question across different scorecard revisions.
            QA_QUESTION_ID = 4

            # The dimension is keyed by QaQuestionIds-Answer value pairs.
            # Note that: We only group by the QuestionId and not the revision-id of the
            # scorecard this question is a part of. This allows for showing
            # distribution of answers per question across different scorecard
            # revisions.
            QA_QUESTION_ANSWER_VALUE = 5

            # The dimension is keyed by the conversation profile ID.
            CONVERSATION_PROFILE_ID = 6
          end
        end

        # The request for querying metrics.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The location of the data.
        #     "projects/\\{project}/locations/\\{location}"
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. Filter to select a subset of conversations to compute the
        #     metrics. Must specify a window of the conversation create time to compute
        #     the metrics. The returned metrics will be from the range [DATE(starting
        #     create time), DATE(ending create time)).
        # @!attribute [rw] time_granularity
        #   @return [::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest::TimeGranularity]
        #     The time granularity of each data point in the time series.
        #     Defaults to NONE if this field is unspecified.
        # @!attribute [rw] dimensions
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::Dimension>]
        #     The dimensions that determine the grouping key for the query. Defaults to
        #     no dimension if this field is unspecified. If a dimension is specified,
        #     its key must also be specified. Each dimension's key must be unique.
        #
        #     If a time granularity is also specified, metric values in the dimension
        #     will be bucketed by this granularity.
        #
        #     Up to one dimension is supported for now.
        # @!attribute [rw] measure_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Measures to return. Defaults to all measures if this field is unspecified.
        #     A valid mask should traverse from the `measure` field from the response.
        #     For example, a path from a measure mask to get the conversation count is
        #     "conversation_measure.count".
        class QueryMetricsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A time granularity divides the time line into discrete time periods.
          # This is useful for defining buckets over which filtering and aggregation
          # should be performed.
          module TimeGranularity
            # The time granularity is unspecified and will default to NONE.
            TIME_GRANULARITY_UNSPECIFIED = 0

            # No time granularity. The response won't contain a time series.
            # This is the default value if no time granularity is specified.
            NONE = 1

            # Data points in the time series will aggregate at a daily granularity.
            # 1 day means [midnight to midnight).
            DAILY = 2

            # Data points in the time series will aggregate at a daily granularity.
            # 1 HOUR means [01:00 to 02:00).
            HOURLY = 3

            # Data points in the time series will aggregate at a daily granularity.
            # PER_MINUTE means [01:00 to 01:01).
            PER_MINUTE = 4

            # Data points in the time series will aggregate at a 1 minute  granularity.
            # PER_5_MINUTES means [01:00 to 01:05).
            PER_5_MINUTES = 5

            # Data points in the time series will aggregate at a monthly granularity.
            # 1 MONTH means [01st of the month to 1st of the next month).
            MONTHLY = 6
          end
        end

        # The response for querying metrics.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The location of the data.
        #     "projects/\\{project}/locations/\\{location}"
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The metrics last update time.
        # @!attribute [rw] slices
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::QueryMetricsResponse::Slice>]
        #     A slice contains a total and (if the request specified a time granularity)
        #     a time series of metric values. Each slice contains a unique combination of
        #     the cardinality of dimensions from the request.
        # @!attribute [rw] macro_average_slice
        #   @return [::Google::Cloud::ContactCenterInsights::V1::QueryMetricsResponse::Slice]
        #     The macro average slice contains aggregated averages across the selected
        #     dimension. i.e. if group_by agent is specified this field will contain the
        #     average across all agents.
        #     This field is only populated if the request specifies a Dimension.
        class QueryMetricsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A slice contains a total and (if the request specified a time granularity)
          # a time series of metric values. Each slice contains a unique combination of
          # the cardinality of dimensions from the request.
          #
          # For example, if the request specifies a single ISSUE dimension and it has a
          # cardinality of 2 (i.e. the data used to compute the metrics has 2 issues in
          # total), the response will have 2 slices:
          #
          # * Slice 1 -> dimensions=[Issue 1]
          # * Slice 2 -> dimensions=[Issue 2]
          # @!attribute [rw] dimensions
          #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::Dimension>]
          #     A unique combination of dimensions that this slice represents.
          # @!attribute [rw] total
          #   @return [::Google::Cloud::ContactCenterInsights::V1::QueryMetricsResponse::Slice::DataPoint]
          #     The total metric value. The interval of this data point is
          #     [starting create time, ending create time) from the request.
          # @!attribute [rw] time_series
          #   @return [::Google::Cloud::ContactCenterInsights::V1::QueryMetricsResponse::Slice::TimeSeries]
          #     A time series of metric values. This is only populated if the request
          #     specifies a time granularity other than NONE.
          class Slice
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A data point contains the metric values mapped to an interval.
            # @!attribute [rw] conversation_measure
            #   @return [::Google::Cloud::ContactCenterInsights::V1::QueryMetricsResponse::Slice::DataPoint::ConversationMeasure]
            #     The measure related to conversations.
            # @!attribute [rw] interval
            #   @return [::Google::Type::Interval]
            #     The interval that this data point represents.
            #
            #     * If this is the total data point, the interval is
            #     [starting create time, ending create time) from the request.
            #     * If this a data point from the time series, the interval is
            #     [time, time + time granularity from the request).
            class DataPoint
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The measure related to conversations.
              # @!attribute [rw] conversation_count
              #   @return [::Integer]
              #     The conversation count.
              # @!attribute [rw] average_silence_percentage
              #   @return [::Float]
              #     The average silence percentage.
              # @!attribute [rw] average_duration
              #   @return [::Google::Protobuf::Duration]
              #     The average duration.
              # @!attribute [rw] average_turn_count
              #   @return [::Float]
              #     The average turn count.
              # @!attribute [rw] average_agent_sentiment_score
              #   @return [::Float]
              #     The average agent's sentiment score.
              # @!attribute [rw] average_client_sentiment_score
              #   @return [::Float]
              #     The average client's sentiment score.
              # @!attribute [rw] average_customer_satisfaction_rating
              #   @return [::Float]
              #     The average customer satisfaction rating.
              # @!attribute [rw] average_qa_normalized_score
              #   @return [::Float]
              #     Average QA normalized score.
              #     Will exclude 0's in average calculation.
              # @!attribute [rw] qa_tag_scores
              #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::QueryMetricsResponse::Slice::DataPoint::ConversationMeasure::QaTagScore>]
              #     Average QA normalized score for all the tags.
              # @!attribute [rw] average_qa_question_normalized_score
              #   @return [::Float]
              #     Average QA normalized score averaged for questions averaged across
              #     all revisions of the parent scorecard.
              #     Will be only populated if the request specifies a dimension of
              #     QA_QUESTION_ID.
              class ConversationMeasure
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Average QA normalized score for the tag.
                # @!attribute [rw] tag
                #   @return [::String]
                #     Tag name.
                # @!attribute [rw] average_tag_normalized_score
                #   @return [::Float]
                #     Average tag normalized score per tag.
                class QaTagScore
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end
              end
            end

            # A time series of metric values.
            # @!attribute [rw] data_points
            #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::QueryMetricsResponse::Slice::DataPoint>]
            #     The data points that make up the time series .
            class TimeSeries
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # The metadata from querying metrics.
        class QueryMetricsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for creating a QaQuestion.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the QaQuestion.
        # @!attribute [rw] qa_question
        #   @return [::Google::Cloud::ContactCenterInsights::V1::QaQuestion]
        #     Required. The QaQuestion to create.
        # @!attribute [rw] qa_question_id
        #   @return [::String]
        #     Optional. A unique ID for the new question. This ID will become the final
        #     component of the question's resource name. If no ID is specified, a
        #     server-generated ID will be used.
        #
        #     This value should be 4-64 characters and must match the regular
        #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
        class CreateQaQuestionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for a QaQuestion.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the QaQuestion to get.
        class GetQaQuestionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list QaQuestions.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the questions.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of questions to return in the response. If the
        #     value is zero, the service will select a default size. A call might return
        #     fewer objects than requested. A non-empty `next_page_token` in the response
        #     indicates that more data is available.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListQaQuestionsResponse`. This
        #     value indicates that this is a continuation of a prior `ListQaQuestions`
        #     call and that the system should return the next page of data.
        class ListQaQuestionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from a ListQaQuestions request.
        # @!attribute [rw] qa_questions
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::QaQuestion>]
        #     The QaQuestions under the parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListQaQuestionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for updating a QaQuestion.
        # @!attribute [rw] qa_question
        #   @return [::Google::Cloud::ContactCenterInsights::V1::QaQuestion]
        #     Required. The QaQuestion to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. All possible fields can be
        #     updated by passing `*`, or a subset of the following updateable fields can
        #     be provided:
        #
        #     * `abbreviation`
        #     * `answer_choices`
        #     * `answer_instructions`
        #     * `order`
        #     * `question_body`
        #     * `tags`
        class UpdateQaQuestionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for deleting a QaQuestion.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the QaQuestion to delete.
        class DeleteQaQuestionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for creating a QaScorecard.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the QaScorecard.
        # @!attribute [rw] qa_scorecard
        #   @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecard]
        #     Required. The QaScorecard to create.
        # @!attribute [rw] qa_scorecard_id
        #   @return [::String]
        #     Optional. A unique ID for the new QaScorecard. This ID will become the
        #     final component of the QaScorecard's resource name. If no ID is specified,
        #     a server-generated ID will be used.
        #
        #     This value should be 4-64 characters and must match the regular
        #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
        class CreateQaScorecardRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for a QaScorecard. By default, returns the latest revision.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the QaScorecard to get.
        class GetQaScorecardRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for updating a QaScorecard.
        # @!attribute [rw] qa_scorecard
        #   @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecard]
        #     Required. The QaScorecard to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated. All possible fields can be
        #     updated by passing `*`, or a subset of the following updateable fields can
        #     be provided:
        #
        #     * `description`
        #     * `display_name`
        class UpdateQaScorecardRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for deleting a QaScorecard.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the QaScorecard to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, all of this QaScorecard's child resources will
        #     also be deleted. Otherwise, the request will only succeed if it has none.
        class DeleteQaScorecardRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for creating a QaScorecardRevision.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the QaScorecardRevision.
        # @!attribute [rw] qa_scorecard_revision
        #   @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
        #     Required. The QaScorecardRevision to create.
        # @!attribute [rw] qa_scorecard_revision_id
        #   @return [::String]
        #     Optional. A unique ID for the new QaScorecardRevision. This ID will become
        #     the final component of the QaScorecardRevision's resource name. If no ID is
        #     specified, a server-generated ID will be used.
        #
        #     This value should be 4-64 characters and must match the regular
        #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
        class CreateQaScorecardRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for a QaScorecardRevision.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the QaScorecardRevision to get.
        class GetQaScorecardRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for TuneQaScorecardRevision endpoint.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for new fine tuning job instance.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. Filter for selecting the feedback labels that needs to be
        #     used for training.
        #     This filter can be used to limit the feedback labels used for tuning to a
        #     feedback labels created or updated for a specific time-window etc.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Run in validate only mode, no fine tuning will actually run.
        #     Data quality validations like training data distributions will run.
        #     Even when set to false, the data quality validations will still run but
        #     once the validations complete we will proceed with the fine tune, if
        #     applicable.
        class TuneQaScorecardRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for TuneQaScorecardRevision endpoint.
        class TuneQaScorecardRevisionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for TuneQaScorecardRevision endpoint.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest]
        #     Output only. The original request.
        # @!attribute [r] qa_question_dataset_validation_results
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionMetadata::QaQuestionDatasetValidationResult>]
        #     Output only. The results of data validation per question in the request.
        # @!attribute [r] qa_question_dataset_tuning_metrics
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionMetadata::QaQuestionDatasetTuningMetrics>]
        #     Output only. The metrics for each QaQuestion in the TuneScorecardRevision
        #     request.
        # @!attribute [r] tuning_completion_ratio
        #   @return [::Float]
        #     Output only. The percentage of the tuning job that has completed. Always
        #     between 0 and 1 where 0 indicates the job has not started i.e. 0% and 1
        #     indicates the job has completed i.e. 100%.
        class TuneQaScorecardRevisionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains validation results for a question in the tuning request.
          # @!attribute [r] question
          #   @return [::String]
          #     Output only. The resource path of the question whose dataset was
          #     evaluated for tuning.
          # @!attribute [rw] dataset_validation_warnings
          #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::DatasetValidationWarning>]
          #     A list of any applicable data validation warnings about the question's
          #     feedback labels.
          # @!attribute [rw] valid_feedback_labels_count
          #   @return [::Integer]
          #     The number of valid feedback labels in the question's dataset.
          class QaQuestionDatasetValidationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains performance metrics for each QaQuestion in the
          # TuneScorecardRevision request.
          # @!attribute [r] question
          #   @return [::String]
          #     Output only. The resource path of the question whose dataset was
          #     evaluated for tuning.
          # @!attribute [r] metrics
          #   @return [::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionMetadata::QaQuestionDatasetTuningMetrics::Metrics]
          #     Output only. The metrics for the question's dataset.
          class QaQuestionDatasetTuningMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Performance metrics for the question's dataset calculated over the tuned
            # model.
            # @!attribute [rw] accuracy
            #   @return [::Float]
            #     Accuracy of the question's dataset.
            class Metrics
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # The request to deploy a QaScorecardRevision
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the QaScorecardRevision to deploy.
        class DeployQaScorecardRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to undeploy a QaScorecardRevision
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the QaScorecardRevision to undeploy.
        class UndeployQaScorecardRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a QaScorecardRevision.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the QaScorecardRevision to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, all of this QaScorecardRevision's child resources
        #     will also be deleted. Otherwise, the request will only succeed if it has
        #     none.
        class DeleteQaScorecardRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list QaScorecards.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the scorecards.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of scorecards to return in the response. If
        #     the value is zero, the service will select a default size. A call might
        #     return fewer objects than requested. A non-empty `next_page_token` in the
        #     response indicates that more data is available.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListQaScorecardsResponse`. This
        #     value indicates that this is a continuation of a prior `ListQaScorecards`
        #     call and that the system should return the next page of data.
        class ListQaScorecardsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from a ListQaScorecards request.
        # @!attribute [rw] qa_scorecards
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::QaScorecard>]
        #     The QaScorecards under the parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListQaScorecardsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list QaScorecardRevisions
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the scorecard revisions. To list all
        #     revisions of all scorecards, substitute the QaScorecard ID with a '-'
        #     character.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of scorecard revisions to return in the
        #     response. If the value is zero, the service will select a default size. A
        #     call might return fewer objects than requested. A non-empty
        #     `next_page_token` in the response indicates that more data is available.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last
        #     `ListQaScorecardRevisionsResponse`. This value indicates that this is a
        #     continuation of a prior `ListQaScorecardRevisions` call and that the system
        #     should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter to reduce results to a specific subset. Useful for
        #     querying scorecard revisions with specific properties.
        class ListQaScorecardRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from a ListQaScorecardRevisions request.
        # @!attribute [rw] qa_scorecard_revisions
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision>]
        #     The QaScorecards under the parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListQaScorecardRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for creating a feedback label.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the feedback label.
        # @!attribute [rw] feedback_label_id
        #   @return [::String]
        #     Optional. The ID of the feedback label to create.
        #     If one is not specified it will be generated by the server.
        # @!attribute [rw] feedback_label
        #   @return [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel]
        #     Required. The feedback label to create.
        class CreateFeedbackLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for listing feedback labels.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the feedback labels.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter to reduce results to a specific subset. Supports
        #     disjunctions (OR) and conjunctions (AND). Automatically sorts by
        #     conversation ID. To sort by all feedback labels in a project see
        #     ListAllFeedbackLabels.
        #
        #     Supported fields:
        #
        #     * `issue_model_id`
        #     * `qa_question_id`
        #     * `qa_scorecard_id`
        #     * `min_create_time`
        #     * `max_create_time`
        #     * `min_update_time`
        #     * `max_update_time`
        #     * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of feedback labels to return in the response.
        #     A valid page size ranges from 0 to 100,000 inclusive. If the page size is
        #     zero or unspecified, a default page size of 100 will be chosen. Note that a
        #     call might return fewer results than the requested page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListFeedbackLabelsResponse`. This
        #     value indicates that this is a continuation of a prior `ListFeedbackLabels`
        #     call and that the system should return the next page of data.
        class ListFeedbackLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for listing feedback labels.
        # @!attribute [rw] feedback_labels
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel>]
        #     The feedback labels that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token.
        class ListFeedbackLabelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for getting a feedback label.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the feedback label to get.
        class GetFeedbackLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for updating a feedback label.
        # @!attribute [rw] feedback_label
        #   @return [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel]
        #     Required. The feedback label to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to be updated.
        class UpdateFeedbackLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for deleting a feedback label.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the feedback label to delete.
        class DeleteFeedbackLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for listing all feedback labels.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of all feedback labels per project.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of feedback labels to return in the response.
        #     A valid page size ranges from 0 to 100,000 inclusive. If the page size is
        #     zero or unspecified, a default page size of 100 will be chosen. Note that a
        #     call might return fewer results than the requested page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value returned by the last `ListAllFeedbackLabelsResponse`.
        #     This value indicates that this is a continuation of a prior
        #     `ListAllFeedbackLabels` call and that the system should return the next
        #     page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter to reduce results to a specific subset in the entire
        #     project. Supports disjunctions (OR) and conjunctions (AND).
        #
        #     Supported fields:
        #
        #     * `issue_model_id`
        #     * `qa_question_id`
        #     * `min_create_time`
        #     * `max_create_time`
        #     * `min_update_time`
        #     * `max_update_time`
        #     * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
        class ListAllFeedbackLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for listing all feedback labels.
        # @!attribute [rw] feedback_labels
        #   @return [::Array<::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel>]
        #     The feedback labels that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAllFeedbackLabelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for bulk uploading feedback labels.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest::GcsSource]
        #     A cloud storage bucket source.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for new feedback labels.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, upload will not happen and the labels will be validated.
        #     If not set, then default behavior will be to upload the labels after
        #     validation is complete.
        class BulkUploadFeedbackLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Google Cloud Storage Object details to get the feedback label file from.
          # @!attribute [rw] format
          #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest::GcsSource::Format]
          #     Required. File format which will be ingested.
          # @!attribute [rw] object_uri
          #   @return [::String]
          #     Required. The Google Cloud Storage URI of the file to import.
          #     Format: `gs://bucket_name/object_name`
          class GcsSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # All permissible file formats.
            module Format
              # Unspecified format.
              FORMAT_UNSPECIFIED = 0

              # CSV format.
              CSV = 1

              # JSON format.
              JSON = 2
            end
          end
        end

        # Response for the Bulk Upload Feedback Labels API.
        class BulkUploadFeedbackLabelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for the Bulk Upload Feedback Labels API.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest]
        #     Output only. The original request for ingest.
        # @!attribute [rw] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Partial errors during ingest operation that might cause the operation
        #     output to be incomplete.
        # @!attribute [r] upload_stats
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsMetadata::UploadStats]
        #     Output only. Statistics for BulkUploadFeedbackLabels operation.
        class BulkUploadFeedbackLabelsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Statistics for BulkUploadFeedbackLabels operation.
          # @!attribute [rw] processed_object_count
          #   @return [::Integer]
          #     The number of objects processed during the upload operation.
          # @!attribute [rw] failed_validation_count
          #   @return [::Integer]
          #     The number of objects skipped because of failed validation
          # @!attribute [rw] successful_upload_count
          #   @return [::Integer]
          #     The number of new feedback labels added during this ingest operation.
          class UploadStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for the BulkDownloadFeedbackLabel endpoint.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest::GcsDestination]
        #     A cloud storage bucket destination.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for new feedback labels.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter to reduce results to a specific subset. Supports
        #     disjunctions (OR) and conjunctions (AND).
        #
        #     Supported fields:
        #
        #     * `issue_model_id`
        #     * `qa_question_id`
        #     * `qa_scorecard_id`
        #     * `min_create_time`
        #     * `max_create_time`
        #     * `min_update_time`
        #     * `max_update_time`
        #     * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
        # @!attribute [rw] max_download_count
        #   @return [::Integer]
        #     Optional. Limits the maximum number of feedback labels that will be
        #     downloaded. The first `N` feedback labels will be downloaded.
        # @!attribute [rw] feedback_label_type
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest::FeedbackLabelType]
        #     Optional. The type of feedback labels that will be downloaded.
        # @!attribute [rw] conversation_filter
        #   @return [::String]
        #     Optional. Filter parent conversations to download feedback labels for.
        #     When specified, the feedback labels will be downloaded for the
        #     conversations that match the filter.
        #     If `template_qa_scorecard_id` is set, all the conversations that match the
        #     filter will be paired with the questions under the scorecard for labeling.
        # @!attribute [rw] template_qa_scorecard_id
        #   @return [::Array<::String>]
        #     Optional. If set, a template for labeling conversations and scorecard
        #     questions will be created from the conversation_filter and the questions
        #     under the scorecard(s). The feedback label `filter` will be ignored.
        class BulkDownloadFeedbackLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Google Cloud Storage Object details to write the feedback labels to.
          # @!attribute [rw] format
          #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest::GcsDestination::Format]
          #     Required. File format in which the labels will be exported.
          # @!attribute [rw] object_uri
          #   @return [::String]
          #     Required. The Google Cloud Storage URI to write the feedback labels to.
          #     The file name will be used as a prefix for the files written to the
          #     bucket if the output needs to be split across multiple files, otherwise
          #     it will be used as is. The file extension will be appended to the file
          #     name based on the format selected.
          #      E.g. `gs://bucket_name/object_uri_prefix`
          # @!attribute [rw] add_whitespace
          #   @return [::Boolean]
          #     Optional. Add whitespace to the JSON file. Makes easier to read, but
          #     increases file size. Only applicable for JSON format.
          # @!attribute [rw] always_print_empty_fields
          #   @return [::Boolean]
          #     Optional. Always print fields with no presence.
          #     This is useful for printing fields that are not set, like implicit 0
          #     value or empty lists/maps. Only applicable for JSON format.
          # @!attribute [rw] records_per_file_count
          #   @return [::Integer]
          #     Optional. The number of records per file. Applicable for either format.
          class GcsDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # All permissible file formats.
            # See `records_per_file_count` to override the default number of records
            # per file.
            module Format
              # Unspecified format.
              FORMAT_UNSPECIFIED = 0

              # CSV format.
              # 1,000 labels are stored per CSV file by default.
              CSV = 1

              # JSON format.
              # 1 label stored per JSON file by default.
              JSON = 2
            end
          end

          # Possible feedback label types that will be downloaded.
          module FeedbackLabelType
            # Unspecified format
            FEEDBACK_LABEL_TYPE_UNSPECIFIED = 0

            # Downloaded file will contain all Quality AI labels from the latest
            # scorecard revision.
            QUALITY_AI = 1

            # Downloaded file will contain only Topic Modeling labels.
            TOPIC_MODELING = 2
          end
        end

        # Response for the BulkDownloadFeedbackLabel endpoint.
        class BulkDownloadFeedbackLabelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for the BulkDownloadFeedbackLabel endpoint.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] request
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest]
        #     Output only. The original request for download.
        # @!attribute [rw] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Partial errors during ingest operation that might cause the operation
        #     output to be incomplete.
        # @!attribute [r] download_stats
        #   @return [::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsMetadata::DownloadStats]
        #     Output only. Statistics for BulkDownloadFeedbackLabels operation.
        class BulkDownloadFeedbackLabelsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Statistics for BulkDownloadFeedbackLabels operation.
          # @!attribute [rw] processed_object_count
          #   @return [::Integer]
          #     The number of objects processed during the download operation.
          # @!attribute [rw] successful_download_count
          #   @return [::Integer]
          #     The number of new feedback labels downloaded during this operation.
          #     Different from "processed" because some labels might not be downloaded
          #     because an error.
          # @!attribute [rw] total_files_written
          #   @return [::Integer]
          #     Total number of files written to the provided Cloud Storage bucket.
          # @!attribute [r] file_names
          #   @return [::Array<::String>]
          #     Output only. Full name of the files written to Cloud storage.
          class DownloadStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents the options for viewing a conversation.
        module ConversationView
          # The conversation view is not specified.
          #
          # * Defaults to `FULL` in `GetConversationRequest`.
          # * Defaults to `BASIC` in `ListConversationsRequest`.
          CONVERSATION_VIEW_UNSPECIFIED = 0

          # Populates all fields in the conversation.
          FULL = 2

          # Populates all fields in the conversation except the transcript.
          BASIC = 1
        end
      end
    end
  end
end
