# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/contactcenterinsights/v1/contact_center_insights_pb"
require "google/cloud/contact_center_insights/v1/contact_center_insights/rest/service_stub"
require "google/iam/v1/rest"

module Google
  module Cloud
    module ContactCenterInsights
      module V1
        module ContactCenterInsights
          module Rest
            ##
            # REST client for the ContactCenterInsights service.
            #
            # An API that lets users analyze and explore their business conversation data.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "contactcenterinsights.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :contact_center_insights_stub

              ##
              # Configure the ContactCenterInsights Client class.
              #
              # See {::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ContactCenterInsights clients
              #   ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ContactCenterInsights", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ContactCenterInsights Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @contact_center_insights_stub.universe_domain
              end

              ##
              # Create a new ContactCenterInsights REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ContactCenterInsights client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @contact_center_insights_stub = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @contact_center_insights_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @contact_center_insights_stub.endpoint
                  config.universe_domain = @contact_center_insights_stub.universe_domain
                  config.logger = @contact_center_insights_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @contact_center_insights_stub.logger
              end

              # Service calls

              ##
              # Creates a conversation.
              # Note that this method does not support audio transcription or redaction.
              # Use `conversations.upload` instead.
              #
              # @overload create_conversation(request, options = nil)
              #   Pass arguments to `create_conversation` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_conversation(parent: nil, conversation: nil, conversation_id: nil)
              #   Pass arguments to `create_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the conversation.
              #   @param conversation [::Google::Cloud::ContactCenterInsights::V1::Conversation, ::Hash]
              #     Required. The conversation resource to create.
              #   @param conversation_id [::String]
              #     A unique ID for the new conversation. This ID will become the final
              #     component of the conversation's resource name. If no ID is specified, a
              #     server-generated ID will be used.
              #
              #     This value should be 4-64 characters and must match the regular
              #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest.new
              #
              #   # Call the create_conversation method.
              #   result = client.create_conversation request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::Conversation.
              #   p result
              #
              def create_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a long-running conversation upload operation. This method differs
              # from `CreateConversation` by allowing audio transcription and optional DLP
              # redaction.
              #
              # @overload upload_conversation(request, options = nil)
              #   Pass arguments to `upload_conversation` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload upload_conversation(parent: nil, conversation: nil, conversation_id: nil, redaction_config: nil, speech_config: nil)
              #   Pass arguments to `upload_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the conversation.
              #   @param conversation [::Google::Cloud::ContactCenterInsights::V1::Conversation, ::Hash]
              #     Required. The conversation resource to create.
              #   @param conversation_id [::String]
              #     Optional. A unique ID for the new conversation. This ID will become the
              #     final component of the conversation's resource name. If no ID is specified,
              #     a server-generated ID will be used.
              #
              #     This value should be 4-64 characters and must match the regular
              #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
              #   @param redaction_config [::Google::Cloud::ContactCenterInsights::V1::RedactionConfig, ::Hash]
              #     Optional. DLP settings for transcript redaction. Will default to the config
              #     specified in Settings.
              #   @param speech_config [::Google::Cloud::ContactCenterInsights::V1::SpeechConfig, ::Hash]
              #     Optional. Speech-to-Text configuration. Will default to the config
              #     specified in Settings.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest.new
              #
              #   # Call the upload_conversation method.
              #   result = client.upload_conversation request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def upload_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UploadConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.upload_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.upload_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.upload_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.upload_conversation request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a conversation.
              #
              # @overload update_conversation(request, options = nil)
              #   Pass arguments to `update_conversation` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_conversation(conversation: nil, update_mask: nil)
              #   Pass arguments to `update_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param conversation [::Google::Cloud::ContactCenterInsights::V1::Conversation, ::Hash]
              #     Required. The new values for the conversation.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated. All possible fields can be updated by
              #     passing `*`, or a subset of the following updateable fields can be
              #     provided:
              #
              #     * `agent_id`
              #     * `language_code`
              #     * `labels`
              #     * `metadata`
              #     * `quality_metadata`
              #     * `call_metadata`
              #     * `start_time`
              #     * `expire_time` or `ttl`
              #     * `data_source.gcs_source.audio_uri` or
              #     `data_source.dialogflow_source.audio_uri`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest.new
              #
              #   # Call the update_conversation method.
              #   result = client.update_conversation request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::Conversation.
              #   p result
              #
              def update_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a conversation.
              #
              # @overload get_conversation(request, options = nil)
              #   Pass arguments to `get_conversation` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_conversation(name: nil, view: nil)
              #   Pass arguments to `get_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the conversation to get.
              #   @param view [::Google::Cloud::ContactCenterInsights::V1::ConversationView]
              #     The level of details of the conversation. Default is `FULL`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetConversationRequest.new
              #
              #   # Call the get_conversation method.
              #   result = client.get_conversation request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::Conversation.
              #   p result
              #
              def get_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists conversations.
              #
              # @overload list_conversations(request, options = nil)
              #   Pass arguments to `list_conversations` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_conversations(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
              #   Pass arguments to `list_conversations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the conversation.
              #   @param page_size [::Integer]
              #     The maximum number of conversations to return in the response. A valid page
              #     size ranges from 0 to 100,000 inclusive. If the page size is zero or
              #     unspecified, a default page size of 100 will be chosen. Note that a call
              #     might return fewer results than the requested page size.
              #   @param page_token [::String]
              #     The value returned by the last `ListConversationsResponse`. This value
              #     indicates that this is a continuation of a prior `ListConversations` call
              #     and that the system should return the next page of data.
              #   @param filter [::String]
              #     A filter to reduce results to a specific subset. Useful for querying
              #     conversations with specific properties.
              #   @param order_by [::String]
              #     Optional. The attribute by which to order conversations in the response.
              #     If empty, conversations will be ordered by descending creation time.
              #     Supported values are one of the following:
              #
              #     * create_time
              #     * customer_satisfaction_rating
              #     * duration
              #     * latest_analysis
              #     * start_time
              #     * turn_count
              #
              #     The default sort order is ascending. To specify order, append `asc` or
              #     `desc` (`create_time desc`).
              #     For more details, see [Google AIPs
              #     Ordering](https://google.aip.dev/132#ordering).
              #   @param view [::Google::Cloud::ContactCenterInsights::V1::ConversationView]
              #     The level of details of the conversation. Default is `BASIC`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::Conversation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::Conversation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest.new
              #
              #   # Call the list_conversations method.
              #   result = client.list_conversations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::Conversation.
              #     p item
              #   end
              #
              def list_conversations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListConversationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_conversations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_conversations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_conversations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_conversations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_conversations, "conversations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a conversation.
              #
              # @overload delete_conversation(request, options = nil)
              #   Pass arguments to `delete_conversation` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_conversation(name: nil, force: nil)
              #   Pass arguments to `delete_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the conversation to delete.
              #   @param force [::Boolean]
              #     If set to true, all of this conversation's analyses will also be deleted.
              #     Otherwise, the request will only succeed if the conversation has no
              #     analyses.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest.new
              #
              #   # Call the delete_conversation method.
              #   result = client.delete_conversation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an analysis. The long running operation is done when the analysis
              # has completed.
              #
              # @overload create_analysis(request, options = nil)
              #   Pass arguments to `create_analysis` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_analysis(parent: nil, analysis: nil)
              #   Pass arguments to `create_analysis` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the analysis.
              #   @param analysis [::Google::Cloud::ContactCenterInsights::V1::Analysis, ::Hash]
              #     Required. The analysis to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest.new
              #
              #   # Call the create_analysis method.
              #   result = client.create_analysis request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_analysis request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_analysis.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_analysis.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_analysis.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_analysis request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an analysis.
              #
              # @overload get_analysis(request, options = nil)
              #   Pass arguments to `get_analysis` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_analysis(name: nil)
              #   Pass arguments to `get_analysis` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the analysis to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::Analysis]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::Analysis]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest.new
              #
              #   # Call the get_analysis method.
              #   result = client.get_analysis request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::Analysis.
              #   p result
              #
              def get_analysis request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_analysis.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_analysis.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_analysis.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_analysis request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists analyses.
              #
              # @overload list_analyses(request, options = nil)
              #   Pass arguments to `list_analyses` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_analyses(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_analyses` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the analyses.
              #   @param page_size [::Integer]
              #     The maximum number of analyses to return in the response. If this
              #     value is zero, the service will select a default size. A call might return
              #     fewer objects than requested. A non-empty `next_page_token` in the response
              #     indicates that more data is available.
              #   @param page_token [::String]
              #     The value returned by the last `ListAnalysesResponse`; indicates
              #     that this is a continuation of a prior `ListAnalyses` call and
              #     the system should return the next page of data.
              #   @param filter [::String]
              #     A filter to reduce results to a specific subset. Useful for querying
              #     conversations with specific properties.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::Analysis>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::Analysis>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest.new
              #
              #   # Call the list_analyses method.
              #   result = client.list_analyses request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::Analysis.
              #     p item
              #   end
              #
              def list_analyses request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListAnalysesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_analyses.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_analyses.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_analyses.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_analyses request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_analyses, "analyses", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an analysis.
              #
              # @overload delete_analysis(request, options = nil)
              #   Pass arguments to `delete_analysis` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_analysis(name: nil)
              #   Pass arguments to `delete_analysis` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the analysis to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest.new
              #
              #   # Call the delete_analysis method.
              #   result = client.delete_analysis request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_analysis request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_analysis.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_analysis.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_analysis.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_analysis request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Analyzes multiple conversations in a single request.
              #
              # @overload bulk_analyze_conversations(request, options = nil)
              #   Pass arguments to `bulk_analyze_conversations` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload bulk_analyze_conversations(parent: nil, filter: nil, analysis_percentage: nil, annotator_selector: nil)
              #   Pass arguments to `bulk_analyze_conversations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource to create analyses in.
              #   @param filter [::String]
              #     Required. Filter used to select the subset of conversations to analyze.
              #   @param analysis_percentage [::Float]
              #     Required. Percentage of selected conversation to analyze, between
              #     [0, 100].
              #   @param annotator_selector [::Google::Cloud::ContactCenterInsights::V1::AnnotatorSelector, ::Hash]
              #     To select the annotators to run and the phrase matchers to use
              #     (if any). If not specified, all annotators will be run.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest.new
              #
              #   # Call the bulk_analyze_conversations method.
              #   result = client.bulk_analyze_conversations request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def bulk_analyze_conversations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::BulkAnalyzeConversationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.bulk_analyze_conversations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.bulk_analyze_conversations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.bulk_analyze_conversations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.bulk_analyze_conversations request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes multiple conversations in a single request.
              #
              # @overload bulk_delete_conversations(request, options = nil)
              #   Pass arguments to `bulk_delete_conversations` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload bulk_delete_conversations(parent: nil, filter: nil, max_delete_count: nil, force: nil)
              #   Pass arguments to `bulk_delete_conversations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource to delete conversations from.
              #     Format:
              #     projects/\\{project}/locations/\\{location}
              #   @param filter [::String]
              #     Filter used to select the subset of conversations to delete.
              #   @param max_delete_count [::Integer]
              #     Maximum number of conversations to delete.
              #   @param force [::Boolean]
              #     If set to true, all of this conversation's analyses will also be deleted.
              #     Otherwise, the request will only succeed if the conversation has no
              #     analyses.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest.new
              #
              #   # Call the bulk_delete_conversations method.
              #   result = client.bulk_delete_conversations request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def bulk_delete_conversations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::BulkDeleteConversationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.bulk_delete_conversations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.bulk_delete_conversations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.bulk_delete_conversations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.bulk_delete_conversations request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports conversations and processes them according to the user's
              # configuration.
              #
              # @overload ingest_conversations(request, options = nil)
              #   Pass arguments to `ingest_conversations` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload ingest_conversations(gcs_source: nil, transcript_object_config: nil, parent: nil, conversation_config: nil, redaction_config: nil, speech_config: nil, sample_size: nil)
              #   Pass arguments to `ingest_conversations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_source [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::GcsSource, ::Hash]
              #     A cloud storage bucket source. Note that any previously ingested objects
              #     from the source will be skipped to avoid duplication.
              #   @param transcript_object_config [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::TranscriptObjectConfig, ::Hash]
              #     Configuration for when `source` contains conversation transcripts.
              #   @param parent [::String]
              #     Required. The parent resource for new conversations.
              #   @param conversation_config [::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest::ConversationConfig, ::Hash]
              #     Configuration that applies to all conversations.
              #   @param redaction_config [::Google::Cloud::ContactCenterInsights::V1::RedactionConfig, ::Hash]
              #     Optional. DLP settings for transcript redaction. Optional, will default to
              #     the config specified in Settings.
              #   @param speech_config [::Google::Cloud::ContactCenterInsights::V1::SpeechConfig, ::Hash]
              #     Optional. Default Speech-to-Text configuration. Optional, will default to
              #     the config specified in Settings.
              #   @param sample_size [::Integer]
              #     Optional. If set, this fields indicates the number of objects to ingest
              #     from the Cloud Storage bucket. If empty, the entire bucket will be
              #     ingested. Unless they are first deleted, conversations produced through
              #     sampling won't be ingested by subsequent ingest requests.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest.new
              #
              #   # Call the ingest_conversations method.
              #   result = client.ingest_conversations request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def ingest_conversations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::IngestConversationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.ingest_conversations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.ingest_conversations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.ingest_conversations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.ingest_conversations request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Export insights data to a destination defined in the request body.
              #
              # @overload export_insights_data(request, options = nil)
              #   Pass arguments to `export_insights_data` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_insights_data(big_query_destination: nil, parent: nil, filter: nil, kms_key: nil, write_disposition: nil)
              #   Pass arguments to `export_insights_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param big_query_destination [::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest::BigQueryDestination, ::Hash]
              #     Specified if sink is a BigQuery table.
              #   @param parent [::String]
              #     Required. The parent resource to export data from.
              #   @param filter [::String]
              #     A filter to reduce results to a specific subset. Useful for exporting
              #     conversations with specific properties.
              #   @param kms_key [::String]
              #     A fully qualified KMS key name for BigQuery tables protected by CMEK.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/keyRings/\\{keyring}/cryptoKeys/\\{key}/cryptoKeyVersions/\\{version}
              #   @param write_disposition [::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest::WriteDisposition]
              #     Options for what to do if the destination table already exists.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest.new
              #
              #   # Call the export_insights_data method.
              #   result = client.export_insights_data request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_insights_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ExportInsightsDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_insights_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_insights_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_insights_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.export_insights_data request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an issue model.
              #
              # @overload create_issue_model(request, options = nil)
              #   Pass arguments to `create_issue_model` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_issue_model(parent: nil, issue_model: nil)
              #   Pass arguments to `create_issue_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the issue model.
              #   @param issue_model [::Google::Cloud::ContactCenterInsights::V1::IssueModel, ::Hash]
              #     Required. The issue model to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest.new
              #
              #   # Call the create_issue_model method.
              #   result = client.create_issue_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_issue_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateIssueModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_issue_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_issue_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_issue_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_issue_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an issue model.
              #
              # @overload update_issue_model(request, options = nil)
              #   Pass arguments to `update_issue_model` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_issue_model(issue_model: nil, update_mask: nil)
              #   Pass arguments to `update_issue_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param issue_model [::Google::Cloud::ContactCenterInsights::V1::IssueModel, ::Hash]
              #     Required. The new values for the issue model.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::IssueModel]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::IssueModel]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest.new
              #
              #   # Call the update_issue_model method.
              #   result = client.update_issue_model request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::IssueModel.
              #   p result
              #
              def update_issue_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateIssueModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_issue_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_issue_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_issue_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_issue_model request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an issue model.
              #
              # @overload get_issue_model(request, options = nil)
              #   Pass arguments to `get_issue_model` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_issue_model(name: nil)
              #   Pass arguments to `get_issue_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the issue model to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::IssueModel]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::IssueModel]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest.new
              #
              #   # Call the get_issue_model method.
              #   result = client.get_issue_model request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::IssueModel.
              #   p result
              #
              def get_issue_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetIssueModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_issue_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_issue_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_issue_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_issue_model request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists issue models.
              #
              # @overload list_issue_models(request, options = nil)
              #   Pass arguments to `list_issue_models` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_issue_models(parent: nil)
              #   Pass arguments to `list_issue_models` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the issue model.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest.new
              #
              #   # Call the list_issue_models method.
              #   result = client.list_issue_models request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::ListIssueModelsResponse.
              #   p result
              #
              def list_issue_models request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListIssueModelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_issue_models.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_issue_models.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_issue_models.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_issue_models request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an issue model.
              #
              # @overload delete_issue_model(request, options = nil)
              #   Pass arguments to `delete_issue_model` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_issue_model(name: nil)
              #   Pass arguments to `delete_issue_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the issue model to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest.new
              #
              #   # Call the delete_issue_model method.
              #   result = client.delete_issue_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_issue_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteIssueModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_issue_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_issue_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_issue_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_issue_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deploys an issue model. Returns an error if a model is already deployed.
              # An issue model can only be used in analysis after it has been deployed.
              #
              # @overload deploy_issue_model(request, options = nil)
              #   Pass arguments to `deploy_issue_model` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload deploy_issue_model(name: nil)
              #   Pass arguments to `deploy_issue_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The issue model to deploy.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest.new
              #
              #   # Call the deploy_issue_model method.
              #   result = client.deploy_issue_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def deploy_issue_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeployIssueModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.deploy_issue_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.deploy_issue_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.deploy_issue_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.deploy_issue_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Undeploys an issue model.
              # An issue model can not be used in analysis after it has been undeployed.
              #
              # @overload undeploy_issue_model(request, options = nil)
              #   Pass arguments to `undeploy_issue_model` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload undeploy_issue_model(name: nil)
              #   Pass arguments to `undeploy_issue_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The issue model to undeploy.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest.new
              #
              #   # Call the undeploy_issue_model method.
              #   result = client.undeploy_issue_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def undeploy_issue_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UndeployIssueModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.undeploy_issue_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.undeploy_issue_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.undeploy_issue_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.undeploy_issue_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports an issue model to the provided destination.
              #
              # @overload export_issue_model(request, options = nil)
              #   Pass arguments to `export_issue_model` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_issue_model(gcs_destination: nil, name: nil)
              #   Pass arguments to `export_issue_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_destination [::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest::GcsDestination, ::Hash]
              #     Google Cloud Storage URI to export the issue model to.
              #   @param name [::String]
              #     Required. The issue model to export.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest.new
              #
              #   # Call the export_issue_model method.
              #   result = client.export_issue_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_issue_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ExportIssueModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_issue_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_issue_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_issue_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.export_issue_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports an issue model from a Cloud Storage bucket.
              #
              # @overload import_issue_model(request, options = nil)
              #   Pass arguments to `import_issue_model` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_issue_model(gcs_source: nil, parent: nil, create_new_model: nil)
              #   Pass arguments to `import_issue_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_source [::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest::GcsSource, ::Hash]
              #     Google Cloud Storage source message.
              #   @param parent [::String]
              #     Required. The parent resource of the issue model.
              #   @param create_new_model [::Boolean]
              #     Optional. If set to true, will create an issue model from the imported file
              #     with randomly generated IDs for the issue model and corresponding issues.
              #     Otherwise, replaces an existing model with the same ID as the file.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest.new
              #
              #   # Call the import_issue_model method.
              #   result = client.import_issue_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_issue_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ImportIssueModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_issue_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_issue_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_issue_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.import_issue_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an issue.
              #
              # @overload get_issue(request, options = nil)
              #   Pass arguments to `get_issue` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_issue(name: nil)
              #   Pass arguments to `get_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the issue to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::Issue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::Issue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetIssueRequest.new
              #
              #   # Call the get_issue method.
              #   result = client.get_issue request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::Issue.
              #   p result
              #
              def get_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_issue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists issues.
              #
              # @overload list_issues(request, options = nil)
              #   Pass arguments to `list_issues` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_issues(parent: nil)
              #   Pass arguments to `list_issues` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the issue.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::ListIssuesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::ListIssuesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest.new
              #
              #   # Call the list_issues method.
              #   result = client.list_issues request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::ListIssuesResponse.
              #   p result
              #
              def list_issues request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListIssuesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_issues.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_issues.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_issues.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_issues request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an issue.
              #
              # @overload update_issue(request, options = nil)
              #   Pass arguments to `update_issue` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_issue(issue: nil, update_mask: nil)
              #   Pass arguments to `update_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param issue [::Google::Cloud::ContactCenterInsights::V1::Issue, ::Hash]
              #     Required. The new values for the issue.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::Issue]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::Issue]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest.new
              #
              #   # Call the update_issue method.
              #   result = client.update_issue request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::Issue.
              #   p result
              #
              def update_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_issue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an issue.
              #
              # @overload delete_issue(request, options = nil)
              #   Pass arguments to `delete_issue` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_issue(name: nil)
              #   Pass arguments to `delete_issue` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the issue to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest.new
              #
              #   # Call the delete_issue method.
              #   result = client.delete_issue request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_issue request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteIssueRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_issue.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_issue.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_issue.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_issue request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an issue model's statistics.
              #
              # @overload calculate_issue_model_stats(request, options = nil)
              #   Pass arguments to `calculate_issue_model_stats` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload calculate_issue_model_stats(issue_model: nil)
              #   Pass arguments to `calculate_issue_model_stats` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param issue_model [::String]
              #     Required. The resource name of the issue model to query against.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest.new
              #
              #   # Call the calculate_issue_model_stats method.
              #   result = client.calculate_issue_model_stats request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsResponse.
              #   p result
              #
              def calculate_issue_model_stats request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CalculateIssueModelStatsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.calculate_issue_model_stats.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.calculate_issue_model_stats.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.calculate_issue_model_stats.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.calculate_issue_model_stats request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a phrase matcher.
              #
              # @overload create_phrase_matcher(request, options = nil)
              #   Pass arguments to `create_phrase_matcher` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_phrase_matcher(parent: nil, phrase_matcher: nil)
              #   Pass arguments to `create_phrase_matcher` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the phrase matcher. Required. The location
              #     to create a phrase matcher for. Format: `projects/<Project
              #     ID>/locations/<Location ID>` or `projects/<Project
              #     Number>/locations/<Location ID>`
              #   @param phrase_matcher [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher, ::Hash]
              #     Required. The phrase matcher resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest.new
              #
              #   # Call the create_phrase_matcher method.
              #   result = client.create_phrase_matcher request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.
              #   p result
              #
              def create_phrase_matcher request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreatePhraseMatcherRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_phrase_matcher.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_phrase_matcher.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_phrase_matcher.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_phrase_matcher request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a phrase matcher.
              #
              # @overload get_phrase_matcher(request, options = nil)
              #   Pass arguments to `get_phrase_matcher` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_phrase_matcher(name: nil)
              #   Pass arguments to `get_phrase_matcher` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the phrase matcher to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest.new
              #
              #   # Call the get_phrase_matcher method.
              #   result = client.get_phrase_matcher request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.
              #   p result
              #
              def get_phrase_matcher request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetPhraseMatcherRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_phrase_matcher.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_phrase_matcher.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_phrase_matcher.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_phrase_matcher request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists phrase matchers.
              #
              # @overload list_phrase_matchers(request, options = nil)
              #   Pass arguments to `list_phrase_matchers` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_phrase_matchers(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_phrase_matchers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the phrase matcher.
              #   @param page_size [::Integer]
              #     The maximum number of phrase matchers to return in the response. If this
              #     value is zero, the service will select a default size. A call might return
              #     fewer objects than requested. A non-empty `next_page_token` in the response
              #     indicates that more data is available.
              #   @param page_token [::String]
              #     The value returned by the last `ListPhraseMatchersResponse`. This value
              #     indicates that this is a continuation of a prior `ListPhraseMatchers` call
              #     and that the system should return the next page of data.
              #   @param filter [::String]
              #     A filter to reduce results to a specific subset. Useful for querying
              #     phrase matchers with specific properties.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest.new
              #
              #   # Call the list_phrase_matchers method.
              #   result = client.list_phrase_matchers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.
              #     p item
              #   end
              #
              def list_phrase_matchers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListPhraseMatchersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_phrase_matchers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_phrase_matchers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_phrase_matchers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_phrase_matchers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_phrase_matchers, "phrase_matchers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a phrase matcher.
              #
              # @overload delete_phrase_matcher(request, options = nil)
              #   Pass arguments to `delete_phrase_matcher` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_phrase_matcher(name: nil)
              #   Pass arguments to `delete_phrase_matcher` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the phrase matcher to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest.new
              #
              #   # Call the delete_phrase_matcher method.
              #   result = client.delete_phrase_matcher request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_phrase_matcher request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeletePhraseMatcherRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_phrase_matcher.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_phrase_matcher.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_phrase_matcher.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_phrase_matcher request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a phrase matcher.
              #
              # @overload update_phrase_matcher(request, options = nil)
              #   Pass arguments to `update_phrase_matcher` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_phrase_matcher(phrase_matcher: nil, update_mask: nil)
              #   Pass arguments to `update_phrase_matcher` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param phrase_matcher [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher, ::Hash]
              #     Required. The new values for the phrase matcher.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::PhraseMatcher]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest.new
              #
              #   # Call the update_phrase_matcher method.
              #   result = client.update_phrase_matcher request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::PhraseMatcher.
              #   p result
              #
              def update_phrase_matcher request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdatePhraseMatcherRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_phrase_matcher.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_phrase_matcher.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_phrase_matcher.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_phrase_matcher request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets conversation statistics.
              #
              # @overload calculate_stats(request, options = nil)
              #   Pass arguments to `calculate_stats` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload calculate_stats(location: nil, filter: nil)
              #   Pass arguments to `calculate_stats` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param location [::String]
              #     Required. The location of the conversations.
              #   @param filter [::String]
              #     A filter to reduce results to a specific subset. This field is useful for
              #     getting statistics about conversations with specific properties.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::CalculateStatsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::CalculateStatsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest.new
              #
              #   # Call the calculate_stats method.
              #   result = client.calculate_stats request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::CalculateStatsResponse.
              #   p result
              #
              def calculate_stats request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CalculateStatsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.calculate_stats.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.calculate_stats.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.calculate_stats.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.calculate_stats request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets project-level settings.
              #
              # @overload get_settings(request, options = nil)
              #   Pass arguments to `get_settings` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_settings(name: nil)
              #   Pass arguments to `get_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the settings resource to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::Settings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::Settings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest.new
              #
              #   # Call the get_settings method.
              #   result = client.get_settings request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::Settings.
              #   p result
              #
              def get_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates project-level settings.
              #
              # @overload update_settings(request, options = nil)
              #   Pass arguments to `update_settings` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_settings(settings: nil, update_mask: nil)
              #   Pass arguments to `update_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param settings [::Google::Cloud::ContactCenterInsights::V1::Settings, ::Hash]
              #     Required. The new settings values.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::Settings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::Settings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest.new
              #
              #   # Call the update_settings method.
              #   result = client.update_settings request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::Settings.
              #   p result
              #
              def update_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a analysis rule.
              #
              # @overload create_analysis_rule(request, options = nil)
              #   Pass arguments to `create_analysis_rule` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_analysis_rule(parent: nil, analysis_rule: nil)
              #   Pass arguments to `create_analysis_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the analysis rule. Required. The location
              #     to create a analysis rule for. Format: `projects/<Project
              #     ID>/locations/<Location ID>` or `projects/<Project
              #     Number>/locations/<Location ID>`
              #   @param analysis_rule [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule, ::Hash]
              #     Required. The analysis rule resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest.new
              #
              #   # Call the create_analysis_rule method.
              #   result = client.create_analysis_rule request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::AnalysisRule.
              #   p result
              #
              def create_analysis_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateAnalysisRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_analysis_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_analysis_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_analysis_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_analysis_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get a analysis rule.
              #
              # @overload get_analysis_rule(request, options = nil)
              #   Pass arguments to `get_analysis_rule` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_analysis_rule(name: nil)
              #   Pass arguments to `get_analysis_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the AnalysisRule to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest.new
              #
              #   # Call the get_analysis_rule method.
              #   result = client.get_analysis_rule request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::AnalysisRule.
              #   p result
              #
              def get_analysis_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetAnalysisRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_analysis_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_analysis_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_analysis_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_analysis_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists analysis rules.
              #
              # @overload list_analysis_rules(request, options = nil)
              #   Pass arguments to `list_analysis_rules` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_analysis_rules(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_analysis_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the analysis rules.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of analysis rule to return in the response. If
              #     this value is zero, the service will select a default size. A call may
              #     return fewer objects than requested. A non-empty `next_page_token` in the
              #     response indicates that more data is available.
              #   @param page_token [::String]
              #     Optional. The value returned by the last `ListAnalysisRulesResponse`;
              #     indicates that this is a continuation of a prior `ListAnalysisRules` call
              #     and the system should return the next page of data.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::AnalysisRule>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::AnalysisRule>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest.new
              #
              #   # Call the list_analysis_rules method.
              #   result = client.list_analysis_rules request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::AnalysisRule.
              #     p item
              #   end
              #
              def list_analysis_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListAnalysisRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_analysis_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_analysis_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_analysis_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_analysis_rules request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_analysis_rules, "analysis_rules", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a analysis rule.
              #
              # @overload update_analysis_rule(request, options = nil)
              #   Pass arguments to `update_analysis_rule` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_analysis_rule(analysis_rule: nil, update_mask: nil)
              #   Pass arguments to `update_analysis_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param analysis_rule [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule, ::Hash]
              #     Required. The new analysis rule.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to be updated.
              #     If the update_mask is not provided, the update will be applied to all
              #     fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::AnalysisRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest.new
              #
              #   # Call the update_analysis_rule method.
              #   result = client.update_analysis_rule request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::AnalysisRule.
              #   p result
              #
              def update_analysis_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateAnalysisRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_analysis_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_analysis_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_analysis_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_analysis_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a analysis rule.
              #
              # @overload delete_analysis_rule(request, options = nil)
              #   Pass arguments to `delete_analysis_rule` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_analysis_rule(name: nil)
              #   Pass arguments to `delete_analysis_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the analysis rule to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest.new
              #
              #   # Call the delete_analysis_rule method.
              #   result = client.delete_analysis_rule request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_analysis_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteAnalysisRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_analysis_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_analysis_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_analysis_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_analysis_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets location-level encryption key specification.
              #
              # @overload get_encryption_spec(request, options = nil)
              #   Pass arguments to `get_encryption_spec` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_encryption_spec(name: nil)
              #   Pass arguments to `get_encryption_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the encryption spec resource to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::EncryptionSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::EncryptionSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest.new
              #
              #   # Call the get_encryption_spec method.
              #   result = client.get_encryption_spec request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::EncryptionSpec.
              #   p result
              #
              def get_encryption_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetEncryptionSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_encryption_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_encryption_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_encryption_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_encryption_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initializes a location-level encryption key specification. An error will
              # result if the location has resources already created before the
              # initialization. After the encryption specification is initialized at a
              # location, it is immutable and all newly created resources under the
              # location will be encrypted with the existing specification.
              #
              # @overload initialize_encryption_spec(request, options = nil)
              #   Pass arguments to `initialize_encryption_spec` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload initialize_encryption_spec(encryption_spec: nil)
              #   Pass arguments to `initialize_encryption_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param encryption_spec [::Google::Cloud::ContactCenterInsights::V1::EncryptionSpec, ::Hash]
              #     Required. The encryption spec used for CMEK encryption. It is required that
              #     the kms key is in the same region as the endpoint. The same key will be
              #     used for all provisioned resources, if encryption is available. If the
              #     `kms_key_name` field is left empty, no encryption will be enforced.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest.new
              #
              #   # Call the initialize_encryption_spec method.
              #   result = client.initialize_encryption_spec request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def initialize_encryption_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::InitializeEncryptionSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.initialize_encryption_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.initialize_encryption_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.initialize_encryption_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.initialize_encryption_spec request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a view.
              #
              # @overload create_view(request, options = nil)
              #   Pass arguments to `create_view` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_view(parent: nil, view: nil)
              #   Pass arguments to `create_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the view. Required. The location to create
              #     a view for.
              #     Format: `projects/<Project ID>/locations/<Location ID>` or
              #     `projects/<Project Number>/locations/<Location ID>`
              #   @param view [::Google::Cloud::ContactCenterInsights::V1::View, ::Hash]
              #     Required. The view resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::View]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::View]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateViewRequest.new
              #
              #   # Call the create_view method.
              #   result = client.create_view request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::View.
              #   p result
              #
              def create_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_view.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_view request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a view.
              #
              # @overload get_view(request, options = nil)
              #   Pass arguments to `get_view` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_view(name: nil)
              #   Pass arguments to `get_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the view to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::View]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::View]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetViewRequest.new
              #
              #   # Call the get_view method.
              #   result = client.get_view request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::View.
              #   p result
              #
              def get_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_view.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_view request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists views.
              #
              # @overload list_views(request, options = nil)
              #   Pass arguments to `list_views` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListViewsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListViewsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_views(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_views` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the views.
              #   @param page_size [::Integer]
              #     The maximum number of views to return in the response. If this
              #     value is zero, the service will select a default size. A call may return
              #     fewer objects than requested. A non-empty `next_page_token` in the response
              #     indicates that more data is available.
              #   @param page_token [::String]
              #     The value returned by the last `ListViewsResponse`; indicates
              #     that this is a continuation of a prior `ListViews` call and
              #     the system should return the next page of data.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::View>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::View>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListViewsRequest.new
              #
              #   # Call the list_views method.
              #   result = client.list_views request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::View.
              #     p item
              #   end
              #
              def list_views request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListViewsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_views.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_views.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_views.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_views request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_views, "views", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a view.
              #
              # @overload update_view(request, options = nil)
              #   Pass arguments to `update_view` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_view(view: nil, update_mask: nil)
              #   Pass arguments to `update_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param view [::Google::Cloud::ContactCenterInsights::V1::View, ::Hash]
              #     Required. The new view.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::View]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::View]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest.new
              #
              #   # Call the update_view method.
              #   result = client.update_view request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::View.
              #   p result
              #
              def update_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_view.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_view request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a view.
              #
              # @overload delete_view(request, options = nil)
              #   Pass arguments to `delete_view` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_view(name: nil)
              #   Pass arguments to `delete_view` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the view to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest.new
              #
              #   # Call the delete_view method.
              #   result = client.delete_view request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_view request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteViewRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_view.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_view.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_view.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_view request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Query metrics.
              #
              # @overload query_metrics(request, options = nil)
              #   Pass arguments to `query_metrics` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload query_metrics(location: nil, filter: nil, time_granularity: nil, dimensions: nil, measure_mask: nil)
              #   Pass arguments to `query_metrics` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param location [::String]
              #     Required. The location of the data.
              #     "projects/\\{project}/locations/\\{location}"
              #   @param filter [::String]
              #     Required. Filter to select a subset of conversations to compute the
              #     metrics. Must specify a window of the conversation create time to compute
              #     the metrics. The returned metrics will be from the range [DATE(starting
              #     create time), DATE(ending create time)).
              #   @param time_granularity [::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest::TimeGranularity]
              #     The time granularity of each data point in the time series.
              #     Defaults to NONE if this field is unspecified.
              #   @param dimensions [::Array<::Google::Cloud::ContactCenterInsights::V1::Dimension, ::Hash>]
              #     The dimensions that determine the grouping key for the query. Defaults to
              #     no dimension if this field is unspecified. If a dimension is specified,
              #     its key must also be specified. Each dimension's key must be unique.
              #
              #     If a time granularity is also specified, metric values in the dimension
              #     will be bucketed by this granularity.
              #
              #     Up to one dimension is supported for now.
              #   @param measure_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Measures to return. Defaults to all measures if this field is unspecified.
              #     A valid mask should traverse from the `measure` field from the response.
              #     For example, a path from a measure mask to get the conversation count is
              #     "conversation_measure.count".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest.new
              #
              #   # Call the query_metrics method.
              #   result = client.query_metrics request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def query_metrics request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::QueryMetricsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.query_metrics.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.query_metrics.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.query_metrics.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.query_metrics request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a QaQuestion.
              #
              # @overload create_qa_question(request, options = nil)
              #   Pass arguments to `create_qa_question` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_qa_question(parent: nil, qa_question: nil, qa_question_id: nil)
              #   Pass arguments to `create_qa_question` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the QaQuestion.
              #   @param qa_question [::Google::Cloud::ContactCenterInsights::V1::QaQuestion, ::Hash]
              #     Required. The QaQuestion to create.
              #   @param qa_question_id [::String]
              #     Optional. A unique ID for the new question. This ID will become the final
              #     component of the question's resource name. If no ID is specified, a
              #     server-generated ID will be used.
              #
              #     This value should be 4-64 characters and must match the regular
              #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaQuestion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaQuestion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest.new
              #
              #   # Call the create_qa_question method.
              #   result = client.create_qa_question request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaQuestion.
              #   p result
              #
              def create_qa_question request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateQaQuestionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_qa_question.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_qa_question.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_qa_question.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_qa_question request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a QaQuestion.
              #
              # @overload get_qa_question(request, options = nil)
              #   Pass arguments to `get_qa_question` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_qa_question(name: nil)
              #   Pass arguments to `get_qa_question` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the QaQuestion to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaQuestion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaQuestion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest.new
              #
              #   # Call the get_qa_question method.
              #   result = client.get_qa_question request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaQuestion.
              #   p result
              #
              def get_qa_question request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetQaQuestionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_qa_question.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_qa_question.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_qa_question.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_qa_question request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a QaQuestion.
              #
              # @overload update_qa_question(request, options = nil)
              #   Pass arguments to `update_qa_question` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_qa_question(qa_question: nil, update_mask: nil)
              #   Pass arguments to `update_qa_question` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param qa_question [::Google::Cloud::ContactCenterInsights::V1::QaQuestion, ::Hash]
              #     Required. The QaQuestion to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. All possible fields can be
              #     updated by passing `*`, or a subset of the following updateable fields can
              #     be provided:
              #
              #     * `abbreviation`
              #     * `answer_choices`
              #     * `answer_instructions`
              #     * `order`
              #     * `question_body`
              #     * `tags`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaQuestion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaQuestion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest.new
              #
              #   # Call the update_qa_question method.
              #   result = client.update_qa_question request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaQuestion.
              #   p result
              #
              def update_qa_question request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateQaQuestionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_qa_question.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_qa_question.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_qa_question.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_qa_question request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a QaQuestion.
              #
              # @overload delete_qa_question(request, options = nil)
              #   Pass arguments to `delete_qa_question` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_qa_question(name: nil)
              #   Pass arguments to `delete_qa_question` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the QaQuestion to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest.new
              #
              #   # Call the delete_qa_question method.
              #   result = client.delete_qa_question request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_qa_question request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteQaQuestionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_qa_question.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_qa_question.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_qa_question.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_qa_question request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists QaQuestions.
              #
              # @overload list_qa_questions(request, options = nil)
              #   Pass arguments to `list_qa_questions` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_qa_questions(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_qa_questions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the questions.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of questions to return in the response. If the
              #     value is zero, the service will select a default size. A call might return
              #     fewer objects than requested. A non-empty `next_page_token` in the response
              #     indicates that more data is available.
              #   @param page_token [::String]
              #     Optional. The value returned by the last `ListQaQuestionsResponse`. This
              #     value indicates that this is a continuation of a prior `ListQaQuestions`
              #     call and that the system should return the next page of data.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::QaQuestion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::QaQuestion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest.new
              #
              #   # Call the list_qa_questions method.
              #   result = client.list_qa_questions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::QaQuestion.
              #     p item
              #   end
              #
              def list_qa_questions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListQaQuestionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_qa_questions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_qa_questions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_qa_questions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_qa_questions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_qa_questions, "qa_questions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a QaScorecard.
              #
              # @overload create_qa_scorecard(request, options = nil)
              #   Pass arguments to `create_qa_scorecard` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_qa_scorecard(parent: nil, qa_scorecard: nil, qa_scorecard_id: nil)
              #   Pass arguments to `create_qa_scorecard` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the QaScorecard.
              #   @param qa_scorecard [::Google::Cloud::ContactCenterInsights::V1::QaScorecard, ::Hash]
              #     Required. The QaScorecard to create.
              #   @param qa_scorecard_id [::String]
              #     Optional. A unique ID for the new QaScorecard. This ID will become the
              #     final component of the QaScorecard's resource name. If no ID is specified,
              #     a server-generated ID will be used.
              #
              #     This value should be 4-64 characters and must match the regular
              #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaScorecard]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecard]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest.new
              #
              #   # Call the create_qa_scorecard method.
              #   result = client.create_qa_scorecard request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaScorecard.
              #   p result
              #
              def create_qa_scorecard request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_qa_scorecard.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_qa_scorecard.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_qa_scorecard.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_qa_scorecard request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a QaScorecard.
              #
              # @overload get_qa_scorecard(request, options = nil)
              #   Pass arguments to `get_qa_scorecard` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_qa_scorecard(name: nil)
              #   Pass arguments to `get_qa_scorecard` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the QaScorecard to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaScorecard]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecard]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest.new
              #
              #   # Call the get_qa_scorecard method.
              #   result = client.get_qa_scorecard request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaScorecard.
              #   p result
              #
              def get_qa_scorecard request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_qa_scorecard.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_qa_scorecard.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_qa_scorecard.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_qa_scorecard request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a QaScorecard.
              #
              # @overload update_qa_scorecard(request, options = nil)
              #   Pass arguments to `update_qa_scorecard` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_qa_scorecard(qa_scorecard: nil, update_mask: nil)
              #   Pass arguments to `update_qa_scorecard` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param qa_scorecard [::Google::Cloud::ContactCenterInsights::V1::QaScorecard, ::Hash]
              #     Required. The QaScorecard to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated. All possible fields can be
              #     updated by passing `*`, or a subset of the following updateable fields can
              #     be provided:
              #
              #     * `description`
              #     * `display_name`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaScorecard]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecard]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest.new
              #
              #   # Call the update_qa_scorecard method.
              #   result = client.update_qa_scorecard request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaScorecard.
              #   p result
              #
              def update_qa_scorecard request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateQaScorecardRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_qa_scorecard.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_qa_scorecard.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_qa_scorecard.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_qa_scorecard request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a QaScorecard.
              #
              # @overload delete_qa_scorecard(request, options = nil)
              #   Pass arguments to `delete_qa_scorecard` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_qa_scorecard(name: nil, force: nil)
              #   Pass arguments to `delete_qa_scorecard` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the QaScorecard to delete.
              #   @param force [::Boolean]
              #     Optional. If set to true, all of this QaScorecard's child resources will
              #     also be deleted. Otherwise, the request will only succeed if it has none.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest.new
              #
              #   # Call the delete_qa_scorecard method.
              #   result = client.delete_qa_scorecard request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_qa_scorecard request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_qa_scorecard.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_qa_scorecard.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_qa_scorecard.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_qa_scorecard request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists QaScorecards.
              #
              # @overload list_qa_scorecards(request, options = nil)
              #   Pass arguments to `list_qa_scorecards` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_qa_scorecards(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_qa_scorecards` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the scorecards.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of scorecards to return in the response. If
              #     the value is zero, the service will select a default size. A call might
              #     return fewer objects than requested. A non-empty `next_page_token` in the
              #     response indicates that more data is available.
              #   @param page_token [::String]
              #     Optional. The value returned by the last `ListQaScorecardsResponse`. This
              #     value indicates that this is a continuation of a prior `ListQaScorecards`
              #     call and that the system should return the next page of data.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::QaScorecard>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::QaScorecard>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest.new
              #
              #   # Call the list_qa_scorecards method.
              #   result = client.list_qa_scorecards request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::QaScorecard.
              #     p item
              #   end
              #
              def list_qa_scorecards request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_qa_scorecards.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_qa_scorecards.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_qa_scorecards.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_qa_scorecards request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_qa_scorecards, "qa_scorecards", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a QaScorecardRevision.
              #
              # @overload create_qa_scorecard_revision(request, options = nil)
              #   Pass arguments to `create_qa_scorecard_revision` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_qa_scorecard_revision(parent: nil, qa_scorecard_revision: nil, qa_scorecard_revision_id: nil)
              #   Pass arguments to `create_qa_scorecard_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the QaScorecardRevision.
              #   @param qa_scorecard_revision [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision, ::Hash]
              #     Required. The QaScorecardRevision to create.
              #   @param qa_scorecard_revision_id [::String]
              #     Optional. A unique ID for the new QaScorecardRevision. This ID will become
              #     the final component of the QaScorecardRevision's resource name. If no ID is
              #     specified, a server-generated ID will be used.
              #
              #     This value should be 4-64 characters and must match the regular
              #     expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest.new
              #
              #   # Call the create_qa_scorecard_revision method.
              #   result = client.create_qa_scorecard_revision request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.
              #   p result
              #
              def create_qa_scorecard_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateQaScorecardRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_qa_scorecard_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_qa_scorecard_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_qa_scorecard_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_qa_scorecard_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a QaScorecardRevision.
              #
              # @overload get_qa_scorecard_revision(request, options = nil)
              #   Pass arguments to `get_qa_scorecard_revision` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_qa_scorecard_revision(name: nil)
              #   Pass arguments to `get_qa_scorecard_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the QaScorecardRevision to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest.new
              #
              #   # Call the get_qa_scorecard_revision method.
              #   result = client.get_qa_scorecard_revision request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.
              #   p result
              #
              def get_qa_scorecard_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetQaScorecardRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_qa_scorecard_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_qa_scorecard_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_qa_scorecard_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_qa_scorecard_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fine tune one or more QaModels.
              #
              # @overload tune_qa_scorecard_revision(request, options = nil)
              #   Pass arguments to `tune_qa_scorecard_revision` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload tune_qa_scorecard_revision(parent: nil, filter: nil, validate_only: nil)
              #   Pass arguments to `tune_qa_scorecard_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for new fine tuning job instance.
              #   @param filter [::String]
              #     Required. Filter for selecting the feedback labels that needs to be
              #     used for training.
              #     This filter can be used to limit the feedback labels used for tuning to a
              #     feedback labels created or updated for a specific time-window etc.
              #   @param validate_only [::Boolean]
              #     Optional. Run in validate only mode, no fine tuning will actually run.
              #     Data quality validations like training data distributions will run.
              #     Even when set to false, the data quality validations will still run but
              #     once the validations complete we will proceed with the fine tune, if
              #     applicable.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest.new
              #
              #   # Call the tune_qa_scorecard_revision method.
              #   result = client.tune_qa_scorecard_revision request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def tune_qa_scorecard_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::TuneQaScorecardRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.tune_qa_scorecard_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.tune_qa_scorecard_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.tune_qa_scorecard_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.tune_qa_scorecard_revision request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deploy a QaScorecardRevision.
              #
              # @overload deploy_qa_scorecard_revision(request, options = nil)
              #   Pass arguments to `deploy_qa_scorecard_revision` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload deploy_qa_scorecard_revision(name: nil)
              #   Pass arguments to `deploy_qa_scorecard_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the QaScorecardRevision to deploy.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest.new
              #
              #   # Call the deploy_qa_scorecard_revision method.
              #   result = client.deploy_qa_scorecard_revision request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.
              #   p result
              #
              def deploy_qa_scorecard_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeployQaScorecardRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.deploy_qa_scorecard_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.deploy_qa_scorecard_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.deploy_qa_scorecard_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.deploy_qa_scorecard_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Undeploy a QaScorecardRevision.
              #
              # @overload undeploy_qa_scorecard_revision(request, options = nil)
              #   Pass arguments to `undeploy_qa_scorecard_revision` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload undeploy_qa_scorecard_revision(name: nil)
              #   Pass arguments to `undeploy_qa_scorecard_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the QaScorecardRevision to undeploy.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest.new
              #
              #   # Call the undeploy_qa_scorecard_revision method.
              #   result = client.undeploy_qa_scorecard_revision request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.
              #   p result
              #
              def undeploy_qa_scorecard_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UndeployQaScorecardRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.undeploy_qa_scorecard_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.undeploy_qa_scorecard_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.undeploy_qa_scorecard_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.undeploy_qa_scorecard_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a QaScorecardRevision.
              #
              # @overload delete_qa_scorecard_revision(request, options = nil)
              #   Pass arguments to `delete_qa_scorecard_revision` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_qa_scorecard_revision(name: nil, force: nil)
              #   Pass arguments to `delete_qa_scorecard_revision` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the QaScorecardRevision to delete.
              #   @param force [::Boolean]
              #     Optional. If set to true, all of this QaScorecardRevision's child resources
              #     will also be deleted. Otherwise, the request will only succeed if it has
              #     none.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest.new
              #
              #   # Call the delete_qa_scorecard_revision method.
              #   result = client.delete_qa_scorecard_revision request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_qa_scorecard_revision request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteQaScorecardRevisionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_qa_scorecard_revision.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_qa_scorecard_revision.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_qa_scorecard_revision.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_qa_scorecard_revision request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all revisions under the parent QaScorecard.
              #
              # @overload list_qa_scorecard_revisions(request, options = nil)
              #   Pass arguments to `list_qa_scorecard_revisions` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_qa_scorecard_revisions(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_qa_scorecard_revisions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the scorecard revisions. To list all
              #     revisions of all scorecards, substitute the QaScorecard ID with a '-'
              #     character.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of scorecard revisions to return in the
              #     response. If the value is zero, the service will select a default size. A
              #     call might return fewer objects than requested. A non-empty
              #     `next_page_token` in the response indicates that more data is available.
              #   @param page_token [::String]
              #     Optional. The value returned by the last
              #     `ListQaScorecardRevisionsResponse`. This value indicates that this is a
              #     continuation of a prior `ListQaScorecardRevisions` call and that the system
              #     should return the next page of data.
              #   @param filter [::String]
              #     Optional. A filter to reduce results to a specific subset. Useful for
              #     querying scorecard revisions with specific properties.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest.new
              #
              #   # Call the list_qa_scorecard_revisions method.
              #   result = client.list_qa_scorecard_revisions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::QaScorecardRevision.
              #     p item
              #   end
              #
              def list_qa_scorecard_revisions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListQaScorecardRevisionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_qa_scorecard_revisions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_qa_scorecard_revisions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_qa_scorecard_revisions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_qa_scorecard_revisions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_qa_scorecard_revisions, "qa_scorecard_revisions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create feedback label.
              #
              # @overload create_feedback_label(request, options = nil)
              #   Pass arguments to `create_feedback_label` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_feedback_label(parent: nil, feedback_label_id: nil, feedback_label: nil)
              #   Pass arguments to `create_feedback_label` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the feedback label.
              #   @param feedback_label_id [::String]
              #     Optional. The ID of the feedback label to create.
              #     If one is not specified it will be generated by the server.
              #   @param feedback_label [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel, ::Hash]
              #     Required. The feedback label to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest.new
              #
              #   # Call the create_feedback_label method.
              #   result = client.create_feedback_label request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.
              #   p result
              #
              def create_feedback_label request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::CreateFeedbackLabelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_feedback_label.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_feedback_label.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_feedback_label.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.create_feedback_label request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List feedback labels.
              #
              # @overload list_feedback_labels(request, options = nil)
              #   Pass arguments to `list_feedback_labels` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_feedback_labels(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_feedback_labels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the feedback labels.
              #   @param filter [::String]
              #     Optional. A filter to reduce results to a specific subset. Supports
              #     disjunctions (OR) and conjunctions (AND). Automatically sorts by
              #     conversation ID. To sort by all feedback labels in a project see
              #     ListAllFeedbackLabels.
              #
              #     Supported fields:
              #
              #     * `issue_model_id`
              #     * `qa_question_id`
              #     * `qa_scorecard_id`
              #     * `min_create_time`
              #     * `max_create_time`
              #     * `min_update_time`
              #     * `max_update_time`
              #     * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
              #   @param page_size [::Integer]
              #     Optional. The maximum number of feedback labels to return in the response.
              #     A valid page size ranges from 0 to 100,000 inclusive. If the page size is
              #     zero or unspecified, a default page size of 100 will be chosen. Note that a
              #     call might return fewer results than the requested page size.
              #   @param page_token [::String]
              #     Optional. The value returned by the last `ListFeedbackLabelsResponse`. This
              #     value indicates that this is a continuation of a prior `ListFeedbackLabels`
              #     call and that the system should return the next page of data.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest.new
              #
              #   # Call the list_feedback_labels method.
              #   result = client.list_feedback_labels request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.
              #     p item
              #   end
              #
              def list_feedback_labels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListFeedbackLabelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_feedback_labels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_feedback_labels.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_feedback_labels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_feedback_labels request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_feedback_labels, "feedback_labels", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get feedback label.
              #
              # @overload get_feedback_label(request, options = nil)
              #   Pass arguments to `get_feedback_label` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_feedback_label(name: nil)
              #   Pass arguments to `get_feedback_label` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the feedback label to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest.new
              #
              #   # Call the get_feedback_label method.
              #   result = client.get_feedback_label request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.
              #   p result
              #
              def get_feedback_label request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::GetFeedbackLabelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_feedback_label.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_feedback_label.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_feedback_label.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.get_feedback_label request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update feedback label.
              #
              # @overload update_feedback_label(request, options = nil)
              #   Pass arguments to `update_feedback_label` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_feedback_label(feedback_label: nil, update_mask: nil)
              #   Pass arguments to `update_feedback_label` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param feedback_label [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel, ::Hash]
              #     Required. The feedback label to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest.new
              #
              #   # Call the update_feedback_label method.
              #   result = client.update_feedback_label request
              #
              #   # The returned object is of type Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.
              #   p result
              #
              def update_feedback_label request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::UpdateFeedbackLabelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_feedback_label.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_feedback_label.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_feedback_label.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.update_feedback_label request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete feedback label.
              #
              # @overload delete_feedback_label(request, options = nil)
              #   Pass arguments to `delete_feedback_label` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_feedback_label(name: nil)
              #   Pass arguments to `delete_feedback_label` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the feedback label to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest.new
              #
              #   # Call the delete_feedback_label method.
              #   result = client.delete_feedback_label request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_feedback_label request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::DeleteFeedbackLabelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_feedback_label.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_feedback_label.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_feedback_label.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.delete_feedback_label request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List all feedback labels by project number.
              #
              # @overload list_all_feedback_labels(request, options = nil)
              #   Pass arguments to `list_all_feedback_labels` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_all_feedback_labels(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_all_feedback_labels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of all feedback labels per project.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of feedback labels to return in the response.
              #     A valid page size ranges from 0 to 100,000 inclusive. If the page size is
              #     zero or unspecified, a default page size of 100 will be chosen. Note that a
              #     call might return fewer results than the requested page size.
              #   @param page_token [::String]
              #     Optional. The value returned by the last `ListAllFeedbackLabelsResponse`.
              #     This value indicates that this is a continuation of a prior
              #     `ListAllFeedbackLabels` call and that the system should return the next
              #     page of data.
              #   @param filter [::String]
              #     Optional. A filter to reduce results to a specific subset in the entire
              #     project. Supports disjunctions (OR) and conjunctions (AND).
              #
              #     Supported fields:
              #
              #     * `issue_model_id`
              #     * `qa_question_id`
              #     * `min_create_time`
              #     * `max_create_time`
              #     * `min_update_time`
              #     * `max_update_time`
              #     * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest.new
              #
              #   # Call the list_all_feedback_labels method.
              #   result = client.list_all_feedback_labels request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ContactCenterInsights::V1::FeedbackLabel.
              #     p item
              #   end
              #
              def list_all_feedback_labels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::ListAllFeedbackLabelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_all_feedback_labels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_all_feedback_labels.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_all_feedback_labels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.list_all_feedback_labels request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @contact_center_insights_stub, :list_all_feedback_labels, "feedback_labels", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Upload feedback labels in bulk.
              #
              # @overload bulk_upload_feedback_labels(request, options = nil)
              #   Pass arguments to `bulk_upload_feedback_labels` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload bulk_upload_feedback_labels(gcs_source: nil, parent: nil, validate_only: nil)
              #   Pass arguments to `bulk_upload_feedback_labels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_source [::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest::GcsSource, ::Hash]
              #     A cloud storage bucket source.
              #   @param parent [::String]
              #     Required. The parent resource for new feedback labels.
              #   @param validate_only [::Boolean]
              #     Optional. If set, upload will not happen and the labels will be validated.
              #     If not set, then default behavior will be to upload the labels after
              #     validation is complete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest.new
              #
              #   # Call the bulk_upload_feedback_labels method.
              #   result = client.bulk_upload_feedback_labels request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def bulk_upload_feedback_labels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::BulkUploadFeedbackLabelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.bulk_upload_feedback_labels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.bulk_upload_feedback_labels.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.bulk_upload_feedback_labels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.bulk_upload_feedback_labels request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Download feedback labels in bulk.
              #
              # @overload bulk_download_feedback_labels(request, options = nil)
              #   Pass arguments to `bulk_download_feedback_labels` via a request object, either of type
              #   {::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload bulk_download_feedback_labels(gcs_destination: nil, parent: nil, filter: nil, max_download_count: nil, feedback_label_type: nil, conversation_filter: nil, template_qa_scorecard_id: nil)
              #   Pass arguments to `bulk_download_feedback_labels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_destination [::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest::GcsDestination, ::Hash]
              #     A cloud storage bucket destination.
              #   @param parent [::String]
              #     Required. The parent resource for new feedback labels.
              #   @param filter [::String]
              #     Optional. A filter to reduce results to a specific subset. Supports
              #     disjunctions (OR) and conjunctions (AND).
              #
              #     Supported fields:
              #
              #     * `issue_model_id`
              #     * `qa_question_id`
              #     * `qa_scorecard_id`
              #     * `min_create_time`
              #     * `max_create_time`
              #     * `min_update_time`
              #     * `max_update_time`
              #     * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
              #   @param max_download_count [::Integer]
              #     Optional. Limits the maximum number of feedback labels that will be
              #     downloaded. The first `N` feedback labels will be downloaded.
              #   @param feedback_label_type [::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest::FeedbackLabelType]
              #     Optional. The type of feedback labels that will be downloaded.
              #   @param conversation_filter [::String]
              #     Optional. Filter parent conversations to download feedback labels for.
              #     When specified, the feedback labels will be downloaded for the
              #     conversations that match the filter.
              #     If `template_qa_scorecard_id` is set, all the conversations that match the
              #     filter will be paired with the questions under the scorecard for labeling.
              #   @param template_qa_scorecard_id [::Array<::String>]
              #     Optional. If set, a template for labeling conversations and scorecard
              #     questions will be created from the conversation_filter and the questions
              #     under the scorecard(s). The feedback label `filter` will be ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/contact_center_insights/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest.new
              #
              #   # Call the bulk_download_feedback_labels method.
              #   result = client.bulk_download_feedback_labels request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def bulk_download_feedback_labels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ContactCenterInsights::V1::BulkDownloadFeedbackLabelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.bulk_download_feedback_labels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ContactCenterInsights::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.bulk_download_feedback_labels.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.bulk_download_feedback_labels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @contact_center_insights_stub.bulk_download_feedback_labels request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ContactCenterInsights REST API.
              #
              # This class represents the configuration for ContactCenterInsights REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_conversation to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_conversation.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ContactCenterInsights::V1::ContactCenterInsights::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_conversation.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "contactcenterinsights.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ContactCenterInsights API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_conversation
                  ##
                  # RPC-specific configuration for `upload_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :upload_conversation
                  ##
                  # RPC-specific configuration for `update_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_conversation
                  ##
                  # RPC-specific configuration for `get_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_conversation
                  ##
                  # RPC-specific configuration for `list_conversations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_conversations
                  ##
                  # RPC-specific configuration for `delete_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_conversation
                  ##
                  # RPC-specific configuration for `create_analysis`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_analysis
                  ##
                  # RPC-specific configuration for `get_analysis`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_analysis
                  ##
                  # RPC-specific configuration for `list_analyses`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_analyses
                  ##
                  # RPC-specific configuration for `delete_analysis`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_analysis
                  ##
                  # RPC-specific configuration for `bulk_analyze_conversations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :bulk_analyze_conversations
                  ##
                  # RPC-specific configuration for `bulk_delete_conversations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :bulk_delete_conversations
                  ##
                  # RPC-specific configuration for `ingest_conversations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :ingest_conversations
                  ##
                  # RPC-specific configuration for `export_insights_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_insights_data
                  ##
                  # RPC-specific configuration for `create_issue_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_issue_model
                  ##
                  # RPC-specific configuration for `update_issue_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_issue_model
                  ##
                  # RPC-specific configuration for `get_issue_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_issue_model
                  ##
                  # RPC-specific configuration for `list_issue_models`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_issue_models
                  ##
                  # RPC-specific configuration for `delete_issue_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_issue_model
                  ##
                  # RPC-specific configuration for `deploy_issue_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :deploy_issue_model
                  ##
                  # RPC-specific configuration for `undeploy_issue_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :undeploy_issue_model
                  ##
                  # RPC-specific configuration for `export_issue_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_issue_model
                  ##
                  # RPC-specific configuration for `import_issue_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_issue_model
                  ##
                  # RPC-specific configuration for `get_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_issue
                  ##
                  # RPC-specific configuration for `list_issues`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_issues
                  ##
                  # RPC-specific configuration for `update_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_issue
                  ##
                  # RPC-specific configuration for `delete_issue`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_issue
                  ##
                  # RPC-specific configuration for `calculate_issue_model_stats`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :calculate_issue_model_stats
                  ##
                  # RPC-specific configuration for `create_phrase_matcher`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_phrase_matcher
                  ##
                  # RPC-specific configuration for `get_phrase_matcher`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_phrase_matcher
                  ##
                  # RPC-specific configuration for `list_phrase_matchers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_phrase_matchers
                  ##
                  # RPC-specific configuration for `delete_phrase_matcher`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_phrase_matcher
                  ##
                  # RPC-specific configuration for `update_phrase_matcher`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_phrase_matcher
                  ##
                  # RPC-specific configuration for `calculate_stats`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :calculate_stats
                  ##
                  # RPC-specific configuration for `get_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_settings
                  ##
                  # RPC-specific configuration for `update_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_settings
                  ##
                  # RPC-specific configuration for `create_analysis_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_analysis_rule
                  ##
                  # RPC-specific configuration for `get_analysis_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_analysis_rule
                  ##
                  # RPC-specific configuration for `list_analysis_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_analysis_rules
                  ##
                  # RPC-specific configuration for `update_analysis_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_analysis_rule
                  ##
                  # RPC-specific configuration for `delete_analysis_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_analysis_rule
                  ##
                  # RPC-specific configuration for `get_encryption_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_encryption_spec
                  ##
                  # RPC-specific configuration for `initialize_encryption_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :initialize_encryption_spec
                  ##
                  # RPC-specific configuration for `create_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_view
                  ##
                  # RPC-specific configuration for `get_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_view
                  ##
                  # RPC-specific configuration for `list_views`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_views
                  ##
                  # RPC-specific configuration for `update_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_view
                  ##
                  # RPC-specific configuration for `delete_view`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_view
                  ##
                  # RPC-specific configuration for `query_metrics`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :query_metrics
                  ##
                  # RPC-specific configuration for `create_qa_question`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_qa_question
                  ##
                  # RPC-specific configuration for `get_qa_question`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_qa_question
                  ##
                  # RPC-specific configuration for `update_qa_question`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_qa_question
                  ##
                  # RPC-specific configuration for `delete_qa_question`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_qa_question
                  ##
                  # RPC-specific configuration for `list_qa_questions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_qa_questions
                  ##
                  # RPC-specific configuration for `create_qa_scorecard`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_qa_scorecard
                  ##
                  # RPC-specific configuration for `get_qa_scorecard`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_qa_scorecard
                  ##
                  # RPC-specific configuration for `update_qa_scorecard`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_qa_scorecard
                  ##
                  # RPC-specific configuration for `delete_qa_scorecard`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_qa_scorecard
                  ##
                  # RPC-specific configuration for `list_qa_scorecards`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_qa_scorecards
                  ##
                  # RPC-specific configuration for `create_qa_scorecard_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_qa_scorecard_revision
                  ##
                  # RPC-specific configuration for `get_qa_scorecard_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_qa_scorecard_revision
                  ##
                  # RPC-specific configuration for `tune_qa_scorecard_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :tune_qa_scorecard_revision
                  ##
                  # RPC-specific configuration for `deploy_qa_scorecard_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :deploy_qa_scorecard_revision
                  ##
                  # RPC-specific configuration for `undeploy_qa_scorecard_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :undeploy_qa_scorecard_revision
                  ##
                  # RPC-specific configuration for `delete_qa_scorecard_revision`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_qa_scorecard_revision
                  ##
                  # RPC-specific configuration for `list_qa_scorecard_revisions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_qa_scorecard_revisions
                  ##
                  # RPC-specific configuration for `create_feedback_label`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_feedback_label
                  ##
                  # RPC-specific configuration for `list_feedback_labels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_feedback_labels
                  ##
                  # RPC-specific configuration for `get_feedback_label`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_feedback_label
                  ##
                  # RPC-specific configuration for `update_feedback_label`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_feedback_label
                  ##
                  # RPC-specific configuration for `delete_feedback_label`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_feedback_label
                  ##
                  # RPC-specific configuration for `list_all_feedback_labels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_all_feedback_labels
                  ##
                  # RPC-specific configuration for `bulk_upload_feedback_labels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :bulk_upload_feedback_labels
                  ##
                  # RPC-specific configuration for `bulk_download_feedback_labels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :bulk_download_feedback_labels

                  # @private
                  def initialize parent_rpcs = nil
                    create_conversation_config = parent_rpcs.create_conversation if parent_rpcs.respond_to? :create_conversation
                    @create_conversation = ::Gapic::Config::Method.new create_conversation_config
                    upload_conversation_config = parent_rpcs.upload_conversation if parent_rpcs.respond_to? :upload_conversation
                    @upload_conversation = ::Gapic::Config::Method.new upload_conversation_config
                    update_conversation_config = parent_rpcs.update_conversation if parent_rpcs.respond_to? :update_conversation
                    @update_conversation = ::Gapic::Config::Method.new update_conversation_config
                    get_conversation_config = parent_rpcs.get_conversation if parent_rpcs.respond_to? :get_conversation
                    @get_conversation = ::Gapic::Config::Method.new get_conversation_config
                    list_conversations_config = parent_rpcs.list_conversations if parent_rpcs.respond_to? :list_conversations
                    @list_conversations = ::Gapic::Config::Method.new list_conversations_config
                    delete_conversation_config = parent_rpcs.delete_conversation if parent_rpcs.respond_to? :delete_conversation
                    @delete_conversation = ::Gapic::Config::Method.new delete_conversation_config
                    create_analysis_config = parent_rpcs.create_analysis if parent_rpcs.respond_to? :create_analysis
                    @create_analysis = ::Gapic::Config::Method.new create_analysis_config
                    get_analysis_config = parent_rpcs.get_analysis if parent_rpcs.respond_to? :get_analysis
                    @get_analysis = ::Gapic::Config::Method.new get_analysis_config
                    list_analyses_config = parent_rpcs.list_analyses if parent_rpcs.respond_to? :list_analyses
                    @list_analyses = ::Gapic::Config::Method.new list_analyses_config
                    delete_analysis_config = parent_rpcs.delete_analysis if parent_rpcs.respond_to? :delete_analysis
                    @delete_analysis = ::Gapic::Config::Method.new delete_analysis_config
                    bulk_analyze_conversations_config = parent_rpcs.bulk_analyze_conversations if parent_rpcs.respond_to? :bulk_analyze_conversations
                    @bulk_analyze_conversations = ::Gapic::Config::Method.new bulk_analyze_conversations_config
                    bulk_delete_conversations_config = parent_rpcs.bulk_delete_conversations if parent_rpcs.respond_to? :bulk_delete_conversations
                    @bulk_delete_conversations = ::Gapic::Config::Method.new bulk_delete_conversations_config
                    ingest_conversations_config = parent_rpcs.ingest_conversations if parent_rpcs.respond_to? :ingest_conversations
                    @ingest_conversations = ::Gapic::Config::Method.new ingest_conversations_config
                    export_insights_data_config = parent_rpcs.export_insights_data if parent_rpcs.respond_to? :export_insights_data
                    @export_insights_data = ::Gapic::Config::Method.new export_insights_data_config
                    create_issue_model_config = parent_rpcs.create_issue_model if parent_rpcs.respond_to? :create_issue_model
                    @create_issue_model = ::Gapic::Config::Method.new create_issue_model_config
                    update_issue_model_config = parent_rpcs.update_issue_model if parent_rpcs.respond_to? :update_issue_model
                    @update_issue_model = ::Gapic::Config::Method.new update_issue_model_config
                    get_issue_model_config = parent_rpcs.get_issue_model if parent_rpcs.respond_to? :get_issue_model
                    @get_issue_model = ::Gapic::Config::Method.new get_issue_model_config
                    list_issue_models_config = parent_rpcs.list_issue_models if parent_rpcs.respond_to? :list_issue_models
                    @list_issue_models = ::Gapic::Config::Method.new list_issue_models_config
                    delete_issue_model_config = parent_rpcs.delete_issue_model if parent_rpcs.respond_to? :delete_issue_model
                    @delete_issue_model = ::Gapic::Config::Method.new delete_issue_model_config
                    deploy_issue_model_config = parent_rpcs.deploy_issue_model if parent_rpcs.respond_to? :deploy_issue_model
                    @deploy_issue_model = ::Gapic::Config::Method.new deploy_issue_model_config
                    undeploy_issue_model_config = parent_rpcs.undeploy_issue_model if parent_rpcs.respond_to? :undeploy_issue_model
                    @undeploy_issue_model = ::Gapic::Config::Method.new undeploy_issue_model_config
                    export_issue_model_config = parent_rpcs.export_issue_model if parent_rpcs.respond_to? :export_issue_model
                    @export_issue_model = ::Gapic::Config::Method.new export_issue_model_config
                    import_issue_model_config = parent_rpcs.import_issue_model if parent_rpcs.respond_to? :import_issue_model
                    @import_issue_model = ::Gapic::Config::Method.new import_issue_model_config
                    get_issue_config = parent_rpcs.get_issue if parent_rpcs.respond_to? :get_issue
                    @get_issue = ::Gapic::Config::Method.new get_issue_config
                    list_issues_config = parent_rpcs.list_issues if parent_rpcs.respond_to? :list_issues
                    @list_issues = ::Gapic::Config::Method.new list_issues_config
                    update_issue_config = parent_rpcs.update_issue if parent_rpcs.respond_to? :update_issue
                    @update_issue = ::Gapic::Config::Method.new update_issue_config
                    delete_issue_config = parent_rpcs.delete_issue if parent_rpcs.respond_to? :delete_issue
                    @delete_issue = ::Gapic::Config::Method.new delete_issue_config
                    calculate_issue_model_stats_config = parent_rpcs.calculate_issue_model_stats if parent_rpcs.respond_to? :calculate_issue_model_stats
                    @calculate_issue_model_stats = ::Gapic::Config::Method.new calculate_issue_model_stats_config
                    create_phrase_matcher_config = parent_rpcs.create_phrase_matcher if parent_rpcs.respond_to? :create_phrase_matcher
                    @create_phrase_matcher = ::Gapic::Config::Method.new create_phrase_matcher_config
                    get_phrase_matcher_config = parent_rpcs.get_phrase_matcher if parent_rpcs.respond_to? :get_phrase_matcher
                    @get_phrase_matcher = ::Gapic::Config::Method.new get_phrase_matcher_config
                    list_phrase_matchers_config = parent_rpcs.list_phrase_matchers if parent_rpcs.respond_to? :list_phrase_matchers
                    @list_phrase_matchers = ::Gapic::Config::Method.new list_phrase_matchers_config
                    delete_phrase_matcher_config = parent_rpcs.delete_phrase_matcher if parent_rpcs.respond_to? :delete_phrase_matcher
                    @delete_phrase_matcher = ::Gapic::Config::Method.new delete_phrase_matcher_config
                    update_phrase_matcher_config = parent_rpcs.update_phrase_matcher if parent_rpcs.respond_to? :update_phrase_matcher
                    @update_phrase_matcher = ::Gapic::Config::Method.new update_phrase_matcher_config
                    calculate_stats_config = parent_rpcs.calculate_stats if parent_rpcs.respond_to? :calculate_stats
                    @calculate_stats = ::Gapic::Config::Method.new calculate_stats_config
                    get_settings_config = parent_rpcs.get_settings if parent_rpcs.respond_to? :get_settings
                    @get_settings = ::Gapic::Config::Method.new get_settings_config
                    update_settings_config = parent_rpcs.update_settings if parent_rpcs.respond_to? :update_settings
                    @update_settings = ::Gapic::Config::Method.new update_settings_config
                    create_analysis_rule_config = parent_rpcs.create_analysis_rule if parent_rpcs.respond_to? :create_analysis_rule
                    @create_analysis_rule = ::Gapic::Config::Method.new create_analysis_rule_config
                    get_analysis_rule_config = parent_rpcs.get_analysis_rule if parent_rpcs.respond_to? :get_analysis_rule
                    @get_analysis_rule = ::Gapic::Config::Method.new get_analysis_rule_config
                    list_analysis_rules_config = parent_rpcs.list_analysis_rules if parent_rpcs.respond_to? :list_analysis_rules
                    @list_analysis_rules = ::Gapic::Config::Method.new list_analysis_rules_config
                    update_analysis_rule_config = parent_rpcs.update_analysis_rule if parent_rpcs.respond_to? :update_analysis_rule
                    @update_analysis_rule = ::Gapic::Config::Method.new update_analysis_rule_config
                    delete_analysis_rule_config = parent_rpcs.delete_analysis_rule if parent_rpcs.respond_to? :delete_analysis_rule
                    @delete_analysis_rule = ::Gapic::Config::Method.new delete_analysis_rule_config
                    get_encryption_spec_config = parent_rpcs.get_encryption_spec if parent_rpcs.respond_to? :get_encryption_spec
                    @get_encryption_spec = ::Gapic::Config::Method.new get_encryption_spec_config
                    initialize_encryption_spec_config = parent_rpcs.initialize_encryption_spec if parent_rpcs.respond_to? :initialize_encryption_spec
                    @initialize_encryption_spec = ::Gapic::Config::Method.new initialize_encryption_spec_config
                    create_view_config = parent_rpcs.create_view if parent_rpcs.respond_to? :create_view
                    @create_view = ::Gapic::Config::Method.new create_view_config
                    get_view_config = parent_rpcs.get_view if parent_rpcs.respond_to? :get_view
                    @get_view = ::Gapic::Config::Method.new get_view_config
                    list_views_config = parent_rpcs.list_views if parent_rpcs.respond_to? :list_views
                    @list_views = ::Gapic::Config::Method.new list_views_config
                    update_view_config = parent_rpcs.update_view if parent_rpcs.respond_to? :update_view
                    @update_view = ::Gapic::Config::Method.new update_view_config
                    delete_view_config = parent_rpcs.delete_view if parent_rpcs.respond_to? :delete_view
                    @delete_view = ::Gapic::Config::Method.new delete_view_config
                    query_metrics_config = parent_rpcs.query_metrics if parent_rpcs.respond_to? :query_metrics
                    @query_metrics = ::Gapic::Config::Method.new query_metrics_config
                    create_qa_question_config = parent_rpcs.create_qa_question if parent_rpcs.respond_to? :create_qa_question
                    @create_qa_question = ::Gapic::Config::Method.new create_qa_question_config
                    get_qa_question_config = parent_rpcs.get_qa_question if parent_rpcs.respond_to? :get_qa_question
                    @get_qa_question = ::Gapic::Config::Method.new get_qa_question_config
                    update_qa_question_config = parent_rpcs.update_qa_question if parent_rpcs.respond_to? :update_qa_question
                    @update_qa_question = ::Gapic::Config::Method.new update_qa_question_config
                    delete_qa_question_config = parent_rpcs.delete_qa_question if parent_rpcs.respond_to? :delete_qa_question
                    @delete_qa_question = ::Gapic::Config::Method.new delete_qa_question_config
                    list_qa_questions_config = parent_rpcs.list_qa_questions if parent_rpcs.respond_to? :list_qa_questions
                    @list_qa_questions = ::Gapic::Config::Method.new list_qa_questions_config
                    create_qa_scorecard_config = parent_rpcs.create_qa_scorecard if parent_rpcs.respond_to? :create_qa_scorecard
                    @create_qa_scorecard = ::Gapic::Config::Method.new create_qa_scorecard_config
                    get_qa_scorecard_config = parent_rpcs.get_qa_scorecard if parent_rpcs.respond_to? :get_qa_scorecard
                    @get_qa_scorecard = ::Gapic::Config::Method.new get_qa_scorecard_config
                    update_qa_scorecard_config = parent_rpcs.update_qa_scorecard if parent_rpcs.respond_to? :update_qa_scorecard
                    @update_qa_scorecard = ::Gapic::Config::Method.new update_qa_scorecard_config
                    delete_qa_scorecard_config = parent_rpcs.delete_qa_scorecard if parent_rpcs.respond_to? :delete_qa_scorecard
                    @delete_qa_scorecard = ::Gapic::Config::Method.new delete_qa_scorecard_config
                    list_qa_scorecards_config = parent_rpcs.list_qa_scorecards if parent_rpcs.respond_to? :list_qa_scorecards
                    @list_qa_scorecards = ::Gapic::Config::Method.new list_qa_scorecards_config
                    create_qa_scorecard_revision_config = parent_rpcs.create_qa_scorecard_revision if parent_rpcs.respond_to? :create_qa_scorecard_revision
                    @create_qa_scorecard_revision = ::Gapic::Config::Method.new create_qa_scorecard_revision_config
                    get_qa_scorecard_revision_config = parent_rpcs.get_qa_scorecard_revision if parent_rpcs.respond_to? :get_qa_scorecard_revision
                    @get_qa_scorecard_revision = ::Gapic::Config::Method.new get_qa_scorecard_revision_config
                    tune_qa_scorecard_revision_config = parent_rpcs.tune_qa_scorecard_revision if parent_rpcs.respond_to? :tune_qa_scorecard_revision
                    @tune_qa_scorecard_revision = ::Gapic::Config::Method.new tune_qa_scorecard_revision_config
                    deploy_qa_scorecard_revision_config = parent_rpcs.deploy_qa_scorecard_revision if parent_rpcs.respond_to? :deploy_qa_scorecard_revision
                    @deploy_qa_scorecard_revision = ::Gapic::Config::Method.new deploy_qa_scorecard_revision_config
                    undeploy_qa_scorecard_revision_config = parent_rpcs.undeploy_qa_scorecard_revision if parent_rpcs.respond_to? :undeploy_qa_scorecard_revision
                    @undeploy_qa_scorecard_revision = ::Gapic::Config::Method.new undeploy_qa_scorecard_revision_config
                    delete_qa_scorecard_revision_config = parent_rpcs.delete_qa_scorecard_revision if parent_rpcs.respond_to? :delete_qa_scorecard_revision
                    @delete_qa_scorecard_revision = ::Gapic::Config::Method.new delete_qa_scorecard_revision_config
                    list_qa_scorecard_revisions_config = parent_rpcs.list_qa_scorecard_revisions if parent_rpcs.respond_to? :list_qa_scorecard_revisions
                    @list_qa_scorecard_revisions = ::Gapic::Config::Method.new list_qa_scorecard_revisions_config
                    create_feedback_label_config = parent_rpcs.create_feedback_label if parent_rpcs.respond_to? :create_feedback_label
                    @create_feedback_label = ::Gapic::Config::Method.new create_feedback_label_config
                    list_feedback_labels_config = parent_rpcs.list_feedback_labels if parent_rpcs.respond_to? :list_feedback_labels
                    @list_feedback_labels = ::Gapic::Config::Method.new list_feedback_labels_config
                    get_feedback_label_config = parent_rpcs.get_feedback_label if parent_rpcs.respond_to? :get_feedback_label
                    @get_feedback_label = ::Gapic::Config::Method.new get_feedback_label_config
                    update_feedback_label_config = parent_rpcs.update_feedback_label if parent_rpcs.respond_to? :update_feedback_label
                    @update_feedback_label = ::Gapic::Config::Method.new update_feedback_label_config
                    delete_feedback_label_config = parent_rpcs.delete_feedback_label if parent_rpcs.respond_to? :delete_feedback_label
                    @delete_feedback_label = ::Gapic::Config::Method.new delete_feedback_label_config
                    list_all_feedback_labels_config = parent_rpcs.list_all_feedback_labels if parent_rpcs.respond_to? :list_all_feedback_labels
                    @list_all_feedback_labels = ::Gapic::Config::Method.new list_all_feedback_labels_config
                    bulk_upload_feedback_labels_config = parent_rpcs.bulk_upload_feedback_labels if parent_rpcs.respond_to? :bulk_upload_feedback_labels
                    @bulk_upload_feedback_labels = ::Gapic::Config::Method.new bulk_upload_feedback_labels_config
                    bulk_download_feedback_labels_config = parent_rpcs.bulk_download_feedback_labels if parent_rpcs.respond_to? :bulk_download_feedback_labels
                    @bulk_download_feedback_labels = ::Gapic::Config::Method.new bulk_download_feedback_labels_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
