# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/connectors/v1/connectors_service_pb"
require "google/cloud/connectors/v1/connectors"

class ::Google::Cloud::Connectors::V1::Connectors::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_connections
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::ListConnectionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :CONNECTION_VIEW_UNSPECIFIED

    list_connections_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_connections, name
      assert_kind_of ::Google::Cloud::Connectors::V1::ListConnectionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal :CONNECTION_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_connections_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_connections ::Google::Cloud::Connectors::V1::ListConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_connections(::Google::Cloud::Connectors::V1::ListConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_connections_client_stub.call_rpc_count
    end
  end

  def test_get_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::Connection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :CONNECTION_VIEW_UNSPECIFIED

    get_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connection, name
      assert_kind_of ::Google::Cloud::Connectors::V1::GetConnectionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :CONNECTION_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connection({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connection name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connection ::Google::Cloud::Connectors::V1::GetConnectionRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connection({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connection(::Google::Cloud::Connectors::V1::GetConnectionRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connection_client_stub.call_rpc_count
    end
  end

  def test_create_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_id = "hello world"
    connection = {}

    create_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_connection, name
      assert_kind_of ::Google::Cloud::Connectors::V1::CreateConnectionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["connection_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Connectors::V1::Connection), request["connection"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_connection({ parent: parent, connection_id: connection_id, connection: connection }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_connection parent: parent, connection_id: connection_id, connection: connection do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_connection ::Google::Cloud::Connectors::V1::CreateConnectionRequest.new(parent: parent, connection_id: connection_id, connection: connection) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_connection({ parent: parent, connection_id: connection_id, connection: connection }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_connection(::Google::Cloud::Connectors::V1::CreateConnectionRequest.new(parent: parent, connection_id: connection_id, connection: connection), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_connection_client_stub.call_rpc_count
    end
  end

  def test_update_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    connection = {}
    update_mask = {}

    update_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_connection, name
      assert_kind_of ::Google::Cloud::Connectors::V1::UpdateConnectionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Connectors::V1::Connection), request["connection"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_connection({ connection: connection, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_connection connection: connection, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_connection ::Google::Cloud::Connectors::V1::UpdateConnectionRequest.new(connection: connection, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_connection({ connection: connection, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_connection(::Google::Cloud::Connectors::V1::UpdateConnectionRequest.new(connection: connection, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_connection_client_stub.call_rpc_count
    end
  end

  def test_delete_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_connection, name
      assert_kind_of ::Google::Cloud::Connectors::V1::DeleteConnectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_connection({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_connection name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_connection ::Google::Cloud::Connectors::V1::DeleteConnectionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_connection({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_connection(::Google::Cloud::Connectors::V1::DeleteConnectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_connection_client_stub.call_rpc_count
    end
  end

  def test_list_providers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::ListProvidersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_providers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_providers, name
      assert_kind_of ::Google::Cloud::Connectors::V1::ListProvidersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_providers_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_providers({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_providers parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_providers ::Google::Cloud::Connectors::V1::ListProvidersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_providers({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_providers(::Google::Cloud::Connectors::V1::ListProvidersRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_providers_client_stub.call_rpc_count
    end
  end

  def test_get_provider
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::Provider.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_provider_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_provider, name
      assert_kind_of ::Google::Cloud::Connectors::V1::GetProviderRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_provider_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_provider({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_provider name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_provider ::Google::Cloud::Connectors::V1::GetProviderRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_provider({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_provider(::Google::Cloud::Connectors::V1::GetProviderRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_provider_client_stub.call_rpc_count
    end
  end

  def test_list_connectors
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::ListConnectorsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_connectors_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_connectors, name
      assert_kind_of ::Google::Cloud::Connectors::V1::ListConnectorsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_connectors_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_connectors({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_connectors parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_connectors ::Google::Cloud::Connectors::V1::ListConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_connectors({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_connectors(::Google::Cloud::Connectors::V1::ListConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_connectors_client_stub.call_rpc_count
    end
  end

  def test_get_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::Connector.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connector, name
      assert_kind_of ::Google::Cloud::Connectors::V1::GetConnectorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connector_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connector({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connector name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connector ::Google::Cloud::Connectors::V1::GetConnectorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connector({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connector(::Google::Cloud::Connectors::V1::GetConnectorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connector_client_stub.call_rpc_count
    end
  end

  def test_list_connector_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::ListConnectorVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :CONNECTOR_VERSION_VIEW_UNSPECIFIED

    list_connector_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_connector_versions, name
      assert_kind_of ::Google::Cloud::Connectors::V1::ListConnectorVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :CONNECTOR_VERSION_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_connector_versions_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_connector_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_connector_versions parent: parent, page_size: page_size, page_token: page_token, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_connector_versions ::Google::Cloud::Connectors::V1::ListConnectorVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_connector_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_connector_versions(::Google::Cloud::Connectors::V1::ListConnectorVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_connector_versions_client_stub.call_rpc_count
    end
  end

  def test_get_connector_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::ConnectorVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :CONNECTOR_VERSION_VIEW_UNSPECIFIED

    get_connector_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connector_version, name
      assert_kind_of ::Google::Cloud::Connectors::V1::GetConnectorVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :CONNECTOR_VERSION_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connector_version_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connector_version({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connector_version name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connector_version ::Google::Cloud::Connectors::V1::GetConnectorVersionRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connector_version({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connector_version(::Google::Cloud::Connectors::V1::GetConnectorVersionRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connector_version_client_stub.call_rpc_count
    end
  end

  def test_get_connection_schema_metadata
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::ConnectionSchemaMetadata.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connection_schema_metadata_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connection_schema_metadata, name
      assert_kind_of ::Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connection_schema_metadata_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connection_schema_metadata({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connection_schema_metadata name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connection_schema_metadata ::Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connection_schema_metadata({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connection_schema_metadata(::Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connection_schema_metadata_client_stub.call_rpc_count
    end
  end

  def test_refresh_connection_schema_metadata
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    refresh_connection_schema_metadata_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :refresh_connection_schema_metadata, name
      assert_kind_of ::Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, refresh_connection_schema_metadata_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.refresh_connection_schema_metadata({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.refresh_connection_schema_metadata name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.refresh_connection_schema_metadata ::Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.refresh_connection_schema_metadata({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.refresh_connection_schema_metadata(::Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, refresh_connection_schema_metadata_client_stub.call_rpc_count
    end
  end

  def test_list_runtime_entity_schemas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_runtime_entity_schemas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_runtime_entity_schemas, name
      assert_kind_of ::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_runtime_entity_schemas_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_runtime_entity_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_runtime_entity_schemas parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_runtime_entity_schemas ::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_runtime_entity_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_runtime_entity_schemas(::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_runtime_entity_schemas_client_stub.call_rpc_count
    end
  end

  def test_list_runtime_action_schemas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_runtime_action_schemas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_runtime_action_schemas, name
      assert_kind_of ::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_runtime_action_schemas_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_runtime_action_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_runtime_action_schemas parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_runtime_action_schemas ::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_runtime_action_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_runtime_action_schemas(::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_runtime_action_schemas_client_stub.call_rpc_count
    end
  end

  def test_get_runtime_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::RuntimeConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_runtime_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_runtime_config, name
      assert_kind_of ::Google::Cloud::Connectors::V1::GetRuntimeConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_runtime_config_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_runtime_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_runtime_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_runtime_config ::Google::Cloud::Connectors::V1::GetRuntimeConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_runtime_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_runtime_config(::Google::Cloud::Connectors::V1::GetRuntimeConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_runtime_config_client_stub.call_rpc_count
    end
  end

  def test_get_global_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Connectors::V1::Settings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_global_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_global_settings, name
      assert_kind_of ::Google::Cloud::Connectors::V1::GetGlobalSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_global_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_global_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_global_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_global_settings ::Google::Cloud::Connectors::V1::GetGlobalSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_global_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_global_settings(::Google::Cloud::Connectors::V1::GetGlobalSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_global_settings_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Connectors::V1::Connectors::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Connectors::V1::Connectors::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Connectors::V1::Connectors::Operations, client.operations_client
  end
end
