# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/connectors/v1/connectors_service_pb"
require "google/cloud/connectors/v1/connectors/rest"


class ::Google::Cloud::Connectors::V1::Connectors::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_connections
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::ListConnectionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :CONNECTION_VIEW_UNSPECIFIED

    list_connections_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_list_connections_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_connections_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_connections ::Google::Cloud::Connectors::V1::ListConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_connections(::Google::Cloud::Connectors::V1::ListConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_connections_client_stub.call_count
      end
    end
  end

  def test_get_connection
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::Connection.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :CONNECTION_VIEW_UNSPECIFIED

    get_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_get_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_connection({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_connection name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_connection ::Google::Cloud::Connectors::V1::GetConnectionRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_connection({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_connection(::Google::Cloud::Connectors::V1::GetConnectionRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_connection_client_stub.call_count
      end
    end
  end

  def test_create_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_id = "hello world"
    connection = {}

    create_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_create_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_connection({ parent: parent, connection_id: connection_id, connection: connection }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_connection parent: parent, connection_id: connection_id, connection: connection do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_connection ::Google::Cloud::Connectors::V1::CreateConnectionRequest.new(parent: parent, connection_id: connection_id, connection: connection) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_connection({ parent: parent, connection_id: connection_id, connection: connection }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_connection(::Google::Cloud::Connectors::V1::CreateConnectionRequest.new(parent: parent, connection_id: connection_id, connection: connection), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_connection_client_stub.call_count
      end
    end
  end

  def test_update_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    connection = {}
    update_mask = {}

    update_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_update_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_connection({ connection: connection, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_connection connection: connection, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_connection ::Google::Cloud::Connectors::V1::UpdateConnectionRequest.new(connection: connection, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_connection({ connection: connection, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_connection(::Google::Cloud::Connectors::V1::UpdateConnectionRequest.new(connection: connection, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_connection_client_stub.call_count
      end
    end
  end

  def test_delete_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_delete_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_connection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_connection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_connection ::Google::Cloud::Connectors::V1::DeleteConnectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_connection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_connection(::Google::Cloud::Connectors::V1::DeleteConnectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_connection_client_stub.call_count
      end
    end
  end

  def test_list_providers
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::ListProvidersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_providers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_list_providers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_providers_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_providers({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_providers parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_providers ::Google::Cloud::Connectors::V1::ListProvidersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_providers({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_providers(::Google::Cloud::Connectors::V1::ListProvidersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_providers_client_stub.call_count
      end
    end
  end

  def test_get_provider
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::Provider.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_provider_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_get_provider_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_provider_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_provider({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_provider name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_provider ::Google::Cloud::Connectors::V1::GetProviderRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_provider({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_provider(::Google::Cloud::Connectors::V1::GetProviderRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_provider_client_stub.call_count
      end
    end
  end

  def test_list_connectors
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::ListConnectorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_connectors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_list_connectors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_connectors_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_connectors({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_connectors parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_connectors ::Google::Cloud::Connectors::V1::ListConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_connectors({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_connectors(::Google::Cloud::Connectors::V1::ListConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_connectors_client_stub.call_count
      end
    end
  end

  def test_get_connector
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::Connector.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_get_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_connector_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_connector ::Google::Cloud::Connectors::V1::GetConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_connector(::Google::Cloud::Connectors::V1::GetConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_connector_client_stub.call_count
      end
    end
  end

  def test_list_connector_versions
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::ListConnectorVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :CONNECTOR_VERSION_VIEW_UNSPECIFIED

    list_connector_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_list_connector_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_connector_versions_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_connector_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_connector_versions parent: parent, page_size: page_size, page_token: page_token, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_connector_versions ::Google::Cloud::Connectors::V1::ListConnectorVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_connector_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_connector_versions(::Google::Cloud::Connectors::V1::ListConnectorVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_connector_versions_client_stub.call_count
      end
    end
  end

  def test_get_connector_version
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::ConnectorVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :CONNECTOR_VERSION_VIEW_UNSPECIFIED

    get_connector_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_get_connector_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_connector_version_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_connector_version({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_connector_version name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_connector_version ::Google::Cloud::Connectors::V1::GetConnectorVersionRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_connector_version({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_connector_version(::Google::Cloud::Connectors::V1::GetConnectorVersionRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_connector_version_client_stub.call_count
      end
    end
  end

  def test_get_connection_schema_metadata
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::ConnectionSchemaMetadata.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connection_schema_metadata_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_get_connection_schema_metadata_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_connection_schema_metadata_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_connection_schema_metadata({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_connection_schema_metadata name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_connection_schema_metadata ::Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_connection_schema_metadata({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_connection_schema_metadata(::Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_connection_schema_metadata_client_stub.call_count
      end
    end
  end

  def test_refresh_connection_schema_metadata
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    refresh_connection_schema_metadata_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_refresh_connection_schema_metadata_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, refresh_connection_schema_metadata_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.refresh_connection_schema_metadata({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.refresh_connection_schema_metadata name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.refresh_connection_schema_metadata ::Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.refresh_connection_schema_metadata({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.refresh_connection_schema_metadata(::Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, refresh_connection_schema_metadata_client_stub.call_count
      end
    end
  end

  def test_list_runtime_entity_schemas
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_runtime_entity_schemas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_list_runtime_entity_schemas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_runtime_entity_schemas_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_runtime_entity_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_runtime_entity_schemas parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_runtime_entity_schemas ::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_runtime_entity_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_runtime_entity_schemas(::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_runtime_entity_schemas_client_stub.call_count
      end
    end
  end

  def test_list_runtime_action_schemas
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_runtime_action_schemas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_list_runtime_action_schemas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_runtime_action_schemas_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_runtime_action_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_runtime_action_schemas parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_runtime_action_schemas ::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_runtime_action_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_runtime_action_schemas(::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_runtime_action_schemas_client_stub.call_count
      end
    end
  end

  def test_get_runtime_config
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::RuntimeConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_runtime_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_get_runtime_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_runtime_config_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_runtime_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_runtime_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_runtime_config ::Google::Cloud::Connectors::V1::GetRuntimeConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_runtime_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_runtime_config(::Google::Cloud::Connectors::V1::GetRuntimeConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_runtime_config_client_stub.call_count
      end
    end
  end

  def test_get_global_settings
    # Create test objects.
    client_result = ::Google::Cloud::Connectors::V1::Settings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_global_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.stub :transcode_get_global_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_global_settings_client_stub do
        # Create client
        client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_global_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_global_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_global_settings ::Google::Cloud::Connectors::V1::GetGlobalSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_global_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_global_settings(::Google::Cloud::Connectors::V1::GetGlobalSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_global_settings_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Connectors::V1::Connectors::Rest::Client::Configuration, config
  end
end
