# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/connectors/v1/connectors"

class ::Google::Cloud::Connectors::V1::Connectors::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_connection_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.connection_path project: "value0", location: "value1", connection: "value2"
      assert_equal "projects/value0/locations/value1/connections/value2", path
    end
  end

  def test_connection_schema_metadata_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.connection_schema_metadata_path project: "value0", location: "value1", connection: "value2"
      assert_equal "projects/value0/locations/value1/connections/value2/connectionSchemaMetadata", path
    end
  end

  def test_connector_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.connector_path project: "value0", location: "value1", provider: "value2", connector: "value3"
      assert_equal "projects/value0/locations/value1/providers/value2/connectors/value3", path
    end
  end

  def test_connector_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.connector_version_path project: "value0", location: "value1", provider: "value2", connector: "value3", version: "value4"
      assert_equal "projects/value0/locations/value1/providers/value2/connectors/value3/versions/value4", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_provider_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.provider_path project: "value0", location: "value1", provider: "value2"
      assert_equal "projects/value0/locations/value1/providers/value2", path
    end
  end

  def test_runtime_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.runtime_config_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/runtimeConfig", path
    end
  end

  def test_settings_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Connectors::V1::Connectors::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.settings_path project: "value0"
      assert_equal "projects/value0/locations/global/settings", path
    end
  end
end
