# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Connectors
      module V1
        # Ssl config details of a connector version
        # @!attribute [rw] ssl_type
        #   @return [::Google::Cloud::Connectors::V1::SslType]
        #     Controls the ssl type for the given connector version
        # @!attribute [rw] is_tls_mandatory
        #   @return [::Boolean]
        #     Boolean for determining if the connector version mandates TLS.
        # @!attribute [rw] server_cert_type
        #   @return [::Array<::Google::Cloud::Connectors::V1::CertType>]
        #     List of supported Server Cert Types
        # @!attribute [rw] client_cert_type
        #   @return [::Array<::Google::Cloud::Connectors::V1::CertType>]
        #     List of supported Client Cert Types
        # @!attribute [rw] additional_variables
        #   @return [::Array<::Google::Cloud::Connectors::V1::ConfigVariableTemplate>]
        #     Any additional fields that need to be rendered
        class SslConfigTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SSL Configuration of a connection
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Connectors::V1::SslType]
        #     Controls the ssl type for the given connector version.
        # @!attribute [rw] trust_model
        #   @return [::Google::Cloud::Connectors::V1::SslConfig::TrustModel]
        #     Trust Model of the SSL connection
        # @!attribute [rw] private_server_certificate
        #   @return [::Google::Cloud::Connectors::V1::Secret]
        #     Private Server Certificate. Needs to be specified if trust model is
        #     `PRIVATE`.
        # @!attribute [rw] client_certificate
        #   @return [::Google::Cloud::Connectors::V1::Secret]
        #     Client Certificate
        # @!attribute [rw] client_private_key
        #   @return [::Google::Cloud::Connectors::V1::Secret]
        #     Client Private Key
        # @!attribute [rw] client_private_key_pass
        #   @return [::Google::Cloud::Connectors::V1::Secret]
        #     Secret containing the passphrase protecting the Client Private Key
        # @!attribute [rw] server_cert_type
        #   @return [::Google::Cloud::Connectors::V1::CertType]
        #     Type of Server Cert (PEM/JKS/.. etc.)
        # @!attribute [rw] client_cert_type
        #   @return [::Google::Cloud::Connectors::V1::CertType]
        #     Type of Client Cert (PEM/JKS/.. etc.)
        # @!attribute [rw] use_ssl
        #   @return [::Boolean]
        #     Bool for enabling SSL
        # @!attribute [rw] additional_variables
        #   @return [::Array<::Google::Cloud::Connectors::V1::ConfigVariable>]
        #     Additional SSL related field values
        class SslConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum for Ttust Model
          module TrustModel
            # Public Trust Model. Takes the Default Java trust store.
            PUBLIC = 0

            # Private Trust Model. Takes custom/private trust store.
            PRIVATE = 1

            # Insecure Trust Model. Accept all certificates.
            INSECURE = 2
          end
        end

        # Enum for controlling the SSL Type (TLS/MTLS)
        module SslType
          # No SSL configuration required.
          SSL_TYPE_UNSPECIFIED = 0

          # TLS Handshake
          TLS = 1

          # mutual TLS (MTLS) Handshake
          MTLS = 2
        end

        # Enum for Cert Types
        module CertType
          # Cert type unspecified.
          CERT_TYPE_UNSPECIFIED = 0

          # Privacy Enhanced Mail (PEM) Type
          PEM = 1
        end
      end
    end
  end
end
