# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Connectors
      module V1
        # Request message for Connectors.GetRuntimeConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the form:
        #     `projects/*/locations/*/runtimeConfig`
        class GetRuntimeConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RuntimeConfig is the singleton resource of each location.
        # It includes generic resource configs consumed by control plane and runtime
        # plane like: pub/sub topic/subscription resource name, Cloud Storage location
        # storing schema etc.
        # @!attribute [r] location_id
        #   @return [::String]
        #     Output only. location_id of the runtime location. E.g. "us-west1".
        # @!attribute [r] connd_topic
        #   @return [::String]
        #     Output only. Pub/Sub topic for connd to send message.
        #     E.g. projects/\\{project-id}/topics/\\{topic-id}
        # @!attribute [r] connd_subscription
        #   @return [::String]
        #     Output only. Pub/Sub subscription for connd to receive message.
        #     E.g. projects/\\{project-id}/subscriptions/\\{topic-id}
        # @!attribute [r] control_plane_topic
        #   @return [::String]
        #     Output only. Pub/Sub topic for control plne to send message.
        #     communication.
        #     E.g. projects/\\{project-id}/topics/\\{topic-id}
        # @!attribute [r] control_plane_subscription
        #   @return [::String]
        #     Output only. Pub/Sub subscription for control plane to receive message.
        #     E.g. projects/\\{project-id}/subscriptions/\\{topic-id}
        # @!attribute [r] runtime_endpoint
        #   @return [::String]
        #     Output only. The endpoint of the connectors runtime ingress.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Connectors::V1::RuntimeConfig::State]
        #     Output only. The state of the location.
        # @!attribute [r] schema_gcs_bucket
        #   @return [::String]
        #     Output only. The Cloud Storage bucket that stores connector's schema
        #     reports.
        # @!attribute [r] service_directory
        #   @return [::String]
        #     Output only. The name of the Service Directory service name.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the runtimeConfig resource.
        #     Format: projects/\\{project}/locations/\\{location}/runtimeConfig
        class RuntimeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the location.
          module State
            # STATE_UNSPECIFIED.
            STATE_UNSPECIFIED = 0

            # INACTIVE.
            INACTIVE = 1

            # ACTIVATING.
            ACTIVATING = 2

            # ACTIVE.
            ACTIVE = 3

            # CREATING.
            CREATING = 4

            # DELETING.
            DELETING = 5

            # UPDATING.
            UPDATING = 6
          end
        end
      end
    end
  end
end
