# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Connectors
      module V1
        # Provider indicates the owner who provides the connectors.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the Provider.
        #     Format: projects/\\{project}/locations/\\{location}/providers/\\{provider}
        #     Only global location is supported for Provider resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Created time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Updated time.
        # @!attribute [r] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Resource labels to represent user-provided metadata.
        #     Refer to cloud documentation on labels for more details.
        #     https://cloud.google.com/compute/docs/labeling-resources
        # @!attribute [r] documentation_uri
        #   @return [::String]
        #     Output only. Link to documentation page.
        # @!attribute [r] external_uri
        #   @return [::String]
        #     Output only. Link to external page.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. Description of the resource.
        # @!attribute [r] web_assets_location
        #   @return [::String]
        #     Output only. Cloud storage location of icons etc consumed by UI.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name.
        # @!attribute [r] launch_stage
        #   @return [::Google::Cloud::Connectors::V1::LaunchStage]
        #     Output only. Flag to mark the version indicating the launch stage.
        class Provider
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for Connectors.GetProvider.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the form:
        #     `projects/*/locations/*/providers/*`
        #     Only global location is supported for Provider resource.
        class GetProviderRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for Connectors.ListProviders.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource of the API, of the form:
        #     `projects/*/locations/*`
        #     Only global location is supported for Provider resource.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token.
        class ListProvidersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for Connectors.ListProviders.
        # @!attribute [rw] providers
        #   @return [::Array<::Google::Cloud::Connectors::V1::Provider>]
        #     A list of providers.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Next page token.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListProvidersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
