# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Connectors
      module V1
        # Define the Connectors target endpoint.
        # @!attribute [rw] key
        #   @return [::String]
        #     The key is the destination identifier that is supported by the Connector.
        # @!attribute [rw] destinations
        #   @return [::Array<::Google::Cloud::Connectors::V1::Destination>]
        #     The destinations for the key.
        class DestinationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] service_attachment
        #   @return [::String]
        #     PSC service attachments.
        #     Format: projects/*/regions/*/serviceAttachments/*
        #
        #     Note: The following fields are mutually exclusive: `service_attachment`, `host`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] host
        #   @return [::String]
        #     For publicly routable host.
        #
        #     Note: The following fields are mutually exclusive: `host`, `service_attachment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     The port is the target port number that is accepted by the destination.
        class Destination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
