# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Connectors
      module V1
        # ConnectorVersion indicates a specific version of a connector.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the Version.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/providers/\\{provider}/connectors/\\{connector}/versions/\\{version}
        #     Only global location is supported for Connector resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Created time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Updated time.
        # @!attribute [r] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Resource labels to represent user-provided metadata.
        #     Refer to cloud documentation on labels for more details.
        #     https://cloud.google.com/compute/docs/labeling-resources
        # @!attribute [r] launch_stage
        #   @return [::Google::Cloud::Connectors::V1::LaunchStage]
        #     Output only. Flag to mark the version indicating the launch stage.
        # @!attribute [r] release_version
        #   @return [::String]
        #     Output only. ReleaseVersion of the connector, for example: "1.0.1-alpha".
        # @!attribute [r] auth_config_templates
        #   @return [::Array<::Google::Cloud::Connectors::V1::AuthConfigTemplate>]
        #     Output only. List of auth configs supported by the Connector Version.
        # @!attribute [r] config_variable_templates
        #   @return [::Array<::Google::Cloud::Connectors::V1::ConfigVariableTemplate>]
        #     Output only. List of config variables needed to create a connection.
        # @!attribute [r] supported_runtime_features
        #   @return [::Google::Cloud::Connectors::V1::SupportedRuntimeFeatures]
        #     Output only. Information about the runtime features supported by the
        #     Connector.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name.
        # @!attribute [r] egress_control_config
        #   @return [::Google::Cloud::Connectors::V1::EgressControlConfig]
        #     Output only. Configuration for Egress Control.
        # @!attribute [r] role_grants
        #   @return [::Array<::Google::Cloud::Connectors::V1::RoleGrant>]
        #     Output only. Role grant configurations for this connector version.
        # @!attribute [r] role_grant
        #   @return [::Google::Cloud::Connectors::V1::RoleGrant]
        #     Output only. Role grant configuration for this config variable. It will be
        #     DEPRECATED soon.
        # @!attribute [r] ssl_config_template
        #   @return [::Google::Cloud::Connectors::V1::SslConfigTemplate]
        #     Output only. Ssl configuration supported by the Connector.
        class ConnectorVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for Connectors.GetConnectorVersion.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the form:
        #     `projects/*/locations/*/providers/*/connectors/*/versions/*`
        #     Only global location is supported for ConnectorVersion resource.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Connectors::V1::ConnectorVersionView]
        #     Specifies which fields of the ConnectorVersion are returned in the
        #     response. Defaults to `CUSTOMER` view.
        class GetConnectorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for Connectors.ListConnectorVersions.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource of the connectors, of the form:
        #     `projects/*/locations/*/providers/*/connectors/*`
        #     Only global location is supported for ConnectorVersion resource.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Connectors::V1::ConnectorVersionView]
        #     Specifies which fields of the ConnectorVersion are returned in the
        #     response. Defaults to `BASIC` view.
        class ListConnectorVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for Connectors.ListConnectorVersions.
        # @!attribute [rw] connector_versions
        #   @return [::Array<::Google::Cloud::Connectors::V1::ConnectorVersion>]
        #     A list of connector versions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Next page token.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListConnectorVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Supported runtime features of a connector version. This is passed to the
        # management layer to add a new connector version by the connector developer.
        # Details about how this proto is passed to the management layer is covered in
        # this doc - go/runtime-manifest.
        # @!attribute [rw] entity_apis
        #   @return [::Boolean]
        #     Specifies if the connector supports entity apis like 'createEntity'.
        # @!attribute [rw] action_apis
        #   @return [::Boolean]
        #     Specifies if the connector supports action apis like 'executeAction'.
        # @!attribute [rw] sql_query
        #   @return [::Boolean]
        #     Specifies if the connector supports 'ExecuteSqlQuery' operation.
        class SupportedRuntimeFeatures
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Egress control config for connector runtime. These configurations define the
        # rules to identify which outbound domains/hosts needs to be whitelisted. It
        # may be a static information for a particular connector version or it is
        # derived from the configurations provided by the customer in Connection
        # resource.
        # @!attribute [rw] backends
        #   @return [::String]
        #     Static Comma separated backends which are common for all Connection
        #     resources. Supported formats for each backend are host:port or just
        #     host (host can be ip address or domain name).
        #
        #     Note: The following fields are mutually exclusive: `backends`, `extraction_rules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] extraction_rules
        #   @return [::Google::Cloud::Connectors::V1::ExtractionRules]
        #     Extractions Rules to extract the backends from customer provided
        #     configuration.
        #
        #     Note: The following fields are mutually exclusive: `extraction_rules`, `backends`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class EgressControlConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Extraction Rules to identity the backends from customer provided
        # configuration in Connection resource.
        # @!attribute [rw] extraction_rule
        #   @return [::Array<::Google::Cloud::Connectors::V1::ExtractionRule>]
        #     Collection of Extraction Rule.
        class ExtractionRules
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Extraction Rule.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::Connectors::V1::ExtractionRule::Source]
        #     Source on which the rule is applied.
        # @!attribute [rw] extraction_regex
        #   @return [::String]
        #     Regex used to extract backend details from source. If empty, whole source
        #     value will be used.
        class ExtractionRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Source to extract the backend from.
          # @!attribute [rw] source_type
          #   @return [::Google::Cloud::Connectors::V1::ExtractionRule::SourceType]
          #     Type of the source.
          # @!attribute [rw] field_id
          #   @return [::String]
          #     Field identifier. For example config vaiable name.
          class Source
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Supported Source types for extraction.
          module SourceType
            # Default SOURCE.
            SOURCE_TYPE_UNSPECIFIED = 0

            # Config Variable source type.
            CONFIG_VARIABLE = 1
          end
        end

        # Enum to control which fields should be included in the response.
        module ConnectorVersionView
          # CONNECTOR_VERSION_VIEW_UNSPECIFIED.
          CONNECTOR_VERSION_VIEW_UNSPECIFIED = 0

          # Do not include role grant configs.
          CONNECTOR_VERSION_VIEW_BASIC = 1

          # Include role grant configs.
          CONNECTOR_VERSION_VIEW_FULL = 2
        end
      end
    end
  end
end
