# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Connectors
      module V1
        # Connection represents an instance of connector.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the Connection.
        #     Format: projects/\\{project}/locations/\\{location}/connections/\\{connection}
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Created time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Updated time.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource labels to represent user-provided metadata.
        #     Refer to cloud documentation on labels for more details.
        #     https://cloud.google.com/compute/docs/labeling-resources
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the resource.
        # @!attribute [rw] connector_version
        #   @return [::String]
        #     Required. Connector version on which the connection is created.
        #     The format is:
        #     projects/*/locations/*/providers/*/connectors/*/versions/*
        #     Only global location is supported for ConnectorVersion resource.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Connectors::V1::ConnectionStatus]
        #     Output only. Current status of the connection.
        # @!attribute [rw] config_variables
        #   @return [::Array<::Google::Cloud::Connectors::V1::ConfigVariable>]
        #     Optional. Configuration for configuring the connection with an external
        #     system.
        # @!attribute [rw] auth_config
        #   @return [::Google::Cloud::Connectors::V1::AuthConfig]
        #     Optional. Configuration for establishing the connection's authentication
        #     with an external system.
        # @!attribute [rw] lock_config
        #   @return [::Google::Cloud::Connectors::V1::LockConfig]
        #     Optional. Configuration that indicates whether or not the Connection can be
        #     edited.
        # @!attribute [rw] destination_configs
        #   @return [::Array<::Google::Cloud::Connectors::V1::DestinationConfig>]
        #     Optional. Configuration of the Connector's destination. Only accepted for
        #     Connectors that accepts user defined destination(s).
        # @!attribute [r] image_location
        #   @return [::String]
        #     Output only. GCR location where the runtime image is stored.
        #     formatted like: gcr.io/\\{bucketName}/\\{imageName}
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. Service account needed for runtime plane to access GCP resources.
        # @!attribute [r] service_directory
        #   @return [::String]
        #     Output only. The name of the Service Directory service name. Used for
        #     Private Harpoon to resolve the ILB address.
        #     e.g.
        #     "projects/cloud-connectors-e2e-testing/locations/us-central1/namespaces/istio-system/services/istio-ingressgateway-connectors"
        # @!attribute [r] envoy_image_location
        #   @return [::String]
        #     Output only. GCR location where the envoy image is stored.
        #     formatted like: gcr.io/\\{bucketName}/\\{imageName}
        # @!attribute [rw] suspended
        #   @return [::Boolean]
        #     Optional. Suspended indicates if a user has suspended a connection or not.
        # @!attribute [rw] node_config
        #   @return [::Google::Cloud::Connectors::V1::NodeConfig]
        #     Optional. Node configuration for the connection.
        # @!attribute [rw] ssl_config
        #   @return [::Google::Cloud::Connectors::V1::SslConfig]
        #     Optional. Ssl config of a connection
        class Connection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Node configuration for the connection.
        # @!attribute [rw] min_node_count
        #   @return [::Integer]
        #     Minimum number of nodes in the runtime nodes.
        # @!attribute [rw] max_node_count
        #   @return [::Integer]
        #     Maximum number of nodes in the runtime nodes.
        class NodeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ConnectionSchemaMetadata is the singleton resource of each connection.
        # It includes the entity and action names of runtime resources exposed
        # by a connection backend.
        # @!attribute [r] entities
        #   @return [::Array<::String>]
        #     Output only. List of entity names.
        # @!attribute [r] actions
        #   @return [::Array<::String>]
        #     Output only. List of actions.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/connections/\\{connection}/connectionSchemaMetadata
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the connection runtime schema was updated.
        # @!attribute [r] refresh_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the connection runtime schema refresh was
        #     triggered.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Connectors::V1::ConnectionSchemaMetadata::State]
        #     Output only. The current state of runtime schema.
        class ConnectionSchemaMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of connection runtime schema.
          module State
            # Default state.
            STATE_UNSPECIFIED = 0

            # Schema refresh is in progress.
            REFRESHING = 1

            # Schema has been updated.
            UPDATED = 2
          end
        end

        # Schema of a runtime entity.
        # @!attribute [r] entity
        #   @return [::String]
        #     Output only. Name of the entity.
        # @!attribute [r] fields
        #   @return [::Array<::Google::Cloud::Connectors::V1::RuntimeEntitySchema::Field>]
        #     Output only. List of fields in the entity.
        class RuntimeEntitySchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metadata of an entity field.
          # @!attribute [rw] field
          #   @return [::String]
          #     Name of the Field.
          # @!attribute [rw] description
          #   @return [::String]
          #     A brief description of the Field.
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::Connectors::V1::DataType]
          #     The data type of the Field.
          # @!attribute [rw] key
          #   @return [::Boolean]
          #     The following boolean field specifies if the current Field acts
          #     as a primary key or id if the parent is of type entity.
          # @!attribute [rw] readonly
          #   @return [::Boolean]
          #     Specifies if the Field is readonly.
          # @!attribute [rw] nullable
          #   @return [::Boolean]
          #     Specifies whether a null value is allowed.
          # @!attribute [rw] default_value
          #   @return [::Google::Protobuf::Value]
          #     The following field specifies the default value of the Field provided
          #     by the external system if a value is not provided.
          # @!attribute [rw] additional_details
          #   @return [::Google::Protobuf::Struct]
          #     The following map contains fields that are not explicitly mentioned
          #     above,this give connectors the flexibility to add new metadata
          #     fields.
          class Field
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Schema of a runtime action.
        # @!attribute [r] action
        #   @return [::String]
        #     Output only. Name of the action.
        # @!attribute [r] input_parameters
        #   @return [::Array<::Google::Cloud::Connectors::V1::RuntimeActionSchema::InputParameter>]
        #     Output only. List of input parameter metadata for the action.
        # @!attribute [r] result_metadata
        #   @return [::Array<::Google::Cloud::Connectors::V1::RuntimeActionSchema::ResultMetadata>]
        #     Output only. List of result field metadata.
        class RuntimeActionSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metadata of an input parameter.
          # @!attribute [rw] parameter
          #   @return [::String]
          #     Name of the Parameter.
          # @!attribute [rw] description
          #   @return [::String]
          #     A brief description of the Parameter.
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::Connectors::V1::DataType]
          #     The data type of the Parameter.
          # @!attribute [rw] nullable
          #   @return [::Boolean]
          #     Specifies whether a null value is allowed.
          # @!attribute [rw] default_value
          #   @return [::Google::Protobuf::Value]
          #     The following field specifies the default value of the Parameter
          #     provided by the external system if a value is not provided.
          class InputParameter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata of result field.
          # @!attribute [rw] field
          #   @return [::String]
          #     Name of the result field.
          # @!attribute [rw] description
          #   @return [::String]
          #     A brief description of the field.
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::Connectors::V1::DataType]
          #     The data type of the field.
          class ResultMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Determines whether or no a connection is locked. If locked, a reason must be
        # specified.
        # @!attribute [rw] locked
        #   @return [::Boolean]
        #     Indicates whether or not the connection is locked.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Describes why a connection is locked.
        class LockConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.ListConnections
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource of the Connection, of the form:
        #     `projects/*/locations/*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Order by parameters.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Connectors::V1::ConnectionView]
        #     Specifies which fields of the Connection are returned in the response.
        #     Defaults to `BASIC` view.
        class ListConnectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ConnectorsService.ListConnections
        # @!attribute [rw] connections
        #   @return [::Array<::Google::Cloud::Connectors::V1::Connection>]
        #     Connections.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Next page token.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListConnectionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.GetConnection
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the form:
        #     `projects/*/locations/*/connections/*`
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Connectors::V1::ConnectionView]
        #     Specifies which fields of the Connection are returned in the response.
        #     Defaults to `BASIC` view.
        class GetConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.CreateConnection
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource of the Connection, of the form:
        #     `projects/*/locations/*`
        # @!attribute [rw] connection_id
        #   @return [::String]
        #     Required. Identifier to assign to the Connection. Must be unique within
        #     scope of the parent resource.
        # @!attribute [rw] connection
        #   @return [::Google::Cloud::Connectors::V1::Connection]
        #     Required. Connection resource.
        class CreateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.UpdateConnection
        # @!attribute [rw] connection
        #   @return [::Google::Cloud::Connectors::V1::Connection]
        #     Required. Connection resource.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. You can modify only the fields listed below.
        #
        #     To lock/unlock a connection:
        #     * `lock_config`
        #
        #     To suspend/resume a connection:
        #     * `suspended`
        #
        #     To update the connection details:
        #     * `description`
        #     * `labels`
        #     * `connector_version`
        #     * `config_variables`
        #     * `auth_config`
        #     * `destination_configs`
        #     * `node_config`
        class UpdateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.DeleteConnection.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the form:
        #     `projects/*/locations/*/connections/*`
        class DeleteConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.GetConnectionSchemaMetadata.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Connection name
        #     Format:
        #     projects/\\{project}/locations/\\{location}/connections/\\{connection}/connectionSchemaMetadata
        class GetConnectionSchemaMetadataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.RefreshConnectionSchemaMetadata.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/connections/\\{connection}/connectionSchemaMetadata
        class RefreshConnectionSchemaMetadataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.ListRuntimeEntitySchemas.
        # For filter, only entity field is supported with literal equality operator.
        # Accepted filter example: entity="Order"
        # Wildcards are not supported in the filter currently.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource of RuntimeEntitySchema
        #     Format:
        #     projects/\\{project}/locations/\\{location}/connections/\\{connection}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. Filter
        #     Format:
        #     entity="\\{entityId}"
        #     Only entity field is supported with literal equality operator.
        #     Accepted filter example: entity="Order"
        #     Wildcards are not supported in the filter currently.
        class ListRuntimeEntitySchemasRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ConnectorsService.ListRuntimeEntitySchemas.
        # @!attribute [rw] runtime_entity_schemas
        #   @return [::Array<::Google::Cloud::Connectors::V1::RuntimeEntitySchema>]
        #     Runtime entity schemas.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Next page token.
        class ListRuntimeEntitySchemasResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ConnectorsService.ListRuntimeActionSchemas.
        # For filter, only action field is supported with literal equality operator.
        # Accepted filter example: action="approveOrder"
        # Wildcards are not supported in the filter currently.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource of RuntimeActionSchema
        #     Format:
        #     projects/\\{project}/locations/\\{location}/connections/\\{connection}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Required. Filter
        #     Format:
        #     action="\\{actionId}"
        #     Only action field is supported with literal equality operator.
        #     Accepted filter example: action="CancelOrder"
        #     Wildcards are not supported in the filter currently.
        class ListRuntimeActionSchemasRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ConnectorsService.ListRuntimeActionSchemas.
        # @!attribute [rw] runtime_action_schemas
        #   @return [::Array<::Google::Cloud::Connectors::V1::RuntimeActionSchema>]
        #     Runtime action schemas.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Next page token.
        class ListRuntimeActionSchemasResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ConnectionStatus indicates the state of the connection.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Connectors::V1::ConnectionStatus::State]
        #     State.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description.
        # @!attribute [rw] status
        #   @return [::String]
        #     Status provides detailed information for the state.
        class ConnectionStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # All the possible Connection State.
          module State
            # Connection does not have a state yet.
            STATE_UNSPECIFIED = 0

            # Connection is being created.
            CREATING = 1

            # Connection is running and ready for requests.
            ACTIVE = 2

            # Connection is stopped.
            INACTIVE = 3

            # Connection is being deleted.
            DELETING = 4

            # Connection is being updated.
            UPDATING = 5

            # Connection is not running due to an error.
            ERROR = 6

            # Connection is not running due to an auth error for the Oauth2 Auth Code
            # based connector.
            AUTHORIZATION_REQUIRED = 7
          end
        end

        # All possible data types of a entity or action field.
        module DataType
          # Data type is not specified.
          DATA_TYPE_UNSPECIFIED = 0

          # DEPRECATED! Use DATA_TYPE_INTEGER.
          DATA_TYPE_INT = 1

          # Short integer(int16) data type.
          DATA_TYPE_SMALLINT = 2

          # Double data type.
          DATA_TYPE_DOUBLE = 3

          # Date data type.
          DATA_TYPE_DATE = 4

          # DEPRECATED! Use DATA_TYPE_TIMESTAMP.
          DATA_TYPE_DATETIME = 5

          # Time data type.
          DATA_TYPE_TIME = 6

          # DEPRECATED! Use DATA_TYPE_VARCHAR.
          DATA_TYPE_STRING = 7

          # DEPRECATED! Use DATA_TYPE_BIGINT.
          DATA_TYPE_LONG = 8

          # Boolean data type.
          DATA_TYPE_BOOLEAN = 9

          # Decimal data type.
          DATA_TYPE_DECIMAL = 10

          # DEPRECATED! Use DATA_TYPE_VARCHAR.
          DATA_TYPE_UUID = 11

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_BLOB = 12

          # Bit data type.
          DATA_TYPE_BIT = 13

          # Small integer(int8) data type.
          DATA_TYPE_TINYINT = 14

          # Integer(int32) data type.
          DATA_TYPE_INTEGER = 15

          # Long integer(int64) data type.
          DATA_TYPE_BIGINT = 16

          # Float data type.
          DATA_TYPE_FLOAT = 17

          # Real data type.
          DATA_TYPE_REAL = 18

          # Numeric data type.
          DATA_TYPE_NUMERIC = 19

          # Char data type.
          DATA_TYPE_CHAR = 20

          # Varchar data type.
          DATA_TYPE_VARCHAR = 21

          # Longvarchar data type.
          DATA_TYPE_LONGVARCHAR = 22

          # Timestamp data type.
          DATA_TYPE_TIMESTAMP = 23

          # Nchar data type.
          DATA_TYPE_NCHAR = 24

          # Nvarchar data type.
          DATA_TYPE_NVARCHAR = 25

          # Longnvarchar data type.
          DATA_TYPE_LONGNVARCHAR = 26

          # Null data type.
          DATA_TYPE_NULL = 27

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_OTHER = 28

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_JAVA_OBJECT = 29

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_DISTINCT = 30

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_STRUCT = 31

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_ARRAY = 32

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_CLOB = 33

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_REF = 34

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_DATALINK = 35

          # UNSUPPORTED! Row id data type.
          DATA_TYPE_ROWID = 36

          # UNSUPPORTED! Binary data type.
          DATA_TYPE_BINARY = 37

          # UNSUPPORTED! Variable binary data type.
          DATA_TYPE_VARBINARY = 38

          # UNSUPPORTED! Long variable binary data type.
          DATA_TYPE_LONGVARBINARY = 39

          # UNSUPPORTED! NCLOB data type.
          DATA_TYPE_NCLOB = 40

          # UNSUPPORTED! SQL XML data type is not supported.
          DATA_TYPE_SQLXML = 41

          # UNSUPPORTED! Cursor reference type is not supported.
          DATA_TYPE_REF_CURSOR = 42

          # UNSUPPORTED! Use TIME or TIMESTAMP instead.
          DATA_TYPE_TIME_WITH_TIMEZONE = 43

          # UNSUPPORTED! Use TIMESTAMP instead.
          DATA_TYPE_TIMESTAMP_WITH_TIMEZONE = 44
        end

        # Enum to control which fields should be included in the response.
        module ConnectionView
          # CONNECTION_UNSPECIFIED.
          CONNECTION_VIEW_UNSPECIFIED = 0

          # Do not include runtime required configs.
          BASIC = 1

          # Include runtime required configs.
          FULL = 2
        end
      end
    end
  end
end
