# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Connectors
      module V1
        # AuthConfig defines details of a authentication type.
        # @!attribute [rw] auth_type
        #   @return [::Google::Cloud::Connectors::V1::AuthType]
        #     The type of authentication configured.
        # @!attribute [rw] user_password
        #   @return [::Google::Cloud::Connectors::V1::AuthConfig::UserPassword]
        #     UserPassword.
        #
        #     Note: The following fields are mutually exclusive: `user_password`, `oauth2_jwt_bearer`, `oauth2_client_credentials`, `ssh_public_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oauth2_jwt_bearer
        #   @return [::Google::Cloud::Connectors::V1::AuthConfig::Oauth2JwtBearer]
        #     Oauth2JwtBearer.
        #
        #     Note: The following fields are mutually exclusive: `oauth2_jwt_bearer`, `user_password`, `oauth2_client_credentials`, `ssh_public_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oauth2_client_credentials
        #   @return [::Google::Cloud::Connectors::V1::AuthConfig::Oauth2ClientCredentials]
        #     Oauth2ClientCredentials.
        #
        #     Note: The following fields are mutually exclusive: `oauth2_client_credentials`, `user_password`, `oauth2_jwt_bearer`, `ssh_public_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ssh_public_key
        #   @return [::Google::Cloud::Connectors::V1::AuthConfig::SshPublicKey]
        #     SSH Public Key.
        #
        #     Note: The following fields are mutually exclusive: `ssh_public_key`, `user_password`, `oauth2_jwt_bearer`, `oauth2_client_credentials`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] additional_variables
        #   @return [::Array<::Google::Cloud::Connectors::V1::ConfigVariable>]
        #     List containing additional auth configs.
        class AuthConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Parameters to support Username and Password Authentication.
          # @!attribute [rw] username
          #   @return [::String]
          #     Username.
          # @!attribute [rw] password
          #   @return [::Google::Cloud::Connectors::V1::Secret]
          #     Secret version reference containing the password.
          class UserPassword
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Parameters to support JSON Web Token (JWT) Profile for Oauth 2.0
          # Authorization Grant based authentication.
          # See https://tools.ietf.org/html/rfc7523 for more details.
          # @!attribute [rw] client_key
          #   @return [::Google::Cloud::Connectors::V1::Secret]
          #     Secret version reference containing a PKCS#8 PEM-encoded private
          #     key associated with the Client Certificate. This private key will be
          #     used to sign JWTs used for the jwt-bearer authorization grant.
          #     Specified in the form as: `projects/*/secrets/*/versions/*`.
          # @!attribute [rw] jwt_claims
          #   @return [::Google::Cloud::Connectors::V1::AuthConfig::Oauth2JwtBearer::JwtClaims]
          #     JwtClaims providers fields to generate the token.
          class Oauth2JwtBearer
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # JWT claims used for the jwt-bearer authorization grant.
            # @!attribute [rw] issuer
            #   @return [::String]
            #     Value for the "iss" claim.
            # @!attribute [rw] subject
            #   @return [::String]
            #     Value for the "sub" claim.
            # @!attribute [rw] audience
            #   @return [::String]
            #     Value for the "aud" claim.
            class JwtClaims
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Parameters to support Oauth 2.0 Client Credentials Grant Authentication.
          # See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
          # @!attribute [rw] client_id
          #   @return [::String]
          #     The client identifier.
          # @!attribute [rw] client_secret
          #   @return [::Google::Cloud::Connectors::V1::Secret]
          #     Secret version reference containing the client secret.
          class Oauth2ClientCredentials
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Parameters to support Ssh public key Authentication.
          # @!attribute [rw] username
          #   @return [::String]
          #     The user account used to authenticate.
          # @!attribute [rw] ssh_client_cert
          #   @return [::Google::Cloud::Connectors::V1::Secret]
          #     SSH Client Cert. It should contain both public and private key.
          # @!attribute [rw] cert_type
          #   @return [::String]
          #     Format of SSH Client cert.
          # @!attribute [rw] ssh_client_cert_pass
          #   @return [::Google::Cloud::Connectors::V1::Secret]
          #     Password (passphrase) for ssh client certificate if it has one.
          class SshPublicKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # AuthConfigTemplate defines required field over an authentication type.
        # @!attribute [rw] auth_type
        #   @return [::Google::Cloud::Connectors::V1::AuthType]
        #     The type of authentication configured.
        # @!attribute [rw] config_variable_templates
        #   @return [::Array<::Google::Cloud::Connectors::V1::ConfigVariableTemplate>]
        #     Config variables to describe an `AuthConfig` for a `Connection`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name for authentication template.
        # @!attribute [rw] description
        #   @return [::String]
        #     Connector specific description for an authentication template.
        class AuthConfigTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AuthType defines different authentication types.
        module AuthType
          # Authentication type not specified.
          AUTH_TYPE_UNSPECIFIED = 0

          # Username and Password Authentication.
          USER_PASSWORD = 1

          # JSON Web Token (JWT) Profile for Oauth 2.0
          # Authorization Grant based authentication
          OAUTH2_JWT_BEARER = 2

          # Oauth 2.0 Client Credentials Grant Authentication
          OAUTH2_CLIENT_CREDENTIALS = 3

          # SSH Public Key Authentication
          SSH_PUBLIC_KEY = 4

          # Oauth 2.0 Authorization Code Flow
          OAUTH2_AUTH_CODE_FLOW = 5
        end
      end
    end
  end
end
