# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/connectors/v1/connectors_service_pb"
require "google/cloud/connectors/v1/connectors/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Connectors
      module V1
        module Connectors
          module Rest
            ##
            # REST client for the Connectors service.
            #
            # Connectors is the interface for managing Connectors.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "connectors.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :connectors_stub

              ##
              # Configure the Connectors Client class.
              #
              # See {::Google::Cloud::Connectors::V1::Connectors::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Connectors clients
              #   ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Connectors", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_connections.timeout = 60.0
                  default_config.rpcs.list_connections.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_connection.timeout = 60.0
                  default_config.rpcs.get_connection.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_connection.timeout = 60.0

                  default_config.rpcs.update_connection.timeout = 60.0

                  default_config.rpcs.delete_connection.timeout = 60.0

                  default_config.rpcs.list_providers.timeout = 60.0
                  default_config.rpcs.list_providers.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_provider.timeout = 60.0
                  default_config.rpcs.get_provider.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_connectors.timeout = 60.0
                  default_config.rpcs.list_connectors.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_connector.timeout = 60.0
                  default_config.rpcs.get_connector.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_connector_versions.timeout = 60.0
                  default_config.rpcs.list_connector_versions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_connector_version.timeout = 60.0
                  default_config.rpcs.get_connector_version.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_connection_schema_metadata.timeout = 60.0
                  default_config.rpcs.get_connection_schema_metadata.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_runtime_entity_schemas.timeout = 60.0
                  default_config.rpcs.list_runtime_entity_schemas.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_runtime_action_schemas.timeout = 60.0
                  default_config.rpcs.list_runtime_action_schemas.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_runtime_config.timeout = 60.0
                  default_config.rpcs.get_runtime_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Connectors Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Connectors::V1::Connectors::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @connectors_stub.universe_domain
              end

              ##
              # Create a new Connectors REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Connectors client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @connectors_stub = ::Google::Cloud::Connectors::V1::Connectors::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @connectors_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @connectors_stub.endpoint
                  config.universe_domain = @connectors_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @connectors_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @connectors_stub.endpoint
                  config.universe_domain = @connectors_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @connectors_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Connectors::V1::Connectors::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @connectors_stub.logger
              end

              # Service calls

              ##
              # Lists Connections in a given project and location.
              #
              # @overload list_connections(request, options = nil)
              #   Pass arguments to `list_connections` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::ListConnectionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::ListConnectionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_connections(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
              #   Pass arguments to `list_connections` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource of the Connection, of the form:
              #     `projects/*/locations/*`
              #   @param page_size [::Integer]
              #     Page size.
              #   @param page_token [::String]
              #     Page token.
              #   @param filter [::String]
              #     Filter.
              #   @param order_by [::String]
              #     Order by parameters.
              #   @param view [::Google::Cloud::Connectors::V1::ConnectionView]
              #     Specifies which fields of the Connection are returned in the response.
              #     Defaults to `BASIC` view.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::Connection>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::Connection>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::ListConnectionsRequest.new
              #
              #   # Call the list_connections method.
              #   result = client.list_connections request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Connectors::V1::Connection.
              #     p item
              #   end
              #
              def list_connections request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::ListConnectionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_connections.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_connections.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_connections.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.list_connections request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @connectors_stub, :list_connections, "connections", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Connection.
              #
              # @overload get_connection(request, options = nil)
              #   Pass arguments to `get_connection` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::GetConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::GetConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connection(name: nil, view: nil)
              #   Pass arguments to `get_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the form:
              #     `projects/*/locations/*/connections/*`
              #   @param view [::Google::Cloud::Connectors::V1::ConnectionView]
              #     Specifies which fields of the Connection are returned in the response.
              #     Defaults to `BASIC` view.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Connectors::V1::Connection]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Connectors::V1::Connection]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::GetConnectionRequest.new
              #
              #   # Call the get_connection method.
              #   result = client.get_connection request
              #
              #   # The returned object is of type Google::Cloud::Connectors::V1::Connection.
              #   p result
              #
              def get_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::GetConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.get_connection request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Connection in a given project and location.
              #
              # @overload create_connection(request, options = nil)
              #   Pass arguments to `create_connection` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::CreateConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::CreateConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_connection(parent: nil, connection_id: nil, connection: nil)
              #   Pass arguments to `create_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource of the Connection, of the form:
              #     `projects/*/locations/*`
              #   @param connection_id [::String]
              #     Required. Identifier to assign to the Connection. Must be unique within
              #     scope of the parent resource.
              #   @param connection [::Google::Cloud::Connectors::V1::Connection, ::Hash]
              #     Required. Connection resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::CreateConnectionRequest.new
              #
              #   # Call the create_connection method.
              #   result = client.create_connection request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::CreateConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.create_connection request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Connection.
              #
              # @overload update_connection(request, options = nil)
              #   Pass arguments to `update_connection` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::UpdateConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::UpdateConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_connection(connection: nil, update_mask: nil)
              #   Pass arguments to `update_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param connection [::Google::Cloud::Connectors::V1::Connection, ::Hash]
              #     Required. Connection resource.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. You can modify only the fields listed below.
              #
              #     To lock/unlock a connection:
              #     * `lock_config`
              #
              #     To suspend/resume a connection:
              #     * `suspended`
              #
              #     To update the connection details:
              #     * `description`
              #     * `labels`
              #     * `connector_version`
              #     * `config_variables`
              #     * `auth_config`
              #     * `destination_configs`
              #     * `node_config`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::UpdateConnectionRequest.new
              #
              #   # Call the update_connection method.
              #   result = client.update_connection request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::UpdateConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.update_connection request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Connection.
              #
              # @overload delete_connection(request, options = nil)
              #   Pass arguments to `delete_connection` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::DeleteConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::DeleteConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_connection(name: nil)
              #   Pass arguments to `delete_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the form:
              #     `projects/*/locations/*/connections/*`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::DeleteConnectionRequest.new
              #
              #   # Call the delete_connection method.
              #   result = client.delete_connection request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::DeleteConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.delete_connection request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Providers in a given project and location.
              #
              # @overload list_providers(request, options = nil)
              #   Pass arguments to `list_providers` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::ListProvidersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::ListProvidersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_providers(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_providers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource of the API, of the form:
              #     `projects/*/locations/*`
              #     Only global location is supported for Provider resource.
              #   @param page_size [::Integer]
              #     Page size.
              #   @param page_token [::String]
              #     Page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::Provider>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::Provider>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::ListProvidersRequest.new
              #
              #   # Call the list_providers method.
              #   result = client.list_providers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Connectors::V1::Provider.
              #     p item
              #   end
              #
              def list_providers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::ListProvidersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_providers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_providers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_providers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.list_providers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @connectors_stub, :list_providers, "providers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a provider.
              #
              # @overload get_provider(request, options = nil)
              #   Pass arguments to `get_provider` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::GetProviderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::GetProviderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_provider(name: nil)
              #   Pass arguments to `get_provider` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the form:
              #     `projects/*/locations/*/providers/*`
              #     Only global location is supported for Provider resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Connectors::V1::Provider]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Connectors::V1::Provider]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::GetProviderRequest.new
              #
              #   # Call the get_provider method.
              #   result = client.get_provider request
              #
              #   # The returned object is of type Google::Cloud::Connectors::V1::Provider.
              #   p result
              #
              def get_provider request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::GetProviderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_provider.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_provider.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_provider.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.get_provider request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Connectors in a given project and location.
              #
              # @overload list_connectors(request, options = nil)
              #   Pass arguments to `list_connectors` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::ListConnectorsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::ListConnectorsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_connectors(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_connectors` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource of the connectors, of the form:
              #     `projects/*/locations/*/providers/*`
              #     Only global location is supported for Connector resource.
              #   @param page_size [::Integer]
              #     Page size.
              #   @param page_token [::String]
              #     Page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::Connector>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::Connector>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::ListConnectorsRequest.new
              #
              #   # Call the list_connectors method.
              #   result = client.list_connectors request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Connectors::V1::Connector.
              #     p item
              #   end
              #
              def list_connectors request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::ListConnectorsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_connectors.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_connectors.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_connectors.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.list_connectors request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @connectors_stub, :list_connectors, "connectors", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Connector.
              #
              # @overload get_connector(request, options = nil)
              #   Pass arguments to `get_connector` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::GetConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::GetConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connector(name: nil)
              #   Pass arguments to `get_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the form:
              #     `projects/*/locations/*/providers/*/connectors/*`
              #     Only global location is supported for Connector resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Connectors::V1::Connector]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Connectors::V1::Connector]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::GetConnectorRequest.new
              #
              #   # Call the get_connector method.
              #   result = client.get_connector request
              #
              #   # The returned object is of type Google::Cloud::Connectors::V1::Connector.
              #   p result
              #
              def get_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::GetConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.get_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Connector Versions in a given project and location.
              #
              # @overload list_connector_versions(request, options = nil)
              #   Pass arguments to `list_connector_versions` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::ListConnectorVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::ListConnectorVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_connector_versions(parent: nil, page_size: nil, page_token: nil, view: nil)
              #   Pass arguments to `list_connector_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource of the connectors, of the form:
              #     `projects/*/locations/*/providers/*/connectors/*`
              #     Only global location is supported for ConnectorVersion resource.
              #   @param page_size [::Integer]
              #     Page size.
              #   @param page_token [::String]
              #     Page token.
              #   @param view [::Google::Cloud::Connectors::V1::ConnectorVersionView]
              #     Specifies which fields of the ConnectorVersion are returned in the
              #     response. Defaults to `BASIC` view.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::ConnectorVersion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::ConnectorVersion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::ListConnectorVersionsRequest.new
              #
              #   # Call the list_connector_versions method.
              #   result = client.list_connector_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Connectors::V1::ConnectorVersion.
              #     p item
              #   end
              #
              def list_connector_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::ListConnectorVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_connector_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_connector_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_connector_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.list_connector_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @connectors_stub, :list_connector_versions, "connector_versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single connector version.
              #
              # @overload get_connector_version(request, options = nil)
              #   Pass arguments to `get_connector_version` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::GetConnectorVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::GetConnectorVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connector_version(name: nil, view: nil)
              #   Pass arguments to `get_connector_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the form:
              #     `projects/*/locations/*/providers/*/connectors/*/versions/*`
              #     Only global location is supported for ConnectorVersion resource.
              #   @param view [::Google::Cloud::Connectors::V1::ConnectorVersionView]
              #     Specifies which fields of the ConnectorVersion are returned in the
              #     response. Defaults to `CUSTOMER` view.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Connectors::V1::ConnectorVersion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Connectors::V1::ConnectorVersion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::GetConnectorVersionRequest.new
              #
              #   # Call the get_connector_version method.
              #   result = client.get_connector_version request
              #
              #   # The returned object is of type Google::Cloud::Connectors::V1::ConnectorVersion.
              #   p result
              #
              def get_connector_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::GetConnectorVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connector_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connector_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connector_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.get_connector_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets schema metadata of a connection.
              # SchemaMetadata is a singleton resource for each connection.
              #
              # @overload get_connection_schema_metadata(request, options = nil)
              #   Pass arguments to `get_connection_schema_metadata` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connection_schema_metadata(name: nil)
              #   Pass arguments to `get_connection_schema_metadata` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Connection name
              #     Format:
              #     projects/\\{project}/locations/\\{location}/connections/\\{connection}/connectionSchemaMetadata
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Connectors::V1::ConnectionSchemaMetadata]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Connectors::V1::ConnectionSchemaMetadata]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest.new
              #
              #   # Call the get_connection_schema_metadata method.
              #   result = client.get_connection_schema_metadata request
              #
              #   # The returned object is of type Google::Cloud::Connectors::V1::ConnectionSchemaMetadata.
              #   p result
              #
              def get_connection_schema_metadata request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::GetConnectionSchemaMetadataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connection_schema_metadata.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connection_schema_metadata.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connection_schema_metadata.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.get_connection_schema_metadata request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Refresh runtime schema of a connection.
              #
              # @overload refresh_connection_schema_metadata(request, options = nil)
              #   Pass arguments to `refresh_connection_schema_metadata` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload refresh_connection_schema_metadata(name: nil)
              #   Pass arguments to `refresh_connection_schema_metadata` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/connections/\\{connection}/connectionSchemaMetadata
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest.new
              #
              #   # Call the refresh_connection_schema_metadata method.
              #   result = client.refresh_connection_schema_metadata request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def refresh_connection_schema_metadata request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::RefreshConnectionSchemaMetadataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.refresh_connection_schema_metadata.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.refresh_connection_schema_metadata.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.refresh_connection_schema_metadata.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.refresh_connection_schema_metadata request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List schema of a runtime entities filtered by entity name.
              #
              # @overload list_runtime_entity_schemas(request, options = nil)
              #   Pass arguments to `list_runtime_entity_schemas` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_runtime_entity_schemas(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_runtime_entity_schemas` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource of RuntimeEntitySchema
              #     Format:
              #     projects/\\{project}/locations/\\{location}/connections/\\{connection}
              #   @param page_size [::Integer]
              #     Page size.
              #   @param page_token [::String]
              #     Page token.
              #   @param filter [::String]
              #     Required. Filter
              #     Format:
              #     entity="\\{entityId}"
              #     Only entity field is supported with literal equality operator.
              #     Accepted filter example: entity="Order"
              #     Wildcards are not supported in the filter currently.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::RuntimeEntitySchema>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::RuntimeEntitySchema>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest.new
              #
              #   # Call the list_runtime_entity_schemas method.
              #   result = client.list_runtime_entity_schemas request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Connectors::V1::RuntimeEntitySchema.
              #     p item
              #   end
              #
              def list_runtime_entity_schemas request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::ListRuntimeEntitySchemasRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_runtime_entity_schemas.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_runtime_entity_schemas.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_runtime_entity_schemas.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.list_runtime_entity_schemas request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @connectors_stub, :list_runtime_entity_schemas, "runtime_entity_schemas", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List schema of a runtime actions filtered by action name.
              #
              # @overload list_runtime_action_schemas(request, options = nil)
              #   Pass arguments to `list_runtime_action_schemas` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_runtime_action_schemas(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_runtime_action_schemas` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource of RuntimeActionSchema
              #     Format:
              #     projects/\\{project}/locations/\\{location}/connections/\\{connection}
              #   @param page_size [::Integer]
              #     Page size.
              #   @param page_token [::String]
              #     Page token.
              #   @param filter [::String]
              #     Required. Filter
              #     Format:
              #     action="\\{actionId}"
              #     Only action field is supported with literal equality operator.
              #     Accepted filter example: action="CancelOrder"
              #     Wildcards are not supported in the filter currently.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::RuntimeActionSchema>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Connectors::V1::RuntimeActionSchema>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest.new
              #
              #   # Call the list_runtime_action_schemas method.
              #   result = client.list_runtime_action_schemas request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Connectors::V1::RuntimeActionSchema.
              #     p item
              #   end
              #
              def list_runtime_action_schemas request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::ListRuntimeActionSchemasRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_runtime_action_schemas.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_runtime_action_schemas.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_runtime_action_schemas.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.list_runtime_action_schemas request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @connectors_stub, :list_runtime_action_schemas, "runtime_action_schemas", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the runtimeConfig of a location.
              # RuntimeConfig is a singleton resource for each location.
              #
              # @overload get_runtime_config(request, options = nil)
              #   Pass arguments to `get_runtime_config` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::GetRuntimeConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::GetRuntimeConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_runtime_config(name: nil)
              #   Pass arguments to `get_runtime_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the form:
              #     `projects/*/locations/*/runtimeConfig`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Connectors::V1::RuntimeConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Connectors::V1::RuntimeConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::GetRuntimeConfigRequest.new
              #
              #   # Call the get_runtime_config method.
              #   result = client.get_runtime_config request
              #
              #   # The returned object is of type Google::Cloud::Connectors::V1::RuntimeConfig.
              #   p result
              #
              def get_runtime_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::GetRuntimeConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_runtime_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_runtime_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_runtime_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.get_runtime_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # GetGlobalSettings gets settings of a project.
              # GlobalSettings is a singleton resource.
              #
              # @overload get_global_settings(request, options = nil)
              #   Pass arguments to `get_global_settings` via a request object, either of type
              #   {::Google::Cloud::Connectors::V1::GetGlobalSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Connectors::V1::GetGlobalSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_global_settings(name: nil)
              #   Pass arguments to `get_global_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Settings.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Connectors::V1::Settings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Connectors::V1::Settings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/connectors/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Connectors::V1::Connectors::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Connectors::V1::GetGlobalSettingsRequest.new
              #
              #   # Call the get_global_settings method.
              #   result = client.get_global_settings request
              #
              #   # The returned object is of type Google::Cloud::Connectors::V1::Settings.
              #   p result
              #
              def get_global_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Connectors::V1::GetGlobalSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_global_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Connectors::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_global_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_global_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @connectors_stub.get_global_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Connectors REST API.
              #
              # This class represents the configuration for Connectors REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Connectors::V1::Connectors::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_connections to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_connections.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Connectors::V1::Connectors::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_connections.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "connectors.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Connectors API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_connections`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_connections
                  ##
                  # RPC-specific configuration for `get_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connection
                  ##
                  # RPC-specific configuration for `create_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_connection
                  ##
                  # RPC-specific configuration for `update_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_connection
                  ##
                  # RPC-specific configuration for `delete_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_connection
                  ##
                  # RPC-specific configuration for `list_providers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_providers
                  ##
                  # RPC-specific configuration for `get_provider`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_provider
                  ##
                  # RPC-specific configuration for `list_connectors`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_connectors
                  ##
                  # RPC-specific configuration for `get_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connector
                  ##
                  # RPC-specific configuration for `list_connector_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_connector_versions
                  ##
                  # RPC-specific configuration for `get_connector_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connector_version
                  ##
                  # RPC-specific configuration for `get_connection_schema_metadata`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connection_schema_metadata
                  ##
                  # RPC-specific configuration for `refresh_connection_schema_metadata`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :refresh_connection_schema_metadata
                  ##
                  # RPC-specific configuration for `list_runtime_entity_schemas`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_runtime_entity_schemas
                  ##
                  # RPC-specific configuration for `list_runtime_action_schemas`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_runtime_action_schemas
                  ##
                  # RPC-specific configuration for `get_runtime_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_runtime_config
                  ##
                  # RPC-specific configuration for `get_global_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_global_settings

                  # @private
                  def initialize parent_rpcs = nil
                    list_connections_config = parent_rpcs.list_connections if parent_rpcs.respond_to? :list_connections
                    @list_connections = ::Gapic::Config::Method.new list_connections_config
                    get_connection_config = parent_rpcs.get_connection if parent_rpcs.respond_to? :get_connection
                    @get_connection = ::Gapic::Config::Method.new get_connection_config
                    create_connection_config = parent_rpcs.create_connection if parent_rpcs.respond_to? :create_connection
                    @create_connection = ::Gapic::Config::Method.new create_connection_config
                    update_connection_config = parent_rpcs.update_connection if parent_rpcs.respond_to? :update_connection
                    @update_connection = ::Gapic::Config::Method.new update_connection_config
                    delete_connection_config = parent_rpcs.delete_connection if parent_rpcs.respond_to? :delete_connection
                    @delete_connection = ::Gapic::Config::Method.new delete_connection_config
                    list_providers_config = parent_rpcs.list_providers if parent_rpcs.respond_to? :list_providers
                    @list_providers = ::Gapic::Config::Method.new list_providers_config
                    get_provider_config = parent_rpcs.get_provider if parent_rpcs.respond_to? :get_provider
                    @get_provider = ::Gapic::Config::Method.new get_provider_config
                    list_connectors_config = parent_rpcs.list_connectors if parent_rpcs.respond_to? :list_connectors
                    @list_connectors = ::Gapic::Config::Method.new list_connectors_config
                    get_connector_config = parent_rpcs.get_connector if parent_rpcs.respond_to? :get_connector
                    @get_connector = ::Gapic::Config::Method.new get_connector_config
                    list_connector_versions_config = parent_rpcs.list_connector_versions if parent_rpcs.respond_to? :list_connector_versions
                    @list_connector_versions = ::Gapic::Config::Method.new list_connector_versions_config
                    get_connector_version_config = parent_rpcs.get_connector_version if parent_rpcs.respond_to? :get_connector_version
                    @get_connector_version = ::Gapic::Config::Method.new get_connector_version_config
                    get_connection_schema_metadata_config = parent_rpcs.get_connection_schema_metadata if parent_rpcs.respond_to? :get_connection_schema_metadata
                    @get_connection_schema_metadata = ::Gapic::Config::Method.new get_connection_schema_metadata_config
                    refresh_connection_schema_metadata_config = parent_rpcs.refresh_connection_schema_metadata if parent_rpcs.respond_to? :refresh_connection_schema_metadata
                    @refresh_connection_schema_metadata = ::Gapic::Config::Method.new refresh_connection_schema_metadata_config
                    list_runtime_entity_schemas_config = parent_rpcs.list_runtime_entity_schemas if parent_rpcs.respond_to? :list_runtime_entity_schemas
                    @list_runtime_entity_schemas = ::Gapic::Config::Method.new list_runtime_entity_schemas_config
                    list_runtime_action_schemas_config = parent_rpcs.list_runtime_action_schemas if parent_rpcs.respond_to? :list_runtime_action_schemas
                    @list_runtime_action_schemas = ::Gapic::Config::Method.new list_runtime_action_schemas_config
                    get_runtime_config_config = parent_rpcs.get_runtime_config if parent_rpcs.respond_to? :get_runtime_config
                    @get_runtime_config = ::Gapic::Config::Method.new get_runtime_config_config
                    get_global_settings_config = parent_rpcs.get_global_settings if parent_rpcs.respond_to? :get_global_settings
                    @get_global_settings = ::Gapic::Config::Method.new get_global_settings_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
