# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Connectors
      module V1
        module Connectors
          # Path helper methods for the Connectors API.
          module Paths
            ##
            # Create a fully-qualified Connection resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connections/{connection}`
            #
            # @param project [String]
            # @param location [String]
            # @param connection [String]
            #
            # @return [::String]
            def connection_path project:, location:, connection:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connections/#{connection}"
            end

            ##
            # Create a fully-qualified ConnectionSchemaMetadata resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connections/{connection}/connectionSchemaMetadata`
            #
            # @param project [String]
            # @param location [String]
            # @param connection [String]
            #
            # @return [::String]
            def connection_schema_metadata_path project:, location:, connection:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connections/#{connection}/connectionSchemaMetadata"
            end

            ##
            # Create a fully-qualified Connector resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/providers/{provider}/connectors/{connector}`
            #
            # @param project [String]
            # @param location [String]
            # @param provider [String]
            # @param connector [String]
            #
            # @return [::String]
            def connector_path project:, location:, provider:, connector:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "provider cannot contain /" if provider.to_s.include? "/"

              "projects/#{project}/locations/#{location}/providers/#{provider}/connectors/#{connector}"
            end

            ##
            # Create a fully-qualified ConnectorVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/providers/{provider}/connectors/{connector}/versions/{version}`
            #
            # @param project [String]
            # @param location [String]
            # @param provider [String]
            # @param connector [String]
            # @param version [String]
            #
            # @return [::String]
            def connector_version_path project:, location:, provider:, connector:, version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "provider cannot contain /" if provider.to_s.include? "/"
              raise ::ArgumentError, "connector cannot contain /" if connector.to_s.include? "/"

              "projects/#{project}/locations/#{location}/providers/#{provider}/connectors/#{connector}/versions/#{version}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Provider resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/providers/{provider}`
            #
            # @param project [String]
            # @param location [String]
            # @param provider [String]
            #
            # @return [::String]
            def provider_path project:, location:, provider:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/providers/#{provider}"
            end

            ##
            # Create a fully-qualified RuntimeConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/runtimeConfig`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def runtime_config_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}/runtimeConfig"
            end

            ##
            # Create a fully-qualified Settings resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/global/settings`
            #
            # @param project [String]
            #
            # @return [::String]
            def settings_path project:
              "projects/#{project}/locations/global/settings"
            end

            extend self
          end
        end
      end
    end
  end
end
