# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/config/v1/config_pb"
require "google/cloud/config_service/v1/config"

class ::Google::Cloud::ConfigService::V1::Config::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_deployments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ListDeploymentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_deployments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_deployments, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ListDeploymentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_deployments_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_deployments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_deployments ::Google::Cloud::ConfigService::V1::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_deployments(::Google::Cloud::ConfigService::V1::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_deployments_client_stub.call_rpc_count
    end
  end

  def test_get_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_deployment, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::GetDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_deployment ::Google::Cloud::ConfigService::V1::GetDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_deployment(::Google::Cloud::ConfigService::V1::GetDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_deployment_client_stub.call_rpc_count
    end
  end

  def test_create_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_id = "hello world"
    deployment = {}
    request_id = "hello world"

    create_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_deployment, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::CreateDeploymentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["deployment_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigService::V1::Deployment), request["deployment"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_deployment parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_deployment ::Google::Cloud::ConfigService::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_deployment(::Google::Cloud::ConfigService::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_deployment_client_stub.call_rpc_count
    end
  end

  def test_update_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    deployment = {}
    request_id = "hello world"

    update_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_deployment, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::UpdateDeploymentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigService::V1::Deployment), request["deployment"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_deployment({ update_mask: update_mask, deployment: deployment, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_deployment update_mask: update_mask, deployment: deployment, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_deployment ::Google::Cloud::ConfigService::V1::UpdateDeploymentRequest.new(update_mask: update_mask, deployment: deployment, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_deployment({ update_mask: update_mask, deployment: deployment, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_deployment(::Google::Cloud::ConfigService::V1::UpdateDeploymentRequest.new(update_mask: update_mask, deployment: deployment, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_deployment_client_stub.call_rpc_count
    end
  end

  def test_delete_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true
    delete_policy = :DELETE_POLICY_UNSPECIFIED

    delete_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_deployment, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      assert_equal :DELETE_POLICY_UNSPECIFIED, request["delete_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_deployment({ name: name, request_id: request_id, force: force, delete_policy: delete_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_deployment name: name, request_id: request_id, force: force, delete_policy: delete_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_deployment ::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest.new(name: name, request_id: request_id, force: force, delete_policy: delete_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_deployment({ name: name, request_id: request_id, force: force, delete_policy: delete_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_deployment(::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest.new(name: name, request_id: request_id, force: force, delete_policy: delete_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_deployment_client_stub.call_rpc_count
    end
  end

  def test_list_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ListRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_revisions, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ListRevisionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_revisions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_revisions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_revisions ::Google::Cloud::ConfigService::V1::ListRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_revisions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_revisions(::Google::Cloud::ConfigService::V1::ListRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_revisions_client_stub.call_rpc_count
    end
  end

  def test_get_revision
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::Revision.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_revision_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_revision, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::GetRevisionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_revision_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_revision({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_revision name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_revision ::Google::Cloud::ConfigService::V1::GetRevisionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_revision({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_revision(::Google::Cloud::ConfigService::V1::GetRevisionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_revision_client_stub.call_rpc_count
    end
  end

  def test_get_resource
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::Resource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_resource, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::GetResourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_resource_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_resource({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_resource name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_resource ::Google::Cloud::ConfigService::V1::GetResourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_resource({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_resource(::Google::Cloud::ConfigService::V1::GetResourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_resource_client_stub.call_rpc_count
    end
  end

  def test_list_resources
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ListResourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_resources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_resources, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ListResourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_resources_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_resources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_resources parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_resources ::Google::Cloud::ConfigService::V1::ListResourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_resources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_resources(::Google::Cloud::ConfigService::V1::ListResourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_resources_client_stub.call_rpc_count
    end
  end

  def test_export_deployment_statefile
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::Statefile.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    draft = true

    export_deployment_statefile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_deployment_statefile, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal true, request["draft"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_deployment_statefile_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_deployment_statefile({ parent: parent, draft: draft }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_deployment_statefile parent: parent, draft: draft do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_deployment_statefile ::Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest.new(parent: parent, draft: draft) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_deployment_statefile({ parent: parent, draft: draft }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_deployment_statefile(::Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest.new(parent: parent, draft: draft), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_deployment_statefile_client_stub.call_rpc_count
    end
  end

  def test_export_revision_statefile
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::Statefile.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    export_revision_statefile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_revision_statefile, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_revision_statefile_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_revision_statefile({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_revision_statefile parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_revision_statefile ::Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_revision_statefile({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_revision_statefile(::Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_revision_statefile_client_stub.call_rpc_count
    end
  end

  def test_import_statefile
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::Statefile.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    lock_id = 42
    skip_draft = true

    import_statefile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_statefile, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ImportStatefileRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["lock_id"]
      assert_equal true, request["skip_draft"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_statefile_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_statefile({ parent: parent, lock_id: lock_id, skip_draft: skip_draft }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_statefile parent: parent, lock_id: lock_id, skip_draft: skip_draft do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_statefile ::Google::Cloud::ConfigService::V1::ImportStatefileRequest.new(parent: parent, lock_id: lock_id, skip_draft: skip_draft) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_statefile({ parent: parent, lock_id: lock_id, skip_draft: skip_draft }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_statefile(::Google::Cloud::ConfigService::V1::ImportStatefileRequest.new(parent: parent, lock_id: lock_id, skip_draft: skip_draft), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_statefile_client_stub.call_rpc_count
    end
  end

  def test_delete_statefile
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    lock_id = 42

    delete_statefile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_statefile, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::DeleteStatefileRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["lock_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_statefile_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_statefile({ name: name, lock_id: lock_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_statefile name: name, lock_id: lock_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_statefile ::Google::Cloud::ConfigService::V1::DeleteStatefileRequest.new(name: name, lock_id: lock_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_statefile({ name: name, lock_id: lock_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_statefile(::Google::Cloud::ConfigService::V1::DeleteStatefileRequest.new(name: name, lock_id: lock_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_statefile_client_stub.call_rpc_count
    end
  end

  def test_lock_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    lock_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :lock_deployment, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::LockDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, lock_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.lock_deployment({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.lock_deployment name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.lock_deployment ::Google::Cloud::ConfigService::V1::LockDeploymentRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.lock_deployment({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.lock_deployment(::Google::Cloud::ConfigService::V1::LockDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, lock_deployment_client_stub.call_rpc_count
    end
  end

  def test_unlock_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    lock_id = 42

    unlock_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :unlock_deployment, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::UnlockDeploymentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["lock_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, unlock_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.unlock_deployment({ name: name, lock_id: lock_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.unlock_deployment name: name, lock_id: lock_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.unlock_deployment ::Google::Cloud::ConfigService::V1::UnlockDeploymentRequest.new(name: name, lock_id: lock_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.unlock_deployment({ name: name, lock_id: lock_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.unlock_deployment(::Google::Cloud::ConfigService::V1::UnlockDeploymentRequest.new(name: name, lock_id: lock_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, unlock_deployment_client_stub.call_rpc_count
    end
  end

  def test_export_lock_info
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::LockInfo.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    export_lock_info_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_lock_info, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ExportLockInfoRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_lock_info_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_lock_info({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_lock_info name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_lock_info ::Google::Cloud::ConfigService::V1::ExportLockInfoRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_lock_info({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_lock_info(::Google::Cloud::ConfigService::V1::ExportLockInfoRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_lock_info_client_stub.call_rpc_count
    end
  end

  def test_create_preview
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    preview_id = "hello world"
    preview = {}
    request_id = "hello world"

    create_preview_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_preview, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::CreatePreviewRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["preview_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigService::V1::Preview), request["preview"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_preview_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_preview({ parent: parent, preview_id: preview_id, preview: preview, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_preview parent: parent, preview_id: preview_id, preview: preview, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_preview ::Google::Cloud::ConfigService::V1::CreatePreviewRequest.new(parent: parent, preview_id: preview_id, preview: preview, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_preview({ parent: parent, preview_id: preview_id, preview: preview, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_preview(::Google::Cloud::ConfigService::V1::CreatePreviewRequest.new(parent: parent, preview_id: preview_id, preview: preview, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_preview_client_stub.call_rpc_count
    end
  end

  def test_get_preview
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::Preview.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_preview_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_preview, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::GetPreviewRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_preview_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_preview({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_preview name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_preview ::Google::Cloud::ConfigService::V1::GetPreviewRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_preview({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_preview(::Google::Cloud::ConfigService::V1::GetPreviewRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_preview_client_stub.call_rpc_count
    end
  end

  def test_list_previews
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ListPreviewsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_previews_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_previews, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ListPreviewsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_previews_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_previews({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_previews parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_previews ::Google::Cloud::ConfigService::V1::ListPreviewsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_previews({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_previews(::Google::Cloud::ConfigService::V1::ListPreviewsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_previews_client_stub.call_rpc_count
    end
  end

  def test_delete_preview
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_preview_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_preview, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::DeletePreviewRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_preview_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_preview({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_preview name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_preview ::Google::Cloud::ConfigService::V1::DeletePreviewRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_preview({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_preview(::Google::Cloud::ConfigService::V1::DeletePreviewRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_preview_client_stub.call_rpc_count
    end
  end

  def test_export_preview_result
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ExportPreviewResultResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    export_preview_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_preview_result, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ExportPreviewResultRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_preview_result_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_preview_result({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_preview_result parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_preview_result ::Google::Cloud::ConfigService::V1::ExportPreviewResultRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_preview_result({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_preview_result(::Google::Cloud::ConfigService::V1::ExportPreviewResultRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_preview_result_client_stub.call_rpc_count
    end
  end

  def test_list_terraform_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ListTerraformVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_terraform_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_terraform_versions, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_terraform_versions_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_terraform_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_terraform_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_terraform_versions ::Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_terraform_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_terraform_versions(::Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_terraform_versions_client_stub.call_rpc_count
    end
  end

  def test_get_terraform_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::TerraformVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_terraform_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_terraform_version, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::GetTerraformVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_terraform_version_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_terraform_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_terraform_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_terraform_version ::Google::Cloud::ConfigService::V1::GetTerraformVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_terraform_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_terraform_version(::Google::Cloud::ConfigService::V1::GetTerraformVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_terraform_version_client_stub.call_rpc_count
    end
  end

  def test_list_resource_changes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ListResourceChangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_resource_changes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_resource_changes, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ListResourceChangesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_resource_changes_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_resource_changes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_resource_changes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_resource_changes ::Google::Cloud::ConfigService::V1::ListResourceChangesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_resource_changes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_resource_changes(::Google::Cloud::ConfigService::V1::ListResourceChangesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_resource_changes_client_stub.call_rpc_count
    end
  end

  def test_get_resource_change
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ResourceChange.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_change_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_resource_change, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::GetResourceChangeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_resource_change_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_resource_change({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_resource_change name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_resource_change ::Google::Cloud::ConfigService::V1::GetResourceChangeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_resource_change({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_resource_change(::Google::Cloud::ConfigService::V1::GetResourceChangeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_resource_change_client_stub.call_rpc_count
    end
  end

  def test_list_resource_drifts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ListResourceDriftsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_resource_drifts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_resource_drifts, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::ListResourceDriftsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_resource_drifts_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_resource_drifts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_resource_drifts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_resource_drifts ::Google::Cloud::ConfigService::V1::ListResourceDriftsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_resource_drifts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_resource_drifts(::Google::Cloud::ConfigService::V1::ListResourceDriftsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_resource_drifts_client_stub.call_rpc_count
    end
  end

  def test_get_resource_drift
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::ResourceDrift.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_drift_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_resource_drift, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::GetResourceDriftRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_resource_drift_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_resource_drift({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_resource_drift name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_resource_drift ::Google::Cloud::ConfigService::V1::GetResourceDriftRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_resource_drift({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_resource_drift(::Google::Cloud::ConfigService::V1::GetResourceDriftRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_resource_drift_client_stub.call_rpc_count
    end
  end

  def test_get_auto_migration_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigService::V1::AutoMigrationConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_auto_migration_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_auto_migration_config, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_auto_migration_config_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_auto_migration_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_auto_migration_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_auto_migration_config ::Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_auto_migration_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_auto_migration_config(::Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_auto_migration_config_client_stub.call_rpc_count
    end
  end

  def test_update_auto_migration_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    auto_migration_config = {}

    update_auto_migration_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_auto_migration_config, name
      assert_kind_of ::Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigService::V1::AutoMigrationConfig), request["auto_migration_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_auto_migration_config_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_auto_migration_config({ update_mask: update_mask, auto_migration_config: auto_migration_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_auto_migration_config update_mask: update_mask, auto_migration_config: auto_migration_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_auto_migration_config ::Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest.new(update_mask: update_mask, auto_migration_config: auto_migration_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_auto_migration_config({ update_mask: update_mask, auto_migration_config: auto_migration_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_auto_migration_config(::Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest.new(update_mask: update_mask, auto_migration_config: auto_migration_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_auto_migration_config_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ConfigService::V1::Config::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ConfigService::V1::Config::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::ConfigService::V1::Config::Operations, client.operations_client
  end
end
