# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/config/v1/config_pb"
require "google/cloud/config_service/v1/config/rest"


class ::Google::Cloud::ConfigService::V1::Config::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_deployments
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ListDeploymentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_deployments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_list_deployments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_deployments_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_deployments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_deployments ::Google::Cloud::ConfigService::V1::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_deployments(::Google::Cloud::ConfigService::V1::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_deployments_client_stub.call_count
      end
    end
  end

  def test_get_deployment
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_get_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_deployment ::Google::Cloud::ConfigService::V1::GetDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_deployment(::Google::Cloud::ConfigService::V1::GetDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_deployment_client_stub.call_count
      end
    end
  end

  def test_create_deployment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_id = "hello world"
    deployment = {}
    request_id = "hello world"

    create_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_create_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_deployment parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_deployment ::Google::Cloud::ConfigService::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_deployment(::Google::Cloud::ConfigService::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_deployment_client_stub.call_count
      end
    end
  end

  def test_update_deployment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    deployment = {}
    request_id = "hello world"

    update_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_update_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_deployment({ update_mask: update_mask, deployment: deployment, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_deployment update_mask: update_mask, deployment: deployment, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_deployment ::Google::Cloud::ConfigService::V1::UpdateDeploymentRequest.new(update_mask: update_mask, deployment: deployment, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_deployment({ update_mask: update_mask, deployment: deployment, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_deployment(::Google::Cloud::ConfigService::V1::UpdateDeploymentRequest.new(update_mask: update_mask, deployment: deployment, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_deployment_client_stub.call_count
      end
    end
  end

  def test_delete_deployment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true
    delete_policy = :DELETE_POLICY_UNSPECIFIED

    delete_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_delete_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_deployment({ name: name, request_id: request_id, force: force, delete_policy: delete_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_deployment name: name, request_id: request_id, force: force, delete_policy: delete_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_deployment ::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest.new(name: name, request_id: request_id, force: force, delete_policy: delete_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_deployment({ name: name, request_id: request_id, force: force, delete_policy: delete_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_deployment(::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest.new(name: name, request_id: request_id, force: force, delete_policy: delete_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_deployment_client_stub.call_count
      end
    end
  end

  def test_list_revisions
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ListRevisionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_revisions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_list_revisions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_revisions_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_revisions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_revisions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_revisions ::Google::Cloud::ConfigService::V1::ListRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_revisions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_revisions(::Google::Cloud::ConfigService::V1::ListRevisionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_revisions_client_stub.call_count
      end
    end
  end

  def test_get_revision
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::Revision.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_revision_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_get_revision_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_revision_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_revision({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_revision name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_revision ::Google::Cloud::ConfigService::V1::GetRevisionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_revision({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_revision(::Google::Cloud::ConfigService::V1::GetRevisionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_revision_client_stub.call_count
      end
    end
  end

  def test_get_resource
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::Resource.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_get_resource_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_resource_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_resource({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_resource name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_resource ::Google::Cloud::ConfigService::V1::GetResourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_resource({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_resource(::Google::Cloud::ConfigService::V1::GetResourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_resource_client_stub.call_count
      end
    end
  end

  def test_list_resources
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ListResourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_resources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_list_resources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_resources_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_resources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_resources parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_resources ::Google::Cloud::ConfigService::V1::ListResourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_resources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_resources(::Google::Cloud::ConfigService::V1::ListResourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_resources_client_stub.call_count
      end
    end
  end

  def test_export_deployment_statefile
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::Statefile.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    draft = true

    export_deployment_statefile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_export_deployment_statefile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_deployment_statefile_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_deployment_statefile({ parent: parent, draft: draft }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_deployment_statefile parent: parent, draft: draft do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_deployment_statefile ::Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest.new(parent: parent, draft: draft) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_deployment_statefile({ parent: parent, draft: draft }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_deployment_statefile(::Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest.new(parent: parent, draft: draft), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_deployment_statefile_client_stub.call_count
      end
    end
  end

  def test_export_revision_statefile
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::Statefile.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    export_revision_statefile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_export_revision_statefile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_revision_statefile_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_revision_statefile({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_revision_statefile parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_revision_statefile ::Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_revision_statefile({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_revision_statefile(::Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_revision_statefile_client_stub.call_count
      end
    end
  end

  def test_import_statefile
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::Statefile.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    lock_id = 42
    skip_draft = true

    import_statefile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_import_statefile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_statefile_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_statefile({ parent: parent, lock_id: lock_id, skip_draft: skip_draft }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_statefile parent: parent, lock_id: lock_id, skip_draft: skip_draft do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_statefile ::Google::Cloud::ConfigService::V1::ImportStatefileRequest.new(parent: parent, lock_id: lock_id, skip_draft: skip_draft) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_statefile({ parent: parent, lock_id: lock_id, skip_draft: skip_draft }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_statefile(::Google::Cloud::ConfigService::V1::ImportStatefileRequest.new(parent: parent, lock_id: lock_id, skip_draft: skip_draft), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_statefile_client_stub.call_count
      end
    end
  end

  def test_delete_statefile
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    lock_id = 42

    delete_statefile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_delete_statefile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_statefile_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_statefile({ name: name, lock_id: lock_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_statefile name: name, lock_id: lock_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_statefile ::Google::Cloud::ConfigService::V1::DeleteStatefileRequest.new(name: name, lock_id: lock_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_statefile({ name: name, lock_id: lock_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_statefile(::Google::Cloud::ConfigService::V1::DeleteStatefileRequest.new(name: name, lock_id: lock_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_statefile_client_stub.call_count
      end
    end
  end

  def test_lock_deployment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    lock_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_lock_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lock_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lock_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lock_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lock_deployment ::Google::Cloud::ConfigService::V1::LockDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lock_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lock_deployment(::Google::Cloud::ConfigService::V1::LockDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lock_deployment_client_stub.call_count
      end
    end
  end

  def test_unlock_deployment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    lock_id = 42

    unlock_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_unlock_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, unlock_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.unlock_deployment({ name: name, lock_id: lock_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.unlock_deployment name: name, lock_id: lock_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.unlock_deployment ::Google::Cloud::ConfigService::V1::UnlockDeploymentRequest.new(name: name, lock_id: lock_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.unlock_deployment({ name: name, lock_id: lock_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.unlock_deployment(::Google::Cloud::ConfigService::V1::UnlockDeploymentRequest.new(name: name, lock_id: lock_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, unlock_deployment_client_stub.call_count
      end
    end
  end

  def test_export_lock_info
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::LockInfo.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    export_lock_info_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_export_lock_info_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_lock_info_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_lock_info({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_lock_info name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_lock_info ::Google::Cloud::ConfigService::V1::ExportLockInfoRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_lock_info({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_lock_info(::Google::Cloud::ConfigService::V1::ExportLockInfoRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_lock_info_client_stub.call_count
      end
    end
  end

  def test_create_preview
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    preview_id = "hello world"
    preview = {}
    request_id = "hello world"

    create_preview_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_create_preview_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_preview_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_preview({ parent: parent, preview_id: preview_id, preview: preview, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_preview parent: parent, preview_id: preview_id, preview: preview, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_preview ::Google::Cloud::ConfigService::V1::CreatePreviewRequest.new(parent: parent, preview_id: preview_id, preview: preview, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_preview({ parent: parent, preview_id: preview_id, preview: preview, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_preview(::Google::Cloud::ConfigService::V1::CreatePreviewRequest.new(parent: parent, preview_id: preview_id, preview: preview, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_preview_client_stub.call_count
      end
    end
  end

  def test_get_preview
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::Preview.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_preview_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_get_preview_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_preview_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_preview({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_preview name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_preview ::Google::Cloud::ConfigService::V1::GetPreviewRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_preview({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_preview(::Google::Cloud::ConfigService::V1::GetPreviewRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_preview_client_stub.call_count
      end
    end
  end

  def test_list_previews
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ListPreviewsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_previews_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_list_previews_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_previews_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_previews({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_previews parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_previews ::Google::Cloud::ConfigService::V1::ListPreviewsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_previews({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_previews(::Google::Cloud::ConfigService::V1::ListPreviewsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_previews_client_stub.call_count
      end
    end
  end

  def test_delete_preview
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_preview_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_delete_preview_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_preview_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_preview({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_preview name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_preview ::Google::Cloud::ConfigService::V1::DeletePreviewRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_preview({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_preview(::Google::Cloud::ConfigService::V1::DeletePreviewRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_preview_client_stub.call_count
      end
    end
  end

  def test_export_preview_result
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ExportPreviewResultResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    export_preview_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_export_preview_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_preview_result_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_preview_result({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_preview_result parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_preview_result ::Google::Cloud::ConfigService::V1::ExportPreviewResultRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_preview_result({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_preview_result(::Google::Cloud::ConfigService::V1::ExportPreviewResultRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_preview_result_client_stub.call_count
      end
    end
  end

  def test_list_terraform_versions
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ListTerraformVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_terraform_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_list_terraform_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_terraform_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_terraform_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_terraform_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_terraform_versions ::Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_terraform_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_terraform_versions(::Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_terraform_versions_client_stub.call_count
      end
    end
  end

  def test_get_terraform_version
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::TerraformVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_terraform_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_get_terraform_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_terraform_version_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_terraform_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_terraform_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_terraform_version ::Google::Cloud::ConfigService::V1::GetTerraformVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_terraform_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_terraform_version(::Google::Cloud::ConfigService::V1::GetTerraformVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_terraform_version_client_stub.call_count
      end
    end
  end

  def test_list_resource_changes
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ListResourceChangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_resource_changes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_list_resource_changes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_resource_changes_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_resource_changes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_resource_changes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_resource_changes ::Google::Cloud::ConfigService::V1::ListResourceChangesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_resource_changes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_resource_changes(::Google::Cloud::ConfigService::V1::ListResourceChangesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_resource_changes_client_stub.call_count
      end
    end
  end

  def test_get_resource_change
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ResourceChange.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_change_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_get_resource_change_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_resource_change_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_resource_change({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_resource_change name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_resource_change ::Google::Cloud::ConfigService::V1::GetResourceChangeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_resource_change({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_resource_change(::Google::Cloud::ConfigService::V1::GetResourceChangeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_resource_change_client_stub.call_count
      end
    end
  end

  def test_list_resource_drifts
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ListResourceDriftsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_resource_drifts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_list_resource_drifts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_resource_drifts_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_resource_drifts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_resource_drifts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_resource_drifts ::Google::Cloud::ConfigService::V1::ListResourceDriftsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_resource_drifts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_resource_drifts(::Google::Cloud::ConfigService::V1::ListResourceDriftsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_resource_drifts_client_stub.call_count
      end
    end
  end

  def test_get_resource_drift
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::ResourceDrift.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_drift_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_get_resource_drift_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_resource_drift_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_resource_drift({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_resource_drift name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_resource_drift ::Google::Cloud::ConfigService::V1::GetResourceDriftRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_resource_drift({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_resource_drift(::Google::Cloud::ConfigService::V1::GetResourceDriftRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_resource_drift_client_stub.call_count
      end
    end
  end

  def test_get_auto_migration_config
    # Create test objects.
    client_result = ::Google::Cloud::ConfigService::V1::AutoMigrationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_auto_migration_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_get_auto_migration_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_auto_migration_config_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_auto_migration_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_auto_migration_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_auto_migration_config ::Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_auto_migration_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_auto_migration_config(::Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_auto_migration_config_client_stub.call_count
      end
    end
  end

  def test_update_auto_migration_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    auto_migration_config = {}

    update_auto_migration_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigService::V1::Config::Rest::ServiceStub.stub :transcode_update_auto_migration_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_auto_migration_config_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_auto_migration_config({ update_mask: update_mask, auto_migration_config: auto_migration_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_auto_migration_config update_mask: update_mask, auto_migration_config: auto_migration_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_auto_migration_config ::Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest.new(update_mask: update_mask, auto_migration_config: auto_migration_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_auto_migration_config({ update_mask: update_mask, auto_migration_config: auto_migration_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_auto_migration_config(::Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest.new(update_mask: update_mask, auto_migration_config: auto_migration_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_auto_migration_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfigService::V1::Config::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ConfigService::V1::Config::Rest::Client::Configuration, config
  end
end
