# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/config_service/v1/config"

class ::Google::Cloud::ConfigService::V1::Config::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_auto_migration_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.auto_migration_config_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/autoMigrationConfig", path
    end
  end

  def test_deployment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.deployment_path project: "value0", location: "value1", deployment: "value2"
      assert_equal "projects/value0/locations/value1/deployments/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_preview_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.preview_path project: "value0", location: "value1", preview: "value2"
      assert_equal "projects/value0/locations/value1/previews/value2", path
    end
  end

  def test_resource_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.resource_path project: "value0", location: "value1", deployment: "value2", revision: "value3", resource: "value4"
      assert_equal "projects/value0/locations/value1/deployments/value2/revisions/value3/resources/value4", path
    end
  end

  def test_resource_change_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.resource_change_path project: "value0", location: "value1", preview: "value2", resource_change: "value3"
      assert_equal "projects/value0/locations/value1/previews/value2/resourceChanges/value3", path
    end
  end

  def test_resource_drift_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.resource_drift_path project: "value0", location: "value1", preview: "value2", resource_drift: "value3"
      assert_equal "projects/value0/locations/value1/previews/value2/resourceDrifts/value3", path
    end
  end

  def test_revision_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.revision_path project: "value0", location: "value1", deployment: "value2", revision: "value3"
      assert_equal "projects/value0/locations/value1/deployments/value2/revisions/value3", path
    end
  end

  def test_service_account_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.service_account_path project: "value0", service_account: "value1"
      assert_equal "projects/value0/serviceAccounts/value1", path
    end
  end

  def test_terraform_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.terraform_version_path project: "value0", location: "value1", terraform_version: "value2"
      assert_equal "projects/value0/locations/value1/terraformVersions/value2", path
    end
  end

  def test_worker_pool_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.worker_pool_path project: "value0", location: "value1", worker_pool: "value2"
      assert_equal "projects/value0/locations/value1/workerPools/value2", path
    end
  end
end
