# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ConfigService
      module V1
        # A Deployment is a group of resources and configs managed and provisioned by
        # Infra Manager.
        # @!attribute [rw] terraform_blueprint
        #   @return [::Google::Cloud::ConfigService::V1::TerraformBlueprint]
        #     A blueprint described using Terraform's HashiCorp Configuration Language
        #     as a root module.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the deployment.
        #     Format: `projects/{project}/locations/{location}/deployments/{deployment}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the deployment was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the deployment was last modified.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined metadata for the deployment.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ConfigService::V1::Deployment::State]
        #     Output only. Current state of the deployment.
        # @!attribute [r] latest_revision
        #   @return [::String]
        #     Output only. Revision name that was most recently applied.
        #     Format: `projects/{project}/locations/{location}/deployments/{deployment}/
        #     revisions/\\{revision}`
        # @!attribute [r] state_detail
        #   @return [::String]
        #     Output only. Additional information regarding the current state.
        # @!attribute [r] error_code
        #   @return [::Google::Cloud::ConfigService::V1::Deployment::ErrorCode]
        #     Output only. Error code describing errors that may have occurred.
        # @!attribute [r] delete_results
        #   @return [::Google::Cloud::ConfigService::V1::ApplyResults]
        #     Output only. Location of artifacts from a DeleteDeployment operation.
        # @!attribute [r] delete_build
        #   @return [::String]
        #     Output only. Cloud Build instance UUID associated with deleting this
        #     deployment.
        # @!attribute [r] delete_logs
        #   @return [::String]
        #     Output only. Location of Cloud Build logs in Google Cloud Storage,
        #     populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
        # @!attribute [r] tf_errors
        #   @return [::Array<::Google::Cloud::ConfigService::V1::TerraformError>]
        #     Output only. Errors encountered when deleting this deployment.
        #     Errors are truncated to 10 entries, see `delete_results` and `error_logs`
        #     for full details.
        # @!attribute [r] error_logs
        #   @return [::String]
        #     Output only. Location of Terraform error logs in Google Cloud Storage.
        #     Format: `gs://{bucket}/{object}`.
        # @!attribute [rw] artifacts_gcs_bucket
        #   @return [::String]
        #     Optional. User-defined location of Cloud Build logs and artifacts in Google
        #     Cloud Storage. Format: `gs://{bucket}/{folder}`
        #
        #     A default bucket will be bootstrapped if the field is not set or empty.
        #     Default bucket format: `gs://<project number>-<region>-blueprint-config`
        #     Constraints:
        #     - The bucket needs to be in the same project as the deployment
        #     - The path cannot be within the path of `gcs_source`
        #     - The field cannot be updated, including changing its presence
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Required. User-specified Service Account (SA) credentials to be used when
        #     actuating resources.
        #     Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
        # @!attribute [rw] import_existing_resources
        #   @return [::Boolean]
        #     By default, Infra Manager will return a failure when
        #     Terraform encounters a 409 code (resource conflict error) during actuation.
        #     If this flag is set to true, Infra Manager will instead
        #     attempt to automatically import the resource into the Terraform state (for
        #     supported resource types) and continue actuation.
        #
        #     Not all resource types are supported, refer to documentation.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     Optional. The user-specified Cloud Build worker pool resource in which the
        #     Cloud Build job will execute. Format:
        #     `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
        #     If this field is unspecified, the default Cloud Build worker pool will be
        #     used.
        # @!attribute [r] lock_state
        #   @return [::Google::Cloud::ConfigService::V1::Deployment::LockState]
        #     Output only. Current lock state of the deployment.
        # @!attribute [rw] tf_version_constraint
        #   @return [::String]
        #     Optional. The user-specified Terraform version constraint.
        #     Example: "=1.3.10".
        # @!attribute [r] tf_version
        #   @return [::String]
        #     Output only. The current Terraform version set on the deployment.
        #     It is in the format of "Major.Minor.Patch", for example, "1.3.10".
        # @!attribute [rw] quota_validation
        #   @return [::Google::Cloud::ConfigService::V1::QuotaValidation]
        #     Optional. Input to control quota checks for resources in terraform
        #     configuration files. There are limited resources on which quota validation
        #     applies.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Arbitrary key-value metadata storage e.g. to help client tools
        #     identify deployments during automation. See
        #     https://google.aip.dev/148#annotations for details on format and size
        #     limitations.
        # @!attribute [rw] provider_config
        #   @return [::Google::Cloud::ConfigService::V1::ProviderConfig]
        #     Optional. This field specifies the provider configurations.
        class Deployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states of a deployment.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The deployment is being created.
            CREATING = 1

            # The deployment is healthy.
            ACTIVE = 2

            # The deployment is being updated.
            UPDATING = 3

            # The deployment is being deleted.
            DELETING = 4

            # The deployment has encountered an unexpected error.
            FAILED = 5

            # The deployment is no longer being actively reconciled.
            # This may be the result of recovering the project after deletion.
            SUSPENDED = 6

            # The deployment has been deleted.
            DELETED = 7
          end

          # Possible errors that can occur with deployments.
          module ErrorCode
            # No error code was specified.
            ERROR_CODE_UNSPECIFIED = 0

            # The revision failed. See Revision for more details.
            REVISION_FAILED = 1

            # Cloud Build failed due to a permission issue.
            CLOUD_BUILD_PERMISSION_DENIED = 3

            # Cloud Build job associated with a deployment deletion could not be
            # started.
            DELETE_BUILD_API_FAILED = 5

            # Cloud Build job associated with a deployment deletion was started but
            # failed.
            DELETE_BUILD_RUN_FAILED = 6

            # Cloud Storage bucket creation failed due to a permission issue.
            BUCKET_CREATION_PERMISSION_DENIED = 7

            # Cloud Storage bucket creation failed due to an issue unrelated to
            # permissions.
            BUCKET_CREATION_FAILED = 8

            # Failed to import values from an external source.
            EXTERNAL_VALUE_SOURCE_IMPORT_FAILED = 10
          end

          # Possible lock states of a deployment.
          module LockState
            # The default value. This value is used if the lock state is omitted.
            LOCK_STATE_UNSPECIFIED = 0

            # The deployment is locked.
            LOCKED = 1

            # The deployment is unlocked.
            UNLOCKED = 2

            # The deployment is being locked.
            LOCKING = 3

            # The deployment is being unlocked.
            UNLOCKING = 4

            # The deployment has failed to lock.
            LOCK_FAILED = 5

            # The deployment has failed to unlock.
            UNLOCK_FAILED = 6
          end
        end

        # TerraformBlueprint describes the source of a Terraform root module which
        # describes the resources and configs to be deployed.
        # @!attribute [rw] gcs_source
        #   @return [::String]
        #     URI of an object in Google Cloud Storage.
        #     Format: `gs://{bucket}/{object}`
        #
        #     URI may also specify an object version for zipped objects.
        #     Format: `gs://{bucket}/{object}#{version}`
        #
        #     Note: The following fields are mutually exclusive: `gcs_source`, `git_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] git_source
        #   @return [::Google::Cloud::ConfigService::V1::GitSource]
        #     URI of a public Git repo.
        #
        #     Note: The following fields are mutually exclusive: `git_source`, `gcs_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] input_values
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ConfigService::V1::TerraformVariable}]
        #     Optional. Input variable values for the Terraform blueprint.
        class TerraformBlueprint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ConfigService::V1::TerraformVariable]
          class InputValuesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A Terraform input variable.
        # @!attribute [rw] input_value
        #   @return [::Google::Protobuf::Value]
        #     Optional. Input variable value.
        class TerraformVariable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Outputs and artifacts from applying a deployment.
        # @!attribute [rw] content
        #   @return [::String]
        #     Location of a blueprint copy and other manifests in Google Cloud Storage.
        #     Format: `gs://{bucket}/{object}`
        # @!attribute [rw] artifacts
        #   @return [::String]
        #     Location of artifacts (e.g. logs) in Google Cloud Storage.
        #     Format: `gs://{bucket}/{object}`
        # @!attribute [rw] outputs
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ConfigService::V1::TerraformOutput}]
        #     Map of output name to output info.
        class ApplyResults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ConfigService::V1::TerraformOutput]
          class OutputsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Describes a Terraform output.
        # @!attribute [rw] sensitive
        #   @return [::Boolean]
        #     Identifies whether Terraform has set this output as a potential
        #     sensitive value.
        # @!attribute [rw] value
        #   @return [::Google::Protobuf::Value]
        #     Value of output.
        class TerraformOutput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the Deployments are listed. The
        #     parent value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}'.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     When requesting a page of resources, 'page_size' specifies number of
        #     resources to return. If unspecified, at most 500 will be returned. The
        #     maximum value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Token returned by previous call to 'ListDeployments' which specifies the
        #     position in the list from where to continue listing the resources.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the Deployments that match the filter expression. A filter
        #     expression filters the resources listed in the response. The expression
        #     must be of the form '\\{field} \\{operator} \\{value}' where operators: '<', '>',
        #     '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
        #     operator which is roughly synonymous with equality). \\{field} can refer to a
        #     proto or JSON field, or a synthetic field. Field names can be camelCase or
        #     snake_case.
        #
        #     Examples:
        #     - Filter by name:
        #       name = "projects/foo/locations/us-central1/deployments/bar
        #
        #     - Filter by labels:
        #       - Resources that have a key called 'foo'
        #         labels.foo:*
        #       - Resources that have a key called 'foo' whose value is 'bar'
        #         labels.foo = bar
        #
        #     - Filter by state:
        #       - Deployments in CREATING state.
        #         state=CREATING
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the list.
        class ListDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] deployments
        #   @return [::Array<::Google::Cloud::ConfigService::V1::Deployment>]
        #     List of {::Google::Cloud::ConfigService::V1::Deployment Deployment}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to be supplied to the next ListDeployments request via `page_token`
        #     to obtain the next set of results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment. Format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        class GetDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list Revisions passed to a 'ListRevisions' call.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the Revisions are listed. The parent
        #     value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     When requesting a page of resources, `page_size` specifies number of
        #     resources to return. If unspecified, at most 500 will be returned. The
        #     maximum value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Token returned by previous call to 'ListRevisions' which specifies the
        #     position in the list from where to continue listing the resources.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the Revisions that match the filter expression. A filter
        #     expression filters the resources listed in the response. The expression
        #     must be of the form '\\{field} \\{operator} \\{value}' where operators: '<', '>',
        #     '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
        #     operator which is roughly synonymous with equality). \\{field} can refer to a
        #     proto or JSON field, or a synthetic field. Field names can be camelCase or
        #     snake_case.
        #
        #     Examples:
        #     - Filter by name:
        #       name = "projects/foo/locations/us-central1/deployments/dep/revisions/bar
        #
        #     - Filter by labels:
        #       - Resources that have a key called 'foo'
        #         labels.foo:*
        #       - Resources that have a key called 'foo' whose value is 'bar'
        #         labels.foo = bar
        #
        #     - Filter by state:
        #       - Revisions in CREATING state.
        #         state=CREATING
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the list.
        class ListRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to a 'ListRevisions' call. Contains a list of Revisions.
        # @!attribute [rw] revisions
        #   @return [::Array<::Google::Cloud::ConfigService::V1::Revision>]
        #     List of {::Google::Cloud::ConfigService::V1::Revision Revision}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to request the next page of resources from the 'ListRevisions'
        #     method. The value of an empty string means that there are no more resources
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a Revision from a 'GetRevision' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Revision in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}/revisions/\\{revision}'.
        class GetRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the Deployment is created. The parent
        #     value is in the format: 'projects/\\{project_id}/locations/\\{location}'.
        # @!attribute [rw] deployment_id
        #   @return [::String]
        #     Required. The Deployment ID.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::ConfigService::V1::Deployment]
        #     Required. {::Google::Cloud::ConfigService::V1::Deployment Deployment} resource to be
        #     created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask used to specify the fields to be overwritten in the
        #     Deployment resource by the update.
        #
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::ConfigService::V1::Deployment]
        #     Required. {::Google::Cloud::ConfigService::V1::Deployment Deployment} to update.
        #
        #     The deployment's `name` field is used to identify the resource to be
        #     updated. Format:
        #     `projects/{project}/locations/{location}/deployments/{deployment}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Deployment in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any revisions for this deployment will also be
        #     deleted. (Otherwise, the request will only work if the deployment has no
        #     revisions.)
        # @!attribute [rw] delete_policy
        #   @return [::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest::DeletePolicy]
        #     Optional. Policy on how resources actuated by the deployment should be
        #     deleted. If unspecified, the default behavior is to delete the underlying
        #     resources.
        class DeleteDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Policy on how resources actuated by the deployment should be deleted.
          module DeletePolicy
            # Unspecified policy, resources will be deleted.
            DELETE_POLICY_UNSPECIFIED = 0

            # Deletes resources actuated by the deployment.
            DELETE = 1

            # Abandons resources and only deletes the deployment and its metadata.
            ABANDON = 2
          end
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] deployment_metadata
        #   @return [::Google::Cloud::ConfigService::V1::DeploymentOperationMetadata]
        #     Output only. Metadata about the deployment operation state.
        #
        #     Note: The following fields are mutually exclusive: `deployment_metadata`, `preview_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] preview_metadata
        #   @return [::Google::Cloud::ConfigService::V1::PreviewOperationMetadata]
        #     Output only. Metadata about the preview operation state.
        #
        #     Note: The following fields are mutually exclusive: `preview_metadata`, `deployment_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation of the
        #     operation. Operations that have successfully been cancelled have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of `1`,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A child resource of a Deployment generated by a 'CreateDeployment' or
        # 'UpdateDeployment' call. Each Revision contains metadata pertaining to a
        # snapshot of a particular Deployment.
        # @!attribute [r] terraform_blueprint
        #   @return [::Google::Cloud::ConfigService::V1::TerraformBlueprint]
        #     Output only. A blueprint described using Terraform's HashiCorp
        #     Configuration Language as a root module.
        # @!attribute [rw] name
        #   @return [::String]
        #     Revision name. Format:
        #     `projects/{project}/locations/{location}/deployments/{deployment}/
        #     revisions/\\{revision}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the revision was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the revision was last modified.
        # @!attribute [r] action
        #   @return [::Google::Cloud::ConfigService::V1::Revision::Action]
        #     Output only. The action which created this revision
        # @!attribute [r] state
        #   @return [::Google::Cloud::ConfigService::V1::Revision::State]
        #     Output only. Current state of the revision.
        # @!attribute [r] apply_results
        #   @return [::Google::Cloud::ConfigService::V1::ApplyResults]
        #     Output only. Outputs and artifacts from applying a deployment.
        # @!attribute [r] state_detail
        #   @return [::String]
        #     Output only. Additional info regarding the current state.
        # @!attribute [r] error_code
        #   @return [::Google::Cloud::ConfigService::V1::Revision::ErrorCode]
        #     Output only. Code describing any errors that may have occurred.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. Cloud Build instance UUID associated with this revision.
        # @!attribute [r] logs
        #   @return [::String]
        #     Output only. Location of Revision operation logs in
        #     `gs://{bucket}/{object}` format.
        # @!attribute [r] tf_errors
        #   @return [::Array<::Google::Cloud::ConfigService::V1::TerraformError>]
        #     Output only. Errors encountered when creating or updating this deployment.
        #     Errors are truncated to 10 entries, see `delete_results` and `error_logs`
        #     for full details.
        # @!attribute [r] error_logs
        #   @return [::String]
        #     Output only. Location of Terraform error logs in Google Cloud Storage.
        #     Format: `gs://{bucket}/{object}`.
        # @!attribute [r] service_account
        #   @return [::String]
        #     Output only. User-specified Service Account (SA) to be used as credential
        #     to manage resources. Format:
        #     `projects/{projectID}/serviceAccounts/{serviceAccount}`
        # @!attribute [r] import_existing_resources
        #   @return [::Boolean]
        #     Output only. By default, Infra Manager will return a failure when
        #     Terraform encounters a 409 code (resource conflict error) during actuation.
        #     If this flag is set to true, Infra Manager will instead
        #     attempt to automatically import the resource into the Terraform state (for
        #     supported resource types) and continue actuation.
        #
        #     Not all resource types are supported, refer to documentation.
        # @!attribute [r] worker_pool
        #   @return [::String]
        #     Output only. The user-specified Cloud Build worker pool resource in which
        #     the Cloud Build job will execute. Format:
        #     `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
        #     If this field is unspecified, the default Cloud Build worker pool will be
        #     used.
        # @!attribute [r] tf_version_constraint
        #   @return [::String]
        #     Output only. The user-specified Terraform version constraint.
        #     Example: "=1.3.10".
        # @!attribute [r] tf_version
        #   @return [::String]
        #     Output only. The version of Terraform used to create the Revision.
        #     It is in the format of "Major.Minor.Patch", for example, "1.3.10".
        # @!attribute [r] quota_validation_results
        #   @return [::String]
        #     Output only. Cloud Storage path containing quota validation results. This
        #     field is set when a user sets Deployment.quota_validation field to ENABLED
        #     or ENFORCED. Format: `gs://{bucket}/{object}`.
        # @!attribute [rw] quota_validation
        #   @return [::Google::Cloud::ConfigService::V1::QuotaValidation]
        #     Optional. Input to control quota checks for resources in terraform
        #     configuration files. There are limited resources on which quota validation
        #     applies.
        # @!attribute [r] provider_config
        #   @return [::Google::Cloud::ConfigService::V1::ProviderConfig]
        #     Output only. This field specifies the provider configurations.
        class Revision
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Actions that generate a revision.
          module Action
            # The default value. This value is used if the action is omitted.
            ACTION_UNSPECIFIED = 0

            # The revision was generated by creating a deployment.
            CREATE = 1

            # The revision was generated by updating a deployment.
            UPDATE = 2

            # The revision was deleted.
            DELETE = 3
          end

          # Possible states of a revision.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The revision is being applied.
            APPLYING = 1

            # The revision was applied successfully.
            APPLIED = 2

            # The revision could not be applied successfully.
            FAILED = 3
          end

          # Possible errors if Revision could not be created or updated successfully.
          module ErrorCode
            # No error code was specified.
            ERROR_CODE_UNSPECIFIED = 0

            # Cloud Build failed due to a permission issue.
            CLOUD_BUILD_PERMISSION_DENIED = 1

            # Cloud Build job associated with creating or updating a deployment could
            # not be started.
            APPLY_BUILD_API_FAILED = 4

            # Cloud Build job associated with creating or updating a deployment was
            # started but failed.
            APPLY_BUILD_RUN_FAILED = 5

            # quota validation failed for one or more resources in terraform
            # configuration files.
            QUOTA_VALIDATION_FAILED = 7

            # Failed to import values from an external source.
            EXTERNAL_VALUE_SOURCE_IMPORT_FAILED = 8
          end
        end

        # Errors encountered during actuation using Terraform
        # @!attribute [rw] resource_address
        #   @return [::String]
        #     Address of the resource associated with the error,
        #     e.g. `google_compute_network.vpc_network`.
        # @!attribute [rw] http_response_code
        #   @return [::Integer]
        #     HTTP response code returned from Google Cloud Platform APIs when Terraform
        #     fails to provision the resource. If unset or 0, no HTTP response code was
        #     returned by Terraform.
        # @!attribute [rw] error_description
        #   @return [::String]
        #     A human-readable error description.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Original error response from underlying Google API, if
        #     available.
        class TerraformError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of files in a Git repository.
        # @!attribute [rw] repo
        #   @return [::String]
        #     Optional. Repository URL.
        #     Example: 'https://github.com/kubernetes/examples.git'
        # @!attribute [rw] directory
        #   @return [::String]
        #     Optional. Subdirectory inside the repository.
        #     Example: 'staging/my-package'
        # @!attribute [rw] ref
        #   @return [::String]
        #     Optional. Git reference (e.g. branch or tag).
        class GitSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Ephemeral metadata content describing the state of a deployment operation.
        # @!attribute [rw] step
        #   @return [::Google::Cloud::ConfigService::V1::DeploymentOperationMetadata::DeploymentStep]
        #     The current step the deployment operation is running.
        # @!attribute [rw] apply_results
        #   @return [::Google::Cloud::ConfigService::V1::ApplyResults]
        #     Outputs and artifacts from applying a deployment.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. Cloud Build instance UUID associated with this operation.
        # @!attribute [r] logs
        #   @return [::String]
        #     Output only. Location of Deployment operations logs in
        #     `gs://{bucket}/{object}` format.
        class DeploymentOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible steps a deployment may be running.
          module DeploymentStep
            # Unspecified deployment step
            DEPLOYMENT_STEP_UNSPECIFIED = 0

            # Infra Manager is creating a Google Cloud Storage bucket to store
            # artifacts and metadata about the deployment and revision
            PREPARING_STORAGE_BUCKET = 1

            # Downloading the blueprint onto the Google Cloud Storage bucket
            DOWNLOADING_BLUEPRINT = 2

            # Initializing Terraform using `terraform init`
            RUNNING_TF_INIT = 3

            # Running `terraform plan`
            RUNNING_TF_PLAN = 4

            # Actuating resources using Terraform using `terraform apply`
            RUNNING_TF_APPLY = 5

            # Destroying resources using Terraform using `terraform destroy`
            RUNNING_TF_DESTROY = 6

            # Validating the uploaded TF state file when unlocking a deployment
            RUNNING_TF_VALIDATE = 7

            # Unlocking a deployment
            UNLOCKING_DEPLOYMENT = 8

            # Operation was successful
            SUCCEEDED = 9

            # Operation failed
            FAILED = 10

            # Validating the provided repository.
            VALIDATING_REPOSITORY = 11

            # Running quota validation
            RUNNING_QUOTA_VALIDATION = 12
          end
        end

        # Resource represents a Google Cloud Platform resource actuated by IM.
        # Resources are child resources of Revisions.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name.
        #     Format:
        #     `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
        # @!attribute [r] terraform_info
        #   @return [::Google::Cloud::ConfigService::V1::ResourceTerraformInfo]
        #     Output only. Terraform-specific info if this resource was created using
        #     Terraform.
        # @!attribute [r] cai_assets
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ConfigService::V1::ResourceCAIInfo}]
        #     Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
        #     ID). CAI type format follows
        #     https://cloud.google.com/asset-inventory/docs/supported-asset-types
        # @!attribute [r] intent
        #   @return [::Google::Cloud::ConfigService::V1::Resource::Intent]
        #     Output only. Intent of the resource.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ConfigService::V1::Resource::State]
        #     Output only. Current state of the resource.
        class Resource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ConfigService::V1::ResourceCAIInfo]
          class CaiAssetsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible intent of the resource.
          module Intent
            # The default value. This value is used if the intent is omitted.
            INTENT_UNSPECIFIED = 0

            # Infra Manager will create this Resource.
            CREATE = 1

            # Infra Manager will update this Resource.
            UPDATE = 2

            # Infra Manager will delete this Resource.
            DELETE = 3

            # Infra Manager will destroy and recreate this Resource.
            RECREATE = 4

            # Infra Manager will leave this Resource untouched.
            UNCHANGED = 5
          end

          # Possible states of a resource.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # Resource has been planned for reconcile.
            PLANNED = 1

            # Resource is actively reconciling into the intended state.
            IN_PROGRESS = 2

            # Resource has reconciled to intended state.
            RECONCILED = 3

            # Resource failed to reconcile.
            FAILED = 4
          end
        end

        # Terraform info of a Resource.
        # @!attribute [rw] address
        #   @return [::String]
        #     TF resource address that uniquely identifies this resource within this
        #     deployment.
        # @!attribute [rw] type
        #   @return [::String]
        #     TF resource type
        # @!attribute [rw] id
        #   @return [::String]
        #     ID attribute of the TF resource
        class ResourceTerraformInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CAI info of a Resource.
        # @!attribute [rw] full_resource_name
        #   @return [::String]
        #     CAI resource name in the format following
        #     https://cloud.google.com/apis/design/resource_names#full_resource_name
        class ResourceCAIInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a Resource from a 'GetResource' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Resource in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}/revisions/\\{revision}/resource/\\{resource}'.
        class GetResourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list Resources passed to a 'ListResources' call.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the Resources are listed. The parent
        #     value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}/revisions/\\{revision}'.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     When requesting a page of resources, 'page_size' specifies number of
        #     resources to return. If unspecified, at most 500 will be returned. The
        #     maximum value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Token returned by previous call to 'ListResources' which specifies the
        #     position in the list from where to continue listing the resources.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the Resources that match the filter expression. A filter
        #     expression filters the resources listed in the response. The expression
        #     must be of the form '\\{field} \\{operator} \\{value}' where operators: '<', '>',
        #     '<=',
        #     '>=',
        #     '!=', '=', ':' are supported (colon ':' represents a HAS operator which is
        #     roughly synonymous with equality). \\{field} can refer to a proto or JSON
        #     field, or a synthetic field. Field names can be camelCase or snake_case.
        #
        #     Examples:
        #     - Filter by name:
        #       name =
        #       "projects/foo/locations/us-central1/deployments/dep/revisions/bar/resources/baz
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the list.
        class ListResourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to a 'ListResources' call. Contains a list of Resources.
        # @!attribute [rw] resources
        #   @return [::Array<::Google::Cloud::ConfigService::V1::Resource>]
        #     List of {::Google::Cloud::ConfigService::V1::Resource Resources}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to request the next page of resources from the 'ListResources'
        #     method. The value of an empty string means that there are no more resources
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListResourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains info about a Terraform state file
        # @!attribute [r] signed_uri
        #   @return [::String]
        #     Output only. Cloud Storage signed URI used for downloading or uploading the
        #     state file.
        class Statefile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to export a state file passed to a 'ExportDeploymentStatefile'
        # call.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the statefile is listed. The parent
        #     value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        # @!attribute [rw] draft
        #   @return [::Boolean]
        #     Optional. If this flag is set to true, the exported deployment state file
        #     will be the draft state. This will enable the draft file to be validated
        #     before copying it over to the working state on unlock.
        class ExportDeploymentStatefileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to export a state file passed to a 'ExportRevisionStatefile'
        # call.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the statefile is listed. The parent
        #     value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}/revisions/\\{revision}'.
        class ExportRevisionStatefileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to import a state file passed to a 'ImportStatefile' call.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the statefile is listed. The parent
        #     value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        # @!attribute [rw] lock_id
        #   @return [::Integer]
        #     Required. Lock ID of the lock file to verify that the user who is importing
        #     the state file previously locked the Deployment.
        # @!attribute [rw] skip_draft
        #   @return [::Boolean]
        #     Optional.
        class ImportStatefileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a state file passed to a 'DeleteStatefile' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        # @!attribute [rw] lock_id
        #   @return [::Integer]
        #     Required. Lock ID of the lock file to verify that the user who is deleting
        #     the state file previously locked the Deployment.
        class DeleteStatefileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to lock a deployment passed to a 'LockDeployment' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        class LockDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to unlock a state file passed to a 'UnlockDeployment' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        # @!attribute [rw] lock_id
        #   @return [::Integer]
        #     Required. Lock ID of the lock file to be unlocked.
        class UnlockDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a state file lock info passed to a 'ExportLockInfo' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment in the format:
        #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
        class ExportLockInfoRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details about the lock which locked the deployment.
        # @!attribute [rw] lock_id
        #   @return [::Integer]
        #     Unique ID for the lock to be overridden with generation ID in the backend.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Terraform operation, provided by the caller.
        # @!attribute [rw] info
        #   @return [::String]
        #     Extra information to store with the lock, provided by the caller.
        # @!attribute [rw] who
        #   @return [::String]
        #     user@hostname when available
        # @!attribute [rw] version
        #   @return [::String]
        #     Terraform version
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time that the lock was taken.
        class LockInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A preview represents a set of actions Infra Manager would perform
        # to move the resources towards the desired state as specified in the
        # configuration.
        # @!attribute [rw] terraform_blueprint
        #   @return [::Google::Cloud::ConfigService::V1::TerraformBlueprint]
        #     The terraform blueprint to preview.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the preview. Resource name can be user
        #     provided or server generated ID if unspecified. Format:
        #     `projects/{project}/locations/{location}/previews/{preview}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the preview was created.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the preview.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ConfigService::V1::Preview::State]
        #     Output only. Current state of the preview.
        # @!attribute [rw] deployment
        #   @return [::String]
        #     Optional. Optional deployment reference. If specified, the preview will be
        #     performed using the provided deployment's current state and use any
        #     relevant fields from the deployment unless explicitly specified in the
        #     preview create request.
        # @!attribute [rw] preview_mode
        #   @return [::Google::Cloud::ConfigService::V1::Preview::PreviewMode]
        #     Optional. Current mode of preview.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Required. User-specified Service Account (SA) credentials to be used when
        #     previewing resources.
        #     Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
        # @!attribute [rw] artifacts_gcs_bucket
        #   @return [::String]
        #     Optional. User-defined location of Cloud Build logs, artifacts, and
        #     in Google Cloud Storage.
        #     Format: `gs://{bucket}/{folder}`
        #     A default bucket will be bootstrapped if the field is not set or empty
        #     Default Bucket Format: `gs://<project number>-<region>-blueprint-config`
        #     Constraints:
        #     - The bucket needs to be in the same project as the deployment
        #     - The path cannot be within the path of `gcs_source`
        #     If omitted and deployment resource ref provided has artifacts_gcs_bucket
        #     defined, that artifact bucket is used.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     Optional. The user-specified Worker Pool resource in which the Cloud Build
        #     job will execute. Format
        #     projects/\\{project}/locations/\\{location}/workerPools/\\{workerPoolId} If this
        #     field is unspecified, the default Cloud Build worker pool will be used. If
        #     omitted and deployment resource ref provided has worker_pool defined, that
        #     worker pool is used.
        # @!attribute [r] error_code
        #   @return [::Google::Cloud::ConfigService::V1::Preview::ErrorCode]
        #     Output only. Code describing any errors that may have occurred.
        # @!attribute [r] error_status
        #   @return [::Google::Rpc::Status]
        #     Output only. Additional information regarding the current state.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. Cloud Build instance UUID associated with this preview.
        # @!attribute [r] tf_errors
        #   @return [::Array<::Google::Cloud::ConfigService::V1::TerraformError>]
        #     Output only. Summary of errors encountered during Terraform preview.
        #     It has a size limit of 10, i.e. only top 10 errors will be summarized here.
        # @!attribute [r] error_logs
        #   @return [::String]
        #     Output only. Link to tf-error.ndjson file, which contains the full list of
        #     the errors encountered during a Terraform preview.
        #     Format: `gs://{bucket}/{object}`.
        # @!attribute [r] preview_artifacts
        #   @return [::Google::Cloud::ConfigService::V1::PreviewArtifacts]
        #     Output only. Artifacts from preview.
        # @!attribute [r] logs
        #   @return [::String]
        #     Output only. Location of preview logs in `gs://{bucket}/{object}` format.
        # @!attribute [r] tf_version
        #   @return [::String]
        #     Output only. The current Terraform version set on the preview.
        #     It is in the format of "Major.Minor.Patch", for example, "1.3.10".
        # @!attribute [rw] tf_version_constraint
        #   @return [::String]
        #     Optional. The user-specified Terraform version constraint.
        #     Example: "=1.3.10".
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Arbitrary key-value metadata storage e.g. to help client tools
        #     identify preview during automation. See
        #     https://google.aip.dev/148#annotations for details on format and size
        #     limitations.
        # @!attribute [rw] provider_config
        #   @return [::Google::Cloud::ConfigService::V1::ProviderConfig]
        #     Optional. This field specifies the provider configurations.
        class Preview
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states of a preview.
          module State
            # The default value. This value is used if the state is unknown.
            STATE_UNSPECIFIED = 0

            # The preview is being created.
            CREATING = 1

            # The preview has succeeded.
            SUCCEEDED = 2

            # The preview is being applied.
            APPLYING = 3

            # The preview is stale. A preview can become stale if a revision has been
            # applied after this preview was created.
            STALE = 4

            # The preview is being deleted.
            DELETING = 5

            # The preview has encountered an unexpected error.
            FAILED = 6

            # The preview has been deleted.
            DELETED = 7
          end

          # Preview mode provides options for customizing preview operations.
          module PreviewMode
            # Unspecified policy, default mode will be used.
            PREVIEW_MODE_UNSPECIFIED = 0

            # DEFAULT mode generates an execution plan for reconciling current resource
            # state into expected resource state.
            DEFAULT = 1

            # DELETE mode generates as execution plan for destroying current resources.
            DELETE = 2
          end

          # Possible errors that can occur with previews.
          module ErrorCode
            # No error code was specified.
            ERROR_CODE_UNSPECIFIED = 0

            # Cloud Build failed due to a permissions issue.
            CLOUD_BUILD_PERMISSION_DENIED = 1

            # Cloud Storage bucket failed to create due to a permissions issue.
            BUCKET_CREATION_PERMISSION_DENIED = 2

            # Cloud Storage bucket failed for a non-permissions-related issue.
            BUCKET_CREATION_FAILED = 3

            # Acquiring lock on provided deployment reference failed.
            DEPLOYMENT_LOCK_ACQUIRE_FAILED = 4

            # Preview encountered an error when trying to access Cloud Build API.
            PREVIEW_BUILD_API_FAILED = 5

            # Preview created a build but build failed and logs were generated.
            PREVIEW_BUILD_RUN_FAILED = 6

            # Failed to import values from an external source.
            EXTERNAL_VALUE_SOURCE_IMPORT_FAILED = 7
          end
        end

        # Ephemeral metadata content describing the state of a preview operation.
        # @!attribute [rw] step
        #   @return [::Google::Cloud::ConfigService::V1::PreviewOperationMetadata::PreviewStep]
        #     The current step the preview operation is running.
        # @!attribute [rw] preview_artifacts
        #   @return [::Google::Cloud::ConfigService::V1::PreviewArtifacts]
        #     Artifacts from preview.
        # @!attribute [r] logs
        #   @return [::String]
        #     Output only. Location of preview logs in `gs://{bucket}/{object}` format.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. Cloud Build instance UUID associated with this preview.
        class PreviewOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible steps a preview may be running.
          module PreviewStep
            # Unspecified preview step.
            PREVIEW_STEP_UNSPECIFIED = 0

            # Infra Manager is creating a Google Cloud Storage bucket to store
            # artifacts and metadata about the preview.
            PREPARING_STORAGE_BUCKET = 1

            # Downloading the blueprint onto the Google Cloud Storage bucket.
            DOWNLOADING_BLUEPRINT = 2

            # Initializing Terraform using `terraform init`.
            RUNNING_TF_INIT = 3

            # Running `terraform plan`.
            RUNNING_TF_PLAN = 4

            # Fetching a deployment.
            FETCHING_DEPLOYMENT = 5

            # Locking a deployment.
            LOCKING_DEPLOYMENT = 6

            # Unlocking a deployment.
            UNLOCKING_DEPLOYMENT = 7

            # Operation was successful.
            SUCCEEDED = 8

            # Operation failed.
            FAILED = 9

            # Validating the provided repository.
            VALIDATING_REPOSITORY = 10
          end
        end

        # Artifacts created by preview.
        # @!attribute [r] content
        #   @return [::String]
        #     Output only. Location of a blueprint copy and other content in Google Cloud
        #     Storage. Format: `gs://{bucket}/{object}`
        # @!attribute [r] artifacts
        #   @return [::String]
        #     Output only. Location of artifacts in Google Cloud Storage.
        #     Format: `gs://{bucket}/{object}`
        class PreviewArtifacts
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a preview.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the Preview is created. The parent
        #     value is in the format: 'projects/\\{project_id}/locations/\\{location}'.
        # @!attribute [rw] preview_id
        #   @return [::String]
        #     Optional. The preview ID.
        # @!attribute [rw] preview
        #   @return [::Google::Cloud::ConfigService::V1::Preview]
        #     Required. {::Google::Cloud::ConfigService::V1::Preview Preview} resource to be created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreatePreviewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get details about a preview.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the preview. Format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
        class GetPreviewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list all previews for a given project and location.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the Previews are listed. The parent
        #     value is in the format: 'projects/\\{project_id}/locations/\\{location}'.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. When requesting a page of resources, 'page_size' specifies number
        #     of resources to return. If unspecified, at most 500 will be returned. The
        #     maximum value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Token returned by previous call to 'ListDeployments' which
        #     specifies the position in the list from where to continue listing the
        #     resources.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Lists the Deployments that match the filter expression. A filter
        #     expression filters the resources listed in the response. The expression
        #     must be of the form '\\{field} \\{operator} \\{value}' where operators: '<', '>',
        #     '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
        #     operator which is roughly synonymous with equality). \\{field} can refer to a
        #     proto or JSON field, or a synthetic field. Field names can be camelCase or
        #     snake_case.
        #
        #     Examples:
        #     - Filter by name:
        #       name = "projects/foo/locations/us-central1/deployments/bar
        #
        #     - Filter by labels:
        #       - Resources that have a key called 'foo'
        #         labels.foo:*
        #       - Resources that have a key called 'foo' whose value is 'bar'
        #         labels.foo = bar
        #
        #     - Filter by state:
        #       - Deployments in CREATING state.
        #         state=CREATING
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to use to sort the list.
        class ListPreviewsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to a `ListPreviews` call. Contains a list of Previews.
        # @!attribute [rw] previews
        #   @return [::Array<::Google::Cloud::ConfigService::V1::Preview>]
        #     List of {::Google::Cloud::ConfigService::V1::Preview Previews}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to be supplied to the next ListPreviews request via `page_token`
        #     to obtain the next set of results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListPreviewsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a preview.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Preview in the format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeletePreviewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to export preview results.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The preview whose results should be exported. The preview value
        #     is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
        class ExportPreviewResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to `ExportPreviewResult` call. Contains preview results.
        # @!attribute [r] result
        #   @return [::Google::Cloud::ConfigService::V1::PreviewResult]
        #     Output only. Signed URLs for accessing the plan files.
        class ExportPreviewResultResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains a signed Cloud Storage URLs.
        # @!attribute [r] binary_signed_uri
        #   @return [::String]
        #     Output only. Plan binary signed URL
        # @!attribute [r] json_signed_uri
        #   @return [::String]
        #     Output only. Plan JSON signed URL
        class PreviewResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the GetTerraformVersion method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the TerraformVersion. Format:
        #     'projects/\\{project_id}/locations/\\{location}/terraformVersions/\\{terraform_version}'
        class GetTerraformVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the ListTerraformVersions method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the TerraformVersions are listed. The
        #     parent value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}'.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. When requesting a page of terraform versions, 'page_size'
        #     specifies number of terraform versions to return. If unspecified, at most
        #     500 will be returned. The maximum value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Token returned by previous call to 'ListTerraformVersions' which
        #     specifies the position in the list from where to continue listing the
        #     terraform versions.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Lists the TerraformVersions that match the filter expression. A
        #     filter expression filters the resources listed in the response. The
        #     expression must be of the form '\\{field} \\{operator} \\{value}' where
        #     operators: '<', '>',
        #     '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
        #     operator which is roughly synonymous with equality). \\{field} can refer to a
        #     proto or JSON field, or a synthetic field. Field names can be camelCase or
        #     snake_case.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to use to sort the list.
        class ListTerraformVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for the `ListTerraformVersions` method.
        # @!attribute [rw] terraform_versions
        #   @return [::Array<::Google::Cloud::ConfigService::V1::TerraformVersion>]
        #     List of {::Google::Cloud::ConfigService::V1::TerraformVersion TerraformVersion}s.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to be supplied to the next ListTerraformVersions request via
        #     `page_token` to obtain the next set of results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources, if any.
        class ListTerraformVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A TerraformVersion represents the support state the corresponding
        # Terraform version.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The version name is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/terraformVersions/\\{terraform_version}'.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ConfigService::V1::TerraformVersion::State]
        #     Output only. The state of the version, ACTIVE, DEPRECATED or OBSOLETE.
        # @!attribute [r] support_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the version is supported.
        # @!attribute [r] deprecate_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the version is deprecated.
        # @!attribute [r] obsolete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the version is obsolete.
        class TerraformVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of a TerraformVersion.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The version is actively supported.
            ACTIVE = 1

            # The version is deprecated.
            DEPRECATED = 2

            # The version is obsolete.
            OBSOLETE = 3
          end
        end

        # Terraform info of a ResourceChange.
        # @!attribute [r] address
        #   @return [::String]
        #     Output only. TF resource address that uniquely identifies the resource.
        # @!attribute [r] type
        #   @return [::String]
        #     Output only. TF resource type.
        # @!attribute [r] resource_name
        #   @return [::String]
        #     Output only. TF resource name.
        # @!attribute [r] provider
        #   @return [::String]
        #     Output only. TF resource provider.
        # @!attribute [r] actions
        #   @return [::Array<::String>]
        #     Output only. TF resource actions.
        class ResourceChangeTerraformInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource change represents a change to a resource in the state file.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the resource change.
        #     Format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}/resourceChanges/\\{resource_change}'.
        # @!attribute [r] terraform_info
        #   @return [::Google::Cloud::ConfigService::V1::ResourceChangeTerraformInfo]
        #     Output only. Terraform info of the resource change.
        # @!attribute [r] intent
        #   @return [::Google::Cloud::ConfigService::V1::ResourceChange::Intent]
        #     Output only. The intent of the resource change.
        # @!attribute [r] property_changes
        #   @return [::Array<::Google::Cloud::ConfigService::V1::PropertyChange>]
        #     Output only. The property changes of the resource change.
        class ResourceChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible intent of the resource change.
          module Intent
            # The default value.
            INTENT_UNSPECIFIED = 0

            # The resource will be created.
            CREATE = 1

            # The resource will be updated.
            UPDATE = 2

            # The resource will be deleted.
            DELETE = 3

            # The resource will be recreated.
            RECREATE = 4

            # The resource will be untouched.
            UNCHANGED = 5
          end
        end

        # A property change represents a change to a property in the state file.
        # @!attribute [r] path
        #   @return [::String]
        #     Output only. The path of the property change.
        # @!attribute [r] before_sensitive_paths
        #   @return [::Array<::String>]
        #     Output only. The paths of sensitive fields in `before`. Paths are relative
        #     to `path`.
        # @!attribute [r] before
        #   @return [::Google::Protobuf::Value]
        #     Output only. Representations of the object value before the actions.
        # @!attribute [r] after_sensitive_paths
        #   @return [::Array<::String>]
        #     Output only. The paths of sensitive fields in `after`. Paths are relative
        #     to `path`.
        # @!attribute [r] after
        #   @return [::Google::Protobuf::Value]
        #     Output only. Representations of the object value after the actions.
        class PropertyChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the ListResourceChanges method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the ResourceChanges are listed. The
        #     parent value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. When requesting a page of resource changes, 'page_size' specifies
        #     number of resource changes to return. If unspecified, at most 500 will be
        #     returned. The maximum value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Token returned by previous call to 'ListResourceChanges' which
        #     specifies the position in the list from where to continue listing the
        #     resource changes.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Lists the resource changes that match the filter expression. A
        #     filter expression filters the resource changes listed in the response. The
        #     expression must be of the form '\\{field} \\{operator} \\{value}' where
        #     operators: '<', '>',
        #     '<=',
        #     '>=',
        #     '!=', '=', ':' are supported (colon ':' represents a HAS operator which is
        #     roughly synonymous with equality). \\{field} can refer to a proto or JSON
        #     field, or a synthetic field. Field names can be camelCase or snake_case.
        #
        #     Examples:
        #     - Filter by name:
        #       name =
        #       "projects/foo/locations/us-central1/previews/dep/resourceChanges/baz
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to use to sort the list.
        class ListResourceChangesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to a 'ListResourceChanges' call. Contains a list of
        # ResourceChanges.
        # @!attribute [rw] resource_changes
        #   @return [::Array<::Google::Cloud::ConfigService::V1::ResourceChange>]
        #     List of ResourceChanges.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to request the next page of resources from the
        #     'ListResourceChanges' method. The value of an empty string means that
        #      there are no more resources to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources, if any.
        class ListResourceChangesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the GetResourceChange method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource change to retrieve.
        #     Format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}/resourceChanges/\\{resource_change}'.
        class GetResourceChangeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Terraform info of a ResourceChange.
        # @!attribute [r] address
        #   @return [::String]
        #     Output only. The address of the drifted resource.
        # @!attribute [r] type
        #   @return [::String]
        #     Output only. The type of the drifted resource.
        # @!attribute [r] resource_name
        #   @return [::String]
        #     Output only. TF resource name.
        # @!attribute [r] provider
        #   @return [::String]
        #     Output only. The provider of the drifted resource.
        class ResourceDriftTerraformInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource drift represents a drift to a resource in the state file.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the resource drift.
        #     Format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}/resourceDrifts/\\{resource_drift}'.
        # @!attribute [r] terraform_info
        #   @return [::Google::Cloud::ConfigService::V1::ResourceDriftTerraformInfo]
        #     Output only. Terraform info of the resource drift.
        # @!attribute [r] property_drifts
        #   @return [::Array<::Google::Cloud::ConfigService::V1::PropertyDrift>]
        #     Output only. The property drifts of the resource drift.
        class ResourceDrift
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A property drift represents a drift to a property in the state file.
        # @!attribute [r] path
        #   @return [::String]
        #     Output only. The path of the property drift.
        # @!attribute [r] before_sensitive_paths
        #   @return [::Array<::String>]
        #     Output only. The paths of sensitive fields in `before`. Paths are relative
        #     to `path`.
        # @!attribute [r] before
        #   @return [::Google::Protobuf::Value]
        #     Output only. Representations of the object value before the actions.
        # @!attribute [r] after_sensitive_paths
        #   @return [::Array<::String>]
        #     Output only. The paths of sensitive fields in `after`. Paths are relative
        #     to `path`.
        # @!attribute [r] after
        #   @return [::Google::Protobuf::Value]
        #     Output only. Representations of the object value after the actions.
        class PropertyDrift
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the ListResourceDrifts method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent in whose context the ResourceDrifts are listed. The
        #     parent value is in the format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. When requesting a page of resource drifts, 'page_size' specifies
        #     number of resource drifts to return. If unspecified, at most 500 will be
        #     returned. The maximum value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Token returned by previous call to 'ListResourceDrifts' which
        #     specifies the position in the list from where to continue listing the
        #     resource drifts.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Lists the resource drifts that match the filter expression. A
        #     filter expression filters the resource drifts listed in the response. The
        #     expression must be of the form '\\{field} \\{operator} \\{value}' where
        #     operators: '<', '>',
        #     '<=',
        #     '>=',
        #     '!=', '=', ':' are supported (colon ':' represents a HAS operator which is
        #     roughly synonymous with equality). \\{field} can refer to a proto or JSON
        #     field, or a synthetic field. Field names can be camelCase or snake_case.
        #
        #     Examples:
        #     - Filter by name:
        #       name =
        #       "projects/foo/locations/us-central1/previews/dep/resourceDrifts/baz
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to use to sort the list.
        class ListResourceDriftsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to a 'ListResourceDrifts' call. Contains a list of ResourceDrifts.
        # @!attribute [rw] resource_drifts
        #   @return [::Array<::Google::Cloud::ConfigService::V1::ResourceDrift>]
        #     List of ResourceDrifts.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to request the next page of resources from the
        #     'ListResourceDrifts' method. The value of an empty string means that
        #     there are no more resources to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources, if any.
        class ListResourceDriftsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the GetResourceDrift method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource drift to retrieve.
        #     Format:
        #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}/resourceDrifts/\\{resource_drift}'.
        class GetResourceDriftRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ProviderConfig contains the provider configurations.
        # @!attribute [rw] source_type
        #   @return [::Google::Cloud::ConfigService::V1::ProviderConfig::ProviderSource]
        #     Optional. ProviderSource specifies the source type of the provider.
        class ProviderConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # ProviderSource represents the source type of the provider.
          module ProviderSource
            # Unspecified source type, default to public sources.
            PROVIDER_SOURCE_UNSPECIFIED = 0

            # Service maintained provider source type.
            SERVICE_MAINTAINED = 1
          end
        end

        # The request message for the GetAutoMigrationConfig method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the AutoMigrationConfig.
        #     Format:
        #     'projects/\\{project_id}/locations/\\{location}/AutoMigrationConfig'.
        class GetAutoMigrationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AutoMigrationConfig contains the automigration configuration for a project.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the AutoMigrationConfig.
        #     Format:
        #     'projects/\\{project_id}/locations/\\{location}/AutoMigrationConfig'.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the AutoMigrationConfig was last updated.
        # @!attribute [rw] auto_migration_enabled
        #   @return [::Boolean]
        #     Optional. Whether the auto migration is enabled for the project.
        class AutoMigrationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the UpdateAutoMigrationConfig method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The update mask applies to the resource. See
        #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}.
        # @!attribute [rw] auto_migration_config
        #   @return [::Google::Cloud::ConfigService::V1::AutoMigrationConfig]
        #     Required. The AutoMigrationConfig to update.
        class UpdateAutoMigrationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Enum values to control quota checks for resources in terraform
        # configuration files.
        module QuotaValidation
          # The default value.
          # QuotaValidation on terraform configuration files will be disabled in
          # this case.
          QUOTA_VALIDATION_UNSPECIFIED = 0

          # Enable computing quotas for resources in terraform configuration files to
          # get visibility on resources with insufficient quotas.
          ENABLED = 1

          # Enforce quota checks so deployment fails if there isn't sufficient quotas
          # available to deploy resources in terraform configuration files.
          ENFORCED = 2
        end
      end
    end
  end
end
