# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/config/v1/config_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module ConfigService
      module V1
        module Config
          ##
          # Client for the Config service.
          #
          # Infrastructure Manager is a managed service that automates the deployment and
          # management of Google Cloud infrastructure resources.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "config.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :config_stub

            ##
            # Configure the Config Client class.
            #
            # See {::Google::Cloud::ConfigService::V1::Config::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Config clients
            #   ::Google::Cloud::ConfigService::V1::Config::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "ConfigService", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Config Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::ConfigService::V1::Config::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @config_stub.universe_domain
            end

            ##
            # Create a new Config client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Config client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/config/v1/config_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @config_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::ConfigService::V1::Config::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @config_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config_stub.endpoint
                config.universe_domain = @config_stub.universe_domain
                config.logger = @config_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config_stub.endpoint
                config.universe_domain = @config_stub.universe_domain
                config.logger = @config_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::ConfigService::V1::Config::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @config_stub.logger
            end

            # Service calls

            ##
            # Lists {::Google::Cloud::ConfigService::V1::Deployment Deployment}s in a given project
            # and location.
            #
            # @overload list_deployments(request, options = nil)
            #   Pass arguments to `list_deployments` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ListDeploymentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ListDeploymentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_deployments(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_deployments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the Deployments are listed. The
            #     parent value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}'.
            #   @param page_size [::Integer]
            #     When requesting a page of resources, 'page_size' specifies number of
            #     resources to return. If unspecified, at most 500 will be returned. The
            #     maximum value is 1000.
            #   @param page_token [::String]
            #     Token returned by previous call to 'ListDeployments' which specifies the
            #     position in the list from where to continue listing the resources.
            #   @param filter [::String]
            #     Lists the Deployments that match the filter expression. A filter
            #     expression filters the resources listed in the response. The expression
            #     must be of the form '\\{field} \\{operator} \\{value}' where operators: '<', '>',
            #     '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
            #     operator which is roughly synonymous with equality). \\{field} can refer to a
            #     proto or JSON field, or a synthetic field. Field names can be camelCase or
            #     snake_case.
            #
            #     Examples:
            #     - Filter by name:
            #       name = "projects/foo/locations/us-central1/deployments/bar
            #
            #     - Filter by labels:
            #       - Resources that have a key called 'foo'
            #         labels.foo:*
            #       - Resources that have a key called 'foo' whose value is 'bar'
            #         labels.foo = bar
            #
            #     - Filter by state:
            #       - Deployments in CREATING state.
            #         state=CREATING
            #   @param order_by [::String]
            #     Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::Deployment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::Deployment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ListDeploymentsRequest.new
            #
            #   # Call the list_deployments method.
            #   result = client.list_deployments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigService::V1::Deployment.
            #     p item
            #   end
            #
            def list_deployments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ListDeploymentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_deployments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_deployments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_deployments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :list_deployments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_stub, :list_deployments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details about a {::Google::Cloud::ConfigService::V1::Deployment Deployment}.
            #
            # @overload get_deployment(request, options = nil)
            #   Pass arguments to `get_deployment` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::GetDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::GetDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_deployment(name: nil)
            #   Pass arguments to `get_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment. Format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::Deployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::Deployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::GetDeploymentRequest.new
            #
            #   # Call the get_deployment method.
            #   result = client.get_deployment request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::Deployment.
            #   p result
            #
            def get_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::GetDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :get_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a {::Google::Cloud::ConfigService::V1::Deployment Deployment}.
            #
            # @overload create_deployment(request, options = nil)
            #   Pass arguments to `create_deployment` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::CreateDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::CreateDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_deployment(parent: nil, deployment_id: nil, deployment: nil, request_id: nil)
            #   Pass arguments to `create_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the Deployment is created. The parent
            #     value is in the format: 'projects/\\{project_id}/locations/\\{location}'.
            #   @param deployment_id [::String]
            #     Required. The Deployment ID.
            #   @param deployment [::Google::Cloud::ConfigService::V1::Deployment, ::Hash]
            #     Required. {::Google::Cloud::ConfigService::V1::Deployment Deployment} resource to be
            #     created.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::CreateDeploymentRequest.new
            #
            #   # Call the create_deployment method.
            #   result = client.create_deployment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::CreateDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :create_deployment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a {::Google::Cloud::ConfigService::V1::Deployment Deployment}.
            #
            # @overload update_deployment(request, options = nil)
            #   Pass arguments to `update_deployment` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::UpdateDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::UpdateDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_deployment(update_mask: nil, deployment: nil, request_id: nil)
            #   Pass arguments to `update_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask used to specify the fields to be overwritten in the
            #     Deployment resource by the update.
            #
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param deployment [::Google::Cloud::ConfigService::V1::Deployment, ::Hash]
            #     Required. {::Google::Cloud::ConfigService::V1::Deployment Deployment} to update.
            #
            #     The deployment's `name` field is used to identify the resource to be
            #     updated. Format:
            #     `projects/{project}/locations/{location}/deployments/{deployment}`
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::UpdateDeploymentRequest.new
            #
            #   # Call the update_deployment method.
            #   result = client.update_deployment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::UpdateDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.deployment&.name
                header_params["deployment.name"] = request.deployment.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :update_deployment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a {::Google::Cloud::ConfigService::V1::Deployment Deployment}.
            #
            # @overload delete_deployment(request, options = nil)
            #   Pass arguments to `delete_deployment` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_deployment(name: nil, request_id: nil, force: nil, delete_policy: nil)
            #   Pass arguments to `delete_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Deployment in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param force [::Boolean]
            #     Optional. If set to true, any revisions for this deployment will also be
            #     deleted. (Otherwise, the request will only work if the deployment has no
            #     revisions.)
            #   @param delete_policy [::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest::DeletePolicy]
            #     Optional. Policy on how resources actuated by the deployment should be
            #     deleted. If unspecified, the default behavior is to delete the underlying
            #     resources.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::DeleteDeploymentRequest.new
            #
            #   # Call the delete_deployment method.
            #   result = client.delete_deployment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::DeleteDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :delete_deployment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::ConfigService::V1::Revision Revision}s of a deployment.
            #
            # @overload list_revisions(request, options = nil)
            #   Pass arguments to `list_revisions` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ListRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ListRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_revisions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the Revisions are listed. The parent
            #     value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #   @param page_size [::Integer]
            #     When requesting a page of resources, `page_size` specifies number of
            #     resources to return. If unspecified, at most 500 will be returned. The
            #     maximum value is 1000.
            #   @param page_token [::String]
            #     Token returned by previous call to 'ListRevisions' which specifies the
            #     position in the list from where to continue listing the resources.
            #   @param filter [::String]
            #     Lists the Revisions that match the filter expression. A filter
            #     expression filters the resources listed in the response. The expression
            #     must be of the form '\\{field} \\{operator} \\{value}' where operators: '<', '>',
            #     '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
            #     operator which is roughly synonymous with equality). \\{field} can refer to a
            #     proto or JSON field, or a synthetic field. Field names can be camelCase or
            #     snake_case.
            #
            #     Examples:
            #     - Filter by name:
            #       name = "projects/foo/locations/us-central1/deployments/dep/revisions/bar
            #
            #     - Filter by labels:
            #       - Resources that have a key called 'foo'
            #         labels.foo:*
            #       - Resources that have a key called 'foo' whose value is 'bar'
            #         labels.foo = bar
            #
            #     - Filter by state:
            #       - Revisions in CREATING state.
            #         state=CREATING
            #   @param order_by [::String]
            #     Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::Revision>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::Revision>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ListRevisionsRequest.new
            #
            #   # Call the list_revisions method.
            #   result = client.list_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigService::V1::Revision.
            #     p item
            #   end
            #
            def list_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ListRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :list_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_stub, :list_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details about a {::Google::Cloud::ConfigService::V1::Revision Revision}.
            #
            # @overload get_revision(request, options = nil)
            #   Pass arguments to `get_revision` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::GetRevisionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::GetRevisionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_revision(name: nil)
            #   Pass arguments to `get_revision` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Revision in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}/revisions/\\{revision}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::Revision]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::Revision]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::GetRevisionRequest.new
            #
            #   # Call the get_revision method.
            #   result = client.get_revision request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::Revision.
            #   p result
            #
            def get_revision request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::GetRevisionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_revision.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_revision.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_revision.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :get_revision, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details about a {::Google::Cloud::ConfigService::V1::Resource Resource} deployed
            # by Infra Manager.
            #
            # @overload get_resource(request, options = nil)
            #   Pass arguments to `get_resource` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::GetResourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::GetResourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_resource(name: nil)
            #   Pass arguments to `get_resource` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Resource in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}/revisions/\\{revision}/resource/\\{resource}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::Resource]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::Resource]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::GetResourceRequest.new
            #
            #   # Call the get_resource method.
            #   result = client.get_resource request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::Resource.
            #   p result
            #
            def get_resource request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::GetResourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_resource.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_resource.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_resource.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :get_resource, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::ConfigService::V1::Resource Resources} in a given revision.
            #
            # @overload list_resources(request, options = nil)
            #   Pass arguments to `list_resources` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ListResourcesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ListResourcesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_resources(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_resources` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the Resources are listed. The parent
            #     value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}/revisions/\\{revision}'.
            #   @param page_size [::Integer]
            #     When requesting a page of resources, 'page_size' specifies number of
            #     resources to return. If unspecified, at most 500 will be returned. The
            #     maximum value is 1000.
            #   @param page_token [::String]
            #     Token returned by previous call to 'ListResources' which specifies the
            #     position in the list from where to continue listing the resources.
            #   @param filter [::String]
            #     Lists the Resources that match the filter expression. A filter
            #     expression filters the resources listed in the response. The expression
            #     must be of the form '\\{field} \\{operator} \\{value}' where operators: '<', '>',
            #     '<=',
            #     '>=',
            #     '!=', '=', ':' are supported (colon ':' represents a HAS operator which is
            #     roughly synonymous with equality). \\{field} can refer to a proto or JSON
            #     field, or a synthetic field. Field names can be camelCase or snake_case.
            #
            #     Examples:
            #     - Filter by name:
            #       name =
            #       "projects/foo/locations/us-central1/deployments/dep/revisions/bar/resources/baz
            #   @param order_by [::String]
            #     Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::Resource>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::Resource>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ListResourcesRequest.new
            #
            #   # Call the list_resources method.
            #   result = client.list_resources request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigService::V1::Resource.
            #     p item
            #   end
            #
            def list_resources request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ListResourcesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_resources.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_resources.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_resources.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :list_resources, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_stub, :list_resources, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Exports Terraform state file from a given deployment.
            #
            # @overload export_deployment_statefile(request, options = nil)
            #   Pass arguments to `export_deployment_statefile` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_deployment_statefile(parent: nil, draft: nil)
            #   Pass arguments to `export_deployment_statefile` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the statefile is listed. The parent
            #     value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #   @param draft [::Boolean]
            #     Optional. If this flag is set to true, the exported deployment state file
            #     will be the draft state. This will enable the draft file to be validated
            #     before copying it over to the working state on unlock.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::Statefile]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::Statefile]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest.new
            #
            #   # Call the export_deployment_statefile method.
            #   result = client.export_deployment_statefile request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::Statefile.
            #   p result
            #
            def export_deployment_statefile request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ExportDeploymentStatefileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_deployment_statefile.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_deployment_statefile.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_deployment_statefile.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :export_deployment_statefile, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Exports Terraform state file from a given revision.
            #
            # @overload export_revision_statefile(request, options = nil)
            #   Pass arguments to `export_revision_statefile` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_revision_statefile(parent: nil)
            #   Pass arguments to `export_revision_statefile` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the statefile is listed. The parent
            #     value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}/revisions/\\{revision}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::Statefile]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::Statefile]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest.new
            #
            #   # Call the export_revision_statefile method.
            #   result = client.export_revision_statefile request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::Statefile.
            #   p result
            #
            def export_revision_statefile request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ExportRevisionStatefileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_revision_statefile.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_revision_statefile.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_revision_statefile.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :export_revision_statefile, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports Terraform state file in a given deployment. The state file does not
            # take effect until the Deployment has been unlocked.
            #
            # @overload import_statefile(request, options = nil)
            #   Pass arguments to `import_statefile` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ImportStatefileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ImportStatefileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_statefile(parent: nil, lock_id: nil, skip_draft: nil)
            #   Pass arguments to `import_statefile` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the statefile is listed. The parent
            #     value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #   @param lock_id [::Integer]
            #     Required. Lock ID of the lock file to verify that the user who is importing
            #     the state file previously locked the Deployment.
            #   @param skip_draft [::Boolean]
            #     Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::Statefile]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::Statefile]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ImportStatefileRequest.new
            #
            #   # Call the import_statefile method.
            #   result = client.import_statefile request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::Statefile.
            #   p result
            #
            def import_statefile request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ImportStatefileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_statefile.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_statefile.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_statefile.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :import_statefile, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes Terraform state file in a given deployment.
            #
            # @overload delete_statefile(request, options = nil)
            #   Pass arguments to `delete_statefile` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::DeleteStatefileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::DeleteStatefileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_statefile(name: nil, lock_id: nil)
            #   Pass arguments to `delete_statefile` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #   @param lock_id [::Integer]
            #     Required. Lock ID of the lock file to verify that the user who is deleting
            #     the state file previously locked the Deployment.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::DeleteStatefileRequest.new
            #
            #   # Call the delete_statefile method.
            #   result = client.delete_statefile request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_statefile request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::DeleteStatefileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_statefile.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_statefile.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_statefile.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :delete_statefile, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Locks a deployment.
            #
            # @overload lock_deployment(request, options = nil)
            #   Pass arguments to `lock_deployment` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::LockDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::LockDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload lock_deployment(name: nil)
            #   Pass arguments to `lock_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::LockDeploymentRequest.new
            #
            #   # Call the lock_deployment method.
            #   result = client.lock_deployment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def lock_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::LockDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.lock_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.lock_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.lock_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :lock_deployment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Unlocks a locked deployment.
            #
            # @overload unlock_deployment(request, options = nil)
            #   Pass arguments to `unlock_deployment` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::UnlockDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::UnlockDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload unlock_deployment(name: nil, lock_id: nil)
            #   Pass arguments to `unlock_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #   @param lock_id [::Integer]
            #     Required. Lock ID of the lock file to be unlocked.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::UnlockDeploymentRequest.new
            #
            #   # Call the unlock_deployment method.
            #   result = client.unlock_deployment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def unlock_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::UnlockDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.unlock_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.unlock_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.unlock_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :unlock_deployment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Exports the lock info on a locked deployment.
            #
            # @overload export_lock_info(request, options = nil)
            #   Pass arguments to `export_lock_info` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ExportLockInfoRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ExportLockInfoRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_lock_info(name: nil)
            #   Pass arguments to `export_lock_info` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the deployment in the format:
            #     'projects/\\{project_id}/locations/\\{location}/deployments/\\{deployment}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::LockInfo]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::LockInfo]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ExportLockInfoRequest.new
            #
            #   # Call the export_lock_info method.
            #   result = client.export_lock_info request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::LockInfo.
            #   p result
            #
            def export_lock_info request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ExportLockInfoRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_lock_info.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_lock_info.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_lock_info.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :export_lock_info, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a {::Google::Cloud::ConfigService::V1::Preview Preview}.
            #
            # @overload create_preview(request, options = nil)
            #   Pass arguments to `create_preview` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::CreatePreviewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::CreatePreviewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_preview(parent: nil, preview_id: nil, preview: nil, request_id: nil)
            #   Pass arguments to `create_preview` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the Preview is created. The parent
            #     value is in the format: 'projects/\\{project_id}/locations/\\{location}'.
            #   @param preview_id [::String]
            #     Optional. The preview ID.
            #   @param preview [::Google::Cloud::ConfigService::V1::Preview, ::Hash]
            #     Required. {::Google::Cloud::ConfigService::V1::Preview Preview} resource to be created.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::CreatePreviewRequest.new
            #
            #   # Call the create_preview method.
            #   result = client.create_preview request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_preview request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::CreatePreviewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_preview.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_preview.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_preview.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :create_preview, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details about a {::Google::Cloud::ConfigService::V1::Preview Preview}.
            #
            # @overload get_preview(request, options = nil)
            #   Pass arguments to `get_preview` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::GetPreviewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::GetPreviewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_preview(name: nil)
            #   Pass arguments to `get_preview` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the preview. Format:
            #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::Preview]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::Preview]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::GetPreviewRequest.new
            #
            #   # Call the get_preview method.
            #   result = client.get_preview request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::Preview.
            #   p result
            #
            def get_preview request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::GetPreviewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_preview.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_preview.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_preview.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :get_preview, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::ConfigService::V1::Preview Preview}s in a given project and
            # location.
            #
            # @overload list_previews(request, options = nil)
            #   Pass arguments to `list_previews` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ListPreviewsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ListPreviewsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_previews(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_previews` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the Previews are listed. The parent
            #     value is in the format: 'projects/\\{project_id}/locations/\\{location}'.
            #   @param page_size [::Integer]
            #     Optional. When requesting a page of resources, 'page_size' specifies number
            #     of resources to return. If unspecified, at most 500 will be returned. The
            #     maximum value is 1000.
            #   @param page_token [::String]
            #     Optional. Token returned by previous call to 'ListDeployments' which
            #     specifies the position in the list from where to continue listing the
            #     resources.
            #   @param filter [::String]
            #     Optional. Lists the Deployments that match the filter expression. A filter
            #     expression filters the resources listed in the response. The expression
            #     must be of the form '\\{field} \\{operator} \\{value}' where operators: '<', '>',
            #     '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
            #     operator which is roughly synonymous with equality). \\{field} can refer to a
            #     proto or JSON field, or a synthetic field. Field names can be camelCase or
            #     snake_case.
            #
            #     Examples:
            #     - Filter by name:
            #       name = "projects/foo/locations/us-central1/deployments/bar
            #
            #     - Filter by labels:
            #       - Resources that have a key called 'foo'
            #         labels.foo:*
            #       - Resources that have a key called 'foo' whose value is 'bar'
            #         labels.foo = bar
            #
            #     - Filter by state:
            #       - Deployments in CREATING state.
            #         state=CREATING
            #   @param order_by [::String]
            #     Optional. Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::Preview>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::Preview>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ListPreviewsRequest.new
            #
            #   # Call the list_previews method.
            #   result = client.list_previews request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigService::V1::Preview.
            #     p item
            #   end
            #
            def list_previews request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ListPreviewsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_previews.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_previews.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_previews.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :list_previews, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_stub, :list_previews, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a {::Google::Cloud::ConfigService::V1::Preview Preview}.
            #
            # @overload delete_preview(request, options = nil)
            #   Pass arguments to `delete_preview` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::DeletePreviewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::DeletePreviewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_preview(name: nil, request_id: nil)
            #   Pass arguments to `delete_preview` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Preview in the format:
            #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::DeletePreviewRequest.new
            #
            #   # Call the delete_preview method.
            #   result = client.delete_preview request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_preview request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::DeletePreviewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_preview.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_preview.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_preview.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :delete_preview, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Export {::Google::Cloud::ConfigService::V1::Preview Preview} results.
            #
            # @overload export_preview_result(request, options = nil)
            #   Pass arguments to `export_preview_result` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ExportPreviewResultRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ExportPreviewResultRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_preview_result(parent: nil)
            #   Pass arguments to `export_preview_result` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The preview whose results should be exported. The preview value
            #     is in the format:
            #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::ExportPreviewResultResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::ExportPreviewResultResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ExportPreviewResultRequest.new
            #
            #   # Call the export_preview_result method.
            #   result = client.export_preview_result request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::ExportPreviewResultResponse.
            #   p result
            #
            def export_preview_result request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ExportPreviewResultRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_preview_result.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_preview_result.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_preview_result.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :export_preview_result, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::ConfigService::V1::TerraformVersion TerraformVersion}s in a
            # given project and location.
            #
            # @overload list_terraform_versions(request, options = nil)
            #   Pass arguments to `list_terraform_versions` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_terraform_versions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_terraform_versions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the TerraformVersions are listed. The
            #     parent value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}'.
            #   @param page_size [::Integer]
            #     Optional. When requesting a page of terraform versions, 'page_size'
            #     specifies number of terraform versions to return. If unspecified, at most
            #     500 will be returned. The maximum value is 1000.
            #   @param page_token [::String]
            #     Optional. Token returned by previous call to 'ListTerraformVersions' which
            #     specifies the position in the list from where to continue listing the
            #     terraform versions.
            #   @param filter [::String]
            #     Optional. Lists the TerraformVersions that match the filter expression. A
            #     filter expression filters the resources listed in the response. The
            #     expression must be of the form '\\{field} \\{operator} \\{value}' where
            #     operators: '<', '>',
            #     '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
            #     operator which is roughly synonymous with equality). \\{field} can refer to a
            #     proto or JSON field, or a synthetic field. Field names can be camelCase or
            #     snake_case.
            #   @param order_by [::String]
            #     Optional. Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::TerraformVersion>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::TerraformVersion>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest.new
            #
            #   # Call the list_terraform_versions method.
            #   result = client.list_terraform_versions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigService::V1::TerraformVersion.
            #     p item
            #   end
            #
            def list_terraform_versions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ListTerraformVersionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_terraform_versions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_terraform_versions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_terraform_versions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :list_terraform_versions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_stub, :list_terraform_versions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details about a
            # {::Google::Cloud::ConfigService::V1::TerraformVersion TerraformVersion}.
            #
            # @overload get_terraform_version(request, options = nil)
            #   Pass arguments to `get_terraform_version` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::GetTerraformVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::GetTerraformVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_terraform_version(name: nil)
            #   Pass arguments to `get_terraform_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the TerraformVersion. Format:
            #     'projects/\\{project_id}/locations/\\{location}/terraformVersions/\\{terraform_version}'
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::TerraformVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::TerraformVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::GetTerraformVersionRequest.new
            #
            #   # Call the get_terraform_version method.
            #   result = client.get_terraform_version request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::TerraformVersion.
            #   p result
            #
            def get_terraform_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::GetTerraformVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_terraform_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_terraform_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_terraform_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :get_terraform_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ResourceChanges for a given preview.
            #
            # @overload list_resource_changes(request, options = nil)
            #   Pass arguments to `list_resource_changes` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ListResourceChangesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ListResourceChangesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_resource_changes(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_resource_changes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the ResourceChanges are listed. The
            #     parent value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
            #   @param page_size [::Integer]
            #     Optional. When requesting a page of resource changes, 'page_size' specifies
            #     number of resource changes to return. If unspecified, at most 500 will be
            #     returned. The maximum value is 1000.
            #   @param page_token [::String]
            #     Optional. Token returned by previous call to 'ListResourceChanges' which
            #     specifies the position in the list from where to continue listing the
            #     resource changes.
            #   @param filter [::String]
            #     Optional. Lists the resource changes that match the filter expression. A
            #     filter expression filters the resource changes listed in the response. The
            #     expression must be of the form '\\{field} \\{operator} \\{value}' where
            #     operators: '<', '>',
            #     '<=',
            #     '>=',
            #     '!=', '=', ':' are supported (colon ':' represents a HAS operator which is
            #     roughly synonymous with equality). \\{field} can refer to a proto or JSON
            #     field, or a synthetic field. Field names can be camelCase or snake_case.
            #
            #     Examples:
            #     - Filter by name:
            #       name =
            #       "projects/foo/locations/us-central1/previews/dep/resourceChanges/baz
            #   @param order_by [::String]
            #     Optional. Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::ResourceChange>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::ResourceChange>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ListResourceChangesRequest.new
            #
            #   # Call the list_resource_changes method.
            #   result = client.list_resource_changes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigService::V1::ResourceChange.
            #     p item
            #   end
            #
            def list_resource_changes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ListResourceChangesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_resource_changes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_resource_changes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_resource_changes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :list_resource_changes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_stub, :list_resource_changes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a ResourceChange for a given preview.
            #
            # @overload get_resource_change(request, options = nil)
            #   Pass arguments to `get_resource_change` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::GetResourceChangeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::GetResourceChangeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_resource_change(name: nil)
            #   Pass arguments to `get_resource_change` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the resource change to retrieve.
            #     Format:
            #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}/resourceChanges/\\{resource_change}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::ResourceChange]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::ResourceChange]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::GetResourceChangeRequest.new
            #
            #   # Call the get_resource_change method.
            #   result = client.get_resource_change request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::ResourceChange.
            #   p result
            #
            def get_resource_change request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::GetResourceChangeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_resource_change.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_resource_change.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_resource_change.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :get_resource_change, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List ResourceDrifts for a given preview.
            #
            # @overload list_resource_drifts(request, options = nil)
            #   Pass arguments to `list_resource_drifts` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::ListResourceDriftsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::ListResourceDriftsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_resource_drifts(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_resource_drifts` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent in whose context the ResourceDrifts are listed. The
            #     parent value is in the format:
            #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}'.
            #   @param page_size [::Integer]
            #     Optional. When requesting a page of resource drifts, 'page_size' specifies
            #     number of resource drifts to return. If unspecified, at most 500 will be
            #     returned. The maximum value is 1000.
            #   @param page_token [::String]
            #     Optional. Token returned by previous call to 'ListResourceDrifts' which
            #     specifies the position in the list from where to continue listing the
            #     resource drifts.
            #   @param filter [::String]
            #     Optional. Lists the resource drifts that match the filter expression. A
            #     filter expression filters the resource drifts listed in the response. The
            #     expression must be of the form '\\{field} \\{operator} \\{value}' where
            #     operators: '<', '>',
            #     '<=',
            #     '>=',
            #     '!=', '=', ':' are supported (colon ':' represents a HAS operator which is
            #     roughly synonymous with equality). \\{field} can refer to a proto or JSON
            #     field, or a synthetic field. Field names can be camelCase or snake_case.
            #
            #     Examples:
            #     - Filter by name:
            #       name =
            #       "projects/foo/locations/us-central1/previews/dep/resourceDrifts/baz
            #   @param order_by [::String]
            #     Optional. Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::ResourceDrift>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigService::V1::ResourceDrift>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::ListResourceDriftsRequest.new
            #
            #   # Call the list_resource_drifts method.
            #   result = client.list_resource_drifts request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigService::V1::ResourceDrift.
            #     p item
            #   end
            #
            def list_resource_drifts request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::ListResourceDriftsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_resource_drifts.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_resource_drifts.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_resource_drifts.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :list_resource_drifts, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_stub, :list_resource_drifts, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a ResourceDrift for a given preview.
            #
            # @overload get_resource_drift(request, options = nil)
            #   Pass arguments to `get_resource_drift` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::GetResourceDriftRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::GetResourceDriftRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_resource_drift(name: nil)
            #   Pass arguments to `get_resource_drift` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the resource drift to retrieve.
            #     Format:
            #     'projects/\\{project_id}/locations/\\{location}/previews/\\{preview}/resourceDrifts/\\{resource_drift}'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::ResourceDrift]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::ResourceDrift]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::GetResourceDriftRequest.new
            #
            #   # Call the get_resource_drift method.
            #   result = client.get_resource_drift request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::ResourceDrift.
            #   p result
            #
            def get_resource_drift request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::GetResourceDriftRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_resource_drift.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_resource_drift.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_resource_drift.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :get_resource_drift, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get the AutoMigrationConfig for a given project and location.
            #
            # @overload get_auto_migration_config(request, options = nil)
            #   Pass arguments to `get_auto_migration_config` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_auto_migration_config(name: nil)
            #   Pass arguments to `get_auto_migration_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the AutoMigrationConfig.
            #     Format:
            #     'projects/\\{project_id}/locations/\\{location}/AutoMigrationConfig'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigService::V1::AutoMigrationConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigService::V1::AutoMigrationConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest.new
            #
            #   # Call the get_auto_migration_config method.
            #   result = client.get_auto_migration_config request
            #
            #   # The returned object is of type Google::Cloud::ConfigService::V1::AutoMigrationConfig.
            #   p result
            #
            def get_auto_migration_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::GetAutoMigrationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_auto_migration_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_auto_migration_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_auto_migration_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :get_auto_migration_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the AutoMigrationConfig for a given project and location.
            #
            # @overload update_auto_migration_config(request, options = nil)
            #   Pass arguments to `update_auto_migration_config` via a request object, either of type
            #   {::Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_auto_migration_config(update_mask: nil, auto_migration_config: nil)
            #   Pass arguments to `update_auto_migration_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The update mask applies to the resource. See
            #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}.
            #   @param auto_migration_config [::Google::Cloud::ConfigService::V1::AutoMigrationConfig, ::Hash]
            #     Required. The AutoMigrationConfig to update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_service/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigService::V1::Config::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest.new
            #
            #   # Call the update_auto_migration_config method.
            #   result = client.update_auto_migration_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_auto_migration_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigService::V1::UpdateAutoMigrationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_auto_migration_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigService::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.auto_migration_config&.name
                header_params["auto_migration_config.name"] = request.auto_migration_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_auto_migration_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_auto_migration_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_stub.call_rpc :update_auto_migration_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Config API.
            #
            # This class represents the configuration for Config,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::ConfigService::V1::Config::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_deployments to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::ConfigService::V1::Config::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_deployments.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_deployments.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::ConfigService::V1::Config::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "config.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Config API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_deployments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_deployments
                ##
                # RPC-specific configuration for `get_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_deployment
                ##
                # RPC-specific configuration for `create_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_deployment
                ##
                # RPC-specific configuration for `update_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_deployment
                ##
                # RPC-specific configuration for `delete_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_deployment
                ##
                # RPC-specific configuration for `list_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_revisions
                ##
                # RPC-specific configuration for `get_revision`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_revision
                ##
                # RPC-specific configuration for `get_resource`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_resource
                ##
                # RPC-specific configuration for `list_resources`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_resources
                ##
                # RPC-specific configuration for `export_deployment_statefile`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_deployment_statefile
                ##
                # RPC-specific configuration for `export_revision_statefile`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_revision_statefile
                ##
                # RPC-specific configuration for `import_statefile`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_statefile
                ##
                # RPC-specific configuration for `delete_statefile`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_statefile
                ##
                # RPC-specific configuration for `lock_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :lock_deployment
                ##
                # RPC-specific configuration for `unlock_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :unlock_deployment
                ##
                # RPC-specific configuration for `export_lock_info`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_lock_info
                ##
                # RPC-specific configuration for `create_preview`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_preview
                ##
                # RPC-specific configuration for `get_preview`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_preview
                ##
                # RPC-specific configuration for `list_previews`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_previews
                ##
                # RPC-specific configuration for `delete_preview`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_preview
                ##
                # RPC-specific configuration for `export_preview_result`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_preview_result
                ##
                # RPC-specific configuration for `list_terraform_versions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_terraform_versions
                ##
                # RPC-specific configuration for `get_terraform_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_terraform_version
                ##
                # RPC-specific configuration for `list_resource_changes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_resource_changes
                ##
                # RPC-specific configuration for `get_resource_change`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_resource_change
                ##
                # RPC-specific configuration for `list_resource_drifts`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_resource_drifts
                ##
                # RPC-specific configuration for `get_resource_drift`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_resource_drift
                ##
                # RPC-specific configuration for `get_auto_migration_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_auto_migration_config
                ##
                # RPC-specific configuration for `update_auto_migration_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_auto_migration_config

                # @private
                def initialize parent_rpcs = nil
                  list_deployments_config = parent_rpcs.list_deployments if parent_rpcs.respond_to? :list_deployments
                  @list_deployments = ::Gapic::Config::Method.new list_deployments_config
                  get_deployment_config = parent_rpcs.get_deployment if parent_rpcs.respond_to? :get_deployment
                  @get_deployment = ::Gapic::Config::Method.new get_deployment_config
                  create_deployment_config = parent_rpcs.create_deployment if parent_rpcs.respond_to? :create_deployment
                  @create_deployment = ::Gapic::Config::Method.new create_deployment_config
                  update_deployment_config = parent_rpcs.update_deployment if parent_rpcs.respond_to? :update_deployment
                  @update_deployment = ::Gapic::Config::Method.new update_deployment_config
                  delete_deployment_config = parent_rpcs.delete_deployment if parent_rpcs.respond_to? :delete_deployment
                  @delete_deployment = ::Gapic::Config::Method.new delete_deployment_config
                  list_revisions_config = parent_rpcs.list_revisions if parent_rpcs.respond_to? :list_revisions
                  @list_revisions = ::Gapic::Config::Method.new list_revisions_config
                  get_revision_config = parent_rpcs.get_revision if parent_rpcs.respond_to? :get_revision
                  @get_revision = ::Gapic::Config::Method.new get_revision_config
                  get_resource_config = parent_rpcs.get_resource if parent_rpcs.respond_to? :get_resource
                  @get_resource = ::Gapic::Config::Method.new get_resource_config
                  list_resources_config = parent_rpcs.list_resources if parent_rpcs.respond_to? :list_resources
                  @list_resources = ::Gapic::Config::Method.new list_resources_config
                  export_deployment_statefile_config = parent_rpcs.export_deployment_statefile if parent_rpcs.respond_to? :export_deployment_statefile
                  @export_deployment_statefile = ::Gapic::Config::Method.new export_deployment_statefile_config
                  export_revision_statefile_config = parent_rpcs.export_revision_statefile if parent_rpcs.respond_to? :export_revision_statefile
                  @export_revision_statefile = ::Gapic::Config::Method.new export_revision_statefile_config
                  import_statefile_config = parent_rpcs.import_statefile if parent_rpcs.respond_to? :import_statefile
                  @import_statefile = ::Gapic::Config::Method.new import_statefile_config
                  delete_statefile_config = parent_rpcs.delete_statefile if parent_rpcs.respond_to? :delete_statefile
                  @delete_statefile = ::Gapic::Config::Method.new delete_statefile_config
                  lock_deployment_config = parent_rpcs.lock_deployment if parent_rpcs.respond_to? :lock_deployment
                  @lock_deployment = ::Gapic::Config::Method.new lock_deployment_config
                  unlock_deployment_config = parent_rpcs.unlock_deployment if parent_rpcs.respond_to? :unlock_deployment
                  @unlock_deployment = ::Gapic::Config::Method.new unlock_deployment_config
                  export_lock_info_config = parent_rpcs.export_lock_info if parent_rpcs.respond_to? :export_lock_info
                  @export_lock_info = ::Gapic::Config::Method.new export_lock_info_config
                  create_preview_config = parent_rpcs.create_preview if parent_rpcs.respond_to? :create_preview
                  @create_preview = ::Gapic::Config::Method.new create_preview_config
                  get_preview_config = parent_rpcs.get_preview if parent_rpcs.respond_to? :get_preview
                  @get_preview = ::Gapic::Config::Method.new get_preview_config
                  list_previews_config = parent_rpcs.list_previews if parent_rpcs.respond_to? :list_previews
                  @list_previews = ::Gapic::Config::Method.new list_previews_config
                  delete_preview_config = parent_rpcs.delete_preview if parent_rpcs.respond_to? :delete_preview
                  @delete_preview = ::Gapic::Config::Method.new delete_preview_config
                  export_preview_result_config = parent_rpcs.export_preview_result if parent_rpcs.respond_to? :export_preview_result
                  @export_preview_result = ::Gapic::Config::Method.new export_preview_result_config
                  list_terraform_versions_config = parent_rpcs.list_terraform_versions if parent_rpcs.respond_to? :list_terraform_versions
                  @list_terraform_versions = ::Gapic::Config::Method.new list_terraform_versions_config
                  get_terraform_version_config = parent_rpcs.get_terraform_version if parent_rpcs.respond_to? :get_terraform_version
                  @get_terraform_version = ::Gapic::Config::Method.new get_terraform_version_config
                  list_resource_changes_config = parent_rpcs.list_resource_changes if parent_rpcs.respond_to? :list_resource_changes
                  @list_resource_changes = ::Gapic::Config::Method.new list_resource_changes_config
                  get_resource_change_config = parent_rpcs.get_resource_change if parent_rpcs.respond_to? :get_resource_change
                  @get_resource_change = ::Gapic::Config::Method.new get_resource_change_config
                  list_resource_drifts_config = parent_rpcs.list_resource_drifts if parent_rpcs.respond_to? :list_resource_drifts
                  @list_resource_drifts = ::Gapic::Config::Method.new list_resource_drifts_config
                  get_resource_drift_config = parent_rpcs.get_resource_drift if parent_rpcs.respond_to? :get_resource_drift
                  @get_resource_drift = ::Gapic::Config::Method.new get_resource_drift_config
                  get_auto_migration_config_config = parent_rpcs.get_auto_migration_config if parent_rpcs.respond_to? :get_auto_migration_config
                  @get_auto_migration_config = ::Gapic::Config::Method.new get_auto_migration_config_config
                  update_auto_migration_config_config = parent_rpcs.update_auto_migration_config if parent_rpcs.respond_to? :update_auto_migration_config
                  @update_auto_migration_config = ::Gapic::Config::Method.new update_auto_migration_config_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
