# Changelog

### 2.6.0 (2026-01-13)

#### Features

* add support for enabling automigration from deprecated Terraform versions ([#32341](https://github.com/googleapis/google-cloud-ruby/issues/32341)) 
* added error code when failing import values from an external source 

### 2.5.1 (2025-10-27)

#### Documentation

* add warning about loading unvalidated credentials 

### 2.5.0 (2025-10-08)

#### Features

* add ListOperations partial success flag ([#31576](https://github.com/googleapis/google-cloud-ruby/issues/31576)) 
* add ListOperations unreachable resources 

### 2.4.0 (2025-09-11)

#### Features

* update gapic-common dependency for generated libraries to 1.2 which requires google-protobuf v4.26+ ([#31015](https://github.com/googleapis/google-cloud-ruby/issues/31015)) 

### 2.3.0 (2025-09-03)

#### Features

* added support for service maintained provider ([#30934](https://github.com/googleapis/google-cloud-ruby/issues/30934)) 

### 2.2.0 (2025-07-15)

#### Features

* added resource change and drift details for the preview ([#30606](https://github.com/googleapis/google-cloud-ruby/issues/30606)) 

### 2.1.0 (2025-05-12)

#### Features

* Updated core dependencies including gapic-common 
* Updated required Ruby version to 3.1 

### 2.0.1 (2025-04-29)

#### Bug Fixes

* Fixed several issues with validating credential configs 

### 2.0.0 (2025-02-07)

### ⚠ BREAKING CHANGES

* Fixed incorrect pagination on certain REST RPC methods ([#28823](https://github.com/googleapis/google-cloud-ruby/issues/28823))

#### Bug Fixes

* Fixed incorrect pagination on certain REST RPC methods ([#28823](https://github.com/googleapis/google-cloud-ruby/issues/28823)) 

### 1.3.0 (2025-01-28)

#### Features

* Update Ruby version requirement to 3.0 
#### Documentation

* Clarify behavior of protobuf message fields that are part of mutually-exclusive sets 
* Include note about validating externally-provided credentials 

### 1.2.1 (2025-01-08)

#### Bug Fixes

* Set default timeout and retry policies ([#28183](https://github.com/googleapis/google-cloud-ruby/issues/28183)) 

### 1.2.0 (2024-12-12)

#### Features

* Support key-value annotations on Preview ([#28099](https://github.com/googleapis/google-cloud-ruby/issues/28099)) 

### 1.1.0 (2024-12-10)

#### Features

* Provide opt-in debug logging 

### 1.0.2 (2024-08-30)

#### Documentation

* Add field `experimental_features` to message `PythonSettings` ([#27004](https://github.com/googleapis/google-cloud-ruby/issues/27004)) 

### 1.0.1 (2024-08-09)

#### Documentation

* Formatting updates to README.md ([#26625](https://github.com/googleapis/google-cloud-ruby/issues/26625)) 

### 1.0.0 (2024-07-10)

#### Features

* Bump version to 1.0.0 

### 0.6.0 (2024-04-25)

#### Features

* Support for deployment annotations 
* Support for Terraform version set on the Preview 

### 0.5.0 (2024-03-22)

#### Features

* Infrastructure Manager can validate and enforce quota limits, preventing infrastructure that exceeds quota limits from being deployed 
* Infrastructure Manager supports the deployment of infrastructure from Terraform configurations in a private Git repository ([#25404](https://github.com/googleapis/google-cloud-ruby/issues/25404)) 
* Infrastructure manager supports the following versions of Terraform when creating a deployment: Terraform version 1.2.3, 1.3.10, 1.4.7, 1.5.7 
#### Documentation

* Comment updates to `page_size` and `service_account` 

### 0.4.0 (2024-02-26)

#### Features

* Updated minimum Ruby version to 2.7 ([#24867](https://github.com/googleapis/google-cloud-ruby/issues/24867)) 

### 0.3.1 (2024-02-01)

#### Bug Fixes

* Eliminated a harmless but annoying warning in the protobuf class files 

### 0.3.0 (2024-01-15)

#### Features

* Support export_preview_result RPC 
* Support preview operation metadata 
* Support RPCs for managing preview resources ([#24412](https://github.com/googleapis/google-cloud-ruby/issues/24412)) 

### 0.2.1 (2024-01-12)

#### Bug Fixes

* Ensure endpoints are correct for mixin clients ([#24032](https://github.com/googleapis/google-cloud-ruby/issues/24032)) 

### 0.2.0 (2024-01-11)

#### Features

* Support for universe_domain ([#23776](https://github.com/googleapis/google-cloud-ruby/issues/23776)) 

### 0.1.0 (2023-09-21)

#### Features

* Initial generation of google-cloud-config_service-v1 ([#23354](https://github.com/googleapis/google-cloud-ruby/issues/23354)) 

## Release History
