# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/configdelivery/v1/config_delivery_pb"
require "google/cloud/config_delivery/v1/config_delivery"

class ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_resource_bundles
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_resource_bundles_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_resource_bundles, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_resource_bundles_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_resource_bundles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_resource_bundles parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_resource_bundles ::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_resource_bundles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_resource_bundles(::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_resource_bundles_client_stub.call_rpc_count
    end
  end

  def test_get_resource_bundle
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::ResourceBundle.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_bundle_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_resource_bundle, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_resource_bundle_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_resource_bundle({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_resource_bundle name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_resource_bundle ::Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_resource_bundle({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_resource_bundle(::Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_resource_bundle_client_stub.call_rpc_count
    end
  end

  def test_create_resource_bundle
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource_bundle_id = "hello world"
    resource_bundle = {}
    request_id = "hello world"

    create_resource_bundle_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_resource_bundle, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["resource_bundle_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigDelivery::V1::ResourceBundle), request["resource_bundle"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_resource_bundle_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_resource_bundle({ parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_resource_bundle parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_resource_bundle ::Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest.new(parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_resource_bundle({ parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_resource_bundle(::Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest.new(parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_resource_bundle_client_stub.call_rpc_count
    end
  end

  def test_update_resource_bundle
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    resource_bundle = {}
    request_id = "hello world"

    update_resource_bundle_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_resource_bundle, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigDelivery::V1::ResourceBundle), request["resource_bundle"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_resource_bundle_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_resource_bundle({ update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_resource_bundle update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_resource_bundle ::Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest.new(update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_resource_bundle({ update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_resource_bundle(::Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest.new(update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_resource_bundle_client_stub.call_rpc_count
    end
  end

  def test_delete_resource_bundle
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_resource_bundle_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_resource_bundle, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_resource_bundle_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_resource_bundle({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_resource_bundle name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_resource_bundle ::Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_resource_bundle({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_resource_bundle(::Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_resource_bundle_client_stub.call_rpc_count
    end
  end

  def test_list_fleet_packages
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_fleet_packages_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_fleet_packages, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_fleet_packages_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_fleet_packages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_fleet_packages parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_fleet_packages ::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_fleet_packages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_fleet_packages(::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_fleet_packages_client_stub.call_rpc_count
    end
  end

  def test_get_fleet_package
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::FleetPackage.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_fleet_package_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_fleet_package, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_fleet_package_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_fleet_package({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_fleet_package name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_fleet_package ::Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_fleet_package({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_fleet_package(::Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_fleet_package_client_stub.call_rpc_count
    end
  end

  def test_create_fleet_package
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    fleet_package_id = "hello world"
    fleet_package = {}
    request_id = "hello world"

    create_fleet_package_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_fleet_package, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["fleet_package_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigDelivery::V1::FleetPackage), request["fleet_package"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_fleet_package_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_fleet_package({ parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_fleet_package parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_fleet_package ::Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest.new(parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_fleet_package({ parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_fleet_package(::Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest.new(parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_fleet_package_client_stub.call_rpc_count
    end
  end

  def test_update_fleet_package
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    fleet_package = {}
    request_id = "hello world"

    update_fleet_package_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_fleet_package, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigDelivery::V1::FleetPackage), request["fleet_package"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_fleet_package_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_fleet_package({ update_mask: update_mask, fleet_package: fleet_package, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_fleet_package update_mask: update_mask, fleet_package: fleet_package, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_fleet_package ::Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest.new(update_mask: update_mask, fleet_package: fleet_package, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_fleet_package({ update_mask: update_mask, fleet_package: fleet_package, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_fleet_package(::Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest.new(update_mask: update_mask, fleet_package: fleet_package, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_fleet_package_client_stub.call_rpc_count
    end
  end

  def test_delete_fleet_package
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true
    allow_missing = true

    delete_fleet_package_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_fleet_package, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_fleet_package_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_fleet_package({ name: name, request_id: request_id, force: force, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_fleet_package name: name, request_id: request_id, force: force, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_fleet_package ::Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest.new(name: name, request_id: request_id, force: force, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_fleet_package({ name: name, request_id: request_id, force: force, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_fleet_package(::Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest.new(name: name, request_id: request_id, force: force, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_fleet_package_client_stub.call_rpc_count
    end
  end

  def test_list_releases
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::ListReleasesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_releases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_releases, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ListReleasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_releases_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_releases parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_releases ::Google::Cloud::ConfigDelivery::V1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_releases(::Google::Cloud::ConfigDelivery::V1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_releases_client_stub.call_rpc_count
    end
  end

  def test_get_release
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::Release.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_release, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::GetReleaseRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_release_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_release({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_release name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_release ::Google::Cloud::ConfigDelivery::V1::GetReleaseRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_release({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_release(::Google::Cloud::ConfigDelivery::V1::GetReleaseRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_release_client_stub.call_rpc_count
    end
  end

  def test_create_release
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    release_id = "hello world"
    release = {}
    request_id = "hello world"

    create_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_release, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["release_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigDelivery::V1::Release), request["release"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_release_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_release({ parent: parent, release_id: release_id, release: release, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_release parent: parent, release_id: release_id, release: release, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_release ::Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_release({ parent: parent, release_id: release_id, release: release, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_release(::Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_release_client_stub.call_rpc_count
    end
  end

  def test_update_release
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    release = {}
    request_id = "hello world"

    update_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_release, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigDelivery::V1::Release), request["release"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_release_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_release({ update_mask: update_mask, release: release, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_release update_mask: update_mask, release: release, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_release ::Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest.new(update_mask: update_mask, release: release, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_release({ update_mask: update_mask, release: release, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_release(::Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest.new(update_mask: update_mask, release: release, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_release_client_stub.call_rpc_count
    end
  end

  def test_delete_release
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_release, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_release_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_release({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_release name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_release ::Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_release({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_release(::Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_release_client_stub.call_rpc_count
    end
  end

  def test_list_variants
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::ListVariantsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_variants_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_variants, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ListVariantsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_variants_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_variants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_variants parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_variants ::Google::Cloud::ConfigDelivery::V1::ListVariantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_variants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_variants(::Google::Cloud::ConfigDelivery::V1::ListVariantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_variants_client_stub.call_rpc_count
    end
  end

  def test_get_variant
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::Variant.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_variant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_variant, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::GetVariantRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_variant_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_variant({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_variant name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_variant ::Google::Cloud::ConfigDelivery::V1::GetVariantRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_variant({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_variant(::Google::Cloud::ConfigDelivery::V1::GetVariantRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_variant_client_stub.call_rpc_count
    end
  end

  def test_create_variant
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    variant_id = "hello world"
    variant = {}
    request_id = "hello world"

    create_variant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_variant, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::CreateVariantRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["variant_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigDelivery::V1::Variant), request["variant"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_variant_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_variant({ parent: parent, variant_id: variant_id, variant: variant, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_variant parent: parent, variant_id: variant_id, variant: variant, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_variant ::Google::Cloud::ConfigDelivery::V1::CreateVariantRequest.new(parent: parent, variant_id: variant_id, variant: variant, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_variant({ parent: parent, variant_id: variant_id, variant: variant, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_variant(::Google::Cloud::ConfigDelivery::V1::CreateVariantRequest.new(parent: parent, variant_id: variant_id, variant: variant, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_variant_client_stub.call_rpc_count
    end
  end

  def test_update_variant
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    variant = {}
    request_id = "hello world"

    update_variant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_variant, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfigDelivery::V1::Variant), request["variant"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_variant_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_variant({ update_mask: update_mask, variant: variant, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_variant update_mask: update_mask, variant: variant, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_variant ::Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest.new(update_mask: update_mask, variant: variant, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_variant({ update_mask: update_mask, variant: variant, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_variant(::Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest.new(update_mask: update_mask, variant: variant, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_variant_client_stub.call_rpc_count
    end
  end

  def test_delete_variant
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_variant_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_variant, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_variant_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_variant({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_variant name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_variant ::Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_variant({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_variant(::Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_variant_client_stub.call_rpc_count
    end
  end

  def test_list_rollouts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::ListRolloutsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_rollouts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rollouts, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rollouts_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rollouts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rollouts ::Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rollouts(::Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rollouts_client_stub.call_rpc_count
    end
  end

  def test_get_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfigDelivery::V1::Rollout.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rollout, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::GetRolloutRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rollout({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rollout name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rollout ::Google::Cloud::ConfigDelivery::V1::GetRolloutRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rollout({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rollout(::Google::Cloud::ConfigDelivery::V1::GetRolloutRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rollout_client_stub.call_rpc_count
    end
  end

  def test_suspend_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    suspend_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :suspend_rollout, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["reason"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, suspend_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.suspend_rollout({ name: name, reason: reason }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.suspend_rollout name: name, reason: reason do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.suspend_rollout ::Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest.new(name: name, reason: reason) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.suspend_rollout({ name: name, reason: reason }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.suspend_rollout(::Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest.new(name: name, reason: reason), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, suspend_rollout_client_stub.call_rpc_count
    end
  end

  def test_resume_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    resume_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resume_rollout, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["reason"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resume_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resume_rollout({ name: name, reason: reason }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resume_rollout name: name, reason: reason do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resume_rollout ::Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest.new(name: name, reason: reason) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resume_rollout({ name: name, reason: reason }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resume_rollout(::Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest.new(name: name, reason: reason), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resume_rollout_client_stub.call_rpc_count
    end
  end

  def test_abort_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    abort_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :abort_rollout, name
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["reason"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, abort_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.abort_rollout({ name: name, reason: reason }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.abort_rollout name: name, reason: reason do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.abort_rollout ::Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest.new(name: name, reason: reason) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.abort_rollout({ name: name, reason: reason }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.abort_rollout(::Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest.new(name: name, reason: reason), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, abort_rollout_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Operations, client.operations_client
  end
end
