# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/configdelivery/v1/config_delivery_pb"
require "google/cloud/config_delivery/v1/config_delivery/rest"


class ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_resource_bundles
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_resource_bundles_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_list_resource_bundles_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_resource_bundles_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_resource_bundles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_resource_bundles parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_resource_bundles ::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_resource_bundles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_resource_bundles(::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_resource_bundles_client_stub.call_count
      end
    end
  end

  def test_get_resource_bundle
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::ResourceBundle.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_resource_bundle_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_get_resource_bundle_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_resource_bundle_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_resource_bundle({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_resource_bundle name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_resource_bundle ::Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_resource_bundle({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_resource_bundle(::Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_resource_bundle_client_stub.call_count
      end
    end
  end

  def test_create_resource_bundle
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource_bundle_id = "hello world"
    resource_bundle = {}
    request_id = "hello world"

    create_resource_bundle_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_create_resource_bundle_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_resource_bundle_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_resource_bundle({ parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_resource_bundle parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_resource_bundle ::Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest.new(parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_resource_bundle({ parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_resource_bundle(::Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest.new(parent: parent, resource_bundle_id: resource_bundle_id, resource_bundle: resource_bundle, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_resource_bundle_client_stub.call_count
      end
    end
  end

  def test_update_resource_bundle
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    resource_bundle = {}
    request_id = "hello world"

    update_resource_bundle_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_update_resource_bundle_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_resource_bundle_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_resource_bundle({ update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_resource_bundle update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_resource_bundle ::Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest.new(update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_resource_bundle({ update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_resource_bundle(::Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest.new(update_mask: update_mask, resource_bundle: resource_bundle, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_resource_bundle_client_stub.call_count
      end
    end
  end

  def test_delete_resource_bundle
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_resource_bundle_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_delete_resource_bundle_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_resource_bundle_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_resource_bundle({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_resource_bundle name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_resource_bundle ::Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_resource_bundle({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_resource_bundle(::Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_resource_bundle_client_stub.call_count
      end
    end
  end

  def test_list_fleet_packages
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_fleet_packages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_list_fleet_packages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_fleet_packages_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_fleet_packages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_fleet_packages parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_fleet_packages ::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_fleet_packages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_fleet_packages(::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_fleet_packages_client_stub.call_count
      end
    end
  end

  def test_get_fleet_package
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::FleetPackage.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_fleet_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_get_fleet_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_fleet_package_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_fleet_package({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_fleet_package name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_fleet_package ::Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_fleet_package({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_fleet_package(::Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_fleet_package_client_stub.call_count
      end
    end
  end

  def test_create_fleet_package
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    fleet_package_id = "hello world"
    fleet_package = {}
    request_id = "hello world"

    create_fleet_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_create_fleet_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_fleet_package_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_fleet_package({ parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_fleet_package parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_fleet_package ::Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest.new(parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_fleet_package({ parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_fleet_package(::Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest.new(parent: parent, fleet_package_id: fleet_package_id, fleet_package: fleet_package, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_fleet_package_client_stub.call_count
      end
    end
  end

  def test_update_fleet_package
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    fleet_package = {}
    request_id = "hello world"

    update_fleet_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_update_fleet_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_fleet_package_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_fleet_package({ update_mask: update_mask, fleet_package: fleet_package, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_fleet_package update_mask: update_mask, fleet_package: fleet_package, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_fleet_package ::Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest.new(update_mask: update_mask, fleet_package: fleet_package, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_fleet_package({ update_mask: update_mask, fleet_package: fleet_package, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_fleet_package(::Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest.new(update_mask: update_mask, fleet_package: fleet_package, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_fleet_package_client_stub.call_count
      end
    end
  end

  def test_delete_fleet_package
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true
    allow_missing = true

    delete_fleet_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_delete_fleet_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_fleet_package_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_fleet_package({ name: name, request_id: request_id, force: force, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_fleet_package name: name, request_id: request_id, force: force, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_fleet_package ::Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest.new(name: name, request_id: request_id, force: force, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_fleet_package({ name: name, request_id: request_id, force: force, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_fleet_package(::Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest.new(name: name, request_id: request_id, force: force, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_fleet_package_client_stub.call_count
      end
    end
  end

  def test_list_releases
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::ListReleasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_releases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_list_releases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_releases_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_releases parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_releases ::Google::Cloud::ConfigDelivery::V1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_releases(::Google::Cloud::ConfigDelivery::V1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_releases_client_stub.call_count
      end
    end
  end

  def test_get_release
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::Release.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_get_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_release_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_release({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_release name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_release ::Google::Cloud::ConfigDelivery::V1::GetReleaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_release({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_release(::Google::Cloud::ConfigDelivery::V1::GetReleaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_release_client_stub.call_count
      end
    end
  end

  def test_create_release
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    release_id = "hello world"
    release = {}
    request_id = "hello world"

    create_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_create_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_release_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_release({ parent: parent, release_id: release_id, release: release, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_release parent: parent, release_id: release_id, release: release, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_release ::Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_release({ parent: parent, release_id: release_id, release: release, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_release(::Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_release_client_stub.call_count
      end
    end
  end

  def test_update_release
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    release = {}
    request_id = "hello world"

    update_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_update_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_release_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_release({ update_mask: update_mask, release: release, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_release update_mask: update_mask, release: release, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_release ::Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest.new(update_mask: update_mask, release: release, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_release({ update_mask: update_mask, release: release, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_release(::Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest.new(update_mask: update_mask, release: release, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_release_client_stub.call_count
      end
    end
  end

  def test_delete_release
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_delete_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_release_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_release({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_release name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_release ::Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_release({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_release(::Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_release_client_stub.call_count
      end
    end
  end

  def test_list_variants
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::ListVariantsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_variants_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_list_variants_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_variants_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_variants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_variants parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_variants ::Google::Cloud::ConfigDelivery::V1::ListVariantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_variants({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_variants(::Google::Cloud::ConfigDelivery::V1::ListVariantsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_variants_client_stub.call_count
      end
    end
  end

  def test_get_variant
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::Variant.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_variant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_get_variant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_variant_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_variant({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_variant name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_variant ::Google::Cloud::ConfigDelivery::V1::GetVariantRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_variant({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_variant(::Google::Cloud::ConfigDelivery::V1::GetVariantRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_variant_client_stub.call_count
      end
    end
  end

  def test_create_variant
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    variant_id = "hello world"
    variant = {}
    request_id = "hello world"

    create_variant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_create_variant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_variant_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_variant({ parent: parent, variant_id: variant_id, variant: variant, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_variant parent: parent, variant_id: variant_id, variant: variant, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_variant ::Google::Cloud::ConfigDelivery::V1::CreateVariantRequest.new(parent: parent, variant_id: variant_id, variant: variant, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_variant({ parent: parent, variant_id: variant_id, variant: variant, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_variant(::Google::Cloud::ConfigDelivery::V1::CreateVariantRequest.new(parent: parent, variant_id: variant_id, variant: variant, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_variant_client_stub.call_count
      end
    end
  end

  def test_update_variant
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    variant = {}
    request_id = "hello world"

    update_variant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_update_variant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_variant_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_variant({ update_mask: update_mask, variant: variant, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_variant update_mask: update_mask, variant: variant, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_variant ::Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest.new(update_mask: update_mask, variant: variant, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_variant({ update_mask: update_mask, variant: variant, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_variant(::Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest.new(update_mask: update_mask, variant: variant, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_variant_client_stub.call_count
      end
    end
  end

  def test_delete_variant
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_variant_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_delete_variant_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_variant_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_variant({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_variant name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_variant ::Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_variant({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_variant(::Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_variant_client_stub.call_count
      end
    end
  end

  def test_list_rollouts
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::ListRolloutsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_rollouts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_list_rollouts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_rollouts_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_rollouts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_rollouts ::Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_rollouts(::Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_rollouts_client_stub.call_count
      end
    end
  end

  def test_get_rollout
    # Create test objects.
    client_result = ::Google::Cloud::ConfigDelivery::V1::Rollout.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_get_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rollout({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rollout name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rollout ::Google::Cloud::ConfigDelivery::V1::GetRolloutRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rollout({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rollout(::Google::Cloud::ConfigDelivery::V1::GetRolloutRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rollout_client_stub.call_count
      end
    end
  end

  def test_suspend_rollout
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    suspend_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_suspend_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suspend_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suspend_rollout({ name: name, reason: reason }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suspend_rollout name: name, reason: reason do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suspend_rollout ::Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest.new(name: name, reason: reason) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suspend_rollout({ name: name, reason: reason }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suspend_rollout(::Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest.new(name: name, reason: reason), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suspend_rollout_client_stub.call_count
      end
    end
  end

  def test_resume_rollout
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    resume_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_resume_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resume_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resume_rollout({ name: name, reason: reason }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resume_rollout name: name, reason: reason do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resume_rollout ::Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest.new(name: name, reason: reason) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resume_rollout({ name: name, reason: reason }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resume_rollout(::Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest.new(name: name, reason: reason), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resume_rollout_client_stub.call_count
      end
    end
  end

  def test_abort_rollout
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    reason = "hello world"

    abort_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::ServiceStub.stub :transcode_abort_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, abort_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.abort_rollout({ name: name, reason: reason }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.abort_rollout name: name, reason: reason do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.abort_rollout ::Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest.new(name: name, reason: reason) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.abort_rollout({ name: name, reason: reason }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.abort_rollout(::Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest.new(name: name, reason: reason), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, abort_rollout_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Rest::Client::Configuration, config
  end
end
