# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/config_delivery/v1/config_delivery"

class ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_fleet_package_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.fleet_package_path project: "value0", location: "value1", fleet_package: "value2"
      assert_equal "projects/value0/locations/value1/fleetPackages/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_project_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.project_path project: "value0"
      assert_equal "projects/value0", path
    end
  end

  def test_release_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.release_path project: "value0", location: "value1", resource_bundle: "value2", release: "value3"
      assert_equal "projects/value0/locations/value1/resourceBundles/value2/releases/value3", path
    end
  end

  def test_repository_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.repository_path project: "value0", location: "value1", connection: "value2", repository: "value3"
      assert_equal "projects/value0/locations/value1/connections/value2/repositories/value3", path
    end
  end

  def test_resource_bundle_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.resource_bundle_path project: "value0", location: "value1", resource_bundle: "value2"
      assert_equal "projects/value0/locations/value1/resourceBundles/value2", path
    end
  end

  def test_rollout_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.rollout_path project: "value0", location: "value1", fleet_package: "value2", rollout: "value3"
      assert_equal "projects/value0/locations/value1/fleetPackages/value2/rollouts/value3", path
    end
  end

  def test_variant_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.variant_path project: "value0", location: "value1", resource_bundle: "value2", release: "value3", variant: "value4"
      assert_equal "projects/value0/locations/value1/resourceBundles/value2/releases/value3/variants/value4", path
    end
  end
end
