# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ConfigDelivery
      module V1
        # ResourceBundle represent a collection of kubernetes configuration resources.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the `ResourceBundle`. Format is
        #     `projects/{project}/locations/{location}/resourceBundle
        #     /[a-z][a-z0-9\-]\\{0,62}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time `ResourceBundle` was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time `ResourceBundle` was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Human readable description of the `ResourceBundle`.
        class ResourceBundle
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for requesting list of ResourceBundles.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListResourceBundlesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListResourceBundlesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing ResourceBundles.
        # @!attribute [rw] resource_bundles
        #   @return [::Array<::Google::Cloud::ConfigDelivery::V1::ResourceBundle>]
        #     The list of ResourceBundle.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListResourceBundlesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a ResourceBundle.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetResourceBundleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a ResourceBundle.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] resource_bundle_id
        #   @return [::String]
        #     Required. Id of the requesting object
        #     If auto-generating Id server-side, remove this field and
        #     resource_bundle_id from the method_signature of Create RPC
        # @!attribute [rw] resource_bundle
        #   @return [::Google::Cloud::ConfigDelivery::V1::ResourceBundle]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateResourceBundleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a ResourceBundle
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     ResourceBundle resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] resource_bundle
        #   @return [::Google::Cloud::ConfigDelivery::V1::ResourceBundle]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateResourceBundleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a ResourceBundle
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any releases of this resource bundle will also be
        #     deleted. (Otherwise, the request will only work if the resource bundle has
        #     no releases.)
        class DeleteResourceBundleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `FleetPackage` resource in the Config Delivery API.
        #
        # A `FleetPackage` defines a package through which kubernetes
        # configuration is deployed to a fleet of kubernetes clusters.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the `FleetPackage`. Format is
        #     `projects/{project}/locations/{location}/fleetPackages/{fleetPackage}`.
        #     The `fleetPackage` component must match
        #     `[a-z][a-z0-9\-]{0,62}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `FleetPackage` was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Most recent time at which the `FleetPackage` was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels are attributes that can be set and used by both the
        #     user and by Config Delivery. Labels must meet the following constraints:
        #
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #     underscores, and dashes.
        #     * All characters must use UTF-8 encoding, and international characters are
        #     allowed.
        #     * Keys must start with a lowercase letter or international character.
        #     * Each resource is limited to a maximum of 64 labels.
        #
        #     Both keys and values are additionally constrained to be <= 128 bytes.
        # @!attribute [rw] resource_bundle_selector
        #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage::ResourceBundleSelector]
        #     Required. Information specifying the source of kubernetes configuration to
        #     deploy.
        # @!attribute [rw] target
        #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage::Target]
        #     Optional. Configuration to select target clusters to deploy kubernetes
        #     configuration to.
        # @!attribute [rw] rollout_strategy
        #   @return [::Google::Cloud::ConfigDelivery::V1::RolloutStrategy]
        #     Optional. The strategy to use to deploy kubernetes configuration to
        #     clusters.
        # @!attribute [rw] variant_selector
        #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage::VariantSelector]
        #     Required. Information specifying how to map a `ResourceBundle` variant to a
        #     target cluster.
        # @!attribute [r] info
        #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackageInfo]
        #     Output only. Information containing the rollout status of the
        #     `FleetPackage` across all the target clusters.
        # @!attribute [rw] deletion_propagation_policy
        #   @return [::Google::Cloud::ConfigDelivery::V1::DeletionPropagationPolicy]
        #     Optional. Information around how to handle kubernetes resources at the
        #     target clusters when the `FleetPackage` is deleted.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage::State]
        #     Optional. The desired state of the fleet package.
        class FleetPackage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information specifying the source of kubernetes configuration to deploy.
          # @!attribute [rw] resource_bundle
          #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage::ResourceBundleTag]
          #     Information specifying `ResourceBundle`.
          #
          #     Note: The following fields are mutually exclusive: `resource_bundle`, `cloud_build_repository`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] cloud_build_repository
          #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage::CloudBuildRepository]
          #     Information specifying `CloudBuildRepository`.
          #
          #     Note: The following fields are mutually exclusive: `cloud_build_repository`, `resource_bundle`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ResourceBundleSelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # ResourceBundleTag contains the information to refer to a release for a
          # `ResourceBundle`.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the `ResourceBundle`.
          #     Format is projects/\\{p}/locations/\\{l}/resourceBundles/\\{r}.
          # @!attribute [rw] tag
          #   @return [::String]
          #     Required. Tag refers to a version of the release in a `ResourceBundle`.
          #     This is a Git tag in the semantic version format `vX.Y.Z`.
          class ResourceBundleTag
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # CloudBuildRepository contains information about fetching Kubernetes
          # configuration from a `CloudBuildRepository`.
          # @!attribute [rw] variants_pattern
          #   @return [::String]
          #     Optional. variants_pattern is a glob pattern that will be used to find
          #     variants in the repository. Examples: `variants/*.yaml`, `us-*`
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the cloud build repository.
          #     Format is projects/\\{p}/locations/\\{l}/connections/\\{c}/repositories/\\{r}.
          # @!attribute [rw] path
          #   @return [::String]
          #     Optional. path to the directory or file within the repository that
          #     contains the kubernetes configuration. If unspecified, path is assumed to
          #     the top level root directory of the repository.
          # @!attribute [rw] tag
          #   @return [::String]
          #     Required. git tag of the underlying git repository.
          #     The git tag must be in the semantic version format `vX.Y.Z`.
          # @!attribute [rw] service_account
          #   @return [::String]
          #     Required. Google service account to use in CloudBuild triggers to fetch
          #     and store kubernetes configuration.
          class CloudBuildRepository
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The target defines different ways to target set of kubernetes clusters.
          # @!attribute [rw] fleet
          #   @return [::Google::Cloud::ConfigDelivery::V1::Fleet]
          #     The GKE fleet information.
          class Target
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # VariantSelector contains information for selecting a variant in
          # `ResourceBundle` to deploy to a target cluster.
          # @!attribute [rw] variant_name_template
          #   @return [::String]
          #     Required. variant_name_template is a template that can refer to
          #     variables containing cluster membership metadata such as location,
          #     name, and labels to generate the name of the variant for a target
          #     cluster. The variable syntax is similar to the unix shell variables.
          #
          #     Available variables are `${membership.name}`, `${membership.location}`,
          #     `${membership.project}` and `${membership.labels['label_name']}`.
          #
          #     If you want to deploy a specific variant, say "default" to all the
          #     clusters, you can use "default" (string without any variables) as
          #     the variant_name_template.
          class VariantSelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State indicates the desired state for the fleet package.
          # Unspecified value is equivalent to `ACTIVE`. If state is set to
          # `SUSPENDED`, active rollout (if any) will continue but no new rollouts will
          # be scheduled.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # `FleetPackage` is intended to be active.
            ACTIVE = 1

            # `FleetPackage` is intended to be suspended.
            SUSPENDED = 2
          end
        end

        # FleetPackageInfo represents the status of the `FleetPackage` across all the
        # target clusters.
        # @!attribute [rw] active_rollout
        #   @return [::String]
        #     Optional. The active rollout, if any. Format is
        #     `projects/{project}/locations/{location}/fleetPackages/{fleet_package}/rollouts/{rollout}`.
        # @!attribute [rw] last_completed_rollout
        #   @return [::String]
        #     Optional. The last completed rollout, if any. Format is
        #     `projects/{project}/locations/{location}/fleetPackages/{fleet_package}/rollouts/{rollout}`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackageInfo::State]
        #     Optional. Output only. The current state of the `FleetPackage`.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Cloud::ConfigDelivery::V1::FleetPackageError>]
        #     Optional. Output only. Errors encountered during configuration deployment
        #     (if any).
        class FleetPackageInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible values for the `FleetPackage` state.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # `FleetPackage` is active.
            ACTIVE = 1

            # `FleetPackage` is suspended.
            SUSPENDED = 2

            # `FleetPackage` has failed to reconcile.
            FAILED = 3

            # `FleetPackage` is being deleted.
            DELETING = 4
          end
        end

        # Information representing an error encountered during rolling out
        # configurations.
        # @!attribute [rw] error_message
        #   @return [::String]
        #     Optional. A description of the error.
        class FleetPackageError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ClusterInfo represents status of a resource bundle rollout for a cluster.
        # @!attribute [r] membership
        #   @return [::String]
        #     Output only. gkehub membership of target cluster
        # @!attribute [r] desired
        #   @return [::Google::Cloud::ConfigDelivery::V1::ResourceBundleDeploymentInfo]
        #     Output only. Desired state for the resource bundle.
        # @!attribute [r] initial
        #   @return [::Google::Cloud::ConfigDelivery::V1::ResourceBundleDeploymentInfo]
        #     Output only. Initial state of the resource bundle prior to the deployment.
        # @!attribute [r] current
        #   @return [::Google::Cloud::ConfigDelivery::V1::ResourceBundleDeploymentInfo]
        #     Output only. Current state of the resource bundle.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ConfigDelivery::V1::ClusterInfo::State]
        #     Output only. State of the rollout for the cluster.
        # @!attribute [r] messages
        #   @return [::Array<::String>]
        #     Output only. Unordered list. Messages convey additional information related
        #     to the deployment.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when reconciliation starts.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when reconciliation ends.
        class ClusterInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the rollout for the cluster.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # Waiting state.
            WAITING = 1

            # In progress state.
            IN_PROGRESS = 2

            # Stalled state.
            STALLED = 3

            # Completed state.
            COMPLETED = 4

            # Aborted state.
            ABORTED = 5

            # Cancelled state.
            CANCELLED = 6

            # Error state.
            ERROR = 7

            # Unchanged state.
            UNCHANGED = 8

            # Skipped state.
            SKIPPED = 9
          end
        end

        # ResourceBundleDeploymentInfo represents the status of a resource bundle
        # deployment.
        # @!attribute [r] release
        #   @return [::String]
        #     Output only. Refers to a `ResourceBundle` release.
        # @!attribute [r] version
        #   @return [::String]
        #     Output only. Refers to a version of the `ResourceBundle` release.
        # @!attribute [r] variant
        #   @return [::String]
        #     Output only. Refers to a variant in a `ResourceBundle` release.
        # @!attribute [r] sync_state
        #   @return [::Google::Cloud::ConfigDelivery::V1::ResourceBundleDeploymentInfo::SyncState]
        #     Output only. Synchronization state of the `ResourceBundle` deployment.
        # @!attribute [r] messages
        #   @return [::Array<::String>]
        #     Output only. Unordered list. Messages contains information related to the
        #     `ResourceBundle` deployment. For example, in case of an error, indicate the
        #     reason for the error. In case of a pending deployment, reason for why the
        #     deployment of new release is pending.
        class ResourceBundleDeploymentInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Synchronization state of the resource bundle deployment.
          module SyncState
            # Unspecified state.
            SYNC_STATE_UNSPECIFIED = 0

            # Reconciling state.
            RECONCILING = 1

            # Stalled state.
            STALLED = 2

            # Synced state.
            SYNCED = 3

            # Pending state.
            PENDING = 4

            # Error state.
            ERROR = 5

            # Deletion pending state.
            DELETION_PENDING = 6

            # Deleting state.
            DELETING = 7

            # Deleted state.
            DELETED = 8
          end
        end

        # The fleet where the `FleetPackage` should be deployed.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. The host project for the GKE fleet. Format is
        #     `projects/{project}`.
        # @!attribute [rw] selector
        #   @return [::Google::Cloud::ConfigDelivery::V1::Fleet::LabelSelector]
        #     Optional. selector allows targeting a subset of fleet members using their
        #     labels.
        class Fleet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A label selector is a label query over a set of resources. An empty label
          # selector matches all objects.
          # @!attribute [rw] match_labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. match_labels is a map of \\{key,value} pairs. Each \\{key,value}
          #     pair must match an existing label key and value exactly in order to
          #     satisfy the match.
          class LabelSelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class MatchLabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # AllAtOnceStrategy causes all clusters to be updated concurrently.
        class AllAtOnceStrategy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RollingStrategy causes a specified number of clusters to be updated
        # concurrently until all clusters are updated.
        # @!attribute [rw] max_concurrent
        #   @return [::Integer]
        #     Optional. Maximum number of clusters to update the resource bundle on
        #     concurrently.
        class RollingStrategy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RolloutStrategy defines different ways to rollout a resource bundle across
        # a set of clusters.
        # @!attribute [rw] all_at_once
        #   @return [::Google::Cloud::ConfigDelivery::V1::AllAtOnceStrategy]
        #     AllAtOnceStrategy causes all clusters to be updated concurrently.
        #
        #     Note: The following fields are mutually exclusive: `all_at_once`, `rolling`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] rolling
        #   @return [::Google::Cloud::ConfigDelivery::V1::RollingStrategy]
        #     RollingStrategy causes a specified number of clusters to be updated
        #     concurrently until all clusters are updated.
        #
        #     Note: The following fields are mutually exclusive: `rolling`, `all_at_once`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RolloutStrategy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RolloutStrategyInfo represents the status of execution of different types of
        # rollout strategies. Only the field corresponding to the rollout strategy
        # specified at the rollout resource will be populated.
        # @!attribute [rw] all_at_once_strategy_info
        #   @return [::Google::Cloud::ConfigDelivery::V1::AllAtOnceStrategyInfo]
        #     AllAtOnceStrategyInfo represents the status of AllAtOnce rollout strategy
        #     execution.
        #
        #     Note: The following fields are mutually exclusive: `all_at_once_strategy_info`, `rolling_strategy_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] rolling_strategy_info
        #   @return [::Google::Cloud::ConfigDelivery::V1::RollingStrategyInfo]
        #     RollingStrategyInfo represents the status of Rolling rollout strategy
        #     execution.
        #
        #     Note: The following fields are mutually exclusive: `rolling_strategy_info`, `all_at_once_strategy_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RolloutStrategyInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AllAtOnceStrategyInfo represents the status of execution of AllAtOnce rollout
        # strategy.
        # @!attribute [rw] clusters
        #   @return [::Array<::Google::Cloud::ConfigDelivery::V1::ClusterInfo>]
        #     Unordered list. resource bundle's deployment status for all targeted
        #     clusters.
        class AllAtOnceStrategyInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RollingStrategyInfo represents the status of execution of Rolling rollout
        # strategy.
        # @!attribute [rw] clusters
        #   @return [::Array<::Google::Cloud::ConfigDelivery::V1::ClusterInfo>]
        #     Unordered list. resource bundle's deployment status for all targeted
        #     clusters.
        class RollingStrategyInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of FleetPackage.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListFleetPackagesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListFleetPackagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing FleetPackage
        # @!attribute [rw] fleet_packages
        #   @return [::Array<::Google::Cloud::ConfigDelivery::V1::FleetPackage>]
        #     The list of FleetPackage
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListFleetPackagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a FleetPackage
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetFleetPackageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a FleetPackage
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] fleet_package_id
        #   @return [::String]
        #     Required. Id of the requesting object
        #     If auto-generating Id server-side, remove this field and
        #     fleet_package_id from the method_signature of Create RPC
        # @!attribute [rw] fleet_package
        #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateFleetPackageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a FleetPackage
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     FleetPackage resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] fleet_package
        #   @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateFleetPackageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a FleetPackage
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any rollouts for this FleetPackage will also be
        #     deleted. (Otherwise, the request will only work if the fleet package has no
        #     rollouts.)
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, then deleting an already deleted or non existing
        #     FleetPackage will succeed.
        class DeleteFleetPackageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `Release` represents a versioned release containing kubernetes manifests.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the Release. Format is
        #     `projects/{project}/locations/location}/resourceBundles/{resource_bundle}/release/[a-z][a-z0-9\-]{0,62}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time `Release` was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time `Release` was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs.
        # @!attribute [rw] lifecycle
        #   @return [::Google::Cloud::ConfigDelivery::V1::Release::Lifecycle]
        #     Optional. lifecycle of the `Release`.
        # @!attribute [rw] version
        #   @return [::String]
        #     Required. version of the `Release`. This must be v<major>.<minor>.<patch>.
        # @!attribute [r] publish_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the `Release` was published.
        # @!attribute [rw] info
        #   @return [::Google::Cloud::ConfigDelivery::V1::ReleaseInfo]
        #     Optional. `ResourceBundle` Release extra information e.g., artifact
        #     registry image path.
        class Release
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Lifecycle indicates the state of the `Release`. A published release is
          # immutable.
          module Lifecycle
            # indicates lifecycle has not been specified.
            LIFECYCLE_UNSPECIFIED = 0

            # indicates that the `Release` is being edited.
            DRAFT = 1

            # indicates that the `Release` is now published (or released) and
            # immutable.
            PUBLISHED = 2
          end
        end

        # Variant represents the content of a `ResourceBundle` variant.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. labels to represent any metadata associated with the variant.
        # @!attribute [rw] resources
        #   @return [::Array<::String>]
        #     Required. Input only. Unordered list. resources contain the kubernetes
        #     manifests (YAMLs) for this variant.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name follows format of
        #     projects/\\{project}/locations/\\{location}/resourceBundles/\\{resource_bundle}/releases/\\{release}/variants/\\{variant}
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create time stamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update time stamp
        class Variant
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for requesting list of Variants.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListVariantsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListVariantsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Variants
        # @!attribute [rw] variants
        #   @return [::Array<::Google::Cloud::ConfigDelivery::V1::Variant>]
        #     The list of Variants
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListVariantsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Variant
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetVariantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Variant
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] variant_id
        #   @return [::String]
        #     Required. Id of the requesting object
        # @!attribute [rw] variant
        #   @return [::Google::Cloud::ConfigDelivery::V1::Variant]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateVariantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Variant
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Variant resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] variant
        #   @return [::Google::Cloud::ConfigDelivery::V1::Variant]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateVariantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Variant
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteVariantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ReleaseInfo contains extra information about the `ResourceBundle` release
        # e.g., link to an artifact registry OCI image.
        # @!attribute [r] oci_image_path
        #   @return [::String]
        #     Output only. path to the oci image the service uploads to on a `Release`
        #     creation.
        # @!attribute [rw] variant_oci_image_paths
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. per-variant paths to the oci images the service uploads on
        #     package release creation
        class ReleaseInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class VariantOciImagePathsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for requesting list of Releases.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListReleasesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListReleasesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Releases
        # @!attribute [rw] releases
        #   @return [::Array<::Google::Cloud::ConfigDelivery::V1::Release>]
        #     The list of Releases
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListReleasesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Release
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetReleaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Release
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] release_id
        #   @return [::String]
        #     Required. Id of the requesting object
        #     If auto-generating Id server-side, remove this field and
        #     release_id from the method_signature of Create RPC
        # @!attribute [rw] release
        #   @return [::Google::Cloud::ConfigDelivery::V1::Release]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateReleaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Release
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Release resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] release
        #   @return [::Google::Cloud::ConfigDelivery::V1::Release]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateReleaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Release
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any variants of this release will also be
        #     deleted. (Otherwise, the request will only work if the release has no
        #     variants.)
        class DeleteReleaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of Rollouts
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListRolloutsRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListRolloutsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Rollouts
        # @!attribute [rw] rollouts
        #   @return [::Array<::Google::Cloud::ConfigDelivery::V1::Rollout>]
        #     The list of Rollouts
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListRolloutsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Rollout
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RolloutInfo represents the state of the `FleetPackage` at all the
        # clusters the rollout is targeting.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ConfigDelivery::V1::RolloutInfo::State]
        #     Output only. state contains the overall status of the Rollout.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the rollout started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the rollout completed.
        # @!attribute [r] message
        #   @return [::String]
        #     Output only. Message containing additional information related to the
        #     rollout.
        # @!attribute [r] rollout_strategy_info
        #   @return [::Google::Cloud::ConfigDelivery::V1::RolloutStrategyInfo]
        #     Output only. Rollout strategy info represents the status of execution of
        #     rollout strategy.
        class RolloutInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the rollout
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # Rollout completed.
            COMPLETED = 1

            # Rollout suspended.
            SUSPENDED = 2

            # Rollout aborted.
            ABORTED = 3

            # Rollout in progress.
            IN_PROGRESS = 5

            # Rollout stalled.
            STALLED = 6

            # Rollout cancelled.
            CANCELLED = 7

            # Rollout aborting.
            ABORTING = 8
          end
        end

        # Rollout resource represents an instance of `FleetPackage` rollout operation
        # across a fleet. This is a system generated resource and will be read only for
        # end-users. It will be primarily used by the service to process the changes in
        # the `FleetPackage` and other changes in the environment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the Rollout. Format is
        #     `projects/{project}/locations/{location}/fleetPackages/{fleet_package}/rollouts/[a-z][a-z0-9\-]{0,62}`.
        # @!attribute [rw] release
        #   @return [::String]
        #     Reference to the `Release` being rolled out.
        # @!attribute [rw] rollout_strategy
        #   @return [::Google::Cloud::ConfigDelivery::V1::RolloutStrategy]
        #     Rollout strategy for rolling out `FleetPackage` to clusters.
        # @!attribute [rw] info
        #   @return [::Google::Cloud::ConfigDelivery::V1::RolloutInfo]
        #     Current details of the rollout.
        # @!attribute [rw] deletion_propagation_policy
        #   @return [::Google::Cloud::ConfigDelivery::V1::DeletionPropagationPolicy]
        #     Deletion propagation policy of the rollout.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the rollout was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the rollout was most recently updated.
        class Rollout
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for suspending a rollout.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Rollout.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. Reason for suspension.
        class SuspendRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for resuming a rollout.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Rollout.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. Reason for resuming the rollout.
        class ResumeRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for aborting a rollout.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Rollout.
        # @!attribute [rw] reason
        #   @return [::String]
        #     Optional. Reason for aborting.
        class AbortRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Deletion Propagation Policy determines what happens to the underlying
        # Kubernetes resources on a cluster when the `FleetPackage` managing
        # those resources no longer targets the cluster or is deleted.
        module DeletionPropagationPolicy
          # Unspecified deletion propagation policy. Defaults to FOREGROUND.
          DELETION_PROPAGATION_POLICY_UNSPECIFIED = 0

          # Foreground deletion propagation policy. Any resources synced to the cluster
          # will be deleted.
          FOREGROUND = 1

          # Orphan deletion propagation policy. Any resources synced to the cluster
          # will be abandoned.
          ORPHAN = 2
        end
      end
    end
  end
end
