# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ConfigDelivery
      module V1
        module ConfigDelivery
          # Path helper methods for the ConfigDelivery API.
          module Paths
            ##
            # Create a fully-qualified FleetPackage resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/fleetPackages/{fleet_package}`
            #
            # @param project [String]
            # @param location [String]
            # @param fleet_package [String]
            #
            # @return [::String]
            def fleet_package_path project:, location:, fleet_package:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/fleetPackages/#{fleet_package}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified Release resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/resourceBundles/{resource_bundle}/releases/{release}`
            #
            # @param project [String]
            # @param location [String]
            # @param resource_bundle [String]
            # @param release [String]
            #
            # @return [::String]
            def release_path project:, location:, resource_bundle:, release:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "resource_bundle cannot contain /" if resource_bundle.to_s.include? "/"

              "projects/#{project}/locations/#{location}/resourceBundles/#{resource_bundle}/releases/#{release}"
            end

            ##
            # Create a fully-qualified Repository resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connections/{connection}/repositories/{repository}`
            #
            # @param project [String]
            # @param location [String]
            # @param connection [String]
            # @param repository [String]
            #
            # @return [::String]
            def repository_path project:, location:, connection:, repository:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "connection cannot contain /" if connection.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connections/#{connection}/repositories/#{repository}"
            end

            ##
            # Create a fully-qualified ResourceBundle resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/resourceBundles/{resource_bundle}`
            #
            # @param project [String]
            # @param location [String]
            # @param resource_bundle [String]
            #
            # @return [::String]
            def resource_bundle_path project:, location:, resource_bundle:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/resourceBundles/#{resource_bundle}"
            end

            ##
            # Create a fully-qualified Rollout resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/fleetPackages/{fleet_package}/rollouts/{rollout}`
            #
            # @param project [String]
            # @param location [String]
            # @param fleet_package [String]
            # @param rollout [String]
            #
            # @return [::String]
            def rollout_path project:, location:, fleet_package:, rollout:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "fleet_package cannot contain /" if fleet_package.to_s.include? "/"

              "projects/#{project}/locations/#{location}/fleetPackages/#{fleet_package}/rollouts/#{rollout}"
            end

            ##
            # Create a fully-qualified Variant resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/resourceBundles/{resource_bundle}/releases/{release}/variants/{variant}`
            #
            # @param project [String]
            # @param location [String]
            # @param resource_bundle [String]
            # @param release [String]
            # @param variant [String]
            #
            # @return [::String]
            def variant_path project:, location:, resource_bundle:, release:, variant:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "resource_bundle cannot contain /" if resource_bundle.to_s.include? "/"
              raise ::ArgumentError, "release cannot contain /" if release.to_s.include? "/"

              "projects/#{project}/locations/#{location}/resourceBundles/#{resource_bundle}/releases/#{release}/variants/#{variant}"
            end

            extend self
          end
        end
      end
    end
  end
end
