# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/configdelivery/v1/config_delivery_pb"
require "google/cloud/location"

module Google
  module Cloud
    module ConfigDelivery
      module V1
        module ConfigDelivery
          ##
          # Client for the ConfigDelivery service.
          #
          # ConfigDelivery service manages the deployment of kubernetes configuration to
          # a fleet of kubernetes clusters.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "configdelivery.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :config_delivery_stub

            ##
            # Configure the ConfigDelivery Client class.
            #
            # See {::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ConfigDelivery clients
            #   ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "ConfigDelivery", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_resource_bundles.timeout = 60.0
                default_config.rpcs.list_resource_bundles.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_resource_bundle.timeout = 60.0
                default_config.rpcs.get_resource_bundle.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_resource_bundle.timeout = 60.0

                default_config.rpcs.update_resource_bundle.timeout = 60.0

                default_config.rpcs.delete_resource_bundle.timeout = 60.0

                default_config.rpcs.list_fleet_packages.timeout = 60.0
                default_config.rpcs.list_fleet_packages.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_fleet_package.timeout = 60.0
                default_config.rpcs.get_fleet_package.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_fleet_package.timeout = 60.0

                default_config.rpcs.update_fleet_package.timeout = 60.0

                default_config.rpcs.delete_fleet_package.timeout = 60.0

                default_config.rpcs.list_releases.timeout = 60.0
                default_config.rpcs.list_releases.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_release.timeout = 60.0
                default_config.rpcs.get_release.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_release.timeout = 60.0

                default_config.rpcs.update_release.timeout = 60.0

                default_config.rpcs.delete_release.timeout = 60.0

                default_config.rpcs.list_variants.timeout = 60.0
                default_config.rpcs.list_variants.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_variant.timeout = 60.0
                default_config.rpcs.get_variant.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_variant.timeout = 60.0

                default_config.rpcs.update_variant.timeout = 60.0

                default_config.rpcs.delete_variant.timeout = 60.0

                default_config.rpcs.list_rollouts.timeout = 60.0
                default_config.rpcs.list_rollouts.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_rollout.timeout = 60.0
                default_config.rpcs.get_rollout.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.suspend_rollout.timeout = 60.0

                default_config.rpcs.resume_rollout.timeout = 60.0

                default_config.rpcs.abort_rollout.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ConfigDelivery Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @config_delivery_stub.universe_domain
            end

            ##
            # Create a new ConfigDelivery client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ConfigDelivery client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/configdelivery/v1/config_delivery_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @config_delivery_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @config_delivery_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config_delivery_stub.endpoint
                config.universe_domain = @config_delivery_stub.universe_domain
                config.logger = @config_delivery_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @config_delivery_stub.logger
            end

            # Service calls

            ##
            # Lists ResourceBundles in a given project and location.
            #
            # @overload list_resource_bundles(request, options = nil)
            #   Pass arguments to `list_resource_bundles` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_resource_bundles(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_resource_bundles` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListResourceBundlesRequest.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::ResourceBundle>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::ResourceBundle>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest.new
            #
            #   # Call the list_resource_bundles method.
            #   result = client.list_resource_bundles request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigDelivery::V1::ResourceBundle.
            #     p item
            #   end
            #
            def list_resource_bundles request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::ListResourceBundlesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_resource_bundles.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_resource_bundles.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_resource_bundles.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :list_resource_bundles, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_delivery_stub, :list_resource_bundles, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ResourceBundle.
            #
            # @overload get_resource_bundle(request, options = nil)
            #   Pass arguments to `get_resource_bundle` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_resource_bundle(name: nil)
            #   Pass arguments to `get_resource_bundle` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigDelivery::V1::ResourceBundle]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigDelivery::V1::ResourceBundle]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest.new
            #
            #   # Call the get_resource_bundle method.
            #   result = client.get_resource_bundle request
            #
            #   # The returned object is of type Google::Cloud::ConfigDelivery::V1::ResourceBundle.
            #   p result
            #
            def get_resource_bundle request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::GetResourceBundleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_resource_bundle.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_resource_bundle.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_resource_bundle.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :get_resource_bundle, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ResourceBundle in a given project and location.
            #
            # @overload create_resource_bundle(request, options = nil)
            #   Pass arguments to `create_resource_bundle` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_resource_bundle(parent: nil, resource_bundle_id: nil, resource_bundle: nil, request_id: nil)
            #   Pass arguments to `create_resource_bundle` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param resource_bundle_id [::String]
            #     Required. Id of the requesting object
            #     If auto-generating Id server-side, remove this field and
            #     resource_bundle_id from the method_signature of Create RPC
            #   @param resource_bundle [::Google::Cloud::ConfigDelivery::V1::ResourceBundle, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest.new
            #
            #   # Call the create_resource_bundle method.
            #   result = client.create_resource_bundle request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_resource_bundle request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::CreateResourceBundleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_resource_bundle.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_resource_bundle.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_resource_bundle.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :create_resource_bundle, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ResourceBundle.
            #
            # @overload update_resource_bundle(request, options = nil)
            #   Pass arguments to `update_resource_bundle` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_resource_bundle(update_mask: nil, resource_bundle: nil, request_id: nil)
            #   Pass arguments to `update_resource_bundle` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     ResourceBundle resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param resource_bundle [::Google::Cloud::ConfigDelivery::V1::ResourceBundle, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest.new
            #
            #   # Call the update_resource_bundle method.
            #   result = client.update_resource_bundle request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_resource_bundle request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::UpdateResourceBundleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_resource_bundle.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource_bundle&.name
                header_params["resource_bundle.name"] = request.resource_bundle.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_resource_bundle.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_resource_bundle.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :update_resource_bundle, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ResourceBundle.
            #
            # @overload delete_resource_bundle(request, options = nil)
            #   Pass arguments to `delete_resource_bundle` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_resource_bundle(name: nil, request_id: nil, force: nil)
            #   Pass arguments to `delete_resource_bundle` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param force [::Boolean]
            #     Optional. If set to true, any releases of this resource bundle will also be
            #     deleted. (Otherwise, the request will only work if the resource bundle has
            #     no releases.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest.new
            #
            #   # Call the delete_resource_bundle method.
            #   result = client.delete_resource_bundle request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_resource_bundle request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::DeleteResourceBundleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_resource_bundle.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_resource_bundle.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_resource_bundle.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :delete_resource_bundle, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists FleetPackages in a given project and location.
            #
            # @overload list_fleet_packages(request, options = nil)
            #   Pass arguments to `list_fleet_packages` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_fleet_packages(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_fleet_packages` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListFleetPackagesRequest.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::FleetPackage>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::FleetPackage>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest.new
            #
            #   # Call the list_fleet_packages method.
            #   result = client.list_fleet_packages request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigDelivery::V1::FleetPackage.
            #     p item
            #   end
            #
            def list_fleet_packages request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::ListFleetPackagesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_fleet_packages.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_fleet_packages.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_fleet_packages.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :list_fleet_packages, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_delivery_stub, :list_fleet_packages, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single FleetPackage.
            #
            # @overload get_fleet_package(request, options = nil)
            #   Pass arguments to `get_fleet_package` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_fleet_package(name: nil)
            #   Pass arguments to `get_fleet_package` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigDelivery::V1::FleetPackage]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigDelivery::V1::FleetPackage]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest.new
            #
            #   # Call the get_fleet_package method.
            #   result = client.get_fleet_package request
            #
            #   # The returned object is of type Google::Cloud::ConfigDelivery::V1::FleetPackage.
            #   p result
            #
            def get_fleet_package request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::GetFleetPackageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_fleet_package.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_fleet_package.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_fleet_package.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :get_fleet_package, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new FleetPackage in a given project and location.
            #
            # @overload create_fleet_package(request, options = nil)
            #   Pass arguments to `create_fleet_package` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_fleet_package(parent: nil, fleet_package_id: nil, fleet_package: nil, request_id: nil)
            #   Pass arguments to `create_fleet_package` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param fleet_package_id [::String]
            #     Required. Id of the requesting object
            #     If auto-generating Id server-side, remove this field and
            #     fleet_package_id from the method_signature of Create RPC
            #   @param fleet_package [::Google::Cloud::ConfigDelivery::V1::FleetPackage, ::Hash]
            #     Required. The resource being created.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest.new
            #
            #   # Call the create_fleet_package method.
            #   result = client.create_fleet_package request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_fleet_package request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::CreateFleetPackageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_fleet_package.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_fleet_package.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_fleet_package.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :create_fleet_package, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single FleetPackage.
            #
            # @overload update_fleet_package(request, options = nil)
            #   Pass arguments to `update_fleet_package` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_fleet_package(update_mask: nil, fleet_package: nil, request_id: nil)
            #   Pass arguments to `update_fleet_package` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     FleetPackage resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param fleet_package [::Google::Cloud::ConfigDelivery::V1::FleetPackage, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest.new
            #
            #   # Call the update_fleet_package method.
            #   result = client.update_fleet_package request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_fleet_package request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::UpdateFleetPackageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_fleet_package.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.fleet_package&.name
                header_params["fleet_package.name"] = request.fleet_package.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_fleet_package.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_fleet_package.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :update_fleet_package, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single FleetPackage.
            #
            # @overload delete_fleet_package(request, options = nil)
            #   Pass arguments to `delete_fleet_package` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_fleet_package(name: nil, request_id: nil, force: nil, allow_missing: nil)
            #   Pass arguments to `delete_fleet_package` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param force [::Boolean]
            #     Optional. If set to true, any rollouts for this FleetPackage will also be
            #     deleted. (Otherwise, the request will only work if the fleet package has no
            #     rollouts.)
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, then deleting an already deleted or non existing
            #     FleetPackage will succeed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest.new
            #
            #   # Call the delete_fleet_package method.
            #   result = client.delete_fleet_package request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_fleet_package request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::DeleteFleetPackageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_fleet_package.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_fleet_package.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_fleet_package.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :delete_fleet_package, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Releases in a given project and location.
            #
            # @overload list_releases(request, options = nil)
            #   Pass arguments to `list_releases` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::ListReleasesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::ListReleasesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_releases(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_releases` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListReleasesRequest.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::Release>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::Release>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::ListReleasesRequest.new
            #
            #   # Call the list_releases method.
            #   result = client.list_releases request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigDelivery::V1::Release.
            #     p item
            #   end
            #
            def list_releases request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::ListReleasesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_releases.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_releases.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_releases.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :list_releases, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_delivery_stub, :list_releases, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Release.
            #
            # @overload get_release(request, options = nil)
            #   Pass arguments to `get_release` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::GetReleaseRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::GetReleaseRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_release(name: nil)
            #   Pass arguments to `get_release` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigDelivery::V1::Release]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigDelivery::V1::Release]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::GetReleaseRequest.new
            #
            #   # Call the get_release method.
            #   result = client.get_release request
            #
            #   # The returned object is of type Google::Cloud::ConfigDelivery::V1::Release.
            #   p result
            #
            def get_release request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::GetReleaseRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_release.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_release.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_release.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :get_release, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Release in a given project, location and resource bundle.
            #
            # @overload create_release(request, options = nil)
            #   Pass arguments to `create_release` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_release(parent: nil, release_id: nil, release: nil, request_id: nil)
            #   Pass arguments to `create_release` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param release_id [::String]
            #     Required. Id of the requesting object
            #     If auto-generating Id server-side, remove this field and
            #     release_id from the method_signature of Create RPC
            #   @param release [::Google::Cloud::ConfigDelivery::V1::Release, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest.new
            #
            #   # Call the create_release method.
            #   result = client.create_release request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_release request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::CreateReleaseRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_release.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_release.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_release.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :create_release, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Release.
            #
            # @overload update_release(request, options = nil)
            #   Pass arguments to `update_release` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_release(update_mask: nil, release: nil, request_id: nil)
            #   Pass arguments to `update_release` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     Release resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param release [::Google::Cloud::ConfigDelivery::V1::Release, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest.new
            #
            #   # Call the update_release method.
            #   result = client.update_release request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_release request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::UpdateReleaseRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_release.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.release&.name
                header_params["release.name"] = request.release.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_release.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_release.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :update_release, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Release.
            #
            # @overload delete_release(request, options = nil)
            #   Pass arguments to `delete_release` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_release(name: nil, request_id: nil, force: nil)
            #   Pass arguments to `delete_release` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param force [::Boolean]
            #     Optional. If set to true, any variants of this release will also be
            #     deleted. (Otherwise, the request will only work if the release has no
            #     variants.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest.new
            #
            #   # Call the delete_release method.
            #   result = client.delete_release request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_release request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::DeleteReleaseRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_release.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_release.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_release.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :delete_release, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Variants in a given project and location.
            #
            # @overload list_variants(request, options = nil)
            #   Pass arguments to `list_variants` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::ListVariantsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::ListVariantsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_variants(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_variants` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListVariantsRequest.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::Variant>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::Variant>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::ListVariantsRequest.new
            #
            #   # Call the list_variants method.
            #   result = client.list_variants request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigDelivery::V1::Variant.
            #     p item
            #   end
            #
            def list_variants request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::ListVariantsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_variants.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_variants.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_variants.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :list_variants, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_delivery_stub, :list_variants, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Variant.
            #
            # @overload get_variant(request, options = nil)
            #   Pass arguments to `get_variant` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::GetVariantRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::GetVariantRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_variant(name: nil)
            #   Pass arguments to `get_variant` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigDelivery::V1::Variant]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigDelivery::V1::Variant]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::GetVariantRequest.new
            #
            #   # Call the get_variant method.
            #   result = client.get_variant request
            #
            #   # The returned object is of type Google::Cloud::ConfigDelivery::V1::Variant.
            #   p result
            #
            def get_variant request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::GetVariantRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_variant.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_variant.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_variant.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :get_variant, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Variant in a given project, location, resource bundle, and
            # release.
            #
            # @overload create_variant(request, options = nil)
            #   Pass arguments to `create_variant` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::CreateVariantRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::CreateVariantRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_variant(parent: nil, variant_id: nil, variant: nil, request_id: nil)
            #   Pass arguments to `create_variant` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param variant_id [::String]
            #     Required. Id of the requesting object
            #   @param variant [::Google::Cloud::ConfigDelivery::V1::Variant, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::CreateVariantRequest.new
            #
            #   # Call the create_variant method.
            #   result = client.create_variant request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_variant request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::CreateVariantRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_variant.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_variant.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_variant.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :create_variant, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Variant.
            #
            # @overload update_variant(request, options = nil)
            #   Pass arguments to `update_variant` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_variant(update_mask: nil, variant: nil, request_id: nil)
            #   Pass arguments to `update_variant` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     Variant resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param variant [::Google::Cloud::ConfigDelivery::V1::Variant, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest.new
            #
            #   # Call the update_variant method.
            #   result = client.update_variant request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_variant request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::UpdateVariantRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_variant.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.variant&.name
                header_params["variant.name"] = request.variant.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_variant.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_variant.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :update_variant, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Variant.
            #
            # @overload delete_variant(request, options = nil)
            #   Pass arguments to `delete_variant` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_variant(name: nil, request_id: nil)
            #   Pass arguments to `delete_variant` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest.new
            #
            #   # Call the delete_variant method.
            #   result = client.delete_variant request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_variant request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::DeleteVariantRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_variant.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_variant.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_variant.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :delete_variant, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Rollouts in a given project, location, and Fleet Package.
            #
            # @overload list_rollouts(request, options = nil)
            #   Pass arguments to `list_rollouts` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_rollouts(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_rollouts` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListRolloutsRequest
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::Rollout>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ConfigDelivery::V1::Rollout>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest.new
            #
            #   # Call the list_rollouts method.
            #   result = client.list_rollouts request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ConfigDelivery::V1::Rollout.
            #     p item
            #   end
            #
            def list_rollouts request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::ListRolloutsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_rollouts.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_rollouts.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_rollouts.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :list_rollouts, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_delivery_stub, :list_rollouts, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Rollout.
            #
            # @overload get_rollout(request, options = nil)
            #   Pass arguments to `get_rollout` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::GetRolloutRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::GetRolloutRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_rollout(name: nil)
            #   Pass arguments to `get_rollout` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ConfigDelivery::V1::Rollout]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ConfigDelivery::V1::Rollout]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::GetRolloutRequest.new
            #
            #   # Call the get_rollout method.
            #   result = client.get_rollout request
            #
            #   # The returned object is of type Google::Cloud::ConfigDelivery::V1::Rollout.
            #   p result
            #
            def get_rollout request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::GetRolloutRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_rollout.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_rollout.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_rollout.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :get_rollout, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Suspend a Rollout.
            #
            # @overload suspend_rollout(request, options = nil)
            #   Pass arguments to `suspend_rollout` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload suspend_rollout(name: nil, reason: nil)
            #   Pass arguments to `suspend_rollout` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the Rollout.
            #   @param reason [::String]
            #     Optional. Reason for suspension.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest.new
            #
            #   # Call the suspend_rollout method.
            #   result = client.suspend_rollout request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def suspend_rollout request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::SuspendRolloutRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.suspend_rollout.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.suspend_rollout.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.suspend_rollout.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :suspend_rollout, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resume a Rollout.
            #
            # @overload resume_rollout(request, options = nil)
            #   Pass arguments to `resume_rollout` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload resume_rollout(name: nil, reason: nil)
            #   Pass arguments to `resume_rollout` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the Rollout.
            #   @param reason [::String]
            #     Optional. Reason for resuming the rollout.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest.new
            #
            #   # Call the resume_rollout method.
            #   result = client.resume_rollout request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def resume_rollout request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::ResumeRolloutRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.resume_rollout.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.resume_rollout.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.resume_rollout.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :resume_rollout, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Abort a Rollout.
            #
            # @overload abort_rollout(request, options = nil)
            #   Pass arguments to `abort_rollout` via a request object, either of type
            #   {::Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload abort_rollout(name: nil, reason: nil)
            #   Pass arguments to `abort_rollout` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the Rollout.
            #   @param reason [::String]
            #     Optional. Reason for aborting.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/config_delivery/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest.new
            #
            #   # Call the abort_rollout method.
            #   result = client.abort_rollout request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def abort_rollout request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfigDelivery::V1::AbortRolloutRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.abort_rollout.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ConfigDelivery::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.abort_rollout.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.abort_rollout.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_delivery_stub.call_rpc :abort_rollout, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ConfigDelivery API.
            #
            # This class represents the configuration for ConfigDelivery,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_resource_bundles to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_resource_bundles.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_resource_bundles.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::ConfigDelivery::V1::ConfigDelivery::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "configdelivery.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ConfigDelivery API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_resource_bundles`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_resource_bundles
                ##
                # RPC-specific configuration for `get_resource_bundle`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_resource_bundle
                ##
                # RPC-specific configuration for `create_resource_bundle`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_resource_bundle
                ##
                # RPC-specific configuration for `update_resource_bundle`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_resource_bundle
                ##
                # RPC-specific configuration for `delete_resource_bundle`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_resource_bundle
                ##
                # RPC-specific configuration for `list_fleet_packages`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_fleet_packages
                ##
                # RPC-specific configuration for `get_fleet_package`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_fleet_package
                ##
                # RPC-specific configuration for `create_fleet_package`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_fleet_package
                ##
                # RPC-specific configuration for `update_fleet_package`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_fleet_package
                ##
                # RPC-specific configuration for `delete_fleet_package`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_fleet_package
                ##
                # RPC-specific configuration for `list_releases`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_releases
                ##
                # RPC-specific configuration for `get_release`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_release
                ##
                # RPC-specific configuration for `create_release`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_release
                ##
                # RPC-specific configuration for `update_release`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_release
                ##
                # RPC-specific configuration for `delete_release`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_release
                ##
                # RPC-specific configuration for `list_variants`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_variants
                ##
                # RPC-specific configuration for `get_variant`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_variant
                ##
                # RPC-specific configuration for `create_variant`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_variant
                ##
                # RPC-specific configuration for `update_variant`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_variant
                ##
                # RPC-specific configuration for `delete_variant`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_variant
                ##
                # RPC-specific configuration for `list_rollouts`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_rollouts
                ##
                # RPC-specific configuration for `get_rollout`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_rollout
                ##
                # RPC-specific configuration for `suspend_rollout`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :suspend_rollout
                ##
                # RPC-specific configuration for `resume_rollout`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :resume_rollout
                ##
                # RPC-specific configuration for `abort_rollout`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :abort_rollout

                # @private
                def initialize parent_rpcs = nil
                  list_resource_bundles_config = parent_rpcs.list_resource_bundles if parent_rpcs.respond_to? :list_resource_bundles
                  @list_resource_bundles = ::Gapic::Config::Method.new list_resource_bundles_config
                  get_resource_bundle_config = parent_rpcs.get_resource_bundle if parent_rpcs.respond_to? :get_resource_bundle
                  @get_resource_bundle = ::Gapic::Config::Method.new get_resource_bundle_config
                  create_resource_bundle_config = parent_rpcs.create_resource_bundle if parent_rpcs.respond_to? :create_resource_bundle
                  @create_resource_bundle = ::Gapic::Config::Method.new create_resource_bundle_config
                  update_resource_bundle_config = parent_rpcs.update_resource_bundle if parent_rpcs.respond_to? :update_resource_bundle
                  @update_resource_bundle = ::Gapic::Config::Method.new update_resource_bundle_config
                  delete_resource_bundle_config = parent_rpcs.delete_resource_bundle if parent_rpcs.respond_to? :delete_resource_bundle
                  @delete_resource_bundle = ::Gapic::Config::Method.new delete_resource_bundle_config
                  list_fleet_packages_config = parent_rpcs.list_fleet_packages if parent_rpcs.respond_to? :list_fleet_packages
                  @list_fleet_packages = ::Gapic::Config::Method.new list_fleet_packages_config
                  get_fleet_package_config = parent_rpcs.get_fleet_package if parent_rpcs.respond_to? :get_fleet_package
                  @get_fleet_package = ::Gapic::Config::Method.new get_fleet_package_config
                  create_fleet_package_config = parent_rpcs.create_fleet_package if parent_rpcs.respond_to? :create_fleet_package
                  @create_fleet_package = ::Gapic::Config::Method.new create_fleet_package_config
                  update_fleet_package_config = parent_rpcs.update_fleet_package if parent_rpcs.respond_to? :update_fleet_package
                  @update_fleet_package = ::Gapic::Config::Method.new update_fleet_package_config
                  delete_fleet_package_config = parent_rpcs.delete_fleet_package if parent_rpcs.respond_to? :delete_fleet_package
                  @delete_fleet_package = ::Gapic::Config::Method.new delete_fleet_package_config
                  list_releases_config = parent_rpcs.list_releases if parent_rpcs.respond_to? :list_releases
                  @list_releases = ::Gapic::Config::Method.new list_releases_config
                  get_release_config = parent_rpcs.get_release if parent_rpcs.respond_to? :get_release
                  @get_release = ::Gapic::Config::Method.new get_release_config
                  create_release_config = parent_rpcs.create_release if parent_rpcs.respond_to? :create_release
                  @create_release = ::Gapic::Config::Method.new create_release_config
                  update_release_config = parent_rpcs.update_release if parent_rpcs.respond_to? :update_release
                  @update_release = ::Gapic::Config::Method.new update_release_config
                  delete_release_config = parent_rpcs.delete_release if parent_rpcs.respond_to? :delete_release
                  @delete_release = ::Gapic::Config::Method.new delete_release_config
                  list_variants_config = parent_rpcs.list_variants if parent_rpcs.respond_to? :list_variants
                  @list_variants = ::Gapic::Config::Method.new list_variants_config
                  get_variant_config = parent_rpcs.get_variant if parent_rpcs.respond_to? :get_variant
                  @get_variant = ::Gapic::Config::Method.new get_variant_config
                  create_variant_config = parent_rpcs.create_variant if parent_rpcs.respond_to? :create_variant
                  @create_variant = ::Gapic::Config::Method.new create_variant_config
                  update_variant_config = parent_rpcs.update_variant if parent_rpcs.respond_to? :update_variant
                  @update_variant = ::Gapic::Config::Method.new update_variant_config
                  delete_variant_config = parent_rpcs.delete_variant if parent_rpcs.respond_to? :delete_variant
                  @delete_variant = ::Gapic::Config::Method.new delete_variant_config
                  list_rollouts_config = parent_rpcs.list_rollouts if parent_rpcs.respond_to? :list_rollouts
                  @list_rollouts = ::Gapic::Config::Method.new list_rollouts_config
                  get_rollout_config = parent_rpcs.get_rollout if parent_rpcs.respond_to? :get_rollout
                  @get_rollout = ::Gapic::Config::Method.new get_rollout_config
                  suspend_rollout_config = parent_rpcs.suspend_rollout if parent_rpcs.respond_to? :suspend_rollout
                  @suspend_rollout = ::Gapic::Config::Method.new suspend_rollout_config
                  resume_rollout_config = parent_rpcs.resume_rollout if parent_rpcs.respond_to? :resume_rollout
                  @resume_rollout = ::Gapic::Config::Method.new resume_rollout_config
                  abort_rollout_config = parent_rpcs.abort_rollout if parent_rpcs.respond_to? :abort_rollout
                  @abort_rollout = ::Gapic::Config::Method.new abort_rollout_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
