# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/confidentialcomputing/v1/service_pb"
require "google/cloud/confidential_computing/v1/confidential_computing"

class ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_challenge
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfidentialComputing::V1::Challenge.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    challenge = {}

    create_challenge_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_challenge, name
      assert_kind_of ::Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::Challenge), request["challenge"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_challenge_client_stub do
      # Create client
      client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_challenge({ parent: parent, challenge: challenge }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_challenge parent: parent, challenge: challenge do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_challenge ::Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest.new(parent: parent, challenge: challenge) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_challenge({ parent: parent, challenge: challenge }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_challenge(::Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest.new(parent: parent, challenge: challenge), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_challenge_client_stub.call_rpc_count
    end
  end

  def test_verify_attestation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    td_ccel = {}
    challenge = "hello world"
    gcp_credentials = {}
    tpm_attestation = {}
    confidential_space_info = {}
    token_options = {}
    attester = "hello world"

    verify_attestation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :verify_attestation, name
      assert_kind_of ::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::TdxCcelAttestation), request["td_ccel"]
      assert_equal :td_ccel, request.tee_attestation
      assert_equal "hello world", request["challenge"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::GcpCredentials), request["gcp_credentials"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::TpmAttestation), request["tpm_attestation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::ConfidentialSpaceInfo), request["confidential_space_info"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::TokenOptions), request["token_options"]
      assert_equal "hello world", request["attester"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, verify_attestation_client_stub do
      # Create client
      client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.verify_attestation({ td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.verify_attestation td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.verify_attestation ::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest.new(td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.verify_attestation({ td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.verify_attestation(::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest.new(td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, verify_attestation_client_stub.call_rpc_count
    end
  end

  def test_verify_confidential_space
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    td_ccel = {}
    challenge = "hello world"
    gcp_credentials = {}
    signed_entities = [{}]
    gce_shielded_identity = {}
    options = {}

    verify_confidential_space_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :verify_confidential_space, name
      assert_kind_of ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::TdxCcelAttestation), request["td_ccel"]
      assert_equal :td_ccel, request.tee_attestation
      assert_equal "hello world", request["challenge"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::GcpCredentials), request["gcp_credentials"]
      assert_kind_of ::Google::Cloud::ConfidentialComputing::V1::SignedEntity, request["signed_entities"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::GceShieldedIdentity), request["gce_shielded_identity"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest::ConfidentialSpaceOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, verify_confidential_space_client_stub do
      # Create client
      client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.verify_confidential_space({ td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.verify_confidential_space td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.verify_confidential_space ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest.new(td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.verify_confidential_space({ td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.verify_confidential_space(::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest.new(td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, verify_confidential_space_client_stub.call_rpc_count
    end
  end

  def test_verify_confidential_gke
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tpm_attestation = {}
    challenge = "hello world"

    verify_confidential_gke_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :verify_confidential_gke, name
      assert_kind_of ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ConfidentialComputing::V1::TpmAttestation), request["tpm_attestation"]
      assert_equal :tpm_attestation, request.tee_attestation
      assert_equal "hello world", request["challenge"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, verify_confidential_gke_client_stub do
      # Create client
      client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.verify_confidential_gke({ tpm_attestation: tpm_attestation, challenge: challenge }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.verify_confidential_gke tpm_attestation: tpm_attestation, challenge: challenge do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.verify_confidential_gke ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest.new(tpm_attestation: tpm_attestation, challenge: challenge) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.verify_confidential_gke({ tpm_attestation: tpm_attestation, challenge: challenge }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.verify_confidential_gke(::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest.new(tpm_attestation: tpm_attestation, challenge: challenge), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, verify_confidential_gke_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
