# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/confidentialcomputing/v1/service_pb"
require "google/cloud/confidential_computing/v1/confidential_computing/rest"


class ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_challenge
    # Create test objects.
    client_result = ::Google::Cloud::ConfidentialComputing::V1::Challenge.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    challenge = {}

    create_challenge_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::ServiceStub.stub :transcode_create_challenge_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_challenge_client_stub do
        # Create client
        client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_challenge({ parent: parent, challenge: challenge }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_challenge parent: parent, challenge: challenge do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_challenge ::Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest.new(parent: parent, challenge: challenge) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_challenge({ parent: parent, challenge: challenge }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_challenge(::Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest.new(parent: parent, challenge: challenge), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_challenge_client_stub.call_count
      end
    end
  end

  def test_verify_attestation
    # Create test objects.
    client_result = ::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    td_ccel = {}
    challenge = "hello world"
    gcp_credentials = {}
    tpm_attestation = {}
    confidential_space_info = {}
    token_options = {}
    attester = "hello world"

    verify_attestation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::ServiceStub.stub :transcode_verify_attestation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, verify_attestation_client_stub do
        # Create client
        client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.verify_attestation({ td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.verify_attestation td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.verify_attestation ::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest.new(td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.verify_attestation({ td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.verify_attestation(::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest.new(td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, tpm_attestation: tpm_attestation, confidential_space_info: confidential_space_info, token_options: token_options, attester: attester), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, verify_attestation_client_stub.call_count
      end
    end
  end

  def test_verify_confidential_space
    # Create test objects.
    client_result = ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    td_ccel = {}
    challenge = "hello world"
    gcp_credentials = {}
    signed_entities = [{}]
    gce_shielded_identity = {}
    options = {}

    verify_confidential_space_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::ServiceStub.stub :transcode_verify_confidential_space_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, verify_confidential_space_client_stub do
        # Create client
        client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.verify_confidential_space({ td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.verify_confidential_space td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.verify_confidential_space ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest.new(td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.verify_confidential_space({ td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.verify_confidential_space(::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest.new(td_ccel: td_ccel, challenge: challenge, gcp_credentials: gcp_credentials, signed_entities: signed_entities, gce_shielded_identity: gce_shielded_identity, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, verify_confidential_space_client_stub.call_count
      end
    end
  end

  def test_verify_confidential_gke
    # Create test objects.
    client_result = ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tpm_attestation = {}
    challenge = "hello world"

    verify_confidential_gke_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::ServiceStub.stub :transcode_verify_confidential_gke_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, verify_confidential_gke_client_stub do
        # Create client
        client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.verify_confidential_gke({ tpm_attestation: tpm_attestation, challenge: challenge }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.verify_confidential_gke tpm_attestation: tpm_attestation, challenge: challenge do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.verify_confidential_gke ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest.new(tpm_attestation: tpm_attestation, challenge: challenge) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.verify_confidential_gke({ tpm_attestation: tpm_attestation, challenge: challenge }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.verify_confidential_gke(::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest.new(tpm_attestation: tpm_attestation, challenge: challenge), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, verify_confidential_gke_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client::Configuration, config
  end
end
