# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ConfidentialComputing
      module V1
        # A Challenge from the server used to guarantee freshness of attestations
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this Challenge in the format
        #     `projects/*/locations/*/challenges/*`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this Challenge was created
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this Challenge will no longer be usable. It
        #     is also the expiration time for any tokens generated from this Challenge.
        # @!attribute [r] used
        #   @return [::Boolean]
        #     Output only. Indicates if this challenge has been used to generate a token.
        # @!attribute [r] tpm_nonce
        #   @return [::String]
        #     Output only. Identical to nonce, but as a string.
        class Challenge
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Challenge
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location where the Challenge will be
        #     used, in the format `projects/*/locations/*`.
        # @!attribute [rw] challenge
        #   @return [::Google::Cloud::ConfidentialComputing::V1::Challenge]
        #     Required. The Challenge to be created. Currently this field can be empty as
        #     all the Challenge fields are set by the server.
        class CreateChallengeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request for an attestation token, providing all the necessary information
        # needed for this service to verify the platform state of the requestor.
        # @!attribute [rw] td_ccel
        #   @return [::Google::Cloud::ConfidentialComputing::V1::TdxCcelAttestation]
        #     Optional. A TDX with CCEL and RTMR Attestation Quote.
        #
        #     Note: The following fields are mutually exclusive: `td_ccel`, `sev_snp_attestation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sev_snp_attestation
        #   @return [::Google::Cloud::ConfidentialComputing::V1::SevSnpAttestation]
        #     Optional. An SEV-SNP Attestation Report.
        #
        #     Note: The following fields are mutually exclusive: `sev_snp_attestation`, `td_ccel`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] challenge
        #   @return [::String]
        #     Required. The name of the Challenge whose nonce was used to generate the
        #     attestation, in the format `projects/*/locations/*/challenges/*`. The
        #     provided Challenge will be consumed, and cannot be used again.
        # @!attribute [rw] gcp_credentials
        #   @return [::Google::Cloud::ConfidentialComputing::V1::GcpCredentials]
        #     Optional. Credentials used to populate the "emails" claim in the
        #     claims_token.
        # @!attribute [rw] tpm_attestation
        #   @return [::Google::Cloud::ConfidentialComputing::V1::TpmAttestation]
        #     Required. The TPM-specific data provided by the attesting platform, used to
        #     populate any of the claims regarding platform state.
        # @!attribute [rw] confidential_space_info
        #   @return [::Google::Cloud::ConfidentialComputing::V1::ConfidentialSpaceInfo]
        #     Optional. Optional information related to the Confidential Space TEE.
        # @!attribute [rw] token_options
        #   @return [::Google::Cloud::ConfidentialComputing::V1::TokenOptions]
        #     Optional. A collection of optional, workload-specified claims that modify
        #     the token output.
        # @!attribute [rw] attester
        #   @return [::String]
        #     Optional. An optional indicator of the attester, only applies to certain
        #     products.
        class VerifyAttestationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A TDX Attestation quote.
        # @!attribute [rw] ccel_acpi_table
        #   @return [::String]
        #     Optional. The Confidential Computing Event Log (CCEL) ACPI table. Formatted
        #     as described in the ACPI Specification 6.5.
        # @!attribute [rw] ccel_data
        #   @return [::String]
        #     Optional. The CCEL event log. Formatted as described in the UEFI 2.10.
        # @!attribute [rw] canonical_event_log
        #   @return [::String]
        #     Optional. An Event Log containing additional events measured into the RTMR
        #     that are not already present in the CCEL.
        # @!attribute [rw] td_quote
        #   @return [::String]
        #     Optional. The TDX attestation quote from the guest. It contains the RTMR
        #     values.
        class TdxCcelAttestation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An SEV-SNP Attestation Report.
        # Contains the attestation report and the certificate bundle that the client
        # collects.
        # @!attribute [rw] report
        #   @return [::String]
        #     Optional. The SEV-SNP Attestation Report
        #     Format is in revision 1.55, §7.3 Attestation, Table 22. ATTESTATION_REPORT
        #     Structure in this document:
        #     https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56860.pdf
        # @!attribute [rw] aux_blob
        #   @return [::String]
        #     Optional. Certificate bundle defined in the GHCB protocol definition
        #     Format is documented in GHCB revision 2.03, section 4.1.8.1 struct
        #     cert_table in this document:
        #     https://www.amd.com/content/dam/amd/en/documents/epyc-technical-docs/specifications/56421.pdf
        class SevSnpAttestation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response once an attestation has been successfully verified, containing a
        # signed attestation token.
        # @!attribute [r] oidc_claims_token
        #   @return [::String]
        #     Output only. Same as claims_token, but as a string.
        # @!attribute [r] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. A list of messages that carry the partial error details
        #     related to VerifyAttestation.
        class VerifyAttestationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Credentials issued by GCP which are linked to the platform attestation. These
        # will be verified server-side as part of attestaion verification.
        # @!attribute [rw] service_account_id_tokens
        #   @return [::Array<::String>]
        #     Same as id_tokens, but as a string.
        class GcpCredentials
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to modify claims in the token to generate custom-purpose tokens.
        # @!attribute [rw] aws_principal_tags_options
        #   @return [::Google::Cloud::ConfidentialComputing::V1::AwsPrincipalTagsOptions]
        #     Optional. Options for AWS token type.
        # @!attribute [rw] audience
        #   @return [::String]
        #     Optional. Optional string to issue the token with a custom audience claim.
        #     Required if one or more nonces are specified.
        # @!attribute [rw] nonce
        #   @return [::Array<::String>]
        #     Optional. Optional parameter to place one or more nonces in the eat_nonce
        #     claim in the output token. The minimum size for JSON-encoded EATs is 10
        #     bytes and the maximum size is 74 bytes.
        # @!attribute [rw] token_type
        #   @return [::Google::Cloud::ConfidentialComputing::V1::TokenType]
        #     Optional. Optional token type to select what type of token to return.
        class TokenOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Token options that only apply to the AWS Principal Tags token type.
        # @!attribute [rw] allowed_principal_tags
        #   @return [::Google::Cloud::ConfidentialComputing::V1::AwsPrincipalTagsOptions::AllowedPrincipalTags]
        #     Optional. Principal tags to allow in the token.
        class AwsPrincipalTagsOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Allowed principal tags is used to define what principal tags will be
          # placed in the token.
          # @!attribute [rw] container_image_signatures
          #   @return [::Google::Cloud::ConfidentialComputing::V1::AwsPrincipalTagsOptions::AllowedPrincipalTags::ContainerImageSignatures]
          #     Optional. Container image signatures allowed in the token.
          class AllowedPrincipalTags
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Allowed Container Image Signatures. Key IDs are required to allow
            # this claim to fit within the narrow AWS IAM restrictions.
            # @!attribute [rw] key_ids
            #   @return [::Array<::String>]
            #     Optional. List of key ids to filter into the Principal tags. Only keys
            #     that have been validated and added to the token will be filtered into
            #     principal tags. Unrecognized key ids will be ignored.
            class ContainerImageSignatures
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # TPM2 data containing everything necessary to validate any platform state
        # measured into the TPM.
        # @!attribute [rw] quotes
        #   @return [::Array<::Google::Cloud::ConfidentialComputing::V1::TpmAttestation::Quote>]
        #     TPM2 PCR Quotes generated by calling TPM2_Quote on each PCR bank.
        # @!attribute [rw] tcg_event_log
        #   @return [::String]
        #     The binary TCG Event Log containing events measured into the TPM by the
        #     platform firmware and operating system. Formatted as described in the
        #     "TCG PC Client Platform Firmware Profile Specification".
        # @!attribute [rw] canonical_event_log
        #   @return [::String]
        #     An Event Log containing additional events measured into the TPM that are
        #     not already present in the tcg_event_log. Formatted as described in the
        #     "Canonical Event Log Format" TCG Specification.
        # @!attribute [rw] ak_cert
        #   @return [::String]
        #     DER-encoded X.509 certificate of the Attestation Key (otherwise known as
        #     an AK or a TPM restricted signing key) used to generate the quotes.
        # @!attribute [rw] cert_chain
        #   @return [::Array<::String>]
        #     List of DER-encoded X.509 certificates which, together with the ak_cert,
        #     chain back to a trusted Root Certificate.
        class TpmAttestation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information about Platform Control Registers (PCRs) including a signature
          # over their values, which can be used for remote validation.
          # @!attribute [rw] hash_algo
          #   @return [::Integer]
          #     The hash algorithm of the PCR bank being quoted, encoded as a TPM_ALG_ID
          # @!attribute [rw] pcr_values
          #   @return [::Google::Protobuf::Map{::Integer => ::String}]
          #     Raw binary values of each PCRs being quoted.
          # @!attribute [rw] raw_quote
          #   @return [::String]
          #     TPM2 quote, encoded as a TPMS_ATTEST
          # @!attribute [rw] raw_signature
          #   @return [::String]
          #     TPM2 signature, encoded as a TPMT_SIGNATURE
          class Quote
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::Integer]
            # @!attribute [rw] value
            #   @return [::String]
            class PcrValuesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # ConfidentialSpaceInfo contains information related to the Confidential Space
        # TEE.
        # @!attribute [rw] signed_entities
        #   @return [::Array<::Google::Cloud::ConfidentialComputing::V1::SignedEntity>]
        #     Optional. A list of signed entities containing container image signatures
        #     that can be used for server-side signature verification.
        class ConfidentialSpaceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SignedEntity represents an OCI image object containing everything necessary
        # to verify container image signatures.
        # @!attribute [rw] container_image_signatures
        #   @return [::Array<::Google::Cloud::ConfidentialComputing::V1::ContainerImageSignature>]
        #     Optional. A list of container image signatures attached to an OCI image
        #     object.
        class SignedEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ContainerImageSignature holds necessary metadata to verify a container image
        # signature.
        # @!attribute [rw] payload
        #   @return [::String]
        #     Optional. The binary signature payload following the SimpleSigning format
        #     https://github.com/sigstore/cosign/blob/main/specs/SIGNATURE_SPEC.md#simple-signing.
        #     This payload includes the container image digest.
        # @!attribute [rw] signature
        #   @return [::String]
        #     Optional. A signature over the payload.
        #     The container image digest is incorporated into the signature as follows:
        #     1. Generate a SimpleSigning format payload that includes the container
        #     image digest.
        #     2. Generate a signature over SHA256 digest of the payload.
        #     The signature generation process can be represented as follows:
        #     `Sign(sha256(SimpleSigningPayload(sha256(Image Manifest))))`
        # @!attribute [rw] public_key
        #   @return [::String]
        #     Optional. Reserved for future use.
        # @!attribute [rw] sig_alg
        #   @return [::Google::Cloud::ConfidentialComputing::V1::SigningAlgorithm]
        #     Optional. Reserved for future use.
        class ContainerImageSignature
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request for an attestation token, providing all the necessary information
        # needed for this service to verify the platform state of the requestor.
        # @!attribute [rw] td_ccel
        #   @return [::Google::Cloud::ConfidentialComputing::V1::TdxCcelAttestation]
        #     Input only. A TDX with CCEL and RTMR Attestation Quote.
        #
        #     Note: The following fields are mutually exclusive: `td_ccel`, `tpm_attestation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tpm_attestation
        #   @return [::Google::Cloud::ConfidentialComputing::V1::TpmAttestation]
        #     Input only. The TPM-specific data provided by the attesting platform,
        #     used to populate any of the claims regarding platform state.
        #
        #     Note: The following fields are mutually exclusive: `tpm_attestation`, `td_ccel`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] challenge
        #   @return [::String]
        #     Required. The name of the Challenge whose nonce was used to generate the
        #     attestation, in the format `projects/*/locations/*/challenges/*`. The
        #     provided Challenge will be consumed, and cannot be used again.
        # @!attribute [rw] gcp_credentials
        #   @return [::Google::Cloud::ConfidentialComputing::V1::GcpCredentials]
        #     Optional. Credentials used to populate the "emails" claim in the
        #     claims_token. If not present, token will not contain the "emails" claim.
        # @!attribute [rw] signed_entities
        #   @return [::Array<::Google::Cloud::ConfidentialComputing::V1::SignedEntity>]
        #     Optional. A list of signed entities containing container image signatures
        #     that can be used for server-side signature verification.
        # @!attribute [rw] gce_shielded_identity
        #   @return [::Google::Cloud::ConfidentialComputing::V1::GceShieldedIdentity]
        #     Optional. Information about the associated Compute Engine instance.
        #     Required for td_ccel requests only - tpm_attestation requests will provide
        #     this information in the attestation.
        # @!attribute [rw] options
        #   @return [::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest::ConfidentialSpaceOptions]
        #     Optional. A collection of fields that modify the token output.
        class VerifyConfidentialSpaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Token options for Confidential Space attestation.
          # @!attribute [rw] aws_principal_tags_options
          #   @return [::Google::Cloud::ConfidentialComputing::V1::AwsPrincipalTagsOptions]
          #     Optional. Options for the AWS token type.
          # @!attribute [rw] audience
          #   @return [::String]
          #     Optional. Optional string to issue the token with a custom audience
          #     claim. Required if custom nonces are specified.
          # @!attribute [rw] token_profile
          #   @return [::Google::Cloud::ConfidentialComputing::V1::TokenProfile]
          #     Optional. Optional specification for token claims profile.
          # @!attribute [rw] nonce
          #   @return [::Array<::String>]
          #     Optional. Optional parameter to place one or more nonces in the eat_nonce
          #     claim in the output token. The minimum size for JSON-encoded EATs is 10
          #     bytes and the maximum size is 74 bytes.
          # @!attribute [rw] signature_type
          #   @return [::Google::Cloud::ConfidentialComputing::V1::SignatureType]
          #     Optional. Optional specification for how to sign the attestation token.
          #     Defaults to SIGNATURE_TYPE_OIDC if unspecified.
          class ConfidentialSpaceOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # GceShieldedIdentity contains information about a Compute Engine instance.
        # @!attribute [rw] ak_cert
        #   @return [::String]
        #     Optional. DER-encoded X.509 certificate of the Attestation Key (otherwise
        #     known as an AK or a TPM restricted signing key) used to generate the
        #     quotes.
        # @!attribute [rw] ak_cert_chain
        #   @return [::Array<::String>]
        #     Optional. List of DER-encoded X.509 certificates which, together with the
        #     ak_cert, chain back to a trusted Root Certificate.
        class GceShieldedIdentity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VerifyConfidentialSpaceResponse is returned once a Confidential Space
        # attestation has been successfully verified, containing a signed token.
        # @!attribute [r] attestation_token
        #   @return [::String]
        #     Output only. The attestation token issued by this service. It contains
        #     specific platform claims based on the contents of the provided attestation.
        # @!attribute [r] partial_errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. A list of messages that carry the partial error details
        #     related to VerifyConfidentialSpace. This field is populated by errors
        #     during container image signature verification, which may reflect problems
        #     in the provided image signatures. This does not block the issuing of an
        #     attestation token, but the token will not contain claims for the failed
        #     image signatures.
        class VerifyConfidentialSpaceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request for an attestation token, providing all the necessary information
        # needed for this service to verify Confidential GKE platform state of the
        # requestor.
        # @!attribute [rw] tpm_attestation
        #   @return [::Google::Cloud::ConfidentialComputing::V1::TpmAttestation]
        #     The TPM-specific data provided by the attesting platform, used to
        #     populate any of the claims regarding platform state.
        # @!attribute [rw] challenge
        #   @return [::String]
        #     Required. The name of the Challenge whose nonce was used to generate the
        #     attestation, in the format projects/*/locations/*/challenges/*. The
        #     provided Challenge will be consumed, and cannot be used again.
        class VerifyConfidentialGkeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VerifyConfidentialGkeResponse response is returened once a Confidential GKE
        # attestation has been successfully verified, containing a signed OIDC token.
        # @!attribute [r] attestation_token
        #   @return [::String]
        #     Output only. The attestation token issued by this service for Confidential
        #     GKE. It contains specific platform claims based on the contents of the
        #     provided attestation.
        class VerifyConfidentialGkeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SigningAlgorithm enumerates all the supported signing algorithms.
        module SigningAlgorithm
          # Unspecified signing algorithm.
          SIGNING_ALGORITHM_UNSPECIFIED = 0

          # RSASSA-PSS with a SHA256 digest.
          RSASSA_PSS_SHA256 = 1

          # RSASSA-PKCS1 v1.5 with a SHA256 digest.
          RSASSA_PKCS1V15_SHA256 = 2

          # ECDSA on the P-256 Curve with a SHA256 digest.
          ECDSA_P256_SHA256 = 3
        end

        # Token type enum contains the different types of token responses Confidential
        # Space supports
        module TokenType
          # Unspecified token type
          TOKEN_TYPE_UNSPECIFIED = 0

          # OpenID Connect (OIDC) token type
          TOKEN_TYPE_OIDC = 1

          # Public Key Infrastructure (PKI) token type
          TOKEN_TYPE_PKI = 2

          # Limited claim token type for AWS integration
          TOKEN_TYPE_LIMITED_AWS = 3

          # Principal-tag-based token for AWS integration
          TOKEN_TYPE_AWS_PRINCIPALTAGS = 4
        end

        # SignatureType enumerates supported signature types for attestation tokens.
        module SignatureType
          # Unspecified signature type.
          SIGNATURE_TYPE_UNSPECIFIED = 0

          # Google OIDC signature.
          SIGNATURE_TYPE_OIDC = 1

          # Public Key Infrastructure (PKI) signature.
          SIGNATURE_TYPE_PKI = 2
        end

        # TokenProfile enumerates the supported token claims profiles.
        module TokenProfile
          # Unspecified token profile.
          TOKEN_PROFILE_UNSPECIFIED = 0

          # EAT claims.
          TOKEN_PROFILE_DEFAULT_EAT = 1

          # AWS Principal Tags claims.
          TOKEN_PROFILE_AWS = 2
        end
      end
    end
  end
end
