# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/confidentialcomputing/v1/service_pb"
require "google/cloud/confidential_computing/v1/confidential_computing/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module ConfidentialComputing
      module V1
        module ConfidentialComputing
          module Rest
            ##
            # REST client for the ConfidentialComputing service.
            #
            # Service describing handlers for resources
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "confidentialcomputing.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :confidential_computing_stub

              ##
              # Configure the ConfidentialComputing Client class.
              #
              # See {::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ConfidentialComputing clients
              #   ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ConfidentialComputing", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config.rpcs.create_challenge.timeout = 60.0
                  default_config.rpcs.create_challenge.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.verify_attestation.timeout = 60.0
                  default_config.rpcs.verify_attestation.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.verify_confidential_space.timeout = 60.0
                  default_config.rpcs.verify_confidential_space.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.verify_confidential_gke.timeout = 60.0
                  default_config.rpcs.verify_confidential_gke.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ConfidentialComputing Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @confidential_computing_stub.universe_domain
              end

              ##
              # Create a new ConfidentialComputing REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ConfidentialComputing client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @confidential_computing_stub = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @confidential_computing_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @confidential_computing_stub.endpoint
                  config.universe_domain = @confidential_computing_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @confidential_computing_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @confidential_computing_stub.logger
              end

              # Service calls

              ##
              # Creates a new Challenge in a given project and location.
              #
              # @overload create_challenge(request, options = nil)
              #   Pass arguments to `create_challenge` via a request object, either of type
              #   {::Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_challenge(parent: nil, challenge: nil)
              #   Pass arguments to `create_challenge` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location where the Challenge will be
              #     used, in the format `projects/*/locations/*`.
              #   @param challenge [::Google::Cloud::ConfidentialComputing::V1::Challenge, ::Hash]
              #     Required. The Challenge to be created. Currently this field can be empty as
              #     all the Challenge fields are set by the server.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ConfidentialComputing::V1::Challenge]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ConfidentialComputing::V1::Challenge]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/confidential_computing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest.new
              #
              #   # Call the create_challenge method.
              #   result = client.create_challenge request
              #
              #   # The returned object is of type Google::Cloud::ConfidentialComputing::V1::Challenge.
              #   p result
              #
              def create_challenge request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfidentialComputing::V1::CreateChallengeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_challenge.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ConfidentialComputing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_challenge.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_challenge.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @confidential_computing_stub.create_challenge request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Verifies the provided attestation info, returning a signed attestation
              # token.
              #
              # @overload verify_attestation(request, options = nil)
              #   Pass arguments to `verify_attestation` via a request object, either of type
              #   {::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload verify_attestation(td_ccel: nil, sev_snp_attestation: nil, challenge: nil, gcp_credentials: nil, tpm_attestation: nil, confidential_space_info: nil, token_options: nil, attester: nil)
              #   Pass arguments to `verify_attestation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param td_ccel [::Google::Cloud::ConfidentialComputing::V1::TdxCcelAttestation, ::Hash]
              #     Optional. A TDX with CCEL and RTMR Attestation Quote.
              #
              #     Note: The following parameters are mutually exclusive: `td_ccel`, `sev_snp_attestation`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param sev_snp_attestation [::Google::Cloud::ConfidentialComputing::V1::SevSnpAttestation, ::Hash]
              #     Optional. An SEV-SNP Attestation Report.
              #
              #     Note: The following parameters are mutually exclusive: `sev_snp_attestation`, `td_ccel`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param challenge [::String]
              #     Required. The name of the Challenge whose nonce was used to generate the
              #     attestation, in the format `projects/*/locations/*/challenges/*`. The
              #     provided Challenge will be consumed, and cannot be used again.
              #   @param gcp_credentials [::Google::Cloud::ConfidentialComputing::V1::GcpCredentials, ::Hash]
              #     Optional. Credentials used to populate the "emails" claim in the
              #     claims_token.
              #   @param tpm_attestation [::Google::Cloud::ConfidentialComputing::V1::TpmAttestation, ::Hash]
              #     Required. The TPM-specific data provided by the attesting platform, used to
              #     populate any of the claims regarding platform state.
              #   @param confidential_space_info [::Google::Cloud::ConfidentialComputing::V1::ConfidentialSpaceInfo, ::Hash]
              #     Optional. Optional information related to the Confidential Space TEE.
              #   @param token_options [::Google::Cloud::ConfidentialComputing::V1::TokenOptions, ::Hash]
              #     Optional. A collection of optional, workload-specified claims that modify
              #     the token output.
              #   @param attester [::String]
              #     Optional. An optional indicator of the attester, only applies to certain
              #     products.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/confidential_computing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest.new
              #
              #   # Call the verify_attestation method.
              #   result = client.verify_attestation request
              #
              #   # The returned object is of type Google::Cloud::ConfidentialComputing::V1::VerifyAttestationResponse.
              #   p result
              #
              def verify_attestation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfidentialComputing::V1::VerifyAttestationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.verify_attestation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ConfidentialComputing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.verify_attestation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.verify_attestation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @confidential_computing_stub.verify_attestation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Verifies whether the provided attestation info is valid, returning a signed
              # attestation token if so.
              #
              # @overload verify_confidential_space(request, options = nil)
              #   Pass arguments to `verify_confidential_space` via a request object, either of type
              #   {::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload verify_confidential_space(td_ccel: nil, tpm_attestation: nil, challenge: nil, gcp_credentials: nil, signed_entities: nil, gce_shielded_identity: nil, options: nil)
              #   Pass arguments to `verify_confidential_space` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param td_ccel [::Google::Cloud::ConfidentialComputing::V1::TdxCcelAttestation, ::Hash]
              #     Input only. A TDX with CCEL and RTMR Attestation Quote.
              #
              #     Note: The following parameters are mutually exclusive: `td_ccel`, `tpm_attestation`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param tpm_attestation [::Google::Cloud::ConfidentialComputing::V1::TpmAttestation, ::Hash]
              #     Input only. The TPM-specific data provided by the attesting platform,
              #     used to populate any of the claims regarding platform state.
              #
              #     Note: The following parameters are mutually exclusive: `tpm_attestation`, `td_ccel`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param challenge [::String]
              #     Required. The name of the Challenge whose nonce was used to generate the
              #     attestation, in the format `projects/*/locations/*/challenges/*`. The
              #     provided Challenge will be consumed, and cannot be used again.
              #   @param gcp_credentials [::Google::Cloud::ConfidentialComputing::V1::GcpCredentials, ::Hash]
              #     Optional. Credentials used to populate the "emails" claim in the
              #     claims_token. If not present, token will not contain the "emails" claim.
              #   @param signed_entities [::Array<::Google::Cloud::ConfidentialComputing::V1::SignedEntity, ::Hash>]
              #     Optional. A list of signed entities containing container image signatures
              #     that can be used for server-side signature verification.
              #   @param gce_shielded_identity [::Google::Cloud::ConfidentialComputing::V1::GceShieldedIdentity, ::Hash]
              #     Optional. Information about the associated Compute Engine instance.
              #     Required for td_ccel requests only - tpm_attestation requests will provide
              #     this information in the attestation.
              #   @param options [::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest::ConfidentialSpaceOptions, ::Hash]
              #     Optional. A collection of fields that modify the token output.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/confidential_computing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest.new
              #
              #   # Call the verify_confidential_space method.
              #   result = client.verify_confidential_space request
              #
              #   # The returned object is of type Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceResponse.
              #   p result
              #
              def verify_confidential_space request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialSpaceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.verify_confidential_space.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ConfidentialComputing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.verify_confidential_space.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.verify_confidential_space.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @confidential_computing_stub.verify_confidential_space request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Verifies the provided Confidential GKE attestation info, returning a signed
              # OIDC token.
              #
              # @overload verify_confidential_gke(request, options = nil)
              #   Pass arguments to `verify_confidential_gke` via a request object, either of type
              #   {::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload verify_confidential_gke(tpm_attestation: nil, challenge: nil)
              #   Pass arguments to `verify_confidential_gke` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tpm_attestation [::Google::Cloud::ConfidentialComputing::V1::TpmAttestation, ::Hash]
              #     The TPM-specific data provided by the attesting platform, used to
              #     populate any of the claims regarding platform state.
              #   @param challenge [::String]
              #     Required. The name of the Challenge whose nonce was used to generate the
              #     attestation, in the format projects/*/locations/*/challenges/*. The
              #     provided Challenge will be consumed, and cannot be used again.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/confidential_computing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest.new
              #
              #   # Call the verify_confidential_gke method.
              #   result = client.verify_confidential_gke request
              #
              #   # The returned object is of type Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeResponse.
              #   p result
              #
              def verify_confidential_gke request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ConfidentialComputing::V1::VerifyConfidentialGkeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.verify_confidential_gke.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ConfidentialComputing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.verify_confidential_gke.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.verify_confidential_gke.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @confidential_computing_stub.verify_confidential_gke request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ConfidentialComputing REST API.
              #
              # This class represents the configuration for ConfidentialComputing REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_challenge to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_challenge.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ConfidentialComputing::V1::ConfidentialComputing::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_challenge.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "confidentialcomputing.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ConfidentialComputing API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_challenge`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_challenge
                  ##
                  # RPC-specific configuration for `verify_attestation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :verify_attestation
                  ##
                  # RPC-specific configuration for `verify_confidential_space`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :verify_confidential_space
                  ##
                  # RPC-specific configuration for `verify_confidential_gke`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :verify_confidential_gke

                  # @private
                  def initialize parent_rpcs = nil
                    create_challenge_config = parent_rpcs.create_challenge if parent_rpcs.respond_to? :create_challenge
                    @create_challenge = ::Gapic::Config::Method.new create_challenge_config
                    verify_attestation_config = parent_rpcs.verify_attestation if parent_rpcs.respond_to? :verify_attestation
                    @verify_attestation = ::Gapic::Config::Method.new verify_attestation_config
                    verify_confidential_space_config = parent_rpcs.verify_confidential_space if parent_rpcs.respond_to? :verify_confidential_space
                    @verify_confidential_space = ::Gapic::Config::Method.new verify_confidential_space_config
                    verify_confidential_gke_config = parent_rpcs.verify_confidential_gke if parent_rpcs.respond_to? :verify_confidential_gke
                    @verify_confidential_gke = ::Gapic::Config::Method.new verify_confidential_gke_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
