# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/compute/v1/compute_pb"
require "google/cloud/compute/v1/routers/rest"


class ::Google::Cloud::Compute::V1::Routers::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_aggregated_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::RouterAggregatedList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    include_all_scopes = true
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    service_project_number = 42

    aggregated_list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_aggregated_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, aggregated_list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.aggregated_list({ filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.aggregated_list filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.aggregated_list ::Google::Cloud::Compute::V1::AggregatedListRoutersRequest.new(filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.aggregated_list({ filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.aggregated_list(::Google::Cloud::Compute::V1::AggregatedListRoutersRequest.new(filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, aggregated_list_client_stub.call_count
      end
    end
  end

  def test_delete
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    request_id = "hello world"
    router = "hello world"

    delete_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_delete_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete({ project: project, region: region, request_id: request_id, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete project: project, region: region, request_id: request_id, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete ::Google::Cloud::Compute::V1::DeleteRouterRequest.new(project: project, region: region, request_id: request_id, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete({ project: project, region: region, request_id: request_id, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete(::Google::Cloud::Compute::V1::DeleteRouterRequest.new(project: project, region: region, request_id: request_id, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_client_stub.call_count
      end
    end
  end

  def test_delete_route_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    policy = "hello world"
    project = "hello world"
    region = "hello world"
    request_id = "hello world"
    router = "hello world"

    delete_route_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_delete_route_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_route_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_route_policy({ policy: policy, project: project, region: region, request_id: request_id, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_route_policy policy: policy, project: project, region: region, request_id: request_id, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_route_policy ::Google::Cloud::Compute::V1::DeleteRoutePolicyRouterRequest.new(policy: policy, project: project, region: region, request_id: request_id, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_route_policy({ policy: policy, project: project, region: region, request_id: request_id, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_route_policy(::Google::Cloud::Compute::V1::DeleteRoutePolicyRouterRequest.new(policy: policy, project: project, region: region, request_id: request_id, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_route_policy_client_stub.call_count
      end
    end
  end

  def test_get
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Router.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    router = "hello world"

    get_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_get_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get({ project: project, region: region, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get project: project, region: region, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get ::Google::Cloud::Compute::V1::GetRouterRequest.new(project: project, region: region, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get({ project: project, region: region, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get(::Google::Cloud::Compute::V1::GetRouterRequest.new(project: project, region: region, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_client_stub.call_count
      end
    end
  end

  def test_get_nat_ip_info
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::NatIpInfoResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    nat_name = "hello world"
    project = "hello world"
    region = "hello world"
    router = "hello world"

    get_nat_ip_info_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_get_nat_ip_info_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_nat_ip_info_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_nat_ip_info({ nat_name: nat_name, project: project, region: region, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_nat_ip_info nat_name: nat_name, project: project, region: region, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_nat_ip_info ::Google::Cloud::Compute::V1::GetNatIpInfoRouterRequest.new(nat_name: nat_name, project: project, region: region, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_nat_ip_info({ nat_name: nat_name, project: project, region: region, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_nat_ip_info(::Google::Cloud::Compute::V1::GetNatIpInfoRouterRequest.new(nat_name: nat_name, project: project, region: region, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_nat_ip_info_client_stub.call_count
      end
    end
  end

  def test_get_nat_mapping_info
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::VmEndpointNatMappingsList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    nat_name = "hello world"
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    region = "hello world"
    return_partial_success = true
    router = "hello world"

    get_nat_mapping_info_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_get_nat_mapping_info_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_nat_mapping_info_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_nat_mapping_info({ filter: filter, max_results: max_results, nat_name: nat_name, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_nat_mapping_info filter: filter, max_results: max_results, nat_name: nat_name, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_nat_mapping_info ::Google::Cloud::Compute::V1::GetNatMappingInfoRoutersRequest.new(filter: filter, max_results: max_results, nat_name: nat_name, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_nat_mapping_info({ filter: filter, max_results: max_results, nat_name: nat_name, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_nat_mapping_info(::Google::Cloud::Compute::V1::GetNatMappingInfoRoutersRequest.new(filter: filter, max_results: max_results, nat_name: nat_name, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_nat_mapping_info_client_stub.call_count
      end
    end
  end

  def test_get_route_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::RoutersGetRoutePolicyResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    policy = "hello world"
    project = "hello world"
    region = "hello world"
    router = "hello world"

    get_route_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_get_route_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_route_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_route_policy({ policy: policy, project: project, region: region, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_route_policy policy: policy, project: project, region: region, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_route_policy ::Google::Cloud::Compute::V1::GetRoutePolicyRouterRequest.new(policy: policy, project: project, region: region, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_route_policy({ policy: policy, project: project, region: region, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_route_policy(::Google::Cloud::Compute::V1::GetRoutePolicyRouterRequest.new(policy: policy, project: project, region: region, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_route_policy_client_stub.call_count
      end
    end
  end

  def test_get_router_status
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::RouterStatusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    router = "hello world"

    get_router_status_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_get_router_status_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_router_status_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_router_status({ project: project, region: region, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_router_status project: project, region: region, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_router_status ::Google::Cloud::Compute::V1::GetRouterStatusRouterRequest.new(project: project, region: region, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_router_status({ project: project, region: region, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_router_status(::Google::Cloud::Compute::V1::GetRouterStatusRouterRequest.new(project: project, region: region, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_router_status_client_stub.call_count
      end
    end
  end

  def test_insert
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    request_id = "hello world"
    router_resource = {}

    insert_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_insert_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, insert_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.insert({ project: project, region: region, request_id: request_id, router_resource: router_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.insert project: project, region: region, request_id: request_id, router_resource: router_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.insert ::Google::Cloud::Compute::V1::InsertRouterRequest.new(project: project, region: region, request_id: request_id, router_resource: router_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.insert({ project: project, region: region, request_id: request_id, router_resource: router_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.insert(::Google::Cloud::Compute::V1::InsertRouterRequest.new(project: project, region: region, request_id: request_id, router_resource: router_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, insert_client_stub.call_count
      end
    end
  end

  def test_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::RouterList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    region = "hello world"
    return_partial_success = true

    list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list ::Google::Cloud::Compute::V1::ListRoutersRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list(::Google::Cloud::Compute::V1::ListRoutersRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_client_stub.call_count
      end
    end
  end

  def test_list_bgp_routes
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::RoutersListBgpRoutes.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    address_family = "hello world"
    destination_prefix = "hello world"
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    peer = "hello world"
    policy_applied = true
    project = "hello world"
    region = "hello world"
    return_partial_success = true
    route_type = "hello world"
    router = "hello world"

    list_bgp_routes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_list_bgp_routes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_bgp_routes_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_bgp_routes({ address_family: address_family, destination_prefix: destination_prefix, filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, peer: peer, policy_applied: policy_applied, project: project, region: region, return_partial_success: return_partial_success, route_type: route_type, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_bgp_routes address_family: address_family, destination_prefix: destination_prefix, filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, peer: peer, policy_applied: policy_applied, project: project, region: region, return_partial_success: return_partial_success, route_type: route_type, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_bgp_routes ::Google::Cloud::Compute::V1::ListBgpRoutesRoutersRequest.new(address_family: address_family, destination_prefix: destination_prefix, filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, peer: peer, policy_applied: policy_applied, project: project, region: region, return_partial_success: return_partial_success, route_type: route_type, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_bgp_routes({ address_family: address_family, destination_prefix: destination_prefix, filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, peer: peer, policy_applied: policy_applied, project: project, region: region, return_partial_success: return_partial_success, route_type: route_type, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_bgp_routes(::Google::Cloud::Compute::V1::ListBgpRoutesRoutersRequest.new(address_family: address_family, destination_prefix: destination_prefix, filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, peer: peer, policy_applied: policy_applied, project: project, region: region, return_partial_success: return_partial_success, route_type: route_type, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_bgp_routes_client_stub.call_count
      end
    end
  end

  def test_list_route_policies
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::RoutersListRoutePolicies.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    region = "hello world"
    return_partial_success = true
    router = "hello world"

    list_route_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_list_route_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_route_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_route_policies({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_route_policies filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_route_policies ::Google::Cloud::Compute::V1::ListRoutePoliciesRoutersRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_route_policies({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_route_policies(::Google::Cloud::Compute::V1::ListRoutePoliciesRoutersRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, region: region, return_partial_success: return_partial_success, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_route_policies_client_stub.call_count
      end
    end
  end

  def test_patch
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    request_id = "hello world"
    router = "hello world"
    router_resource = {}

    patch_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_patch_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, patch_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.patch({ project: project, region: region, request_id: request_id, router: router, router_resource: router_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.patch project: project, region: region, request_id: request_id, router: router, router_resource: router_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.patch ::Google::Cloud::Compute::V1::PatchRouterRequest.new(project: project, region: region, request_id: request_id, router: router, router_resource: router_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.patch({ project: project, region: region, request_id: request_id, router: router, router_resource: router_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.patch(::Google::Cloud::Compute::V1::PatchRouterRequest.new(project: project, region: region, request_id: request_id, router: router, router_resource: router_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, patch_client_stub.call_count
      end
    end
  end

  def test_patch_route_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    request_id = "hello world"
    route_policy_resource = {}
    router = "hello world"

    patch_route_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_patch_route_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, patch_route_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.patch_route_policy({ project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.patch_route_policy project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.patch_route_policy ::Google::Cloud::Compute::V1::PatchRoutePolicyRouterRequest.new(project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.patch_route_policy({ project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.patch_route_policy(::Google::Cloud::Compute::V1::PatchRoutePolicyRouterRequest.new(project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, patch_route_policy_client_stub.call_count
      end
    end
  end

  def test_preview
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::RoutersPreviewResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    router = "hello world"
    router_resource = {}

    preview_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_preview_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, preview_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.preview({ project: project, region: region, router: router, router_resource: router_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.preview project: project, region: region, router: router, router_resource: router_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.preview ::Google::Cloud::Compute::V1::PreviewRouterRequest.new(project: project, region: region, router: router, router_resource: router_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.preview({ project: project, region: region, router: router, router_resource: router_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.preview(::Google::Cloud::Compute::V1::PreviewRouterRequest.new(project: project, region: region, router: router, router_resource: router_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, preview_client_stub.call_count
      end
    end
  end

  def test_update
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    request_id = "hello world"
    router = "hello world"
    router_resource = {}

    update_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_update_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update({ project: project, region: region, request_id: request_id, router: router, router_resource: router_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update project: project, region: region, request_id: request_id, router: router, router_resource: router_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update ::Google::Cloud::Compute::V1::UpdateRouterRequest.new(project: project, region: region, request_id: request_id, router: router, router_resource: router_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update({ project: project, region: region, request_id: request_id, router: router, router_resource: router_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update(::Google::Cloud::Compute::V1::UpdateRouterRequest.new(project: project, region: region, request_id: request_id, router: router, router_resource: router_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_client_stub.call_count
      end
    end
  end

  def test_update_route_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    region = "hello world"
    request_id = "hello world"
    route_policy_resource = {}
    router = "hello world"

    update_route_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Routers::Rest::ServiceStub.stub :transcode_update_route_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_route_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_route_policy({ project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_route_policy project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_route_policy ::Google::Cloud::Compute::V1::UpdateRoutePolicyRouterRequest.new(project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_route_policy({ project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_route_policy(::Google::Cloud::Compute::V1::UpdateRoutePolicyRouterRequest.new(project: project, region: region, request_id: request_id, route_policy_resource: route_policy_resource, router: router), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_route_policy_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Compute::V1::Routers::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Compute::V1::Routers::Rest::Client::Configuration, config
  end
end
