# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/compute/v1/compute_pb"
require "google/cloud/compute/v1/projects/rest"


class ::Google::Cloud::Compute::V1::Projects::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_disable_xpn_host
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    request_id = "hello world"

    disable_xpn_host_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_disable_xpn_host_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_xpn_host_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_xpn_host({ project: project, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_xpn_host project: project, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_xpn_host ::Google::Cloud::Compute::V1::DisableXpnHostProjectRequest.new(project: project, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_xpn_host({ project: project, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_xpn_host(::Google::Cloud::Compute::V1::DisableXpnHostProjectRequest.new(project: project, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_xpn_host_client_stub.call_count
      end
    end
  end

  def test_disable_xpn_resource
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    projects_disable_xpn_resource_request_resource = {}
    request_id = "hello world"

    disable_xpn_resource_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_disable_xpn_resource_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_xpn_resource_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_xpn_resource({ project: project, projects_disable_xpn_resource_request_resource: projects_disable_xpn_resource_request_resource, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_xpn_resource project: project, projects_disable_xpn_resource_request_resource: projects_disable_xpn_resource_request_resource, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_xpn_resource ::Google::Cloud::Compute::V1::DisableXpnResourceProjectRequest.new(project: project, projects_disable_xpn_resource_request_resource: projects_disable_xpn_resource_request_resource, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_xpn_resource({ project: project, projects_disable_xpn_resource_request_resource: projects_disable_xpn_resource_request_resource, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_xpn_resource(::Google::Cloud::Compute::V1::DisableXpnResourceProjectRequest.new(project: project, projects_disable_xpn_resource_request_resource: projects_disable_xpn_resource_request_resource, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_xpn_resource_client_stub.call_count
      end
    end
  end

  def test_enable_xpn_host
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    request_id = "hello world"

    enable_xpn_host_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_enable_xpn_host_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_xpn_host_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_xpn_host({ project: project, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_xpn_host project: project, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_xpn_host ::Google::Cloud::Compute::V1::EnableXpnHostProjectRequest.new(project: project, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_xpn_host({ project: project, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_xpn_host(::Google::Cloud::Compute::V1::EnableXpnHostProjectRequest.new(project: project, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_xpn_host_client_stub.call_count
      end
    end
  end

  def test_enable_xpn_resource
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    projects_enable_xpn_resource_request_resource = {}
    request_id = "hello world"

    enable_xpn_resource_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_enable_xpn_resource_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_xpn_resource_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_xpn_resource({ project: project, projects_enable_xpn_resource_request_resource: projects_enable_xpn_resource_request_resource, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_xpn_resource project: project, projects_enable_xpn_resource_request_resource: projects_enable_xpn_resource_request_resource, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_xpn_resource ::Google::Cloud::Compute::V1::EnableXpnResourceProjectRequest.new(project: project, projects_enable_xpn_resource_request_resource: projects_enable_xpn_resource_request_resource, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_xpn_resource({ project: project, projects_enable_xpn_resource_request_resource: projects_enable_xpn_resource_request_resource, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_xpn_resource(::Google::Cloud::Compute::V1::EnableXpnResourceProjectRequest.new(project: project, projects_enable_xpn_resource_request_resource: projects_enable_xpn_resource_request_resource, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_xpn_resource_client_stub.call_count
      end
    end
  end

  def test_get
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Project.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"

    get_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_get_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get({ project: project }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get project: project do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get ::Google::Cloud::Compute::V1::GetProjectRequest.new(project: project) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get({ project: project }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get(::Google::Cloud::Compute::V1::GetProjectRequest.new(project: project), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_client_stub.call_count
      end
    end
  end

  def test_get_xpn_host
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Project.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"

    get_xpn_host_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_get_xpn_host_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_xpn_host_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_xpn_host({ project: project }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_xpn_host project: project do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_xpn_host ::Google::Cloud::Compute::V1::GetXpnHostProjectRequest.new(project: project) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_xpn_host({ project: project }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_xpn_host(::Google::Cloud::Compute::V1::GetXpnHostProjectRequest.new(project: project), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_xpn_host_client_stub.call_count
      end
    end
  end

  def test_get_xpn_resources
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::ProjectsGetXpnResources.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true

    get_xpn_resources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_get_xpn_resources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_xpn_resources_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_xpn_resources({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_xpn_resources filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_xpn_resources ::Google::Cloud::Compute::V1::GetXpnResourcesProjectsRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_xpn_resources({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_xpn_resources(::Google::Cloud::Compute::V1::GetXpnResourcesProjectsRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_xpn_resources_client_stub.call_count
      end
    end
  end

  def test_list_xpn_hosts
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::XpnHostList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    projects_list_xpn_hosts_request_resource = {}
    return_partial_success = true

    list_xpn_hosts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_list_xpn_hosts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_xpn_hosts_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_xpn_hosts({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, projects_list_xpn_hosts_request_resource: projects_list_xpn_hosts_request_resource, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_xpn_hosts filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, projects_list_xpn_hosts_request_resource: projects_list_xpn_hosts_request_resource, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_xpn_hosts ::Google::Cloud::Compute::V1::ListXpnHostsProjectsRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, projects_list_xpn_hosts_request_resource: projects_list_xpn_hosts_request_resource, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_xpn_hosts({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, projects_list_xpn_hosts_request_resource: projects_list_xpn_hosts_request_resource, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_xpn_hosts(::Google::Cloud::Compute::V1::ListXpnHostsProjectsRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, projects_list_xpn_hosts_request_resource: projects_list_xpn_hosts_request_resource, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_xpn_hosts_client_stub.call_count
      end
    end
  end

  def test_move_disk
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk_move_request_resource = {}
    project = "hello world"
    request_id = "hello world"

    move_disk_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_move_disk_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, move_disk_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.move_disk({ disk_move_request_resource: disk_move_request_resource, project: project, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.move_disk disk_move_request_resource: disk_move_request_resource, project: project, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.move_disk ::Google::Cloud::Compute::V1::MoveDiskProjectRequest.new(disk_move_request_resource: disk_move_request_resource, project: project, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.move_disk({ disk_move_request_resource: disk_move_request_resource, project: project, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.move_disk(::Google::Cloud::Compute::V1::MoveDiskProjectRequest.new(disk_move_request_resource: disk_move_request_resource, project: project, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, move_disk_client_stub.call_count
      end
    end
  end

  def test_move_instance
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_move_request_resource = {}
    project = "hello world"
    request_id = "hello world"

    move_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_move_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, move_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.move_instance({ instance_move_request_resource: instance_move_request_resource, project: project, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.move_instance instance_move_request_resource: instance_move_request_resource, project: project, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.move_instance ::Google::Cloud::Compute::V1::MoveInstanceProjectRequest.new(instance_move_request_resource: instance_move_request_resource, project: project, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.move_instance({ instance_move_request_resource: instance_move_request_resource, project: project, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.move_instance(::Google::Cloud::Compute::V1::MoveInstanceProjectRequest.new(instance_move_request_resource: instance_move_request_resource, project: project, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, move_instance_client_stub.call_count
      end
    end
  end

  def test_set_cloud_armor_tier
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    projects_set_cloud_armor_tier_request_resource = {}
    request_id = "hello world"

    set_cloud_armor_tier_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_set_cloud_armor_tier_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_cloud_armor_tier_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_cloud_armor_tier({ project: project, projects_set_cloud_armor_tier_request_resource: projects_set_cloud_armor_tier_request_resource, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_cloud_armor_tier project: project, projects_set_cloud_armor_tier_request_resource: projects_set_cloud_armor_tier_request_resource, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_cloud_armor_tier ::Google::Cloud::Compute::V1::SetCloudArmorTierProjectRequest.new(project: project, projects_set_cloud_armor_tier_request_resource: projects_set_cloud_armor_tier_request_resource, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_cloud_armor_tier({ project: project, projects_set_cloud_armor_tier_request_resource: projects_set_cloud_armor_tier_request_resource, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_cloud_armor_tier(::Google::Cloud::Compute::V1::SetCloudArmorTierProjectRequest.new(project: project, projects_set_cloud_armor_tier_request_resource: projects_set_cloud_armor_tier_request_resource, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_cloud_armor_tier_client_stub.call_count
      end
    end
  end

  def test_set_common_instance_metadata
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    metadata_resource = {}
    project = "hello world"
    request_id = "hello world"

    set_common_instance_metadata_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_set_common_instance_metadata_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_common_instance_metadata_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_common_instance_metadata({ metadata_resource: metadata_resource, project: project, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_common_instance_metadata metadata_resource: metadata_resource, project: project, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_common_instance_metadata ::Google::Cloud::Compute::V1::SetCommonInstanceMetadataProjectRequest.new(metadata_resource: metadata_resource, project: project, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_common_instance_metadata({ metadata_resource: metadata_resource, project: project, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_common_instance_metadata(::Google::Cloud::Compute::V1::SetCommonInstanceMetadataProjectRequest.new(metadata_resource: metadata_resource, project: project, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_common_instance_metadata_client_stub.call_count
      end
    end
  end

  def test_set_default_network_tier
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    projects_set_default_network_tier_request_resource = {}
    request_id = "hello world"

    set_default_network_tier_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_set_default_network_tier_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_default_network_tier_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_default_network_tier({ project: project, projects_set_default_network_tier_request_resource: projects_set_default_network_tier_request_resource, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_default_network_tier project: project, projects_set_default_network_tier_request_resource: projects_set_default_network_tier_request_resource, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_default_network_tier ::Google::Cloud::Compute::V1::SetDefaultNetworkTierProjectRequest.new(project: project, projects_set_default_network_tier_request_resource: projects_set_default_network_tier_request_resource, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_default_network_tier({ project: project, projects_set_default_network_tier_request_resource: projects_set_default_network_tier_request_resource, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_default_network_tier(::Google::Cloud::Compute::V1::SetDefaultNetworkTierProjectRequest.new(project: project, projects_set_default_network_tier_request_resource: projects_set_default_network_tier_request_resource, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_default_network_tier_client_stub.call_count
      end
    end
  end

  def test_set_usage_export_bucket
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    request_id = "hello world"
    usage_export_location_resource = {}

    set_usage_export_bucket_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Projects::Rest::ServiceStub.stub :transcode_set_usage_export_bucket_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_usage_export_bucket_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_usage_export_bucket({ project: project, request_id: request_id, usage_export_location_resource: usage_export_location_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_usage_export_bucket project: project, request_id: request_id, usage_export_location_resource: usage_export_location_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_usage_export_bucket ::Google::Cloud::Compute::V1::SetUsageExportBucketProjectRequest.new(project: project, request_id: request_id, usage_export_location_resource: usage_export_location_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_usage_export_bucket({ project: project, request_id: request_id, usage_export_location_resource: usage_export_location_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_usage_export_bucket(::Google::Cloud::Compute::V1::SetUsageExportBucketProjectRequest.new(project: project, request_id: request_id, usage_export_location_resource: usage_export_location_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_usage_export_bucket_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Compute::V1::Projects::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Compute::V1::Projects::Rest::Client::Configuration, config
  end
end
