# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/compute/v1/compute_pb"
require "google/cloud/compute/v1/instances/rest"


class ::Google::Cloud::Compute::V1::Instances::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_add_access_config
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    access_config_resource = {}
    instance = "hello world"
    network_interface = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    add_access_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_add_access_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_access_config_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_access_config({ access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_access_config access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_access_config ::Google::Cloud::Compute::V1::AddAccessConfigInstanceRequest.new(access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_access_config({ access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_access_config(::Google::Cloud::Compute::V1::AddAccessConfigInstanceRequest.new(access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_access_config_client_stub.call_count
      end
    end
  end

  def test_add_network_interface
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    network_interface_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    add_network_interface_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_add_network_interface_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_network_interface_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_network_interface({ instance: instance, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_network_interface instance: instance, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_network_interface ::Google::Cloud::Compute::V1::AddNetworkInterfaceInstanceRequest.new(instance: instance, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_network_interface({ instance: instance, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_network_interface(::Google::Cloud::Compute::V1::AddNetworkInterfaceInstanceRequest.new(instance: instance, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_network_interface_client_stub.call_count
      end
    end
  end

  def test_add_resource_policies
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_add_resource_policies_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    add_resource_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_add_resource_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_resource_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_resource_policies({ instance: instance, instances_add_resource_policies_request_resource: instances_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_resource_policies instance: instance, instances_add_resource_policies_request_resource: instances_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_resource_policies ::Google::Cloud::Compute::V1::AddResourcePoliciesInstanceRequest.new(instance: instance, instances_add_resource_policies_request_resource: instances_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_resource_policies({ instance: instance, instances_add_resource_policies_request_resource: instances_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_resource_policies(::Google::Cloud::Compute::V1::AddResourcePoliciesInstanceRequest.new(instance: instance, instances_add_resource_policies_request_resource: instances_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_resource_policies_client_stub.call_count
      end
    end
  end

  def test_aggregated_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceAggregatedList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    include_all_scopes = true
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    service_project_number = 42

    aggregated_list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_aggregated_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, aggregated_list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.aggregated_list({ filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.aggregated_list filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.aggregated_list ::Google::Cloud::Compute::V1::AggregatedListInstancesRequest.new(filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.aggregated_list({ filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.aggregated_list(::Google::Cloud::Compute::V1::AggregatedListInstancesRequest.new(filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, aggregated_list_client_stub.call_count
      end
    end
  end

  def test_attach_disk
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    attached_disk_resource = {}
    force_attach = true
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    attach_disk_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_attach_disk_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, attach_disk_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.attach_disk({ attached_disk_resource: attached_disk_resource, force_attach: force_attach, instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.attach_disk attached_disk_resource: attached_disk_resource, force_attach: force_attach, instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.attach_disk ::Google::Cloud::Compute::V1::AttachDiskInstanceRequest.new(attached_disk_resource: attached_disk_resource, force_attach: force_attach, instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.attach_disk({ attached_disk_resource: attached_disk_resource, force_attach: force_attach, instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.attach_disk(::Google::Cloud::Compute::V1::AttachDiskInstanceRequest.new(attached_disk_resource: attached_disk_resource, force_attach: force_attach, instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, attach_disk_client_stub.call_count
      end
    end
  end

  def test_bulk_insert
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    bulk_insert_instance_resource_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    bulk_insert_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_bulk_insert_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_insert_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_insert({ bulk_insert_instance_resource_resource: bulk_insert_instance_resource_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_insert bulk_insert_instance_resource_resource: bulk_insert_instance_resource_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_insert ::Google::Cloud::Compute::V1::BulkInsertInstanceRequest.new(bulk_insert_instance_resource_resource: bulk_insert_instance_resource_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_insert({ bulk_insert_instance_resource_resource: bulk_insert_instance_resource_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_insert(::Google::Cloud::Compute::V1::BulkInsertInstanceRequest.new(bulk_insert_instance_resource_resource: bulk_insert_instance_resource_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_insert_client_stub.call_count
      end
    end
  end

  def test_delete
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    delete_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_delete_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete({ instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete ::Google::Cloud::Compute::V1::DeleteInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete({ instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete(::Google::Cloud::Compute::V1::DeleteInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_client_stub.call_count
      end
    end
  end

  def test_delete_access_config
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    access_config = "hello world"
    instance = "hello world"
    network_interface = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    delete_access_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_delete_access_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_access_config_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_access_config({ access_config: access_config, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_access_config access_config: access_config, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_access_config ::Google::Cloud::Compute::V1::DeleteAccessConfigInstanceRequest.new(access_config: access_config, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_access_config({ access_config: access_config, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_access_config(::Google::Cloud::Compute::V1::DeleteAccessConfigInstanceRequest.new(access_config: access_config, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_access_config_client_stub.call_count
      end
    end
  end

  def test_delete_network_interface
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    network_interface_name = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    delete_network_interface_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_delete_network_interface_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_network_interface_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_network_interface({ instance: instance, network_interface_name: network_interface_name, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_network_interface instance: instance, network_interface_name: network_interface_name, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_network_interface ::Google::Cloud::Compute::V1::DeleteNetworkInterfaceInstanceRequest.new(instance: instance, network_interface_name: network_interface_name, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_network_interface({ instance: instance, network_interface_name: network_interface_name, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_network_interface(::Google::Cloud::Compute::V1::DeleteNetworkInterfaceInstanceRequest.new(instance: instance, network_interface_name: network_interface_name, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_network_interface_client_stub.call_count
      end
    end
  end

  def test_detach_disk
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    device_name = "hello world"
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    detach_disk_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_detach_disk_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, detach_disk_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.detach_disk({ device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.detach_disk device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.detach_disk ::Google::Cloud::Compute::V1::DetachDiskInstanceRequest.new(device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.detach_disk({ device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.detach_disk(::Google::Cloud::Compute::V1::DetachDiskInstanceRequest.new(device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, detach_disk_client_stub.call_count
      end
    end
  end

  def test_get
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Instance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    zone = "hello world"

    get_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_get_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get({ instance: instance, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get instance: instance, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get ::Google::Cloud::Compute::V1::GetInstanceRequest.new(instance: instance, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get({ instance: instance, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get(::Google::Cloud::Compute::V1::GetInstanceRequest.new(instance: instance, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_client_stub.call_count
      end
    end
  end

  def test_get_effective_firewalls
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstancesGetEffectiveFirewallsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    network_interface = "hello world"
    project = "hello world"
    zone = "hello world"

    get_effective_firewalls_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_get_effective_firewalls_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_effective_firewalls_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_effective_firewalls({ instance: instance, network_interface: network_interface, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_effective_firewalls instance: instance, network_interface: network_interface, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_effective_firewalls ::Google::Cloud::Compute::V1::GetEffectiveFirewallsInstanceRequest.new(instance: instance, network_interface: network_interface, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_effective_firewalls({ instance: instance, network_interface: network_interface, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_effective_firewalls(::Google::Cloud::Compute::V1::GetEffectiveFirewallsInstanceRequest.new(instance: instance, network_interface: network_interface, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_effective_firewalls_client_stub.call_count
      end
    end
  end

  def test_get_guest_attributes
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::GuestAttributes.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    query_path = "hello world"
    variable_key = "hello world"
    zone = "hello world"

    get_guest_attributes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_get_guest_attributes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_guest_attributes_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_guest_attributes({ instance: instance, project: project, query_path: query_path, variable_key: variable_key, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_guest_attributes instance: instance, project: project, query_path: query_path, variable_key: variable_key, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_guest_attributes ::Google::Cloud::Compute::V1::GetGuestAttributesInstanceRequest.new(instance: instance, project: project, query_path: query_path, variable_key: variable_key, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_guest_attributes({ instance: instance, project: project, query_path: query_path, variable_key: variable_key, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_guest_attributes(::Google::Cloud::Compute::V1::GetGuestAttributesInstanceRequest.new(instance: instance, project: project, query_path: query_path, variable_key: variable_key, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_guest_attributes_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    options_requested_policy_version = 42
    project = "hello world"
    resource = "hello world"
    zone = "hello world"

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Cloud::Compute::V1::GetIamPolicyInstanceRequest.new(options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Cloud::Compute::V1::GetIamPolicyInstanceRequest.new(options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_screenshot
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Screenshot.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    zone = "hello world"

    get_screenshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_get_screenshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_screenshot_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_screenshot({ instance: instance, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_screenshot instance: instance, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_screenshot ::Google::Cloud::Compute::V1::GetScreenshotInstanceRequest.new(instance: instance, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_screenshot({ instance: instance, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_screenshot(::Google::Cloud::Compute::V1::GetScreenshotInstanceRequest.new(instance: instance, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_screenshot_client_stub.call_count
      end
    end
  end

  def test_get_serial_port_output
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::SerialPortOutput.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    port = 42
    project = "hello world"
    start = 42
    zone = "hello world"

    get_serial_port_output_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_get_serial_port_output_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_serial_port_output_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_serial_port_output({ instance: instance, port: port, project: project, start: start, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_serial_port_output instance: instance, port: port, project: project, start: start, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_serial_port_output ::Google::Cloud::Compute::V1::GetSerialPortOutputInstanceRequest.new(instance: instance, port: port, project: project, start: start, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_serial_port_output({ instance: instance, port: port, project: project, start: start, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_serial_port_output(::Google::Cloud::Compute::V1::GetSerialPortOutputInstanceRequest.new(instance: instance, port: port, project: project, start: start, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_serial_port_output_client_stub.call_count
      end
    end
  end

  def test_get_shielded_instance_identity
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::ShieldedInstanceIdentity.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    zone = "hello world"

    get_shielded_instance_identity_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_get_shielded_instance_identity_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_shielded_instance_identity_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_shielded_instance_identity({ instance: instance, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_shielded_instance_identity instance: instance, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_shielded_instance_identity ::Google::Cloud::Compute::V1::GetShieldedInstanceIdentityInstanceRequest.new(instance: instance, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_shielded_instance_identity({ instance: instance, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_shielded_instance_identity(::Google::Cloud::Compute::V1::GetShieldedInstanceIdentityInstanceRequest.new(instance: instance, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_shielded_instance_identity_client_stub.call_count
      end
    end
  end

  def test_insert
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_resource = {}
    project = "hello world"
    request_id = "hello world"
    source_instance_template = "hello world"
    source_machine_image = "hello world"
    zone = "hello world"

    insert_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_insert_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, insert_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.insert({ instance_resource: instance_resource, project: project, request_id: request_id, source_instance_template: source_instance_template, source_machine_image: source_machine_image, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.insert instance_resource: instance_resource, project: project, request_id: request_id, source_instance_template: source_instance_template, source_machine_image: source_machine_image, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.insert ::Google::Cloud::Compute::V1::InsertInstanceRequest.new(instance_resource: instance_resource, project: project, request_id: request_id, source_instance_template: source_instance_template, source_machine_image: source_machine_image, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.insert({ instance_resource: instance_resource, project: project, request_id: request_id, source_instance_template: source_instance_template, source_machine_image: source_machine_image, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.insert(::Google::Cloud::Compute::V1::InsertInstanceRequest.new(instance_resource: instance_resource, project: project, request_id: request_id, source_instance_template: source_instance_template, source_machine_image: source_machine_image, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, insert_client_stub.call_count
      end
    end
  end

  def test_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    zone = "hello world"

    list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list ::Google::Cloud::Compute::V1::ListInstancesRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list(::Google::Cloud::Compute::V1::ListInstancesRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_client_stub.call_count
      end
    end
  end

  def test_list_referrers
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceListReferrers.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    instance = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    zone = "hello world"

    list_referrers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_list_referrers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_referrers_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_referrers({ filter: filter, instance: instance, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_referrers filter: filter, instance: instance, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_referrers ::Google::Cloud::Compute::V1::ListReferrersInstancesRequest.new(filter: filter, instance: instance, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_referrers({ filter: filter, instance: instance, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_referrers(::Google::Cloud::Compute::V1::ListReferrersInstancesRequest.new(filter: filter, instance: instance, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_referrers_client_stub.call_count
      end
    end
  end

  def test_perform_maintenance
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    perform_maintenance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_perform_maintenance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, perform_maintenance_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.perform_maintenance({ instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.perform_maintenance instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.perform_maintenance ::Google::Cloud::Compute::V1::PerformMaintenanceInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.perform_maintenance({ instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.perform_maintenance(::Google::Cloud::Compute::V1::PerformMaintenanceInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, perform_maintenance_client_stub.call_count
      end
    end
  end

  def test_remove_resource_policies
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_remove_resource_policies_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    remove_resource_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_remove_resource_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_resource_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_resource_policies({ instance: instance, instances_remove_resource_policies_request_resource: instances_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_resource_policies instance: instance, instances_remove_resource_policies_request_resource: instances_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_resource_policies ::Google::Cloud::Compute::V1::RemoveResourcePoliciesInstanceRequest.new(instance: instance, instances_remove_resource_policies_request_resource: instances_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_resource_policies({ instance: instance, instances_remove_resource_policies_request_resource: instances_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_resource_policies(::Google::Cloud::Compute::V1::RemoveResourcePoliciesInstanceRequest.new(instance: instance, instances_remove_resource_policies_request_resource: instances_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_resource_policies_client_stub.call_count
      end
    end
  end

  def test_report_host_as_faulty
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_report_host_as_faulty_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    report_host_as_faulty_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_report_host_as_faulty_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, report_host_as_faulty_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.report_host_as_faulty({ instance: instance, instances_report_host_as_faulty_request_resource: instances_report_host_as_faulty_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.report_host_as_faulty instance: instance, instances_report_host_as_faulty_request_resource: instances_report_host_as_faulty_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.report_host_as_faulty ::Google::Cloud::Compute::V1::ReportHostAsFaultyInstanceRequest.new(instance: instance, instances_report_host_as_faulty_request_resource: instances_report_host_as_faulty_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.report_host_as_faulty({ instance: instance, instances_report_host_as_faulty_request_resource: instances_report_host_as_faulty_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.report_host_as_faulty(::Google::Cloud::Compute::V1::ReportHostAsFaultyInstanceRequest.new(instance: instance, instances_report_host_as_faulty_request_resource: instances_report_host_as_faulty_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, report_host_as_faulty_client_stub.call_count
      end
    end
  end

  def test_reset
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    reset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_reset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reset_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reset({ instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reset instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reset ::Google::Cloud::Compute::V1::ResetInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reset({ instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reset(::Google::Cloud::Compute::V1::ResetInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reset_client_stub.call_count
      end
    end
  end

  def test_resume
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    resume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_resume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resume_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resume({ instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resume instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resume ::Google::Cloud::Compute::V1::ResumeInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resume({ instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resume(::Google::Cloud::Compute::V1::ResumeInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resume_client_stub.call_count
      end
    end
  end

  def test_send_diagnostic_interrupt
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    zone = "hello world"

    send_diagnostic_interrupt_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_send_diagnostic_interrupt_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, send_diagnostic_interrupt_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.send_diagnostic_interrupt({ instance: instance, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.send_diagnostic_interrupt instance: instance, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.send_diagnostic_interrupt ::Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceRequest.new(instance: instance, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.send_diagnostic_interrupt({ instance: instance, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.send_diagnostic_interrupt(::Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceRequest.new(instance: instance, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, send_diagnostic_interrupt_client_stub.call_count
      end
    end
  end

  def test_set_deletion_protection
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    deletion_protection = true
    project = "hello world"
    request_id = "hello world"
    resource = "hello world"
    zone = "hello world"

    set_deletion_protection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_deletion_protection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_deletion_protection_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_deletion_protection({ deletion_protection: deletion_protection, project: project, request_id: request_id, resource: resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_deletion_protection deletion_protection: deletion_protection, project: project, request_id: request_id, resource: resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_deletion_protection ::Google::Cloud::Compute::V1::SetDeletionProtectionInstanceRequest.new(deletion_protection: deletion_protection, project: project, request_id: request_id, resource: resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_deletion_protection({ deletion_protection: deletion_protection, project: project, request_id: request_id, resource: resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_deletion_protection(::Google::Cloud::Compute::V1::SetDeletionProtectionInstanceRequest.new(deletion_protection: deletion_protection, project: project, request_id: request_id, resource: resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_deletion_protection_client_stub.call_count
      end
    end
  end

  def test_set_disk_auto_delete
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    auto_delete = true
    device_name = "hello world"
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_disk_auto_delete_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_disk_auto_delete_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_disk_auto_delete_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_disk_auto_delete({ auto_delete: auto_delete, device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_disk_auto_delete auto_delete: auto_delete, device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_disk_auto_delete ::Google::Cloud::Compute::V1::SetDiskAutoDeleteInstanceRequest.new(auto_delete: auto_delete, device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_disk_auto_delete({ auto_delete: auto_delete, device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_disk_auto_delete(::Google::Cloud::Compute::V1::SetDiskAutoDeleteInstanceRequest.new(auto_delete: auto_delete, device_name: device_name, instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_disk_auto_delete_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    resource = "hello world"
    zone = "hello world"
    zone_set_policy_request_resource = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Cloud::Compute::V1::SetIamPolicyInstanceRequest.new(project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Cloud::Compute::V1::SetIamPolicyInstanceRequest.new(project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_set_labels
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_set_labels_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_labels_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_labels({ instance: instance, instances_set_labels_request_resource: instances_set_labels_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_labels instance: instance, instances_set_labels_request_resource: instances_set_labels_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_labels ::Google::Cloud::Compute::V1::SetLabelsInstanceRequest.new(instance: instance, instances_set_labels_request_resource: instances_set_labels_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_labels({ instance: instance, instances_set_labels_request_resource: instances_set_labels_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_labels(::Google::Cloud::Compute::V1::SetLabelsInstanceRequest.new(instance: instance, instances_set_labels_request_resource: instances_set_labels_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_labels_client_stub.call_count
      end
    end
  end

  def test_set_machine_resources
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_set_machine_resources_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_machine_resources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_machine_resources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_machine_resources_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_machine_resources({ instance: instance, instances_set_machine_resources_request_resource: instances_set_machine_resources_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_machine_resources instance: instance, instances_set_machine_resources_request_resource: instances_set_machine_resources_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_machine_resources ::Google::Cloud::Compute::V1::SetMachineResourcesInstanceRequest.new(instance: instance, instances_set_machine_resources_request_resource: instances_set_machine_resources_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_machine_resources({ instance: instance, instances_set_machine_resources_request_resource: instances_set_machine_resources_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_machine_resources(::Google::Cloud::Compute::V1::SetMachineResourcesInstanceRequest.new(instance: instance, instances_set_machine_resources_request_resource: instances_set_machine_resources_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_machine_resources_client_stub.call_count
      end
    end
  end

  def test_set_machine_type
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_set_machine_type_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_machine_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_machine_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_machine_type_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_machine_type({ instance: instance, instances_set_machine_type_request_resource: instances_set_machine_type_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_machine_type instance: instance, instances_set_machine_type_request_resource: instances_set_machine_type_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_machine_type ::Google::Cloud::Compute::V1::SetMachineTypeInstanceRequest.new(instance: instance, instances_set_machine_type_request_resource: instances_set_machine_type_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_machine_type({ instance: instance, instances_set_machine_type_request_resource: instances_set_machine_type_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_machine_type(::Google::Cloud::Compute::V1::SetMachineTypeInstanceRequest.new(instance: instance, instances_set_machine_type_request_resource: instances_set_machine_type_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_machine_type_client_stub.call_count
      end
    end
  end

  def test_set_metadata
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    metadata_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_metadata_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_metadata_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_metadata_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_metadata({ instance: instance, metadata_resource: metadata_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_metadata instance: instance, metadata_resource: metadata_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_metadata ::Google::Cloud::Compute::V1::SetMetadataInstanceRequest.new(instance: instance, metadata_resource: metadata_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_metadata({ instance: instance, metadata_resource: metadata_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_metadata(::Google::Cloud::Compute::V1::SetMetadataInstanceRequest.new(instance: instance, metadata_resource: metadata_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_metadata_client_stub.call_count
      end
    end
  end

  def test_set_min_cpu_platform
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_set_min_cpu_platform_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_min_cpu_platform_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_min_cpu_platform_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_min_cpu_platform_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_min_cpu_platform({ instance: instance, instances_set_min_cpu_platform_request_resource: instances_set_min_cpu_platform_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_min_cpu_platform instance: instance, instances_set_min_cpu_platform_request_resource: instances_set_min_cpu_platform_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_min_cpu_platform ::Google::Cloud::Compute::V1::SetMinCpuPlatformInstanceRequest.new(instance: instance, instances_set_min_cpu_platform_request_resource: instances_set_min_cpu_platform_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_min_cpu_platform({ instance: instance, instances_set_min_cpu_platform_request_resource: instances_set_min_cpu_platform_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_min_cpu_platform(::Google::Cloud::Compute::V1::SetMinCpuPlatformInstanceRequest.new(instance: instance, instances_set_min_cpu_platform_request_resource: instances_set_min_cpu_platform_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_min_cpu_platform_client_stub.call_count
      end
    end
  end

  def test_set_name
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_set_name_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_name_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_name_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_name_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_name({ instance: instance, instances_set_name_request_resource: instances_set_name_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_name instance: instance, instances_set_name_request_resource: instances_set_name_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_name ::Google::Cloud::Compute::V1::SetNameInstanceRequest.new(instance: instance, instances_set_name_request_resource: instances_set_name_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_name({ instance: instance, instances_set_name_request_resource: instances_set_name_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_name(::Google::Cloud::Compute::V1::SetNameInstanceRequest.new(instance: instance, instances_set_name_request_resource: instances_set_name_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_name_client_stub.call_count
      end
    end
  end

  def test_set_scheduling
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    scheduling_resource = {}
    zone = "hello world"

    set_scheduling_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_scheduling_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_scheduling_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_scheduling({ instance: instance, project: project, request_id: request_id, scheduling_resource: scheduling_resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_scheduling instance: instance, project: project, request_id: request_id, scheduling_resource: scheduling_resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_scheduling ::Google::Cloud::Compute::V1::SetSchedulingInstanceRequest.new(instance: instance, project: project, request_id: request_id, scheduling_resource: scheduling_resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_scheduling({ instance: instance, project: project, request_id: request_id, scheduling_resource: scheduling_resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_scheduling(::Google::Cloud::Compute::V1::SetSchedulingInstanceRequest.new(instance: instance, project: project, request_id: request_id, scheduling_resource: scheduling_resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_scheduling_client_stub.call_count
      end
    end
  end

  def test_set_security_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_set_security_policy_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_security_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_security_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_security_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_security_policy({ instance: instance, instances_set_security_policy_request_resource: instances_set_security_policy_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_security_policy instance: instance, instances_set_security_policy_request_resource: instances_set_security_policy_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_security_policy ::Google::Cloud::Compute::V1::SetSecurityPolicyInstanceRequest.new(instance: instance, instances_set_security_policy_request_resource: instances_set_security_policy_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_security_policy({ instance: instance, instances_set_security_policy_request_resource: instances_set_security_policy_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_security_policy(::Google::Cloud::Compute::V1::SetSecurityPolicyInstanceRequest.new(instance: instance, instances_set_security_policy_request_resource: instances_set_security_policy_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_security_policy_client_stub.call_count
      end
    end
  end

  def test_set_service_account
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_set_service_account_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_service_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_service_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_service_account_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_service_account({ instance: instance, instances_set_service_account_request_resource: instances_set_service_account_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_service_account instance: instance, instances_set_service_account_request_resource: instances_set_service_account_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_service_account ::Google::Cloud::Compute::V1::SetServiceAccountInstanceRequest.new(instance: instance, instances_set_service_account_request_resource: instances_set_service_account_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_service_account({ instance: instance, instances_set_service_account_request_resource: instances_set_service_account_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_service_account(::Google::Cloud::Compute::V1::SetServiceAccountInstanceRequest.new(instance: instance, instances_set_service_account_request_resource: instances_set_service_account_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_service_account_client_stub.call_count
      end
    end
  end

  def test_set_shielded_instance_integrity_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    shielded_instance_integrity_policy_resource = {}
    zone = "hello world"

    set_shielded_instance_integrity_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_shielded_instance_integrity_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_shielded_instance_integrity_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_shielded_instance_integrity_policy({ instance: instance, project: project, request_id: request_id, shielded_instance_integrity_policy_resource: shielded_instance_integrity_policy_resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_shielded_instance_integrity_policy instance: instance, project: project, request_id: request_id, shielded_instance_integrity_policy_resource: shielded_instance_integrity_policy_resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_shielded_instance_integrity_policy ::Google::Cloud::Compute::V1::SetShieldedInstanceIntegrityPolicyInstanceRequest.new(instance: instance, project: project, request_id: request_id, shielded_instance_integrity_policy_resource: shielded_instance_integrity_policy_resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_shielded_instance_integrity_policy({ instance: instance, project: project, request_id: request_id, shielded_instance_integrity_policy_resource: shielded_instance_integrity_policy_resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_shielded_instance_integrity_policy(::Google::Cloud::Compute::V1::SetShieldedInstanceIntegrityPolicyInstanceRequest.new(instance: instance, project: project, request_id: request_id, shielded_instance_integrity_policy_resource: shielded_instance_integrity_policy_resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_shielded_instance_integrity_policy_client_stub.call_count
      end
    end
  end

  def test_set_tags
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    tags_resource = {}
    zone = "hello world"

    set_tags_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_set_tags_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_tags_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_tags({ instance: instance, project: project, request_id: request_id, tags_resource: tags_resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_tags instance: instance, project: project, request_id: request_id, tags_resource: tags_resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_tags ::Google::Cloud::Compute::V1::SetTagsInstanceRequest.new(instance: instance, project: project, request_id: request_id, tags_resource: tags_resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_tags({ instance: instance, project: project, request_id: request_id, tags_resource: tags_resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_tags(::Google::Cloud::Compute::V1::SetTagsInstanceRequest.new(instance: instance, project: project, request_id: request_id, tags_resource: tags_resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_tags_client_stub.call_count
      end
    end
  end

  def test_simulate_maintenance_event
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    with_extended_notifications = true
    zone = "hello world"

    simulate_maintenance_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_simulate_maintenance_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, simulate_maintenance_event_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.simulate_maintenance_event({ instance: instance, project: project, request_id: request_id, with_extended_notifications: with_extended_notifications, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.simulate_maintenance_event instance: instance, project: project, request_id: request_id, with_extended_notifications: with_extended_notifications, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.simulate_maintenance_event ::Google::Cloud::Compute::V1::SimulateMaintenanceEventInstanceRequest.new(instance: instance, project: project, request_id: request_id, with_extended_notifications: with_extended_notifications, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.simulate_maintenance_event({ instance: instance, project: project, request_id: request_id, with_extended_notifications: with_extended_notifications, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.simulate_maintenance_event(::Google::Cloud::Compute::V1::SimulateMaintenanceEventInstanceRequest.new(instance: instance, project: project, request_id: request_id, with_extended_notifications: with_extended_notifications, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, simulate_maintenance_event_client_stub.call_count
      end
    end
  end

  def test_start
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    start_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_start_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start({ instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start ::Google::Cloud::Compute::V1::StartInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start({ instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start(::Google::Cloud::Compute::V1::StartInstanceRequest.new(instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_client_stub.call_count
      end
    end
  end

  def test_start_with_encryption_key
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instances_start_with_encryption_key_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    start_with_encryption_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_start_with_encryption_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_with_encryption_key_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_with_encryption_key({ instance: instance, instances_start_with_encryption_key_request_resource: instances_start_with_encryption_key_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_with_encryption_key instance: instance, instances_start_with_encryption_key_request_resource: instances_start_with_encryption_key_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_with_encryption_key ::Google::Cloud::Compute::V1::StartWithEncryptionKeyInstanceRequest.new(instance: instance, instances_start_with_encryption_key_request_resource: instances_start_with_encryption_key_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_with_encryption_key({ instance: instance, instances_start_with_encryption_key_request_resource: instances_start_with_encryption_key_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_with_encryption_key(::Google::Cloud::Compute::V1::StartWithEncryptionKeyInstanceRequest.new(instance: instance, instances_start_with_encryption_key_request_resource: instances_start_with_encryption_key_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_with_encryption_key_client_stub.call_count
      end
    end
  end

  def test_stop
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    discard_local_ssd = true
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    stop_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_stop_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop({ discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop ::Google::Cloud::Compute::V1::StopInstanceRequest.new(discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop({ discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop(::Google::Cloud::Compute::V1::StopInstanceRequest.new(discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_client_stub.call_count
      end
    end
  end

  def test_suspend
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    discard_local_ssd = true
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    suspend_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_suspend_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suspend_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suspend({ discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suspend discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suspend ::Google::Cloud::Compute::V1::SuspendInstanceRequest.new(discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suspend({ discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suspend(::Google::Cloud::Compute::V1::SuspendInstanceRequest.new(discard_local_ssd: discard_local_ssd, instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suspend_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::TestPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    resource = "hello world"
    test_permissions_request_resource = {}
    zone = "hello world"

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Cloud::Compute::V1::TestIamPermissionsInstanceRequest.new(project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Cloud::Compute::V1::TestIamPermissionsInstanceRequest.new(project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_update
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    instance_resource = {}
    minimal_action = "hello world"
    most_disruptive_allowed_action = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    update_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_update_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update({ instance: instance, instance_resource: instance_resource, minimal_action: minimal_action, most_disruptive_allowed_action: most_disruptive_allowed_action, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update instance: instance, instance_resource: instance_resource, minimal_action: minimal_action, most_disruptive_allowed_action: most_disruptive_allowed_action, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update ::Google::Cloud::Compute::V1::UpdateInstanceRequest.new(instance: instance, instance_resource: instance_resource, minimal_action: minimal_action, most_disruptive_allowed_action: most_disruptive_allowed_action, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update({ instance: instance, instance_resource: instance_resource, minimal_action: minimal_action, most_disruptive_allowed_action: most_disruptive_allowed_action, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update(::Google::Cloud::Compute::V1::UpdateInstanceRequest.new(instance: instance, instance_resource: instance_resource, minimal_action: minimal_action, most_disruptive_allowed_action: most_disruptive_allowed_action, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_client_stub.call_count
      end
    end
  end

  def test_update_access_config
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    access_config_resource = {}
    instance = "hello world"
    network_interface = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    update_access_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_update_access_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_access_config_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_access_config({ access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_access_config access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_access_config ::Google::Cloud::Compute::V1::UpdateAccessConfigInstanceRequest.new(access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_access_config({ access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_access_config(::Google::Cloud::Compute::V1::UpdateAccessConfigInstanceRequest.new(access_config_resource: access_config_resource, instance: instance, network_interface: network_interface, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_access_config_client_stub.call_count
      end
    end
  end

  def test_update_display_device
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    display_device_resource = {}
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    update_display_device_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_update_display_device_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_display_device_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_display_device({ display_device_resource: display_device_resource, instance: instance, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_display_device display_device_resource: display_device_resource, instance: instance, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_display_device ::Google::Cloud::Compute::V1::UpdateDisplayDeviceInstanceRequest.new(display_device_resource: display_device_resource, instance: instance, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_display_device({ display_device_resource: display_device_resource, instance: instance, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_display_device(::Google::Cloud::Compute::V1::UpdateDisplayDeviceInstanceRequest.new(display_device_resource: display_device_resource, instance: instance, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_display_device_client_stub.call_count
      end
    end
  end

  def test_update_network_interface
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    network_interface = "hello world"
    network_interface_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    update_network_interface_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_update_network_interface_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_network_interface_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_network_interface({ instance: instance, network_interface: network_interface, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_network_interface instance: instance, network_interface: network_interface, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_network_interface ::Google::Cloud::Compute::V1::UpdateNetworkInterfaceInstanceRequest.new(instance: instance, network_interface: network_interface, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_network_interface({ instance: instance, network_interface: network_interface, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_network_interface(::Google::Cloud::Compute::V1::UpdateNetworkInterfaceInstanceRequest.new(instance: instance, network_interface: network_interface, network_interface_resource: network_interface_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_network_interface_client_stub.call_count
      end
    end
  end

  def test_update_shielded_instance_config
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance = "hello world"
    project = "hello world"
    request_id = "hello world"
    shielded_instance_config_resource = {}
    zone = "hello world"

    update_shielded_instance_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.stub :transcode_update_shielded_instance_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_shielded_instance_config_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_shielded_instance_config({ instance: instance, project: project, request_id: request_id, shielded_instance_config_resource: shielded_instance_config_resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_shielded_instance_config instance: instance, project: project, request_id: request_id, shielded_instance_config_resource: shielded_instance_config_resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_shielded_instance_config ::Google::Cloud::Compute::V1::UpdateShieldedInstanceConfigInstanceRequest.new(instance: instance, project: project, request_id: request_id, shielded_instance_config_resource: shielded_instance_config_resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_shielded_instance_config({ instance: instance, project: project, request_id: request_id, shielded_instance_config_resource: shielded_instance_config_resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_shielded_instance_config(::Google::Cloud::Compute::V1::UpdateShieldedInstanceConfigInstanceRequest.new(instance: instance, project: project, request_id: request_id, shielded_instance_config_resource: shielded_instance_config_resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_shielded_instance_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Compute::V1::Instances::Rest::Client::Configuration, config
  end
end
