# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/compute/v1/compute_pb"
require "google/cloud/compute/v1/instance_group_managers/rest"


class ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_abandon_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_abandon_instances_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    abandon_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_abandon_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, abandon_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.abandon_instances({ instance_group_manager: instance_group_manager, instance_group_managers_abandon_instances_request_resource: instance_group_managers_abandon_instances_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.abandon_instances instance_group_manager: instance_group_manager, instance_group_managers_abandon_instances_request_resource: instance_group_managers_abandon_instances_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.abandon_instances ::Google::Cloud::Compute::V1::AbandonInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_abandon_instances_request_resource: instance_group_managers_abandon_instances_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.abandon_instances({ instance_group_manager: instance_group_manager, instance_group_managers_abandon_instances_request_resource: instance_group_managers_abandon_instances_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.abandon_instances(::Google::Cloud::Compute::V1::AbandonInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_abandon_instances_request_resource: instance_group_managers_abandon_instances_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, abandon_instances_client_stub.call_count
      end
    end
  end

  def test_aggregated_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceGroupManagerAggregatedList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    include_all_scopes = true
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    service_project_number = 42

    aggregated_list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_aggregated_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, aggregated_list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.aggregated_list({ filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.aggregated_list filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.aggregated_list ::Google::Cloud::Compute::V1::AggregatedListInstanceGroupManagersRequest.new(filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.aggregated_list({ filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.aggregated_list(::Google::Cloud::Compute::V1::AggregatedListInstanceGroupManagersRequest.new(filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, aggregated_list_client_stub.call_count
      end
    end
  end

  def test_apply_updates_to_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_apply_updates_request_resource = {}
    project = "hello world"
    zone = "hello world"

    apply_updates_to_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_apply_updates_to_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, apply_updates_to_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.apply_updates_to_instances({ instance_group_manager: instance_group_manager, instance_group_managers_apply_updates_request_resource: instance_group_managers_apply_updates_request_resource, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.apply_updates_to_instances instance_group_manager: instance_group_manager, instance_group_managers_apply_updates_request_resource: instance_group_managers_apply_updates_request_resource, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.apply_updates_to_instances ::Google::Cloud::Compute::V1::ApplyUpdatesToInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_apply_updates_request_resource: instance_group_managers_apply_updates_request_resource, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.apply_updates_to_instances({ instance_group_manager: instance_group_manager, instance_group_managers_apply_updates_request_resource: instance_group_managers_apply_updates_request_resource, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.apply_updates_to_instances(::Google::Cloud::Compute::V1::ApplyUpdatesToInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_apply_updates_request_resource: instance_group_managers_apply_updates_request_resource, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, apply_updates_to_instances_client_stub.call_count
      end
    end
  end

  def test_create_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_create_instances_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    create_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_create_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_instances({ instance_group_manager: instance_group_manager, instance_group_managers_create_instances_request_resource: instance_group_managers_create_instances_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_instances instance_group_manager: instance_group_manager, instance_group_managers_create_instances_request_resource: instance_group_managers_create_instances_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_instances ::Google::Cloud::Compute::V1::CreateInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_create_instances_request_resource: instance_group_managers_create_instances_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_instances({ instance_group_manager: instance_group_manager, instance_group_managers_create_instances_request_resource: instance_group_managers_create_instances_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_instances(::Google::Cloud::Compute::V1::CreateInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_create_instances_request_resource: instance_group_managers_create_instances_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_instances_client_stub.call_count
      end
    end
  end

  def test_delete
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    delete_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_delete_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete({ instance_group_manager: instance_group_manager, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete instance_group_manager: instance_group_manager, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete ::Google::Cloud::Compute::V1::DeleteInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete({ instance_group_manager: instance_group_manager, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete(::Google::Cloud::Compute::V1::DeleteInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_client_stub.call_count
      end
    end
  end

  def test_delete_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_delete_instances_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    delete_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_delete_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_instances({ instance_group_manager: instance_group_manager, instance_group_managers_delete_instances_request_resource: instance_group_managers_delete_instances_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_instances instance_group_manager: instance_group_manager, instance_group_managers_delete_instances_request_resource: instance_group_managers_delete_instances_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_instances ::Google::Cloud::Compute::V1::DeleteInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_delete_instances_request_resource: instance_group_managers_delete_instances_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_instances({ instance_group_manager: instance_group_manager, instance_group_managers_delete_instances_request_resource: instance_group_managers_delete_instances_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_instances(::Google::Cloud::Compute::V1::DeleteInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_delete_instances_request_resource: instance_group_managers_delete_instances_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_instances_client_stub.call_count
      end
    end
  end

  def test_delete_per_instance_configs
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_delete_per_instance_configs_req_resource = {}
    project = "hello world"
    zone = "hello world"

    delete_per_instance_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_delete_per_instance_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_per_instance_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_per_instance_configs({ instance_group_manager: instance_group_manager, instance_group_managers_delete_per_instance_configs_req_resource: instance_group_managers_delete_per_instance_configs_req_resource, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_per_instance_configs instance_group_manager: instance_group_manager, instance_group_managers_delete_per_instance_configs_req_resource: instance_group_managers_delete_per_instance_configs_req_resource, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_per_instance_configs ::Google::Cloud::Compute::V1::DeletePerInstanceConfigsInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_delete_per_instance_configs_req_resource: instance_group_managers_delete_per_instance_configs_req_resource, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_per_instance_configs({ instance_group_manager: instance_group_manager, instance_group_managers_delete_per_instance_configs_req_resource: instance_group_managers_delete_per_instance_configs_req_resource, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_per_instance_configs(::Google::Cloud::Compute::V1::DeletePerInstanceConfigsInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_delete_per_instance_configs_req_resource: instance_group_managers_delete_per_instance_configs_req_resource, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_per_instance_configs_client_stub.call_count
      end
    end
  end

  def test_get
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceGroupManager.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    project = "hello world"
    zone = "hello world"

    get_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_get_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get({ instance_group_manager: instance_group_manager, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get instance_group_manager: instance_group_manager, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get ::Google::Cloud::Compute::V1::GetInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get({ instance_group_manager: instance_group_manager, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get(::Google::Cloud::Compute::V1::GetInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_client_stub.call_count
      end
    end
  end

  def test_insert
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    insert_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_insert_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, insert_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.insert({ instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.insert instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.insert ::Google::Cloud::Compute::V1::InsertInstanceGroupManagerRequest.new(instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.insert({ instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.insert(::Google::Cloud::Compute::V1::InsertInstanceGroupManagerRequest.new(instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, insert_client_stub.call_count
      end
    end
  end

  def test_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceGroupManagerList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    zone = "hello world"

    list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list ::Google::Cloud::Compute::V1::ListInstanceGroupManagersRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list(::Google::Cloud::Compute::V1::ListInstanceGroupManagersRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_client_stub.call_count
      end
    end
  end

  def test_list_errors
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceGroupManagersListErrorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    instance_group_manager = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    zone = "hello world"

    list_errors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_list_errors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_errors_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_errors({ filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_errors filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_errors ::Google::Cloud::Compute::V1::ListErrorsInstanceGroupManagersRequest.new(filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_errors({ filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_errors(::Google::Cloud::Compute::V1::ListErrorsInstanceGroupManagersRequest.new(filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_errors_client_stub.call_count
      end
    end
  end

  def test_list_managed_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceGroupManagersListManagedInstancesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    instance_group_manager = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    zone = "hello world"

    list_managed_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_list_managed_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_managed_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_managed_instances({ filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_managed_instances filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_managed_instances ::Google::Cloud::Compute::V1::ListManagedInstancesInstanceGroupManagersRequest.new(filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_managed_instances({ filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_managed_instances(::Google::Cloud::Compute::V1::ListManagedInstancesInstanceGroupManagersRequest.new(filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_managed_instances_client_stub.call_count
      end
    end
  end

  def test_list_per_instance_configs
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::InstanceGroupManagersListPerInstanceConfigsResp.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    instance_group_manager = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    zone = "hello world"

    list_per_instance_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_list_per_instance_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_per_instance_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_per_instance_configs({ filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_per_instance_configs filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_per_instance_configs ::Google::Cloud::Compute::V1::ListPerInstanceConfigsInstanceGroupManagersRequest.new(filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_per_instance_configs({ filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_per_instance_configs(::Google::Cloud::Compute::V1::ListPerInstanceConfigsInstanceGroupManagersRequest.new(filter: filter, instance_group_manager: instance_group_manager, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_per_instance_configs_client_stub.call_count
      end
    end
  end

  def test_patch
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_manager_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    patch_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_patch_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, patch_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.patch({ instance_group_manager: instance_group_manager, instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.patch instance_group_manager: instance_group_manager, instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.patch ::Google::Cloud::Compute::V1::PatchInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.patch({ instance_group_manager: instance_group_manager, instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.patch(::Google::Cloud::Compute::V1::PatchInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_manager_resource: instance_group_manager_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, patch_client_stub.call_count
      end
    end
  end

  def test_patch_per_instance_configs
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_patch_per_instance_configs_req_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    patch_per_instance_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_patch_per_instance_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, patch_per_instance_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.patch_per_instance_configs({ instance_group_manager: instance_group_manager, instance_group_managers_patch_per_instance_configs_req_resource: instance_group_managers_patch_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.patch_per_instance_configs instance_group_manager: instance_group_manager, instance_group_managers_patch_per_instance_configs_req_resource: instance_group_managers_patch_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.patch_per_instance_configs ::Google::Cloud::Compute::V1::PatchPerInstanceConfigsInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_patch_per_instance_configs_req_resource: instance_group_managers_patch_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.patch_per_instance_configs({ instance_group_manager: instance_group_manager, instance_group_managers_patch_per_instance_configs_req_resource: instance_group_managers_patch_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.patch_per_instance_configs(::Google::Cloud::Compute::V1::PatchPerInstanceConfigsInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_patch_per_instance_configs_req_resource: instance_group_managers_patch_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, patch_per_instance_configs_client_stub.call_count
      end
    end
  end

  def test_recreate_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_recreate_instances_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    recreate_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_recreate_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, recreate_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.recreate_instances({ instance_group_manager: instance_group_manager, instance_group_managers_recreate_instances_request_resource: instance_group_managers_recreate_instances_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.recreate_instances instance_group_manager: instance_group_manager, instance_group_managers_recreate_instances_request_resource: instance_group_managers_recreate_instances_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.recreate_instances ::Google::Cloud::Compute::V1::RecreateInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_recreate_instances_request_resource: instance_group_managers_recreate_instances_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.recreate_instances({ instance_group_manager: instance_group_manager, instance_group_managers_recreate_instances_request_resource: instance_group_managers_recreate_instances_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.recreate_instances(::Google::Cloud::Compute::V1::RecreateInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_recreate_instances_request_resource: instance_group_managers_recreate_instances_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, recreate_instances_client_stub.call_count
      end
    end
  end

  def test_resize
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    project = "hello world"
    request_id = "hello world"
    size = 42
    zone = "hello world"

    resize_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_resize_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resize_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resize({ instance_group_manager: instance_group_manager, project: project, request_id: request_id, size: size, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resize instance_group_manager: instance_group_manager, project: project, request_id: request_id, size: size, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resize ::Google::Cloud::Compute::V1::ResizeInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, project: project, request_id: request_id, size: size, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resize({ instance_group_manager: instance_group_manager, project: project, request_id: request_id, size: size, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resize(::Google::Cloud::Compute::V1::ResizeInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, project: project, request_id: request_id, size: size, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resize_client_stub.call_count
      end
    end
  end

  def test_resume_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_resume_instances_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    resume_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_resume_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resume_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resume_instances({ instance_group_manager: instance_group_manager, instance_group_managers_resume_instances_request_resource: instance_group_managers_resume_instances_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resume_instances instance_group_manager: instance_group_manager, instance_group_managers_resume_instances_request_resource: instance_group_managers_resume_instances_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resume_instances ::Google::Cloud::Compute::V1::ResumeInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_resume_instances_request_resource: instance_group_managers_resume_instances_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resume_instances({ instance_group_manager: instance_group_manager, instance_group_managers_resume_instances_request_resource: instance_group_managers_resume_instances_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resume_instances(::Google::Cloud::Compute::V1::ResumeInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_resume_instances_request_resource: instance_group_managers_resume_instances_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resume_instances_client_stub.call_count
      end
    end
  end

  def test_set_instance_template
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_set_instance_template_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_instance_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_set_instance_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_instance_template_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_instance_template({ instance_group_manager: instance_group_manager, instance_group_managers_set_instance_template_request_resource: instance_group_managers_set_instance_template_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_instance_template instance_group_manager: instance_group_manager, instance_group_managers_set_instance_template_request_resource: instance_group_managers_set_instance_template_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_instance_template ::Google::Cloud::Compute::V1::SetInstanceTemplateInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_set_instance_template_request_resource: instance_group_managers_set_instance_template_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_instance_template({ instance_group_manager: instance_group_manager, instance_group_managers_set_instance_template_request_resource: instance_group_managers_set_instance_template_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_instance_template(::Google::Cloud::Compute::V1::SetInstanceTemplateInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_set_instance_template_request_resource: instance_group_managers_set_instance_template_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_instance_template_client_stub.call_count
      end
    end
  end

  def test_set_target_pools
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_set_target_pools_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    set_target_pools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_set_target_pools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_target_pools_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_target_pools({ instance_group_manager: instance_group_manager, instance_group_managers_set_target_pools_request_resource: instance_group_managers_set_target_pools_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_target_pools instance_group_manager: instance_group_manager, instance_group_managers_set_target_pools_request_resource: instance_group_managers_set_target_pools_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_target_pools ::Google::Cloud::Compute::V1::SetTargetPoolsInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_set_target_pools_request_resource: instance_group_managers_set_target_pools_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_target_pools({ instance_group_manager: instance_group_manager, instance_group_managers_set_target_pools_request_resource: instance_group_managers_set_target_pools_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_target_pools(::Google::Cloud::Compute::V1::SetTargetPoolsInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_set_target_pools_request_resource: instance_group_managers_set_target_pools_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_target_pools_client_stub.call_count
      end
    end
  end

  def test_start_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_start_instances_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    start_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_start_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_instances({ instance_group_manager: instance_group_manager, instance_group_managers_start_instances_request_resource: instance_group_managers_start_instances_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_instances instance_group_manager: instance_group_manager, instance_group_managers_start_instances_request_resource: instance_group_managers_start_instances_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_instances ::Google::Cloud::Compute::V1::StartInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_start_instances_request_resource: instance_group_managers_start_instances_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_instances({ instance_group_manager: instance_group_manager, instance_group_managers_start_instances_request_resource: instance_group_managers_start_instances_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_instances(::Google::Cloud::Compute::V1::StartInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_start_instances_request_resource: instance_group_managers_start_instances_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_instances_client_stub.call_count
      end
    end
  end

  def test_stop_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_stop_instances_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    stop_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_stop_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_instances({ instance_group_manager: instance_group_manager, instance_group_managers_stop_instances_request_resource: instance_group_managers_stop_instances_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_instances instance_group_manager: instance_group_manager, instance_group_managers_stop_instances_request_resource: instance_group_managers_stop_instances_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_instances ::Google::Cloud::Compute::V1::StopInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_stop_instances_request_resource: instance_group_managers_stop_instances_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_instances({ instance_group_manager: instance_group_manager, instance_group_managers_stop_instances_request_resource: instance_group_managers_stop_instances_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_instances(::Google::Cloud::Compute::V1::StopInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_stop_instances_request_resource: instance_group_managers_stop_instances_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_instances_client_stub.call_count
      end
    end
  end

  def test_suspend_instances
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_suspend_instances_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    suspend_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_suspend_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suspend_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suspend_instances({ instance_group_manager: instance_group_manager, instance_group_managers_suspend_instances_request_resource: instance_group_managers_suspend_instances_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suspend_instances instance_group_manager: instance_group_manager, instance_group_managers_suspend_instances_request_resource: instance_group_managers_suspend_instances_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suspend_instances ::Google::Cloud::Compute::V1::SuspendInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_suspend_instances_request_resource: instance_group_managers_suspend_instances_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suspend_instances({ instance_group_manager: instance_group_manager, instance_group_managers_suspend_instances_request_resource: instance_group_managers_suspend_instances_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suspend_instances(::Google::Cloud::Compute::V1::SuspendInstancesInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_suspend_instances_request_resource: instance_group_managers_suspend_instances_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suspend_instances_client_stub.call_count
      end
    end
  end

  def test_update_per_instance_configs
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    instance_group_manager = "hello world"
    instance_group_managers_update_per_instance_configs_req_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    update_per_instance_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::ServiceStub.stub :transcode_update_per_instance_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_per_instance_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_per_instance_configs({ instance_group_manager: instance_group_manager, instance_group_managers_update_per_instance_configs_req_resource: instance_group_managers_update_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_per_instance_configs instance_group_manager: instance_group_manager, instance_group_managers_update_per_instance_configs_req_resource: instance_group_managers_update_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_per_instance_configs ::Google::Cloud::Compute::V1::UpdatePerInstanceConfigsInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_update_per_instance_configs_req_resource: instance_group_managers_update_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_per_instance_configs({ instance_group_manager: instance_group_manager, instance_group_managers_update_per_instance_configs_req_resource: instance_group_managers_update_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_per_instance_configs(::Google::Cloud::Compute::V1::UpdatePerInstanceConfigsInstanceGroupManagerRequest.new(instance_group_manager: instance_group_manager, instance_group_managers_update_per_instance_configs_req_resource: instance_group_managers_update_per_instance_configs_req_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_per_instance_configs_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Compute::V1::InstanceGroupManagers::Rest::Client::Configuration, config
  end
end
