# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/compute/v1/compute_pb"
require "google/cloud/compute/v1/firewall_policies/rest"


class ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_add_association
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    firewall_policy_association_resource = {}
    replace_existing_association = true
    request_id = "hello world"

    add_association_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_add_association_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_association_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_association({ firewall_policy: firewall_policy, firewall_policy_association_resource: firewall_policy_association_resource, replace_existing_association: replace_existing_association, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_association firewall_policy: firewall_policy, firewall_policy_association_resource: firewall_policy_association_resource, replace_existing_association: replace_existing_association, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_association ::Google::Cloud::Compute::V1::AddAssociationFirewallPolicyRequest.new(firewall_policy: firewall_policy, firewall_policy_association_resource: firewall_policy_association_resource, replace_existing_association: replace_existing_association, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_association({ firewall_policy: firewall_policy, firewall_policy_association_resource: firewall_policy_association_resource, replace_existing_association: replace_existing_association, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_association(::Google::Cloud::Compute::V1::AddAssociationFirewallPolicyRequest.new(firewall_policy: firewall_policy, firewall_policy_association_resource: firewall_policy_association_resource, replace_existing_association: replace_existing_association, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_association_client_stub.call_count
      end
    end
  end

  def test_add_rule
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    firewall_policy_rule_resource = {}
    request_id = "hello world"

    add_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_add_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_rule_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_rule({ firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_rule firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_rule ::Google::Cloud::Compute::V1::AddRuleFirewallPolicyRequest.new(firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_rule({ firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_rule(::Google::Cloud::Compute::V1::AddRuleFirewallPolicyRequest.new(firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_rule_client_stub.call_count
      end
    end
  end

  def test_clone_rules
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    request_id = "hello world"
    source_firewall_policy = "hello world"

    clone_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_clone_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, clone_rules_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.clone_rules({ firewall_policy: firewall_policy, request_id: request_id, source_firewall_policy: source_firewall_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.clone_rules firewall_policy: firewall_policy, request_id: request_id, source_firewall_policy: source_firewall_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.clone_rules ::Google::Cloud::Compute::V1::CloneRulesFirewallPolicyRequest.new(firewall_policy: firewall_policy, request_id: request_id, source_firewall_policy: source_firewall_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.clone_rules({ firewall_policy: firewall_policy, request_id: request_id, source_firewall_policy: source_firewall_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.clone_rules(::Google::Cloud::Compute::V1::CloneRulesFirewallPolicyRequest.new(firewall_policy: firewall_policy, request_id: request_id, source_firewall_policy: source_firewall_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, clone_rules_client_stub.call_count
      end
    end
  end

  def test_delete
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    request_id = "hello world"

    delete_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_delete_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete({ firewall_policy: firewall_policy, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete firewall_policy: firewall_policy, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete ::Google::Cloud::Compute::V1::DeleteFirewallPolicyRequest.new(firewall_policy: firewall_policy, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete({ firewall_policy: firewall_policy, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete(::Google::Cloud::Compute::V1::DeleteFirewallPolicyRequest.new(firewall_policy: firewall_policy, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_client_stub.call_count
      end
    end
  end

  def test_get
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::FirewallPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"

    get_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_get_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get({ firewall_policy: firewall_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get firewall_policy: firewall_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get ::Google::Cloud::Compute::V1::GetFirewallPolicyRequest.new(firewall_policy: firewall_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get({ firewall_policy: firewall_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get(::Google::Cloud::Compute::V1::GetFirewallPolicyRequest.new(firewall_policy: firewall_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_client_stub.call_count
      end
    end
  end

  def test_get_association
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::FirewallPolicyAssociation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    name = "hello world"

    get_association_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_get_association_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_association_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_association({ firewall_policy: firewall_policy, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_association firewall_policy: firewall_policy, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_association ::Google::Cloud::Compute::V1::GetAssociationFirewallPolicyRequest.new(firewall_policy: firewall_policy, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_association({ firewall_policy: firewall_policy, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_association(::Google::Cloud::Compute::V1::GetAssociationFirewallPolicyRequest.new(firewall_policy: firewall_policy, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_association_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    options_requested_policy_version = 42
    resource = "hello world"

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ options_requested_policy_version: options_requested_policy_version, resource: resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy options_requested_policy_version: options_requested_policy_version, resource: resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Cloud::Compute::V1::GetIamPolicyFirewallPolicyRequest.new(options_requested_policy_version: options_requested_policy_version, resource: resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ options_requested_policy_version: options_requested_policy_version, resource: resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Cloud::Compute::V1::GetIamPolicyFirewallPolicyRequest.new(options_requested_policy_version: options_requested_policy_version, resource: resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_rule
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::FirewallPolicyRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    priority = 42

    get_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_get_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rule_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rule({ firewall_policy: firewall_policy, priority: priority }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rule firewall_policy: firewall_policy, priority: priority do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rule ::Google::Cloud::Compute::V1::GetRuleFirewallPolicyRequest.new(firewall_policy: firewall_policy, priority: priority) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rule({ firewall_policy: firewall_policy, priority: priority }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rule(::Google::Cloud::Compute::V1::GetRuleFirewallPolicyRequest.new(firewall_policy: firewall_policy, priority: priority), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rule_client_stub.call_count
      end
    end
  end

  def test_insert
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy_resource = {}
    parent_id = "hello world"
    request_id = "hello world"

    insert_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_insert_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, insert_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.insert({ firewall_policy_resource: firewall_policy_resource, parent_id: parent_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.insert firewall_policy_resource: firewall_policy_resource, parent_id: parent_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.insert ::Google::Cloud::Compute::V1::InsertFirewallPolicyRequest.new(firewall_policy_resource: firewall_policy_resource, parent_id: parent_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.insert({ firewall_policy_resource: firewall_policy_resource, parent_id: parent_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.insert(::Google::Cloud::Compute::V1::InsertFirewallPolicyRequest.new(firewall_policy_resource: firewall_policy_resource, parent_id: parent_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, insert_client_stub.call_count
      end
    end
  end

  def test_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::FirewallPolicyList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    parent_id = "hello world"
    return_partial_success = true

    list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, parent_id: parent_id, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, parent_id: parent_id, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list ::Google::Cloud::Compute::V1::ListFirewallPoliciesRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, parent_id: parent_id, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, parent_id: parent_id, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list(::Google::Cloud::Compute::V1::ListFirewallPoliciesRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, parent_id: parent_id, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_client_stub.call_count
      end
    end
  end

  def test_list_associations
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::FirewallPoliciesListAssociationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    target_resource = "hello world"

    list_associations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_list_associations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_associations_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_associations({ target_resource: target_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_associations target_resource: target_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_associations ::Google::Cloud::Compute::V1::ListAssociationsFirewallPolicyRequest.new(target_resource: target_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_associations({ target_resource: target_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_associations(::Google::Cloud::Compute::V1::ListAssociationsFirewallPolicyRequest.new(target_resource: target_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_associations_client_stub.call_count
      end
    end
  end

  def test_move
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    parent_id = "hello world"
    request_id = "hello world"

    move_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_move_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, move_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.move({ firewall_policy: firewall_policy, parent_id: parent_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.move firewall_policy: firewall_policy, parent_id: parent_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.move ::Google::Cloud::Compute::V1::MoveFirewallPolicyRequest.new(firewall_policy: firewall_policy, parent_id: parent_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.move({ firewall_policy: firewall_policy, parent_id: parent_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.move(::Google::Cloud::Compute::V1::MoveFirewallPolicyRequest.new(firewall_policy: firewall_policy, parent_id: parent_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, move_client_stub.call_count
      end
    end
  end

  def test_patch
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    firewall_policy_resource = {}
    request_id = "hello world"

    patch_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_patch_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, patch_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.patch({ firewall_policy: firewall_policy, firewall_policy_resource: firewall_policy_resource, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.patch firewall_policy: firewall_policy, firewall_policy_resource: firewall_policy_resource, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.patch ::Google::Cloud::Compute::V1::PatchFirewallPolicyRequest.new(firewall_policy: firewall_policy, firewall_policy_resource: firewall_policy_resource, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.patch({ firewall_policy: firewall_policy, firewall_policy_resource: firewall_policy_resource, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.patch(::Google::Cloud::Compute::V1::PatchFirewallPolicyRequest.new(firewall_policy: firewall_policy, firewall_policy_resource: firewall_policy_resource, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, patch_client_stub.call_count
      end
    end
  end

  def test_patch_rule
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    firewall_policy_rule_resource = {}
    priority = 42
    request_id = "hello world"

    patch_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_patch_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, patch_rule_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.patch_rule({ firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, priority: priority, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.patch_rule firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, priority: priority, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.patch_rule ::Google::Cloud::Compute::V1::PatchRuleFirewallPolicyRequest.new(firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, priority: priority, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.patch_rule({ firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, priority: priority, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.patch_rule(::Google::Cloud::Compute::V1::PatchRuleFirewallPolicyRequest.new(firewall_policy: firewall_policy, firewall_policy_rule_resource: firewall_policy_rule_resource, priority: priority, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, patch_rule_client_stub.call_count
      end
    end
  end

  def test_remove_association
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    name = "hello world"
    request_id = "hello world"

    remove_association_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_remove_association_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_association_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_association({ firewall_policy: firewall_policy, name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_association firewall_policy: firewall_policy, name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_association ::Google::Cloud::Compute::V1::RemoveAssociationFirewallPolicyRequest.new(firewall_policy: firewall_policy, name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_association({ firewall_policy: firewall_policy, name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_association(::Google::Cloud::Compute::V1::RemoveAssociationFirewallPolicyRequest.new(firewall_policy: firewall_policy, name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_association_client_stub.call_count
      end
    end
  end

  def test_remove_rule
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    firewall_policy = "hello world"
    priority = 42
    request_id = "hello world"

    remove_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_remove_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_rule_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_rule({ firewall_policy: firewall_policy, priority: priority, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_rule firewall_policy: firewall_policy, priority: priority, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_rule ::Google::Cloud::Compute::V1::RemoveRuleFirewallPolicyRequest.new(firewall_policy: firewall_policy, priority: priority, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_rule({ firewall_policy: firewall_policy, priority: priority, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_rule(::Google::Cloud::Compute::V1::RemoveRuleFirewallPolicyRequest.new(firewall_policy: firewall_policy, priority: priority, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_rule_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    global_organization_set_policy_request_resource = {}
    resource = "hello world"

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ global_organization_set_policy_request_resource: global_organization_set_policy_request_resource, resource: resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy global_organization_set_policy_request_resource: global_organization_set_policy_request_resource, resource: resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Cloud::Compute::V1::SetIamPolicyFirewallPolicyRequest.new(global_organization_set_policy_request_resource: global_organization_set_policy_request_resource, resource: resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ global_organization_set_policy_request_resource: global_organization_set_policy_request_resource, resource: resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Cloud::Compute::V1::SetIamPolicyFirewallPolicyRequest.new(global_organization_set_policy_request_resource: global_organization_set_policy_request_resource, resource: resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::TestPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    test_permissions_request_resource = {}

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, test_permissions_request_resource: test_permissions_request_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, test_permissions_request_resource: test_permissions_request_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Cloud::Compute::V1::TestIamPermissionsFirewallPolicyRequest.new(resource: resource, test_permissions_request_resource: test_permissions_request_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, test_permissions_request_resource: test_permissions_request_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Cloud::Compute::V1::TestIamPermissionsFirewallPolicyRequest.new(resource: resource, test_permissions_request_resource: test_permissions_request_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Compute::V1::FirewallPolicies::Rest::Client::Configuration, config
  end
end
