# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/compute/v1/compute_pb"
require "google/cloud/compute/v1/disks/rest"


class ::Google::Cloud::Compute::V1::Disks::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_add_resource_policies
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    disks_add_resource_policies_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    add_resource_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_add_resource_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_resource_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_resource_policies({ disk: disk, disks_add_resource_policies_request_resource: disks_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_resource_policies disk: disk, disks_add_resource_policies_request_resource: disks_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_resource_policies ::Google::Cloud::Compute::V1::AddResourcePoliciesDiskRequest.new(disk: disk, disks_add_resource_policies_request_resource: disks_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_resource_policies({ disk: disk, disks_add_resource_policies_request_resource: disks_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_resource_policies(::Google::Cloud::Compute::V1::AddResourcePoliciesDiskRequest.new(disk: disk, disks_add_resource_policies_request_resource: disks_add_resource_policies_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_resource_policies_client_stub.call_count
      end
    end
  end

  def test_aggregated_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::DiskAggregatedList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    include_all_scopes = true
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    service_project_number = 42

    aggregated_list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_aggregated_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, aggregated_list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.aggregated_list({ filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.aggregated_list filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.aggregated_list ::Google::Cloud::Compute::V1::AggregatedListDisksRequest.new(filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.aggregated_list({ filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.aggregated_list(::Google::Cloud::Compute::V1::AggregatedListDisksRequest.new(filter: filter, include_all_scopes: include_all_scopes, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, service_project_number: service_project_number), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, aggregated_list_client_stub.call_count
      end
    end
  end

  def test_bulk_insert
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    bulk_insert_disk_resource_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    bulk_insert_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_bulk_insert_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_insert_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_insert({ bulk_insert_disk_resource_resource: bulk_insert_disk_resource_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_insert bulk_insert_disk_resource_resource: bulk_insert_disk_resource_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_insert ::Google::Cloud::Compute::V1::BulkInsertDiskRequest.new(bulk_insert_disk_resource_resource: bulk_insert_disk_resource_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_insert({ bulk_insert_disk_resource_resource: bulk_insert_disk_resource_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_insert(::Google::Cloud::Compute::V1::BulkInsertDiskRequest.new(bulk_insert_disk_resource_resource: bulk_insert_disk_resource_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_insert_client_stub.call_count
      end
    end
  end

  def test_bulk_set_labels
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    bulk_zone_set_labels_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    resource = "hello world"
    zone = "hello world"

    bulk_set_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_bulk_set_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, bulk_set_labels_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.bulk_set_labels({ bulk_zone_set_labels_request_resource: bulk_zone_set_labels_request_resource, project: project, request_id: request_id, resource: resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.bulk_set_labels bulk_zone_set_labels_request_resource: bulk_zone_set_labels_request_resource, project: project, request_id: request_id, resource: resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.bulk_set_labels ::Google::Cloud::Compute::V1::BulkSetLabelsDiskRequest.new(bulk_zone_set_labels_request_resource: bulk_zone_set_labels_request_resource, project: project, request_id: request_id, resource: resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.bulk_set_labels({ bulk_zone_set_labels_request_resource: bulk_zone_set_labels_request_resource, project: project, request_id: request_id, resource: resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.bulk_set_labels(::Google::Cloud::Compute::V1::BulkSetLabelsDiskRequest.new(bulk_zone_set_labels_request_resource: bulk_zone_set_labels_request_resource, project: project, request_id: request_id, resource: resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, bulk_set_labels_client_stub.call_count
      end
    end
  end

  def test_create_snapshot
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    guest_flush = true
    project = "hello world"
    request_id = "hello world"
    snapshot_resource = {}
    zone = "hello world"

    create_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_create_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_snapshot({ disk: disk, guest_flush: guest_flush, project: project, request_id: request_id, snapshot_resource: snapshot_resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_snapshot disk: disk, guest_flush: guest_flush, project: project, request_id: request_id, snapshot_resource: snapshot_resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_snapshot ::Google::Cloud::Compute::V1::CreateSnapshotDiskRequest.new(disk: disk, guest_flush: guest_flush, project: project, request_id: request_id, snapshot_resource: snapshot_resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_snapshot({ disk: disk, guest_flush: guest_flush, project: project, request_id: request_id, snapshot_resource: snapshot_resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_snapshot(::Google::Cloud::Compute::V1::CreateSnapshotDiskRequest.new(disk: disk, guest_flush: guest_flush, project: project, request_id: request_id, snapshot_resource: snapshot_resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_snapshot_client_stub.call_count
      end
    end
  end

  def test_delete
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    delete_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_delete_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete({ disk: disk, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete disk: disk, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete ::Google::Cloud::Compute::V1::DeleteDiskRequest.new(disk: disk, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete({ disk: disk, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete(::Google::Cloud::Compute::V1::DeleteDiskRequest.new(disk: disk, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_client_stub.call_count
      end
    end
  end

  def test_get
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Disk.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    project = "hello world"
    zone = "hello world"

    get_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_get_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get({ disk: disk, project: project, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get disk: disk, project: project, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get ::Google::Cloud::Compute::V1::GetDiskRequest.new(disk: disk, project: project, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get({ disk: disk, project: project, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get(::Google::Cloud::Compute::V1::GetDiskRequest.new(disk: disk, project: project, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    options_requested_policy_version = 42
    project = "hello world"
    resource = "hello world"
    zone = "hello world"

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Cloud::Compute::V1::GetIamPolicyDiskRequest.new(options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Cloud::Compute::V1::GetIamPolicyDiskRequest.new(options_requested_policy_version: options_requested_policy_version, project: project, resource: resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_insert
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk_resource = {}
    project = "hello world"
    request_id = "hello world"
    source_image = "hello world"
    zone = "hello world"

    insert_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_insert_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, insert_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.insert({ disk_resource: disk_resource, project: project, request_id: request_id, source_image: source_image, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.insert disk_resource: disk_resource, project: project, request_id: request_id, source_image: source_image, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.insert ::Google::Cloud::Compute::V1::InsertDiskRequest.new(disk_resource: disk_resource, project: project, request_id: request_id, source_image: source_image, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.insert({ disk_resource: disk_resource, project: project, request_id: request_id, source_image: source_image, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.insert(::Google::Cloud::Compute::V1::InsertDiskRequest.new(disk_resource: disk_resource, project: project, request_id: request_id, source_image: source_image, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, insert_client_stub.call_count
      end
    end
  end

  def test_list
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::DiskList.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = "hello world"
    max_results = 42
    order_by = "hello world"
    page_token = "hello world"
    project = "hello world"
    return_partial_success = true
    zone = "hello world"

    list_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_list_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list ::Google::Cloud::Compute::V1::ListDisksRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list({ filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list(::Google::Cloud::Compute::V1::ListDisksRequest.new(filter: filter, max_results: max_results, order_by: order_by, page_token: page_token, project: project, return_partial_success: return_partial_success, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_client_stub.call_count
      end
    end
  end

  def test_remove_resource_policies
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    disks_remove_resource_policies_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    remove_resource_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_remove_resource_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_resource_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_resource_policies({ disk: disk, disks_remove_resource_policies_request_resource: disks_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_resource_policies disk: disk, disks_remove_resource_policies_request_resource: disks_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_resource_policies ::Google::Cloud::Compute::V1::RemoveResourcePoliciesDiskRequest.new(disk: disk, disks_remove_resource_policies_request_resource: disks_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_resource_policies({ disk: disk, disks_remove_resource_policies_request_resource: disks_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_resource_policies(::Google::Cloud::Compute::V1::RemoveResourcePoliciesDiskRequest.new(disk: disk, disks_remove_resource_policies_request_resource: disks_remove_resource_policies_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_resource_policies_client_stub.call_count
      end
    end
  end

  def test_resize
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    disks_resize_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    resize_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_resize_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resize_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resize({ disk: disk, disks_resize_request_resource: disks_resize_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resize disk: disk, disks_resize_request_resource: disks_resize_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resize ::Google::Cloud::Compute::V1::ResizeDiskRequest.new(disk: disk, disks_resize_request_resource: disks_resize_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resize({ disk: disk, disks_resize_request_resource: disks_resize_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resize(::Google::Cloud::Compute::V1::ResizeDiskRequest.new(disk: disk, disks_resize_request_resource: disks_resize_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resize_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    resource = "hello world"
    zone = "hello world"
    zone_set_policy_request_resource = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Cloud::Compute::V1::SetIamPolicyDiskRequest.new(project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Cloud::Compute::V1::SetIamPolicyDiskRequest.new(project: project, resource: resource, zone: zone, zone_set_policy_request_resource: zone_set_policy_request_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_set_labels
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    request_id = "hello world"
    resource = "hello world"
    zone = "hello world"
    zone_set_labels_request_resource = {}

    set_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_set_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_labels_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_labels({ project: project, request_id: request_id, resource: resource, zone: zone, zone_set_labels_request_resource: zone_set_labels_request_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_labels project: project, request_id: request_id, resource: resource, zone: zone, zone_set_labels_request_resource: zone_set_labels_request_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_labels ::Google::Cloud::Compute::V1::SetLabelsDiskRequest.new(project: project, request_id: request_id, resource: resource, zone: zone, zone_set_labels_request_resource: zone_set_labels_request_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_labels({ project: project, request_id: request_id, resource: resource, zone: zone, zone_set_labels_request_resource: zone_set_labels_request_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_labels(::Google::Cloud::Compute::V1::SetLabelsDiskRequest.new(project: project, request_id: request_id, resource: resource, zone: zone, zone_set_labels_request_resource: zone_set_labels_request_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_labels_client_stub.call_count
      end
    end
  end

  def test_start_async_replication
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    disks_start_async_replication_request_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    start_async_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_start_async_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_async_replication_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_async_replication({ disk: disk, disks_start_async_replication_request_resource: disks_start_async_replication_request_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_async_replication disk: disk, disks_start_async_replication_request_resource: disks_start_async_replication_request_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_async_replication ::Google::Cloud::Compute::V1::StartAsyncReplicationDiskRequest.new(disk: disk, disks_start_async_replication_request_resource: disks_start_async_replication_request_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_async_replication({ disk: disk, disks_start_async_replication_request_resource: disks_start_async_replication_request_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_async_replication(::Google::Cloud::Compute::V1::StartAsyncReplicationDiskRequest.new(disk: disk, disks_start_async_replication_request_resource: disks_start_async_replication_request_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_async_replication_client_stub.call_count
      end
    end
  end

  def test_stop_async_replication
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    stop_async_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_stop_async_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_async_replication_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_async_replication({ disk: disk, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_async_replication disk: disk, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_async_replication ::Google::Cloud::Compute::V1::StopAsyncReplicationDiskRequest.new(disk: disk, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_async_replication({ disk: disk, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_async_replication(::Google::Cloud::Compute::V1::StopAsyncReplicationDiskRequest.new(disk: disk, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_async_replication_client_stub.call_count
      end
    end
  end

  def test_stop_group_async_replication
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disks_stop_group_async_replication_resource_resource = {}
    project = "hello world"
    request_id = "hello world"
    zone = "hello world"

    stop_group_async_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_stop_group_async_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_group_async_replication_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_group_async_replication({ disks_stop_group_async_replication_resource_resource: disks_stop_group_async_replication_resource_resource, project: project, request_id: request_id, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_group_async_replication disks_stop_group_async_replication_resource_resource: disks_stop_group_async_replication_resource_resource, project: project, request_id: request_id, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_group_async_replication ::Google::Cloud::Compute::V1::StopGroupAsyncReplicationDiskRequest.new(disks_stop_group_async_replication_resource_resource: disks_stop_group_async_replication_resource_resource, project: project, request_id: request_id, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_group_async_replication({ disks_stop_group_async_replication_resource_resource: disks_stop_group_async_replication_resource_resource, project: project, request_id: request_id, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_group_async_replication(::Google::Cloud::Compute::V1::StopGroupAsyncReplicationDiskRequest.new(disks_stop_group_async_replication_resource_resource: disks_stop_group_async_replication_resource_resource, project: project, request_id: request_id, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_group_async_replication_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::TestPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project = "hello world"
    resource = "hello world"
    test_permissions_request_resource = {}
    zone = "hello world"

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Cloud::Compute::V1::TestIamPermissionsDiskRequest.new(project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Cloud::Compute::V1::TestIamPermissionsDiskRequest.new(project: project, resource: resource, test_permissions_request_resource: test_permissions_request_resource, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_update
    # Create test objects.
    client_result = ::Google::Cloud::Compute::V1::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    disk = "hello world"
    disk_resource = {}
    paths = "hello world"
    project = "hello world"
    request_id = "hello world"
    update_mask = "hello world"
    zone = "hello world"

    update_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Compute::V1::Disks::Rest::ServiceStub.stub :transcode_update_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_client_stub do
        # Create client
        client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update({ disk: disk, disk_resource: disk_resource, paths: paths, project: project, request_id: request_id, update_mask: update_mask, zone: zone }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update disk: disk, disk_resource: disk_resource, paths: paths, project: project, request_id: request_id, update_mask: update_mask, zone: zone do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update ::Google::Cloud::Compute::V1::UpdateDiskRequest.new(disk: disk, disk_resource: disk_resource, paths: paths, project: project, request_id: request_id, update_mask: update_mask, zone: zone) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update({ disk: disk, disk_resource: disk_resource, paths: paths, project: project, request_id: request_id, update_mask: update_mask, zone: zone }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update(::Google::Cloud::Compute::V1::UpdateDiskRequest.new(disk: disk, disk_resource: disk_resource, paths: paths, project: project, request_id: request_id, update_mask: update_mask, zone: zone), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Compute::V1::Disks::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Compute::V1::Disks::Rest::Client::Configuration, config
  end
end
